package Bencher::Scenario::LogDispatch::Startup;

our $DATE = '2016-02-17'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

#our @modules = grep {!/\ALog::Dispatch::(XXX)\z/} do { require App::lcpan::Call; @{ App::lcpan::Call::call_lcpan_script(argv=>["modules", "--namespace", "Regexp::Common"])->[2] } }; # PRECOMPUTE
our @modules = qw(
    Log::Dispatch::Base
    Log::Dispatch::Dir
    Log::Dispatch::File
    Log::Dispatch::FileWriteRotate
    Log::Dispatch::Null
    Log::Dispatch::Perl
    Log::Dispatch::Screen
    Log::Dispatch::Screen::Color
);

our $scenario = {
    summary => 'Benchmark module startup overhead of some Log::Dispatch modules',

    module_startup => 1,

    participants => [
        map { +{module=>$_} } @modules,
    ],
};

1;
# ABSTRACT: Benchmark module startup overhead of some Log::Dispatch modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::LogDispatch::Startup - Benchmark module startup overhead of some Log::Dispatch modules

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::LogDispatch::Startup (from Perl distribution Bencher-Scenarios-LogDispatch), released on 2016-02-17.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m LogDispatch::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Log::Dispatch::Base> 2.54

L<Log::Dispatch::Dir> 0.14

L<Log::Dispatch::File> 2.54

L<Log::Dispatch::FileWriteRotate> 0.04

L<Log::Dispatch::Null> 2.54

L<Log::Dispatch::Perl> 0.04

L<Log::Dispatch::Screen> 2.54

L<Log::Dispatch::Screen::Color> 0.04

=head1 BENCHMARK PARTICIPANTS

=over

=item * Log::Dispatch::Base (perl_code)

L<Log::Dispatch::Base>



=item * Log::Dispatch::Dir (perl_code)

L<Log::Dispatch::Dir>



=item * Log::Dispatch::File (perl_code)

L<Log::Dispatch::File>



=item * Log::Dispatch::FileWriteRotate (perl_code)

L<Log::Dispatch::FileWriteRotate>



=item * Log::Dispatch::Null (perl_code)

L<Log::Dispatch::Null>



=item * Log::Dispatch::Perl (perl_code)

L<Log::Dispatch::Perl>



=item * Log::Dispatch::Screen (perl_code)

L<Log::Dispatch::Screen>



=item * Log::Dispatch::Screen::Color (perl_code)

L<Log::Dispatch::Screen::Color>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m LogDispatch::Startup >>):

 +--------------------------------+-----------+------------------------+---------+---------+
 | participant                    | time (ms) | mod_overhead_time (ms) | errors  | samples |
 +--------------------------------+-----------+------------------------+---------+---------+
 | Log::Dispatch::FileWriteRotate | 50        | 44.8                   | 0.00014 | 20      |
 | Log::Dispatch::Dir             | 35        | 29.8                   | 0.0001  | 21      |
 | Log::Dispatch::Screen::Color   | 33        | 27.8                   | 0.00016 | 20      |
 | Log::Dispatch::Screen          | 29        | 23.8                   | 0.00013 | 20      |
 | Log::Dispatch::File            | 22        | 16.8                   | 5.8e-05 | 20      |
 | Log::Dispatch::Perl            | 22        | 16.8                   | 7.6e-05 | 21      |
 | Log::Dispatch::Null            | 21.3      | 16.1                   | 2.1e-05 | 20      |
 | Log::Dispatch::Base            | 7.1       | 1.9                    | 2.7e-05 | 20      |
 | perl -e1 (baseline)            | 5.2       | 0                      | 4.2e-05 | 20      |
 +--------------------------------+-----------+------------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-LogDispatch>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-LogDispatch>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-LogDispatch>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
