package Bencher::Scenario::DateModules::Creation;

our $DATE = '2016-04-19'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark date creation',
    participants => [
        {
            name => 'DateTime->new(ymd)',
            fcall_template => 'DateTime->new(year=>2016, month=>4, day=>19)',
        },
        {
            name => 'DateTime->now',
            fcall_template => 'DateTime->now',
        },

        {
            name => 'Time::Moment->new(ymd)',
            fcall_template => 'Time::Moment->new(year=>2016, month=>4, day=>19)',
        },
        {
            name => 'Time::Moment->now',
            fcall_template => 'Time::Moment->now',
        },

        {
            name => 'Time::Local::timelocal',
            fcall_template => 'Time::Local::timelocal(0, 0, 0, 19, 4-1, 2016-1900)',
        },

        {
            name => 'Time::Piece::localtime',
            fcall_template => 'Time::Piece::localtime()',
        },
    ],
    include_result_size => 1,
    datasets => [
    ],
};

1;
# ABSTRACT: Benchmark date creation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DateModules::Creation - Benchmark date creation

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::DateModules::Creation (from Perl distribution Bencher-Scenarios-DateModules), released on 2016-04-19.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DateModules::Creation

To run module startup overhead benchmark:

 % bencher --module-startup -m DateModules::Creation

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<DateTime> 1.20

L<Time::Moment> 0.25

L<Time::Local> 1.2300

L<Time::Piece> 1.29

=head1 BENCHMARK PARTICIPANTS

=over

=item * DateTime->new(ymd) (perl_code)

Function call template:

 DateTime->new(year=>2016, month=>4, day=>19)



=item * DateTime->now (perl_code)

Function call template:

 DateTime->now



=item * Time::Moment->new(ymd) (perl_code)

Function call template:

 Time::Moment->new(year=>2016, month=>4, day=>19)



=item * Time::Moment->now (perl_code)

Function call template:

 Time::Moment->now



=item * Time::Local::timelocal (perl_code)

Function call template:

 Time::Local::timelocal(0, 0, 0, 19, 4-1, 2016-1900)



=item * Time::Piece::localtime (perl_code)

Function call template:

 Time::Piece::localtime()



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DateModules::Creation >>):

 +------------------------+-----------+-----------+------------+------------------+---------+---------+
 | participant            | rate (/s) | time (μs) | vs_slowest | result_size (kB) | errors  | samples |
 +------------------------+-----------+-----------+------------+------------------+---------+---------+
 | DateTime->now          | 3.5e+04   | 28        | 1          | 3.8              | 5.5e-08 | 29      |
 | DateTime->new(ymd)     | 3.6e+04   | 28        | 1          | 3.9              | 6.4e-08 | 22      |
 | Time::Local::timelocal | 1.27e+05  | 7.89      | 3.6        | 0.0547           | 3e-09   | 24      |
 | Time::Piece::localtime | 2.5e+05   | 3.9       | 7.2        | 0.44             | 6.7e-09 | 20      |
 | Time::Moment->now      | 8.3e+05   | 1.2       | 24         | 0.088            | 1.6e-09 | 23      |
 | Time::Moment->new(ymd) | 1.942e+06 | 0.5149    | 55.15      | 0.08789          | 4.7e-11 | 20      |
 +------------------------+-----------+-----------+------------+------------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m DateModules::Creation --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | DateTime            | 51        | 48.5                   | 1          | 0.00016 | 20      |
 | Time::Piece         | 13        | 10.5                   | 4          | 5.6e-05 | 20      |
 | Time::Moment        | 9.6       | 7.1                    | 5.3        | 6.3e-05 | 20      |
 | Time::Local         | 8.9       | 6.4                    | 5.8        | 3.4e-05 | 20      |
 | perl -e1 (baseline) | 2.5       | 0                      | 20         | 3.8e-06 | 20      |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARK NOTES

Time::Moment is the fastest. It also produces a very compact object (second only
to Time::Local, which produces ints). In comparison, DateTime is relatively
crazy big.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DateModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-DateModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DateModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
