package Bencher::Scenario::DamerauLevenshteinModules;

our $DATE = '2016-01-14'; # DATE
our $VERSION = '0.09'; # VERSION

use 5.010001;
use strict;
use utf8;
use warnings;

our $scenario = {
    summary => 'Benchmark various modules calculating the Damerau-Levenshtein edit distance',
    modules => {
    },
    participants => [
        {
            fcall_template => "Text::Levenshtein::Damerau::PP::pp_edistance(<word1>, <word2>)",
        },
        {
            fcall_template => "Text::Levenshtein::Damerau::XS::xs_edistance(<word1>, <word2>)",
        },
    ],
    datasets => [
        { name=>"a",       args => {word1=>"a"      , word2=>"aa"},      result => 1 },
        { name=>"foo",     args => {word1=>"foo"    , word2=>"bar"},     result => 3 },
        { name=>"program", args => {word1=>"program", word2=>"porgram"}, result => 1 },
        { name=>"reve"   , args => {word1=>"reve"   , word2=>"rêves"},   result => 2, tags=>['unicode'], exclude_participant_tags=>['no_unicode_support'] },
        { name=>"euro"   , args => {word1=>"Euro"   , word2=>"€uro"},    result => 1, tags=>['unicode'], exclude_participant_tags=>['no_unicode_support'] },
    ],
    on_result_failure => 'warn',
};

1;
# ABSTRACT: Benchmark various modules calculating the Damerau-Levenshtein edit distance

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DamerauLevenshteinModules - Benchmark various modules calculating the Damerau-Levenshtein edit distance

=head1 VERSION

This document describes version 0.09 of Bencher::Scenario::DamerauLevenshteinModules (from Perl distribution Bencher-Scenario-LevenshteinModules), released on 2016-01-14.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DamerauLevenshteinModules

To run module startup overhead benchmark:

 % bencher --module-startup -m DamerauLevenshteinModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

L<Text::Levenshtein::Damerau::PP> 0.25

L<Text::Levenshtein::Damerau::XS> 3.0

=head1 BENCHMARK PARTICIPANTS

=over

=item * Text::Levenshtein::Damerau::PP::pp_edistance (perl_code)

Function call template:

 Text::Levenshtein::Damerau::PP::pp_edistance(<word1>, <word2>)



=item * Text::Levenshtein::Damerau::XS::xs_edistance (perl_code)

Function call template:

 Text::Levenshtein::Damerau::XS::xs_edistance(<word1>, <word2>)



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+----------------------------------------------+---------+------------+-----------+---------+---------+
 | seq | participant                                  | dataset | rate       | time      | errors  | samples |
 +-----+----------------------------------------------+---------+------------+-----------+---------+---------+
 | 2   | Text::Levenshtein::Damerau::PP::pp_edistance | program | 22739.3    | 43.9768μs | 0       | 20      |
 | 3   | Text::Levenshtein::Damerau::PP::pp_edistance | reve    | 49820      | 20.0723μs | 1.2e-11 | 20      |
 | 4   | Text::Levenshtein::Damerau::PP::pp_edistance | euro    | 5.14e+04   | 19.5μs    | 6.2e-09 | 23      |
 | 1   | Text::Levenshtein::Damerau::PP::pp_edistance | foo     | 94071.1    | 10.6303μs | 0       | 20      |
 | 0   | Text::Levenshtein::Damerau::PP::pp_edistance | a       | 2.8618e+05 | 3.4944μs  | 7.7e-11 | 20      |
 | 7   | Text::Levenshtein::Damerau::XS::xs_edistance | program | 5.82e+05   | 1.72μs    | 8.3e-10 | 20      |
 | 8   | Text::Levenshtein::Damerau::XS::xs_edistance | reve    | 7.651e+05  | 1.307μs   | 4.7e-11 | 22      |
 | 9   | Text::Levenshtein::Damerau::XS::xs_edistance | euro    | 8.18e+05   | 1.22μs    | 1.7e-09 | 20      |
 | 6   | Text::Levenshtein::Damerau::XS::xs_edistance | foo     | 9.4204e+05 | 1.0615μs  | 1.1e-11 | 20      |
 | 5   | Text::Levenshtein::Damerau::XS::xs_edistance | a       | 1.277e+06  | 0.7831μs  | 4.6e-11 | 20      |
 +-----+----------------------------------------------+---------+------------+-----------+---------+---------+


Benchmark module startup overhead:

 +-----+--------------------------------+--------+-------------------+---------+---------+
 | seq | participant                    | time   | mod_overhead_time | errors  | samples |
 +-----+--------------------------------+--------+-------------------+---------+---------+
 | 1   | Text::Levenshtein::Damerau::PP | 4.2ms  | 1.7ms             | 1.8e-05 | 20      |
 | 2   | Text::Levenshtein::Damerau::XS | 3.8ms  | 1.4ms             | 1.8e-05 | 20      |
 | 0   | perl -e1 (baseline)            | 2.45ms | 0ms               | 2.5e-06 | 20      |
 +-----+--------------------------------+--------+-------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 SEE ALSO

L<Bencher::Scenario::LevenshteinModules>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-LevenshteinModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-LevenshteinModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-LevenshteinModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
