package Bencher::Scenario::IntValidation;

our $DATE = '2016-05-24'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Which method of checking for integer is fastest in Perl?',
    participants => [
        {
            name => 'regex',
            code_template  => '<data> =~ /\A-?[0-9]+\z/',
        },
        {
            name=>'SUN::isint',
            fcall_template => 'Scalar::Util::Numeric::isint(<data>)',
        },
        {
            name=>'SUN::PP::isint',
            fcall_template => 'Scalar::Util::Numeric::PP::isint(<data>)',
        },
    ],

    datasets => [
        {
            args => {
                'data@' => [0, 1, -1, "foo"],
            },
        },
    ],
};

1;
# ABSTRACT: Which method of checking for integer is fastest in Perl?

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::IntValidation - Which method of checking for integer is fastest in Perl?

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::IntValidation (from Perl distribution Bencher-Scenario-IntValidation), released on 2016-05-24.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m IntValidation

To run module startup overhead benchmark:

 % bencher --module-startup -m IntValidation

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Scalar::Util::Numeric> 0.40

L<Scalar::Util::Numeric::PP> 0.04

=head1 BENCHMARK PARTICIPANTS

=over

=item * regex (perl_code)

Code template:

 <data> =~ /\A-?[0-9]+\z/



=item * SUN::isint (perl_code)

Function call template:

 Scalar::Util::Numeric::isint(<data>)



=item * SUN::PP::isint (perl_code)

Function call template:

 Scalar::Util::Numeric::PP::isint(<data>)



=back

=head1 BENCHMARK DATASETS

=over

=item * [0,1,-1,"foo"]

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m IntValidation >>):

 +----------------+----------+-----------+-----------+------------+---------+---------+
 | participant    | arg_data | rate (/s) | time (ns) | vs_slowest | errors  | samples |
 +----------------+----------+-----------+-----------+------------+---------+---------+
 | SUN::PP::isint | -1       | 1.2e+06   | 8.1e+02   | 1          | 1.3e-09 | 20      |
 | SUN::PP::isint | 1        | 1.3e+06   | 7.8e+02   | 1          | 1.7e-09 | 20      |
 | SUN::PP::isint | 0        | 1.48e+06  | 676       | 1.2        | 6.3e-10 | 20      |
 | SUN::PP::isint | foo      | 1.7e+06   | 6e+02     | 1.3        | 8.4e-10 | 20      |
 | SUN::isint     | -1       | 4.2e+06   | 2.4e+02   | 3.4        | 2.6e-10 | 26      |
 | regex          | 1        | 5.9e+06   | 1.7e+02   | 4.8        | 2.3e-10 | 26      |
 | regex          | 0        | 6.11e+06  | 164       | 4.95       | 7.9e-11 | 20      |
 | regex          | -1       | 6.23e+06  | 160       | 5.05       | 1.4e-10 | 20      |
 | regex          | foo      | 6.4e+06   | 1.6e+02   | 5.2        | 1.9e-10 | 20      |
 | SUN::isint     | 1        | 9.12e+06  | 110       | 7.39       | 4.5e-11 | 28      |
 | SUN::isint     | foo      | 9.42e+06  | 106       | 7.63       | 4.6e-11 | 20      |
 | SUN::isint     | 0        | 9.9e+06   | 1e+02     | 8          | 1.9e-10 | 26      |
 +----------------+----------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m IntValidation --module-startup >>):

 +---------------------------+-----------+------------------------+------------+---------+---------+
 | participant               | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------------+-----------+------------------------+------------+---------+---------+
 | Scalar::Util::Numeric     | 9.7       | 5.5                    | 1          | 3.7e-05 | 20      |
 | Scalar::Util::Numeric::PP | 7.6       | 3.4                    | 1.3        | 2.5e-05 | 20      |
 | perl -e1 (baseline)       | 4.2       | 0                      | 2.3        | 3.2e-05 | 23      |
 +---------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-IntValidation>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-IntValidation>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-IntValidation>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
