package Bencher::Scenario::Allocations;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark allocations',

    descriptions => <<'_',

This scenario tries to give a picture on how long it takes to allocate arrays
and hashes of various size take.

_
    participants => [
        {name=>'1k-array0'  , summary => 'Allocating empty array 1000 times'      , code_template=>'my $val; for (1..1000) { $val = [] }'},
        {name=>'1k-hash0'   , summary => 'Allocating empty hash 1000 times'       , code_template=>'my $val; for (1..1000) { $val = {} }'},
        {name=>'1k-array1'  , summary => 'Allocating 1-element array 1000 times'  , code_template=>'my $val; for (1..1000) { $val = [1] }'},
        {name=>'1k-hash1'   , summary => 'Allocating 1-key hash 1000 times'       , code_template=>'my $val; for (1..1000) { $val = {a=>1} }'},
        {name=>'1k-array5'  , summary => 'Allocating 5-element array 1000 times'  , code_template=>'my $val; for (1..1000) { $val = [1..5] }'},
        {name=>'1k-hash5'   , summary => 'Allocating 5-key hash 1000 times'       , code_template=>'my $val; for (1..1000) { $val = {a=>1, b=>2, c=>3, d=>4, e=>5} }'},
        {name=>'1k-array10' , summary => 'Allocating 10-element array 1000 times' , code_template=>'my $val; for (1..1000) { $val = [1..10] }'},
        {name=>'1k-hash10'  , summary => 'Allocating 10-key hash 1000 times'      , code_template=>'my $val; for (1..1000) { $val = {1..20} }'},
        {name=>'1k-array100', summary => 'Allocating 100-element array 1000 times', code_template=>'my $val; for (1..1000) { $val = [1..100] }'},
        {name=>'1k-hash100' , summary => 'Allocating 100-key hash 1000 times'     , code_template=>'my $val; for (1..1000) { $val = {1..200} }'},
    ],
};

1;
# ABSTRACT: Benchmark allocations

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Allocations

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::Allocations (from Perl distribution Bencher-Scenario-Allocations), released on 2016-01-05.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Allocations

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * 1k-array0 (perl_code)

Allocating empty array 1000 times.

Code template:

 my $val; for (1..1000) { $val = [] }



=item * 1k-hash0 (perl_code)

Allocating empty hash 1000 times.

Code template:

 my $val; for (1..1000) { $val = {} }



=item * 1k-array1 (perl_code)

Allocating 1-element array 1000 times.

Code template:

 my $val; for (1..1000) { $val = [1] }



=item * 1k-hash1 (perl_code)

Allocating 1-key hash 1000 times.

Code template:

 my $val; for (1..1000) { $val = {a=>1} }



=item * 1k-array5 (perl_code)

Allocating 5-element array 1000 times.

Code template:

 my $val; for (1..1000) { $val = [1..5] }



=item * 1k-hash5 (perl_code)

Allocating 5-key hash 1000 times.

Code template:

 my $val; for (1..1000) { $val = {a=>1, b=>2, c=>3, d=>4, e=>5} }



=item * 1k-array10 (perl_code)

Allocating 10-element array 1000 times.

Code template:

 my $val; for (1..1000) { $val = [1..10] }



=item * 1k-hash10 (perl_code)

Allocating 10-key hash 1000 times.

Code template:

 my $val; for (1..1000) { $val = {1..20} }



=item * 1k-array100 (perl_code)

Allocating 100-element array 1000 times.

Code template:

 my $val; for (1..1000) { $val = [1..100] }



=item * 1k-hash100 (perl_code)

Allocating 100-key hash 1000 times.

Code template:

 my $val; for (1..1000) { $val = {1..200} }



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+---------------------------------------------+----------+----------+---------+---------+
 | seq | name                                        | rate     | time     | errors  | samples |
 +-----+---------------------------------------------+----------+----------+---------+---------+
 | 9   | {dataset=>undef,participant=>"1k-hash100"}  | 102      | 9.77ms   | 1.1e-05 | 20      |
 | 8   | {dataset=>undef,participant=>"1k-array100"} | 470      | 2.13ms   | 1.7e-06 | 21      |
 | 7   | {dataset=>undef,participant=>"1k-hash10"}   | 9.1e+02  | 1.1ms    | 5.8e-06 | 20      |
 | 5   | {dataset=>undef,participant=>"1k-hash5"}    | 1.73e+03 | 0.579ms  | 1.7e-06 | 21      |
 | 6   | {dataset=>undef,participant=>"1k-array10"}  | 2.42e+03 | 0.412ms  | 9.1e-07 | 20      |
 | 4   | {dataset=>undef,participant=>"1k-array5"}   | 3.33e+03 | 0.3ms    | 2.1e-07 | 20      |
 | 3   | {dataset=>undef,participant=>"1k-hash1"}    | 3.72e+03 | 0.269ms  | 2.1e-07 | 20      |
 | 2   | {dataset=>undef,participant=>"1k-array1"}   | 4899     | 0.2041ms | 4.9e-08 | 24      |
 | 1   | {dataset=>undef,participant=>"1k-hash0"}    | 6.79e+03 | 0.147ms  | 1.6e-07 | 21      |
 | 0   | {dataset=>undef,participant=>"1k-array0"}   | 7.4e+03  | 0.135ms  | 5.3e-08 | 20      |
 +-----+---------------------------------------------+----------+----------+---------+---------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-Allocations>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-Allocations>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-Allocations>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
