package Bencher::Scenario::Allocations;

our $DATE = '2015-12-29'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark allocations',

    participants => [
        {name=>'1k-array0'  , code_template=>'my $val; for (1..1000) { $val = [] }'},
        {name=>'1k-hash0'   , code_template=>'my $val; for (1..1000) { $val = {} }'},
        {name=>'1k-array1'  , code_template=>'my $val; for (1..1000) { $val = [1] }'},
        {name=>'1k-hash1'   , code_template=>'my $val; for (1..1000) { $val = {a=>1} }'},
        {name=>'1k-array5'  , code_template=>'my $val; for (1..1000) { $val = [1..5] }'},
        {name=>'1k-hash5'   , code_template=>'my $val; for (1..1000) { $val = {a=>1, b=>2, c=>3, d=>4, e=>5} }'},
        {name=>'1k-array10' , code_template=>'my $val; for (1..1000) { $val = [1..10] }'},
        {name=>'1k-hash10'  , code_template=>'my $val; for (1..1000) { $val = {1..20} }'},
        {name=>'1k-array100', code_template=>'my $val; for (1..1000) { $val = [1..100] }'},
        {name=>'1k-hash100' , code_template=>'my $val; for (1..1000) { $val = {1..200} }'},
    ],
};

1;
# ABSTRACT: Benchmark allocations

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Allocations

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::Allocations (from Perl distribution Bencher-Scenario-Allocations), released on 2015-12-29.

=head1 SYNOPSIS

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-Allocations>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-Allocations>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-Allocations>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
