#
# Makefile.PL for Net-Dict
#
# $Id: Makefile.PL,v 1.2 2003/05/05 23:56:17 neilb Exp $
#

use ExtUtils::MakeMaker;

my $DEFAULT_HOST = 'dict.org';
my $DEFAULT_PORT = 2628;

$test_config_file = 't/test_host.cfg';

print <<EOF;

			Net::Dict

EOF

&configure_testsuite();

&WriteMakefile(
                NAME		=> 'Net::Dict',
                DISTNAME	=> 'Net-Dict',
            VERSION_FROM	=> 'lib/Net/Dict.pm',
                PREREQ_PM	=> {
                                 'IO::Socket'     => 0,
                                 'Net::Cmd'	      => 0,
                                 'Carp'		      => 0,
                                 'AppConfig::Std' => 0,
                                },
		EXE_FILES	=> [qw(dict tkdict)],
		AUTHOR		=> 'Neil Bowers <neil@bowers.com>',
		ABSTRACT_FROM	=> 'lib/Net/Dict.pod',
        META_MERGE => {
            resources => {
                repository => 'https://github.com/neilbowers/Net-Dict',
            },
        },
        LICENSE      => 'perl',

                dist		=> {COMPRESS => 'gzip', SUFFIX => 'gz'},
              );

sub configure_testsuite
{
    my ($host, $port);

print <<EOF;
Testsuite Configuration

The testsuite uses the DICT server at dict.org.
If you're going to run the testsuite, then please confirm
that the hostname and port are correct. If you're going
to skip "make test", then just hit return on the two questions.

EOF

    $host = prompt('what is the hostname for the DICT server?', $DEFAULT_HOST);
    $port = prompt('what is the port for the DICT server?', $DEFAULT_PORT);
    print "\nWriting test config $test_config_file\n\n";

    open(CFGFILE, "> $test_config_file")
	|| die "failed to write $test_config_file: $!\n";

    print CFGFILE <<EOF;
#
# Testsuite configuration
#
# This file is auto-generated by Makefile.PL
#
use vars qw(\$HOST \$PORT);
\$HOST = '$host';
\$PORT = $port;
1;
EOF

    close(CFGFILE);
}

