#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

#include "xxhash.h"

#define MY_TOHEX(h) do {                                    \
    int i = 0;                                              \
    char buffer[2 * sizeof(h)] = {0};                       \
    unsigned shift = 8 * sizeof(h) - 4;                     \
                                                            \
    for (i = 0; i < (2 * sizeof(h)); i += 1) {              \
        buffer[i] = xdigit[ (h >> shift) & 0xf ];           \
            shift -= 4;                                     \
    }                                                       \
                                                            \
    RETVAL = newSVpvn(buffer, sizeof(buffer));              \
} while (0);


MODULE = Digest::xxHash64		PACKAGE = Digest::xxHash64		

UV
xxhash64(const char *input, size_t length(input), UV seed)
    CODE:
        RETVAL = XXH64(input, STRLEN_length_of_input, seed);
    OUTPUT:
        RETVAL

U32
xxhash32(const char *input, size_t length(input), U32 seed)
    CODE:
        RETVAL = XXH32(input, STRLEN_length_of_input, seed);
    OUTPUT:
        RETVAL

SV *
xxhash64_hex(const char *input, size_t length(input), UV seed)
    CODE:
        static const char xdigit[] = "0123456789abcdef";

        unsigned long long h = XXH64(input, STRLEN_length_of_input, seed);

        MY_TOHEX(h);

    OUTPUT:
        RETVAL

SV *
xxhash32_hex(const char *input, size_t length(input), unsigned seed)
    CODE:
        static const char xdigit[] = "0123456789abcdef";

        unsigned h = XXH32(input, STRLEN_length_of_input, seed);

        MY_TOHEX(h);

    OUTPUT:
        RETVAL

