use ExtUtils::MakeMaker;
use Alien::Gfsm;

##----------------------------------------------------------------------
## Configuration
##----------------------------------------------------------------------
my $GFSM_CFLAGS = Alien::Gfsm->cflags;
my $GFSM_LIBS   = Alien::Gfsm->libs;

##-- prereqs
my %prereq = (
	      'ExtUtils::MakeMaker' => 0,
	      'Alien::Gfsm' => 0.001,
	     );

##----------------------------------------------------------------------
## MAIN
##----------------------------------------------------------------------
WriteMakefile
  (
   NAME		=> 'Gfsm',
   #DISTNAME	=> 'gfsm-perl',
   DISTNAME	=> 'Gfsm',
   AUTHOR       => 'Bryan Jurish <moocow@cpan.org>',
   ABSTRACT	=> 'Perl interface to libgfsm finite-state library',
   VERSION_FROM	=> 'Gfsm.pm',
   LICENSE => 'perl',

   ##-- prerequisites
   PREREQ_PM => \%prereq,

   ##-- user variables
   #CC           => 'c++',   ##-- your c++ compiler
   LIBS         => $GFSM_LIBS,            ##-- additional libraries
   DEFINE       => '-DHAVE_CONFIG_H',     ##-- additional defines
   INC          => $GFSM_CFLAGS,          ##-- additional includes
   CCFLAGS      => '',          ##-- additional flags
   OPTIMIZE    => '-O2 -pipe', ##-- optimization flags
   OBJECT       => 'Gfsm.o GfsmPerl.o',

   ##-- install these
   EXE_FILES => [glob("bin/*.perl")],

   ##-- DEBUG
   #MAKEAPERL=>1,
   #LINKTYPE=>'static',
   #MAP_TARGET=>'gfsmperl',
   #CCFLAGS=>'-g',
   ##-- /DEBUG

   ##-- stuff that probably doesn't need to be changed
   #XSOPT        => '-C++',
   TYPEMAPS     => ['perlobject.map', 'typemap'],
  );


#-----------------------------------------------------------------------
# Extensions
#-----------------------------------------------------------------------
##...

sub MY::depend {
  package MY;
  my $inherited = shift->SUPER::depend(@_);
  $inherited .= (
		 "\n\n"
		 ##-- included xs dependencies
		 ."Gfsm.c: "
		 .(''
		   ." Gfsm.xs"
		   ." Constants.xs"
		   ." Semiring.xs"
		   ." Alphabet.xs"
		   ." Automaton.xs"
		   ." Algebra.xs"
		   ." Arith.xs"
		   ." ArcIter.xs"
		   ." Encode.xs"
		   ." Lookup.xs"
		   ." Paths.xs"
		   ." Trie.xs"
		   ." Indexed.xs"
		   ." StateSort.xs"
		  )
		 ."\n\n"
		 ##-- c->o dependencies
		 ."Gfsm.o: Gfsm.c GfsmPerl.h\n"
		 ."\n"
		 ."GfsmPerl.o: GfsmPerl.h GfsmPerl.c\n"
		 ."\n"
		 ## -- more here
		 ."\n"
		);
  $inherited;
}

