
package MyElements::AddUsersToGroup;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://tempuri2.org/' }

__PACKAGE__->__set_name('AddUsersToGroup');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %groupName_of :ATTR(:get<groupName>);
my %userMails_of :ATTR(:get<userMails>);

__PACKAGE__->_factory(
    [ qw(        groupName
        userMails

    ) ],
    {
        'groupName' => \%groupName_of,
        'userMails' => \%userMails_of,
    },
    {
        'groupName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'userMails' => 'MyTypes::ArrayOfNUser',
    },
    {

        'groupName' => 'groupName',
        'userMails' => 'userMails',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

MyElements::AddUsersToGroup

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
AddUsersToGroup from the namespace http://tempuri2.org/.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * groupName

 $element->set_groupName($data);
 $element->get_groupName();




=back
=item * userMails

 $element->set_userMails($data);
 $element->get_userMails();




=back


=head1 METHODS

=head2 new

 my $element = MyElements::AddUsersToGroup->new($data);

Constructor. The following data structure may be passed to new():

 {
   groupName =>  $some_value, # string
   userMails =>  { # MyTypes::ArrayOfNUser
     NUser =>  { value => $some_value },
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

