#!perl -T
use 5.006;
use strict;
use warnings;
use Test::Most;

use Git::Hooks::CheckCommitAuthorFromMailmap;

BEGIN {
    use_ok('Git::Hooks::CheckCommitAuthorFromMailmap')
      || print "Bail out!\n";

    can_ok( 'Git::Hooks::CheckCommitAuthorFromMailmap', '_setup_config' );
    can_ok( 'Git::Hooks::CheckCommitAuthorFromMailmap', 'check_commit_at_client' );
    can_ok( 'Git::Hooks::CheckCommitAuthorFromMailmap', 'check_commit_at_server' );
    can_ok( 'Git::Hooks::CheckCommitAuthorFromMailmap', '_check_author' );
    can_ok( 'Git::Hooks::CheckCommitAuthorFromMailmap', '_check_mailmap' );
    can_ok( 'Git::Hooks::CheckCommitAuthorFromMailmap', 'check_ref' );
    can_ok( 'Git::Hooks::CheckCommitAuthorFromMailmap', 'check_affected_refs' );
    can_ok( 'Git::Hooks::CheckCommitAuthorFromMailmap', 'check_patchset' );
}

done_testing();

