package Gruntmaster::App::Command::Rerun;

use 5.014000;
use warnings;

our $VERSION = '5999.000_015';

use Gruntmaster::App '-command';
use Gruntmaster::Data;

sub usage_desc { '%c rerun id' }

sub validate_args {
	my ($self, $opt, $args) = @_;
	my @args = @$args;
	$self->usage_error('This command only works on jobs') if $self->app->table && $self->app->table ne 'jobs';
	$self->usage_error('Wrong number of arguments') if @args != 1;
}

sub execute {
	my ($self, $opt, $args) = @_;
	my ($obj) = @$args;
	rerun_job $obj;
}

1;
__END__

=encoding utf-8

=head1 NAME

Gruntmaster::App::Command::Rerun - rerun a job

=head1 SYNOPSIS

  gm rerun 123

=head1 DESCRIPTION

The rerun command takes the ID of a job, clears its result, and makes
B<gruntmaster-daemon> rerun it.

=head1 SEE ALSO

L<gm>

=head1 AUTHOR

Marius Gavrilescu, E<lt>marius@ieval.roE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2014-2015 by Marius Gavrilescu

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.20.1 or,
at your option, any later version of Perl 5 you may have available.


=cut
