package SVG::Rasterize::Specification;
use strict;
use warnings;

use Exporter 'import';
use Params::Validate qw(:types);

use SVG::Rasterize::Regexes qw(:attributes);

# $Id: Specification.pm 5710 2010-05-23 09:04:11Z mullet $

=head1 NAME

C<SVG::Rasterize::Specification> - data structures derived from DTD

=head1 VERSION

Version 0.001005

=cut

our $VERSION = '0.001005';

our @EXPORT    = qw(%CHILDREN %ATTR_VAL %ATTR_HINTS);
our @EXPORT_OK = qw();

our %CHILDREN =
    ('a'                   => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'altGlyph'            => {},
     'altGlyphDef'         => {'altGlyphItem'        => 1,
                               'glyphRef'            => 1},
     'altGlyphItem'        => {'glyphRef'            => 1},
     'animate'             => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'animateColor'        => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'animateMotion'       => {'desc'                => 1,
                               'metadata'            => 1,
                               'mpath'               => 1,
                               'title'               => 1},
     'animateTransform'    => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'circle'              => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'clipPath'            => {'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'line'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'rect'                => 1,
                               'set'                 => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1},
     'color-profile'       => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'cursor'              => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'definition-src'      => {},
     'defs'                => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'desc'                => {},
     'ellipse'             => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'feBlend'             => {'animate'             => 1,
                               'set'                 => 1},
     'feColorMatrix'       => {'animate'             => 1,
                               'set'                 => 1},
     'feComponentTransfer' => {'feFuncA'             => 1,
                               'feFuncB'             => 1,
                               'feFuncG'             => 1,
                               'feFuncR'             => 1},
     'feComposite'         => {'animate'             => 1,
                               'set'                 => 1},
     'feConvolveMatrix'    => {'animate'             => 1,
                               'set'                 => 1},
     'feDiffuseLighting'   => {'animate'             => 1,
                               'animateColor'        => 1,
                               'feDistantLight'      => 1,
                               'fePointLight'        => 1,
                               'feSpotLight'         => 1,
                               'set'                 => 1},
     'feDisplacementMap'   => {'animate'             => 1,
                               'set'                 => 1},
     'feDistantLight'      => {'animate'             => 1,
                               'set'                 => 1},
     'feFlood'             => {'animate'             => 1,
                               'animateColor'        => 1,
                               'set'                 => 1},
     'feFuncA'             => {'animate'             => 1,
                               'set'                 => 1},
     'feFuncB'             => {'animate'             => 1,
                               'set'                 => 1},
     'feFuncG'             => {'animate'             => 1,
                               'set'                 => 1},
     'feFuncR'             => {'animate'             => 1,
                               'set'                 => 1},
     'feGaussianBlur'      => {'animate'             => 1,
                               'set'                 => 1},
     'feImage'             => {'animate'             => 1,
                               'animateTransform'    => 1,
                               'set'                 => 1},
     'feMerge'             => {'feMergeNode'         => 1},
     'feMergeNode'         => {'animate'             => 1,
                               'set'                 => 1},
     'feMorphology'        => {'animate'             => 1,
                               'set'                 => 1},
     'feOffset'            => {'animate'             => 1,
                               'set'                 => 1},
     'fePointLight'        => {'animate'             => 1,
                               'set'                 => 1},
     'feSpecularLighting'  => {'animate'             => 1,
                               'animateColor'        => 1,
                               'feDistantLight'      => 1,
                               'fePointLight'        => 1,
                               'feSpotLight'         => 1,
                               'set'                 => 1},
     'feSpotLight'         => {'animate'             => 1,
                               'set'                 => 1},
     'feTile'              => {'animate'             => 1,
                               'set'                 => 1},
     'feTurbulence'        => {'animate'             => 1,
                               'set'                 => 1},
     'filter'              => {'animate'             => 1,
                               'desc'                => 1,
                               'feBlend'             => 1,
                               'feColorMatrix'       => 1,
                               'feComponentTransfer' => 1,
                               'feComposite'         => 1,
                               'feConvolveMatrix'    => 1,
                               'feDiffuseLighting'   => 1,
                               'feDisplacementMap'   => 1,
                               'feFlood'             => 1,
                               'feGaussianBlur'      => 1,
                               'feImage'             => 1,
                               'feMerge'             => 1,
                               'feMorphology'        => 1,
                               'feOffset'            => 1,
                               'feSpecularLighting'  => 1,
                               'feTile'              => 1,
                               'feTurbulence'        => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'font'                => {'desc'                => 1,
                               'font-face'           => 1,
                               'glyph'               => 1,
                               'hkern'               => 1,
                               'metadata'            => 1,
                               'missing-glyph'       => 1,
                               'title'               => 1,
                               'vkern'               => 1},
     'font-face'           => {'definition-src'      => 1,
                               'desc'                => 1,
                               'font-face-src'       => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'font-face-format'    => {},
     'font-face-name'      => {},
     'font-face-src'       => {'font-face-name'      => 1,
                               'font-face-uri'       => 1},
     'font-face-uri'       => {'font-face-format'    => 1},
     'foreignObject'       => {},
     'g'                   => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'glyph'               => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'glyphRef'            => {},
     'hkern'               => {},
     'image'               => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'line'                => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'linearGradient'      => {'animate'             => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'stop'                => 1,
                               'title'               => 1},
     'marker'              => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'mask'                => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'metadata'            => {},
     'missing-glyph'       => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'mpath'               => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'path'                => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'pattern'             => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'polygon'             => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'polyline'            => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'radialGradient'      => {'animate'             => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'stop'                => 1,
                               'title'               => 1},
     'rect'                => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'script'              => {},
     'set'                 => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'stop'                => {'animate'             => 1,
                               'animateColor'        => 1,
                               'set'                 => 1},
     'style'               => {},
     'svg'                 => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'switch'              => {'a'                   => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'foreignObject'       => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'rect'                => 1,
                               'set'                 => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1},
     'symbol'              => {'a'                   => 1,
                               'altGlyphDef'         => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'circle'              => 1,
                               'clipPath'            => 1,
                               'color-profile'       => 1,
                               'cursor'              => 1,
                               'defs'                => 1,
                               'desc'                => 1,
                               'ellipse'             => 1,
                               'filter'              => 1,
                               'font'                => 1,
                               'font-face'           => 1,
                               'g'                   => 1,
                               'image'               => 1,
                               'line'                => 1,
                               'linearGradient'      => 1,
                               'marker'              => 1,
                               'mask'                => 1,
                               'metadata'            => 1,
                               'path'                => 1,
                               'pattern'             => 1,
                               'polygon'             => 1,
                               'polyline'            => 1,
                               'radialGradient'      => 1,
                               'rect'                => 1,
                               'script'              => 1,
                               'set'                 => 1,
                               'style'               => 1,
                               'svg'                 => 1,
                               'switch'              => 1,
                               'symbol'              => 1,
                               'text'                => 1,
                               'title'               => 1,
                               'use'                 => 1,
                               'view'                => 1},
     'text'                => {'a'                   => 1,
                               'altGlyph'            => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'textPath'            => 1,
                               'title'               => 1,
                               'tref'                => 1,
                               'tspan'               => 1},
     'textPath'            => {'a'                   => 1,
                               'altGlyph'            => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1,
                               'tref'                => 1,
                               'tspan'               => 1},
     'title'               => {},
     'tref'                => {'animate'             => 1,
                               'animateColor'        => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'tspan'               => {'a'                   => 1,
                               'altGlyph'            => 1,
                               'animate'             => 1,
                               'animateColor'        => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1,
                               'tref'                => 1,
                               'tspan'               => 1},
     'use'                 => {'animate'             => 1,
                               'animateColor'        => 1,
                               'animateMotion'       => 1,
                               'animateTransform'    => 1,
                               'desc'                => 1,
                               'metadata'            => 1,
                               'set'                 => 1,
                               'title'               => 1},
     'view'                => {'desc'                => 1,
                               'metadata'            => 1,
                               'title'               => 1},
     'vkern'               => {});

our %ATTR_VAL =
    ('a'                   => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'target'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'xlink:actuate'                => {default  => 'onRequest',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onRequest/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'replace',
                                                                  type     => SCALAR,
                                                                  regex    => qr/new|replace/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'altGlyph'            => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'dx'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'dy'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'format'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyphRef'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'rotate'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'altGlyphDef'         => {'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'altGlyphItem'        => {'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'animate'             => {'accumulate'                   => {default  => 'none',
                                                                  type     => SCALAR,
                                                                  regex    => qr/none|sum/},
                               'additive'                     => {default  => 'replace',
                                                                  type     => SCALAR,
                                                                  regex    => qr/replace|sum/},
                               'attributeName'                => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'attributeType'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'begin'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'by'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'calcMode'                     => {default  => 'linear',
                                                                  type     => SCALAR,
                                                                  regex    => qr/discrete|linear|paced|spline/},
                               'dur'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'end'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {default  => 'remove',
                                                                  type     => SCALAR,
                                                                  regex    => qr/remove|freeze/},
                               'from'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'keySplines'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'keyTimes'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'max'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'min'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onbegin'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onend'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onrepeat'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'repeatCount'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'repeatDur'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'restart'                      => {default  => 'always',
                                                                  type     => SCALAR,
                                                                  regex    => qr/always|never|whenNotActive/},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'to'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'values'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'animateColor'        => {'accumulate'                   => {default  => 'none',
                                                                  type     => SCALAR,
                                                                  regex    => qr/none|sum/},
                               'additive'                     => {default  => 'replace',
                                                                  type     => SCALAR,
                                                                  regex    => qr/replace|sum/},
                               'attributeName'                => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'attributeType'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'begin'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'by'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'calcMode'                     => {default  => 'linear',
                                                                  type     => SCALAR,
                                                                  regex    => qr/discrete|linear|paced|spline/},
                               'dur'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'end'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {default  => 'remove',
                                                                  type     => SCALAR,
                                                                  regex    => qr/remove|freeze/},
                               'from'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'keySplines'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'keyTimes'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'max'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'min'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onbegin'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onend'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onrepeat'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'repeatCount'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'repeatDur'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'restart'                      => {default  => 'always',
                                                                  type     => SCALAR,
                                                                  regex    => qr/always|never|whenNotActive/},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'to'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'values'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'animateMotion'       => {'accumulate'                   => {default  => 'none',
                                                                  type     => SCALAR,
                                                                  regex    => qr/none|sum/},
                               'additive'                     => {default  => 'replace',
                                                                  type     => SCALAR,
                                                                  regex    => qr/replace|sum/},
                               'begin'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'by'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'calcMode'                     => {default  => 'paced',
                                                                  type     => SCALAR,
                                                                  regex    => qr/discrete|linear|paced|spline/},
                               'dur'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'end'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {default  => 'remove',
                                                                  type     => SCALAR,
                                                                  regex    => qr/remove|freeze/},
                               'from'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'keyPoints'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'keySplines'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'keyTimes'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'max'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'min'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onbegin'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onend'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onrepeat'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'origin'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'path'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'repeatCount'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'repeatDur'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'restart'                      => {default  => 'always',
                                                                  type     => SCALAR,
                                                                  regex    => qr/always|never|whenNotActive/},
                               'rotate'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'to'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'values'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'animateTransform'    => {'accumulate'                   => {default  => 'none',
                                                                  type     => SCALAR,
                                                                  regex    => qr/none|sum/},
                               'additive'                     => {default  => 'replace',
                                                                  type     => SCALAR,
                                                                  regex    => qr/replace|sum/},
                               'attributeName'                => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'attributeType'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'begin'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'by'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'calcMode'                     => {default  => 'linear',
                                                                  type     => SCALAR,
                                                                  regex    => qr/discrete|linear|paced|spline/},
                               'dur'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'end'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {default  => 'remove',
                                                                  type     => SCALAR,
                                                                  regex    => qr/remove|freeze/},
                               'from'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'keySplines'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'keyTimes'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'max'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'min'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onbegin'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onend'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onrepeat'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'repeatCount'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'repeatDur'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'restart'                      => {default  => 'always',
                                                                  type     => SCALAR,
                                                                  regex    => qr/always|never|whenNotActive/},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'to'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'type'                         => {default  => 'translate',
                                                                  type     => SCALAR,
                                                                  regex    => qr/translate|scale|rotate|skewX|skewY/},
                               'values'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'circle'              => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'cx'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'cy'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'r'                            => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'clipPath'            => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'clipPathUnits'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/userSpaceOnUse|objectBoundingBox/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'color-profile'       => {'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'local'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'name'                         => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'rendering-intent'             => {default  => 'auto',
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|perceptual|relative\-colorimetric|saturation|absolute\-colorimetric/},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'cursor'              => {'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'definition-src'      => {'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'defs'                => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'desc'                => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'ellipse'             => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'cx'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'cy'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'rx'                           => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'ry'                           => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'feBlend'             => {'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in2'                          => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mode'                         => {default  => 'normal',
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|multiply|screen|darken|lighten/},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'feColorMatrix'       => {'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'type'                         => {default  => 'matrix',
                                                                  type     => SCALAR,
                                                                  regex    => qr/matrix|saturate|hueRotate|luminanceToAlpha/},
                               'values'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'feComponentTransfer' => {'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'feComposite'         => {'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in2'                          => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'k1'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'k2'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'k3'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'k4'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'operator'                     => {default  => 'over',
                                                                  type     => SCALAR,
                                                                  regex    => qr/over|in|out|atop|xor|arithmetic/},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'feConvolveMatrix'    => {'bias'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'divisor'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'edgeMode'                     => {default  => 'duplicate',
                                                                  type     => SCALAR,
                                                                  regex    => qr/duplicate|wrap|none/},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'kernelMatrix'                 => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'kernelUnitLength'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'order'                        => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'preserveAlpha'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'targetX'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'targetY'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'feDiffuseLighting'   => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'diffuseConstant'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'kernelUnitLength'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'surfaceScale'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'feDisplacementMap'   => {'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in2'                          => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'scale'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xChannelSelector'             => {default  => 'A',
                                                                  type     => SCALAR,
                                                                  regex    => qr/R|G|B|A/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'yChannelSelector'             => {default  => 'A',
                                                                  type     => SCALAR,
                                                                  regex    => qr/R|G|B|A/}},
     'feDistantLight'      => {'azimuth'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'elevation'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'feFlood'             => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'feFuncA'             => {'amplitude'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'exponent'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'intercept'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'offset'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'slope'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'tableValues'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'type'                         => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr/identity|table|discrete|linear|gamma/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'feFuncB'             => {'amplitude'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'exponent'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'intercept'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'offset'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'slope'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'tableValues'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'type'                         => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr/identity|table|discrete|linear|gamma/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'feFuncG'             => {'amplitude'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'exponent'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'intercept'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'offset'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'slope'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'tableValues'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'type'                         => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr/identity|table|discrete|linear|gamma/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'feFuncR'             => {'amplitude'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'exponent'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'intercept'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'offset'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'slope'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'tableValues'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'type'                         => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr/identity|table|discrete|linear|gamma/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'feGaussianBlur'      => {'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stdDeviation'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'feImage'             => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'preserveAspectRatio'          => {default  => 'xMidYMid meet',
                                                                  type     => SCALAR,
                                                                  regex    => $RE_VIEW_BOX{PAR}},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'embed',
                                                                  type     => SCALAR,
                                                                  regex    => qr/embed/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'feMerge'             => {'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'feMergeNode'         => {'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'feMorphology'        => {'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'operator'                     => {default  => 'erode',
                                                                  type     => SCALAR,
                                                                  regex    => qr/erode|dilate/},
                               'radius'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'feOffset'            => {'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'dx'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'dy'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'fePointLight'        => {'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'z'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}}},
     'feSpecularLighting'  => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'kernelUnitLength'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'specularConstant'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'specularExponent'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'surfaceScale'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'feSpotLight'         => {'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'limitingConeAngle'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'pointsAtX'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'pointsAtY'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'pointsAtZ'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'specularExponent'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'z'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}}},
     'feTile'              => {'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'in'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'feTurbulence'        => {'baseFrequency'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'numOctaves'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'result'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'seed'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'stitchTiles'                  => {default  => 'noStitch',
                                                                  type     => SCALAR,
                                                                  regex    => qr/stitch|noStitch/},
                               'type'                         => {default  => 'turbulence',
                                                                  type     => SCALAR,
                                                                  regex    => qr/fractalNoise|turbulence/},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'filter'              => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'filterRes'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'filterUnits'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/userSpaceOnUse|objectBoundingBox/},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'primitiveUnits'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/userSpaceOnUse|objectBoundingBox/},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'font'                => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'horiz-adv-x'                  => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'horiz-origin-x'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'horiz-origin-y'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'vert-adv-y'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'vert-origin-x'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'vert-origin-y'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'font-face'           => {'accent-height'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'alphabetic'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'ascent'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'bbox'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'cap-height'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'descent'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'hanging'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'ideographic'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'mathematical'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'overline-position'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'overline-thickness'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'panose-1'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'slope'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'stemh'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'stemv'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'strikethrough-position'       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'strikethrough-thickness'      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'underline-position'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'underline-thickness'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'unicode-range'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'units-per-em'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'v-alphabetic'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'v-hanging'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'v-ideographic'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'v-mathematical'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'widths'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'x-height'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'font-face-format'    => {'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'string'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'font-face-name'      => {'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'name'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'font-face-src'       => {'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'font-face-uri'       => {'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'foreignObject'       => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'height'                       => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'width'                        => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'g'                   => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'glyph'               => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'arabic-form'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'd'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_PATH{p_PATH_LIST}},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-name'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'horiz-adv-x'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lang'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'orientation'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'unicode'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'vert-adv-y'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'vert-origin-x'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'vert-origin-y'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'glyphRef'            => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'dx'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'dy'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'format'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyphRef'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}}},
     'hkern'               => {'g1'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'g2'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'k'                            => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'u1'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'u2'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'image'               => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'height'                       => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'preserveAspectRatio'          => {default  => 'xMidYMid meet',
                                                                  type     => SCALAR,
                                                                  regex    => $RE_VIEW_BOX{PAR}},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'width'                        => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'embed',
                                                                  type     => SCALAR,
                                                                  regex    => qr/embed/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'line'                => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'x1'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x2'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y1'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'y2'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'linearGradient'      => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'gradientTransform'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'gradientUnits'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/userSpaceOnUse|objectBoundingBox/},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'spreadMethod'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/pad|reflect|repeat/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'x1'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x2'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'y1'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'y2'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'marker'              => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'markerHeight'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'markerUnits'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/strokeWidth|userSpaceOnUse/},
                               'markerWidth'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'orient'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'preserveAspectRatio'          => {default  => 'xMidYMid meet',
                                                                  type     => SCALAR,
                                                                  regex    => $RE_VIEW_BOX{PAR}},
                               'refX'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'refY'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'viewBox'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_VIEW_BOX{p_VIEW_BOX}},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'mask'                => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'maskContentUnits'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/userSpaceOnUse|objectBoundingBox/},
                               'maskUnits'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/userSpaceOnUse|objectBoundingBox/},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'metadata'            => {'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'missing-glyph'       => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'd'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_PATH{p_PATH_LIST}},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'horiz-adv-x'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'vert-adv-y'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'vert-origin-x'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'vert-origin-y'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'mpath'               => {'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'path'                => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'd'                            => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_PATH{p_PATH_LIST}},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'pathLength'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'pattern'             => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'patternContentUnits'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/userSpaceOnUse|objectBoundingBox/},
                               'patternTransform'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'patternUnits'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/userSpaceOnUse|objectBoundingBox/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'preserveAspectRatio'          => {default  => 'xMidYMid meet',
                                                                  type     => SCALAR,
                                                                  regex    => $RE_VIEW_BOX{PAR}},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'viewBox'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_VIEW_BOX{p_VIEW_BOX}},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'polygon'             => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'points'                       => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'polyline'            => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'points'                       => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'radialGradient'      => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cx'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'cy'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fx'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'fy'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'gradientTransform'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'gradientUnits'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/userSpaceOnUse|objectBoundingBox/},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'r'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'spreadMethod'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/pad|reflect|repeat/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'rect'                => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'height'                       => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'rx'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'ry'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'width'                        => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'script'              => {'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'type'                         => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'set'                 => {'attributeName'                => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'attributeType'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'begin'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'dur'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'end'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {default  => 'remove',
                                                                  type     => SCALAR,
                                                                  regex    => qr/remove|freeze/},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'max'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'min'                          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onbegin'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onend'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onrepeat'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'repeatCount'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'repeatDur'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'restart'                      => {default  => 'always',
                                                                  type     => SCALAR,
                                                                  regex    => qr/always|never|whenNotActive/},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'to'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'stop'                => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'offset'                       => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'style'               => {'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'media'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'title'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'type'                         => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {default  => 'preserve',
                                                                  type     => SCALAR,
                                                                  regex    => qr/preserve/}},
     'svg'                 => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseProfile'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'contentScriptType'            => {default  => 'text/ecmascript',
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'contentStyleType'             => {default  => 'text/css',
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onabort'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onerror'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onresize'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onscroll'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onunload'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onzoom'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'preserveAspectRatio'          => {default  => 'xMidYMid meet',
                                                                  type     => SCALAR,
                                                                  regex    => $RE_VIEW_BOX{PAR}},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'version'                      => {default  => '1.1',
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'viewBox'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_VIEW_BOX{p_VIEW_BOX}},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns'                        => {default  => 'http://www.w3.org/2000/svg',
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'zoomAndPan'                   => {default  => 'magnify',
                                                                  type     => SCALAR,
                                                                  regex    => qr/disable|magnify/}},
     'switch'              => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'symbol'              => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'preserveAspectRatio'          => {default  => 'xMidYMid meet',
                                                                  type     => SCALAR,
                                                                  regex    => $RE_VIEW_BOX{PAR}},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'viewBox'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_VIEW_BOX{p_VIEW_BOX}},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'text'                => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'dx'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'dy'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lengthAdjust'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/spacing|spacingAndGlyphs/},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'rotate'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'textLength'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'textPath'            => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lengthAdjust'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/spacing|spacingAndGlyphs/},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'method'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/align|stretch/},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'spacing'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|exact/},
                               'startOffset'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'textLength'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'title'               => {'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}},
     'tref'                => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'dx'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'dy'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lengthAdjust'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/spacing|spacingAndGlyphs/},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'rotate'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'textLength'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'other',
                                                                  type     => SCALAR,
                                                                  regex    => qr/other/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'tspan'               => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'dx'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'dy'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lengthAdjust'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/spacing|spacingAndGlyphs/},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'rotate'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'textLength'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//}},
     'use'                 => {'alignment-baseline'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit/},
                               'baseline-shift'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'class'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-path'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'clip-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'color'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-interpolation'          => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-interpolation-filters'  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|sRGB|linearRGB|inherit/},
                               'color-profile'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'color-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'cursor'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'direction'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/ltr|rtl|inherit/},
                               'display'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit/},
                               'dominant-baseline'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit/},
                               'enable-background'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'fill'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'fill-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'fill-rule'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/nonzero|evenodd|inherit/},
                               'filter'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-color'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'flood-opacity'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'font-family'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-size-adjust'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'font-stretch'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit/},
                               'font-style'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|italic|oblique|inherit/},
                               'font-variant'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|small\-caps|inherit/},
                               'font-weight'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit/},
                               'glyph-orientation-horizontal' => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'glyph-orientation-vertical'   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'height'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'image-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeQuality|inherit/},
                               'kerning'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'letter-spacing'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'lighting-color'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-end'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-mid'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'marker-start'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'mask'                         => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onactivate'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onclick'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusin'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onfocusout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onload'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousedown'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmousemove'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseout'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseover'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'onmouseup'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'opacity'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'overflow'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|scroll|auto|inherit/},
                               'pointer-events'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit/},
                               'requiredExtensions'           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'requiredFeatures'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'shape-rendering'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|crispEdges|geometricPrecision|inherit/},
                               'stop-color'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stop-opacity'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke'                       => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'stroke-dasharray'             => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                               'stroke-dashoffset'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'stroke-linecap'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/butt|round|square|inherit/},
                               'stroke-linejoin'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/miter|round|bevel|inherit/},
                               'stroke-miterlimit'            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                               'stroke-opacity'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                               'stroke-width'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                               'style'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'systemLanguage'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-anchor'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/start|middle|end|inherit/},
                               'text-decoration'              => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'text-rendering'               => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit/},
                               'transform'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_TRANSFORM{p_TRANSFORM_LIST}},
                               'unicode-bidi'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/normal|embed|bidi\-override|inherit/},
                               'visibility'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/visible|hidden|inherit/},
                               'width'                        => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'word-spacing'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'writing-mode'                 => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit/},
                               'x'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}},
                               'xlink:actuate'                => {default  => 'onLoad',
                                                                  type     => SCALAR,
                                                                  regex    => qr/onLoad/},
                               'xlink:arcrole'                => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:href'                   => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:role'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:show'                   => {default  => 'embed',
                                                                  type     => SCALAR,
                                                                  regex    => qr/embed/},
                               'xlink:title'                  => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xlink:type'                   => {default  => 'simple',
                                                                  type     => SCALAR,
                                                                  regex    => qr/simple/},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'xmlns:xlink'                  => {default  => 'http://www.w3.org/1999/xlink',
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'y'                            => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_LENGTH{p_A_LENGTH}}},
     'view'                => {'externalResourcesRequired'    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/false|true/},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'preserveAspectRatio'          => {default  => 'xMidYMid meet',
                                                                  type     => SCALAR,
                                                                  regex    => $RE_VIEW_BOX{PAR}},
                               'viewBox'                      => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_VIEW_BOX{p_VIEW_BOX}},
                               'viewTarget'                   => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/},
                               'zoomAndPan'                   => {default  => 'magnify',
                                                                  type     => SCALAR,
                                                                  regex    => qr/disable|magnify/}},
     'vkern'               => {'g1'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'g2'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'id'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'k'                            => {optional => 0,
                                                                  type     => SCALAR,
                                                                  regex    => $RE_NUMBER{p_A_NUMBER}},
                               'u1'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'u2'                           => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:base'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:lang'                     => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr//},
                               'xml:space'                    => {optional => 1,
                                                                  type     => SCALAR,
                                                                  regex    => qr/default|preserve/}});

our %ATTR_HINTS =
    ('a'                   => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'target'                       => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'altGlyph'            => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'dx'                           => {},
                               'dy'                           => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'format'                       => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'glyphRef'                     => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'rotate'                       => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'x'                            => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {}},
     'altGlyphDef'         => {'id'                           => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'altGlyphItem'        => {'id'                           => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'animate'             => {'accumulate'                   => {},
                               'additive'                     => {},
                               'attributeName'                => {},
                               'attributeType'                => {},
                               'begin'                        => {},
                               'by'                           => {},
                               'calcMode'                     => {},
                               'dur'                          => {},
                               'end'                          => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {},
                               'from'                         => {},
                               'id'                           => {},
                               'keySplines'                   => {},
                               'keyTimes'                     => {},
                               'max'                          => {},
                               'min'                          => {},
                               'onbegin'                      => {},
                               'onend'                        => {},
                               'onload'                       => {},
                               'onrepeat'                     => {},
                               'repeatCount'                  => {},
                               'repeatDur'                    => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'restart'                      => {},
                               'systemLanguage'               => {},
                               'to'                           => {},
                               'values'                       => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'animateColor'        => {'accumulate'                   => {},
                               'additive'                     => {},
                               'attributeName'                => {},
                               'attributeType'                => {},
                               'begin'                        => {},
                               'by'                           => {},
                               'calcMode'                     => {},
                               'dur'                          => {},
                               'end'                          => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {},
                               'from'                         => {},
                               'id'                           => {},
                               'keySplines'                   => {},
                               'keyTimes'                     => {},
                               'max'                          => {},
                               'min'                          => {},
                               'onbegin'                      => {},
                               'onend'                        => {},
                               'onload'                       => {},
                               'onrepeat'                     => {},
                               'repeatCount'                  => {},
                               'repeatDur'                    => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'restart'                      => {},
                               'systemLanguage'               => {},
                               'to'                           => {},
                               'values'                       => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'animateMotion'       => {'accumulate'                   => {},
                               'additive'                     => {},
                               'begin'                        => {},
                               'by'                           => {},
                               'calcMode'                     => {},
                               'dur'                          => {},
                               'end'                          => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {},
                               'from'                         => {},
                               'id'                           => {},
                               'keyPoints'                    => {},
                               'keySplines'                   => {},
                               'keyTimes'                     => {},
                               'max'                          => {},
                               'min'                          => {},
                               'onbegin'                      => {},
                               'onend'                        => {},
                               'onload'                       => {},
                               'onrepeat'                     => {},
                               'origin'                       => {},
                               'path'                         => {},
                               'repeatCount'                  => {},
                               'repeatDur'                    => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'restart'                      => {},
                               'rotate'                       => {},
                               'systemLanguage'               => {},
                               'to'                           => {},
                               'values'                       => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'animateTransform'    => {'accumulate'                   => {},
                               'additive'                     => {},
                               'attributeName'                => {},
                               'attributeType'                => {},
                               'begin'                        => {},
                               'by'                           => {},
                               'calcMode'                     => {},
                               'dur'                          => {},
                               'end'                          => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {},
                               'from'                         => {},
                               'id'                           => {},
                               'keySplines'                   => {},
                               'keyTimes'                     => {},
                               'max'                          => {},
                               'min'                          => {},
                               'onbegin'                      => {},
                               'onend'                        => {},
                               'onload'                       => {},
                               'onrepeat'                     => {},
                               'repeatCount'                  => {},
                               'repeatDur'                    => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'restart'                      => {},
                               'systemLanguage'               => {},
                               'to'                           => {},
                               'type'                         => {},
                               'values'                       => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'circle'              => {'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'cx'                           => {length => 1},
                               'cy'                           => {length => 1},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'r'                            => {length => 1},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'clipPath'            => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'clipPathUnits'                => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'color-profile'       => {'id'                           => {},
                               'local'                        => {},
                               'name'                         => {},
                               'rendering-intent'             => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'cursor'              => {'externalResourcesRequired'    => {},
                               'id'                           => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'systemLanguage'               => {},
                               'x'                            => {length => 1},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {length => 1}},
     'definition-src'      => {'id'                           => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'defs'                => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'desc'                => {'class'                        => {},
                               'id'                           => {},
                               'style'                        => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'ellipse'             => {'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'cx'                           => {length => 1},
                               'cy'                           => {length => 1},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'rx'                           => {length => 1},
                               'ry'                           => {length => 1},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'feBlend'             => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'in2'                          => {},
                               'mode'                         => {},
                               'result'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feColorMatrix'       => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'result'                       => {},
                               'type'                         => {},
                               'values'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feComponentTransfer' => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'result'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feComposite'         => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'in2'                          => {},
                               'k1'                           => {},
                               'k2'                           => {},
                               'k3'                           => {},
                               'k4'                           => {},
                               'operator'                     => {},
                               'result'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feConvolveMatrix'    => {'bias'                         => {},
                               'color-interpolation-filters'  => {},
                               'divisor'                      => {},
                               'edgeMode'                     => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'kernelMatrix'                 => {},
                               'kernelUnitLength'             => {},
                               'order'                        => {},
                               'preserveAlpha'                => {},
                               'result'                       => {},
                               'targetX'                      => {},
                               'targetY'                      => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feDiffuseLighting'   => {'class'                        => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-rendering'              => {},
                               'diffuseConstant'              => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'kernelUnitLength'             => {},
                               'lighting-color'               => {},
                               'result'                       => {},
                               'style'                        => {},
                               'surfaceScale'                 => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feDisplacementMap'   => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'in2'                          => {},
                               'result'                       => {},
                               'scale'                        => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xChannelSelector'             => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1},
                               'yChannelSelector'             => {}},
     'feDistantLight'      => {'azimuth'                      => {},
                               'elevation'                    => {},
                               'id'                           => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'feFlood'             => {'class'                        => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-rendering'              => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'result'                       => {},
                               'style'                        => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feFuncA'             => {'amplitude'                    => {},
                               'exponent'                     => {},
                               'id'                           => {},
                               'intercept'                    => {},
                               'offset'                       => {},
                               'slope'                        => {},
                               'tableValues'                  => {},
                               'type'                         => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'feFuncB'             => {'amplitude'                    => {},
                               'exponent'                     => {},
                               'id'                           => {},
                               'intercept'                    => {},
                               'offset'                       => {},
                               'slope'                        => {},
                               'tableValues'                  => {},
                               'type'                         => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'feFuncG'             => {'amplitude'                    => {},
                               'exponent'                     => {},
                               'id'                           => {},
                               'intercept'                    => {},
                               'offset'                       => {},
                               'slope'                        => {},
                               'tableValues'                  => {},
                               'type'                         => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'feFuncR'             => {'amplitude'                    => {},
                               'exponent'                     => {},
                               'id'                           => {},
                               'intercept'                    => {},
                               'offset'                       => {},
                               'slope'                        => {},
                               'tableValues'                  => {},
                               'type'                         => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'feGaussianBlur'      => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'result'                       => {},
                               'stdDeviation'                 => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feImage'             => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'preserveAspectRatio'          => {},
                               'result'                       => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'x'                            => {length => 1},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {length => 1}},
     'feMerge'             => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'result'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feMergeNode'         => {'id'                           => {},
                               'in'                           => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'feMorphology'        => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'operator'                     => {},
                               'radius'                       => {},
                               'result'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feOffset'            => {'color-interpolation-filters'  => {},
                               'dx'                           => {},
                               'dy'                           => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'result'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'fePointLight'        => {'id'                           => {},
                               'x'                            => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {},
                               'z'                            => {}},
     'feSpecularLighting'  => {'class'                        => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-rendering'              => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'kernelUnitLength'             => {},
                               'lighting-color'               => {},
                               'result'                       => {},
                               'specularConstant'             => {},
                               'specularExponent'             => {},
                               'style'                        => {},
                               'surfaceScale'                 => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feSpotLight'         => {'id'                           => {},
                               'limitingConeAngle'            => {},
                               'pointsAtX'                    => {},
                               'pointsAtY'                    => {},
                               'pointsAtZ'                    => {},
                               'specularExponent'             => {},
                               'x'                            => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {},
                               'z'                            => {}},
     'feTile'              => {'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'in'                           => {},
                               'result'                       => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'feTurbulence'        => {'baseFrequency'                => {},
                               'color-interpolation-filters'  => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'numOctaves'                   => {},
                               'result'                       => {},
                               'seed'                         => {},
                               'stitchTiles'                  => {},
                               'type'                         => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'filter'              => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'filterRes'                    => {},
                               'filterUnits'                  => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'primitiveUnits'               => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'x'                            => {length => 1},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {length => 1}},
     'font'                => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'horiz-adv-x'                  => {},
                               'horiz-origin-x'               => {},
                               'horiz-origin-y'               => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'vert-adv-y'                   => {},
                               'vert-origin-x'                => {},
                               'vert-origin-y'                => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'font-face'           => {'accent-height'                => {},
                               'alphabetic'                   => {},
                               'ascent'                       => {},
                               'bbox'                         => {},
                               'cap-height'                   => {},
                               'descent'                      => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'hanging'                      => {},
                               'id'                           => {},
                               'ideographic'                  => {},
                               'mathematical'                 => {},
                               'overline-position'            => {},
                               'overline-thickness'           => {},
                               'panose-1'                     => {},
                               'slope'                        => {},
                               'stemh'                        => {},
                               'stemv'                        => {},
                               'strikethrough-position'       => {},
                               'strikethrough-thickness'      => {},
                               'underline-position'           => {},
                               'underline-thickness'          => {},
                               'unicode-range'                => {},
                               'units-per-em'                 => {},
                               'v-alphabetic'                 => {},
                               'v-hanging'                    => {},
                               'v-ideographic'                => {},
                               'v-mathematical'               => {},
                               'widths'                       => {},
                               'x-height'                     => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'font-face-format'    => {'id'                           => {},
                               'string'                       => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'font-face-name'      => {'id'                           => {},
                               'name'                         => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'font-face-src'       => {'id'                           => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'font-face-uri'       => {'id'                           => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'foreignObject'       => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'g'                   => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'glyph'               => {'alignment-baseline'           => {},
                               'arabic-form'                  => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'd'                            => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-name'                   => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'horiz-adv-x'                  => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'lang'                         => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'orientation'                  => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode'                      => {},
                               'unicode-bidi'                 => {},
                               'vert-adv-y'                   => {},
                               'vert-origin-x'                => {},
                               'vert-origin-y'                => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'glyphRef'            => {'class'                        => {},
                               'dx'                           => {},
                               'dy'                           => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'format'                       => {},
                               'glyphRef'                     => {},
                               'id'                           => {},
                               'style'                        => {},
                               'x'                            => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {}},
     'hkern'               => {'g1'                           => {},
                               'g2'                           => {},
                               'id'                           => {},
                               'k'                            => {},
                               'u1'                           => {},
                               'u2'                           => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'image'               => {'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill-opacity'                 => {},
                               'filter'                       => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'preserveAspectRatio'          => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stroke-opacity'               => {},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {length => 1}},
     'line'                => {'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'x1'                           => {length => 1},
                               'x2'                           => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y1'                           => {length => 1},
                               'y2'                           => {length => 1}},
     'linearGradient'      => {'class'                        => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'externalResourcesRequired'    => {},
                               'gradientTransform'            => {},
                               'gradientUnits'                => {},
                               'id'                           => {},
                               'spreadMethod'                 => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'style'                        => {},
                               'x1'                           => {length => 1},
                               'x2'                           => {length => 1},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y1'                           => {length => 1},
                               'y2'                           => {length => 1}},
     'marker'              => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'markerHeight'                 => {length => 1},
                               'markerUnits'                  => {},
                               'markerWidth'                  => {length => 1},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'orient'                       => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'preserveAspectRatio'          => {},
                               'refX'                         => {length => 1},
                               'refY'                         => {length => 1},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'viewBox'                      => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'mask'                => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'maskContentUnits'             => {},
                               'maskUnits'                    => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'metadata'            => {'id'                           => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'missing-glyph'       => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'd'                            => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'horiz-adv-x'                  => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'vert-adv-y'                   => {},
                               'vert-origin-x'                => {},
                               'vert-origin-y'                => {},
                               'visibility'                   => {},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'mpath'               => {'externalResourcesRequired'    => {},
                               'id'                           => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'path'                => {'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'd'                            => {},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pathLength'                   => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'pattern'             => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'patternContentUnits'          => {},
                               'patternTransform'             => {},
                               'patternUnits'                 => {},
                               'pointer-events'               => {},
                               'preserveAspectRatio'          => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'viewBox'                      => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'x'                            => {length => 1},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {length => 1}},
     'polygon'             => {'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'points'                       => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'polyline'            => {'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'points'                       => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'radialGradient'      => {'class'                        => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cx'                           => {length => 1},
                               'cy'                           => {length => 1},
                               'externalResourcesRequired'    => {},
                               'fx'                           => {length => 1},
                               'fy'                           => {length => 1},
                               'gradientTransform'            => {},
                               'gradientUnits'                => {},
                               'id'                           => {},
                               'r'                            => {length => 1},
                               'spreadMethod'                 => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'style'                        => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'rect'                => {'class'                        => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'display'                      => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'mask'                         => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'opacity'                      => {},
                               'pointer-events'               => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'rx'                           => {length => 1},
                               'ry'                           => {length => 1},
                               'shape-rendering'              => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-rendering'               => {},
                               'transform'                    => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'y'                            => {length => 1}},
     'script'              => {'externalResourcesRequired'    => {},
                               'id'                           => {},
                               'type'                         => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'set'                 => {'attributeName'                => {},
                               'attributeType'                => {},
                               'begin'                        => {},
                               'dur'                          => {},
                               'end'                          => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {},
                               'id'                           => {},
                               'max'                          => {},
                               'min'                          => {},
                               'onbegin'                      => {},
                               'onend'                        => {},
                               'onload'                       => {},
                               'onrepeat'                     => {},
                               'repeatCount'                  => {},
                               'repeatDur'                    => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'restart'                      => {},
                               'systemLanguage'               => {},
                               'to'                           => {},
                               'xlink:actuate'                => {},
                               'xlink:arcrole'                => {},
                               'xlink:href'                   => {},
                               'xlink:role'                   => {},
                               'xlink:show'                   => {},
                               'xlink:title'                  => {},
                               'xlink:type'                   => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns:xlink'                  => {}},
     'stop'                => {'class'                        => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-rendering'              => {},
                               'id'                           => {},
                               'offset'                       => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'style'                        => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'style'               => {'id'                           => {},
                               'media'                        => {},
                               'title'                        => {},
                               'type'                         => {},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {}},
     'svg'                 => {'alignment-baseline'           => {},
                               'baseProfile'                  => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'contentScriptType'            => {},
                               'contentStyleType'             => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opacity'                => {},
                               'font-family'                  => {},
                               'font-size'                    => {},
                               'font-size-adjust'             => {},
                               'font-stretch'                 => {},
                               'font-style'                   => {},
                               'font-variant'                 => {},
                               'font-weight'                  => {},
                               'glyph-orientation-horizontal' => {},
                               'glyph-orientation-vertical'   => {},
                               'height'                       => {length => 1},
                               'id'                           => {},
                               'image-rendering'              => {},
                               'kerning'                      => {},
                               'letter-spacing'               => {},
                               'lighting-color'               => {},
                               'marker-end'                   => {},
                               'marker-mid'                   => {},
                               'marker-start'                 => {},
                               'mask'                         => {},
                               'onabort'                      => {},
                               'onactivate'                   => {},
                               'onclick'                      => {},
                               'onerror'                      => {},
                               'onfocusin'                    => {},
                               'onfocusout'                   => {},
                               'onload'                       => {},
                               'onmousedown'                  => {},
                               'onmousemove'                  => {},
                               'onmouseout'                   => {},
                               'onmouseover'                  => {},
                               'onmouseup'                    => {},
                               'onresize'                     => {},
                               'onscroll'                     => {},
                               'onunload'                     => {},
                               'onzoom'                       => {},
                               'opacity'                      => {},
                               'overflow'                     => {},
                               'pointer-events'               => {},
                               'preserveAspectRatio'          => {},
                               'requiredExtensions'           => {},
                               'requiredFeatures'             => {},
                               'shape-rendering'              => {},
                               'stop-color'                   => {},
                               'stop-opacity'                 => {},
                               'stroke'                       => {color  => 1},
                               'stroke-dasharray'             => {},
                               'stroke-dashoffset'            => {},
                               'stroke-linecap'               => {},
                               'stroke-linejoin'              => {},
                               'stroke-miterlimit'            => {},
                               'stroke-opacity'               => {},
                               'stroke-width'                 => {length => 1},
                               'style'                        => {},
                               'systemLanguage'               => {},
                               'text-anchor'                  => {},
                               'text-decoration'              => {},
                               'text-rendering'               => {},
                               'unicode-bidi'                 => {},
                               'version'                      => {},
                               'viewBox'                      => {},
                               'visibility'                   => {},
                               'width'                        => {length => 1},
                               'word-spacing'                 => {},
                               'writing-mode'                 => {},
                               'x'                            => {length => 1},
                               'xml:base'                     => {},
                               'xml:lang'                     => {},
                               'xml:space'                    => {},
                               'xmlns'                        => {},
                               'xmlns:xlink'                  => {},
                               'y'                            => {length => 1},
                               'zoomAndPan'                   => {}},
     'switch'              => {'alignment-baseline'           => {},
                               'baseline-shift'               => {},
                               'class'                        => {},
                               'clip'                         => {},
                               'clip-path'                    => {},
                               'clip-rule'                    => {},
                               'color'                        => {color  => 1},
                               'color-interpolation'          => {},
                               'color-interpolation-filters'  => {},
                               'color-profile'                => {},
                               'color-rendering'              => {},
                               'cursor'                       => {},
                               'direction'                    => {},
                               'display'                      => {},
                               'dominant-baseline'            => {},
                               'enable-background'            => {},
                               'externalResourcesRequired'    => {},
                               'fill'                         => {color  => 1},
                               'fill-opacity'                 => {},
                               'fill-rule'                    => {},
                               'filter'                       => {},
                               'flood-color'                  => {},
                               'flood-opac