use v5.12;
use warnings;
use Data::Dump qw/pp dd/;
use English;

$INPUT_RECORD_SEPARATOR="\n\n#";

while (<DATA>){
    say '-'x60;
    say ;
#    say '>'x3;
}





__DATA__
# --- single placeholders

$sql = qq~
SELECT *
    FROM  Customer
    WHERE Firstname = $first
      AND Lastname  = $last
;~;


# --- list of placeholders ?,?,?
$sql = qq~
SELECT *
    FROM  Customer
    WHERE City      IN (@cities)
;~;




# ****** exceptions are only quoted


# --- table name
$_table = 'Customer';

$sql = qq~
SELECT *
    FROM  $_table
    WHERE City      IN (@cities)
;~;


# --- fields
@_fields = qw/Id FirstName LastName Country/;

$sql = qq~
SELECT @_fields
    FROM  Customer
    WHERE City      IN (@cities)
;~;


# *** sub-expressions are not quoted

$_SUB_SQL = 'SELECT Country FROM Supplier';


$sql = qq~
SELECT Id, FirstName, LastName, Country
    FROM  Customer
    WHERE Country IN
       ( $_SUB_SQL )
;~;


# *** sub-expressions with nested placeholders

$_SUB_SQL = qq~
SELECT Country
    FROM Supplier
    WHERE Name = $name
;~;


$sql = qq~
SELECT Id, FirstName, LastName, Country
    FROM  Customer
    WHERE Country IN
       ( $_SUB_SQL )
;~;


# --- nested data structures

$sql = qq~
SELECT *
    FROM  Customer
    WHERE Firstname = $name{first}
      AND Lastname  = $name{last}
;~;
















