package # hide from PAUSE
App::YTDL::InfoPrint;

use warnings;
use strict;
use 5.010000;

use Exporter qw( import );
our @EXPORT_OK = qw( linefolded_print_info );

use Term::ANSIScreen   qw( :cursor :screen );
use Term::Choose::Util qw( term_size );
use Text::LineFold     qw();

use if $^O eq 'MSWin32', 'Win32::Console::ANSI';

use App::YTDL::GetData     qw( get_download_info );
use App::YTDL::DataExtract qw( json_to_hash );



sub _youtube_print_info {
    my ( $opt, $info, $ex, $video_id ) = @_;
    my $message = "** GET download info: ";
    my $tmp = get_download_info( $opt, $video_id, $message );
    for my $video_id ( keys %{$tmp->{$ex}} ) {
        for my $key ( keys %{$tmp->{$ex}{$video_id}} ) {
            $info->{$ex}{$video_id}{$key} = $tmp->{$ex}{$video_id}{$key};
        }
    }
}


sub _prepare_print_info {
    my ( $opt, $info, $ex, $video_id ) = @_;
    _youtube_print_info( $opt, $info, $ex, $video_id ) if $ex eq 'youtube';
    $info->{$ex}{$video_id}{published} = $info->{$ex}{$video_id}{upload_date};
    $info->{$ex}{$video_id}{author}    = $info->{$ex}{$video_id}{uploader};
    if ( length $info->{$ex}{$video_id}{author} && length $info->{$ex}{$video_id}{uploader_id} ) {
        if ( $info->{$ex}{$video_id}{author} ne $info->{$ex}{$video_id}{uploader_id} ) {
            $info->{$ex}{$video_id}{author} .= ' (' . $info->{$ex}{$video_id}{uploader_id} . ')';
        }
    }
    my @keys = ( qw( title video_id ) );
    push @keys, 'extractor' if $ex ne 'youtube';
    push @keys, qw( author duration raters avg_rating view_count published description keywords ); # categories
    for my $key ( @keys ) {
        next if ! $info->{$ex}{$video_id}{$key};
        $info->{$ex}{$video_id}{$key} =~ s/\R/ /g;
    }
    return @keys;
}


sub linefolded_print_info {
    my ( $opt, $info, $ex, $video_id, $key_len ) = @_;
    my @keys = _prepare_print_info( $opt, $info, $ex, $video_id );
    my $s_tab = $key_len + length( ' : ' );
    my ( $maxcols, $maxrows ) = term_size();
    $maxcols -= $opt->{right_margin};
    my $col_max = $maxcols > $opt->{max_info_width} ? $opt->{max_info_width} : $maxcols;
    my $lf = Text::LineFold->new( %{$opt->{linefold}} );
    $lf->config( 'ColMax', $col_max );
    my $print_array = [];
    for my $key ( @keys ) {
        next if ! length $info->{$ex}{$video_id}{$key};
        $info->{$ex}{$video_id}{$key} =~ s/\n+/\n/g;
        $info->{$ex}{$video_id}{$key} =~ s/^\s+//;
        ( my $kk = $key ) =~ s/_/ /g;
        my $pr_key = sprintf "%*.*s : ", $key_len, $key_len, $kk;
        my $text = $lf->fold( '' , ' ' x $s_tab, $pr_key . $info->{$ex}{$video_id}{$key} );
        $text =~ s/\R+\z//;
        push @$print_array, map { "$_\n" } split /\R+/, $text;
    }
    return $print_array if ! @$print_array;
    # auto width:
    my $ratio = @$print_array / $maxrows;
    my $begin = 0.70;
    my $end   = 1.50;
    my $step  = 0.0125;
    my $div   = ( $end - $begin ) / $step + 1;
    my $plus;
    if ( $ratio >= $begin ) {
        $ratio = $end if $ratio > $end;
        $plus = int( ( ( $maxcols - $col_max ) / $div ) * ( ( $ratio - $begin  ) / $step + 1 ) );
    }
    if ( $plus ) {
        $col_max += $plus;
        $lf->config( 'ColMax', $col_max );
        $print_array = [];
        for my $key ( @keys ) {
            next if ! length $info->{$ex}{$video_id}{$key};
            ( my $kk = $key ) =~ s/_/ /g;
            my $pr_key = sprintf "%*.*s : ", $key_len, $key_len, $kk;
            my $text = $lf->fold( '' , ' ' x $s_tab, $pr_key . $info->{$ex}{$video_id}{$key} );
            $text =~ s/\R+\z//;
            push @$print_array, map { "$_\n" } split /\R+/, $text;
        }
    }
    if ( @$print_array > ( $maxrows - 6 ) ) {
        $col_max = $maxcols;
        $lf->config( 'ColMax', $col_max );
        $print_array = [];
        for my $key ( @keys ) {
            next if ! length $info->{$ex}{$video_id}{$key};
            ( my $kk = $key ) =~ s/_/ /g;
            my $pr_key = sprintf "%*.*s : ", $key_len, $key_len, $kk;
            my $text = $lf->fold( '' , ' ' x $s_tab, $pr_key . $info->{$ex}{$video_id}{$key} );
            $text =~ s/\R+\z//;
            push @$print_array, map { "$_\n" } split /\R+/, $text;
        }
    }
    return $print_array;
}





1;


__END__
