#!/usr/bin/perl
# -*- cperl -*-

sub taint {use Taint (); for(@_){Taint::taint($_) if defined $_} return @_;}

sub assembledatetime {
  my ($basename, $inputhash, $timezone, $cleanup) = @_;
  if ($timezone =~ m/^field:\s*(\w+)$/i) {
    my $tzfield = $1;
    $timezone = $$inputhash{$timezone};
  }
  $timezone ||= 'America/New_York';
  my $dt = DateTime->new(
                         time_zone => $timezone,
                         year      => ($$inputhash{$basename . 'year'}   || 1974),
                         month     => ($$inputhash{$basename . 'month'}  || 12),
                         day       => ($$inputhash{$basename . 'day'}    || 29),
                         hour      => ($$inputhash{$basename . 'hour'}   || 0),
                         minute    => ($$inputhash{$basename . 'minute'} || 0),
                         second    => ($$inputhash{$basename . 'second'} || 0),
                        );
  if ($cleanup) {
    delete $$inputhash{$basename . $_} for qw(year month day hour minute second);
    # Note that the timezone field is NOT deleted, as it might be used
    # for multiple date/time assemblages.
  }
  return $dt;
}

sub getforminput {
  my ($num_bytes, $bytesread, $formdata, $name, $value, $boundary, $part, $parts, $partdebug, $partname);
  my (%head, %val, $headers, $h, %disposition, $content_disposition, $t, %partdata, %content_type);
  $num_bytes=$ENV{'CONTENT_LENGTH'};
  if ($num_bytes > 0) {
    $bytesread = read (STDIN, $formdata, $num_bytes);
  } else {
    $formdata=$ENV{'QUERY_STRING'};
  }
  if ($ENV{'CONTENT_TYPE'}=~/multipart\/form-data.*boundary=(.+?)$/) {
	$boundary=$1; taint($boundary);
	foreach $part (split /--$boundary/, $formdata) {
      taint($part);
	  if ($main::debug) {
		$parts++;
		$partdebug.="<li><pre>$part</pre></li>";
	  }
	  $partname="";

      ($headers, $value) = $part =~ /^(.*?)\n\s?\n(.*)$/s;
      ($head{$parts}, $val{$parts}) = taint($headers, $value);

	  foreach $h (split (/\n/, $headers)) {
        if ($h =~ /Content-Disposition: ([^;]+); (.*?)$/) {
		  taint(($content_disposition, $t)=($1,$2));
		  foreach $_ (split /; /, $t) {
            if (/^name=(.*?)$/) {
              $partname=$1; $partname=~s/\"//g; taint($partname);
              $disposition{$partname}=$content_disposition;
            } elsif (/^([^=]+)=([^=]+?)$/) {
              my ($n, $v) = ($1, $2); taint($n, $v);
              $partdata{$partname}{$n}=$v;
            } elsif ($main::debug>2) {
			  $main::dribble .= "<li>[Unrecognised name/value pair on content disposition line] <code>$_</code></li>\n";
            }
          }
        } elsif ($h=~/^Content-Type: (.*?)$/) {
          my $ctpn = $1;
          $content_type{$partname}=taint($ctpn);
		} elsif ($main::debug>2) {
		  $main::dribble .= "<li>[Unrecognised header] <pre>$h</pre></li>\n";
		}
	  }
        $main::input{$partname}=$value;
	}
  } else {
	foreach (split /&/, $formdata) {
      # Reverse the encoding generated by the browser for the CGI interface:
	  s/\+/ /g; # Decode spaces
	  ($name, $value) = split(/=/, $_);
	  $name =~ s/%(..)/pack("c",hex($1))/ge;  # These lines reverse the %nn encodings
	  $value =~ s/%(..)/pack("c",hex($1))/ge; # cgi does for punctuation marks and such.
      taint($name, $value);
      if (exists $main::input{$name}) {
        $main::input{$name} .= ",$value";
        # Yes, this means that if you have multiple inputs with the
        # same name (e.g., checkboxen) you dursn't have commas within
        # any of the possible values.
      } else {
        $main::input{$name}=$value;
      }
	}
  }
  if ($main::input{magicdate} eq 'today') {
    use DateTime;
    my $now = DateTime->now(
                            'time_zone' => 'America/New_York',
                            );
    $main::input{year}  = $now->year();
    $main::input{month} = $now->month();
    $main::input{mday}  = $now->mday();
  }
  if ($main::input{magicdate} eq 'monthataglance') {
    use DateTime;
    my $dt = DateTime->new(
                           year  => $main::input{year},
                           month => $main::input{month},
                           day   => 1,
                          );
    $dt = $dt->add(months => 1);
    $dt = $dt->subtract(days => 1);
    $main::input{mday} = join ",", 1.. $dt->mday();
  }
  if ($formdata) {
    return \%main::input;
  } else {
    return undef;
  }
}

1;
