#!/usr/bin/perl -w
use strict;
use WWW::Mechanize;
use WWW::Mechanize::FormFiller;
use URI::URL;
use HTML::TableExtract;

my $agent = WWW::Mechanize->new( autocheck => 1 );
my $formfiller = WWW::Mechanize::FormFiller->new();
$agent->env_proxy();

$agent->get('https://onlinebanking.norisbank.de/login/login.jsp');
$agent->form(1) if $agent->forms and scalar @{$agent->forms};
$agent->form_name('login');
#  { local $^W; $agent->current_form->value('kontonummer', '7967197003'); };
$agent->current_form->value('kontonummer', '7967197003');
#  { local $^W; $agent->current_form->value('pin', '46613'); };
$agent->current_form->value('pin', '46613');
$agent->submit();

# logged in 

$agent->follow('1');  # mainFrame 
$agent->follow('Auswahl Girokonten') or
  die "Couldn't follow Auswahl Girokonten link after login... ";

$agent->follow('1'); #  mainFrame
$agent->follow('Umsatzauskunft');

$agent->follow('1'); #  mainFrame
$agent->follow('2');
$agent->form_number(1);
$agent->current_form->value('datumvon', '01.06');
$agent->current_form->value('datumbis', '22.06');
$agent->click('');
$agent->follow(1);
$agent->follow(1);

my $html = $agent->content;

# ACTUAL DATA -- current. 

my $te = new HTML::TableExtract(depth=>1, count=>0);
$te->parse($html);

foreach my $ts ($te->table_states) {
  my $rownum=0;
  foreach my $row ($ts->rows) {
	print "----- $rownum\n";
	my ($date, $posted, $desc, $value, $bal) = @$row;
	$date   =~ tr/\xA0\n //d;
	$posted =~ tr/\xA0\n //d;
	$value = cleannum($value);
	$bal   = cleannum($bal);
	
	$desc   =~ s/\xA0/<nbsp>/sg;
	$desc   =~ s/\n/<newline>/sg;

	print "$date, $posted, $desc, $value, $bal\n";

#	my $colnum=0;
#	foreach my $col (@$row) {
#	  print "$colnum: $col\n";
#	  $colnum++;
#	}

	$rownum++;
  }
}

# Converts a number, in german notation, with possible garbage,
# into something that looks like a perl-OK number.
sub cleannum {
  local $_=shift;
  tr/,./.,/;
  tr/0-9.-//cd;
  return $_;
}

# Converts a date, in MM.DD.YYYY, with the year part two digits, four
# digits, or not present.  If not present, it will be disambiguated
# with the $yearfrom, if given, or the current year, if not given.
# $yearfrom should be a unix time.
# Output is the unix time.
sub cleandate {
  my ($date, $yearfrom)=@_;
  $yearfrom ||= time;
  
  $date =~ tr|-/|..|;
  $date =~ tr|0-9.||cd;

  print "# $date\n";
  my($day,$month,$year)=split /\./, $date;
  $year ||= (gmtime($yearfrom))[5];
  
  local $ENV{TZ} = 'MET';
  
}
