package Paws::SES::TrackingOptions;
  use Moose;
  has CustomRedirectDomain => (is => 'ro', isa => 'Str');
1;

### main pod documentation begin ###

=head1 NAME

Paws::SES::TrackingOptions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SES::TrackingOptions object:

  $service_obj->Method(Att1 => { CustomRedirectDomain => $value, ..., CustomRedirectDomain => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SES::TrackingOptions object:

  $result = $service_obj->Method(...);
  $result->Att1->CustomRedirectDomain

=head1 DESCRIPTION

A domain that is used to redirect email recipients to an Amazon
SES-operated domain. This domain captures open and click events
generated by Amazon SES emails.

For more information, see Configuring Custom Domains to Handle Open and
Click Tracking in the I<Amazon SES Developer Guide>.

=head1 ATTRIBUTES


=head2 CustomRedirectDomain => Str

  The custom subdomain that will be used to redirect email recipients to
the Amazon SES event tracking domain.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SES>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

