=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Mk - Package for language Macedonian

=cut

package Locale::CLDR::Locales::Mk;
# This file auto generated from Data\common\main\mk.xml
#	on Wed 28 Feb 12:16:00 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
    is => 'ro',
    isa => ArrayRef,
    init_arg => undef,
    default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal-masculine','spellout-cardinal-neuter','spellout-cardinal-feminine' ]},
);

has 'algorithmic_number_format_data' => (
    is => 'ro',
    isa => HashRef,
    init_arg => undef,
    default => sub {
        use bigfloat;
        return {
		'spellout-cardinal-feminine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(една),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(две),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(дваесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(триесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четириесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шеесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седумдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осумдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← илјада[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милијарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← билион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← билијарда[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-masculine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(еден),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(два),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(три),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(четири),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(пет),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(шест),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(седум),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(осум),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(девет),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(десет),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(единаесет),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(дванаесет),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(тринаесет),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(четиринаесет),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(петнаесет),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(шеснаесет),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(седумнаесет),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(осумнаесет),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(деветнаесет),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(дваесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(триесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четириесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шеесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седумдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осумдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← илјада[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милијарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← билион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← билијарда[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-neuter' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(едно),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(два),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(дваесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(триесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четириесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шеесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седумдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осумдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← илјада[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милијарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← билион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← билијарда[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
			},
		},
    } },
);

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'афарски',
 				'ab' => 'апхаски',
 				'ace' => 'ачешки',
 				'ach' => 'аколи',
 				'ada' => 'адангме',
 				'ady' => 'адигејски',
 				'ae' => 'авестански',
 				'aeb' => 'туниски арапски',
 				'af' => 'африканс',
 				'afh' => 'африхили',
 				'agq' => 'агемски',
 				'ain' => 'ајну',
 				'ak' => 'акански',
 				'akk' => 'акадски',
 				'akz' => 'алабамски',
 				'ale' => 'алеутски',
 				'aln' => 'гешки албански',
 				'alt' => 'јужноалтајски',
 				'am' => 'амхарски',
 				'an' => 'арагонски',
 				'ang' => 'староанглиски',
 				'ann' => 'оболо',
 				'anp' => 'ангика',
 				'ar' => 'арапски',
 				'ar_001' => 'современ стандардизиран арапски',
 				'arc' => 'арамејски',
 				'arn' => 'мапучки',
 				'aro' => 'араона',
 				'arp' => 'арапахо',
 				'arq' => 'алжирски арапски',
 				'ars' => 'неџдиски арапски',
 				'arw' => 'аравачки',
 				'ary' => 'марокански арапски',
 				'arz' => 'египетски арапски',
 				'as' => 'асамски',
 				'asa' => 'асу',
 				'ase' => 'американски знаковен јазик',
 				'ast' => 'астурски',
 				'atj' => 'атикамек',
 				'av' => 'аварски',
 				'avk' => 'котава',
 				'awa' => 'авади',
 				'ay' => 'ајмарски',
 				'az' => 'азербејџански',
 				'az@alt=short' => 'азерски',
 				'ba' => 'башкирски',
 				'bal' => 'белуџиски',
 				'ban' => 'балиски',
 				'bar' => 'баварски',
 				'bas' => 'баса',
 				'bax' => 'бамунски',
 				'bbc' => 'тоба',
 				'bbj' => 'гомала',
 				'be' => 'белоруски',
 				'bej' => 'беџа',
 				'bem' => 'бемба',
 				'bew' => 'бетавски',
 				'bez' => 'бена',
 				'bfd' => 'бафут',
 				'bfq' => 'бадага',
 				'bg' => 'бугарски',
 				'bgc' => 'харијанви',
 				'bgn' => 'западен балочи',
 				'bho' => 'боџпури',
 				'bi' => 'бислама',
 				'bik' => 'биколски',
 				'bin' => 'бини',
 				'bjn' => 'банџарски',
 				'bkm' => 'ком',
 				'bla' => 'сиксика',
 				'bm' => 'бамбара',
 				'bn' => 'бенгалски',
 				'bo' => 'тибетски',
 				'bpy' => 'бишнуприја',
 				'bqi' => 'бахтијарски',
 				'br' => 'бретонски',
 				'bra' => 'брај',
 				'brh' => 'брахујски',
 				'brx' => 'бодо',
 				'bs' => 'босански',
 				'bss' => 'акосе',
 				'bua' => 'бурјатски',
 				'bug' => 'бугиски',
 				'bum' => 'булу',
 				'byn' => 'биленски',
 				'byv' => 'медумба',
 				'ca' => 'каталонски',
 				'cad' => 'кадо',
 				'car' => 'карипски',
 				'cay' => 'кајуга',
 				'cch' => 'ацам',
 				'ccp' => 'чакмански',
 				'ce' => 'чеченски',
 				'ceb' => 'себуански',
 				'cgg' => 'чига',
 				'ch' => 'чаморски',
 				'chb' => 'чибча',
 				'chg' => 'чагатајски',
 				'chk' => 'чучки',
 				'chm' => 'мариски',
 				'chn' => 'чинучки жаргон',
 				'cho' => 'чоктавски',
 				'chp' => 'чипевјански',
 				'chr' => 'чероки',
 				'chy' => 'чејенски',
 				'ckb' => 'централнокурдски',
 				'ckb@alt=menu' => 'курдски, централен',
 				'ckb@alt=variant' => 'курдски, сорани',
 				'clc' => 'чилкотински',
 				'co' => 'корзикански',
 				'cop' => 'коптски',
 				'cps' => 'капизнон',
 				'cr' => 'кри',
 				'crg' => 'мичиф',
 				'crh' => 'кримскотурски',
 				'crj' => 'југоисточен кријски',
 				'crk' => 'прериски кријски',
 				'crl' => 'североисточен кријски',
 				'crm' => 'лосовски кријски',
 				'crr' => 'каролински алгонкински',
 				'crs' => 'француски (Сеселва креоли)',
 				'cs' => 'чешки',
 				'csb' => 'кашупски',
 				'csw' => 'мочуришен кријски',
 				'cu' => 'црковнословенски',
 				'cv' => 'чувашки',
 				'cy' => 'велшки',
 				'da' => 'дански',
 				'dak' => 'дакота',
 				'dar' => 'даргва',
 				'dav' => 'таита',
 				'de' => 'германски',
 				'de_AT' => 'австриски германски',
 				'de_CH' => 'швајцарски горногермански',
 				'del' => 'делавер',
 				'den' => 'слејви',
 				'dgr' => 'догрипски',
 				'din' => 'динка',
 				'dje' => 'зарма',
 				'doi' => 'догри',
 				'dsb' => 'долнолужички',
 				'dtp' => 'дусунски',
 				'dua' => 'дуала',
 				'dum' => 'среднохоландски',
 				'dv' => 'дивехи',
 				'dyo' => 'јола-фоњи',
 				'dyu' => 'џула',
 				'dz' => 'ѕонгка',
 				'dzg' => 'дазага',
 				'ebu' => 'ембу',
 				'ee' => 'еве',
 				'efi' => 'ефик',
 				'egl' => 'емилијански',
 				'egy' => 'староегипетски',
 				'eka' => 'екаџук',
 				'el' => 'грчки',
 				'elx' => 'еламски',
 				'en' => 'англиски',
 				'en_AU' => 'австралиски англиски',
 				'en_CA' => 'канадски англиски',
 				'en_GB' => 'британски англиски',
 				'en_GB@alt=short' => 'англиски (ОК)',
 				'en_US' => 'американски англиски',
 				'en_US@alt=short' => 'англиски (САД)',
 				'enm' => 'средноанглиски',
 				'eo' => 'есперанто',
 				'es' => 'шпански',
 				'es_419' => 'латиноамерикански шпански',
 				'es_ES' => 'шпански (Европа)',
 				'es_MX' => 'мексикански шпански',
 				'esu' => 'централнојупички',
 				'et' => 'естонски',
 				'eu' => 'баскиски',
 				'ewo' => 'евондо',
 				'ext' => 'екстремадурски',
 				'fa' => 'персиски',
 				'fa_AF' => 'дари',
 				'fan' => 'фанг',
 				'fat' => 'фанти',
 				'ff' => 'фула',
 				'fi' => 'фински',
 				'fil' => 'филипински',
 				'fit' => 'турнедаленски фински',
 				'fj' => 'фиџиски',
 				'fo' => 'фарски',
 				'fon' => 'фон',
 				'fr' => 'француски',
 				'fr_CA' => 'канадски француски',
 				'fr_CH' => 'швајцарски француски',
 				'frc' => 'каџунски француски',
 				'frm' => 'среднофранцуски',
 				'fro' => 'старофранцуски',
 				'frp' => 'франкопровансалски',
 				'frr' => 'севернофризиски',
 				'frs' => 'источнофризиски',
 				'fur' => 'фурлански',
 				'fy' => 'западнофризиски',
 				'ga' => 'ирски',
 				'gaa' => 'га',
 				'gag' => 'гагауски',
 				'gan' => 'ган',
 				'gay' => 'гајо',
 				'gba' => 'гбаја',
 				'gbz' => 'зороастриски дари',
 				'gd' => 'шкотски гелски',
 				'gez' => 'гиз',
 				'gil' => 'гилбертански',
 				'gl' => 'галициски',
 				'glk' => 'гилански',
 				'gmh' => 'средногорногермански',
 				'gn' => 'гварански',
 				'goh' => 'старогорногермански',
 				'gom' => 'гоански конкани',
 				'gon' => 'гонди',
 				'gor' => 'горонтало',
 				'got' => 'готски',
 				'grb' => 'гребо',
 				'grc' => 'старогрчки',
 				'gsw' => 'швајцарски германски',
 				'gu' => 'гуџарати',
 				'guc' => 'гвахиро',
 				'gur' => 'фарефаре',
 				'guz' => 'гуси',
 				'gv' => 'манкс',
 				'gwi' => 'гвичински',
 				'ha' => 'хауса',
 				'hai' => 'хајда',
 				'hak' => 'хака',
 				'haw' => 'хавајски',
 				'hax' => 'јужен хајда',
 				'he' => 'хебрејски',
 				'hi' => 'хинди',
 				'hi_Latn@alt=variant' => 'хинди англиски',
 				'hif' => 'фиџиски хинди',
 				'hil' => 'хилигајнонски',
 				'hit' => 'хетитски',
 				'hmn' => 'хмонг',
 				'ho' => 'хири моту',
 				'hr' => 'хрватски',
 				'hsb' => 'горнолужички',
 				'hsn' => 'сјанг',
 				'ht' => 'хаитски',
 				'hu' => 'унгарски',
 				'hup' => 'хупа',
 				'hur' => 'халкомелем',
 				'hy' => 'ерменски',
 				'hz' => 'хереро',
 				'ia' => 'интерлингва',
 				'iba' => 'ибан',
 				'ibb' => 'ибибио',
 				'id' => 'индонезиски',
 				'ie' => 'окцидентал',
 				'ig' => 'игбо',
 				'ii' => 'сичуан ји',
 				'ik' => 'инупијачки',
 				'ikt' => 'западноканадски инуктитут',
 				'ilo' => 'илокански',
 				'inh' => 'ингушки',
 				'io' => 'идо',
 				'is' => 'исландски',
 				'it' => 'италијански',
 				'iu' => 'инуктитут',
 				'izh' => 'ижорски',
 				'ja' => 'јапонски',
 				'jam' => 'јамајски креолски',
 				'jbo' => 'ложбан',
 				'jgo' => 'нгомба',
 				'jmc' => 'мачаме',
 				'jpr' => 'еврејскоперсиски',
 				'jrb' => 'еврејскоарапски',
 				'jut' => 'јитски',
 				'jv' => 'јавански',
 				'ka' => 'грузиски',
 				'kaa' => 'каракалпачки',
 				'kab' => 'кабилски',
 				'kac' => 'качински',
 				'kaj' => 'каџе',
 				'kam' => 'камба',
 				'kaw' => 'кави',
 				'kbd' => 'кабардински',
 				'kbl' => 'канембу',
 				'kcg' => 'тјап',
 				'kde' => 'маконде',
 				'kea' => 'кабувердиану',
 				'ken' => 'кењанг',
 				'kfo' => 'коро',
 				'kg' => 'конго',
 				'kgp' => 'каинганшки',
 				'kha' => 'каси',
 				'kho' => 'хотански',
 				'khq' => 'којра чиини',
 				'khw' => 'коварски',
 				'ki' => 'кикују',
 				'kiu' => 'зазаки',
 				'kj' => 'квањама',
 				'kk' => 'казашки',
 				'kkj' => 'како',
 				'kl' => 'калалисут',
 				'kln' => 'каленџин',
 				'km' => 'кмерски',
 				'kmb' => 'кимбунду',
 				'kn' => 'каннада',
 				'ko' => 'корејски',
 				'koi' => 'коми-пермјачки',
 				'kok' => 'конкани',
 				'kos' => 'козрејски',
 				'kpe' => 'кпеле',
 				'kr' => 'канури',
 				'krc' => 'карачаевско-балкарски',
 				'kri' => 'крио',
 				'krj' => 'кинарајски',
 				'krl' => 'карелски',
 				'kru' => 'курух',
 				'ks' => 'кашмирски',
 				'ksb' => 'шамбала',
 				'ksf' => 'бафија',
 				'ksh' => 'колоњски',
 				'ku' => 'курдски',
 				'kum' => 'кумички',
 				'kut' => 'кутенајски',
 				'kv' => 'коми',
 				'kw' => 'корнски',
 				'kwk' => 'кваквала',
 				'ky' => 'киргиски',
 				'la' => 'латински',
 				'lad' => 'ладино',
 				'lag' => 'ланги',
 				'lah' => 'ланда',
 				'lam' => 'ламба',
 				'lb' => 'луксембуршки',
 				'lez' => 'лезгински',
 				'lfn' => 'лингва франка нова',
 				'lg' => 'ганда',
 				'li' => 'лимбуршки',
 				'lij' => 'лигурски',
 				'lil' => 'лилуетски',
 				'liv' => 'ливонски',
 				'lkt' => 'лакотски',
 				'lmo' => 'ломбардиски',
 				'ln' => 'лингала',
 				'lo' => 'лаошки',
 				'lol' => 'монго',
 				'lou' => 'луизијански креолски',
 				'loz' => 'лози',
 				'lrc' => 'севернолуриски',
 				'lsm' => 'самиски',
 				'lt' => 'литвански',
 				'ltg' => 'латгалски',
 				'lu' => 'луба-катанга',
 				'lua' => 'луба-лулуа',
 				'lui' => 'лујсењски',
 				'lun' => 'лунда',
 				'luo' => 'луо',
 				'lus' => 'мизо',
 				'luy' => 'луја',
 				'lv' => 'латвиски',
 				'lzh' => 'книжевен кинески',
 				'lzz' => 'ласки',
 				'mad' => 'мадурски',
 				'maf' => 'мафа',
 				'mag' => 'магахи',
 				'mai' => 'маитили',
 				'mak' => 'макасарски',
 				'man' => 'мандинго',
 				'mas' => 'масајски',
 				'mde' => 'маба',
 				'mdf' => 'мокшански',
 				'mdr' => 'мандарски',
 				'men' => 'менде',
 				'mer' => 'меру',
 				'mfe' => 'морисјен',
 				'mg' => 'малгашки',
 				'mga' => 'средноирски',
 				'mgh' => 'макува-мито',
 				'mgo' => 'мета',
 				'mh' => 'маршалски',
 				'mi' => 'маорски',
 				'mic' => 'микмак',
 				'min' => 'минангкабау',
 				'mk' => 'македонски',
 				'ml' => 'малајалски',
 				'mn' => 'монголски',
 				'mnc' => 'манџурски',
 				'mni' => 'манипурски',
 				'moe' => 'ину-аимунски',
 				'moh' => 'мохавски',
 				'mos' => 'моси',
 				'mr' => 'марати',
 				'mrj' => 'западномариски',
 				'ms' => 'малајски',
 				'mt' => 'малтешки',
 				'mua' => 'мунданг',
 				'mul' => 'повеќе јазици',
 				'mus' => 'крик',
 				'mwl' => 'мирандски',
 				'mwr' => 'марвари',
 				'my' => 'бурмански',
 				'mye' => 'мјене',
 				'myv' => 'ерзјански',
 				'mzn' => 'мазендерански',
 				'na' => 'науруански',
 				'nan' => 'јужномински',
 				'nap' => 'неаполски',
 				'naq' => 'нама',
 				'nb' => 'норвешки букмол',
 				'nd' => 'северен ндебеле',
 				'nds' => 'долногермански',
 				'nds_NL' => 'долносаксонски',
 				'ne' => 'непалски',
 				'new' => 'неварски',
 				'ng' => 'ндонга',
 				'nia' => 'нијас',
 				'niu' => 'ниујески',
 				'njo' => 'ао нага',
 				'nl' => 'холандски',
 				'nl_BE' => 'фламански',
 				'nmg' => 'квазио',
 				'nn' => 'норвешки нинорск',
 				'nnh' => 'нгиембун',
 				'no' => 'норвешки',
 				'nog' => 'ногајски',
 				'non' => 'старонордиски',
 				'nov' => 'новијал',
 				'nqo' => 'нко',
 				'nr' => 'јужен ндебеле',
 				'nso' => 'северносотски',
 				'nus' => 'нуер',
 				'nv' => 'навахо',
 				'nwc' => 'класичен неварски',
 				'ny' => 'њанџа',
 				'nym' => 'њамвези',
 				'nyn' => 'њанколе',
 				'nyo' => 'њоро',
 				'nzi' => 'нзима',
 				'oc' => 'окситански',
 				'oj' => 'оџибва',
 				'ojb' => 'северозападен оџибва',
 				'ojc' => 'централен оџибва',
 				'ojs' => 'очиски кријски',
 				'ojw' => 'западен оџибва',
 				'oka' => 'оканагански',
 				'om' => 'оромо',
 				'or' => 'одија',
 				'os' => 'осетски',
 				'osa' => 'осашки',
 				'ota' => 'отомански турски',
 				'pa' => 'пенџапски',
 				'pag' => 'пангасинански',
 				'pal' => 'средноперсиски',
 				'pam' => 'пампанга',
 				'pap' => 'папијаменто',
 				'pau' => 'палауански',
 				'pcd' => 'пикардски',
 				'pcm' => 'нигериски пиџин',
 				'pdc' => 'пенсилваниски германски',
 				'pdt' => 'менонитски долногермански',
 				'peo' => 'староперсиски',
 				'pfl' => 'фалечкогермански',
 				'phn' => 'феникиски',
 				'pi' => 'пали',
 				'pis' => 'пиџин',
 				'pl' => 'полски',
 				'pms' => 'пиемонтски',
 				'pnt' => 'понтски',
 				'pon' => 'понпејски',
 				'pqm' => 'малиситски пасамакводски',
 				'prg' => 'пруски',
 				'pro' => 'старопровансалски',
 				'ps' => 'паштунски',
 				'pt' => 'португалски',
 				'pt_BR' => 'бразилски португалски',
 				'pt_PT' => 'португалски (Европа)',
 				'qu' => 'кечуански',
 				'quc' => 'киче',
 				'qug' => 'кичвански',
 				'raj' => 'раџастански',
 				'rap' => 'рапанујски',
 				'rar' => 'раротонгански',
 				'rgn' => 'ромањолски',
 				'rhg' => 'рохиншки',
 				'rif' => 'рифски',
 				'rm' => 'реторомански',
 				'rn' => 'рунди',
 				'ro' => 'романски',
 				'ro_MD' => 'молдавски',
 				'rof' => 'ромбо',
 				'rom' => 'ромски',
 				'rtm' => 'ротумански',
 				'ru' => 'руски',
 				'rue' => 'русински',
 				'rug' => 'ровијански',
 				'rup' => 'влашки',
 				'rw' => 'руандски',
 				'rwk' => 'руа',
 				'sa' => 'санскрит',
 				'sad' => 'сандаве',
 				'sah' => 'јакутски',
 				'sam' => 'самарјански арамејски',
 				'saq' => 'самбуру',
 				'sas' => 'сасачки',
 				'sat' => 'сантали',
 				'saz' => 'саураштра',
 				'sba' => 'нгембеј',
 				'sbp' => 'сангу',
 				'sc' => 'сардински',
 				'scn' => 'сицилијански',
 				'sco' => 'шкотски германски',
 				'sd' => 'синди',
 				'sdc' => 'сасарски сардински',
 				'sdh' => 'јужнокурдски',
 				'se' => 'северен сами',
 				'see' => 'сенека',
 				'seh' => 'сена',
 				'sei' => 'сери',
 				'sel' => 'селкупски',
 				'ses' => 'којраборо сени',
 				'sg' => 'санго',
 				'sga' => 'староирски',
 				'sgs' => 'самогитски',
 				'sh' => 'српскохрватски',
 				'shi' => 'тачелхит',
 				'shn' => 'шан',
 				'shu' => 'чадски арапски',
 				'si' => 'синхалски',
 				'sid' => 'сидамо',
 				'sk' => 'словачки',
 				'sl' => 'словенечки',
 				'slh' => 'јужен лушуцид',
 				'sli' => 'долношлезиски',
 				'sly' => 'селајарски',
 				'sm' => 'самоански',
 				'sma' => 'јужен сами',
 				'smj' => 'луле сами',
 				'smn' => 'инариски сами',
 				'sms' => 'сколт сами',
 				'sn' => 'шона',
 				'snk' => 'сонинке',
 				'so' => 'сомалиски',
 				'sog' => 'зогдијански',
 				'sq' => 'албански',
 				'sr' => 'српски',
 				'srn' => 'срански тонго',
 				'srr' => 'серер',
 				'ss' => 'свати',
 				'ssy' => 'сахо',
 				'st' => 'сесото',
 				'stq' => 'затерландски фризиски',
 				'str' => 'салишки (Северен Теснец)',
 				'su' => 'сундски',
 				'suk' => 'сукума',
 				'sus' => 'сусу',
 				'sux' => 'сумерски',
 				'sv' => 'шведски',
 				'sw' => 'свахили',
 				'sw_CD' => 'конгоански свахили',
 				'swb' => 'коморијански',
 				'syc' => 'класичен сириски',
 				'syr' => 'сириски',
 				'szl' => 'шлезиски',
 				'ta' => 'тамилски',
 				'tce' => 'јужнотучонски',
 				'tcy' => 'тулу',
 				'te' => 'телугу',
 				'tem' => 'тимне',
 				'teo' => 'тесо',
 				'ter' => 'терено',
 				'tet' => 'тетум',
 				'tg' => 'таџикистански',
 				'tgx' => 'тагишки',
 				'th' => 'тајландски',
 				'tht' => 'талтански',
 				'ti' => 'тигриња',
 				'tig' => 'тигре',
 				'tiv' => 'тив',
 				'tk' => 'туркменски',
 				'tkl' => 'токелауански',
 				'tkr' => 'цахурски',
 				'tl' => 'тагалог',
 				'tlh' => 'клингонски',
 				'tli' => 'тлингит',
 				'tly' => 'талишки',
 				'tmh' => 'тамашек',
 				'tn' => 'цвана',
 				'to' => 'тонгајски',
 				'tog' => 'њаса тонга',
 				'tok' => 'токи пона',
 				'tpi' => 'ток писин',
 				'tr' => 'турски',
 				'tru' => 'туројо',
 				'trv' => 'тароко',
 				'ts' => 'цонга',
 				'tsd' => 'цаконски',
 				'tsi' => 'цимшијански',
 				'tt' => 'татарски',
 				'ttm' => 'севернотучонски',
 				'ttt' => 'татски',
 				'tum' => 'тумбука',
 				'tvl' => 'тувалуански',
 				'tw' => 'тви',
 				'twq' => 'тазавак',
 				'ty' => 'тахитски',
 				'tyv' => 'тувански',
 				'tzm' => 'централноатлански тамазитски',
 				'udm' => 'удмуртски',
 				'ug' => 'ујгурски',
 				'uga' => 'угаритски',
 				'uk' => 'украински',
 				'umb' => 'умбунду',
 				'und' => 'непознат јазик',
 				'ur' => 'урду',
 				'uz' => 'узбечки',
 				'vai' => 'вај',
 				've' => 'венда',
 				'vec' => 'венетски',
 				'vep' => 'вепшки',
 				'vi' => 'виетнамски',
 				'vls' => 'западнофламански',
 				'vmf' => 'мајнскофранконски',
 				'vo' => 'волапик',
 				'vot' => 'вотски',
 				'vro' => 'виру',
 				'vun' => 'вунџо',
 				'wa' => 'валонски',
 				'wae' => 'валсер',
 				'wal' => 'воламо',
 				'war' => 'варајски',
 				'was' => 'вашо',
 				'wbp' => 'варлпири',
 				'wo' => 'волофски',
 				'wuu' => 'ву',
 				'xal' => 'калмички',
 				'xh' => 'коса',
 				'xmf' => 'мегрелски',
 				'xog' => 'сога',
 				'yao' => 'јао',
 				'yap' => 'јапски',
 				'yav' => 'јенгбен',
 				'ybb' => 'јемба',
 				'yi' => 'јидиш',
 				'yo' => 'јорупски',
 				'yrl' => 'њенгату',
 				'yue' => 'кантонски',
 				'yue@alt=menu' => 'кантонски кинески',
 				'za' => 'џуаншки',
 				'zap' => 'запотечки',
 				'zbl' => 'блиссимболи',
 				'zea' => 'зеландски',
 				'zen' => 'зенага',
 				'zgh' => 'стандарден марокански тамазитски',
 				'zh' => 'кинески',
 				'zh@alt=menu' => 'мандарински кинески',
 				'zh_Hans' => 'поедноставен кинески',
 				'zh_Hans@alt=long' => 'поедноставен мандарински',
 				'zh_Hant' => 'традиционален кинески',
 				'zh_Hant@alt=long' => 'традиционален мандарински',
 				'zu' => 'зулу',
 				'zun' => 'зуни',
 				'zxx' => 'без лингвистичка содржина',
 				'zza' => 'заза',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'адламско',
 			'Afak' => 'афака',
 			'Aghb' => 'кавкаскоалбански',
 			'Arab' => 'арапско писмо',
 			'Aran' => 'насталик',
 			'Armi' => 'царскоарамејски',
 			'Armn' => 'ерменско писмо',
 			'Avst' => 'авестанско',
 			'Bali' => 'балиско',
 			'Bamu' => 'бамумско',
 			'Bass' => 'баса',
 			'Batk' => 'батачко',
 			'Beng' => 'бенгалско писмо',
 			'Blis' => 'блиссимболи',
 			'Bopo' => 'бопомофо',
 			'Brah' => 'брами',
 			'Brai' => 'брајово писмо',
 			'Bugi' => 'бугиско',
 			'Buhd' => 'бухидско',
 			'Cakm' => 'чакманско',
 			'Cans' => 'канадско слоговно',
 			'Cari' => 'кариско',
 			'Cham' => 'чамско',
 			'Cher' => 'черокиско',
 			'Cirt' => 'кирт',
 			'Copt' => 'коптско',
 			'Cprt' => 'кипарско',
 			'Cyrl' => 'кирилско писмо',
 			'Cyrs' => 'старословенска кирилица',
 			'Deva' => 'деванагари',
 			'Dsrt' => 'дезеретско',
 			'Dupl' => 'Диплојеево стенографско',
 			'Egyd' => 'египетско демотско',
 			'Egyh' => 'египетско хиератско',
 			'Egyp' => 'египетски хиероглифи',
 			'Elba' => 'елбасанско',
 			'Ethi' => 'етиопско писмо',
 			'Geok' => 'грузиски хуцури',
 			'Geor' => 'грузиско писмо',
 			'Glag' => 'глаголица',
 			'Goth' => 'готско',
 			'Gran' => 'гранта',
 			'Grek' => 'грчко писмо',
 			'Gujr' => 'гуџарати',
 			'Guru' => 'гурмуки',
 			'Hanb' => 'ханб',
 			'Hang' => 'хангул',
 			'Hani' => 'ханско писмо',
 			'Hano' => 'хануноовско',
 			'Hans' => 'поедноставено',
 			'Hans@alt=stand-alone' => 'поедноставено ханско писмо',
 			'Hant' => 'традиционално',
 			'Hant@alt=stand-alone' => 'традиционално ханско',
 			'Hebr' => 'хебрејско писмо',
 			'Hira' => 'хирагана',
 			'Hluw' => 'анадолски хиероглифи',
 			'Hmng' => 'пахауанско хмоншко',
 			'Hrkt' => 'јапонско слоговно',
 			'Hung' => 'староунгарско',
 			'Inds' => 'харапско',
 			'Ital' => 'староиталско',
 			'Jamo' => 'џамо',
 			'Java' => 'јаванско',
 			'Jpan' => 'јапонско писмо',
 			'Jurc' => 'џурченско',
 			'Kali' => 'каја ли',
 			'Kana' => 'катакана',
 			'Khar' => 'карошти',
 			'Khmr' => 'кмерско писмо',
 			'Khoj' => 'хоџки',
 			'Knda' => 'каннада',
 			'Kore' => 'корејско писмо',
 			'Kpel' => 'кпелско',
 			'Kthi' => 'кајти',
 			'Lana' => 'ланско',
 			'Laoo' => 'лаошко писмо',
 			'Latf' => 'фрактурна латиница',
 			'Latg' => 'гелска латиница',
 			'Latn' => 'латинично писмо',
 			'Lepc' => 'лепчанско',
 			'Limb' => 'лимбу',
 			'Lina' => 'линеарно А',
 			'Linb' => 'линеарно Б',
 			'Lisu' => 'Фрејзерово',
 			'Loma' => 'ломско',
 			'Lyci' => 'ликиско',
 			'Lydi' => 'лидиско',
 			'Mahj' => 'махаџани',
 			'Mand' => 'мандејско',
 			'Mani' => 'манихејско',
 			'Maya' => 'мајански хиероглифи',
 			'Mend' => 'мендско',
 			'Merc' => 'мероитско ракописно',
 			'Mero' => 'мероитско',
 			'Mlym' => 'малајалско писмо',
 			'Modi' => 'моди',
 			'Mong' => 'монголско писмо',
 			'Moon' => 'Муново',
 			'Mroo' => 'мро',
 			'Mtei' => 'мејтејско',
 			'Mymr' => 'мјанмарско писмо',
 			'Narb' => 'старосеверноарапско',
 			'Nbat' => 'набатејско',
 			'Nkgb' => 'насиска геба',
 			'Nkoo' => 'нко',
 			'Nshu' => 'нишу',
 			'Ogam' => 'огам',
 			'Olck' => 'ол чики',
 			'Orkh' => 'старотурско',
 			'Orya' => 'оријанско писмо',
 			'Osma' => 'сомалиско',
 			'Palm' => 'палмирско',
 			'Pauc' => 'Паучинхауово',
 			'Perm' => 'старопермско',
 			'Phag' => 'пагспа',
 			'Phli' => 'натписно средноперсиско',
 			'Phlp' => 'псалтирско средноперсиско',
 			'Phlv' => 'книжевно староперсиско',
 			'Phnx' => 'феникиско',
 			'Plrd' => 'Полардово',
 			'Prti' => 'натписно партиско',
 			'Rjng' => 'реџаншко',
 			'Rohg' => 'ханифи',
 			'Roro' => 'ронгоронго',
 			'Runr' => 'рунско',
 			'Samr' => 'самарјанско',
 			'Sara' => 'сарати',
 			'Sarb' => 'старојужноарапско',
 			'Saur' => 'саураштранско',
 			'Sgnw' => 'знаковно пишување',
 			'Shaw' => 'Шоово',
 			'Shrd' => 'шарада',
 			'Sidd' => 'сидам',
 			'Sind' => 'кудабади',
 			'Sinh' => 'синхалско писмо',
 			'Sora' => 'соранг сомпенг',
 			'Sund' => 'сунданско',
 			'Sylo' => 'силхетско нагари',
 			'Syrc' => 'сириско',
 			'Syre' => 'естрангелско сириско',
 			'Syrj' => 'западносириско',
 			'Syrn' => 'источносириско',
 			'Tagb' => 'тагбанванско',
 			'Takr' => 'такри',
 			'Tale' => 'тај ле',
 			'Talu' => 'ново тај луе',
 			'Taml' => 'тамилско писмо',
 			'Tang' => 'тангутско',
 			'Tavt' => 'тај вјет',
 			'Telu' => 'телугу',
 			'Teng' => 'тенгвар',
 			'Tfng' => 'тифинаг',
 			'Tglg' => 'тагалошко',
 			'Thaa' => 'тана',
 			'Thai' => 'тајландско писмо',
 			'Tibt' => 'тибетско писмо',
 			'Tirh' => 'тирхута',
 			'Ugar' => 'угаритско',
 			'Vaii' => 'вај',
 			'Visp' => 'видлив говор',
 			'Wara' => 'варанг кшити',
 			'Wole' => 'волеајско',
 			'Xpeo' => 'староперсиско',
 			'Xsux' => 'сумероакадско клинесто',
 			'Yiii' => 'ји',
 			'Zinh' => 'наследено',
 			'Zmth' => 'математичка нотација',
 			'Zsye' => 'емоџи',
 			'Zsym' => 'симболи',
 			'Zxxx' => 'без писмо',
 			'Zyyy' => 'општо',
 			'Zzzz' => 'непознато писмо',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'Свет',
 			'002' => 'Африка',
 			'003' => 'Северна Америка',
 			'005' => 'Јужна Америка',
 			'009' => 'Океанија',
 			'011' => 'Западна Африка',
 			'013' => 'Централна Америка',
 			'014' => 'Источна Африка',
 			'015' => 'Северна Африка',
 			'017' => 'Средна Африка',
 			'018' => 'Јужна Африка',
 			'019' => 'Америки',
 			'021' => 'Северна континентална Америка',
 			'029' => 'Кариби',
 			'030' => 'Источна Азија',
 			'034' => 'Јужна Азија',
 			'035' => 'Југоисточна Азија',
 			'039' => 'Јужна Европа',
 			'053' => 'Австралазија',
 			'054' => 'Меланезија',
 			'057' => 'Микронезиски регион',
 			'061' => 'Полинезија',
 			'142' => 'Азија',
 			'143' => 'Централна Азија',
 			'145' => 'Западна Азија',
 			'150' => 'Европа',
 			'151' => 'Источна Европа',
 			'154' => 'Северна Европа',
 			'155' => 'Западна Европа',
 			'202' => 'Супсахарска Африка',
 			'419' => 'Латинска Америка',
 			'AC' => 'Остров Асенсион',
 			'AD' => 'Андора',
 			'AE' => 'Обединети Арапски Емирати',
 			'AF' => 'Авганистан',
 			'AG' => 'Антига и Барбуда',
 			'AI' => 'Ангвила',
 			'AL' => 'Албанија',
 			'AM' => 'Ерменија',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктик',
 			'AR' => 'Аргентина',
 			'AS' => 'Американска Самоа',
 			'AT' => 'Австрија',
 			'AU' => 'Австралија',
 			'AW' => 'Аруба',
 			'AX' => 'Оландски Острови',
 			'AZ' => 'Азербејџан',
 			'BA' => 'Босна и Херцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Белгија',
 			'BF' => 'Буркина Фасо',
 			'BG' => 'Бугарија',
 			'BH' => 'Бахреин',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Свети Вартоломеј',
 			'BM' => 'Бермуди',
 			'BN' => 'Брунеј',
 			'BO' => 'Боливија',
 			'BQ' => 'Карипска Холандија',
 			'BR' => 'Бразил',
 			'BS' => 'Бахами',
 			'BT' => 'Бутан',
 			'BV' => 'Остров Буве',
 			'BW' => 'Боцвана',
 			'BY' => 'Белорусија',
 			'BZ' => 'Белизе',
 			'CA' => 'Канада',
 			'CC' => 'Кокосови (Килиншки) Острови',
 			'CD' => 'Конго - Киншаса',
 			'CD@alt=variant' => 'Конго (Демократска Република Конго)',
 			'CF' => 'Централноафриканска Република',
 			'CG' => 'Конго - Бразавил',
 			'CG@alt=variant' => 'Конго (Република)',
 			'CH' => 'Швајцарија',
 			'CI' => 'Брегот на Слоновата Коска',
 			'CI@alt=variant' => 'Брег на Слоновата Коска',
 			'CK' => 'Кукови Острови',
 			'CL' => 'Чиле',
 			'CM' => 'Камерун',
 			'CN' => 'Кина',
 			'CO' => 'Колумбија',
 			'CP' => 'Остров Клипертон',
 			'CR' => 'Костарика',
 			'CU' => 'Куба',
 			'CV' => 'Кабо Верде',
 			'CW' => 'Курасао',
 			'CX' => 'Божиќен Остров',
 			'CY' => 'Кипар',
 			'CZ' => 'Чешка',
 			'CZ@alt=variant' => 'Чешка Република',
 			'DE' => 'Германија',
 			'DG' => 'Диего Гарсија',
 			'DJ' => 'Џибути',
 			'DK' => 'Данска',
 			'DM' => 'Доминика',
 			'DO' => 'Доминиканска Република',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута и Мелиља',
 			'EC' => 'Еквадор',
 			'EE' => 'Естонија',
 			'EG' => 'Египет',
 			'EH' => 'Западна Сахара',
 			'ER' => 'Еритреја',
 			'ES' => 'Шпанија',
 			'ET' => 'Етиопија',
 			'EU' => 'Европска унија',
 			'EZ' => 'Еврозона',
 			'FI' => 'Финска',
 			'FJ' => 'Фиџи',
 			'FK' => 'Фолкландски Острови',
 			'FK@alt=variant' => 'Фолкландски Острови (Малвински Острови)',
 			'FM' => 'Микронезија',
 			'FO' => 'Фарски Острови',
 			'FR' => 'Франција',
 			'GA' => 'Габон',
 			'GB' => 'Обединето Кралство',
 			'GB@alt=short' => 'ОК',
 			'GD' => 'Гренада',
 			'GE' => 'Грузија',
 			'GF' => 'Француска Гвајана',
 			'GG' => 'Гернзи',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренланд',
 			'GM' => 'Гамбија',
 			'GN' => 'Гвинеја',
 			'GP' => 'Гвадалупе',
 			'GQ' => 'Екваторска Гвинеја',
 			'GR' => 'Грција',
 			'GS' => 'Јужна Џорџија и Јужни Сендвички Острови',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвинеја Бисао',
 			'GY' => 'Гвајана',
 			'HK' => 'Хонгконг САР Кина',
 			'HK@alt=short' => 'Хонгконг',
 			'HM' => 'Остров Херд и Острови Мекдоналд',
 			'HN' => 'Хондурас',
 			'HR' => 'Хрватска',
 			'HT' => 'Хаити',
 			'HU' => 'Унгарија',
 			'IC' => 'Канарски Острови',
 			'ID' => 'Индонезија',
 			'IE' => 'Ирска',
 			'IL' => 'Израел',
 			'IM' => 'Остров Ман',
 			'IN' => 'Индија',
 			'IO' => 'Британска Индоокеанска Територија',
 			'IO@alt=chagos' => 'Архипелаг Чагос',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исланд',
 			'IT' => 'Италија',
 			'JE' => 'Џерси',
 			'JM' => 'Јамајка',
 			'JO' => 'Јордан',
 			'JP' => 'Јапонија',
 			'KE' => 'Кенија',
 			'KG' => 'Киргистан',
 			'KH' => 'Камбоџа',
 			'KI' => 'Кирибати',
 			'KM' => 'Коморски Острови',
 			'KN' => 'Свети Китс и Невис',
 			'KP' => 'Северна Кореја',
 			'KR' => 'Јужна Кореја',
 			'KW' => 'Кувајт',
 			'KY' => 'Кајмански Острови',
 			'KZ' => 'Казахстан',
 			'LA' => 'Лаос',
 			'LB' => 'Либан',
 			'LC' => 'Сент Лусија',
 			'LI' => 'Лихтенштајн',
 			'LK' => 'Шри Ланка',
 			'LR' => 'Либерија',
 			'LS' => 'Лесото',
 			'LT' => 'Литванија',
 			'LU' => 'Луксембург',
 			'LV' => 'Латвија',
 			'LY' => 'Либија',
 			'MA' => 'Мароко',
 			'MC' => 'Монако',
 			'MD' => 'Молдавија',
 			'ME' => 'Црна Гора',
 			'MF' => 'Сент Мартин',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршалски Острови',
 			'MK' => 'Северна Македонија',
 			'ML' => 'Мали',
 			'MM' => 'Мјанмар (Бурма)',
 			'MN' => 'Монголија',
 			'MO' => 'Макао САР',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Северни Маријански Острови',
 			'MQ' => 'Мартиник',
 			'MR' => 'Мавританија',
 			'MS' => 'Монсерат',
 			'MT' => 'Малта',
 			'MU' => 'Маврициус',
 			'MV' => 'Малдиви',
 			'MW' => 'Малави',
 			'MX' => 'Мексико',
 			'MY' => 'Малезија',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибија',
 			'NC' => 'Нова Каледонија',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолшки Остров',
 			'NG' => 'Нигерија',
 			'NI' => 'Никарагва',
 			'NL' => 'Холандија',
 			'NO' => 'Норвешка',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниује',
 			'NZ' => 'Нов Зеланд',
 			'NZ@alt=variant' => 'Аотеароа (Нов Зеланд)',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Француска Полинезија',
 			'PG' => 'Папуа Нова Гвинеја',
 			'PH' => 'Филипини',
 			'PK' => 'Пакистан',
 			'PL' => 'Полска',
 			'PM' => 'Сент Пјер и Микелан',
 			'PN' => 'Питкернски Острови',
 			'PR' => 'Порторико',
 			'PS' => 'Палестински Територии',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португалија',
 			'PW' => 'Палау',
 			'PY' => 'Парагвај',
 			'QA' => 'Катар',
 			'QO' => 'Зависни земји во Океанија',
 			'RE' => 'Рејунион',
 			'RO' => 'Романија',
 			'RS' => 'Србија',
 			'RU' => 'Русија',
 			'RW' => 'Руанда',
 			'SA' => 'Саудиска Арабија',
 			'SB' => 'Соломонски Острови',
 			'SC' => 'Сејшели',
 			'SD' => 'Судан',
 			'SE' => 'Шведска',
 			'SG' => 'Сингапур',
 			'SH' => 'Света Елена',
 			'SI' => 'Словенија',
 			'SJ' => 'Свалбард и Јан Мајен',
 			'SK' => 'Словачка',
 			'SL' => 'Сиера Леоне',
 			'SM' => 'Сан Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомалија',
 			'SR' => 'Суринам',
 			'SS' => 'Јужен Судан',
 			'ST' => 'Саун Томе и Принсип',
 			'SV' => 'Ел Салвадор',
 			'SX' => 'Свети Мартин',
 			'SY' => 'Сирија',
 			'SZ' => 'Свазиленд',
 			'TA' => 'Тристан да Куња',
 			'TC' => 'Острови Туркс и Каикос',
 			'TD' => 'Чад',
 			'TF' => 'Француски Јужни Територии',
 			'TG' => 'Того',
 			'TH' => 'Тајланд',
 			'TJ' => 'Таџикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Тимор Лесте',
 			'TL@alt=variant' => 'Источен Тимор',
 			'TM' => 'Туркменистан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Турција',
 			'TT' => 'Тринидад и Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тајван',
 			'TZ' => 'Танзанија',
 			'UA' => 'Украина',
 			'UG' => 'Уганда',
 			'UM' => 'Американски територии во Пацификот',
 			'UN' => 'Обединети нации',
 			'UN@alt=short' => 'ОН',
 			'US' => 'Соединети Американски Држави',
 			'US@alt=short' => 'САД',
 			'UY' => 'Уругвај',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент Винсент и Гренадини',
 			'VE' => 'Венецуела',
 			'VG' => 'Британски Девствени Острови',
 			'VI' => 'Американски Девствени Острови',
 			'VN' => 'Виетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Валис и Футуна',
 			'WS' => 'Самоа',
 			'XA' => 'псевдо-акценти',
 			'XB' => 'псевдо-биди',
 			'XK' => 'Косово',
 			'YE' => 'Јемен',
 			'YT' => 'Мајот',
 			'ZA' => 'Јужноафриканска Република',
 			'ZM' => 'Замбија',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Непознат регион',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'PINYIN' => 'Пинјин романизација',
 			'WADEGILE' => 'Вејд-Џајлс романизација',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'Календар',
 			'cf' => 'Формат на валута',
 			'collation' => 'Подредување',
 			'currency' => 'Валута',
 			'hc' => 'Часовен циклус (12 или 24)',
 			'lb' => 'Стил за разделување редови',
 			'ms' => 'Мерен систем',
 			'numbers' => 'Броеви',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{Будистички календар},
 				'chinese' => q{Кинески календар},
 				'coptic' => q{Коптски календар},
 				'dangi' => q{Дангиски календар},
 				'ethiopic' => q{Етиопски календар},
 				'ethiopic-amete-alem' => q{Етиопски Амет Алем календар},
 				'gregorian' => q{Грегоријански календар},
 				'hebrew' => q{Еврејски календар},
 				'indian' => q{Индиски национален календар},
 				'islamic' => q{Исламски календар},
 				'islamic-civil' => q{Исламски граѓански календар},
 				'islamic-rgsa' => q{Исламски календар (Саудиска Арабија)},
 				'islamic-tbla' => q{Исламски календар (астрономска епоха)},
 				'islamic-umalqura' => q{Исламски календар (Ум ал-Кура)},
 				'iso8601' => q{Календар ISO-8601},
 				'japanese' => q{Јапонски календар},
 				'persian' => q{Персиски календар},
 				'roc' => q{Мингуо-календар},
 			},
 			'cf' => {
 				'account' => q{Сметководствен формат на валута},
 				'standard' => q{Стандарден формат на валута},
 			},
 			'collation' => {
 				'big5han' => q{Традиционално кинеско сортирање},
 				'compat' => q{Претходно подредување},
 				'dictionary' => q{Подредување по азбучен редослед},
 				'ducet' => q{Стандардно подредување во уникод},
 				'emoji' => q{Подредување емотикони},
 				'eor' => q{Европски правила за подредување},
 				'gb2312han' => q{Поедноставено кинеско сортирање},
 				'phonebook' => q{Азбучен редослед},
 				'pinyin' => q{Сортирање Pinyin},
 				'reformed' => q{Реформирано подредување},
 				'search' => q{Општо пребарување},
 				'searchjl' => q{Пребарување според почетна согласка хангул},
 				'standard' => q{Стандардно подредување},
 				'stroke' => q{Ритмички редослед},
 				'traditional' => q{Традиционално сортирање},
 				'unihan' => q{Подредување унихан},
 				'zhuyin' => q{Подредување жујин},
 			},
 			'hc' => {
 				'h11' => q{12-часовен систем (0-11)},
 				'h12' => q{12-часовен систем (1-12)},
 				'h23' => q{24-часовен систем (0-23)},
 				'h24' => q{24-часовен систем (1-24)},
 			},
 			'lb' => {
 				'loose' => q{Допустлив стил за разделување редови},
 				'normal' => q{Нормален стил за разделување редови},
 				'strict' => q{Строг стил за разделување редови},
 			},
 			'ms' => {
 				'metric' => q{Метрички систем},
 				'uksystem' => q{Империјален мерен систем},
 				'ussystem' => q{Американски мерен систем},
 			},
 			'numbers' => {
 				'ahom' => q{Ахомски цифри},
 				'arab' => q{Арапско-индиски цифри},
 				'arabext' => q{Проширени арапско-индиски цифри},
 				'armn' => q{Ерменски броеви},
 				'armnlow' => q{Ерменски мали броеви},
 				'beng' => q{Бенгалски цифри},
 				'cakm' => q{Чакмански цифри},
 				'deva' => q{Деванагарски цифри},
 				'ethi' => q{Етиопски броеви},
 				'fullwide' => q{Цифри со целосна ширина},
 				'geor' => q{Грузиски броеви},
 				'grek' => q{Грчки броеви},
 				'greklow' => q{Грчки мали броеви},
 				'gujr' => q{Гуџарати цифри},
 				'guru' => q{Гурмуки цифри},
 				'hanidec' => q{Кинески децимални броеви},
 				'hans' => q{Поедноставени кинески броеви},
 				'hansfin' => q{Поедноставени кинески финансиски броеви},
 				'hant' => q{Традиционални кинески броеви},
 				'hantfin' => q{Традиционални кинески финансиски броеви},
 				'hebr' => q{Хебрејски броеви},
 				'java' => q{Јавански цифри},
 				'jpan' => q{Јапонски броеви},
 				'jpanfin' => q{Јапонски финансиски броеви},
 				'khmr' => q{Кмерски цифри},
 				'knda' => q{Каннада цифри},
 				'laoo' => q{Лаошки цифри},
 				'latn' => q{Арапски броеви},
 				'mlym' => q{Малајалски цифри},
 				'mtei' => q{Мејтејски цифри},
 				'mymr' => q{Мјанмарски цифри},
 				'olck' => q{Цифри ол чики},
 				'orya' => q{Одиски цифри},
 				'roman' => q{Римски броеви},
 				'romanlow' => q{Римски мали броеви},
 				'taml' => q{Традиционални тамилски броеви},
 				'tamldec' => q{Тамилски цифри},
 				'telu' => q{Телугу цифри},
 				'thai' => q{Тајландски цифри},
 				'tibt' => q{Тибетски цифри},
 				'vaii' => q{Цифри ваи},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{метрички},
 			'UK' => q{британски},
 			'US' => q{американски},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'Јазик: {0}',
 			'script' => 'Писмо: {0}',
 			'region' => 'Регион: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[ѐ ѝ]},
			index => ['А', 'Б', 'В', 'Г', 'Д', 'Ѓ', 'Е', 'Ж', 'З', 'Ѕ', 'И', 'Ј', 'К', 'Л', 'Љ', 'М', 'Н', 'Њ', 'О', 'П', 'Р', 'С', 'Т', 'Ќ', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Џ', 'Ш'],
			main => qr{[а б в г д ѓ е ж з ѕ и ј к л љ м н њ о п р с т ќ у ф х ц ч џ ш]},
			punctuation => qr{[\- ‐‑ – — , ; \: ! ? . … ‘‚ “„ ( ) \[ \] \{ \}]},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Д', 'Ѓ', 'Е', 'Ж', 'З', 'Ѕ', 'И', 'Ј', 'К', 'Л', 'Љ', 'М', 'Н', 'Њ', 'О', 'П', 'Р', 'С', 'Т', 'Ќ', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Џ', 'Ш'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'word-final' => '{0}…',
			'word-initial' => '…{0}',
			'word-medial' => '{0}… {1}',
		};
	},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{„},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‚},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(киби{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(киби{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(меби{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(меби{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(гиби{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(гиби{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(теби{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(теби{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(пеби{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(пеби{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(ексби{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(ексби{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(зеби{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(зеби{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(јобе{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(јобе{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(деци{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(деци{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(пико{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(пико{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(фемто{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(фемто{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(ато{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(ато{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(санти{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(санти{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(зепто{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(зепто{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(јокто{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(јокто{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(ронто{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(ронто{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(мили{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(мили{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(квекто{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(квекто{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(микро{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(микро{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(нано{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(нано{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(дека{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(дека{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(тера{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(тера{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(пета{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(пета{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(екса{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(екса{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(хекто{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(хекто{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(зета{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(зета{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(јота{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(јота{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(рона{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(рона{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(кило{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(кило{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(квета{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(квета{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(мега{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(мега{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(гига{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(гига{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'one' => q({0} гравитациска сила),
						'other' => q({0} гравитациска сила),
					},
					# Core Unit Identifier
					'g-force' => {
						'one' => q({0} гравитациска сила),
						'other' => q({0} гравитациска сила),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(метри во секунда на квадрат),
						'one' => q({0} метар во секунда на квадрат),
						'other' => q({0} метри во секунда на квадрат),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(метри во секунда на квадрат),
						'one' => q({0} метар во секунда на квадрат),
						'other' => q({0} метри во секунда на квадрат),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(аголни минути),
						'one' => q({0} аголна минута),
						'other' => q({0} аголни минути),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(аголни минути),
						'one' => q({0} аголна минута),
						'other' => q({0} аголни минути),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(аголни секунди),
						'one' => q({0} аголна секунда),
						'other' => q({0} аголни секунди),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(аголни секунди),
						'one' => q({0} аголна секунда),
						'other' => q({0} аголни секунди),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'one' => q({0} степен),
						'other' => q({0} степени),
					},
					# Core Unit Identifier
					'degree' => {
						'one' => q({0} степен),
						'other' => q({0} степени),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(радијани),
						'one' => q({0} радијан),
						'other' => q({0} радијани),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(радијани),
						'one' => q({0} радијан),
						'other' => q({0} радијани),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(револуција),
						'one' => q({0} револуција),
						'other' => q({0} револуции),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(револуција),
						'one' => q({0} револуција),
						'other' => q({0} револуции),
					},
					# Long Unit Identifier
					'area-acre' => {
						'one' => q({0} акр),
						'other' => q({0} акри),
					},
					# Core Unit Identifier
					'acre' => {
						'one' => q({0} акр),
						'other' => q({0} акри),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'one' => q({0} дунам),
						'other' => q({0} дунами),
					},
					# Core Unit Identifier
					'dunam' => {
						'one' => q({0} дунам),
						'other' => q({0} дунами),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'one' => q({0} хектар),
						'other' => q({0} хектари),
					},
					# Core Unit Identifier
					'hectare' => {
						'one' => q({0} хектар),
						'other' => q({0} хектари),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(квадратни сантиметри),
						'one' => q({0} квадратен сантиметар),
						'other' => q({0} квадратни сантиметри),
						'per' => q({0} по квадратен сантиметар),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(квадратни сантиметри),
						'one' => q({0} квадратен сантиметар),
						'other' => q({0} квадратни сантиметри),
						'per' => q({0} по квадратен сантиметар),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'one' => q({0} квадратна стапка),
						'other' => q({0} квадратни стапки),
					},
					# Core Unit Identifier
					'square-foot' => {
						'one' => q({0} квадратна стапка),
						'other' => q({0} квадратни стапки),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(квадратни инчи),
						'one' => q({0} квадратен инч),
						'other' => q({0} квадратни инчи),
						'per' => q({0} по квадратен инч),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(квадратни инчи),
						'one' => q({0} квадратен инч),
						'other' => q({0} квадратни инчи),
						'per' => q({0} по квадратен инч),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(квадратни километри),
						'one' => q({0} квадратен километар),
						'other' => q({0} квадратни километри),
						'per' => q({0} по квадратен километар),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(квадратни километри),
						'one' => q({0} квадратен километар),
						'other' => q({0} квадратни километри),
						'per' => q({0} по квадратен километар),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(квадратни метри),
						'one' => q({0} квадратен метар),
						'other' => q({0} квадратни метри),
						'per' => q({0} по квадратен метар),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(квадратни метри),
						'one' => q({0} квадратен метар),
						'other' => q({0} квадратни метри),
						'per' => q({0} по квадратен метар),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(квадратни милји),
						'one' => q({0} квадратна милја),
						'other' => q({0} квадратни милји),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(квадратни милји),
						'one' => q({0} квадратна милја),
						'other' => q({0} квадратни милји),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(квадратни јарди),
						'one' => q({0} квадратен јард),
						'other' => q({0} квадратни јарди),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(квадратни јарди),
						'one' => q({0} квадратен јард),
						'other' => q({0} квадратни јарди),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(ставки),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(ставки),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(карати),
						'one' => q({0} карат),
						'other' => q({0} карати),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(карати),
						'one' => q({0} карат),
						'other' => q({0} карати),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(милиграми на децилитар),
						'one' => q({0} милиграм на децилитар),
						'other' => q({0} милиграми на децилитар),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(милиграми на децилитар),
						'one' => q({0} милиграм на децилитар),
						'other' => q({0} милиграми на децилитар),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(милимоли на литар),
						'one' => q({0} милимол на литар),
						'other' => q({0} милимоли на литар),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(милимоли на литар),
						'one' => q({0} милимол на литар),
						'other' => q({0} милимоли на литар),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(молови),
						'one' => q({0} мол),
						'other' => q({0} мола),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(молови),
						'one' => q({0} мол),
						'other' => q({0} мола),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(процент),
						'one' => q({0} процент),
						'other' => q({0} проценти),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(процент),
						'one' => q({0} процент),
						'other' => q({0} проценти),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(промил),
						'one' => q({0} промили),
						'other' => q({0} промили),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(промил),
						'one' => q({0} промили),
						'other' => q({0} промили),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(делови на милион),
						'one' => q({0} дел на милион),
						'other' => q({0} дела на милион),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(делови на милион),
						'one' => q({0} дел на милион),
						'other' => q({0} дела на милион),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(десетилјадити дел),
						'one' => q({0} десетилјадити дел),
						'other' => q({0} десетилјадити делови),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(десетилјадити дел),
						'one' => q({0} десетилјадити дел),
						'other' => q({0} десетилјадити делови),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(литри на 100 километри),
						'one' => q({0} литар на 100 километри),
						'other' => q({0} литри на 100 километри),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(литри на 100 километри),
						'one' => q({0} литар на 100 километри),
						'other' => q({0} литри на 100 километри),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(литри на километар),
						'one' => q({0} литар на километар),
						'other' => q({0} литри на километар),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(литри на километар),
						'one' => q({0} литар на километар),
						'other' => q({0} литри на километар),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(милји на галон),
						'one' => q({0} милја на галон),
						'other' => q({0} милји на галон),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(милји на галон),
						'one' => q({0} милја на галон),
						'other' => q({0} милји на галон),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} исток),
						'north' => q({0} север),
						'south' => q({0} југ),
						'west' => q({0} запад),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} исток),
						'north' => q({0} север),
						'south' => q({0} југ),
						'west' => q({0} запад),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(бита),
						'one' => q({0} бит),
						'other' => q({0} бита),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(бита),
						'one' => q({0} бит),
						'other' => q({0} бита),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(бајти),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(бајти),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(гигабита),
						'one' => q({0} гигабит),
						'other' => q({0} гигабита),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(гигабита),
						'one' => q({0} гигабит),
						'other' => q({0} гигабита),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(гигабајти),
						'one' => q({0} гигабајт),
						'other' => q({0} гигабајти),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(гигабајти),
						'one' => q({0} гигабајт),
						'other' => q({0} гигабајти),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(килобита),
						'one' => q({0} килобит),
						'other' => q({0} килобита),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(килобита),
						'one' => q({0} килобит),
						'other' => q({0} килобита),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(килобајти),
						'one' => q({0} килобајт),
						'other' => q({0} килобајти),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(килобајти),
						'one' => q({0} килобајт),
						'other' => q({0} килобајти),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(мегабита),
						'one' => q({0} мегабит),
						'other' => q({0} мегабита),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(мегабита),
						'one' => q({0} мегабит),
						'other' => q({0} мегабита),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(мегабајти),
						'one' => q({0} мегабајт),
						'other' => q({0} мегабајти),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(мегабајти),
						'one' => q({0} мегабајт),
						'other' => q({0} мегабајти),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(петабајти),
						'one' => q({0} петабајт),
						'other' => q({0} петабајти),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(петабајти),
						'one' => q({0} петабајт),
						'other' => q({0} петабајти),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(терабита),
						'one' => q({0} терабит),
						'other' => q({0} терабита),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(терабита),
						'one' => q({0} терабит),
						'other' => q({0} терабита),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(терабајти),
						'one' => q({0} терабајт),
						'other' => q({0} терабајти),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(терабајти),
						'one' => q({0} терабајт),
						'other' => q({0} терабајти),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(векови),
						'one' => q({0} век),
						'other' => q({0} векови),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(векови),
						'one' => q({0} век),
						'other' => q({0} векови),
					},
					# Long Unit Identifier
					'duration-day' => {
						'per' => q({0} дневно),
					},
					# Core Unit Identifier
					'day' => {
						'per' => q({0} дневно),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(децении),
						'one' => q({0} деценија),
						'other' => q({0} децении),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(децении),
						'one' => q({0} деценија),
						'other' => q({0} децении),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'one' => q({0} час),
						'other' => q({0} часа),
						'per' => q({0} на час),
					},
					# Core Unit Identifier
					'hour' => {
						'one' => q({0} час),
						'other' => q({0} часа),
						'per' => q({0} на час),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(микросекунди),
						'one' => q({0} микросекунда),
						'other' => q({0} микросекунди),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(микросекунди),
						'one' => q({0} микросекунда),
						'other' => q({0} микросекунди),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(милисекунди),
						'one' => q({0} милисекунда),
						'other' => q({0} милисекунди),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(милисекунди),
						'one' => q({0} милисекунда),
						'other' => q({0} милисекунди),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(минути),
						'one' => q({0} минута),
						'other' => q({0} минути),
						'per' => q({0} на минута),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(минути),
						'one' => q({0} минута),
						'other' => q({0} минути),
						'per' => q({0} на минута),
					},
					# Long Unit Identifier
					'duration-month' => {
						'one' => q({0} месец),
						'other' => q({0} месеци),
						'per' => q({0} месечно),
					},
					# Core Unit Identifier
					'month' => {
						'one' => q({0} месец),
						'other' => q({0} месеци),
						'per' => q({0} месечно),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(наносекунди),
						'one' => q({0} наносекунда),
						'other' => q({0} наносекунди),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(наносекунди),
						'one' => q({0} наносекунда),
						'other' => q({0} наносекунди),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'one' => q({0} тримесечје),
						'other' => q({0} тримесечја),
						'per' => q({0}/тримесечје),
					},
					# Core Unit Identifier
					'quarter' => {
						'one' => q({0} тримесечје),
						'other' => q({0} тримесечја),
						'per' => q({0}/тримесечје),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(секунди),
						'one' => q({0} секунда),
						'other' => q({0} секунди),
						'per' => q({0} во секунда),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(секунди),
						'one' => q({0} секунда),
						'other' => q({0} секунди),
						'per' => q({0} во секунда),
					},
					# Long Unit Identifier
					'duration-week' => {
						'one' => q({0} седмица),
						'other' => q({0} седмици),
						'per' => q({0} седмично),
					},
					# Core Unit Identifier
					'week' => {
						'one' => q({0} седмица),
						'other' => q({0} седмици),
						'per' => q({0} седмично),
					},
					# Long Unit Identifier
					'duration-year' => {
						'one' => q({0} година),
						'other' => q({0} години),
						'per' => q({0} годишно),
					},
					# Core Unit Identifier
					'year' => {
						'one' => q({0} година),
						'other' => q({0} години),
						'per' => q({0} годишно),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(ампери),
						'one' => q({0} ампер),
						'other' => q({0} ампери),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(ампери),
						'one' => q({0} ампер),
						'other' => q({0} ампери),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(милиампери),
						'one' => q({0} милиампер),
						'other' => q({0} милиампери),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(милиампери),
						'one' => q({0} милиампер),
						'other' => q({0} милиампери),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'one' => q({0} ом),
						'other' => q({0} оми),
					},
					# Core Unit Identifier
					'ohm' => {
						'one' => q({0} ом),
						'other' => q({0} оми),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(волти),
						'one' => q({0} волт),
						'other' => q({0} волти),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(волти),
						'one' => q({0} волт),
						'other' => q({0} волти),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(британски термални единици),
						'one' => q({0} британска термална единица),
						'other' => q({0} британски термални единици),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(британски термални единици),
						'one' => q({0} британска термална единица),
						'other' => q({0} британски термални единици),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(калории),
						'one' => q({0} калорија),
						'other' => q({0} калории),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(калории),
						'one' => q({0} калорија),
						'other' => q({0} калории),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(електронволти),
						'one' => q({0} електронволт),
						'other' => q({0} електронволти),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(електронволти),
						'one' => q({0} електронволт),
						'other' => q({0} електронволти),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(калории),
						'one' => q({0} калорија),
						'other' => q({0} калории),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(калории),
						'one' => q({0} калорија),
						'other' => q({0} калории),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(џули),
						'one' => q({0} џул),
						'other' => q({0} џули),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(џули),
						'one' => q({0} џул),
						'other' => q({0} џули),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(килокалории),
						'one' => q({0} килокалорија),
						'other' => q({0} килокалории),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(килокалории),
						'one' => q({0} килокалорија),
						'other' => q({0} килокалории),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(килоџули),
						'one' => q({0} килоџул),
						'other' => q({0} килоџули),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(килоџули),
						'one' => q({0} килоџул),
						'other' => q({0} килоџули),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(киловат-часови),
						'one' => q({0} киловат-час),
						'other' => q({0} киловат-часа),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(киловат-часови),
						'one' => q({0} киловат-час),
						'other' => q({0} киловат-часа),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(US терми),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(US терми),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(киловат-час на 100 километри),
						'one' => q({0} киловат-час на 100 километри),
						'other' => q({0} киловат-часа на 100 километри),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(киловат-час на 100 километри),
						'one' => q({0} киловат-час на 100 километри),
						'other' => q({0} киловат-часа на 100 километри),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(њутни),
						'one' => q({0} њутн),
						'other' => q({0} њутни),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(њутни),
						'one' => q({0} њутн),
						'other' => q({0} њутни),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(фунти сила),
						'one' => q({0} фунта сила),
						'other' => q({0} фунти сила),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(фунти сила),
						'one' => q({0} фунта сила),
						'other' => q({0} фунти сила),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(гигахерци),
						'one' => q({0} гигахерц),
						'other' => q({0} гигахерци),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(гигахерци),
						'one' => q({0} гигахерц),
						'other' => q({0} гигахерци),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(херци),
						'one' => q({0} херц),
						'other' => q({0} херца),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(херци),
						'one' => q({0} херц),
						'other' => q({0} херца),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(килохерци),
						'one' => q({0} килохерц),
						'other' => q({0} килохерци),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(килохерци),
						'one' => q({0} килохерц),
						'other' => q({0} килохерци),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(мегахерци),
						'one' => q({0} мегахерц),
						'other' => q({0} мегахерци),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(мегахерци),
						'one' => q({0} мегахерц),
						'other' => q({0} мегахерци),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(точки),
						'one' => q({0} точка),
						'other' => q({0} точки),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(точки),
						'one' => q({0} точка),
						'other' => q({0} точки),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(точки на сантиметар),
						'one' => q({0} точка на сантиметар),
						'other' => q({0} точки на сантиметар),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(точки на сантиметар),
						'one' => q({0} точка на сантиметар),
						'other' => q({0} точки на сантиметар),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(точки на инч),
						'one' => q({0} точка на инч),
						'other' => q({0} точки на инч),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(точки на инч),
						'one' => q({0} точка на инч),
						'other' => q({0} точки на инч),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(типографски еми),
						'one' => q({0} ем),
						'other' => q({0} еми),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(типографски еми),
						'one' => q({0} ем),
						'other' => q({0} еми),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(мегапиксели),
						'one' => q({0} мегапиксел),
						'other' => q({0} мегапиксели),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(мегапиксели),
						'one' => q({0} мегапиксел),
						'other' => q({0} мегапиксели),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(пиксели),
						'one' => q({0} пиксел),
						'other' => q({0} пиксели),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(пиксели),
						'one' => q({0} пиксел),
						'other' => q({0} пиксели),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(пиксели на сантиметар),
						'one' => q({0} пиксел на сантиметар),
						'other' => q({0} пиксели на сантиметар),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(пиксели на сантиметар),
						'one' => q({0} пиксел на сантиметар),
						'other' => q({0} пиксели на сантиметар),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(пиксели на инч),
						'one' => q({0} пиксел на инч),
						'other' => q({0} пиксели на инч),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(пиксели на инч),
						'one' => q({0} пиксел на инч),
						'other' => q({0} пиксели на инч),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(астрономски единици),
						'one' => q({0} астрономска единица),
						'other' => q({0} астрономски единици),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(астрономски единици),
						'one' => q({0} астрономска единица),
						'other' => q({0} астрономски единици),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(сантиметри),
						'one' => q({0} сантиметар),
						'other' => q({0} сантиметри),
						'per' => q({0} на сантиметар),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(сантиметри),
						'one' => q({0} сантиметар),
						'other' => q({0} сантиметри),
						'per' => q({0} на сантиметар),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(дециметри),
						'one' => q({0} дециметар),
						'other' => q({0} дециметри),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(дециметри),
						'one' => q({0} дециметар),
						'other' => q({0} дециметри),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(земјен радиус),
						'one' => q({0} земјен радиус),
						'other' => q({0} земјени радиуси),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(земјен радиус),
						'one' => q({0} земјен радиус),
						'other' => q({0} земјени радиуси),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'one' => q({0} фатом),
						'other' => q({0} фатоми),
					},
					# Core Unit Identifier
					'fathom' => {
						'one' => q({0} фатом),
						'other' => q({0} фатоми),
					},
					# Long Unit Identifier
					'length-foot' => {
						'one' => q({0} стапка),
						'other' => q({0} стапки),
						'per' => q({0} на стапка),
					},
					# Core Unit Identifier
					'foot' => {
						'one' => q({0} стапка),
						'other' => q({0} стапки),
						'per' => q({0} на стапка),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'one' => q({0} фурлонг),
						'other' => q({0} фурлонзи),
					},
					# Core Unit Identifier
					'furlong' => {
						'one' => q({0} фурлонг),
						'other' => q({0} фурлонзи),
					},
					# Long Unit Identifier
					'length-inch' => {
						'one' => q({0} инч),
						'other' => q({0} инчи),
						'per' => q({0} на инч),
					},
					# Core Unit Identifier
					'inch' => {
						'one' => q({0} инч),
						'other' => q({0} инчи),
						'per' => q({0} на инч),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(километри),
						'one' => q({0} километар),
						'other' => q({0} километри),
						'per' => q({0} на километар),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(километри),
						'one' => q({0} километар),
						'other' => q({0} километри),
						'per' => q({0} на километар),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(светлосни години),
						'one' => q({0} светлосна година),
						'other' => q({0} светлосни години),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(светлосни години),
						'one' => q({0} светлосна година),
						'other' => q({0} светлосни години),
					},
					# Long Unit Identifier
					'length-meter' => {
						'one' => q({0} метар),
						'other' => q({0} метри),
						'per' => q({0} на метар),
					},
					# Core Unit Identifier
					'meter' => {
						'one' => q({0} метар),
						'other' => q({0} метри),
						'per' => q({0} на метар),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(микрометри),
						'one' => q({0} микрометар),
						'other' => q({0} микрометри),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(микрометри),
						'one' => q({0} микрометар),
						'other' => q({0} микрометри),
					},
					# Long Unit Identifier
					'length-mile' => {
						'one' => q({0} милја),
						'other' => q({0} милји),
					},
					# Core Unit Identifier
					'mile' => {
						'one' => q({0} милја),
						'other' => q({0} милји),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(скандинавска милја),
						'one' => q({0} скандинавска милја),
						'other' => q({0} скандинавски милји),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(скандинавска милја),
						'one' => q({0} скандинавска милја),
						'other' => q({0} скандинавски милји),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(милиметри),
						'one' => q({0} милиметар),
						'other' => q({0} милиметри),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(милиметри),
						'one' => q({0} милиметар),
						'other' => q({0} милиметри),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(нанометри),
						'one' => q({0} нанометар),
						'other' => q({0} нанометри),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(нанометри),
						'one' => q({0} нанометар),
						'other' => q({0} нанометри),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(наутички милји),
						'one' => q({0} наутичка милја),
						'other' => q({0} наутички милји),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(наутички милји),
						'one' => q({0} наутичка милја),
						'other' => q({0} наутички милји),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'one' => q({0} парсек),
						'other' => q({0} парсеци),
					},
					# Core Unit Identifier
					'parsec' => {
						'one' => q({0} парсек),
						'other' => q({0} парсеци),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(пикометри),
						'one' => q({0} пикометар),
						'other' => q({0} пикометри),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(пикометри),
						'one' => q({0} пикометар),
						'other' => q({0} пикометри),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(сончеви радиуси),
						'one' => q({0} сончев радиус),
						'other' => q({0} сончеви радиуси),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(сончеви радиуси),
						'one' => q({0} сончев радиус),
						'other' => q({0} сончеви радиуси),
					},
					# Long Unit Identifier
					'length-yard' => {
						'one' => q({0} јард),
						'other' => q({0} јарди),
					},
					# Core Unit Identifier
					'yard' => {
						'one' => q({0} јард),
						'other' => q({0} јарди),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(кандела),
						'one' => q({0} кандела),
						'other' => q({0} кандели),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(кандела),
						'one' => q({0} кандела),
						'other' => q({0} кандели),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(лумен),
						'one' => q({0} лумен),
						'other' => q({0} лумени),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(лумен),
						'one' => q({0} лумен),
						'other' => q({0} лумени),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(лукс),
						'one' => q({0} лукс),
						'other' => q({0} лукса),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(лукс),
						'one' => q({0} лукс),
						'other' => q({0} лукса),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(сончеви сјајности),
						'one' => q({0} сончева сјајност),
						'other' => q({0} сончеви сјајности),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(сончеви сјајности),
						'one' => q({0} сончева сјајност),
						'other' => q({0} сончеви сјајности),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'one' => q({0} карат),
						'other' => q({0} карати),
					},
					# Core Unit Identifier
					'carat' => {
						'one' => q({0} карат),
						'other' => q({0} карати),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(далтони),
						'one' => q({0} далтон),
						'other' => q({0} далтони),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(далтони),
						'one' => q({0} далтон),
						'other' => q({0} далтони),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(земјини маси),
						'one' => q({0} земјина маса),
						'other' => q({0} земјини маси),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(земјини маси),
						'one' => q({0} земјина маса),
						'other' => q({0} земјини маси),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(грејни),
						'one' => q({0} грејн),
						'other' => q({0} грејни),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(грејни),
						'one' => q({0} грејн),
						'other' => q({0} грејни),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(грамови),
						'one' => q({0} грам),
						'other' => q({0} грама),
						'per' => q({0} на грам),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(грамови),
						'one' => q({0} грам),
						'other' => q({0} грама),
						'per' => q({0} на грам),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(килограми),
						'one' => q({0} килограм),
						'other' => q({0} килограми),
						'per' => q({0} на килограм),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(килограми),
						'one' => q({0} килограм),
						'other' => q({0} килограми),
						'per' => q({0} на килограм),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(микрограми),
						'one' => q({0} микрограм),
						'other' => q({0} микрограми),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(микрограми),
						'one' => q({0} микрограм),
						'other' => q({0} микрограми),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(милиграми),
						'one' => q({0} милиграм),
						'other' => q({0} милиграми),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(милиграми),
						'one' => q({0} милиграм),
						'other' => q({0} милиграми),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(унци),
						'one' => q({0} унца),
						'other' => q({0} унци),
						'per' => q({0} на унца),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(унци),
						'one' => q({0} унца),
						'other' => q({0} унци),
						'per' => q({0} на унца),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(тројски унци),
						'one' => q({0} тројска унца),
						'other' => q({0} тројски унци),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(тројски унци),
						'one' => q({0} тројска унца),
						'other' => q({0} тројски унци),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'one' => q({0} фунта),
						'other' => q({0} фунти),
						'per' => q({0} на фунта),
					},
					# Core Unit Identifier
					'pound' => {
						'one' => q({0} фунта),
						'other' => q({0} фунти),
						'per' => q({0} на фунта),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(сончеви маси),
						'one' => q({0} сончева маса),
						'other' => q({0} сончеви маси),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(сончеви маси),
						'one' => q({0} сончева маса),
						'other' => q({0} сончеви маси),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'one' => q({0} стоун),
						'other' => q({0} стоуни),
					},
					# Core Unit Identifier
					'stone' => {
						'one' => q({0} стоун),
						'other' => q({0} стоуни),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'one' => q({0} американски тон),
						'other' => q({0} американски тони),
					},
					# Core Unit Identifier
					'ton' => {
						'one' => q({0} американски тон),
						'other' => q({0} американски тони),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(тони),
						'one' => q({0} тон),
						'other' => q({0} тона),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(тони),
						'one' => q({0} тон),
						'other' => q({0} тона),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0} на {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0} на {1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(гигавати),
						'one' => q({0} гигават),
						'other' => q({0} гигавати),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(гигавати),
						'one' => q({0} гигават),
						'other' => q({0} гигавати),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(коњски сили),
						'one' => q({0} коњска сила),
						'other' => q({0} коњски сили),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(коњски сили),
						'one' => q({0} коњска сила),
						'other' => q({0} коњски сили),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(киловати),
						'one' => q({0} киловат),
						'other' => q({0} киловати),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(киловати),
						'one' => q({0} киловат),
						'other' => q({0} киловати),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(мегавати),
						'one' => q({0} мегават),
						'other' => q({0} мегавати),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(мегавати),
						'one' => q({0} мегават),
						'other' => q({0} мегавати),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(миливати),
						'one' => q({0} миливат),
						'other' => q({0} миливати),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(миливати),
						'one' => q({0} миливат),
						'other' => q({0} миливати),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(вати),
						'one' => q({0} ват),
						'other' => q({0} вати),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(вати),
						'one' => q({0} ват),
						'other' => q({0} вати),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q(квадратни {0}),
						'one' => q({0} квадратен),
						'other' => q({0} квадратни),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q(квадратни {0}),
						'one' => q({0} квадратен),
						'other' => q({0} квадратни),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q(кубни {0}),
						'one' => q({0} кубен),
						'other' => q({0} кубни),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q(кубни {0}),
						'one' => q({0} кубен),
						'other' => q({0} кубни),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(атмосфери),
						'one' => q({0} атмосфера),
						'other' => q({0} атмосфери),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(атмосфери),
						'one' => q({0} атмосфера),
						'other' => q({0} атмосфери),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(бари),
						'one' => q({0} бар),
						'other' => q({0} бари),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(бари),
						'one' => q({0} бар),
						'other' => q({0} бари),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(хектопаскали),
						'one' => q({0} хектопаскал),
						'other' => q({0} хектопаскали),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(хектопаскали),
						'one' => q({0} хектопаскал),
						'other' => q({0} хектопаскали),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(инчи жива),
						'one' => q({0} инч жива),
						'other' => q({0} инчи жива),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(инчи жива),
						'one' => q({0} инч жива),
						'other' => q({0} инчи жива),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(килопаскали),
						'one' => q({0} килопаскал),
						'other' => q({0} килопаскали),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(килопаскали),
						'one' => q({0} килопаскал),
						'other' => q({0} килопаскали),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(мегапаскали),
						'one' => q({0} мегапаскал),
						'other' => q({0} мегапаскали),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(мегапаскали),
						'one' => q({0} мегапаскал),
						'other' => q({0} мегапаскали),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(милибари),
						'one' => q({0} милибар),
						'other' => q({0} милибари),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(милибари),
						'one' => q({0} милибар),
						'other' => q({0} милибари),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(милиметри жива),
						'one' => q({0} милиметар жива),
						'other' => q({0} милиметри жива),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(милиметри жива),
						'one' => q({0} милиметар жива),
						'other' => q({0} милиметри жива),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(паскали),
						'one' => q({0} паскал),
						'other' => q({0} паскали),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(паскали),
						'one' => q({0} паскал),
						'other' => q({0} паскали),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(фунти на квадратен инч),
						'one' => q({0} фунта на квадратен инч),
						'other' => q({0} фунти на квадратен инч),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(фунти на квадратен инч),
						'one' => q({0} фунта на квадратен инч),
						'other' => q({0} фунти на квадратен инч),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'name' => q(бофори),
						'one' => q({0} бофор),
						'other' => q({0} бофори),
					},
					# Core Unit Identifier
					'beaufort' => {
						'name' => q(бофори),
						'one' => q({0} бофор),
						'other' => q({0} бофори),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(километри на час),
						'one' => q({0} километар на час),
						'other' => q({0} километри на час),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(километри на час),
						'one' => q({0} километар на час),
						'other' => q({0} километри на час),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(јазли),
						'one' => q({0} јазол),
						'other' => q({0} јазли),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(јазли),
						'one' => q({0} јазол),
						'other' => q({0} јазли),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(метри во секунда),
						'one' => q({0} метар во секунда),
						'other' => q({0} метри во секунда),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(метри во секунда),
						'one' => q({0} метар во секунда),
						'other' => q({0} метри во секунда),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(милји на час),
						'one' => q({0} милја на час),
						'other' => q({0} милји на час),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(милји на час),
						'one' => q({0} милја на час),
						'other' => q({0} милји на час),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'one' => q({0} целзиусов степен),
						'other' => q({0} целзиусови степени),
					},
					# Core Unit Identifier
					'celsius' => {
						'one' => q({0} целзиусов степен),
						'other' => q({0} целзиусови степени),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(фаренхајтови степени),
						'one' => q({0} фаренхајтов степен),
						'other' => q({0} фаренхајтови степени),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(фаренхајтови степени),
						'one' => q({0} фаренхајтов степен),
						'other' => q({0} фаренхајтови степени),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(келвини),
						'one' => q({0} келвин),
						'other' => q({0} келвини),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(келвини),
						'one' => q({0} келвин),
						'other' => q({0} келвини),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(њутнметри),
						'one' => q({0} њутнметар),
						'other' => q({0} њутнметри),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(њутнметри),
						'one' => q({0} њутнметар),
						'other' => q({0} њутнметри),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(стапки фунти),
						'one' => q({0} стапка фунта),
						'other' => q({0} стапки фунти),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(стапки фунти),
						'one' => q({0} стапка фунта),
						'other' => q({0} стапки фунти),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(акр-стапка),
						'one' => q({0} акр-стапка),
						'other' => q({0} акр-стапки),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(акр-стапка),
						'one' => q({0} акр-стапка),
						'other' => q({0} акр-стапки),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(барели),
						'one' => q({0} барел),
						'other' => q({0} барели),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(барели),
						'one' => q({0} барел),
						'other' => q({0} барели),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'one' => q({0} бушел),
						'other' => q({0} бушели),
					},
					# Core Unit Identifier
					'bushel' => {
						'one' => q({0} бушел),
						'other' => q({0} бушели),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(центилитри),
						'one' => q({0} центилитар),
						'other' => q({0} центилитри),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(центилитри),
						'one' => q({0} центилитар),
						'other' => q({0} центилитри),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(кубни сантиметри),
						'one' => q({0} кубен сантиметар),
						'other' => q({0} кубни сантиметри),
						'per' => q({0} на кубен сантиметар),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(кубни сантиметри),
						'one' => q({0} кубен сантиметар),
						'other' => q({0} кубни сантиметри),
						'per' => q({0} на кубен сантиметар),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(кубни стапки),
						'one' => q({0} кубна стапка),
						'other' => q({0} кубни стапки),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(кубни стапки),
						'one' => q({0} кубна стапка),
						'other' => q({0} кубни стапки),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(кубни инчи),
						'one' => q({0} кубен инч),
						'other' => q({0} кубни инчи),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(кубни инчи),
						'one' => q({0} кубен инч),
						'other' => q({0} кубни инчи),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(кубни километри),
						'one' => q({0} кубен километар),
						'other' => q({0} кубни километри),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(кубни километри),
						'one' => q({0} кубен километар),
						'other' => q({0} кубни километри),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(кубни метри),
						'one' => q({0} кубен метар),
						'other' => q({0} кубни метри),
						'per' => q({0} на кубен метар),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(кубни метри),
						'one' => q({0} кубен метар),
						'other' => q({0} кубни метри),
						'per' => q({0} на кубен метар),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(кубни милји),
						'one' => q({0} кубна милја),
						'other' => q({0} кубни милји),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(кубни милји),
						'one' => q({0} кубна милја),
						'other' => q({0} кубни милји),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(кубни јарди),
						'one' => q({0} кубен јард),
						'other' => q({0} кубни јарди),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(кубни јарди),
						'one' => q({0} кубен јард),
						'other' => q({0} кубни јарди),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'one' => q({0} чаша),
						'other' => q({0} чаши),
					},
					# Core Unit Identifier
					'cup' => {
						'one' => q({0} чаша),
						'other' => q({0} чаши),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(метрички чаши),
						'one' => q({0} метричка чаша),
						'other' => q({0} метрички чаши),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(метрички чаши),
						'one' => q({0} метричка чаша),
						'other' => q({0} метрички чаши),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(децилитри),
						'one' => q({0} децилитар),
						'other' => q({0} децилитри),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(децилитри),
						'one' => q({0} децилитар),
						'other' => q({0} децилитри),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(лажица за десерт),
						'one' => q({0} лажица за десерт),
						'other' => q({0} лажици за десерт),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(лажица за десерт),
						'one' => q({0} лажица за десерт),
						'other' => q({0} лажици за десерт),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(имп. лажица за десерт),
						'one' => q({0} имп. лажица за десерт),
						'other' => q({0} имп. лажици за десерт),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(имп. лажица за десерт),
						'one' => q({0} имп. лажица за десерт),
						'other' => q({0} имп. лажици за десерт),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(драм),
						'one' => q({0} драм),
						'other' => q({0} драмови),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(драм),
						'one' => q({0} драм),
						'other' => q({0} драмови),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'one' => q({0} капка),
						'other' => q({0} капки),
					},
					# Core Unit Identifier
					'drop' => {
						'one' => q({0} капка),
						'other' => q({0} капки),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(унци течност),
						'one' => q({0} унца течност),
						'other' => q({0} унци течност),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(унци течност),
						'one' => q({0} унца течност),
						'other' => q({0} унци течност),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(имп. унци течност),
						'one' => q({0} имп. унца течност),
						'other' => q({0} имп. унци течност),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(имп. унци течност),
						'one' => q({0} имп. унца течност),
						'other' => q({0} имп. унци течност),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(галони),
						'one' => q({0} галон),
						'other' => q({0} галони),
						'per' => q({0} по галон),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(галони),
						'one' => q({0} галон),
						'other' => q({0} галони),
						'per' => q({0} по галон),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(имп. галони),
						'one' => q({0} имп. галон),
						'other' => q({0} имп. галони),
						'per' => q({0}/имп. галон),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(имп. галони),
						'one' => q({0} имп. галон),
						'other' => q({0} имп. галони),
						'per' => q({0}/имп. галон),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(хектолитри),
						'one' => q({0} хектолитар),
						'other' => q({0} хектолитри),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(хектолитри),
						'one' => q({0} хектолитар),
						'other' => q({0} хектолитри),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'one' => q({0} џигер),
						'other' => q({0} џигери),
					},
					# Core Unit Identifier
					'jigger' => {
						'one' => q({0} џигер),
						'other' => q({0} џигери),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'one' => q({0} литар),
						'other' => q({0} литри),
						'per' => q({0} по литар),
					},
					# Core Unit Identifier
					'liter' => {
						'one' => q({0} литар),
						'other' => q({0} литри),
						'per' => q({0} по литар),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(мегалитри),
						'one' => q({0} мегалитар),
						'other' => q({0} мегалитри),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(мегалитри),
						'one' => q({0} мегалитар),
						'other' => q({0} мегалитри),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(милилитри),
						'one' => q({0} милилитар),
						'other' => q({0} милилитри),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(милилитри),
						'one' => q({0} милилитар),
						'other' => q({0} милилитри),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(прстофат),
						'one' => q({0} прстофат),
						'other' => q({0} прстофати),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(прстофат),
						'one' => q({0} прстофат),
						'other' => q({0} прстофати),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'one' => q({0} пинта),
						'other' => q({0} пинти),
					},
					# Core Unit Identifier
					'pint' => {
						'one' => q({0} пинта),
						'other' => q({0} пинти),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(метрички пинти),
						'one' => q({0} метричка пинта),
						'other' => q({0} метрички пинти),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(метрички пинти),
						'one' => q({0} метричка пинта),
						'other' => q({0} метрички пинти),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(кварти),
						'one' => q({0} кварт),
						'other' => q({0} кварти),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(кварти),
						'one' => q({0} кварт),
						'other' => q({0} кварти),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(имп. четвртина),
						'one' => q({0} имп. четвртина),
						'other' => q({0} имп. четвртини),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(имп. четвртина),
						'one' => q({0} имп. четвртина),
						'other' => q({0} имп. четвртини),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(супени лажици),
						'one' => q({0} супена лажица),
						'other' => q({0} супени лажици),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(супени лажици),
						'one' => q({0} супена лажица),
						'other' => q({0} супени лажици),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(кафени лажици),
						'one' => q({0} кафена лажица),
						'other' => q({0} кафени лажици),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(кафени лажици),
						'one' => q({0} кафена лажица),
						'other' => q({0} кафени лажици),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(m/s²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(m/s²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(arcmin),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(arcmin),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(arcsec),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(arcsec),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(deg),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(deg),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(акр),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(акр),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(дунам),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(дунам),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(хектар),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(хектар),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(ft²),
						'one' => q({0} ft²),
						'other' => q({0} ft²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(ft²),
						'one' => q({0} ft²),
						'other' => q({0} ft²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(mi²),
						'one' => q({0} mi²),
						'other' => q({0} mi²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(mi²),
						'one' => q({0} mi²),
						'other' => q({0} mi²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(yd²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(yd²),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'one' => q({0} ‱),
						'other' => q({0} ‱),
					},
					# Core Unit Identifier
					'permyriad' => {
						'one' => q({0} ‱),
						'other' => q({0} ‱),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(mpg UK),
						'one' => q({0} m/gUK),
						'other' => q({0} m/gUK),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(mpg UK),
						'one' => q({0} m/gUK),
						'other' => q({0} m/gUK),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(B),
						'one' => q({0} B),
						'other' => q({0} B),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(B),
						'one' => q({0} B),
						'other' => q({0} B),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(kb),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(kb),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Mb),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Mb),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(MB),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(MB),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Tb),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Tb),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(TB),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(TB),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(ден),
						'one' => q({0} д.),
						'other' => q({0} д.),
						'per' => q({0}/д.),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(ден),
						'one' => q({0} д.),
						'other' => q({0} д.),
						'per' => q({0}/д.),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(час),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(час),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(μс),
						'one' => q({0}μс),
						'other' => q({0}μс),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(μс),
						'one' => q({0}μс),
						'other' => q({0}μс),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(мин),
						'one' => q({0} м.),
						'other' => q({0} м.),
						'per' => q({0}/м.),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(мин),
						'one' => q({0} м.),
						'other' => q({0} м.),
						'per' => q({0}/м.),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(месец),
						'one' => q({0} м.),
						'other' => q({0} м.),
						'per' => q({0}/м.),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(месец),
						'one' => q({0} м.),
						'other' => q({0} м.),
						'per' => q({0}/м.),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(т.),
						'one' => q({0} т.),
						'other' => q({0} т.),
						'per' => q({0}/т.),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(т.),
						'one' => q({0} т.),
						'other' => q({0} т.),
						'per' => q({0}/т.),
					},
					# Long Unit Identifier
					'duration-second' => {
						'one' => q({0} с.),
						'other' => q({0} с.),
						'per' => q({0}/с.),
					},
					# Core Unit Identifier
					'second' => {
						'one' => q({0} с.),
						'other' => q({0} с.),
						'per' => q({0}/с.),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(сед.),
						'one' => q({0} с.),
						'other' => q({0} с.),
						'per' => q({0}/с.),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(сед.),
						'one' => q({0} с.),
						'other' => q({0} с.),
						'per' => q({0}/с.),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(г.),
						'one' => q({0} г.),
						'other' => q({0} г.),
						'per' => q({0}/г.),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(г.),
						'one' => q({0} г.),
						'other' => q({0} г.),
						'per' => q({0}/г.),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(ohm),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(ohm),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'one' => q({0} US therm),
						'other' => q({0} US therms),
					},
					# Core Unit Identifier
					'therm-us' => {
						'one' => q({0} US therm),
						'other' => q({0} US therms),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(dot),
						'one' => q({0} dot),
						'other' => q({0} dot),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(dot),
						'one' => q({0} dot),
						'other' => q({0} dot),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(fathom),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(fathom),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(ft),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(ft),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(furlong),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(furlong),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(in),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(in),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(ly),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(ly),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(m),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(m),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(mi),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(mi),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(parsec),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(parsec),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(yd),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(yd),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(gr),
						'one' => q({0} gr),
						'other' => q({0} gr),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(gr),
						'one' => q({0} gr),
						'other' => q({0} gr),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(oz t),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(oz t),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(lb),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(lb),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(стоун),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(стоун),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(американски тон),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(американски тон),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(km/hr),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(km/hr),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(m/s),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(m/s),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(mi/hr),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(mi/hr),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(°C),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(°C),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(бушел),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(бушел),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(ft³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(ft³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(in³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(in³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(yd³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(yd³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(чаша),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(чаша),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(dsp),
						'one' => q({0} dsp),
						'other' => q({0} dsp),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(dsp),
						'one' => q({0} dsp),
						'other' => q({0} dsp),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(dsp Imp),
						'one' => q({0} dsp-Imp),
						'other' => q({0} dsp-Imp),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(dsp Imp),
						'one' => q({0} dsp-Imp),
						'other' => q({0} dsp-Imp),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(fl.dr.),
						'one' => q({0} fl.dr.),
						'other' => q({0} fl.dr.),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(fl.dr.),
						'one' => q({0} fl.dr.),
						'other' => q({0} fl.dr.),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(dr),
						'one' => q({0} dr),
						'other' => q({0} dr),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(dr),
						'one' => q({0} dr),
						'other' => q({0} dr),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(Imp fl oz),
						'one' => q({0} fl oz Im),
						'other' => q({0} fl oz Im),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(Imp fl oz),
						'one' => q({0} fl oz Im),
						'other' => q({0} fl oz Im),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'per' => q({0}/gal),
					},
					# Core Unit Identifier
					'gallon' => {
						'per' => q({0}/gal),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(Imp gal),
						'one' => q({0} galIm),
						'other' => q({0} galIm),
						'per' => q({0}/galIm),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(Imp gal),
						'one' => q({0} galIm),
						'other' => q({0} galIm),
						'per' => q({0}/galIm),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(литар),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(литар),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(pn),
						'one' => q({0} pn),
						'other' => q({0} pn),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(pn),
						'one' => q({0} pn),
						'other' => q({0} pn),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(pt),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(pt),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(pt),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(pt),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'one' => q({0} qt-Imp.),
						'other' => q({0} qt-Imp.),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'one' => q({0} qt-Imp.),
						'other' => q({0} qt-Imp.),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(насока),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(насока),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(гравитациска сила),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(гравитациска сила),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(метри/сек²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(метри/сек²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(arcmins),
						'one' => q({0} arcmin),
						'other' => q({0} arcmins),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(arcmins),
						'one' => q({0} arcmin),
						'other' => q({0} arcmins),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(arcsecs),
						'one' => q({0} arcsec),
						'other' => q({0} arcsecs),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(arcsecs),
						'one' => q({0} arcsec),
						'other' => q({0} arcsecs),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(степени),
						'one' => q({0} deg),
						'other' => q({0} deg),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(степени),
						'one' => q({0} deg),
						'other' => q({0} deg),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(акри),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(акри),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(дунами),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(дунами),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(хектари),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(хектари),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(квадратни стапки),
						'one' => q({0} sq ft),
						'other' => q({0} sq ft),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(квадратни стапки),
						'one' => q({0} sq ft),
						'other' => q({0} sq ft),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(метри²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(метри²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(кв. милји),
						'one' => q({0} sq mi),
						'other' => q({0} sq mi),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(кв. милји),
						'one' => q({0} sq mi),
						'other' => q({0} sq mi),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(јарди²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(јарди²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(ставка),
						'one' => q({0} ставка),
						'other' => q({0} ставки),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(ставка),
						'one' => q({0} ставка),
						'other' => q({0} ставки),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'one' => q({0} %),
						'other' => q({0} %),
					},
					# Core Unit Identifier
					'percent' => {
						'one' => q({0} %),
						'other' => q({0} %),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'one' => q({0} ‰),
						'other' => q({0} ‰),
					},
					# Core Unit Identifier
					'permille' => {
						'one' => q({0} ‰),
						'other' => q({0} ‰),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(mpg),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(mpg),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}И),
						'north' => q({0}С),
						'south' => q({0}Ј),
						'west' => q({0}З),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}И),
						'north' => q({0}С),
						'south' => q({0}Ј),
						'west' => q({0}З),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(бајт),
						'one' => q({0} бајт),
						'other' => q({0} бајти),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(бајт),
						'one' => q({0} бајт),
						'other' => q({0} бајти),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(kbit),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(kbit),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Mbit),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Mbit),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(MByte),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(MByte),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Tbit),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Tbit),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(TByte),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(TByte),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(в.),
						'one' => q({0} в.),
						'other' => q({0} в.),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(в.),
						'one' => q({0} в.),
						'other' => q({0} в.),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(дена),
						'one' => q({0} ден),
						'other' => q({0} дена),
						'per' => q({0}/ден),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(дена),
						'one' => q({0} ден),
						'other' => q({0} дена),
						'per' => q({0}/ден),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(дец.),
						'one' => q({0} дец.),
						'other' => q({0} дец.),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(дец.),
						'one' => q({0} дец.),
						'other' => q({0} дец.),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(часа),
						'one' => q({0} ч.),
						'other' => q({0} ч.),
						'per' => q({0}/ч.),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(часа),
						'one' => q({0} ч.),
						'other' => q({0} ч.),
						'per' => q({0}/ч.),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(мс),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(мс),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(мин.),
						'one' => q({0} мин.),
						'other' => q({0} мин.),
						'per' => q({0}/мин.),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(мин.),
						'one' => q({0} мин.),
						'other' => q({0} мин.),
						'per' => q({0}/мин.),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(месеци),
						'one' => q({0} мес.),
						'other' => q({0} мес.),
						'per' => q({0}/мес.),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(месеци),
						'one' => q({0} мес.),
						'other' => q({0} мес.),
						'per' => q({0}/мес.),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(наносек),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(наносек),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(тримесечја),
						'one' => q({0} тримес.),
						'other' => q({0} тримес.),
						'per' => q({0}/тримес.),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(тримесечја),
						'one' => q({0} тримес.),
						'other' => q({0} тримес.),
						'per' => q({0}/тримес.),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(сек.),
						'one' => q({0} сек.),
						'other' => q({0} сек.),
						'per' => q({0}/с),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(сек.),
						'one' => q({0} сек.),
						'other' => q({0} сек.),
						'per' => q({0}/с),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(седмици),
						'one' => q({0} сед.),
						'other' => q({0} сед.),
						'per' => q({0}/сед.),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(седмици),
						'one' => q({0} сед.),
						'other' => q({0} сед.),
						'per' => q({0}/сед.),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(години),
						'one' => q({0} год.),
						'other' => q({0} год.),
						'per' => q({0}/год.),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(години),
						'one' => q({0} год.),
						'other' => q({0} год.),
						'per' => q({0}/год.),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(оми),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(оми),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(V),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(V),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(J),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(J),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(US терм),
						'one' => q({0} US терм),
						'other' => q({0} US терми),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(US терм),
						'one' => q({0} US терм),
						'other' => q({0} US терми),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(dots),
						'one' => q({0} dot),
						'other' => q({0} dots),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(dots),
						'one' => q({0} dot),
						'other' => q({0} dots),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0} dpcm),
						'other' => q({0} dpcm),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0} dpcm),
						'other' => q({0} dpcm),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} dpi),
						'other' => q({0} dpi),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} dpi),
						'other' => q({0} dpi),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(фатоми),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(фатоми),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(стапки),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(стапки),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(фурлонзи),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(фурлонзи),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(инчи),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(инчи),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(свет. год.),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(свет. год.),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(метри),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(метри),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(милји),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(милји),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(парсеци),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(парсеци),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(јарди),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(јарди),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(карати),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(карати),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(грејн),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(грејн),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(g),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(g),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(тројска унца),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(тројска унца),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(фунти),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(фунти),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(стоуни),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(стоуни),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(американски тони),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(американски тони),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(W),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(W),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(mmHg),
						'one' => q({0} mmHg),
						'other' => q({0} mmHg),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(mmHg),
						'one' => q({0} mmHg),
						'other' => q({0} mmHg),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'one' => q({0} B),
						'other' => q({0} B),
					},
					# Core Unit Identifier
					'beaufort' => {
						'one' => q({0} B),
						'other' => q({0} B),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(км/час),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(км/час),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(метри/сек),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(метри/сек),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(милји/час),
						'one' => q({0} mph),
						'other' => q({0} mph),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(милји/час),
						'one' => q({0} mph),
						'other' => q({0} mph),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(целзиусови степени),
						'one' => q({0} °C),
						'other' => q({0} °C),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(целзиусови степени),
						'one' => q({0} °C),
						'other' => q({0} °C),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'one' => q({0} °F),
						'other' => q({0} °F),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'one' => q({0} °F),
						'other' => q({0} °F),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(acre ft),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(acre ft),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(бушели),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(бушели),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(стапки³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(стапки³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(инчи³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(инчи³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(јарди³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(јарди³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(чаши),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(чаши),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(драм течност),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(драм течност),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(капка),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(капка),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(џигер),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(џигер),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(литри),
						'one' => q({0} L),
						'other' => q({0} L),
						'per' => q({0}/L),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(литри),
						'one' => q({0} L),
						'other' => q({0} L),
						'per' => q({0}/L),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(пинти),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(пинти),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:да|д|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:не|н|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				end => q({0} и {1}),
				2 => q({0} и {1}),
		} }
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'group' => q(.),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'one' => '0 илјада',
					'other' => '0 илјади',
				},
				'10000' => {
					'one' => '00 илјада',
					'other' => '00 илјади',
				},
				'100000' => {
					'one' => '000 илјада',
					'other' => '000 илјади',
				},
				'1000000' => {
					'one' => '0 милион',
					'other' => '0 милиони',
				},
				'10000000' => {
					'one' => '00 милион',
					'other' => '00 милиони',
				},
				'100000000' => {
					'one' => '000 милион',
					'other' => '000 милиони',
				},
				'1000000000' => {
					'one' => '0 милијарда',
					'other' => '0 милијарди',
				},
				'10000000000' => {
					'one' => '00 милијарда',
					'other' => '00 милијарди',
				},
				'100000000000' => {
					'one' => '000 милијарда',
					'other' => '000 милијарди',
				},
				'1000000000000' => {
					'one' => '0 билион',
					'other' => '0 билиони',
				},
				'10000000000000' => {
					'one' => '00 билион',
					'other' => '00 билиони',
				},
				'100000000000000' => {
					'one' => '000 билион',
					'other' => '000 билиони',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 илј'.'',
					'other' => '0 илј'.'',
				},
				'10000' => {
					'one' => '00 илј'.'',
					'other' => '00 илј'.'',
				},
				'100000' => {
					'one' => '000 илј'.'',
					'other' => '000 илј'.'',
				},
				'1000000' => {
					'one' => '0 мил'.'',
					'other' => '0 мил'.'',
				},
				'10000000' => {
					'one' => '00 мил'.'',
					'other' => '00 мил'.'',
				},
				'100000000' => {
					'one' => '000 М',
					'other' => '000 М',
				},
				'1000000000' => {
					'one' => '0 милј'.'',
					'other' => '0 милј'.'',
				},
				'10000000000' => {
					'one' => '00 милј'.'',
					'other' => '00 милј'.'',
				},
				'100000000000' => {
					'one' => '000 мј'.'',
					'other' => '000 ми'.'',
				},
				'1000000000000' => {
					'one' => '0 бил'.'',
					'other' => '0 бил'.'',
				},
				'10000000000000' => {
					'one' => '00 бил'.'',
					'other' => '00 бил'.'',
				},
				'100000000000000' => {
					'one' => '000 бил'.'',
					'other' => '000 бил'.'',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0 %',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(Андорска Пезета),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(Дирхам на Обединети Арапски Емирати),
				'one' => q(Дирхам на Обединети Арапски Емирати),
				'other' => q(Дирхами на Обединети Арапски Емирати),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(Авгани \(1927–2002\)),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(Авганистански авгани),
				'one' => q(Авгани),
				'other' => q(Авгани),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(Албански лек),
				'one' => q(Албански лек),
				'other' => q(Албански леки),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(Ерменски драм),
				'one' => q(Ерменски драм),
				'other' => q(Ерменски драми),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(Холандски антилски гилдер),
				'one' => q(Холандски антилски гилдер),
				'other' => q(Холандски антилски гилдери),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(Анголска кванза),
				'one' => q(Анголска кванза),
				'other' => q(Анголски кванзи),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(Анголска Кванза \(1977–1990\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(Анголска нова Кванза \(1990–2000\)),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(Аргентински Пезос \(1983–1985\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(Аргентински пезос),
				'one' => q(Аргентински пезос),
				'other' => q(Аргентински пезоси),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(Австралиски Шилинг),
			},
		},
		'AUD' => {
			symbol => 'AUD',
			display_name => {
				'currency' => q(Австралиски долар),
				'one' => q(Австралиски долар),
				'other' => q(Австралиски долари),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(Арубиски флорин),
				'one' => q(Арубиски флорин),
				'other' => q(Арубиски флорини),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(Азербејџански манат),
				'one' => q(Азербејџански манат),
				'other' => q(Азербејџански манати),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(Босанско-Херцеговски Динар),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(Босанско-херцеговска конвертибилна марка),
				'one' => q(Босанско-херцеговска конвертибилна марка),
				'other' => q(Босанско-херцеговски конвертибилни марки),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(Барбадоски долар),
				'one' => q(Барбадоски долар),
				'other' => q(Барбадоски долари),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(Бангладешка така),
				'one' => q(Бангладешка така),
				'other' => q(Бангладешки таки),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(Белгиски Франк \(конвертибилен\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(Белгиски Франк),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(Белгиски Франк \(финансиски\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(Бугарски цврст лев),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(Бугарски лев),
				'one' => q(Бугарски лев),
				'other' => q(Бугарски левови),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(Бахреински динар),
				'one' => q(Бахреински динар),
				'other' => q(Бахреински динари),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(Бурундиски франк),
				'one' => q(Бурундиски франк),
				'other' => q(Бурундиски франци),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(Бермудски долар),
				'one' => q(Бермудски долар),
				'other' => q(Бермудски долари),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(Брунејски долар),
				'one' => q(Брунејски долар),
				'other' => q(Брунејски долари),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(Боливиски боливиано),
				'one' => q(Боливиски боливиано),
				'other' => q(Боливиски боливиани),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(Бразилски реал),
				'one' => q(Бразилски реал),
				'other' => q(Бразилски реали),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(Бахамски долар),
				'one' => q(Бахамски долар),
				'other' => q(Бахамски долари),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(Бутански нгултрум),
				'one' => q(Бутански нгултрум),
				'other' => q(Бутански нгултруми),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(Боцванска пула),
				'one' => q(Боцванска пула),
				'other' => q(Боцвански пули),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(Белоруска нова рубља \(1994–1999\)),
			},
		},
		'BYN' => {
			symbol => 'р.',
			display_name => {
				'currency' => q(Белоруска рубља),
				'one' => q(Белоруска рубља),
				'other' => q(Белоруски рубљи),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(Белоруска рубља \(2000–2016\)),
				'one' => q(Белоруска рубља \(2000–2016\)),
				'other' => q(Белоруски рубљи \(2000–2016\)),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(Белизиски долар),
				'one' => q(Белизиски долар),
				'other' => q(Белизиски долари),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(Канадски долар),
				'one' => q(Канадски долар),
				'other' => q(Канадски долари),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(Конголски франк),
				'one' => q(Конголски франк),
				'other' => q(Конголски франци),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(Швајцарски франк),
				'one' => q(Швајцарски франк),
				'other' => q(Швајцарски франци),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(Чилеански пезос),
				'one' => q(Чилеански пезос),
				'other' => q(Чилеански пезоси),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(Кинески јуан \(офшор\)),
			},
		},
		'CNY' => {
			symbol => 'CNY',
			display_name => {
				'currency' => q(Кинески јуан),
				'one' => q(Кинески јуан),
				'other' => q(Кинески јуани),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(Колумбиски пезос),
				'one' => q(Колумбиски пезос),
				'other' => q(Колумбиски пезоси),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(Костарикански колон),
				'one' => q(Костарикански колон),
				'other' => q(Костарикански колони),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(Чехословачка цврста корона),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(Кубански конвертибилен пезос),
				'one' => q(Кубански конвертибилен пезос),
				'other' => q(Кубански конвертибилни пезоси),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(Кубански пезос),
				'one' => q(Кубански пезос),
				'other' => q(Кубански пезоси),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(Зелено’ртски ескудо),
				'one' => q(Зелено’ртски ескудо),
				'other' => q(Зелено’ртски ескуди),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(Кипарска фунта),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(Чешка круна),
				'one' => q(Чешка круна),
				'other' => q(Чешки круни),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(Германска Марка),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(Џибутски франк),
				'one' => q(Џибутски франк),
				'other' => q(Џибутски франци),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(Данска круна),
				'one' => q(Данска круна),
				'other' => q(Дански круни),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(Доминикански пезос),
				'one' => q(Доминикански пезос),
				'other' => q(Доминикански пезоси),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(Алжирски динар),
				'one' => q(Алжирски динар),
				'other' => q(Алжирски динари),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(Египетска фунта),
				'one' => q(Египетска фунта),
				'other' => q(Египетски фунти),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(Еритрејска накфа),
				'one' => q(Еритрејска накфа),
				'other' => q(Еритрејски накфи),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(Шпанска Пезета),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(Етиописки бир),
				'one' => q(Етиописки бир),
				'other' => q(Етиописки бири),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(Евро),
				'one' => q(евро),
				'other' => q(евра),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(Финска марка),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(Фиџиски долар),
				'one' => q(Фиџиски долар),
				'other' => q(Фиџиски долари),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(Фолкландска фунта),
				'one' => q(Фолкландска фунта),
				'other' => q(Фолкландски фунти),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(Француски франк),
			},
		},
		'GBP' => {
			symbol => 'GBP',
			display_name => {
				'currency' => q(Британска фунта),
				'one' => q(Британска фунта),
				'other' => q(Британски фунти),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(Грузиски лари),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(Ганајски Седи),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(Гански седи),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(Гибралтарска фунта),
				'one' => q(Гибралтарска фунта),
				'other' => q(Гибралтарски фунти),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(Гамбиски даласи),
				'one' => q(Гамбиски Даласи),
				'other' => q(Гамбиски Даласи),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(Гвинејски франк),
				'one' => q(Гвинејски франк),
				'other' => q(Гвинејски франци),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(Грчка драхма),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(Гватемалски кветцал),
				'one' => q(Гватемалски кветцал),
				'other' => q(Гватемалски кветцали),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(Гвинејски Бисау пезос),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(Гвајански долар),
				'one' => q(Гвајански долар),
				'other' => q(Гвајански долари),
			},
		},
		'HKD' => {
			symbol => 'HKD',
			display_name => {
				'currency' => q(Хонгконшки долар),
				'one' => q(Хонгконшки долар),
				'other' => q(Хонгконшки долари),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(Хондурска лемпира),
				'one' => q(Хондурска лемпира),
				'other' => q(Хондурски лемпири),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(Хрватски динар),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(Хрватска куна),
				'one' => q(Хрватска куна),
				'other' => q(Хрватски куни),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(Хаитски гурд),
				'one' => q(Хаитски гурд),
				'other' => q(Хаитски гурди),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(Унгарска форинта),
				'one' => q(Унгарска форинта),
				'other' => q(Унгарски форинти),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(Индонезиска рупија),
				'one' => q(Индонезиска рупија),
				'other' => q(Индонезиски рупии),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(Ирска фунта),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(Изрелска фунта),
			},
		},
		'ILS' => {
			symbol => 'ILS',
			display_name => {
				'currency' => q(Израелски нов шекел),
				'one' => q(Израелски нов шекел),
				'other' => q(Израелски нови шекели),
			},
		},
		'INR' => {
			symbol => 'INR',
			display_name => {
				'currency' => q(Индиска рупија),
				'one' => q(Индиска рупија),
				'other' => q(Индиски рупии),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(Ирачки динар),
				'one' => q(Ирачки динар),
				'other' => q(Ирачки динари),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(Ирански риал),
				'one' => q(Ирански риал),
				'other' => q(Ирански риали),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(Исландска крона),
				'one' => q(Исландска крона),
				'other' => q(Исландски крони),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(Италијанска лира),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(Јамајкански долар),
				'one' => q(Јамајкански долар),
				'other' => q(Јамајкански долари),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(Јордански динар),
				'one' => q(Јордански динар),
				'other' => q(Јордански динари),
			},
		},
		'JPY' => {
			symbol => 'JPY',
			display_name => {
				'currency' => q(Јапонски јен),
				'one' => q(Јапонски јен),
				'other' => q(Јапонски јени),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(Кениски шилинг),
				'one' => q(Кениски шилинг),
				'other' => q(Кениски шилинзи),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(Киргистански сом),
				'one' => q(Киргистански сом),
				'other' => q(Киргистански соми),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(Камбоџиски рел),
				'one' => q(Камбоџиски рел),
				'other' => q(Камбоџиски рели),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(Коморски франк),
				'one' => q(Коморски франк),
				'other' => q(Коморски франци),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(Северно корејски вон),
				'one' => q(Северно корејски вон),
				'other' => q(Северно корејски вони),
			},
		},
		'KRW' => {
			symbol => 'KRW',
			display_name => {
				'currency' => q(Јужно корејски вон),
				'one' => q(Јужно корејски вон),
				'other' => q(Јужно корејски вони),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(Кувајтски динар),
				'one' => q(Кувајтски динар),
				'other' => q(Кувајтски динари),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(Кајмански долар),
				'one' => q(Кајмански долар),
				'other' => q(Кајмански долари),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(Казахстанска тенга),
				'one' => q(Казахстанска тенга),
				'other' => q(Казахстански тенги),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(Лаоски кип),
				'one' => q(Лаоски кип),
				'other' => q(Лаоски кипови),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(Либанска фунта),
				'one' => q(Либанска фунта),
				'other' => q(Либански фунти),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(Шриланканска рупија),
				'one' => q(Шриланканска рупија),
				'other' => q(Шриланкански рупии),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(Либериски долар),
				'one' => q(Либериски долар),
				'other' => q(Либериски долари),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(Лесотско лоти),
				'one' => q(Лесотски лоти),
				'other' => q(Лесотски лоти),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(Литваниска лита),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(Литваниски литаз),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(Луксембуршки франк),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(Латвијски лат),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(Латвијска рубља),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(Либијски динар),
				'one' => q(Либијски динар),
				'other' => q(Либијски динари),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(Марокански дирхам),
				'one' => q(Марокански дирхам),
				'other' => q(Марокански дирхами),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(Марокански франк),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(Молдавски леу),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(Малагасиски ариари),
			},
		},
		'MKD' => {
			symbol => 'ден.',
			display_name => {
				'currency' => q(Македонски денар),
				'one' => q(Македонски денар),
				'other' => q(Македонски денари),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(Малски франк),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(Мјанмарски киат),
				'one' => q(Мјанмарски киат),
				'other' => q(Мјанмарски киати),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(Монголиски тугрик),
				'one' => q(Монголиски тугрик),
				'other' => q(Монголиски тугрици),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(Макао патака),
				'one' => q(Макао патака),
				'other' => q(Макао патаки),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(Мавританска угија \(1973–2017\)),
				'one' => q(Мавританска угија \(1973–2017\)),
				'other' => q(Мавритански угии \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(Мавританска угија),
				'one' => q(Мавританска угија),
				'other' => q(Мавритански угии),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(Малтешка лира),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(Малтешка фунта),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(Мавританска рупија),
				'one' => q(Мавританска рупија),
				'other' => q(Мавритански рупии),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(Малдивска руфија),
				'one' => q(Малдивска руфија),
				'other' => q(Малдивски руфии),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(Малависка квача),
				'one' => q(Малависка квача),
				'other' => q(Малависки квачи),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(Мексикански пезос),
				'one' => q(Мексикански пезос),
				'other' => q(Мексикански пезоси),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(Мексикански сребрен пезос \(1861–1992\)),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(Малезиски рингит),
				'one' => q(Малезиски рингит),
				'other' => q(Малезиски рингити),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(Мозамбиско ескудо),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(Стар мозамбиски метикал),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(Мозамбиски метикал),
				'one' => q(Мозамбиски метикал),
				'other' => q(Мозамбиски метикали),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(Намибиски долар),
				'one' => q(Намибиски долар),
				'other' => q(Намибиски долари),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(Нигериска наира),
				'one' => q(Нигериска наира),
				'other' => q(Нигериски наири),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(Никарагванска кордоба \(1988–1991\)),
				'one' => q(Никарагванска кордоба \(1988–1991\)),
				'other' => q(Никарагвански кордоби \(1988–1991\)),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(Никарагванска кордоба),
				'one' => q(Никарагванска кордоба),
				'other' => q(Никарагвански кордоби),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(Холандски гилдер),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(Норвешка круна),
				'one' => q(Норвешка круна),
				'other' => q(Норвешки круни),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(Непалска рупија),
				'one' => q(Непалска рупија),
				'other' => q(Непалски рупии),
			},
		},
		'NZD' => {
			symbol => 'NZD',
			display_name => {
				'currency' => q(Новозеландски долар),
				'one' => q(Новозеландски долар),
				'other' => q(Новозеландски долари),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(Омански риал),
				'one' => q(Омански риал),
				'other' => q(Омански риали),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(Панамска балбоа),
				'one' => q(Панамска балбоа),
				'other' => q(Панамски балбои),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(Перуански сол),
				'one' => q(Перуански сол),
				'other' => q(Перуански соли),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(Перуански сол \(1863–1965\)),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(Папуа новогвинејска кина),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(Филипински пезос),
				'one' => q(Филипински пезос),
				'other' => q(Филипински пезоси),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(Пакистанска рупија),
				'one' => q(Пакистанска рупија),
				'other' => q(Пакистански рупии),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(Полска злота),
				'one' => q(Полска злота),
				'other' => q(Полски злоти),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(Полска злота \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(Португалско ескудо),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(Парагвајска гуарана),
				'one' => q(Парагвајска гуарана),
				'other' => q(Парагвајски гуарани),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(Катарски риал),
				'one' => q(Катарски риал),
				'other' => q(Катарски риали),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(Романска леи \(1952–2006\)),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(Романски леу),
				'one' => q(Романски леу),
				'other' => q(Романски леи),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(Српски динар),
				'one' => q(Српски динар),
				'other' => q(Српски динари),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(Руска рубља),
				'one' => q(Руска рубља),
				'other' => q(Руски рубљи),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(Руска рубља \(1991–1998\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(Руандски франк),
				'one' => q(Руандски франк),
				'other' => q(Руандски франци),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(Саудиски ријал),
				'one' => q(Саудиски ријал),
				'other' => q(Саудиски ријали),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(Соломонски долар),
				'one' => q(Соломонски долар),
				'other' => q(Соломонски долари),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(Сејшелска рупија),
				'one' => q(Сејшелска рупија),
				'other' => q(Сејшелски рупии),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(Стар судански динар),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(Суданска фунта),
				'one' => q(Суданска фунта),
				'other' => q(Судански фунти),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(Стара суданска фунта),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(Шведска круна),
				'one' => q(Шведска круна),
				'other' => q(Шведски круни),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(Сингапурски долар),
				'one' => q(Сингапурски долар),
				'other' => q(Сингапурски долари),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(Фунта на Света Елена),
				'one' => q(Фунта на Света Елена),
				'other' => q(Фунти на Света Елена),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(Словенечки толар),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(Словачка круна),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(Сиералеонско леоне),
				'one' => q(Сиералеонско леоне),
				'other' => q(Сиералеонски леони),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(Сиералеонско леоне \(1964—2022\)),
				'one' => q(Сиералеонско леоне \(1964—2022\)),
				'other' => q(Сиералеонски леони \(1964—2022\)),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(Сомалијски шилинг),
				'one' => q(Сомалијски шилинг),
				'other' => q(Сомалијски шилинзи),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(Суринамски долар),
				'one' => q(Суринамски долар),
				'other' => q(Суринамски долари),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(Суринамски гилдер),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(Јужносуданска фунта),
				'one' => q(Јужносуданска фунта),
				'other' => q(Јужносудански фунти),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(Добра на Саун Томе и Принсип \(1977–2017\)),
				'one' => q(Добра на Саун Томе и Принсип \(1977–2017\)),
				'other' => q(Добри на Саун Томе и Принсип \(1977–2017\)),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(Добра на Сао Томе и Принсипе),
				'one' => q(Добра на Сао Томе и Принсипе),
				'other' => q(Добри на Сао Томе и Принсипе),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(Советска рубља),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(Салвадорски колон),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(Сиријска фунта),
				'one' => q(Сиријска фунта),
				'other' => q(Сиријски фунти),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(Свазилендски лиланген),
				'one' => q(Свазилендски лиланген),
				'other' => q(Свазилендски лилангени),
			},
		},
		'THB' => {
			display_name => {
				'currency' => q(Таи бат),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(Таџикистанска рубља),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(Таџикистански сомони),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(Туркменистански манат),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(Туркменист. манат),
				'one' => q(Туркменистански манати),
				'other' => q(Туркменистански манати),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(Тунизиски динар),
				'one' => q(Тунизиски динар),
				'other' => q(Тунизиски динари),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(Тонганска панга),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(Тиморски ескудо),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(Турска лира \(1922–2005\)),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(Турска лира),
				'one' => q(Турска лира),
				'other' => q(Турски лири),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(Долар на Тринидад и Тобаго),
				'one' => q(Долар на Тринидад и Тобаго),
				'other' => q(Долари на Тринидад и Тобаго),
			},
		},
		'TWD' => {
			symbol => 'TWD',
			display_name => {
				'currency' => q(Тајвански нов долар),
				'one' => q(Тајвански нов долар),
				'other' => q(Тајвански нови долари),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(Танзаниски шилинг),
				'one' => q(Танзаниски шилинг),
				'other' => q(Танзаниски шилинзи),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(Украинска хривнија),
				'one' => q(Украинска хривнија),
				'other' => q(Украински хривнии),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(Угандиски шилинг \(1966–1987\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(Угандиски шилинг),
				'one' => q(Угандиски шилинг),
				'other' => q(Угандиски шилинзи),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(Американски долар),
				'one' => q(Американски долар),
				'other' => q(Американски долари),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(САД долар \(Next day\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(САД долар \(Same day\)),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(Уругвајски пезос \(1975–1993\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(Уругвајски пезос),
				'one' => q(Уругвајски пезос),
				'other' => q(Уругвајски пезоси),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(Узбекистански сом),
				'one' => q(Узбекистански сом),
				'other' => q(Узбекистански соми),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(Венецуелски боливар \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(Венецуелски боливар \(2008–2018\)),
				'one' => q(Венецуелски боливар \(2008–2018\)),
				'other' => q(Венецуелски боливари \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(Венецуелски боливар),
				'one' => q(Венецуелски боливар),
				'other' => q(Венецуелски боливари),
			},
		},
		'VND' => {
			symbol => 'VND',
			display_name => {
				'currency' => q(Виетнамски донг),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(Ванатски вату),
				'one' => q(Ванатски вату),
				'other' => q(Ванатски ватуи),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(Самоанска тала),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(Централноафрикански франк),
				'one' => q(Централноафрикански франк),
				'other' => q(Централноафрикански франци),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(Источнокарипски долар),
				'one' => q(Источнокарипски долар),
				'other' => q(Источнокарипски долари),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(Западноафрикански франк),
				'one' => q(Западноафрикански франк),
				'other' => q(Западноафрикански франци),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(ЦФП франк),
				'one' => q(ЦФП франк),
				'other' => q(ЦФП франци),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Непозната валута),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(Јеменски динар),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(Јеменски риал),
				'one' => q(Јеменски риал),
				'other' => q(Јеменски риали),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(Југословенски динар),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(Југословенски конвертибилен динар),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(Јужно афрички ранд\(финансиски\)),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(Јужноафрикански ранд),
				'one' => q(Јужноафрикански ранд),
				'other' => q(Јужноафрикански ранди),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(Замбијска квача \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(Замбијска квача),
				'one' => q(Замбијска квача),
				'other' => q(Замбијски квачи),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(Заирско новозаире),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(Заирско заире),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(Зимбабвиски долар),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					wide => {
						nonleap => [
							'тут',
							'баба',
							'хатор',
							'кијак',
							'тоба',
							'амшир',
							'барамхат',
							'барамуда',
							'башанс',
							'паона',
							'епеп',
							'месра',
							'наси'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					wide => {
						nonleap => [
							'мескерем',
							'текемт',
							'хедар',
							'тахсас',
							'тер',
							'јекатит',
							'мегабит',
							'миазиа',
							'генбот',
							'сене',
							'хамле',
							'нехасе',
							'пагумен'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'јан.',
							'фев.',
							'мар.',
							'апр.',
							'мај',
							'јун.',
							'јул.',
							'авг.',
							'сеп.',
							'окт.',
							'ное.',
							'дек.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'јануари',
							'февруари',
							'март',
							'април',
							'мај',
							'јуни',
							'јули',
							'август',
							'септември',
							'октомври',
							'ноември',
							'декември'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ј',
							'ф',
							'м',
							'а',
							'м',
							'ј',
							'ј',
							'а',
							'с',
							'о',
							'н',
							'д'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					wide => {
						nonleap => [
							'тишри',
							'хешван',
							'кислев',
							'тевет',
							'шеват',
							'адар I',
							'адар',
							'нисан',
							'ијар',
							'сиван',
							'тамуз',
							'ав',
							'елул'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'чаитра',
							'вајсака',
							'јаиста',
							'асада',
							'сравана',
							'бадра',
							'асвина',
							'картика',
							'аграхајана',
							'пауса',
							'мага',
							'фалгуна'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'мух.',
							'саф.',
							'раб. I',
							'раб. II',
							'џум. I',
							'џум. II',
							'раџ.',
							'шаб.',
							'рам.',
							'шав.',
							'дулк.',
							'дулх.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'мухарем',
							'сафар',
							'раби I',
							'раби II',
							'џумада I',
							'џумада II',
							'раџаб',
							'шабан',
							'рамадан',
							'шавал',
							'дулкида',
							'дулхиџа'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					wide => {
						nonleap => [
							'фарвардин',
							'ордибехешт',
							'кордад',
							'тир',
							'мордад',
							'шахривар',
							'мер',
							'абан',
							'азар',
							'деј',
							'бахман',
							'есфанд'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'пон.',
						tue => 'вто.',
						wed => 'сре.',
						thu => 'чет.',
						fri => 'пет.',
						sat => 'саб.',
						sun => 'нед.'
					},
					wide => {
						mon => 'понеделник',
						tue => 'вторник',
						wed => 'среда',
						thu => 'четврток',
						fri => 'петок',
						sat => 'сабота',
						sun => 'недела'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'п',
						tue => 'в',
						wed => 'с',
						thu => 'ч',
						fri => 'п',
						sat => 'с',
						sun => 'н'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'јан – мар',
						1 => 'апр – јун',
						2 => 'јул – сеп',
						3 => 'окт – дек'
					},
					wide => {0 => 'прво тримесечје',
						1 => 'второ тримесечје',
						2 => 'трето тримесечје',
						3 => 'четврто тримесечје'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'roc') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 400;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{попладне},
					'am' => q{претпл.},
					'evening1' => q{навечер},
					'midnight' => q{полноќ},
					'morning1' => q{наутро},
					'morning2' => q{претпладне},
					'night1' => q{ноќе},
					'noon' => q{напладне},
					'pm' => q{попл.},
				},
				'narrow' => {
					'afternoon1' => q{попл.},
					'evening1' => q{навечер},
					'midnight' => q{полн.},
					'morning1' => q{наутро},
					'morning2' => q{претпл.},
					'night1' => q{ноќе},
					'noon' => q{напл.},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{попл.},
					'evening1' => q{вечер},
					'morning1' => q{утро},
					'morning2' => q{претпл.},
					'night1' => q{ноќ},
					'noon' => q{пладне},
				},
				'wide' => {
					'afternoon1' => q{попладне},
					'evening1' => q{вечер},
					'morning1' => q{утро},
					'morning2' => q{претпладне},
					'night1' => q{ноќ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
			abbreviated => {
				'0' => 'ЕРА0',
				'1' => 'ЕРА1'
			},
		},
		'ethiopic' => {
			abbreviated => {
				'0' => 'ЕРА0',
				'1' => 'ЕРА1'
			},
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'п.н.е.',
				'1' => 'н.е.'
			},
			wide => {
				'0' => 'пред нашата ера',
				'1' => 'од нашата ера'
			},
		},
		'hebrew' => {
		},
		'indian' => {
			abbreviated => {
				'0' => 'Сака'
			},
		},
		'islamic' => {
		},
		'persian' => {
			abbreviated => {
				'0' => 'АП'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'пр. Р.К.',
				'1' => 'мингуо'
			},
			wide => {
				'0' => 'пред Р.К.'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			'full' => q{EEEE, dd MMMM y 'г'. G},
			'long' => q{dd MMMM y 'г'. G},
			'medium' => q{dd.M.y G},
			'short' => q{dd.M.y GGGGG},
		},
		'coptic' => {
			'full' => q{EEEE, dd MMMM y 'г'. G},
			'long' => q{dd MMMM y 'г'. G},
			'medium' => q{dd.M.y G},
			'short' => q{dd.M.y GGGGG},
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE, d MMMM y 'г'. G},
			'long' => q{d MMMM y 'г'. G},
			'medium' => q{d.M.y G},
			'short' => q{d.M.y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM y},
			'long' => q{d MMMM y},
			'medium' => q{d.M.y},
			'short' => q{d.M.yy},
		},
		'hebrew' => {
			'full' => q{EEEE, dd MMMM y 'г'. G},
			'long' => q{dd MMMM y 'г'. G},
			'medium' => q{dd.M.y G},
			'short' => q{dd.M.y GGGGG},
		},
		'indian' => {
		},
		'islamic' => {
			'full' => q{EEEE, dd MMMM y 'г'. G},
			'long' => q{dd MMMM y 'г'. G},
			'medium' => q{dd.M.y G},
			'short' => q{dd.M.y GGGGG},
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'coptic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'hebrew' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'indian' => {
		},
		'islamic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			Ed => q{d E},
			GyMMMEd => q{E, dd MMM y 'г'. G},
			GyMMMd => q{dd MMM y 'г'. G},
			MEd => q{E, dd.M},
			MMMEd => q{E, dd MMM},
			MMMMEd => q{E, dd MMMM},
			MMMMd => q{dd MMMM},
			MMMd => q{dd MMM},
			Md => q{dd.M},
			yyyyMEd => q{E, dd.M.y G},
			yyyyMMMEd => q{E, dd MMM y 'г'. G},
			yyyyMMMd => q{dd MMM y 'г'. G},
			yyyyMd => q{dd.M.y G},
		},
		'generic' => {
			E => q{E},
			EHm => q{E H:mm},
			EHms => q{E H:mm:ss},
			Ed => q{E, d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y 'г'. G},
			GyMMM => q{MMM y 'г'. G},
			GyMMMEd => q{E, d MMM y 'г'. G},
			GyMMMd => q{d MMM y 'г'. G},
			GyMd => q{d.M.y GGGGG},
			H => q{H},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			MEd => q{E, d.M},
			MMMEd => q{E, d MMM},
			MMMMEd => q{E, d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d.M},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			y => q{y 'г'. G},
			yyyy => q{y 'г'. G},
			yyyyM => q{M.y G},
			yyyyMEd => q{E, d.M.y G},
			yyyyMMM => q{MMM y 'г'. G},
			yyyyMMMEd => q{E, d MMM y 'г'. G},
			yyyyMMMM => q{MMMM y 'г'. G},
			yyyyMMMd => q{d MMM y 'г'. G},
			yyyyMd => q{d.M.y G},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQ y G},
		},
		'gregorian' => {
			Ed => q{E, d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM y G},
			GyMMMd => q{d MMM y G},
			GyMd => q{d.M.y GGGGG},
			MEd => q{E, d.M},
			MMMEd => q{E, d MMM},
			MMMMEd => q{E, d MMMM},
			MMMMW => q{W. 'седмица' 'од' MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d.M},
			Mdd => q{d.M},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			yM => q{M.y},
			yMEd => q{E, d.M.y},
			yMMM => q{MMM y 'г'.},
			yMMMEd => q{E, d MMM y 'г'.},
			yMMMM => q{MMMM y 'г'.},
			yMMMd => q{d MMM y 'г'.},
			yMd => q{d.M.y},
			yQQQ => q{QQQ y 'г'.},
			yQQQQ => q{QQQQ y 'г'.},
			yw => q{w. 'седмица' 'од' Y},
		},
		'hebrew' => {
			Ed => q{d E},
			GyMMMEd => q{E, dd MMM y 'г'. G},
			GyMMMd => q{dd MMM y 'г'. G},
			MEd => q{E, dd.M},
			MMMEd => q{E, dd MMM},
			MMMMEd => q{E, dd MMMM},
			MMMMd => q{dd MMMM},
			MMMd => q{dd MMM},
			Md => q{dd.M},
			yyyyMEd => q{E, dd.M.y G},
			yyyyMMMEd => q{E, dd MMM y 'г'. G},
			yyyyMMMd => q{dd MMM y 'г'. G},
			yyyyMd => q{dd.M.y G},
		},
		'islamic' => {
			Ed => q{d E},
			GyMMMEd => q{E, dd MMM y 'г'. G},
			GyMMMd => q{dd MMM y 'г'. G},
			MEd => q{E, dd.M},
			MMMEd => q{E, dd MMM},
			MMMMEd => q{E, dd MMMM},
			MMMMd => q{dd MMMM},
			MMMd => q{dd MMM},
			Md => q{dd.M},
			yyyyMEd => q{E, dd.M.y G},
			yyyyMMMEd => q{E, dd MMM y 'г'. G},
			yyyyMMMd => q{dd MMM y 'г'. G},
			yyyyMd => q{dd.M.y G},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.M – E, dd.M},
				d => q{E, dd.M – E, dd.M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, dd MMM – E, dd MMM},
				d => q{E, dd – E, dd MMM},
			},
			MMMM => {
				M => q{LLLL–LLLL},
			},
			MMMd => {
				M => q{dd MMM – dd MMM},
				d => q{dd–dd MMM},
			},
			Md => {
				M => q{dd.M – dd.M},
				d => q{dd.M – dd.M},
			},
			fallback => '{0} - {1}',
			y => {
				y => q{y–y G},
			},
			yMEd => {
				M => q{E, dd.M.y – E, dd.M.y G},
				d => q{E, dd.M.y – E, dd.M.y G},
				y => q{E, dd.M.y – E, dd.M.y G},
			},
			yMMM => {
				M => q{MMM–MMM y G},
			},
			yMMMEd => {
				M => q{E, dd MMM – E, dd MMM y G},
				d => q{E, dd – E, dd MMM y G},
				y => q{E, dd MMM y – E, dd MMM y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
			},
			yMMMd => {
				M => q{dd MMM – dd MMM y G},
				d => q{dd–dd MMM y G},
				y => q{dd MMM y – dd MMM y G},
			},
			yMd => {
				M => q{dd.M.y – dd.M.y G},
				d => q{dd.M.y – dd.M.y G},
				y => q{dd.M.y – dd.M.y G},
			},
		},
		'generic' => {
			Bh => {
				h => q{h – h B},
			},
			Bhm => {
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{M.y GGGGG – M.y GGGGG},
				M => q{M.y – M.y GGGGG},
				y => q{M.y – M.y GGGGG},
			},
			GyMEd => {
				G => q{E, d.M.y GGGGG – E, d.M.y GGGGG},
				M => q{E, d.M.y – E, d.M.y GGGGG},
				d => q{E, d.M.y – E, d.M.y GGGGG},
				y => q{E, d.M.y – E, d.M.y GGGGG},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E, d MMM y G – E, d MMM y G},
				M => q{E, d MMM – E, d MMM y G},
				d => q{E, d MMM – E, d MMM y G},
				y => q{E, d MMM y – E, d MMM y G},
			},
			GyMMMd => {
				G => q{d MMM y G – d MMM y G},
				M => q{d MMM – d MMM y G},
				d => q{d – d MMM y G},
				y => q{d MMM y – d MMM y G},
			},
			GyMd => {
				G => q{d.M.y GGGGG – d.M.y GGGGG},
				M => q{d.M.y – d.M.y GGGGG},
				d => q{d.M.y – d.M.y GGGGG},
				y => q{d.M.y – d.M.y GGGGG},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E, d.M – E, d.M},
				d => q{E, d.M – E, d.M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d – E, d MMM},
			},
			MMMM => {
				M => q{LLLL – LLLL},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{d.M – d.M},
				d => q{d.M – d.M},
			},
			d => {
				d => q{d – d},
			},
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y – y G},
			},
			yM => {
				M => q{M.y – M.y G},
				y => q{M.y – M.y G},
			},
			yMEd => {
				M => q{E, d.M.y – E, d.M.y G},
				d => q{E, d.M.y – E, d.M.y G},
				y => q{E, d.M.y – E, d.M.y G},
			},
			yMMM => {
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y G},
				d => q{E, d – E, d MMM y G},
				y => q{E, d MMM y – E, d MMM y G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM y G},
				d => q{d – d MMM y G},
				y => q{d MMM y – d MMM y G},
			},
			yMd => {
				M => q{d.M.y – d.M.y G},
				d => q{d.M.y – d.M.y G},
				y => q{d.M.y – d.M.y G},
			},
		},
		'gregorian' => {
			Bh => {
				h => q{h – h B},
			},
			Bhm => {
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{M.y GGGGG – M.y GGGGG},
				M => q{M.y – M.y GGGGG},
				y => q{M.y – M.y GGGGG},
			},
			GyMEd => {
				G => q{E, d.M.y GGGGG – E, d.M.y GGGGG},
				M => q{E, d.M.y – E, d.M.y GGGGG},
				d => q{E, d.M.y – E, d.M.y GGGGG},
				y => q{E, d.M.y – E, d.M.y GGGGG},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E, d MMM y G – E, d MMM y G},
				M => q{E, d MMM – E, d MMM y G},
				d => q{E, d MMM – E, d MMM y G},
				y => q{E, d MMM y – E, d MMM y G},
			},
			GyMMMd => {
				G => q{d MMM y G – d MMM y G},
				M => q{d MMM – d MMM y G},
				d => q{d – d MMM y G},
				y => q{d MMM y – d MMM y G},
			},
			GyMd => {
				G => q{d.M.y GGGGG – d.M.y GGGGG},
				M => q{d.M.y – d.M.y GGGGG},
				d => q{d.M.y – d.M.y GGGGG},
				y => q{d.M.y – d.M.y GGGGG},
			},
			H => {
				H => q{HH – HH},
			},
			Hm => {
				H => q{HH:mm – HH:mm},
				m => q{HH:mm – HH:mm},
			},
			Hmv => {
				H => q{HH:mm – HH:mm v},
				m => q{HH:mm – HH:mm v},
			},
			Hv => {
				H => q{HH – HH v},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E, d.M – E, d.M},
				d => q{E, d.M – E, d.M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d – E, d MMM},
			},
			MMMM => {
				M => q{LLLL – LLLL},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{d.M – d.M},
				d => q{d.M – d.M},
			},
			d => {
				d => q{d – d},
			},
			h => {
				a => q{h a – h a},
				h => q{h – h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm – h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm – h:mm a v},
				m => q{h:mm – h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h – h a v},
			},
			y => {
				y => q{y – y},
			},
			yM => {
				M => q{M.y – M.y},
				y => q{M.y – M.y},
			},
			yMEd => {
				M => q{E, d.M.y – E, d.M.y},
				d => q{E, d.M.y – E, d.M.y},
				y => q{E, d.M.y – E, d.M.y},
			},
			yMMM => {
				M => q{MMM – MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y},
				d => q{E, d – E, d MMM y},
				y => q{E, d MMM y – E, d MMM y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d – d MMM y},
				y => q{d MMM y – d MMM y},
			},
			yMd => {
				M => q{d.M.y – d.M.y},
				d => q{d.M.y – d.M.y},
				y => q{d.M.y – d.M.y},
			},
		},
		'hebrew' => {
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.M – E, dd.M},
				d => q{E, dd.M – E, dd.M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, dd MMM – E, dd MMM},
				d => q{E, dd – E, dd MMM},
			},
			MMMM => {
				M => q{LLLL–LLLL},
			},
			MMMd => {
				M => q{dd MMM – dd MMM},
				d => q{dd–dd MMM},
			},
			Md => {
				M => q{dd.M – dd.M},
				d => q{dd.M – dd.M},
			},
			fallback => '{0} - {1}',
			y => {
				y => q{y–y G},
			},
			yMEd => {
				M => q{E, dd.M.y – E, dd.M.y G},
				d => q{E, dd.M.y – E, dd.M.y G},
				y => q{E, dd.M.y – E, dd.M.y G},
			},
			yMMM => {
				M => q{MMM–MMM y G},
			},
			yMMMEd => {
				M => q{E, dd MMM – E, dd MMM y G},
				d => q{E, dd – E, dd MMM y G},
				y => q{E, dd MMM y – E, dd MMM y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
			},
			yMMMd => {
				M => q{dd MMM – dd MMM y G},
				d => q{dd–dd MMM y G},
				y => q{dd MMM y – dd MMM y G},
			},
			yMd => {
				M => q{dd.M.y – dd.M.y G},
				d => q{dd.M.y – dd.M.y G},
				y => q{dd.M.y – dd.M.y G},
			},
		},
		'islamic' => {
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.M – E, dd.M},
				d => q{E, dd.M – E, dd.M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, dd MMM – E, dd MMM},
				d => q{E, dd – E, dd MMM},
			},
			MMMM => {
				M => q{LLLL–LLLL},
			},
			MMMd => {
				M => q{dd MMM – dd MMM},
				d => q{dd–dd MMM},
			},
			Md => {
				M => q{dd.M – dd.M},
				d => q{dd.M – dd.M},
			},
			fallback => '{0} - {1}',
			y => {
				y => q{y–y G},
			},
			yMEd => {
				M => q{E, dd.M.y – E, dd.M.y G},
				d => q{E, dd.M.y – E, dd.M.y G},
				y => q{E, dd.M.y – E, dd.M.y G},
			},
			yMMM => {
				M => q{MMM–MMM y G},
			},
			yMMMEd => {
				M => q{E, dd MMM – E, dd MMM y G},
				d => q{E, dd – E, dd MMM y G},
				y => q{E, dd MMM y – E, dd MMM y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
			},
			yMMMd => {
				M => q{dd MMM – dd MMM y G},
				d => q{dd–dd MMM y G},
				y => q{dd MMM y – dd MMM y G},
			},
			yMd => {
				M => q{dd.M.y – dd.M.y G},
				d => q{dd.M.y – dd.M.y G},
				y => q{dd.M.y – dd.M.y G},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		regionFormat => q(Време во {0}),
		'Acre' => {
			long => {
				'daylight' => q#Акре летно сметање на времето#,
				'generic' => q#Акре време#,
				'standard' => q#Акре стандардно време#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#Време во Авганистан#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиџан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Акра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Адис Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмара#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Банги#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банџул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантајр#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Бразавил#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Буџумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каиро#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Казабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар ес Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Џибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Ел Ајун#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Јоханесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Џуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Картум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либрвил#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуто#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишу#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровија#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Најроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нџамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Нијамеј#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Саун Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#Средноафриканско време#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#Источноафриканско време#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#Време во Јужноафриканска Република#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#Западноафриканско летно сметање на времето#,
				'generic' => q#Западноафриканско време#,
				'standard' => q#Западноафриканско стандардно време#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#Летно сметање на времето во Алјаска#,
				'generic' => q#Време во Алјаска#,
				'standard' => q#Стандардно време во Алјаска#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#Летно сметање на времето во Амазон#,
				'generic' => q#Време во Амазон#,
				'standard' => q#Стандардно време во Амазон#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Енкориџ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангвила#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антига#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагвајана#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио Галегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан Луис#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуаја#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсион#,
		},
		'America/Bahia' => {
			exemplarCity => q#Бахиа#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Бахија де Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белизе#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Сејблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бојзи#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буенос Аирес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кембриџ Беј#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампо Гранде#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кајена#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кајмански Острови#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чивава#,
		},
		'America/Ciudad_Juarez' => {
			exemplarCity => q#Сиудад Хуарез#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Корал Харбор#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордоба#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Костарика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Кујаба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Курасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмаркшан#,
		},
		'America/Dawson' => {
			exemplarCity => q#Досон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Досон Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детроит#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Едмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Еирунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Ел Салвадор#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#Форт Нелсон#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глејс Беј#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нук#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус Беј#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Турк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гвадалупе#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гвајакил#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гвајана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Халифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Хавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Ермосиљо#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индијана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индијана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питерсбург, Индијана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Тел Сити, Индијана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вивеј, Индијана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Венсен, Индијана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Винамак, Индијана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индијанаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Икалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Јамајка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Хухуј#,
		},
		'America/Juneau' => {
			exemplarCity => q#Џуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичело, Кентаки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендајк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла Паз#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос Анџелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луизвил#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Долен Принс квортр#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масејо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагва#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиник#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Мазатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоза#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мексико Сити#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелан#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтереј#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсерат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Насау#,
		},
		'America/New_York' => {
			exemplarCity => q#Њујорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Нороња#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Бјула, Северна Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Центар, Северна Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Њу Салем, Северна Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангниртунг#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Феникс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт о Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт ов Спејн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порто Вељо#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Порторико#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#Пунта Аренас#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рејни Ривер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ренкин Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифи#,
		},
		'America/Regina' => {
			exemplarCity => q#Реџајна#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резолут#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рио Бранко#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Света Изабела#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантијаго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сао Паоло#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Итокортормит#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сент Бартоломеј#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент Џонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Свети Китс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Сент Лусија#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт Курент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигалпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Тандр Беј#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Вајтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Винипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Јакутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Јелоунајф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#Централно летно сметање на времето во Северна Америка#,
				'generic' => q#Централно време во Северна Америка#,
				'standard' => q#Централно стандардно време во Северна Америка#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#Источно летно сметање на времето во Северна Америка#,
				'generic' => q#Источно време во Северна Америка#,
				'standard' => q#Источно стандардно време во Северна Америка#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#Планинско летно сметање на времето во Северна Америка#,
				'generic' => q#Планинско време во Северна Америка#,
				'standard' => q#Планинско стандардно време во Северна Америка#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#Пацифичко летно сметање на времето во Северна Америка#,
				'generic' => q#Пацифичко време во Северна Америка#,
				'standard' => q#Пацифичко стандардно време во Северна Америка#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#Анадирско летно време#,
				'generic' => q#Анадирско време#,
				'standard' => q#Анадирско стандардно време#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кејси#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дејвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Димон Дирвил#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маквори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Мосон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Макмурдо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Сајова#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Трол#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q#Летно време во Апија#,
				'generic' => q#Време во Апија#,
				'standard' => q#Стандардно време во Апија#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#Арапско летно сметање на времето#,
				'generic' => q#Арапско време#,
				'standard' => q#Стандардно арапско време#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгјербијен#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#Летно сметање на времето во Аргентина#,
				'generic' => q#Време во Аргентина#,
				'standard' => q#Стандардно време во Аргентина#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#Летно сметање на времето во западна Аргентина#,
				'generic' => q#Време во западна Аргентина#,
				'standard' => q#Стандардно време во западна Аргентина#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#Летно време во Ерменија#,
				'generic' => q#Време во Ерменија#,
				'standard' => q#Стандардно време во Ерменија#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алмати#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Аман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадир#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Актобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашкабад#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#Атирау#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахреин#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#Барнаул#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бејрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Брунеј#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калкута#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Чита#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чојбалсан#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дака#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубаи#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#Фамагуста#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеброн#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Хонг Конг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркутск#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Џакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Џајапура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Ерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандига#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Краснојарск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучинг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувајт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макасар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Мускат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никозија#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузњецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пном Пен#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтијанак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пјонгјанг#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#Костанај#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кизилорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Ријад#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хо Ши Мин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сакалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шангај#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Среднеколимск#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тајпеј#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Техеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тимпу#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#Томск#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Урумчи#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Уст-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Виентијан#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Јакутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Екатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Ереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#Атлантско летно сметање на времето#,
				'generic' => q#Атлантско време#,
				'standard' => q#Атлантско стандардно време#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азорски Острови#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуди#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канарски Острови#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Кабо Верде#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарски Острови#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадеира#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рејкјавик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Јужна Џорџија#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Света Елена#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стенли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Бризбејн#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен Хил#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Курие#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Јукла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд Хау#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мелбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сиднеј#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#Летно сметање на времето во Централна Австралија#,
				'generic' => q#Време во Централна Австралија#,
				'standard' => q#Стандардно време во Централна Австралија#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#Летно сметање на времето во Централна и Западна Австралија#,
				'generic' => q#Време во Централна и Западна Австралија#,
				'standard' => q#Стандардно време во Централна и Западна Австралија#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#Летно сметање на времето во Источна Австралија#,
				'generic' => q#Време во Источна Австралија#,
				'standard' => q#Стандардно време во Источна Австралија#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#Летно сметање на времето во Западна Австралија#,
				'generic' => q#Време во Западна Австралија#,
				'standard' => q#Стандардно време во Западна Австралија#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#Летно време во Азербејџан#,
				'generic' => q#Време во Азербејџан#,
				'standard' => q#Стандардно време во Азербејџан#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#Летно време во Азорски Острови#,
				'generic' => q#Време во Азорски Острови#,
				'standard' => q#Стандардно време во Азорски Острови#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#Летно време во Бангладеш#,
				'generic' => q#Време во Бангладеш#,
				'standard' => q#Стандардно време во Бангладеш#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#Време во Бутан#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#Време во Боливија#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#Летно сметање на времето во Бразилија#,
				'generic' => q#Време во Бразилија#,
				'standard' => q#Стандардно време во Бразилија#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#Време во Брунеј Дарусалам#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#Летно сметање на времето во Кабо Верде#,
				'generic' => q#Време во Кабо Верде#,
				'standard' => q#Стандардно време во Кабо Верде#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#Време во Чаморо#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#Летно сметање на времето во Чатам#,
				'generic' => q#Време во Чатам#,
				'standard' => q#Стандардно време во Чатам#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#Летно сметање на времето во Чиле#,
				'generic' => q#Време во Чиле#,
				'standard' => q#Стандардно време во Чиле#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#Летно сметање на времето во Кина#,
				'generic' => q#Време во Кина#,
				'standard' => q#Стандардно време во Кина#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#Летно време во Чојбалсан#,
				'generic' => q#Време во Чојбалсан#,
				'standard' => q#Стандардно време во Чојбалсан#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#Време во Божиќен Остров#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#Време во Кокосови Острови#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#Летно сметање на времето во Колумбија#,
				'generic' => q#Време во Колумбија#,
				'standard' => q#Стандардно време во Колумбија#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#Летно време во Кукови Острови#,
				'generic' => q#Време во Кукови Острови#,
				'standard' => q#Стандардно време во Кукови Острови#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#Летно сметање на времето во Куба#,
				'generic' => q#Време во Куба#,
				'standard' => q#Стандардно време во Куба#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#Време во Дејвис#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#Време во Димон Дирвил#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#Време во Источен Тимор#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#Летно време во Велигденски Остров#,
				'generic' => q#Време во Велигденски Остров#,
				'standard' => q#Стандардно време во Велигденски Остров#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#Време во Еквадор#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#Координирано универзално време#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Непознат град#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андора#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#Астрахан#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Атина#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брисел#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Букурешт#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будимпешта#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бизинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинау#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенхаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Даблин#,
			long => {
				'daylight' => q#Ирско стандардно време#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернзи#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хелсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Остров Ман#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Истанбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Џерзи#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Киев#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#Киров#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лисабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Љубљана#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q#Британско летно време#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Луксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Малта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Маријехамен#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париз#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараево#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#Саратов#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферопол#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопје#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Софија#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокхолм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Талин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#Улјановск#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуц#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Виена#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вилнус#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожје#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цирих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#Средноевропско летно време#,
				'generic' => q#Средноевропско време#,
				'standard' => q#Средноевропско стандардно време#,
			},
			short => {
				'daylight' => q#CEST#,
				'generic' => q#CET#,
				'standard' => q#CET#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#Источноевропско летно време#,
				'generic' => q#Источноевропско време#,
				'standard' => q#Источноевропско стандардно време#,
			},
			short => {
				'daylight' => q#EEST#,
				'generic' => q#EET#,
				'standard' => q#EET#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#Калининградско време#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#Западноевропско летно време#,
				'generic' => q#Западноевропско време#,
				'standard' => q#Западноевропско стандардно време#,
			},
			short => {
				'daylight' => q#WEST#,
				'generic' => q#WET#,
				'standard' => q#WET#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#Летно сметање на времето во Фолкландски Острови#,
				'generic' => q#Време во Фолкландски Острови#,
				'standard' => q#Стандардно време во Фолкландски Острови#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#Летно време во Фиџи#,
				'generic' => q#Време во Фиџи#,
				'standard' => q#Стандардно време во Фиџи#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#Време во Француска Гвајана#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#Француско јужно и антарктичко време#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#Средно време по Гринич#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#Време во Галапагос#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#Време во Гамбе#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#Летно време во Грузија#,
				'generic' => q#Време во Грузија#,
				'standard' => q#Стандардно време во Грузија#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#Време во Гилбертови Острови#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#Летно сметање на времето во Источен Гренланд#,
				'generic' => q#Време во Источен Гренланд#,
				'standard' => q#Стандардно време во Источен Гренланд#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#Летно сметање на времето во Западен Гренланд#,
				'generic' => q#Време во Западен Гренланд#,
				'standard' => q#Стандардно време во Западен Гренланд#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#Време во Персиски Залив#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#Време во Гвајана#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#Летно сметање на времето во Хаваи - Алеутски острови#,
				'generic' => q#Време во Хаваи - Алеутски острови#,
				'standard' => q#Стандардно време во Хаваи - Алеутски острови#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#Летно време во Хонг Конг#,
				'generic' => q#Време во Хонг Конг#,
				'standard' => q#Стандардно време во Хонг Конг#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#Летно време во Ховд#,
				'generic' => q#Време во Ховд#,
				'standard' => q#Стандардно време во Ховд#,
			},
		},
		'India' => {
			long => {
				'standard' => q#Време во Индија#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариво#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Божиќен Остров#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокосови Острови#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Комори#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Махе#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Малдиви#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маврициус#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Мајот#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Рејунион#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#Време во Индиски океан#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#Време во Индокина#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#Време во Централна Индонезија#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#Време во Источна Индонезија#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#Време во Западна Индонезија#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#Летно сметање на времето во Иран#,
				'generic' => q#Време во Иран#,
				'standard' => q#Стандардно време во Иран#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#Летно време во Иркутск#,
				'generic' => q#Време во Иркутск#,
				'standard' => q#Стандардно време во Иркутск#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#Летно сметање на времето во Израел#,
				'generic' => q#Време во Израел#,
				'standard' => q#Стандардно време во Израел#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#Летно сметање на времето во Јапонија#,
				'generic' => q#Време во Јапонија#,
				'standard' => q#Стандардно време во Јапонија#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#Време во Источен Казахстан#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#Време во Западен Казахстан#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#Летно сметање на времето во Кореја#,
				'generic' => q#Време во Кореја#,
				'standard' => q#Стандардно време во Кореја#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#Време во Косра#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#Летно време во Краснојарск#,
				'generic' => q#Време во Краснојарск#,
				'standard' => q#Стандардно време во Краснојарск#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#Време во Киргистан#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#Време во Линиски Острови#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#Летно сметање на времето во Лорд Хау#,
				'generic' => q#Време во Лорд Хау#,
				'standard' => q#Стандардно време во Лорд Хау#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#Време на Островот Макуари#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#Летно време во Магадан#,
				'generic' => q#Време во Магадан#,
				'standard' => q#Стандардно време во Магадан#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#Време во Малезија#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#Време во Малдиви#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#Време во Маркесас#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#Време во Маршалски Острови#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#Летно сметање на времето во Маврициус#,
				'generic' => q#Време во Маврициус#,
				'standard' => q#Стандардно време во Маврициус#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#Време во Мосон#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#Летно сметање на времето во северозападно Мексико#,
				'generic' => q#Време во северозападно Мексико#,
				'standard' => q#Стандардно време во северозападно Мексико#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#Летно пацифичко време во Мексико#,
				'generic' => q#Пацифичко време во Мексико#,
				'standard' => q#Стандардно пацифичко време во Мексико#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#Летно време во Улан Батор#,
				'generic' => q#Време во Улан Батор#,
				'standard' => q#Стандардно време во Улан Батор#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#Летно сметање на времето во Москва#,
				'generic' => q#Време во Москва#,
				'standard' => q#Стандардно време во Москва#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#Време во Мјанмар#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#Време во Науру#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#Време во Непал#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#Летно време во Нова Каледонија#,
				'generic' => q#Време во Нова Каледонија#,
				'standard' => q#Стандардно време во Нова Каледонија#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#Летно сметање на времето во Нов Зеланд#,
				'generic' => q#Време во Нов Зеланд#,
				'standard' => q#Стандардно време во Нов Зеланд#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#Летно сметање на времето во Њуфаундленд#,
				'generic' => q#Време во Њуфаундленд#,
				'standard' => q#Стандардно време во Њуфаундленд#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#Време во Ниуе#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#Летно сметање на времето во Норфолшки Остров#,
				'generic' => q#Време во Норфолшки Остров#,
				'standard' => q#Стандардно време во Норфолшки Остров#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#Летно сметање на времето во Фернандо де Нороња#,
				'generic' => q#Време во Фернандо де Нороња#,
				'standard' => q#Стандардно време во Фернандо де Нороња#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#Летно време во Новосибирск#,
				'generic' => q#Време во Новосибирск#,
				'standard' => q#Стандардно време во Новосибирск#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#Летно време во Омск#,
				'generic' => q#Време во Омск#,
				'standard' => q#Стандардно време во Омск#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апија#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окленд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Буганвил#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатам#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Велигденски Остров#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Ефате#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Ендербери#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фиџи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбије#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гвадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гвам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Хонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Џонстон#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#Кантон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Косрае#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваџалејн#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Маџуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркески Острови#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидвеј#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуе#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкернски Острови#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понпеј#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт Морсби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сајпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Тахити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Чук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Вејк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Валис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#Летно време во Пакистан#,
				'generic' => q#Време во Пакистан#,
				'standard' => q#Стандардно време во Пакистан#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#Време во Палау#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#Време во Папуа Нова Гвинеја#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#Летно сметање на времето во Парагвај#,
				'generic' => q#Време во Парагвај#,
				'standard' => q#Стандардно време во Парагвај#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#Летно сметање на времето во Перу#,
				'generic' => q#Време во Перу#,
				'standard' => q#Стандардно време во Перу#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#Летно време во Филипини#,
				'generic' => q#Време во Филипини#,
				'standard' => q#Стандардно време во Филипини#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#Време во Островите Феникс#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#Летно сметање на времето во Сент Пјер и Микелан#,
				'generic' => q#Време во Сент Пјер и Микелан#,
				'standard' => q#Стандардно време во Сент Пјер и Микелан#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#Време во Питкерн#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#Време во Понапе#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#Време во Пјонгјанг#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#Време во Рејунион#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#Време во Ротера#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#Летно време во Сакалин#,
				'generic' => q#Време во Сакалин#,
				'standard' => q#Стандардно време во Сакалин#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#Самара летно сметање на времето#,
				'generic' => q#Самара време#,
				'standard' => q#Самара стандардно време#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#Летно време во Самоа#,
				'generic' => q#Време во Самоа#,
				'standard' => q#Стандардно време во Самоа#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#Време во Сејшели#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#Време во Сингапур#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#Време во Соломонски Острови#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#Време во Јужна Грузија#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#Време во Суринам#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#Време во Сајова#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#Време во Тахити#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#Летно сметање на времето во Тајпеј#,
				'generic' => q#Време во Тајпеј#,
				'standard' => q#Стандардно време во Тајпеј#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#Време во Таџикистан#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#Време во Токелау#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#Летно време во Тонга#,
				'generic' => q#Време во Тонга#,
				'standard' => q#Стандардно време во Тонга#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#Време во Чуук#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#Летно време во Туркменистан#,
				'generic' => q#Време во Туркменистан#,
				'standard' => q#Стандардно време во Туркменистан#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#Време во Тувалу#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#Летно сметање на времето во Уругвај#,
				'generic' => q#Време во Уругвај#,
				'standard' => q#Стандардно време во Уругвај#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#Летно време во Узбекистан#,
				'generic' => q#Време во Узбекистан#,
				'standard' => q#Стандардно време во Узбекистан#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#Летно време во Вануату#,
				'generic' => q#Време во Вануату#,
				'standard' => q#Стандардно време во Вануату#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#Време во Венецуела#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#Летно време во Владивосток#,
				'generic' => q#Време во Владивосток#,
				'standard' => q#Стандардно време во Владивосток#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#Летно сметање на времето во Волгоград#,
				'generic' => q#Време во Волгоград#,
				'standard' => q#Стандардно време во Волгоград#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#Време во Восток#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#Време во Островот Вејк#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#Време во Валис и Футуна#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#Летно време во Јакутск#,
				'generic' => q#Време во Јакутск#,
				'standard' => q#Стандардно време во Јакутск#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#Летно време во Екатеринбург#,
				'generic' => q#Време во Екатеринбург#,
				'standard' => q#Стандардно време во Екатеринбург#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#Време во Јукон#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
