=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Ja - Package for language Japanese

=cut

package Locale::CLDR::Locales::Ja;
# This file auto generated from Data\common\main\ja.xml
#	on Tue  5 Dec  1:16:11 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.4');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'WordBreak_variables' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub {[
		'$Hiragana' => '\p{Hiragana}',
		'$Hiragana' => '($Hiragana $FE*)',
		'$Ideographic' => '[[\p{Ideographic}] [々 〇 〻]]',
		'$Ideographic' => '($Ideographic $FE*)',
	]}
);

has 'WordBreak_rules' => (
	is => 'ro',
	isa => HashRef,
	init_arg => undef,
	default => sub { {
		'13.3' => ' $Hiragana × $Hiragana ',
		'13.4' => ' $Ideographic × $Ideographic ',
	}}
);
has 'LineBreak_variables' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub {[
		'$ID' => '[[\p{Line_Break=Ideographic}] [$CJ]]',
		'$NS' => '\p{Line_Break=Nonstarter}',
	]}
);
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal-financial','spellout-cardinal','spellout-ordinal','digits-ordinal' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => HashRef,
	init_arg => undef,
	default => sub { 
		use bigfloat;
		return {
		'digits-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(第−→#,##0→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(第=#,##0=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(第=#,##0=),
				},
			},
		},
		'spellout-cardinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(マイナス→→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(〇),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←←・→→→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(一),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(二),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(三),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(四),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(五),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(六),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(七),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(八),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(九),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(十[→→]),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(←←十[→→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(百[→→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(←←百[→→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(千[→→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←←千[→→]),
				},
				'10000' => {
					base_value => q(10000),
					divisor => q(10000),
					rule => q(←←万[→→]),
				},
				'100000000' => {
					base_value => q(100000000),
					divisor => q(100000000),
					rule => q(←←億[→→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←←兆[→→]),
				},
				'10000000000000000' => {
					base_value => q(10000000000000000),
					divisor => q(10000000000000000),
					rule => q(←←京[→→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-financial' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(マイナス→→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(零),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←←点→→→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(壱),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(弐),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(参),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(四),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(伍),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(六),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(七),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(八),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(九),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(拾[→→]),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(←←拾[→→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←←百[→→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←←千[→→]),
				},
				'10000' => {
					base_value => q(10000),
					divisor => q(10000),
					rule => q(←←萬[→→]),
				},
				'100000000' => {
					base_value => q(100000000),
					divisor => q(100000000),
					rule => q(←←億[→→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←←兆[→→]),
				},
				'10000000000000000' => {
					base_value => q(10000000000000000),
					divisor => q(10000000000000000),
					rule => q(←←京[→→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(元),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(=%%spellout-numbering-year-digits=),
				},
				'10000' => {
					base_value => q(10000),
					divisor => q(10000),
					rule => q(=%spellout-numbering=),
				},
				'max' => {
					base_value => q(10000),
					divisor => q(10000),
					rule => q(=%spellout-numbering=),
				},
			},
		},
		'spellout-numbering-year-digits' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(←←→→→),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←←→→→),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←←→→→),
				},
				'max' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←←→→→),
				},
			},
		},
		'spellout-ordinal' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(第=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,##0.#=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=#,##0.#=),
				},
			},
		},
	} },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}、{1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'アファル語',
 				'ab' => 'アブハズ語',
 				'ace' => 'アチェ語',
 				'ach' => 'アチョリ語',
 				'ada' => 'アダングメ語',
 				'ady' => 'アディゲ語',
 				'ae' => 'アヴェスタ語',
 				'aeb' => 'チュニジア・アラビア語',
 				'af' => 'アフリカーンス語',
 				'afh' => 'アフリヒリ語',
 				'agq' => 'アゲム語',
 				'ain' => 'アイヌ語',
 				'ak' => 'アカン語',
 				'akk' => 'アッカド語',
 				'akz' => 'アラバマ語',
 				'ale' => 'アレウト語',
 				'aln' => 'ゲグ・アルバニア語',
 				'alt' => '南アルタイ語',
 				'am' => 'アムハラ語',
 				'an' => 'アラゴン語',
 				'ang' => '古英語',
 				'anp' => 'アンギカ語',
 				'ar' => 'アラビア語',
 				'ar_001' => '現代標準アラビア語',
 				'arc' => 'アラム語',
 				'arn' => 'マプチェ語',
 				'aro' => 'アラオナ語',
 				'arp' => 'アラパホー語',
 				'arq' => 'アルジェリア・アラビア語',
 				'ars' => 'ナジュド地方・アラビア語',
 				'arw' => 'アラワク語',
 				'ary' => 'モロッコ・アラビア語',
 				'arz' => 'エジプト・アラビア語',
 				'as' => 'アッサム語',
 				'asa' => 'アス語',
 				'ase' => 'アメリカ手話',
 				'ast' => 'アストゥリアス語',
 				'av' => 'アヴァル語',
 				'avk' => 'コタヴァ',
 				'awa' => 'アワディー語',
 				'ay' => 'アイマラ語',
 				'az' => 'アゼルバイジャン語',
 				'az@alt=short' => 'アゼリー語',
 				'ba' => 'バシキール語',
 				'bal' => 'バルーチー語',
 				'ban' => 'バリ語',
 				'bar' => 'バイエルン・オーストリア語',
 				'bas' => 'バサ語',
 				'bax' => 'バムン語',
 				'bbc' => 'トバ・バタク語',
 				'bbj' => 'ゴーマラ語',
 				'be' => 'ベラルーシ語',
 				'bej' => 'ベジャ語',
 				'bem' => 'ベンバ語',
 				'bew' => 'ベタウィ語',
 				'bez' => 'ベナ語',
 				'bfd' => 'バフット語',
 				'bfq' => 'バダガ語',
 				'bg' => 'ブルガリア語',
 				'bgn' => '西バローチー語',
 				'bho' => 'ボージュプリー語',
 				'bi' => 'ビスラマ語',
 				'bik' => 'ビコル語',
 				'bin' => 'ビニ語',
 				'bjn' => 'バンジャル語',
 				'bkm' => 'コム語',
 				'bla' => 'シクシカ語',
 				'bm' => 'バンバラ語',
 				'bn' => 'ベンガル語',
 				'bo' => 'チベット語',
 				'bpy' => 'ビシュヌプリヤ・マニプリ語',
 				'bqi' => 'バフティヤーリー語',
 				'br' => 'ブルトン語',
 				'bra' => 'ブラジ語',
 				'brh' => 'ブラフイ語',
 				'brx' => 'ボド語',
 				'bs' => 'ボスニア語',
 				'bss' => 'アコース語',
 				'bua' => 'ブリヤート語',
 				'bug' => 'ブギ語',
 				'bum' => 'ブル語',
 				'byn' => 'ビリン語',
 				'byv' => 'メドゥンバ語',
 				'ca' => 'カタロニア語',
 				'cad' => 'カドー語',
 				'car' => 'カリブ語',
 				'cay' => 'カユーガ語',
 				'cch' => 'チャワイ語',
 				'ce' => 'チェチェン語',
 				'ceb' => 'セブアノ語',
 				'cgg' => 'チガ語',
 				'ch' => 'チャモロ語',
 				'chb' => 'チブチャ語',
 				'chg' => 'チャガタイ語',
 				'chk' => 'チューク語',
 				'chm' => 'マリ語',
 				'chn' => 'チヌーク混成語',
 				'cho' => 'チョクトー語',
 				'chp' => 'チペワイアン語',
 				'chr' => 'チェロキー語',
 				'chy' => 'シャイアン語',
 				'ckb' => '中央クルド語',
 				'co' => 'コルシカ語',
 				'cop' => 'コプト語',
 				'cps' => 'カピス語',
 				'cr' => 'クリー語',
 				'crh' => 'クリミア・タタール語',
 				'crs' => 'セーシェル・クレオール語',
 				'cs' => 'チェコ語',
 				'csb' => 'カシューブ語',
 				'cu' => '教会スラブ語',
 				'cv' => 'チュヴァシ語',
 				'cy' => 'ウェールズ語',
 				'da' => 'デンマーク語',
 				'dak' => 'ダコタ語',
 				'dar' => 'ダルグワ語',
 				'dav' => 'タイタ語',
 				'de' => 'ドイツ語',
 				'de_CH' => '標準ドイツ語 (スイス)',
 				'del' => 'デラウェア語',
 				'den' => 'スレイビー語',
 				'dgr' => 'ドグリブ語',
 				'din' => 'ディンカ語',
 				'dje' => 'ザルマ語',
 				'doi' => 'ドーグリー語',
 				'dsb' => '低地ソルブ語',
 				'dtp' => '中央ドゥスン語',
 				'dua' => 'ドゥアラ語',
 				'dum' => '中世オランダ語',
 				'dv' => 'ディベヒ語',
 				'dyo' => 'ジョラ＝フォニィ語',
 				'dyu' => 'ジュラ語',
 				'dz' => 'ゾンカ語',
 				'dzg' => 'ダザガ語',
 				'ebu' => 'エンブ語',
 				'ee' => 'エウェ語',
 				'efi' => 'エフィク語',
 				'egl' => 'エミリア語',
 				'egy' => '古代エジプト語',
 				'eka' => 'エカジュク語',
 				'el' => 'ギリシャ語',
 				'elx' => 'エラム語',
 				'en' => '英語',
 				'en_AU' => 'オーストラリア英語',
 				'en_CA' => 'カナダ英語',
 				'en_GB' => 'イギリス英語',
 				'en_GB@alt=short' => '英語(英国)',
 				'en_US' => 'アメリカ英語',
 				'en_US@alt=short' => '英語(米国)',
 				'enm' => '中英語',
 				'eo' => 'エスペラント語',
 				'es' => 'スペイン語',
 				'es_ES' => 'スペイン語 (イベリア半島)',
 				'esu' => '中央アラスカ・ユピック語',
 				'et' => 'エストニア語',
 				'eu' => 'バスク語',
 				'ewo' => 'エウォンド語',
 				'ext' => 'エストレマドゥーラ語',
 				'fa' => 'ペルシア語',
 				'fan' => 'ファング語',
 				'fat' => 'ファンティー語',
 				'ff' => 'フラ語',
 				'fi' => 'フィンランド語',
 				'fil' => 'フィリピノ語',
 				'fit' => 'トルネダール・フィンランド語',
 				'fj' => 'フィジー語',
 				'fo' => 'フェロー語',
 				'fon' => 'フォン語',
 				'fr' => 'フランス語',
 				'frc' => 'ケイジャン・フランス語',
 				'frm' => '中期フランス語',
 				'fro' => '古フランス語',
 				'frp' => 'アルピタン語',
 				'frr' => '北フリジア語',
 				'frs' => '東フリジア語',
 				'fur' => 'フリウリ語',
 				'fy' => '西フリジア語',
 				'ga' => 'アイルランド語',
 				'gaa' => 'ガ語',
 				'gag' => 'ガガウズ語',
 				'gan' => '贛語',
 				'gay' => 'ガヨ語',
 				'gba' => 'バヤ語',
 				'gbz' => 'ダリー語(ゾロアスター教)',
 				'gd' => 'スコットランド・ゲール語',
 				'gez' => 'ゲエズ語',
 				'gil' => 'キリバス語',
 				'gl' => 'ガリシア語',
 				'glk' => 'ギラキ語',
 				'gmh' => '中高ドイツ語',
 				'gn' => 'グアラニー語',
 				'goh' => '古高ドイツ語',
 				'gom' => 'ゴア・コンカニ語',
 				'gon' => 'ゴーンディー語',
 				'gor' => 'ゴロンタロ語',
 				'got' => 'ゴート語',
 				'grb' => 'グレボ語',
 				'grc' => '古代ギリシャ語',
 				'gsw' => 'スイスドイツ語',
 				'gu' => 'グジャラート語',
 				'guc' => 'ワユ語',
 				'gur' => 'フラフラ語',
 				'guz' => 'グシイ語',
 				'gv' => 'マン島語',
 				'gwi' => 'グウィッチン語',
 				'ha' => 'ハウサ語',
 				'hai' => 'ハイダ語',
 				'hak' => '客家語',
 				'haw' => 'ハワイ語',
 				'he' => 'ヘブライ語',
 				'hi' => 'ヒンディー語',
 				'hif' => 'フィジー・ヒンディー語',
 				'hil' => 'ヒリガイノン語',
 				'hit' => 'ヒッタイト語',
 				'hmn' => 'フモン語',
 				'ho' => 'ヒリモツ語',
 				'hr' => 'クロアチア語',
 				'hsb' => '高地ソルブ語',
 				'hsn' => '湘語',
 				'ht' => 'ハイチ・クレオール語',
 				'hu' => 'ハンガリー語',
 				'hup' => 'フパ語',
 				'hy' => 'アルメニア語',
 				'hz' => 'ヘレロ語',
 				'ia' => 'インターリングア',
 				'iba' => 'イバン語',
 				'ibb' => 'イビビオ語',
 				'id' => 'インドネシア語',
 				'ie' => 'インターリング',
 				'ig' => 'イボ語',
 				'ii' => '四川イ語',
 				'ik' => 'イヌピアック語',
 				'ilo' => 'イロカノ語',
 				'inh' => 'イングーシ語',
 				'io' => 'イド語',
 				'is' => 'アイスランド語',
 				'it' => 'イタリア語',
 				'iu' => 'イヌクティトット語',
 				'izh' => 'イングリア語',
 				'ja' => '日本語',
 				'jam' => 'ジャマイカ・クレオール語',
 				'jbo' => 'ロジバン語',
 				'jgo' => 'ンゴンバ語',
 				'jmc' => 'マチャメ語',
 				'jpr' => 'ユダヤ・ペルシア語',
 				'jrb' => 'ユダヤ・アラビア語',
 				'jut' => 'ユトランド語',
 				'jv' => 'ジャワ語',
 				'ka' => 'ジョージア語',
 				'kaa' => 'カラカルパク語',
 				'kab' => 'カビル語',
 				'kac' => 'カチン語',
 				'kaj' => 'カジェ語',
 				'kam' => 'カンバ語',
 				'kaw' => 'カウィ語',
 				'kbd' => 'カバルド語',
 				'kbl' => 'カネンブ語',
 				'kcg' => 'カタブ語',
 				'kde' => 'マコンデ語',
 				'kea' => 'カーボベルデ・クレオール語',
 				'ken' => 'ニャン語',
 				'kfo' => 'コロ語',
 				'kg' => 'コンゴ語',
 				'kgp' => 'カインガング語',
 				'kha' => 'カシ語',
 				'kho' => 'コータン語',
 				'khq' => 'コイラ・チーニ語',
 				'khw' => 'コワール語',
 				'ki' => 'キクユ語',
 				'kiu' => 'キルマンジュキ語',
 				'kj' => 'クワニャマ語',
 				'kk' => 'カザフ語',
 				'kkj' => 'カコ語',
 				'kl' => 'グリーンランド語',
 				'kln' => 'カレンジン語',
 				'km' => 'クメール語',
 				'kmb' => 'キンブンド語',
 				'kn' => 'カンナダ語',
 				'ko' => '韓国語',
 				'koi' => 'コミ・ペルミャク語',
 				'kok' => 'コンカニ語',
 				'kos' => 'コスラエ語',
 				'kpe' => 'クペレ語',
 				'kr' => 'カヌリ語',
 				'krc' => 'カラチャイ・バルカル語',
 				'kri' => 'クリオ語',
 				'krj' => 'キナライア語',
 				'krl' => 'カレリア語',
 				'kru' => 'クルク語',
 				'ks' => 'カシミール語',
 				'ksb' => 'サンバー語',
 				'ksf' => 'バフィア語',
 				'ksh' => 'ケルン語',
 				'ku' => 'クルド語',
 				'kum' => 'クムク語',
 				'kut' => 'クテナイ語',
 				'kv' => 'コミ語',
 				'kw' => 'コーンウォール語',
 				'ky' => 'キルギス語',
 				'la' => 'ラテン語',
 				'lad' => 'ラディノ語',
 				'lag' => 'ランギ語',
 				'lah' => 'ラフンダー語',
 				'lam' => 'ランバ語',
 				'lb' => 'ルクセンブルク語',
 				'lez' => 'レズギ語',
 				'lfn' => 'リングア・フランカ・ノバ',
 				'lg' => 'ガンダ語',
 				'li' => 'リンブルフ語',
 				'lij' => 'リグリア語',
 				'liv' => 'リヴォニア語',
 				'lkt' => 'ラコタ語',
 				'lmo' => 'ロンバルド語',
 				'ln' => 'リンガラ語',
 				'lo' => 'ラオ語',
 				'lol' => 'モンゴ語',
 				'lou' => 'ルイジアナ・クレオール語',
 				'loz' => 'ロジ語',
 				'lrc' => '北ロル語',
 				'lt' => 'リトアニア語',
 				'ltg' => 'ラトガリア語',
 				'lu' => 'ルバ・カタンガ語',
 				'lua' => 'ルバ・ルルア語',
 				'lui' => 'ルイセーニョ語',
 				'lun' => 'ルンダ語',
 				'luo' => 'ルオ語',
 				'lus' => 'ミゾ語',
 				'luy' => 'ルヒヤ語',
 				'lv' => 'ラトビア語',
 				'lzh' => '漢文',
 				'lzz' => 'ラズ語',
 				'mad' => 'マドゥラ語',
 				'maf' => 'マファ語',
 				'mag' => 'マガヒー語',
 				'mai' => 'マイティリー語',
 				'mak' => 'マカッサル語',
 				'man' => 'マンディンゴ語',
 				'mas' => 'マサイ語',
 				'mde' => 'マバ語',
 				'mdf' => 'モクシャ語',
 				'mdr' => 'マンダル語',
 				'men' => 'メンデ語',
 				'mer' => 'メル語',
 				'mfe' => 'モーリシャス・クレオール語',
 				'mg' => 'マダガスカル語',
 				'mga' => '中期アイルランド語',
 				'mgh' => 'マクア・ミート語',
 				'mgo' => 'メタ語',
 				'mh' => 'マーシャル語',
 				'mi' => 'マオリ語',
 				'mic' => 'ミクマク語',
 				'min' => 'ミナンカバウ語',
 				'mk' => 'マケドニア語',
 				'ml' => 'マラヤーラム語',
 				'mn' => 'モンゴル語',
 				'mnc' => '満州語',
 				'mni' => 'マニプリ語',
 				'moh' => 'モーホーク語',
 				'mos' => 'モシ語',
 				'mr' => 'マラーティー語',
 				'mrj' => '山地マリ語',
 				'ms' => 'マレー語',
 				'mt' => 'マルタ語',
 				'mua' => 'ムンダン語',
 				'mul' => '複数言語',
 				'mus' => 'クリーク語',
 				'mwl' => 'ミランダ語',
 				'mwr' => 'マールワーリー語',
 				'mwv' => 'メンタワイ語',
 				'my' => 'ミャンマー語',
 				'mye' => 'ミエネ語',
 				'myv' => 'エルジャ語',
 				'mzn' => 'マーザンダラーン語',
 				'na' => 'ナウル語',
 				'nan' => '閩南語',
 				'nap' => 'ナポリ語',
 				'naq' => 'ナマ語',
 				'nb' => 'ノルウェー語(ブークモール)',
 				'nd' => '北ンデベレ語',
 				'nds' => '低地ドイツ語',
 				'ne' => 'ネパール語',
 				'new' => 'ネワール語',
 				'ng' => 'ンドンガ語',
 				'nia' => 'ニアス語',
 				'niu' => 'ニウーエイ語',
 				'njo' => 'アオ・ナガ語',
 				'nl' => 'オランダ語',
 				'nl_BE' => 'フレミッシュ語',
 				'nmg' => 'クワシオ語',
 				'nn' => 'ノルウェー語(ニーノシュク)',
 				'nnh' => 'ンジエムブーン語',
 				'no' => 'ノルウェー語',
 				'nog' => 'ノガイ語',
 				'non' => '古ノルド語',
 				'nov' => 'ノヴィアル',
 				'nqo' => 'ンコ語',
 				'nr' => '南ンデベレ語',
 				'nso' => '北部ソト語',
 				'nus' => 'ヌエル語',
 				'nv' => 'ナバホ語',
 				'nwc' => '古典ネワール語',
 				'ny' => 'ニャンジャ語',
 				'nym' => 'ニャムウェジ語',
 				'nyn' => 'ニャンコレ語',
 				'nyo' => 'ニョロ語',
 				'nzi' => 'ンゼマ語',
 				'oc' => 'オック語',
 				'oj' => 'オジブウェー語',
 				'om' => 'オロモ語',
 				'or' => 'オディア語',
 				'os' => 'オセット語',
 				'osa' => 'オセージ語',
 				'ota' => 'オスマントルコ語',
 				'pa' => 'パンジャブ語',
 				'pag' => 'パンガシナン語',
 				'pal' => 'パフラヴィー語',
 				'pam' => 'パンパンガ語',
 				'pap' => 'パピアメント語',
 				'pau' => 'パラオ語',
 				'pcd' => 'ピカルディ語',
 				'pcm' => 'ナイジェリア・ピジン語',
 				'pdc' => 'ペンシルベニア・ドイツ語',
 				'pdt' => 'メノナイト低地ドイツ語',
 				'peo' => '古代ペルシア語',
 				'pfl' => 'プファルツ語',
 				'phn' => 'フェニキア語',
 				'pi' => 'パーリ語',
 				'pl' => 'ポーランド語',
 				'pms' => 'ピエモンテ語',
 				'pnt' => 'ポントス・ギリシャ語',
 				'pon' => 'ポンペイ語',
 				'prg' => 'プロシア語',
 				'pro' => '古期プロバンス語',
 				'ps' => 'パシュトゥー語',
 				'ps@alt=variant' => 'パシュトゥ語',
 				'pt' => 'ポルトガル語',
 				'pt_PT' => 'ポルトガル語 (イベリア半島)',
 				'qu' => 'ケチュア語',
 				'quc' => 'キチェ語',
 				'qug' => 'チンボラソ高地ケチュア語',
 				'raj' => 'ラージャスターン語',
 				'rap' => 'ラパヌイ語',
 				'rar' => 'ラロトンガ語',
 				'rgn' => 'ロマーニャ語',
 				'rif' => 'リーフ語',
 				'rm' => 'ロマンシュ語',
 				'rn' => 'ルンディ語',
 				'ro' => 'ルーマニア語',
 				'ro_MD' => 'モルダビア語',
 				'rof' => 'ロンボ語',
 				'rom' => 'ロマーニー語',
 				'root' => 'ルート',
 				'rtm' => 'ロツマ語',
 				'ru' => 'ロシア語',
 				'rue' => 'ルシン語',
 				'rug' => 'ロヴィアナ語',
 				'rup' => 'アルーマニア語',
 				'rw' => 'キニアルワンダ語',
 				'rwk' => 'ルワ語',
 				'sa' => 'サンスクリット語',
 				'sad' => 'サンダウェ語',
 				'sah' => 'サハ語',
 				'sam' => 'サマリア・アラム語',
 				'saq' => 'サンブル語',
 				'sas' => 'ササク語',
 				'sat' => 'サンターリー語',
 				'saz' => 'サウラーシュトラ語',
 				'sba' => 'ンガムバイ語',
 				'sbp' => 'サング語',
 				'sc' => 'サルデーニャ語',
 				'scn' => 'シチリア語',
 				'sco' => 'スコットランド語',
 				'sd' => 'シンド語',
 				'sdc' => 'サッサリ・サルデーニャ語',
 				'sdh' => '南部クルド語',
 				'se' => '北サーミ語',
 				'see' => 'セネカ語',
 				'seh' => 'セナ語',
 				'sei' => 'セリ語',
 				'sel' => 'セリクプ語',
 				'ses' => 'コイラボロ・センニ語',
 				'sg' => 'サンゴ語',
 				'sga' => '古アイルランド語',
 				'sgs' => 'サモギティア語',
 				'sh' => 'セルボ・クロアチア語',
 				'shi' => 'タシルハイト語',
 				'shn' => 'シャン語',
 				'shu' => 'チャド・アラビア語',
 				'si' => 'シンハラ語',
 				'sid' => 'シダモ語',
 				'sk' => 'スロバキア語',
 				'sl' => 'スロベニア語',
 				'sli' => '低シレジア語',
 				'sly' => 'スラヤール語',
 				'sm' => 'サモア語',
 				'sma' => '南サーミ語',
 				'smj' => 'ルレ・サーミ語',
 				'smn' => 'イナリ・サーミ語',
 				'sms' => 'スコルト・サーミ語',
 				'sn' => 'ショナ語',
 				'snk' => 'ソニンケ語',
 				'so' => 'ソマリ語',
 				'sog' => 'ソグド語',
 				'sq' => 'アルバニア語',
 				'sr' => 'セルビア語',
 				'srn' => 'スリナム語',
 				'srr' => 'セレル語',
 				'ss' => 'スワジ語',
 				'ssy' => 'サホ語',
 				'st' => '南部ソト語',
 				'stq' => 'ザーターフリジア語',
 				'su' => 'スンダ語',
 				'suk' => 'スクマ語',
 				'sus' => 'スス語',
 				'sux' => 'シュメール語',
 				'sv' => 'スウェーデン語',
 				'sw' => 'スワヒリ語',
 				'sw_CD' => 'コンゴ・スワヒリ語',
 				'swb' => 'コモロ語',
 				'syc' => '古典シリア語',
 				'syr' => 'シリア語',
 				'szl' => 'シレジア語',
 				'ta' => 'タミル語',
 				'tcy' => 'トゥル語',
 				'te' => 'テルグ語',
 				'tem' => 'テムネ語',
 				'teo' => 'テソ語',
 				'ter' => 'テレーノ語',
 				'tet' => 'テトゥン語',
 				'tg' => 'タジク語',
 				'th' => 'タイ語',
 				'ti' => 'ティグリニア語',
 				'tig' => 'ティグレ語',
 				'tiv' => 'ティブ語',
 				'tk' => 'トルクメン語',
 				'tkl' => 'トケラウ語',
 				'tkr' => 'ツァフル語',
 				'tl' => 'タガログ語',
 				'tlh' => 'クリンゴン語',
 				'tli' => 'トリンギット語',
 				'tly' => 'タリシュ語',
 				'tmh' => 'タマシェク語',
 				'tn' => 'ツワナ語',
 				'to' => 'トンガ語',
 				'tog' => 'トンガ語(ニアサ)',
 				'tpi' => 'トク・ピシン語',
 				'tr' => 'トルコ語',
 				'tru' => 'トゥロヨ語',
 				'trv' => 'タロコ語',
 				'ts' => 'ツォンガ語',
 				'tsd' => 'ツァコン語',
 				'tsi' => 'チムシュ語',
 				'tt' => 'タタール語',
 				'ttt' => 'ムスリム・タタール語',
 				'tum' => 'トゥンブカ語',
 				'tvl' => 'ツバル語',
 				'tw' => 'トウィ語',
 				'twq' => 'タサワク語',
 				'ty' => 'タヒチ語',
 				'tyv' => 'トゥヴァ語',
 				'tzm' => '中央アトラス・タマジクト語',
 				'udm' => 'ウドムルト語',
 				'ug' => 'ウイグル語',
 				'ug@alt=variant' => 'ウィグル語',
 				'uga' => 'ウガリト語',
 				'uk' => 'ウクライナ語',
 				'umb' => 'ムブンドゥ語',
 				'und' => '言語不明',
 				'ur' => 'ウルドゥー語',
 				'uz' => 'ウズベク語',
 				'vai' => 'ヴァイ語',
 				've' => 'ベンダ語',
 				'vec' => 'ヴェネト語',
 				'vep' => 'ヴェプス語',
 				'vi' => 'ベトナム語',
 				'vls' => '西フラマン語',
 				'vmf' => 'マインフランク語',
 				'vo' => 'ヴォラピュク語',
 				'vot' => 'ヴォート語',
 				'vro' => 'ヴォロ語',
 				'vun' => 'ヴンジョ語',
 				'wa' => 'ワロン語',
 				'wae' => 'ヴァリス語',
 				'wal' => 'ウォライタ語',
 				'war' => 'ワライ語',
 				'was' => 'ワショ語',
 				'wbp' => 'ワルピリ語',
 				'wo' => 'ウォロフ語',
 				'wuu' => '呉語',
 				'xal' => 'カルムイク語',
 				'xh' => 'コサ語',
 				'xmf' => 'メグレル語',
 				'xog' => 'ソガ語',
 				'yao' => 'ヤオ語',
 				'yap' => 'ヤップ語',
 				'yav' => 'ヤンベン語',
 				'ybb' => 'イエンバ語',
 				'yi' => 'イディッシュ語',
 				'yo' => 'ヨルバ語',
 				'yrl' => 'ニェエンガトゥ語',
 				'yue' => '広東語',
 				'za' => 'チワン語',
 				'zap' => 'サポテカ語',
 				'zbl' => 'ブリスシンボル',
 				'zea' => 'ゼーラント語',
 				'zen' => 'ゼナガ語',
 				'zgh' => '標準モロッコ タマジクト語',
 				'zh' => '中国語',
 				'zh_Hans' => '簡体中国語',
 				'zh_Hant' => '繁体中国語',
 				'zu' => 'ズールー語',
 				'zun' => 'ズニ語',
 				'zxx' => '言語的内容なし',
 				'zza' => 'ザザ語',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Afak' => 'アファカ文字',
 			'Aghb' => 'カフカス・アルバニア文字',
 			'Arab' => 'アラビア文字',
 			'Arab@alt=variant' => 'ペルソ・アラビア文字',
 			'Armi' => '帝国アラム文字',
 			'Armn' => 'アルメニア文字',
 			'Avst' => 'アヴェスター文字',
 			'Bali' => 'バリ文字',
 			'Bamu' => 'バムン文字',
 			'Bass' => 'バサ文字',
 			'Batk' => 'バタク文字',
 			'Beng' => 'ベンガル文字',
 			'Blis' => 'ブリスシンボル',
 			'Bopo' => '注音字母',
 			'Brah' => 'ブラーフミー文字',
 			'Brai' => 'ブライユ点字',
 			'Bugi' => 'ブギス文字',
 			'Buhd' => 'ブヒッド文字',
 			'Cakm' => 'チャクマ文字',
 			'Cans' => '統合カナダ先住民音節文字',
 			'Cari' => 'カリア文字',
 			'Cham' => 'チャム文字',
 			'Cher' => 'チェロキー文字',
 			'Cirt' => 'キアス文字',
 			'Copt' => 'コプト文字',
 			'Cprt' => 'キプロス文字',
 			'Cyrl' => 'キリル文字',
 			'Cyrs' => '古代教会スラブ語キリル文字',
 			'Deva' => 'デーバナーガリー文字',
 			'Dsrt' => 'デセレット文字',
 			'Dupl' => 'デュプロワエ式速記',
 			'Egyd' => 'エジプト民衆文字',
 			'Egyh' => 'エジプト神官文字',
 			'Egyp' => 'エジプト聖刻文字',
 			'Elba' => 'エルバサン文字',
 			'Ethi' => 'エチオピア文字',
 			'Geok' => 'ジョージア文字(フツリ)',
 			'Geor' => 'ジョージア文字',
 			'Glag' => 'グラゴル文字',
 			'Goth' => 'ゴート文字',
 			'Gran' => 'グランタ文字',
 			'Grek' => 'ギリシャ文字',
 			'Gujr' => 'グジャラート文字',
 			'Guru' => 'グルムキー文字',
 			'Hanb' => '漢語注音字母',
 			'Hang' => 'ハングル',
 			'Hani' => '漢字',
 			'Hano' => 'ハヌノオ文字',
 			'Hans' => '簡体字',
 			'Hans@alt=stand-alone' => '漢字(簡体字)',
 			'Hant' => '繁体字',
 			'Hant@alt=stand-alone' => '漢字(繁体字)',
 			'Hebr' => 'ヘブライ文字',
 			'Hira' => 'ひらがな',
 			'Hluw' => 'アナトリア象形文字',
 			'Hmng' => 'パハウ・フモン文字',
 			'Hrkt' => '仮名',
 			'Hung' => '古代ハンガリー文字',
 			'Inds' => 'インダス文字',
 			'Ital' => '古イタリア文字',
 			'Jamo' => '字母',
 			'Java' => 'ジャワ文字',
 			'Jpan' => '日本語の文字',
 			'Jurc' => '女真文字',
 			'Kali' => 'カヤー文字',
 			'Kana' => 'カタカナ',
 			'Khar' => 'カローシュティー文字',
 			'Khmr' => 'クメール文字',
 			'Khoj' => 'ホジャ文字',
 			'Knda' => 'カンナダ文字',
 			'Kore' => '韓国語の文字',
 			'Kpel' => 'クペレ文字',
 			'Kthi' => 'カイティ文字',
 			'Lana' => 'ラーンナー文字',
 			'Laoo' => 'ラオ文字',
 			'Latf' => 'ラテン文字(ドイツ文字)',
 			'Latg' => 'ラテン文字 (ゲール文字)',
 			'Latn' => 'ラテン文字',
 			'Lepc' => 'レプチャ文字',
 			'Limb' => 'リンブ文字',
 			'Lina' => '線文字A',
 			'Linb' => '線文字B',
 			'Lisu' => 'フレイザー文字',
 			'Loma' => 'ロマ文字',
 			'Lyci' => 'リキア文字',
 			'Lydi' => 'リディア文字',
 			'Mahj' => 'マハージャニー文字',
 			'Mand' => 'マンダ文字',
 			'Mani' => 'マニ文字',
 			'Maya' => 'マヤ象形文字',
 			'Mend' => 'メンデ文字',
 			'Merc' => 'メロエ文字草書体',
 			'Mero' => 'メロエ文字',
 			'Mlym' => 'マラヤーラム文字',
 			'Modi' => 'モーディー文字',
 			'Mong' => 'モンゴル文字',
 			'Moon' => 'ムーン文字',
 			'Mroo' => 'ムロ文字',
 			'Mtei' => 'メイテイ文字',
 			'Mymr' => 'ミャンマー文字',
 			'Narb' => '古代北アラビア文字',
 			'Nbat' => 'ナバテア文字',
 			'Nkgb' => 'ナシ族ゲバ文字',
 			'Nkoo' => 'ンコ文字',
 			'Nshu' => '女書',
 			'Ogam' => 'オガム文字',
 			'Olck' => 'オルチキ文字',
 			'Orkh' => 'オルホン文字',
 			'Orya' => 'オリヤー文字',
 			'Osma' => 'オスマニア文字',
 			'Palm' => 'パルミラ文字',
 			'Pauc' => 'パウ・チン・ハウ文字',
 			'Perm' => '古ぺルム文字',
 			'Phag' => 'パスパ文字',
 			'Phli' => '碑文パフラヴィー文字',
 			'Phlp' => '詩編用パフラヴィー文字',
 			'Phlv' => '書物用パフラヴィー文字',
 			'Phnx' => 'フェニキア文字',
 			'Plrd' => 'ポラード音声記号',
 			'Prti' => '碑文パルティア文字',
 			'Rjng' => 'ルジャン文字',
 			'Roro' => 'ロンゴロンゴ文字',
 			'Runr' => 'ルーン文字',
 			'Samr' => 'サマリア文字',
 			'Sara' => 'サラティ文字',
 			'Sarb' => '古代南アラビア文字',
 			'Saur' => 'サウラーシュトラ文字',
 			'Sgnw' => '手話文字',
 			'Shaw' => 'ショー文字',
 			'Shrd' => 'シャーラダー文字',
 			'Sidd' => '梵字',
 			'Sind' => 'クダワディ文字',
 			'Sinh' => 'シンハラ文字',
 			'Sora' => 'ソラング・ソンペング文字',
 			'Sund' => 'スンダ文字',
 			'Sylo' => 'シロティ・ナグリ文字',
 			'Syrc' => 'シリア文字',
 			'Syre' => 'シリア文字(エストランゲロ文字)',
 			'Syrj' => 'シリア文字(西方シリア文字)',
 			'Syrn' => 'シリア文字(東方シリア文字)',
 			'Tagb' => 'タグバンワ文字',
 			'Takr' => 'タークリー文字',
 			'Tale' => 'タイ・レ文字',
 			'Talu' => '新タイ・ルー文字',
 			'Taml' => 'タミール文字',
 			'Tang' => '西夏文字',
 			'Tavt' => 'タイ・ヴェト文字',
 			'Telu' => 'テルグ文字',
 			'Teng' => 'テングワール文字',
 			'Tfng' => 'ティフナグ文字',
 			'Tglg' => 'タガログ文字',
 			'Thaa' => 'ターナ文字',
 			'Thai' => 'タイ文字',
 			'Tibt' => 'チベット文字',
 			'Tirh' => 'ティルフータ文字',
 			'Ugar' => 'ウガリット文字',
 			'Vaii' => 'ヴァイ文字',
 			'Visp' => '視話法',
 			'Wara' => 'バラン・クシティ文字',
 			'Wole' => 'ウォレアイ文字',
 			'Xpeo' => '古代ペルシア文字',
 			'Xsux' => 'シュメール＝アッカド語楔形文字',
 			'Yiii' => 'イ文字',
 			'Zinh' => '基底文字の種別を継承する結合文字',
 			'Zmth' => '数学記号',
 			'Zsye' => '絵文字',
 			'Zsym' => '記号文字',
 			'Zxxx' => '非表記',
 			'Zyyy' => '共通文字',
 			'Zzzz' => '未定義文字',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => '世界',
 			'002' => 'アフリカ',
 			'003' => '北アメリカ大陸',
 			'005' => '南アメリカ',
 			'009' => 'オセアニア',
 			'011' => '西アフリカ',
 			'013' => '中央アメリカ',
 			'014' => '東アフリカ',
 			'015' => '北アフリカ',
 			'017' => '中部アフリカ',
 			'018' => '南部アフリカ',
 			'019' => 'アメリカ大陸',
 			'021' => '北アメリカ',
 			'029' => 'カリブ',
 			'030' => '東アジア',
 			'034' => '南アジア',
 			'035' => '東南アジア',
 			'039' => '南ヨーロッパ',
 			'053' => 'オーストララシア',
 			'054' => 'メラネシア',
 			'057' => 'ミクロネシア',
 			'061' => 'ポリネシア',
 			'142' => 'アジア',
 			'143' => '中央アジア',
 			'145' => '西アジア',
 			'150' => 'ヨーロッパ',
 			'151' => '東ヨーロッパ',
 			'154' => '北ヨーロッパ',
 			'155' => '西ヨーロッパ',
 			'202' => 'サブサハラアフリカ',
 			'419' => 'ラテンアメリカ',
 			'AC' => 'アセンション島',
 			'AD' => 'アンドラ',
 			'AE' => 'アラブ首長国連邦',
 			'AF' => 'アフガニスタン',
 			'AG' => 'アンティグア・バーブーダ',
 			'AI' => 'アンギラ',
 			'AL' => 'アルバニア',
 			'AM' => 'アルメニア',
 			'AO' => 'アンゴラ',
 			'AQ' => '南極',
 			'AR' => 'アルゼンチン',
 			'AS' => '米領サモア',
 			'AT' => 'オーストリア',
 			'AU' => 'オーストラリア',
 			'AW' => 'アルバ',
 			'AX' => 'オーランド諸島',
 			'AZ' => 'アゼルバイジャン',
 			'BA' => 'ボスニア・ヘルツェゴビナ',
 			'BB' => 'バルバドス',
 			'BD' => 'バングラデシュ',
 			'BE' => 'ベルギー',
 			'BF' => 'ブルキナファソ',
 			'BG' => 'ブルガリア',
 			'BH' => 'バーレーン',
 			'BI' => 'ブルンジ',
 			'BJ' => 'ベナン',
 			'BL' => 'サン・バルテルミー',
 			'BM' => 'バミューダ',
 			'BN' => 'ブルネイ',
 			'BO' => 'ボリビア',
 			'BQ' => 'オランダ領カリブ',
 			'BR' => 'ブラジル',
 			'BS' => 'バハマ',
 			'BT' => 'ブータン',
 			'BV' => 'ブーベ島',
 			'BW' => 'ボツワナ',
 			'BY' => 'ベラルーシ',
 			'BZ' => 'ベリーズ',
 			'CA' => 'カナダ',
 			'CC' => 'ココス(キーリング)諸島',
 			'CD' => 'コンゴ民主共和国(キンシャサ)',
 			'CD@alt=variant' => 'コンゴ民主共和国',
 			'CF' => '中央アフリカ共和国',
 			'CG' => 'コンゴ共和国(ブラザビル)',
 			'CG@alt=variant' => 'コンゴ共和国',
 			'CH' => 'スイス',
 			'CI' => 'コートジボワール',
 			'CI@alt=variant' => '象牙海岸',
 			'CK' => 'クック諸島',
 			'CL' => 'チリ',
 			'CM' => 'カメルーン',
 			'CN' => '中国',
 			'CO' => 'コロンビア',
 			'CP' => 'クリッパートン島',
 			'CR' => 'コスタリカ',
 			'CU' => 'キューバ',
 			'CV' => 'カーボベルデ',
 			'CW' => 'キュラソー',
 			'CX' => 'クリスマス島',
 			'CY' => 'キプロス',
 			'CZ' => 'チェコ',
 			'CZ@alt=variant' => 'チェコ共和国',
 			'DE' => 'ドイツ',
 			'DG' => 'ディエゴガルシア島',
 			'DJ' => 'ジブチ',
 			'DK' => 'デンマーク',
 			'DM' => 'ドミニカ国',
 			'DO' => 'ドミニカ共和国',
 			'DZ' => 'アルジェリア',
 			'EA' => 'セウタ・メリリャ',
 			'EC' => 'エクアドル',
 			'EE' => 'エストニア',
 			'EG' => 'エジプト',
 			'EH' => '西サハラ',
 			'ER' => 'エリトリア',
 			'ES' => 'スペイン',
 			'ET' => 'エチオピア',
 			'EU' => '欧州連合',
 			'EZ' => 'ユーロ圏',
 			'FI' => 'フィンランド',
 			'FJ' => 'フィジー',
 			'FK' => 'フォークランド諸島',
 			'FK@alt=variant' => 'フォークランド諸島 (マルビーナス諸島)',
 			'FM' => 'ミクロネシア連邦',
 			'FO' => 'フェロー諸島',
 			'FR' => 'フランス',
 			'GA' => 'ガボン',
 			'GB' => 'イギリス',
 			'GB@alt=short' => '英国',
 			'GD' => 'グレナダ',
 			'GE' => 'ジョージア',
 			'GF' => '仏領ギアナ',
 			'GG' => 'ガーンジー',
 			'GH' => 'ガーナ',
 			'GI' => 'ジブラルタル',
 			'GL' => 'グリーンランド',
 			'GM' => 'ガンビア',
 			'GN' => 'ギニア',
 			'GP' => 'グアドループ',
 			'GQ' => '赤道ギニア',
 			'GR' => 'ギリシャ',
 			'GS' => 'サウスジョージア・サウスサンドウィッチ諸島',
 			'GT' => 'グアテマラ',
 			'GU' => 'グアム',
 			'GW' => 'ギニアビサウ',
 			'GY' => 'ガイアナ',
 			'HK' => '中華人民共和国香港特別行政区',
 			'HK@alt=short' => '香港',
 			'HM' => 'ハード島・マクドナルド諸島',
 			'HN' => 'ホンジュラス',
 			'HR' => 'クロアチア',
 			'HT' => 'ハイチ',
 			'HU' => 'ハンガリー',
 			'IC' => 'カナリア諸島',
 			'ID' => 'インドネシア',
 			'IE' => 'アイルランド',
 			'IL' => 'イスラエル',
 			'IM' => 'マン島',
 			'IN' => 'インド',
 			'IO' => '英領インド洋地域',
 			'IQ' => 'イラク',
 			'IR' => 'イラン',
 			'IS' => 'アイスランド',
 			'IT' => 'イタリア',
 			'JE' => 'ジャージー',
 			'JM' => 'ジャマイカ',
 			'JO' => 'ヨルダン',
 			'JP' => '日本',
 			'KE' => 'ケニア',
 			'KG' => 'キルギス',
 			'KH' => 'カンボジア',
 			'KI' => 'キリバス',
 			'KM' => 'コモロ',
 			'KN' => 'セントクリストファー・ネーヴィス',
 			'KP' => '北朝鮮',
 			'KR' => '韓国',
 			'KW' => 'クウェート',
 			'KY' => 'ケイマン諸島',
 			'KZ' => 'カザフスタン',
 			'LA' => 'ラオス',
 			'LB' => 'レバノン',
 			'LC' => 'セントルシア',
 			'LI' => 'リヒテンシュタイン',
 			'LK' => 'スリランカ',
 			'LR' => 'リベリア',
 			'LS' => 'レソト',
 			'LT' => 'リトアニア',
 			'LU' => 'ルクセンブルク',
 			'LV' => 'ラトビア',
 			'LY' => 'リビア',
 			'MA' => 'モロッコ',
 			'MC' => 'モナコ',
 			'MD' => 'モルドバ',
 			'ME' => 'モンテネグロ',
 			'MF' => 'サン・マルタン',
 			'MG' => 'マダガスカル',
 			'MH' => 'マーシャル諸島',
 			'MK' => 'マケドニア',
 			'MK@alt=variant' => 'マケドニア(旧ユーゴスラビア共和国)',
 			'ML' => 'マリ',
 			'MM' => 'ミャンマー (ビルマ)',
 			'MN' => 'モンゴル',
 			'MO' => '中華人民共和国マカオ特別行政区',
 			'MO@alt=short' => 'マカオ',
 			'MP' => '北マリアナ諸島',
 			'MQ' => 'マルティニーク',
 			'MR' => 'モーリタニア',
 			'MS' => 'モントセラト',
 			'MT' => 'マルタ',
 			'MU' => 'モーリシャス',
 			'MV' => 'モルディブ',
 			'MW' => 'マラウイ',
 			'MX' => 'メキシコ',
 			'MY' => 'マレーシア',
 			'MZ' => 'モザンビーク',
 			'NA' => 'ナミビア',
 			'NC' => 'ニューカレドニア',
 			'NE' => 'ニジェール',
 			'NF' => 'ノーフォーク島',
 			'NG' => 'ナイジェリア',
 			'NI' => 'ニカラグア',
 			'NL' => 'オランダ',
 			'NO' => 'ノルウェー',
 			'NP' => 'ネパール',
 			'NR' => 'ナウル',
 			'NU' => 'ニウエ',
 			'NZ' => 'ニュージーランド',
 			'OM' => 'オマーン',
 			'PA' => 'パナマ',
 			'PE' => 'ペルー',
 			'PF' => '仏領ポリネシア',
 			'PG' => 'パプアニューギニア',
 			'PH' => 'フィリピン',
 			'PK' => 'パキスタン',
 			'PL' => 'ポーランド',
 			'PM' => 'サンピエール島・ミクロン島',
 			'PN' => 'ピトケアン諸島',
 			'PR' => 'プエルトリコ',
 			'PS' => 'パレスチナ自治区',
 			'PS@alt=short' => 'パレスチナ',
 			'PT' => 'ポルトガル',
 			'PW' => 'パラオ',
 			'PY' => 'パラグアイ',
 			'QA' => 'カタール',
 			'QO' => 'オセアニア周辺地域',
 			'RE' => 'レユニオン',
 			'RO' => 'ルーマニア',
 			'RS' => 'セルビア',
 			'RU' => 'ロシア',
 			'RW' => 'ルワンダ',
 			'SA' => 'サウジアラビア',
 			'SB' => 'ソロモン諸島',
 			'SC' => 'セーシェル',
 			'SD' => 'スーダン',
 			'SE' => 'スウェーデン',
 			'SG' => 'シンガポール',
 			'SH' => 'セントヘレナ',
 			'SI' => 'スロベニア',
 			'SJ' => 'スバールバル諸島・ヤンマイエン島',
 			'SK' => 'スロバキア',
 			'SL' => 'シエラレオネ',
 			'SM' => 'サンマリノ',
 			'SN' => 'セネガル',
 			'SO' => 'ソマリア',
 			'SR' => 'スリナム',
 			'SS' => '南スーダン',
 			'ST' => 'サントメ・プリンシペ',
 			'SV' => 'エルサルバドル',
 			'SX' => 'シント・マールテン',
 			'SY' => 'シリア',
 			'SZ' => 'スワジランド',
 			'TA' => 'トリスタン・ダ・クーニャ',
 			'TC' => 'タークス・カイコス諸島',
 			'TD' => 'チャド',
 			'TF' => '仏領極南諸島',
 			'TG' => 'トーゴ',
 			'TH' => 'タイ',
 			'TJ' => 'タジキスタン',
 			'TK' => 'トケラウ',
 			'TL' => '東ティモール',
 			'TL@alt=variant' => '東チモール',
 			'TM' => 'トルクメニスタン',
 			'TN' => 'チュニジア',
 			'TO' => 'トンガ',
 			'TR' => 'トルコ',
 			'TT' => 'トリニダード・トバゴ',
 			'TV' => 'ツバル',
 			'TW' => '台湾',
 			'TZ' => 'タンザニア',
 			'UA' => 'ウクライナ',
 			'UG' => 'ウガンダ',
 			'UM' => '合衆国領有小離島',
 			'UN' => '国際連合',
 			'UN@alt=short' => '国連',
 			'US' => 'アメリカ合衆国',
 			'US@alt=short' => 'アメリカ',
 			'UY' => 'ウルグアイ',
 			'UZ' => 'ウズベキスタン',
 			'VA' => 'バチカン市国',
 			'VC' => 'セントビンセント及びグレナディーン諸島',
 			'VE' => 'ベネズエラ',
 			'VG' => '英領ヴァージン諸島',
 			'VI' => '米領ヴァージン諸島',
 			'VN' => 'ベトナム',
 			'VU' => 'バヌアツ',
 			'WF' => 'ウォリス・フツナ',
 			'WS' => 'サモア',
 			'XK' => 'コソボ',
 			'YE' => 'イエメン',
 			'YT' => 'マヨット',
 			'ZA' => '南アフリカ',
 			'ZM' => 'ザンビア',
 			'ZW' => 'ジンバブエ',
 			'ZZ' => '不明な地域',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'ドイツ語旧正書法',
 			'1994' => '標準レージア方言正書法',
 			'1996' => 'ドイツ語正書法(1996)',
 			'1606NICT' => '後期中世フランス語(〜1606)',
 			'1694ACAD' => '初期現代フランス語',
 			'1959ACAD' => '標準ベラルーシ語 (1959)',
 			'ALALC97' => 'ALA-LCラテン文字化(1997)',
 			'ALUKU' => 'アロコ方言',
 			'AREVELA' => '東アルメニア文語',
 			'AREVMDA' => '西アルメニア文語',
 			'BAKU1926' => '統一トルコラテン文字',
 			'BAUDDHA' => 'バウッダ',
 			'BISCAYAN' => 'ビスカヤ語',
 			'BISKE' => 'サン・ジョルジョ/ビーラ方言',
 			'BOHORIC' => 'ボホリッツ・アルファベット',
 			'BOONT' => 'ブーントリング',
 			'DAJNKO' => 'ダインチッツァ',
 			'EMODENG' => '初期近代英語',
 			'FONIPA' => '国際音声記号',
 			'FONUPA' => 'ウラル音声記号',
 			'FONXSAMP' => 'フォンクサンプ',
 			'HEPBURN' => 'ヘボン式ローマ字',
 			'HOGNORSK' => 'ヘグノシュク',
 			'ITIHASA' => 'イティハーサ',
 			'JAUER' => 'ヤウエル',
 			'JYUTPING' => '略称粤拼',
 			'KKCOR' => '共通コーンウォール語正書法',
 			'KSCOR' => '標準コーンウォール語正書法',
 			'LAUKIKA' => 'ラウキカ',
 			'LIPAW' => 'レージア方言 リポヴァツ方言',
 			'LUNA1918' => 'LUNA1918',
 			'METELKO' => 'メテルチッツァ',
 			'MONOTON' => 'モノトニック',
 			'NDYUKA' => 'ンジュカ方言',
 			'NEDIS' => 'ナティゾーネ方言',
 			'NJIVA' => 'ニヴァ方言',
 			'NULIK' => '現代ヴォラピュク語',
 			'OSOJS' => 'オゼアッコ/オソヤネ方言',
 			'PAMAKA' => 'パマカ方言',
 			'PETR1708' => 'PETR1708',
 			'PINYIN' => 'ピン音(ローマ字表記法)',
 			'POLYTON' => 'ポリトニック',
 			'POSIX' => 'コンピュータ',
 			'PUTER' => 'プーター',
 			'REVISED' => '改訂版',
 			'RIGIK' => '古典ヴォラピュク語',
 			'ROZAJ' => 'レシア方言',
 			'RUMGR' => 'RUMGR',
 			'SAAHO' => 'サホ語',
 			'SCOTLAND' => 'スコットランド標準英語',
 			'SCOUSE' => 'リバプール方言',
 			'SOLBA' => 'ストルヴィッツァ/ソルビツァ方言',
 			'SURMIRAN' => 'スルミラン',
 			'SURSILV' => 'スルシルヴァン',
 			'SUTSILV' => 'ストシルヴァン',
 			'TARASK' => 'タラシケヴィツァ正書法',
 			'UCCOR' => '統一コーンウォール語正書法',
 			'UCRCOR' => '改訂統一コーンウォール語正書法',
 			'ULSTER' => 'アルスター',
 			'VAIDIKA' => 'ヴァイディカ',
 			'VALENCIA' => 'バレンシア方言',
 			'VALLADER' => 'ヴァラダー',
 			'WADEGILE' => 'ウェード式ローマ字表記法',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => '暦法',
 			'cf' => '通貨フォーマット',
 			'colalternate' => '記号を無視した並べ替え',
 			'colbackwards' => 'アクセント（逆方向）による並べ替え',
 			'colcasefirst' => '大文字順/小文字順による並べ替え',
 			'colcaselevel' => '大文字小文字を区別した並べ替え',
 			'collation' => '並べ替え順序',
 			'colnormalization' => '正規化による並べ替え',
 			'colnumeric' => '数値による並べ替え',
 			'colstrength' => '強度による並べ替え',
 			'currency' => '通貨',
 			'hc' => '時間制(12 / 24)',
 			'lb' => '禁則処理',
 			'ms' => '単位系',
 			'numbers' => '数値書式',
 			'timezone' => 'タイムゾーン',
 			'va' => 'ロケールのバリアント',
 			'x' => '私用',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{仏暦},
 				'chinese' => q{中国暦},
 				'coptic' => q{コプト暦},
 				'dangi' => q{ダンギ暦},
 				'ethiopic' => q{エチオピア暦},
 				'ethiopic-amete-alem' => q{エチオピア創世紀元暦},
 				'gregorian' => q{西暦(グレゴリオ暦)},
 				'hebrew' => q{ユダヤ暦},
 				'indian' => q{インド国定暦},
 				'islamic' => q{イスラム暦},
 				'islamic-civil' => q{イスラム歴(定周期、公民紀元)},
 				'islamic-rgsa' => q{イスラム暦(サウジアラビア、月観測)},
 				'islamic-tbla' => q{イスラム歴(定周期、天文紀元)},
 				'islamic-umalqura' => q{イスラム暦(ウンム・アルクラー)},
 				'iso8601' => q{ISO-8601},
 				'japanese' => q{和暦},
 				'persian' => q{ペルシア暦},
 				'roc' => q{中華民国暦},
 			},
 			'cf' => {
 				'account' => q{会計通貨フォーマット},
 				'standard' => q{標準通貨フォーマット},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{記号で並べ替え},
 				'shifted' => q{記号を無視して並べ替え},
 			},
 			'colbackwards' => {
 				'no' => q{アクセント（順方向）で並べ替え},
 				'yes' => q{アクセント（逆方向）で並べ替え},
 			},
 			'colcasefirst' => {
 				'lower' => q{小文字優先で並べ替え},
 				'no' => q{大文字小文字を通常の順序で並べ替え},
 				'upper' => q{大文字優先で並べ替え},
 			},
 			'colcaselevel' => {
 				'no' => q{大文字小文字を区別しないで並べ替え},
 				'yes' => q{大文字小文字を区別して並べ替え},
 			},
 			'collation' => {
 				'big5han' => q{繁体字中国語順(Big5)},
 				'compat' => q{以前の順序（互換性）},
 				'dictionary' => q{辞書順},
 				'ducet' => q{ユニコード照合順},
 				'eor' => q{ヨーロッパ言語文字の並べ替え規則},
 				'gb2312han' => q{簡体字中国語順(GB2312)},
 				'phonebook' => q{電話帳順},
 				'phonetic' => q{音声順による並べ替え},
 				'pinyin' => q{ピンイン順},
 				'reformed' => q{リフォーム},
 				'search' => q{汎用検索},
 				'searchjl' => q{ハングル語頭子音による並べ替え},
 				'standard' => q{標準ソート順序},
 				'stroke' => q{画数順},
 				'traditional' => q{トラディッショナル},
 				'unihan' => q{部首順},
 				'zhuyin' => q{注音順},
 			},
 			'colnormalization' => {
 				'no' => q{正規化しないで並べ替え},
 				'yes' => q{Unicode 正規化で並べ替え},
 			},
 			'colnumeric' => {
 				'no' => q{数値を独立して並べ替え},
 				'yes' => q{数値を数値として並べ替え},
 			},
 			'colstrength' => {
 				'identical' => q{すべてを区別して並べ替え},
 				'primary' => q{基本文字のみで並べ替え},
 				'quaternary' => q{アクセント/大文字小文字/全角半角/仮名で並べ替え},
 				'secondary' => q{アクセントで並べ替え},
 				'tertiary' => q{アクセント/大文字小文字/全角半角で並べ替え},
 			},
 			'd0' => {
 				'fwidth' => q{全角},
 				'hwidth' => q{半角},
 				'npinyin' => q{数字},
 			},
 			'hc' => {
 				'h11' => q{12時間制(0〜11)},
 				'h12' => q{12時間制(1〜12)},
 				'h23' => q{24時間制(0〜23)},
 				'h24' => q{24時間制(1〜24)},
 			},
 			'lb' => {
 				'loose' => q{禁則処理(弱)},
 				'normal' => q{禁則処理(標準)},
 				'strict' => q{禁則処理(強)},
 			},
 			'm0' => {
 				'bgn' => q{BGN},
 				'ungegn' => q{UNGEGN},
 			},
 			'ms' => {
 				'metric' => q{メートル法},
 				'uksystem' => q{ヤード・ポンド法},
 				'ussystem' => q{米慣習単位},
 			},
 			'numbers' => {
 				'arab' => q{アラビア・インド数字},
 				'arabext' => q{ペルシア数字},
 				'armn' => q{アルメニア数字},
 				'armnlow' => q{アルメニア数字(小文字)},
 				'bali' => q{バリ数字},
 				'beng' => q{ベンガル数字},
 				'brah' => q{ブラーフミー数字},
 				'cakm' => q{チャクマ数字},
 				'cham' => q{チャム数字},
 				'deva' => q{デーヴァナーガリー数字},
 				'ethi' => q{エチオピア数字},
 				'finance' => q{財務用漢数字},
 				'fullwide' => q{全角数字},
 				'geor' => q{ジョージア数字},
 				'grek' => q{ギリシャ数字},
 				'greklow' => q{ギリシャ数字(小文字)},
 				'gujr' => q{グジャラート数字},
 				'guru' => q{グルムキー数字},
 				'hanidec' => q{漢数字(位取り記数法)},
 				'hans' => q{簡体漢数字},
 				'hansfin' => q{簡体大字},
 				'hant' => q{繁体漢数字},
 				'hantfin' => q{繁体大字},
 				'hebr' => q{ヘブライ数字},
 				'java' => q{ジャワ数字},
 				'jpan' => q{漢数字},
 				'jpanfin' => q{大字},
 				'kali' => q{カヤー数字},
 				'khmr' => q{クメール数字},
 				'knda' => q{カンナダ数字},
 				'lana' => q{ラーンナー数字},
 				'lanatham' => q{ラーンナー・タム数字},
 				'laoo' => q{ラオ数字},
 				'latn' => q{算用数字},
 				'lepc' => q{レプチャ数字},
 				'limb' => q{リンブ数字},
 				'mlym' => q{マラヤーラム数字},
 				'mong' => q{モンゴル数字},
 				'mtei' => q{マニプリ数字},
 				'mymr' => q{ミャンマー数字},
 				'mymrshan' => q{ミャンマー・シャン数字},
 				'native' => q{独自の記数法},
 				'nkoo' => q{ンコ数字},
 				'olck' => q{オルチキ数字},
 				'orya' => q{オリヤー数字},
 				'osma' => q{オスマニア数字},
 				'roman' => q{ローマ数字},
 				'romanlow' => q{ローマ数字(小文字)},
 				'saur' => q{サウラーシュトラ数字},
 				'shrd' => q{シャーラダー数字},
 				'sora' => q{ソラ・ソンペン数字},
 				'sund' => q{スンダ数字},
 				'takr' => q{タークリー数字},
 				'talu' => q{新タイ・ルー数字},
 				'taml' => q{タミール数字},
 				'tamldec' => q{タミル数字},
 				'telu' => q{テルグ数字},
 				'thai' => q{タイ数字},
 				'tibt' => q{チベット数字},
 				'traditional' => q{従来の記数法},
 				'vaii' => q{ヴァイ文字の記数法},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{メートル法},
 			'UK' => q{英ヤード・ポンド法},
 			'US' => q{米ヤード・ポンド法},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => '言語: {0}',
 			'script' => '文字: {0}',
 			'region' => '地域: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[丑 亥 亨 兌 兎 卯 嘉 壬 寅 巳 庚 弘 戊 戌 拼 昌 楔 猪 癸 祚 禄 禎 辰 酉 錄 閏 雉 鳳 鼠]},
			index => ['あ', 'か', 'さ', 'た', 'な', 'は', 'ま', 'や', 'ら', 'わ'],
			main => qr{[々 ゝヽ ゞヾ ー ぁァ あア ぃィ いイ ぅゥ うウ ヴ ぇェ えエ ぉォ おオ ヵ かカ がガ きキ ぎギ くク ぐグ ヶ けケ げゲ こコ ごゴ さサ ざザ しシ じジ すス ずズ せセ ぜゼ そソ ぞゾ たタ だダ ちチ ぢヂ っッ つツ づヅ てテ でデ とト どド なナ にニ ぬヌ ねネ のノ はハ ばバ ぱパ ひヒ びビ ぴピ ふフ ぶブ ぷプ へヘ べベ ぺペ ほホ ぼボ ぽポ まマ みミ むム めメ もモ ゃャ やヤ ゅュ ゆユ ょョ よヨ らラ りリ るル れレ ろロ ゎヮ わワ ゐヰ ゑヱ をヲ んン 一 丁 七 万-下 不 与 且 世 丘 丙 両 並 中 丸 丹 主 久 乏 乗 乙 九 乱 乳 乾 亀 了 予 争 事 二 互 五 井 亜 亡 交 享-亭 人 仁 今 介 仏 仕 他 付 仙 代-以 仮 仰 仲 件 任 企 伏-休 会 伝 伯 伴 伸 伺 似 但 位-佐 体 何 余 作 佳 併 使 例 侍 供 依 価 侮 侯 侵 便 係 促 俊 俗 保 信 修 俳 俵 俸 俺 倉 個 倍 倒 候 借 倣 値 倫 倹 偉 偏 停 健 側-偶 偽 傍 傑 傘 備 催 債 傷 傾 働 像 僕 僚 僧 儀 億 儒 償 優 元-兆 先 光 克 免 児 党 入 全 八-六 共 兵 具 典 兼 内 円 冊 再 冒 冗 写 冠 冬 冷 准 凍 凝 凡 処 凶 凸-出 刀 刃 分-刈 刊 刑 列 初 判 別 利 到 制-券 刺 刻 則 削 前 剖 剛 剣-剥 副 剰 割 創 劇 力 功 加 劣 助 努 励 労 効 劾 勅 勇 勉 動 勘 務 勝 募 勢 勤 勧 勲 包 化 北 匠 匹-医 匿 十 千 升 午 半 卑-協 南 単 博 占 印 危 即-卵 卸 厄 厘 厚 原 厳 去 参 又 及-収 叔 取 受 叙 口-句 叫 召 可-右 号 司 各 合 吉 同-向 君 吟 否 含 吸 吹 呈-告 周 味 呼 命 和 咲 哀 品 員 哲 唆 唇 唐 唯 唱 商 問 啓 善 喚 喜 喝 喪 喫 営 嗣 嘆 嘱 器 噴 嚇 囚 四 回 因 団 困 囲 図 固 国 圏 園 土 圧 在 地 坂 均 坊 坑 坪 垂 型 垣 埋 城 域 執 培 基 埼 堀 堂 堅 堕 堤 堪 報 場 塀 塁 塊 塑 塔 塗 塚 塩 填 塾 境 墓 増 墜 墨 墳 墾 壁 壇 壊 壌 士 壮 声-売 変 夏 夕 外 多 夜 夢 大 天-夫 央 失 奇-奉 奏 契 奔 奥 奨 奪 奮 女 奴 好 如-妄 妊 妙 妥 妨 妹 妻 姉 始 姓 委 姫 姻 姿 威 娘 娠 娯 婆 婚 婦 婿 媒 嫁 嫌 嫡 嬢 子 孔 字 存 孝 季 孤 学 孫 宅 宇-安 完 宗-定 宜 宝 実 客-室 宮 宰 害-家 容 宿 寂 寄 密 富 寒 寛 寝 察 寡 寧 審 寮 寸 寺 対 寿 封 専 射 将 尉-尋 導 小 少 尚 就 尺 尼-局 居 屈 届 屋 展 属 層 履 屯 山 岐 岡 岩 岬 岳 岸 峠 峡 峰 島 崇 崎 崩 川 州 巡 巣 工-巨 差 己 巻 市 布 帆 希 帝 帥 師 席 帯 帰 帳 常 帽 幅 幕 幣 干-年 幸 幹 幻-幾 庁 広 床 序 底 店 府 度 座 庫 庭 庶-庸 廃 廉 廊 延 廷 建 弁 弊 式 弐 弓-引 弟 弦 弧 弱 張 強 弾 当 形 彩 彫 彰 影 役 彼 往 征 径 待 律 後 徐 徒 従 得 御 復 循 微 徳 徴 徹 心 必 忌 忍 志-忙 応 忠 快 念 怒 怖 思 怠 急 性 怪 恋 恐 恒 恥 恨 恩 恭 息 恵 悔 悟 悠 患 悦 悩 悪 悲 悼 情 惑 惜 惨 惰 想 愁 愉 意 愚 愛 感 慈 態 慌 慎 慕 慢 慣 慨 慮 慰 慶 憂 憎 憤 憩 憲 憶 憾 懇 懐 懲 懸 成-戒 戦 戯 戸 戻 房 所 扇 扉 手 才 打 払 扱 扶 批 承 技 抄 把 抑 投 抗 折 抜 択 披 抱 抵 抹 押 抽 担 拍 拐 拒 拓 拘 拙 招 拝 拠 拡 括 拷 拾 持 指 挑 挙 挟 振 挿 捕 捜 捨 据 掃 授 掌 排 掘 掛 採 探 接 控 推 措 掲 描 提 揚 換 握 揮 援 揺 損 搬 搭 携 搾 摂 摘 摩 撃 撤 撮 撲 擁 操 擦 擬 支 改 攻 放 政 故 敏 救 敗 教 敢 散 敬 数 整 敵 敷 文 斉 斎 斗 料 斜 斤 斥 断 新 方 施 旅 旋 族 旗 既 日 旧-早 旬 昆 昇 明 易 昔 星 映 春 昨 昭 是 昼 時 晩 普 景 晴 晶 暁 暇 暑 暖 暗 暦 暫 暮 暴 曇 曜 曲 更 書 曹 替 最 月 有 服 朕 朗 望 朝 期 木 未-札 朱 朴 机 朽 杉 材 村 束 条 来 杯 東 松 板 析 林 枚 果 枝 枠 枢 枯 架 柄 某 染 柔 柱 柳 査 栄 栓 校 株 核 根 格 栽 桃 案 桑 桜 桟 梅 械 棄 棋 棒 棚 棟 森 棺 植 検 業 極 楼 楽 概 構 様 槽 標 模 権 横 樹 橋 機 欄 欠 次 欧 欲 欺 款 歌 歓 止 正 武 歩 歯 歳 歴 死 殉-残 殖 殴 段 殺 殻 殿 母 毎 毒 比 毛 氏 民 気 水 氷 永 汁 求 汎 汗 汚 江 池 決 汽 沈 沖 没 沢 河 沸 油 治 沼 沿 況 泉 泊 泌 法 泡-泣 泥 注 泰 泳 洋 洗 洞 津 洪 活 派 流 浄 浅 浜 浦 浪 浮 浴 海 浸 消 涙 涯 液 涼 淑 淡 深 混 添 清 渇-渉 渋 渓 減 渡 渦 温 測 港 湖 湯 湾-満 源 準 溝 溶 滅 滋 滑 滝 滞 滴 漁 漂 漆 漏 演 漠 漢 漫 漬 漸 潔 潜 潟 潤 潮 澄 激 濁 濃 濫 濯 瀬 火 灯 灰 災 炉 炊 炎 炭 点 為 烈 無 焦 然 焼 煙 照 煩 煮 熟 熱 燃 燥 爆 爵 父 片 版 牙 牛 牧 物 牲 特 犠 犬 犯 状 狂 狩 独 狭 猛 猟 猫 献 猶 猿 獄 獣 獲 玄 率 玉 王 珍 珠 班 現 球 理 琴 環 璽 瓶 甘 甚 生 産 用 田-申 男 町 画 界 畑 畔 留 畜 畝 略 番 異 畳 疎 疑 疫 疲 疾 病 症 痘 痛 痢 痴 療 癒 癖 発 登 白 百 的 皆 皇 皮 皿 盆 益 盗 盛 盟 監 盤 目 盲 直 相 盾 省 看 県 真 眠 眺 眼 着 睡 督 瞬 矛 矢 知 短 矯 石 砂 研 砕 砲 破 硝 硫 硬 碁 碑 確 磁 磨 礁 礎 示 礼 社 祈 祉 祖 祝 神 祥 票 祭 禁 禅 禍 福 秀 私 秋 科 秒 秘 租 秩 称 移 程 税 稚 種 稲 稼 稿 穀 穂 積 穏 穫 穴 究 空 突 窃 窒 窓 窮 窯 立 竜 章 童 端 競 竹 笑 笛 符 第 筆 等 筋 筒 答 策 箇 算 管 箱 節 範 築 篤 簡 簿 籍 米 粉 粋 粒 粗 粘 粛 粧 精 糖 糧 糸 系 糾 紀 約 紅 紋 納 純 紙-紛 素-索 紫 累 細 紳 紹 紺 終 組 経 結 絞 絡 給 統 絵 絶 絹 継 続 維 綱 網 綿 緊 総 緑 緒 線 締 編 緩 緯 練 縁 縄 縛 縦 縫 縮 績 繁 繊 織 繕 繭 繰 缶 罪 置 罰 署 罷 羅 羊 美 群 義 羽 翁 翌 習 翻 翼 老 考 者 耐 耕 耗 耳 聖 聞 聴 職 肉 肌 肖 肝 肢 肥 肩 肪 肯 育 肺 胃 胆 背 胎 胞 胴 胸 能 脂 脅 脈 脚 脱 脳 腐 腕 腰 腸 腹 膚 膜 膨 臓 臣 臨 自 臭 至 致 興 舌 舎 舗 舞 舟 航 般 舶 船 艇 艦 良 色 芋 芝 花 芳 芸 芽 苗 若 苦 英 茂 茎 茶 草 荒 荘 荷 菊 菌 菓 菜 華 落 葉 著 葬 蒸 蓄 蔵 薄 薦 薪-薬 藤 藩 藻 虎 虐 虚 虜 虞 虫 蚊 蚕 蛇 蛍 蛮 融 血 衆 行 術 街 衛 衝 衡 衣 表 衰 衷 袋 被 裁 裂 装 裏 裕 補 裸 製 複 褐 褒 襟 襲 西 要 覆 覇 見 規 視 覚 覧 親 観 角 解 触 言 訂 計 討 訓 託 記 訟 訪 設 許 訳 訴 診 証 詐 詔 評 詞 詠 試 詩 詰-詳 誇 誉 誌 認 誓 誕 誘 語 誠 誤 説 読 誰 課 調 談 請 論 諭 諮 諸 諾 謀 謁 謄 謙 講 謝 謡 謹 識 譜 警 議 譲 護 谷 豆 豊 豚 象 豪 貝 貞 負-貢 貧-販 貫 責 貯 貴 買 貸 費 貿 賀 賃 賄 資 賊 賓 賛 賜 賞 賠 賢 賦 質 購 贈 赤 赦 走 赴 起 超 越 趣 足 距 跡 路 跳 践 踊 踏 躍 身 車 軌 軍 軒 軟 転 軸 軽 較 載 輝 輩 輪 輸 轄 辛 辞 辱 農 辺 込 迅 迎 近 返 迫 迭 述 迷 追 退 送 逃 逆 透 逐 逓 途 通 逝 速 造 連 逮 週 進 逸 遂 遅 遇 遊 運 遍 過 道-違 遠 遣 適 遭 遮 遵 遷 選 遺 避 還 邦 邪 邸 郊 郎 郡 部 郭 郵 郷 都 酌 配 酒 酔 酢 酪 酬 酵 酷 酸 醜 醸 釈 里-量 金 針 釣 鈍 鈴 鉄 鉛 鉢 鉱 銀 銃 銅 銘 銭 鋭 鋳 鋼 錠 錬 錯 録 鍛 鎖 鎮 鏡 鐘 鑑 長 門 閉 開 閑 間 関 閣 閥 閲 闘 阪 防 阻 附 降 限 陛 院-陥 陪 陰 陳 陵 陶 陸 険 陽 隅 隆 隊 階 随 隔 際 障 隠 隣 隷 隻 雄-雇 雌 雑 離 難 雨 雪 雰 雲 零 雷 電 需 震 霊 霜 霧 露 青 静 非 面 革 靴 韓 音 韻 響 頂 頃 項 順 預-頒 領 頬 頭 頻 頼 題 額 顔 顕 願 類 顧 風 飛 食 飢 飯 飲 飼-飾 養 餓 館 首 香 馬 駄-駆 駐 騎 騒 験 騰 驚 骨 髄 高 髪 鬼 魂 魅 魔 魚 鮮 鯨 鳥 鳴 鶏 鹿 麗 麦 麻 黄 黒 黙 鼓 鼻 齢]},
			numbers => qr{[\- , . % ‰ + 0 1 2 3 4 5 6 7 8 9]},
			punctuation => qr{[‾ _＿ \-－ ‐ — ― 〜 ・ ･ ,， 、､ ;； \:： !！ ?？ .． ‥ … 。｡ ＇ ‘ ’ "＂ “ ” (（ )） \[［ \]］ \N{U+FF5B}｝ 〈 〉 《 》 「｢ 」｣ 『 』 【 】 〔 〕 ‖ § ¶ @＠ *＊ /／ \\＼ \&＆ #＃ %％ ‰ † ‡ ′ ″ 〃 ※]},
		};
	},
EOT
: sub {
		return { index => ['あ', 'か', 'さ', 'た', 'な', 'は', 'ま', 'や', 'ら', 'わ'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{「},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{」},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{『},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{』},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'' => {
						'name' => q(方位),
					},
					'acre' => {
						'name' => q(エーカー),
						'other' => q({0} エーカー),
					},
					'acre-foot' => {
						'name' => q(エーカーフィート),
						'other' => q({0} エーカーフィート),
					},
					'ampere' => {
						'name' => q(アンペア),
						'other' => q({0} アンペア),
					},
					'arc-minute' => {
						'name' => q(分),
						'other' => q({0} 分),
					},
					'arc-second' => {
						'name' => q(秒),
						'other' => q({0} 秒),
					},
					'astronomical-unit' => {
						'name' => q(天文単位),
						'other' => q({0} 天文単位),
					},
					'atmosphere' => {
						'name' => q(気圧),
						'other' => q({0} 気圧),
					},
					'bit' => {
						'name' => q(ビット),
						'other' => q({0} ビット),
					},
					'bushel' => {
						'name' => q(ブッシェル),
						'other' => q({0} ブッシェル),
					},
					'byte' => {
						'name' => q(バイト),
						'other' => q({0} バイト),
					},
					'calorie' => {
						'name' => q(カロリー),
						'other' => q({0} カロリー),
					},
					'carat' => {
						'name' => q(カラット),
						'other' => q({0} カラット),
					},
					'celsius' => {
						'name' => q(摂氏),
						'other' => q(摂氏 {0} 度),
					},
					'centiliter' => {
						'name' => q(センチリットル),
						'other' => q({0} センチリットル),
					},
					'centimeter' => {
						'name' => q(センチメートル),
						'other' => q({0} センチメートル),
						'per' => q({0}/センチメートル),
					},
					'century' => {
						'name' => q(世紀),
						'other' => q({0} 世紀),
					},
					'coordinate' => {
						'east' => q(東経{0}),
						'north' => q(北緯{0}),
						'south' => q(南緯{0}),
						'west' => q(西経{0}),
					},
					'cubic-centimeter' => {
						'name' => q(立方センチメートル),
						'other' => q({0} 立方センチメートル),
						'per' => q({0}/立方センチメートル),
					},
					'cubic-foot' => {
						'name' => q(立方フィート),
						'other' => q({0} 立方フィート),
					},
					'cubic-inch' => {
						'name' => q(立方インチ),
						'other' => q({0} 立方インチ),
					},
					'cubic-kilometer' => {
						'name' => q(立方キロメートル),
						'other' => q({0} 立方キロメートル),
					},
					'cubic-meter' => {
						'name' => q(立方メートル),
						'other' => q({0} 立方メートル),
						'per' => q({0}/立方メートル),
					},
					'cubic-mile' => {
						'name' => q(立方マイル),
						'other' => q({0} 立方マイル),
					},
					'cubic-yard' => {
						'name' => q(立方ヤード),
						'other' => q({0} 立方ヤード),
					},
					'cup' => {
						'name' => q(カップ),
						'other' => q({0} カップ),
					},
					'cup-metric' => {
						'name' => q(メトリックカップ),
						'other' => q({0} メトリックカップ),
					},
					'day' => {
						'name' => q(日),
						'other' => q({0} 日),
						'per' => q({0}/日),
					},
					'deciliter' => {
						'name' => q(デシリットル),
						'other' => q({0} デシリットル),
					},
					'decimeter' => {
						'name' => q(デシメートル),
						'other' => q({0} デシメートル),
					},
					'degree' => {
						'name' => q(度),
						'other' => q({0} 度),
					},
					'fahrenheit' => {
						'name' => q(華氏),
						'other' => q(華氏 {0} 度),
					},
					'fathom' => {
						'name' => q(ファゾム),
						'other' => q({0} ファゾム),
					},
					'fluid-ounce' => {
						'name' => q(液量オンス),
						'other' => q({0} 液量オンス),
					},
					'foodcalorie' => {
						'name' => q(カロリー),
						'other' => q({0} カロリー),
					},
					'foot' => {
						'name' => q(フィート),
						'other' => q({0} フィート),
						'per' => q({0}/フィート),
					},
					'furlong' => {
						'name' => q(ハロン),
						'other' => q({0} ハロン),
					},
					'g-force' => {
						'name' => q(重力加速度),
						'other' => q({0} G),
					},
					'gallon' => {
						'name' => q(ガロン),
						'other' => q({0} ガロン),
						'per' => q({0}/ガロン),
					},
					'gallon-imperial' => {
						'name' => q(英ガロン),
						'other' => q({0} 英ガロン),
						'per' => q({0}/英ガロン),
					},
					'generic' => {
						'name' => q(度),
						'other' => q({0}度),
					},
					'gigabit' => {
						'name' => q(ギガビット),
						'other' => q({0} ギガビット),
					},
					'gigabyte' => {
						'name' => q(ギガバイト),
						'other' => q({0} ギガバイト),
					},
					'gigahertz' => {
						'name' => q(ギガヘルツ),
						'other' => q({0} ギガヘルツ),
					},
					'gigawatt' => {
						'name' => q(ギガワット),
						'other' => q({0} ギガワット),
					},
					'gram' => {
						'name' => q(グラム),
						'other' => q({0} グラム),
						'per' => q({0}/グラム),
					},
					'hectare' => {
						'name' => q(ヘクタール),
						'other' => q({0} ヘクタール),
					},
					'hectoliter' => {
						'name' => q(ヘクトリットル),
						'other' => q({0} ヘクトリットル),
					},
					'hectopascal' => {
						'name' => q(ヘクトパスカル),
						'other' => q({0} ヘクトパスカル),
					},
					'hertz' => {
						'name' => q(ヘルツ),
						'other' => q({0} ヘルツ),
					},
					'horsepower' => {
						'name' => q(馬力),
						'other' => q({0} 馬力),
					},
					'hour' => {
						'name' => q(時間),
						'other' => q({0} 時間),
						'per' => q({0}/時間),
					},
					'inch' => {
						'name' => q(インチ),
						'other' => q({0} インチ),
						'per' => q({0}/インチ),
					},
					'inch-hg' => {
						'name' => q(水銀柱インチ),
						'other' => q({0} 水銀柱インチ),
					},
					'joule' => {
						'name' => q(ジュール),
						'other' => q({0} ジュール),
					},
					'karat' => {
						'name' => q(金),
						'other' => q({0} 金),
					},
					'kelvin' => {
						'name' => q(ケルビン),
						'other' => q({0} ケルビン),
					},
					'kilobit' => {
						'name' => q(キロビット),
						'other' => q({0} キロビット),
					},
					'kilobyte' => {
						'name' => q(キロバイト),
						'other' => q({0} キロバイト),
					},
					'kilocalorie' => {
						'name' => q(キロカロリー),
						'other' => q({0} キロカロリー),
					},
					'kilogram' => {
						'name' => q(キログラム),
						'other' => q({0} キログラム),
						'per' => q({0}/キログラム),
					},
					'kilohertz' => {
						'name' => q(キロヘルツ),
						'other' => q({0} キロヘルツ),
					},
					'kilojoule' => {
						'name' => q(キロジュール),
						'other' => q({0} キロジュール),
					},
					'kilometer' => {
						'name' => q(キロメートル),
						'other' => q({0} キロメートル),
						'per' => q({0}/キロメートル),
					},
					'kilometer-per-hour' => {
						'name' => q(キロメートル毎時),
						'other' => q(時速 {0} キロメートル),
					},
					'kilowatt' => {
						'name' => q(キロワット),
						'other' => q({0} キロワット),
					},
					'kilowatt-hour' => {
						'name' => q(キロワット時),
						'other' => q({0} キロワット時),
					},
					'knot' => {
						'name' => q(ノット),
						'other' => q({0} ノット),
					},
					'light-year' => {
						'name' => q(光年),
						'other' => q({0} 光年),
					},
					'liter' => {
						'name' => q(リットル),
						'other' => q({0} リットル),
						'per' => q({0}/リットル),
					},
					'liter-per-100kilometers' => {
						'name' => q(リットル毎100キロメートル),
						'other' => q({0} リットル毎100キロメートル),
					},
					'liter-per-kilometer' => {
						'name' => q(リットル毎キロメートル),
						'other' => q({0} リットル毎キロメートル),
					},
					'lux' => {
						'name' => q(ルクス),
						'other' => q({0} ルクス),
					},
					'megabit' => {
						'name' => q(メガビット),
						'other' => q({0} メガビット),
					},
					'megabyte' => {
						'name' => q(メガバイト),
						'other' => q({0} メガバイト),
					},
					'megahertz' => {
						'name' => q(メガヘルツ),
						'other' => q({0} メガヘルツ),
					},
					'megaliter' => {
						'name' => q(メガリットル),
						'other' => q({0} メガリットル),
					},
					'megawatt' => {
						'name' => q(メガワット),
						'other' => q({0} メガワット),
					},
					'meter' => {
						'name' => q(メートル),
						'other' => q({0} メートル),
						'per' => q({0}/メートル),
					},
					'meter-per-second' => {
						'name' => q(メートル毎秒),
						'other' => q(秒速 {0} メートル),
					},
					'meter-per-second-squared' => {
						'name' => q(メートル毎秒毎秒),
						'other' => q({0} メートル毎秒毎秒),
					},
					'metric-ton' => {
						'name' => q(トン),
						'other' => q({0} トン),
					},
					'microgram' => {
						'name' => q(マイクログラム),
						'other' => q({0} マイクログラム),
					},
					'micrometer' => {
						'name' => q(マイクロメートル),
						'other' => q({0} マイクロメートル),
					},
					'microsecond' => {
						'name' => q(マイクロ秒),
						'other' => q({0} マイクロ秒),
					},
					'mile' => {
						'name' => q(マイル),
						'other' => q({0} マイル),
					},
					'mile-per-gallon' => {
						'name' => q(マイル毎ガロン),
						'other' => q({0} マイル毎ガロン),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(マイル毎英ガロン),
						'other' => q({0} マイル毎英ガロン),
					},
					'mile-per-hour' => {
						'name' => q(マイル毎時),
						'other' => q(時速 {0} マイル),
					},
					'mile-scandinavian' => {
						'name' => q(スカンジナビアマイル),
						'other' => q({0} スカンジナビアマイル),
					},
					'milliampere' => {
						'name' => q(ミリアンペア),
						'other' => q({0} ミリアンペア),
					},
					'millibar' => {
						'name' => q(ミリバール),
						'other' => q({0} ミリバール),
					},
					'milligram' => {
						'name' => q(ミリグラム),
						'other' => q({0} ミリグラム),
					},
					'milligram-per-deciliter' => {
						'name' => q(ミリグラム毎デシリットル),
						'other' => q({0} ミリグラム毎デシリットル),
					},
					'milliliter' => {
						'name' => q(ミリリットル),
						'other' => q({0} ミリリットル),
					},
					'millimeter' => {
						'name' => q(ミリメートル),
						'other' => q({0} ミリメートル),
					},
					'millimeter-of-mercury' => {
						'name' => q(水銀柱ミリメートル),
						'other' => q({0} 水銀柱ミリメートル),
					},
					'millimole-per-liter' => {
						'name' => q(ミリモル毎リットル),
						'other' => q({0} ミリモル毎リットル),
					},
					'millisecond' => {
						'name' => q(ミリ秒),
						'other' => q({0} ミリ秒),
					},
					'milliwatt' => {
						'name' => q(ミリワット),
						'other' => q({0} ミリワット),
					},
					'minute' => {
						'name' => q(分),
						'other' => q({0} 分),
						'per' => q({0}/分),
					},
					'month' => {
						'name' => q(か月),
						'other' => q({0} か月),
						'per' => q({0}/月),
					},
					'nanometer' => {
						'name' => q(ナノメートル),
						'other' => q({0} ナノメートル),
					},
					'nanosecond' => {
						'name' => q(ナノ秒),
						'other' => q({0} ナノ秒),
					},
					'nautical-mile' => {
						'name' => q(海里),
						'other' => q({0} 海里),
					},
					'ohm' => {
						'name' => q(オーム),
						'other' => q({0} オーム),
					},
					'ounce' => {
						'name' => q(オンス),
						'other' => q({0} オンス),
						'per' => q({0}/オンス),
					},
					'ounce-troy' => {
						'name' => q(トロイオンス),
						'other' => q({0} トロイオンス),
					},
					'parsec' => {
						'name' => q(パーセク),
						'other' => q({0} パーセク),
					},
					'part-per-million' => {
						'name' => q(ppm),
						'other' => q({0} ppm),
					},
					'per' => {
						'1' => q({0}毎{1}),
					},
					'percent' => {
						'name' => q(パーセント),
						'other' => q({0} パーセント),
					},
					'permille' => {
						'name' => q(パーミル),
						'other' => q({0} パーミル),
					},
					'petabyte' => {
						'name' => q(ペタバイト),
						'other' => q({0} ペタバイト),
					},
					'picometer' => {
						'name' => q(ピコメートル),
						'other' => q({0} ピコメートル),
					},
					'pint' => {
						'name' => q(パイント),
						'other' => q({0} パイント),
					},
					'pint-metric' => {
						'name' => q(メトリックパイント),
						'other' => q({0} メトリックパイント),
					},
					'point' => {
						'name' => q(ポイント),
						'other' => q({0} ポイント),
					},
					'pound' => {
						'name' => q(ポンド),
						'other' => q({0} ポンド),
						'per' => q({0}/ポンド),
					},
					'pound-per-square-inch' => {
						'name' => q(重量ポンド毎平方インチ),
						'other' => q({0} 重量ポンド毎平方インチ),
					},
					'quart' => {
						'name' => q(クォート),
						'other' => q({0} クォート),
					},
					'radian' => {
						'name' => q(ラジアン),
						'other' => q({0} ラジアン),
					},
					'revolution' => {
						'name' => q(回転),
						'other' => q({0} 回転),
					},
					'second' => {
						'name' => q(秒),
						'other' => q({0} 秒),
						'per' => q({0}/秒),
					},
					'square-centimeter' => {
						'name' => q(平方センチメートル),
						'other' => q({0} 平方センチメートル),
						'per' => q({0}/平方センチメートル),
					},
					'square-foot' => {
						'name' => q(平方フィート),
						'other' => q({0} 平方フィート),
					},
					'square-inch' => {
						'name' => q(平方インチ),
						'other' => q({0} 平方インチ),
						'per' => q({0}/平方インチ),
					},
					'square-kilometer' => {
						'name' => q(平方キロメートル),
						'other' => q({0} 平方キロメートル),
						'per' => q({0}/平方キロメートル),
					},
					'square-meter' => {
						'name' => q(平方メートル),
						'other' => q({0} 平方メートル),
						'per' => q({0}/平方メートル),
					},
					'square-mile' => {
						'name' => q(平方マイル),
						'other' => q({0} 平方マイル),
						'per' => q({0}/平方マイル),
					},
					'square-yard' => {
						'name' => q(平方ヤード),
						'other' => q({0} 平方ヤード),
					},
					'stone' => {
						'name' => q(ストーン),
						'other' => q({0} ストーン),
					},
					'tablespoon' => {
						'name' => q(大さじ),
						'other' => q(大さじ {0}),
					},
					'teaspoon' => {
						'name' => q(小さじ),
						'other' => q(小さじ {0}),
					},
					'terabit' => {
						'name' => q(テラビット),
						'other' => q({0} テラビット),
					},
					'terabyte' => {
						'name' => q(テラバイト),
						'other' => q({0} テラバイト),
					},
					'ton' => {
						'name' => q(米トン),
						'other' => q({0} 米トン),
					},
					'volt' => {
						'name' => q(ボルト),
						'other' => q({0} ボルト),
					},
					'watt' => {
						'name' => q(ワット),
						'other' => q({0} ワット),
					},
					'week' => {
						'name' => q(週間),
						'other' => q({0} 週間),
						'per' => q({0}/週),
					},
					'yard' => {
						'name' => q(ヤード),
						'other' => q({0} ヤード),
					},
					'year' => {
						'name' => q(年),
						'other' => q({0} 年),
						'per' => q({0}/年),
					},
				},
				'narrow' => {
					'' => {
						'name' => q(方位),
					},
					'acre' => {
						'other' => q({0}ac),
					},
					'acre-foot' => {
						'other' => q({0}ac ft),
					},
					'ampere' => {
						'other' => q({0}A),
					},
					'arc-minute' => {
						'other' => q({0}′),
					},
					'arc-second' => {
						'other' => q({0}″),
					},
					'astronomical-unit' => {
						'name' => q(天文単位),
						'other' => q({0}au),
					},
					'bit' => {
						'other' => q({0}b),
					},
					'bushel' => {
						'name' => q(bu),
						'other' => q({0}bu),
					},
					'byte' => {
						'other' => q({0}B),
					},
					'calorie' => {
						'other' => q({0}calth),
					},
					'carat' => {
						'other' => q({0}ct),
					},
					'celsius' => {
						'name' => q(°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'other' => q({0}cL),
					},
					'centimeter' => {
						'name' => q(cm),
						'other' => q({0}cm),
						'per' => q({0}/cm),
					},
					'century' => {
						'name' => q(世紀),
						'other' => q({0} 世紀),
					},
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					'cubic-centimeter' => {
						'other' => q({0}cm³),
					},
					'cubic-foot' => {
						'other' => q({0}ft³),
					},
					'cubic-inch' => {
						'other' => q({0}in³),
					},
					'cubic-kilometer' => {
						'other' => q({0}km³),
					},
					'cubic-meter' => {
						'other' => q({0}m³),
					},
					'cubic-mile' => {
						'other' => q({0}mi³),
					},
					'cubic-yard' => {
						'other' => q({0}yd³),
					},
					'cup' => {
						'other' => q({0}カップ),
					},
					'day' => {
						'name' => q(日),
						'other' => q({0}d),
						'per' => q({0}/日),
					},
					'deciliter' => {
						'other' => q({0}dL),
					},
					'decimeter' => {
						'name' => q(デシメートル),
						'other' => q({0}dm),
					},
					'degree' => {
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'name' => q(°F),
						'other' => q({0}°F),
					},
					'fathom' => {
						'name' => q(fm),
						'other' => q({0}fth),
					},
					'fluid-ounce' => {
						'other' => q({0}fl oz),
					},
					'foodcalorie' => {
						'other' => q({0}cal),
					},
					'foot' => {
						'name' => q(フィート),
						'other' => q({0}′),
						'per' => q({0}/ft),
					},
					'furlong' => {
						'name' => q(fur),
						'other' => q({0}fur),
					},
					'g-force' => {
						'name' => q(重力加速度),
						'other' => q({0}G),
					},
					'gallon' => {
						'other' => q({0}gal),
					},
					'generic' => {
						'name' => q(°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'other' => q({0}Gb),
					},
					'gigabyte' => {
						'other' => q({0}GB),
					},
					'gigahertz' => {
						'other' => q({0}GHz),
					},
					'gigawatt' => {
						'other' => q({0}GW),
					},
					'gram' => {
						'name' => q(g),
						'other' => q({0}g),
						'per' => q({0}/g),
					},
					'hectare' => {
						'other' => q({0}ha),
					},
					'hectoliter' => {
						'other' => q({0}hL),
					},
					'hectopascal' => {
						'name' => q(hPa),
						'other' => q({0}hPa),
					},
					'hertz' => {
						'other' => q({0}Hz),
					},
					'horsepower' => {
						'other' => q({0}hp),
					},
					'hour' => {
						'name' => q(時間),
						'other' => q({0}h),
						'per' => q({0}/時間),
					},
					'inch' => {
						'name' => q(インチ),
						'other' => q({0}″),
						'per' => q({0}/in),
					},
					'inch-hg' => {
						'name' => q(水銀柱インチ),
						'other' => q({0}" Hg),
					},
					'joule' => {
						'other' => q({0}J),
					},
					'karat' => {
						'other' => q({0}K),
					},
					'kelvin' => {
						'name' => q(K),
						'other' => q({0}K),
					},
					'kilobit' => {
						'other' => q({0}kb),
					},
					'kilobyte' => {
						'other' => q({0}KB),
					},
					'kilocalorie' => {
						'other' => q({0}kcal),
					},
					'kilogram' => {
						'name' => q(kg),
						'other' => q({0}kg),
						'per' => q({0}/kg),
					},
					'kilohertz' => {
						'other' => q({0}kHz),
					},
					'kilojoule' => {
						'other' => q({0}kJ),
					},
					'kilometer' => {
						'name' => q(km),
						'other' => q({0}km),
						'per' => q({0}/km),
					},
					'kilometer-per-hour' => {
						'name' => q(km/h),
						'other' => q({0}km/h),
					},
					'kilowatt' => {
						'other' => q({0}kW),
					},
					'kilowatt-hour' => {
						'other' => q({0}kWh),
					},
					'knot' => {
						'name' => q(ノット),
						'other' => q({0} kn),
					},
					'light-year' => {
						'name' => q(光年),
						'other' => q({0}光年),
					},
					'liter' => {
						'name' => q(L),
						'other' => q({0}L),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'other' => q({0}L/100km),
					},
					'liter-per-kilometer' => {
						'other' => q({0}L/km),
					},
					'lux' => {
						'other' => q({0}lx),
					},
					'megabit' => {
						'other' => q({0}Mb),
					},
					'megabyte' => {
						'other' => q({0}MB),
					},
					'megahertz' => {
						'other' => q({0}MHz),
					},
					'megaliter' => {
						'other' => q({0}ML),
					},
					'megawatt' => {
						'other' => q({0}MW),
					},
					'meter' => {
						'name' => q(m),
						'other' => q({0}m),
						'per' => q({0}/m),
					},
					'meter-per-second' => {
						'name' => q(m/s),
						'other' => q({0}m/s),
					},
					'meter-per-second-squared' => {
						'name' => q(m/s²),
						'other' => q({0}m/s²),
					},
					'metric-ton' => {
						'other' => q({0}MT),
					},
					'microgram' => {
						'other' => q({0}µg),
					},
					'micrometer' => {
						'name' => q(マイクロメートル),
						'other' => q({0}µm),
					},
					'microsecond' => {
						'name' => q(µs),
						'other' => q({0}μs),
					},
					'mile' => {
						'name' => q(マイル),
						'other' => q({0}マイル),
					},
					'mile-per-gallon' => {
						'other' => q({0}mpg),
					},
					'mile-per-hour' => {
						'name' => q(マイル毎時),
						'other' => q({0}mi/h),
					},
					'mile-scandinavian' => {
						'name' => q(スカンジナビアマイル),
						'other' => q({0} smi),
					},
					'milliampere' => {
						'other' => q({0}mA),
					},
					'millibar' => {
						'name' => q(ミリバール),
						'other' => q({0}mb),
					},
					'milligram' => {
						'other' => q({0}mg),
					},
					'milliliter' => {
						'other' => q({0}ml),
					},
					'millimeter' => {
						'name' => q(mm),
						'other' => q({0}mm),
					},
					'millimeter-of-mercury' => {
						'name' => q(水銀柱ミリメートル),
						'other' => q({0}mm Hg),
					},
					'millisecond' => {
						'name' => q(ms),
						'other' => q({0}ms),
					},
					'milliwatt' => {
						'other' => q({0}mW),
					},
					'minute' => {
						'name' => q(分),
						'other' => q({0}m),
						'per' => q({0}/分),
					},
					'month' => {
						'name' => q(か月),
						'other' => q({0}m),
						'per' => q({0}/月),
					},
					'nanometer' => {
						'name' => q(ナノメートル),
						'other' => q({0}nm),
					},
					'nanosecond' => {
						'name' => q(ns),
						'other' => q({0}ns),
					},
					'nautical-mile' => {
						'name' => q(海里),
						'other' => q({0}海里),
					},
					'ohm' => {
						'other' => q({0}Ω),
					},
					'ounce' => {
						'name' => q(オンス),
						'other' => q({0}oz),
						'per' => q({0}/oz),
					},
					'ounce-troy' => {
						'other' => q({0}oz t),
					},
					'parsec' => {
						'name' => q(パーセク),
						'other' => q({0}pc),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(%),
						'other' => q({0}%),
					},
					'picometer' => {
						'name' => q(ピコメートル),
						'other' => q({0}pm),
					},
					'pint' => {
						'other' => q({0}pt),
					},
					'point' => {
						'name' => q(pt),
						'other' => q({0} pt),
					},
					'pound' => {
						'name' => q(ポンド),
						'other' => q({0}lb),
						'per' => q({0}/lb),
					},
					'pound-per-square-inch' => {
						'name' => q(重量ポンド毎平方インチ),
						'other' => q({0}psi),
					},
					'quart' => {
						'other' => q({0}qt),
					},
					'radian' => {
						'other' => q({0}rad),
					},
					'second' => {
						'name' => q(秒),
						'other' => q({0}s),
						'per' => q({0}/秒),
					},
					'square-centimeter' => {
						'other' => q({0}cm²),
					},
					'square-foot' => {
						'other' => q({0}ft²),
					},
					'square-inch' => {
						'other' => q({0}in²),
					},
					'square-kilometer' => {
						'other' => q({0}km²),
					},
					'square-meter' => {
						'other' => q({0}m²),
					},
					'square-mile' => {
						'other' => q({0}mi²),
					},
					'square-yard' => {
						'other' => q({0}yd²),
					},
					'stone' => {
						'name' => q(st),
						'other' => q({0}st),
					},
					'tablespoon' => {
						'other' => q(大さじ{0}),
					},
					'teaspoon' => {
						'other' => q(小さじ{0}),
					},
					'terabit' => {
						'other' => q({0}Tb),
					},
					'terabyte' => {
						'other' => q({0}TB),
					},
					'ton' => {
						'other' => q({0}t),
					},
					'volt' => {
						'other' => q({0}V),
					},
					'watt' => {
						'other' => q({0}W),
					},
					'week' => {
						'name' => q(週間),
						'other' => q({0}w),
						'per' => q({0}/週),
					},
					'yard' => {
						'name' => q(ヤード),
						'other' => q({0}ヤード),
					},
					'year' => {
						'name' => q(年),
						'other' => q({0}y),
						'per' => q({0}/年),
					},
				},
				'short' => {
					'' => {
						'name' => q(方位),
					},
					'acre' => {
						'name' => q(エーカー),
						'other' => q({0} ac),
					},
					'acre-foot' => {
						'name' => q(エーカーフィート),
						'other' => q({0} ac ft),
					},
					'ampere' => {
						'name' => q(アンペア),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'name' => q(分),
						'other' => q({0} 分),
					},
					'arc-second' => {
						'name' => q(秒),
						'other' => q({0} 秒),
					},
					'astronomical-unit' => {
						'name' => q(天文単位),
						'other' => q({0} au),
					},
					'atmosphere' => {
						'name' => q(気圧),
						'other' => q({0} atm),
					},
					'bit' => {
						'name' => q(ビット),
						'other' => q({0} bit),
					},
					'bushel' => {
						'name' => q(ブッシェル),
						'other' => q({0} bu),
					},
					'byte' => {
						'name' => q(バイト),
						'other' => q({0} byte),
					},
					'calorie' => {
						'name' => q(cal),
						'other' => q({0} cal),
					},
					'carat' => {
						'name' => q(カラット),
						'other' => q({0} ct),
					},
					'celsius' => {
						'name' => q(°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'name' => q(センチリットル),
						'other' => q({0} cL),
					},
					'centimeter' => {
						'name' => q(cm),
						'other' => q({0} cm),
						'per' => q({0}/cm),
					},
					'century' => {
						'name' => q(世紀),
						'other' => q({0} 世紀),
					},
					'coordinate' => {
						'east' => q(東経{0}),
						'north' => q(北緯{0}),
						'south' => q(南緯{0}),
						'west' => q(西経{0}),
					},
					'cubic-centimeter' => {
						'name' => q(cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					'cubic-foot' => {
						'name' => q(立方フィート),
						'other' => q({0} ft³),
					},
					'cubic-inch' => {
						'name' => q(立方インチ),
						'other' => q({0} in³),
					},
					'cubic-kilometer' => {
						'name' => q(km³),
						'other' => q({0} km³),
					},
					'cubic-meter' => {
						'name' => q(m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
					},
					'cubic-mile' => {
						'name' => q(立方マイル),
						'other' => q({0} mi³),
					},
					'cubic-yard' => {
						'name' => q(立方ヤード),
						'other' => q({0} yd³),
					},
					'cup' => {
						'name' => q(カップ),
						'other' => q({0} カップ),
					},
					'cup-metric' => {
						'name' => q(メトリックカップ),
						'other' => q({0} mc),
					},
					'day' => {
						'name' => q(日),
						'other' => q({0} 日),
						'per' => q({0}/日),
					},
					'deciliter' => {
						'name' => q(デシリットル),
						'other' => q({0} dL),
					},
					'decimeter' => {
						'name' => q(デシメートル),
						'other' => q({0} dm),
					},
					'degree' => {
						'name' => q(度),
						'other' => q({0} 度),
					},
					'fahrenheit' => {
						'name' => q(°F),
						'other' => q({0}°F),
					},
					'fathom' => {
						'name' => q(ファゾム),
						'other' => q({0} fth),
					},
					'fluid-ounce' => {
						'name' => q(液量オンス),
						'other' => q({0} fl oz),
					},
					'foodcalorie' => {
						'name' => q(cal),
						'other' => q({0} cal),
					},
					'foot' => {
						'name' => q(フィート),
						'other' => q({0} ft),
						'per' => q({0}/ft),
					},
					'furlong' => {
						'name' => q(ハロン),
						'other' => q({0} fur),
					},
					'g-force' => {
						'name' => q(重力加速度),
						'other' => q({0} G),
					},
					'gallon' => {
						'name' => q(ガロン),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					'gallon-imperial' => {
						'name' => q(英ガロン),
						'other' => q({0} gal Imp.),
						'per' => q({0}/gal Imp.),
					},
					'generic' => {
						'name' => q(°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(ギガビット),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'name' => q(GB),
						'other' => q({0} GB),
					},
					'gigahertz' => {
						'name' => q(GHz),
						'other' => q({0} GHz),
					},
					'gigawatt' => {
						'name' => q(ギガワット),
						'other' => q({0} GW),
					},
					'gram' => {
						'name' => q(グラム),
						'other' => q({0} g),
						'per' => q({0}/g),
					},
					'hectare' => {
						'name' => q(ヘクタール),
						'other' => q({0} ha),
					},
					'hectoliter' => {
						'name' => q(ヘクトリットル),
						'other' => q({0} hL),
					},
					'hectopascal' => {
						'name' => q(hPa),
						'other' => q({0} hPa),
					},
					'hertz' => {
						'name' => q(Hz),
						'other' => q({0} Hz),
					},
					'horsepower' => {
						'name' => q(馬力),
						'other' => q({0} 馬力),
					},
					'hour' => {
						'name' => q(時間),
						'other' => q({0} 時間),
						'per' => q({0}/時間),
					},
					'inch' => {
						'name' => q(インチ),
						'other' => q({0} in),
						'per' => q({0}/in),
					},
					'inch-hg' => {
						'name' => q(水銀柱インチ),
						'other' => q({0} inHg),
					},
					'joule' => {
						'name' => q(ジュール),
						'other' => q({0} J),
					},
					'karat' => {
						'name' => q(金),
						'other' => q({0} 金),
					},
					'kelvin' => {
						'name' => q(K),
						'other' => q({0} K),
					},
					'kilobit' => {
						'name' => q(キロビット),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'name' => q(KB),
						'other' => q({0} KB),
					},
					'kilocalorie' => {
						'name' => q(kcal),
						'other' => q({0} kcal),
					},
					'kilogram' => {
						'name' => q(kg),
						'other' => q({0} kg),
						'per' => q({0}/kg),
					},
					'kilohertz' => {
						'name' => q(kHz),
						'other' => q({0} kHz),
					},
					'kilojoule' => {
						'name' => q(キロジュール),
						'other' => q({0} kJ),
					},
					'kilometer' => {
						'name' => q(km),
						'other' => q({0} km),
						'per' => q({0}/km),
					},
					'kilometer-per-hour' => {
						'name' => q(km/h),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'name' => q(キロワット),
						'other' => q({0} kW),
					},
					'kilowatt-hour' => {
						'name' => q(キロワット時),
						'other' => q({0} kWh),
					},
					'knot' => {
						'name' => q(ノット),
						'other' => q({0} kn),
					},
					'light-year' => {
						'name' => q(光年),
						'other' => q({0} 光年),
					},
					'liter' => {
						'name' => q(リットル),
						'other' => q({0} L),
						'per' => q({0}/l),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'other' => q({0} L/100km),
					},
					'liter-per-kilometer' => {
						'name' => q(L/km),
						'other' => q({0} L/km),
					},
					'lux' => {
						'name' => q(ルクス),
						'other' => q({0} lx),
					},
					'megabit' => {
						'name' => q(メガビット),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'name' => q(MB),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'name' => q(MHz),
						'other' => q({0} MHz),
					},
					'megaliter' => {
						'name' => q(メガリットル),
						'other' => q({0} ML),
					},
					'megawatt' => {
						'name' => q(メガワット),
						'other' => q({0} MW),
					},
					'meter' => {
						'name' => q(m),
						'other' => q({0} m),
						'per' => q({0}/m),
					},
					'meter-per-second' => {
						'name' => q(m/s),
						'other' => q({0} m/s),
					},
					'meter-per-second-squared' => {
						'name' => q(m/s²),
						'other' => q({0} m/s²),
					},
					'metric-ton' => {
						'name' => q(トン),
						'other' => q({0} t),
					},
					'microgram' => {
						'name' => q(マイクログラム),
						'other' => q({0} µg),
					},
					'micrometer' => {
						'name' => q(マイクロメートル),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'name' => q(マイクロ秒),
						'other' => q({0} μs),
					},
					'mile' => {
						'name' => q(マイル),
						'other' => q({0} mi),
					},
					'mile-per-gallon' => {
						'name' => q(マイル/ガロン),
						'other' => q({0} mpg),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(マイル毎英ガロン),
						'other' => q({0} mpg Imp.),
					},
					'mile-per-hour' => {
						'name' => q(マイル毎時),
						'other' => q({0} mph),
					},
					'mile-scandinavian' => {
						'name' => q(スカンジナビアマイル),
						'other' => q({0} smi),
					},
					'milliampere' => {
						'name' => q(ミリアンペア),
						'other' => q({0} mA),
					},
					'millibar' => {
						'name' => q(ミリバール),
						'other' => q({0} mb),
					},
					'milligram' => {
						'name' => q(mg),
						'other' => q({0} mg),
					},
					'milligram-per-deciliter' => {
						'name' => q(ミリグラム毎デシリットル),
						'other' => q({0} mg/dL),
					},
					'milliliter' => {
						'name' => q(ミリリットル),
						'other' => q({0} ml),
					},
					'millimeter' => {
						'name' => q(mm),
						'other' => q({0} mm),
					},
					'millimeter-of-mercury' => {
						'name' => q(水銀柱ミリメートル),
						'other' => q({0} mm Hg),
					},
					'millimole-per-liter' => {
						'name' => q(ミリモル毎リットル),
						'other' => q({0} mmol/L),
					},
					'millisecond' => {
						'name' => q(ミリ秒),
						'other' => q({0} ms),
					},
					'milliwatt' => {
						'name' => q(ミリワット),
						'other' => q({0} mW),
					},
					'minute' => {
						'name' => q(分),
						'other' => q({0} 分),
						'per' => q({0}/分),
					},
					'month' => {
						'name' => q(か月),
						'other' => q({0} か月),
						'per' => q({0}/月),
					},
					'nanometer' => {
						'name' => q(ナノメートル),
						'other' => q({0} nm),
					},
					'nanosecond' => {
						'name' => q(ナノ秒),
						'other' => q({0} ns),
					},
					'nautical-mile' => {
						'name' => q(海里),
						'other' => q({0} 海里),
					},
					'ohm' => {
						'name' => q(オーム),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(オンス),
						'other' => q({0} oz),
						'per' => q({0}/oz),
					},
					'ounce-troy' => {
						'name' => q(トロイオンス),
						'other' => q({0} oz t),
					},
					'parsec' => {
						'name' => q(パーセク),
						'other' => q({0} pc),
					},
					'part-per-million' => {
						'name' => q(ppm),
						'other' => q({0} ppm),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(パーセント),
						'other' => q({0}%),
					},
					'permille' => {
						'name' => q(パーミル),
						'other' => q({0}‰),
					},
					'petabyte' => {
						'name' => q(ペタバイト),
						'other' => q({0} PB),
					},
					'picometer' => {
						'name' => q(ピコメートル),
						'other' => q({0} pm),
					},
					'pint' => {
						'name' => q(パイント),
						'other' => q({0} pt),
					},
					'pint-metric' => {
						'name' => q(メトリックパイント),
						'other' => q({0} mpt),
					},
					'point' => {
						'name' => q(ポイント),
						'other' => q({0} pt),
					},
					'pound' => {
						'name' => q(ポンド),
						'other' => q({0} lb),
						'per' => q({0}/lb),
					},
					'pound-per-square-inch' => {
						'name' => q(重量ポンド毎平方インチ),
						'other' => q({0} psi),
					},
					'quart' => {
						'name' => q(クォート),
						'other' => q({0} qt),
					},
					'radian' => {
						'name' => q(ラジアン),
						'other' => q({0} rad),
					},
					'revolution' => {
						'name' => q(回転),
						'other' => q({0} rev),
					},
					'second' => {
						'name' => q(秒),
						'other' => q({0} 秒),
						'per' => q({0}/秒),
					},
					'square-centimeter' => {
						'name' => q(cm²),
						'other' => q({0} cm²),
						'per' => q({0}/cm²),
					},
					'square-foot' => {
						'name' => q(平方フィート),
						'other' => q({0} ft²),
					},
					'square-inch' => {
						'name' => q(平方インチ),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					'square-kilometer' => {
						'name' => q(km²),
						'other' => q({0} km²),
						'per' => q({0}/km²),
					},
					'square-meter' => {
						'name' => q(m²),
						'other' => q({0} m²),
						'per' => q({0}/m²),
					},
					'square-mile' => {
						'name' => q(平方マイル),
						'other' => q({0} mi²),
						'per' => q({0}/mi²),
					},
					'square-yard' => {
						'name' => q(平方ヤード),
						'other' => q({0} yd²),
					},
					'stone' => {
						'name' => q(ストーン),
						'other' => q({0} st),
					},
					'tablespoon' => {
						'name' => q(大さじ),
						'other' => q(大さじ {0}),
					},
					'teaspoon' => {
						'name' => q(小さじ),
						'other' => q(小さじ {0}),
					},
					'terabit' => {
						'name' => q(テラビット),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'name' => q(テラバイト),
						'other' => q({0} TB),
					},
					'ton' => {
						'name' => q(米トン),
						'other' => q({0} s/t),
					},
					'volt' => {
						'name' => q(ボルト),
						'other' => q({0} V),
					},
					'watt' => {
						'name' => q(ワット),
						'other' => q({0} W),
					},
					'week' => {
						'name' => q(週間),
						'other' => q({0} 週間),
						'per' => q({0}/週),
					},
					'yard' => {
						'name' => q(ヤード),
						'other' => q({0} yd),
					},
					'year' => {
						'name' => q(年),
						'other' => q({0} 年),
						'per' => q({0}/年),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:はい|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:いいえ|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0} {1}),
				middle => q({0} {1}),
				end => q({0} {1}),
				2 => q({0} {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has traditional_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'jpan',
);

has finance_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'jpanfin',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'other' => '0',
				},
				'10000' => {
					'other' => '0万',
				},
				'100000' => {
					'other' => '00万',
				},
				'1000000' => {
					'other' => '000万',
				},
				'10000000' => {
					'other' => '0000万',
				},
				'100000000' => {
					'other' => '0億',
				},
				'1000000000' => {
					'other' => '00億',
				},
				'10000000000' => {
					'other' => '000億',
				},
				'100000000000' => {
					'other' => '0000億',
				},
				'1000000000000' => {
					'other' => '0兆',
				},
				'10000000000000' => {
					'other' => '00兆',
				},
				'100000000000000' => {
					'other' => '000兆',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'other' => '0',
				},
				'10000' => {
					'other' => '0万',
				},
				'100000' => {
					'other' => '00万',
				},
				'1000000' => {
					'other' => '000万',
				},
				'10000000' => {
					'other' => '0000万',
				},
				'100000000' => {
					'other' => '0億',
				},
				'1000000000' => {
					'other' => '00億',
				},
				'10000000000' => {
					'other' => '000億',
				},
				'100000000000' => {
					'other' => '0000億',
				},
				'1000000000000' => {
					'other' => '0兆',
				},
				'10000000000000' => {
					'other' => '00兆',
				},
				'100000000000000' => {
					'other' => '000兆',
				},
			},
			'short' => {
				'1000' => {
					'other' => '0',
				},
				'10000' => {
					'other' => '0万',
				},
				'100000' => {
					'other' => '00万',
				},
				'1000000' => {
					'other' => '000万',
				},
				'10000000' => {
					'other' => '0000万',
				},
				'100000000' => {
					'other' => '0億',
				},
				'1000000000' => {
					'other' => '00億',
				},
				'10000000000' => {
					'other' => '000億',
				},
				'100000000000' => {
					'other' => '0000億',
				},
				'1000000000000' => {
					'other' => '0兆',
				},
				'10000000000000' => {
					'other' => '00兆',
				},
				'100000000000000' => {
					'other' => '000兆',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			symbol => 'ADP',
			display_name => {
				'currency' => q(アンドラ ペセタ),
				'other' => q(アンドラ ペセタ),
			},
		},
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(アラブ首長国連邦ディルハム),
				'other' => q(UAE ディルハム),
			},
		},
		'AFA' => {
			symbol => 'AFA',
			display_name => {
				'currency' => q(アフガニスタン アフガニー \(1927–2002\)),
				'other' => q(アフガニスタン アフガニー \(1927–2002\)),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(アフガニスタン アフガニー),
				'other' => q(アフガニスタン アフガニー),
			},
		},
		'ALK' => {
			symbol => 'ALK',
			display_name => {
				'currency' => q(アルバニア レク \(1946–1965\)),
				'other' => q(アルバニア レク \(1946–1965\)),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(アルバニア レク),
				'other' => q(アルバニア レク),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(アルメニア ドラム),
				'other' => q(アルメニア ドラム),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(オランダ領アンティル ギルダー),
				'other' => q(オランダ領アンティル ギルダー),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(アンゴラ クワンザ),
				'other' => q(アンゴラ クワンザ),
			},
		},
		'AOK' => {
			symbol => 'AOK',
			display_name => {
				'currency' => q(アンゴラ クワンザ \(1977–1991\)),
				'other' => q(アンゴラ クワンザ \(1977–1991\)),
			},
		},
		'AON' => {
			symbol => 'AON',
			display_name => {
				'currency' => q(アンゴラ 新クワンザ \(1990–2000\)),
				'other' => q(アンゴラ 新クワンザ \(1990–2000\)),
			},
		},
		'AOR' => {
			symbol => 'AOR',
			display_name => {
				'currency' => q(アンゴラ 旧クワンザ \(1995–1999\)),
				'other' => q(アンゴラ 旧クワンザ \(1995–1999\)),
			},
		},
		'ARA' => {
			symbol => 'ARA',
			display_name => {
				'currency' => q(アルゼンチン アゥストラール),
				'other' => q(アルゼンチン アゥストラール),
			},
		},
		'ARL' => {
			symbol => 'ARL',
			display_name => {
				'currency' => q(アルゼンチン・ペソ・レイ（1970–1983）),
				'other' => q(アルゼンチン・ペソ・レイ（1970–1983）),
			},
		},
		'ARM' => {
			symbol => 'ARM',
			display_name => {
				'currency' => q(アルゼンチン・ペソ（1881–1970）),
				'other' => q(アルゼンチン・ペソ（1881–1970）),
			},
		},
		'ARP' => {
			symbol => 'ARP',
			display_name => {
				'currency' => q(アルゼンチン ペソ \(1983–1985\)),
				'other' => q(アルゼンチン ペソ \(1983–1985\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(アルゼンチン ペソ),
				'other' => q(アルゼンチン ペソ),
			},
		},
		'ATS' => {
			symbol => 'ATS',
			display_name => {
				'currency' => q(オーストリア シリング),
				'other' => q(オーストリア シリング),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(オーストラリア ドル),
				'other' => q(オーストラリア ドル),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(アルバ ギルダー),
				'other' => q(アルバ ギルダー),
			},
		},
		'AZM' => {
			symbol => 'AZM',
			display_name => {
				'currency' => q(アゼルバイジャン マナト \(1993–2006\)),
				'other' => q(アゼルバイジャン マナト \(1993–2006\)),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(アゼルバイジャン マナト),
				'other' => q(アゼルバイジャン マナト),
			},
		},
		'BAD' => {
			symbol => 'BAD',
			display_name => {
				'currency' => q(ボスニア・ヘルツェゴビナ ディナール \(1992–1994\)),
				'other' => q(ボスニア・ヘルツェゴビナ ディナール \(1992–1994\)),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(ボスニア・ヘルツェゴビナ 兌換マルク \(BAM\)),
				'other' => q(ボスニア・ヘルツェゴビナ 兌換マルク \(BAM\)),
			},
		},
		'BAN' => {
			symbol => 'BAN',
			display_name => {
				'currency' => q(ボスニア・ヘルツェゴビナ 新ディナール（1994–1997）),
				'other' => q(ボスニア・ヘルツェゴビナ 新ディナール（1994–1997）),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(バルバドス ドル),
				'other' => q(バルバドス ドル),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(バングラデシュ タカ),
				'other' => q(バングラデシュ タカ),
			},
		},
		'BEC' => {
			symbol => 'BEC',
			display_name => {
				'currency' => q(ベルギー フラン \(BEC\)),
				'other' => q(ベルギー フラン \(BEC\)),
			},
		},
		'BEF' => {
			symbol => 'BEF',
			display_name => {
				'currency' => q(ベルギー フラン),
				'other' => q(ベルギー フラン),
			},
		},
		'BEL' => {
			symbol => 'BEL',
			display_name => {
				'currency' => q(ベルギー フラン \(BEL\)),
				'other' => q(ベルギー フラン \(BEL\)),
			},
		},
		'BGL' => {
			symbol => 'BGL',
			display_name => {
				'currency' => q(ブルガリア レフ),
				'other' => q(ブルガリア レフ),
			},
		},
		'BGM' => {
			symbol => 'BGM',
			display_name => {
				'currency' => q(ブルガリア社会主義 レフ),
				'other' => q(ブルガリア社会主義 レフ),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(ブルガリア 新レフ),
				'other' => q(ブルガリア 新レフ),
			},
		},
		'BGO' => {
			symbol => 'BGO',
			display_name => {
				'currency' => q(ブルガリア レフ（1879–1952）),
				'other' => q(ブルガリア レフ（1879–1952）),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(バーレーン ディナール),
				'other' => q(バーレーン ディナール),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(ブルンジ フラン),
				'other' => q(ブルンジ フラン),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(バミューダ ドル),
				'other' => q(バミューダ ドル),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(ブルネイ ドル),
				'other' => q(ブルネイ ドル),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(ボリビア ボリビアーノ),
				'other' => q(ボリビア ボリビアーノ),
			},
		},
		'BOL' => {
			symbol => 'BOL',
			display_name => {
				'currency' => q(ボリビア ボリビアーノ \(1863–1963\)),
				'other' => q(ボリビア ボリビアーノ \(1863–1963\)),
			},
		},
		'BOP' => {
			symbol => 'BOP',
			display_name => {
				'currency' => q(ボリビア ペソ),
				'other' => q(ボリビア ペソ),
			},
		},
		'BOV' => {
			symbol => 'BOV',
			display_name => {
				'currency' => q(ボリビア \(Mvdol\)),
				'other' => q(ボリビア \(Mvdol\)),
			},
		},
		'BRB' => {
			symbol => 'BRB',
			display_name => {
				'currency' => q(ブラジル 新クルゼイロ \(1967–1986\)),
				'other' => q(ブラジル 新クルゼイロ \(1967–1986\)),
			},
		},
		'BRC' => {
			symbol => 'BRC',
			display_name => {
				'currency' => q(ブラジル クルザード \(1986–1989\)),
				'other' => q(ブラジル クルザード \(1986–1989\)),
			},
		},
		'BRE' => {
			symbol => 'BRE',
			display_name => {
				'currency' => q(ブラジル クルゼイロ \(1990–1993\)),
				'other' => q(ブラジル クルゼイロ \(1990–1993\)),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ブラジル レアル),
				'other' => q(ブラジル レアル),
			},
		},
		'BRN' => {
			symbol => 'BRN',
			display_name => {
				'currency' => q(ブラジル 新クルザード \(1989–1990\)),
				'other' => q(ブラジル 新クルザード \(1989–1990\)),
			},
		},
		'BRR' => {
			symbol => 'BRR',
			display_name => {
				'currency' => q(ブラジル クルゼイロ \(1993–1994\)),
				'other' => q(ブラジル クルゼイロ \(1993–1994\)),
			},
		},
		'BRZ' => {
			symbol => 'BRZ',
			display_name => {
				'currency' => q(ブラジル クルゼイロ（1942–1967）),
				'other' => q(ブラジル クルゼイロ（1942–1967）),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(バハマ ドル),
				'other' => q(バハマ ドル),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(ブータン ニュルタム),
				'other' => q(ブータン ニュルタム),
			},
		},
		'BUK' => {
			symbol => 'BUK',
			display_name => {
				'currency' => q(ビルマ チャット),
				'other' => q(ビルマ チャット),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(ボツワナ プラ),
				'other' => q(ボツワナ プラ),
			},
		},
		'BYB' => {
			symbol => 'BYB',
			display_name => {
				'currency' => q(ベラルーシ 新ルーブル \(1994–1999\)),
				'other' => q(ベラルーシ 新ルーブル \(1994–1999\)),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(ベラルーシ ルーブル),
				'other' => q(ベラルーシ ルーブル),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(ベラルーシ ルーブル \(2000–2016\)),
				'other' => q(ベラルーシ ルーブル \(2000–2016\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(ベリーズ ドル),
				'other' => q(ベリーズ ドル),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(カナダ ドル),
				'other' => q(カナダ ドル),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(コンゴ フラン),
				'other' => q(コンゴ フラン),
			},
		},
		'CHE' => {
			symbol => 'CHE',
			display_name => {
				'currency' => q(ユーロ \(WIR\)),
				'other' => q(ユーロ \(WIR\)),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(スイス フラン),
				'other' => q(スイス フラン),
			},
		},
		'CHW' => {
			symbol => 'CHW',
			display_name => {
				'currency' => q(フラン \(WIR\)),
				'other' => q(フラン \(WIR\)),
			},
		},
		'CLE' => {
			symbol => 'CLE',
			display_name => {
				'currency' => q(チリ エスクード),
				'other' => q(チリ エスクード),
			},
		},
		'CLF' => {
			symbol => 'CLF',
			display_name => {
				'currency' => q(チリ ウニダ・デ・フォメント \(UF\)),
				'other' => q(チリ ウニダ・デ・フォメント \(UF\)),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(チリ ペソ),
				'other' => q(チリ ペソ),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(中国人民元\(オフショア\)),
				'other' => q(中国人民元\(オフショア\)),
			},
		},
		'CNX' => {
			symbol => 'CNX',
			display_name => {
				'currency' => q(中国人民銀行ドル),
				'other' => q(中国人民銀行ドル),
			},
		},
		'CNY' => {
			symbol => '元',
			display_name => {
				'currency' => q(中国人民元),
				'other' => q(中国人民元),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(コロンビア ペソ),
				'other' => q(コロンビア ペソ),
			},
		},
		'COU' => {
			symbol => 'COU',
			display_name => {
				'currency' => q(コロンビア レアル （UVR\)),
				'other' => q(コロンビア レアル （UVR\)),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(コスタリカ コロン),
				'other' => q(コスタリカ コロン),
			},
		},
		'CSD' => {
			symbol => 'CSD',
			display_name => {
				'currency' => q(セルビア ディナール \(2002–2006\)),
				'other' => q(セルビア ディナール \(2002–2006\)),
			},
		},
		'CSK' => {
			symbol => 'CSK',
			display_name => {
				'currency' => q(チェコスロバキア コルナ),
				'other' => q(チェコスロバキア コルナ),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(キューバ 兌換ペソ),
				'other' => q(キューバ 兌換ペソ),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(キューバ ペソ),
				'other' => q(キューバ ペソ),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(カーボベルデ エスクード),
				'other' => q(カーボベルデ エスクード),
			},
		},
		'CYP' => {
			symbol => 'CYP',
			display_name => {
				'currency' => q(キプロス ポンド),
				'other' => q(キプロス ポンド),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(チェコ コルナ),
				'other' => q(チェコ コルナ),
			},
		},
		'DDM' => {
			symbol => 'DDM',
			display_name => {
				'currency' => q(東ドイツ マルク),
				'other' => q(東ドイツ マルク),
			},
		},
		'DEM' => {
			symbol => 'DEM',
			display_name => {
				'currency' => q(ドイツ マルク),
				'other' => q(ドイツ マルク),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(ジブチ フラン),
				'other' => q(ジブチ フラン),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(デンマーク クローネ),
				'other' => q(デンマーク クローネ),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(ドミニカ ペソ),
				'other' => q(ドミニカ ペソ),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(アルジェリア ディナール),
				'other' => q(アルジェリア ディナール),
			},
		},
		'ECS' => {
			symbol => 'ECS',
			display_name => {
				'currency' => q(エクアドル スクレ),
				'other' => q(エクアドル スクレ),
			},
		},
		'ECV' => {
			symbol => 'ECV',
			display_name => {
				'currency' => q(エクアドル \(UVC\)),
				'other' => q(エクアドル \(UVC\)),
			},
		},
		'EEK' => {
			symbol => 'EEK',
			display_name => {
				'currency' => q(エストニア クルーン),
				'other' => q(エストニア クルーン),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(エジプト ポンド),
				'other' => q(エジプト ポンド),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(エリトリア ナクファ),
				'other' => q(エリトリア ナクファ),
			},
		},
		'ESA' => {
			symbol => 'ESA',
			display_name => {
				'currency' => q(スペインペセタ（勘定A）),
				'other' => q(スペインペセタ（勘定A）),
			},
		},
		'ESB' => {
			symbol => 'ESB',
			display_name => {
				'currency' => q(スペイン 兌換ペセタ),
				'other' => q(スペイン 兌換ペセタ),
			},
		},
		'ESP' => {
			symbol => 'ESP',
			display_name => {
				'currency' => q(スペイン ペセタ),
				'other' => q(スペイン ペセタ),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(エチオピア ブル),
				'other' => q(エチオピア ブル),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ユーロ),
				'other' => q(ユーロ),
			},
		},
		'FIM' => {
			symbol => 'FIM',
			display_name => {
				'currency' => q(フィンランド マルカ),
				'other' => q(フィンランド マルカ),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(フィジー ドル),
				'other' => q(フィジー ドル),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(フォークランド（マルビナス）諸島 ポンド),
				'other' => q(フォークランド（マルビナス）諸島 ポンド),
			},
		},
		'FRF' => {
			symbol => 'FRF',
			display_name => {
				'currency' => q(フランス フラン),
				'other' => q(フランス フラン),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(英国ポンド),
				'other' => q(英国ポンド),
			},
		},
		'GEK' => {
			symbol => 'GEK',
			display_name => {
				'currency' => q(ジョージア クーポン ラリ),
				'other' => q(ジョージア クーポン ラリ),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(ジョージア ラリ),
				'other' => q(ジョージア ラリ),
			},
		},
		'GHC' => {
			symbol => 'GHC',
			display_name => {
				'currency' => q(ガーナ セディ \(1979–2007\)),
				'other' => q(ガーナ セディ \(1979–2007\)),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(ガーナ セディ),
				'other' => q(ガーナ セディ),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(ジブラルタル ポンド),
				'other' => q(ジブラルタル ポンド),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(ガンビア ダラシ),
				'other' => q(ガンビア ダラシ),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(ギニア フラン),
				'other' => q(ギニア フラン),
			},
		},
		'GNS' => {
			symbol => 'GNS',
			display_name => {
				'currency' => q(ギニア シリー),
				'other' => q(ギニア シリー),
			},
		},
		'GQE' => {
			symbol => 'GQE',
			display_name => {
				'currency' => q(赤道ギニア エクウェレ),
				'other' => q(赤道ギニア エクウェレ),
			},
		},
		'GRD' => {
			symbol => 'GRD',
			display_name => {
				'currency' => q(ギリシャ ドラクマ),
				'other' => q(ギリシャ ドラクマ),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(グアテマラ ケツァル),
				'other' => q(グアテマラ ケツァル),
			},
		},
		'GWE' => {
			symbol => 'GWE',
			display_name => {
				'currency' => q(ポルトガル領ギニア エスクード),
				'other' => q(ポルトガル領ギニア エスクード),
			},
		},
		'GWP' => {
			symbol => 'GWP',
			display_name => {
				'currency' => q(ギニアビサウ ペソ),
				'other' => q(ギニアビサウ ペソ),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(ガイアナ ドル),
				'other' => q(ガイアナ ドル),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(香港ドル),
				'other' => q(香港ドル),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(ホンジュラス レンピラ),
				'other' => q(ホンジュラス レンピラ),
			},
		},
		'HRD' => {
			symbol => 'HRD',
			display_name => {
				'currency' => q(クロアチア ディナール),
				'other' => q(クロアチア ディナール),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(クロアチア クーナ),
				'other' => q(クロアチア クーナ),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(ハイチ グールド),
				'other' => q(ハイチ グールド),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(ハンガリー フォリント),
				'other' => q(ハンガリー フォリント),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(インドネシア ルピア),
				'other' => q(インドネシア ルピア),
			},
		},
		'IEP' => {
			symbol => 'IEP',
			display_name => {
				'currency' => q(アイリッシュ ポンド),
				'other' => q(アイリッシュ ポンド),
			},
		},
		'ILP' => {
			symbol => 'ILP',
			display_name => {
				'currency' => q(イスラエル ポンド),
				'other' => q(イスラエル ポンド),
			},
		},
		'ILR' => {
			symbol => 'ILR',
			display_name => {
				'currency' => q(イスラエル シェケル \(1980–1985\)),
				'other' => q(イスラエル シェケル \(1980–1985\)),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(イスラエル新シェケル),
				'other' => q(イスラエル新シェケル),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(インド ルピー),
				'other' => q(インド ルピー),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(イラク ディナール),
				'other' => q(イラク ディナール),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(イラン リアル),
				'other' => q(イラン リアル),
			},
		},
		'ISJ' => {
			symbol => 'ISJ',
			display_name => {
				'currency' => q(アイスランド クローナ \(1918–1981\)),
				'other' => q(アイスランド クローナ \(1918–1981\)),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(アイスランド クローナ),
				'other' => q(アイスランド クローナ),
			},
		},
		'ITL' => {
			symbol => 'ITL',
			display_name => {
				'currency' => q(イタリア リラ),
				'other' => q(イタリア リラ),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(ジャマイカ ドル),
				'other' => q(ジャマイカ ドル),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(ヨルダン ディナール),
				'other' => q(ヨルダン ディナール),
			},
		},
		'JPY' => {
			symbol => '￥',
			display_name => {
				'currency' => q(日本円),
				'other' => q(円),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(ケニア シリング),
				'other' => q(ケニア シリング),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(キルギス ソム),
				'other' => q(キルギス ソム),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(カンボジア リエル),
				'other' => q(カンボジア リエル),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(コモロ フラン),
				'other' => q(コモロ フラン),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(北朝鮮ウォン),
				'other' => q(北朝鮮ウォン),
			},
		},
		'KRH' => {
			symbol => 'KRH',
			display_name => {
				'currency' => q(韓国 ファン（1953–1962）),
				'other' => q(韓国 ファン（1953–1962）),
			},
		},
		'KRO' => {
			symbol => 'KRO',
			display_name => {
				'currency' => q(韓国 ウォン（1945–1953）),
				'other' => q(韓国 ウォン（1945–1953）),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(韓国ウォン),
				'other' => q(韓国ウォン),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(クウェート ディナール),
				'other' => q(クウェート ディナール),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(ケイマン諸島 ドル),
				'other' => q(ケイマン諸島 ドル),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(カザフスタン テンゲ),
				'other' => q(カザフスタン テンゲ),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(ラオス キープ),
				'other' => q(ラオス キープ),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(レバノン ポンド),
				'other' => q(レバノン ポンド),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(スリランカ ルピー),
				'other' => q(スリランカ ルピー),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(リベリア ドル),
				'other' => q(リベリア ドル),
			},
		},
		'LSL' => {
			symbol => 'LSL',
			display_name => {
				'currency' => q(レソト ロティ),
				'other' => q(レソト ロティ),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(リトアニア リタス),
				'other' => q(リトアニア リタス),
			},
		},
		'LTT' => {
			symbol => 'LTT',
			display_name => {
				'currency' => q(リトアニア タロナ),
				'other' => q(リトアニア タロナ),
			},
		},
		'LUC' => {
			symbol => 'LUC',
			display_name => {
				'currency' => q(ルクセンブルク 兌換フラン),
				'other' => q(ルクセンブルク 兌換フラン),
			},
		},
		'LUF' => {
			symbol => 'LUF',
			display_name => {
				'currency' => q(ルクセンブルグ フラン),
				'other' => q(ルクセンブルグ フラン),
			},
		},
		'LUL' => {
			symbol => 'LUL',
			display_name => {
				'currency' => q(ルクセンブルク 金融フラン),
				'other' => q(ルクセンブルク 金融フラン),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(ラトビア ラッツ),
				'other' => q(ラトビア ラッツ),
			},
		},
		'LVR' => {
			symbol => 'LVR',
			display_name => {
				'currency' => q(ラトビア ルーブル),
				'other' => q(ラトビア ルーブル),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(リビア ディナール),
				'other' => q(リビア ディナール),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(モロッコ ディルハム),
				'other' => q(モロッコ ディルハム),
			},
		},
		'MAF' => {
			symbol => 'MAF',
			display_name => {
				'currency' => q(モロッコ フラン),
				'other' => q(モロッコ フラン),
			},
		},
		'MCF' => {
			symbol => 'MCF',
			display_name => {
				'currency' => q(モネガスク フラン),
				'other' => q(モネガスク フラン),
			},
		},
		'MDC' => {
			symbol => 'MDC',
			display_name => {
				'currency' => q(モルドバ クーポン),
				'other' => q(モルドバ クーポン),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(モルドバ レイ),
				'other' => q(モルドバ レイ),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(マダガスカル アリアリ),
				'other' => q(マダガスカル アリアリ),
			},
		},
		'MGF' => {
			symbol => 'MGF',
			display_name => {
				'currency' => q(マラガシ フラン),
				'other' => q(マラガシ フラン),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(マケドニア デナル),
				'other' => q(マケドニア デナル),
			},
		},
		'MKN' => {
			symbol => 'MKN',
			display_name => {
				'currency' => q(マケドニア ディナール（1992–1993）),
				'other' => q(マケドニア ディナール（1992–1993）),
			},
		},
		'MLF' => {
			symbol => 'MLF',
			display_name => {
				'currency' => q(マリ フラン),
				'other' => q(マリ フラン),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(ミャンマー チャット),
				'other' => q(ミャンマー チャット),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(モンゴル トグログ),
				'other' => q(モンゴル トグログ),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(マカオ パタカ),
				'other' => q(マカオ パタカ),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(モーリタニア ウギア \(1973–2017\)),
				'other' => q(モーリタニア ウギア \(1973–2017\)),
			},
		},
		'MRU' => {
			symbol => 'MRU',
			display_name => {
				'currency' => q(モーリタニア ウギア),
				'other' => q(モーリタニア ウギア),
			},
		},
		'MTL' => {
			symbol => 'MTL',
			display_name => {
				'currency' => q(マルタ リラ),
				'other' => q(マルタ リラ),
			},
		},
		'MTP' => {
			symbol => 'MTP',
			display_name => {
				'currency' => q(マルタ ポンド),
				'other' => q(マルタ ポンド),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(モーリシャス ルピー),
				'other' => q(モーリシャス ルピー),
			},
		},
		'MVP' => {
			symbol => 'MVP',
			display_name => {
				'currency' => q(モルディブ諸島 ルピー),
				'other' => q(モルディブ諸島 ルピー),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(モルディブ ルフィア),
				'other' => q(モルディブ ルフィア),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(マラウィ クワチャ),
				'other' => q(マラウィ クワチャ),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(メキシコ ペソ),
				'other' => q(メキシコ ペソ),
			},
		},
		'MXP' => {
			symbol => 'MXP',
			display_name => {
				'currency' => q(メキシコ ペソ \(1861–1992\)),
				'other' => q(メキシコ ペソ \(1861–1992\)),
			},
		},
		'MXV' => {
			symbol => 'MXV',
			display_name => {
				'currency' => q(メキシコ \(UDI\)),
				'other' => q(メキシコ \(UDI\)),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(マレーシア リンギット),
				'other' => q(マレーシア リンギット),
			},
		},
		'MZE' => {
			symbol => 'MZE',
			display_name => {
				'currency' => q(モザンピーク エスクード),
				'other' => q(モザンピーク エスクード),
			},
		},
		'MZM' => {
			symbol => 'MZM',
			display_name => {
				'currency' => q(モザンビーク メティカル \(1980–2006\)),
				'other' => q(モザンビーク メティカル \(1980–2006\)),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(モザンビーク メティカル),
				'other' => q(モザンビーク メティカル),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(ナミビア ドル),
				'other' => q(ナミビア ドル),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(ナイジェリア ナイラ),
				'other' => q(ナイジェリア ナイラ),
			},
		},
		'NIC' => {
			symbol => 'NIC',
			display_name => {
				'currency' => q(ニカラグア コルドバ \(1988–1991\)),
				'other' => q(ニカラグア コルドバ \(1988–1991\)),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(ニカラグア コルドバ オロ),
				'other' => q(ニカラグア コルドバ オロ),
			},
		},
		'NLG' => {
			symbol => 'NLG',
			display_name => {
				'currency' => q(オランダ ギルダー),
				'other' => q(オランダ ギルダー),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(ノルウェー クローネ),
				'other' => q(ノルウェー クローネ),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(ネパール ルピー),
				'other' => q(ネパール ルピー),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(ニュージーランド ドル),
				'other' => q(ニュージーランド ドル),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(オマーン リアル),
				'other' => q(オマーン リアル),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(パナマ バルボア),
				'other' => q(パナマ バルボア),
			},
		},
		'PEI' => {
			symbol => 'PEI',
			display_name => {
				'currency' => q(ペルー インティ),
				'other' => q(ペルー インティ),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(ペルー ソル),
				'other' => q(ペルー ソル),
			},
		},
		'PES' => {
			symbol => 'PES',
			display_name => {
				'currency' => q(ペルー ソル \(1863–1965\)),
				'other' => q(ペルー ソル \(1863–1965\)),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(パプアニューギニア キナ),
				'other' => q(パプアニューギニア キナ),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(フィリピン ペソ),
				'other' => q(フィリピン ペソ),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(パキスタン ルピー),
				'other' => q(パキスタン ルピー),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(ポーランド ズウォティ),
				'other' => q(ポーランド ズウォティ),
			},
		},
		'PLZ' => {
			symbol => 'PLZ',
			display_name => {
				'currency' => q(ポーランド ズウォティ \(1950–1995\)),
				'other' => q(ポーランド ズウォティ \(1950–1995\)),
			},
		},
		'PTE' => {
			symbol => 'PTE',
			display_name => {
				'currency' => q(ポルトガル エスクード),
				'other' => q(ポルトガル エスクード),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(パラグアイ グアラニ),
				'other' => q(パラグアイ グアラニ),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(カタール リアル),
				'other' => q(カタール リアル),
			},
		},
		'RHD' => {
			symbol => 'RHD',
			display_name => {
				'currency' => q(ローデシア ドル),
				'other' => q(ローデシア ドル),
			},
		},
		'ROL' => {
			symbol => 'ROL',
			display_name => {
				'currency' => q(ルーマニア レイ \(1952–2006\)),
				'other' => q(ルーマニア レイ \(1952–2006\)),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(ルーマニア レイ),
				'other' => q(ルーマニア レイ),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(ディナール \(セルビア\)),
				'other' => q(ディナール \(セルビア\)),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(ロシア ルーブル),
				'other' => q(ロシア ルーブル),
			},
		},
		'RUR' => {
			symbol => 'RUR',
			display_name => {
				'currency' => q(ロシア ルーブル \(1991–1998\)),
				'other' => q(ロシア ルーブル \(1991–1998\)),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(ルワンダ フラン),
				'other' => q(ルワンダ フラン),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(サウジ リヤル),
				'other' => q(サウジ リヤル),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(ソロモン諸島 ドル),
				'other' => q(ソロモン諸島 ドル),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(セーシェル ルピー),
				'other' => q(セーシェル ルピー),
			},
		},
		'SDD' => {
			symbol => 'SDD',
			display_name => {
				'currency' => q(スーダン ディナール \(1992–2007\)),
				'other' => q(スーダン ディナール \(1992–2007\)),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(スーダン ポンド),
				'other' => q(スーダン ポンド),
			},
		},
		'SDP' => {
			symbol => 'SDP',
			display_name => {
				'currency' => q(スーダン ポンド \(1957–1998\)),
				'other' => q(スーダン ポンド \(1957–1998\)),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(スウェーデン クローナ),
				'other' => q(スウェーデン クローナ),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(シンガポール ドル),
				'other' => q(シンガポール ドル),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(セントヘレナ ポンド),
				'other' => q(セントヘレナ ポンド),
			},
		},
		'SIT' => {
			symbol => 'SIT',
			display_name => {
				'currency' => q(スロベニア トラール),
				'other' => q(スロベニア トラール),
			},
		},
		'SKK' => {
			symbol => 'SKK',
			display_name => {
				'currency' => q(スロバキア コルナ),
				'other' => q(スロバキア コルナ),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(シエラレオネ レオン),
				'other' => q(シエラレオネ レオン),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(ソマリア シリング),
				'other' => q(ソマリア シリング),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(スリナム ドル),
				'other' => q(スリナム ドル),
			},
		},
		'SRG' => {
			symbol => 'SRG',
			display_name => {
				'currency' => q(スリナム ギルダー),
				'other' => q(スリナム ギルダー),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(南スーダン ポンド),
				'other' => q(南スーダン ポンド),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(サントメ・プリンシペ ドブラ \(1977–2017\)),
				'other' => q(サントメ・プリンシペ ドブラ \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'STN',
			display_name => {
				'currency' => q(サントメ・プリンシペ ドブラ),
				'other' => q(サントメ・プリンシペ ドブラ),
			},
		},
		'SUR' => {
			symbol => 'SUR',
			display_name => {
				'currency' => q(ソ連 ルーブル),
				'other' => q(ソ連 ルーブル),
			},
		},
		'SVC' => {
			symbol => 'SVC',
			display_name => {
				'currency' => q(エルサルバドル コロン),
				'other' => q(エルサルバドル コロン),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(シリア ポンド),
				'other' => q(シリア ポンド),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(スワジランド リランゲニ),
				'other' => q(スワジランド リランゲニ),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(タイ バーツ),
				'other' => q(タイ バーツ),
			},
		},
		'TJR' => {
			symbol => 'TJR',
			display_name => {
				'currency' => q(タジキスタン ルーブル),
				'other' => q(タジキスタン ルーブル),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(タジキスタン ソモニ),
				'other' => q(タジキスタン ソモニ),
			},
		},
		'TMM' => {
			symbol => 'TMM',
			display_name => {
				'currency' => q(トルクメニスタン マナト \(1993–2009\)),
				'other' => q(トルクメニスタン マナト \(1993–2009\)),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(トルクメニスタン マナト),
				'other' => q(トルクメニスタン マナト),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(チュニジア ディナール),
				'other' => q(チュニジア ディナール),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(トンガ パ・アンガ),
				'other' => q(トンガ パ・アンガ),
			},
		},
		'TPE' => {
			symbol => 'TPE',
			display_name => {
				'currency' => q(ティモール エスクード),
				'other' => q(ティモール エスクード),
			},
		},
		'TRL' => {
			symbol => 'TRL',
			display_name => {
				'currency' => q(トルコ リラ \(1922–2005\)),
				'other' => q(トルコ リラ \(1922–2005\)),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(新トルコリラ),
				'other' => q(新トルコリラ),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(トリニダード・トバゴ ドル),
				'other' => q(トリニダード・トバゴ ドル),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(新台湾ドル),
				'other' => q(新台湾ドル),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(タンザニア シリング),
				'other' => q(タンザニア シリング),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(ウクライナ グリブナ),
				'other' => q(ウクライナ グリブナ),
			},
		},
		'UAK' => {
			symbol => 'UAK',
			display_name => {
				'currency' => q(ウクライナ カルボバネツ),
				'other' => q(ウクライナ カルボバネツ),
			},
		},
		'UGS' => {
			symbol => 'UGS',
			display_name => {
				'currency' => q(ウガンダ シリング \(1966–1987\)),
				'other' => q(ウガンダ シリング \(1966–1987\)),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(ウガンダ シリング),
				'other' => q(ウガンダ シリング),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(米ドル),
				'other' => q(米ドル),
			},
		},
		'USN' => {
			symbol => 'USN',
			display_name => {
				'currency' => q(米ドル \(翌日\)),
				'other' => q(米ドル \(翌日\)),
			},
		},
		'USS' => {
			symbol => 'USS',
			display_name => {
				'currency' => q(米ドル \(当日\)),
				'other' => q(米ドル \(当日\)),
			},
		},
		'UYI' => {
			symbol => 'UYI',
			display_name => {
				'currency' => q(ウルグアイ ペソエン),
				'other' => q(ウルグアイ ペソエン),
			},
		},
		'UYP' => {
			symbol => 'UYP',
			display_name => {
				'currency' => q(ウルグアイ ペソ \(1975–1993\)),
				'other' => q(ウルグアイ ペソ \(1975–1993\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(ウルグアイ ペソ),
				'other' => q(ウルグアイ ペソ),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(ウズベキスタン スム),
				'other' => q(ウズベキスタン スム),
			},
		},
		'VEB' => {
			symbol => 'VEB',
			display_name => {
				'currency' => q(ベネズエラ ボリバル \(1871–2008\)),
				'other' => q(ベネズエラ ボリバル \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(ベネズエラ ボリバル \(2008–2018\)),
				'other' => q(ベネズエラ ボリバル \(2008–2018\)),
			},
		},
		'VES' => {
			symbol => 'VES',
			display_name => {
				'currency' => q(ベネズエラ ボリバル),
				'other' => q(ベネズエラ ボリバル),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ベトナム ドン),
				'other' => q(ベトナム ドン),
			},
		},
		'VNN' => {
			symbol => 'VNN',
			display_name => {
				'currency' => q(ベトナム ドン（1978–1985）),
				'other' => q(ベトナム ドン（1978–1985）),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(バヌアツ バツ),
				'other' => q(バヌアツ バツ),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(サモア タラ),
				'other' => q(サモア タラ),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(中央アフリカ CFA フラン),
				'other' => q(中央アフリカ CFA フラン),
			},
		},
		'XAG' => {
			symbol => 'XAG',
			display_name => {
				'currency' => q(銀),
				'other' => q(銀),
			},
		},
		'XAU' => {
			symbol => 'XAU',
			display_name => {
				'currency' => q(金),
				'other' => q(金),
			},
		},
		'XBA' => {
			symbol => 'XBA',
			display_name => {
				'currency' => q(ヨーロッパ混合単位 \(EURCO\)),
				'other' => q(ヨーロッパ混合単位 \(EURCO\)),
			},
		},
		'XBB' => {
			symbol => 'XBB',
			display_name => {
				'currency' => q(ヨーロッパ通貨単位 \(EMU–6\)),
				'other' => q(ヨーロッパ通貨単位 \(EMU–6\)),
			},
		},
		'XBC' => {
			symbol => 'XBC',
			display_name => {
				'currency' => q(ヨーロッパ勘定単位 \(EUA–9\)),
				'other' => q(ヨーロッパ勘定単位 \(EUA–9\)),
			},
		},
		'XBD' => {
			symbol => 'XBD',
			display_name => {
				'currency' => q(ヨーロッパ勘定単位 \(EUA–17\)),
				'other' => q(ヨーロッパ勘定単位 \(EUA–17\)),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(東カリブ ドル),
				'other' => q(東カリブ ドル),
			},
		},
		'XDR' => {
			symbol => 'XDR',
			display_name => {
				'currency' => q(特別引き出し権),
				'other' => q(特別引き出し権),
			},
		},
		'XEU' => {
			symbol => 'XEU',
			display_name => {
				'currency' => q(ヨーロッパ通貨単位),
				'other' => q(ヨーロッパ通貨単位),
			},
		},
		'XFO' => {
			symbol => 'XFO',
			display_name => {
				'currency' => q(フランス金フラン),
				'other' => q(フランス金フラン),
			},
		},
		'XFU' => {
			symbol => 'XFU',
			display_name => {
				'currency' => q(フランス フラン \(UIC\)),
				'other' => q(フランス フラン \(UIC\)),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(西アフリカ CFA フラン),
				'other' => q(西アフリカ CFA フラン),
			},
		},
		'XPD' => {
			symbol => 'XPD',
			display_name => {
				'currency' => q(パラジウム),
				'other' => q(パラジウム),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP フラン),
				'other' => q(CFP フラン),
			},
		},
		'XPT' => {
			symbol => 'XPT',
			display_name => {
				'currency' => q(プラチナ),
				'other' => q(プラチナ),
			},
		},
		'XRE' => {
			symbol => 'XRE',
			display_name => {
				'currency' => q(RINET基金),
				'other' => q(RINET基金),
			},
		},
		'XSU' => {
			symbol => 'XSU',
			display_name => {
				'currency' => q(スクレ),
				'other' => q(スクレ),
			},
		},
		'XTS' => {
			symbol => 'XTS',
			display_name => {
				'currency' => q(テスト用通貨コード),
				'other' => q(テスト用通貨コード),
			},
		},
		'XUA' => {
			symbol => 'XUA',
			display_name => {
				'currency' => q(UA \(アフリカ開発銀行\)),
				'other' => q(UA \(アフリカ開発銀行\)),
			},
		},
		'XXX' => {
			symbol => 'XXX',
			display_name => {
				'currency' => q(不明または無効な通貨),
				'other' => q(不明または無効な通貨),
			},
		},
		'YDD' => {
			symbol => 'YDD',
			display_name => {
				'currency' => q(イエメン ディナール),
				'other' => q(イエメン ディナール),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(イエメン リアル),
				'other' => q(イエメン リアル),
			},
		},
		'YUD' => {
			symbol => 'YUD',
			display_name => {
				'currency' => q(ユーゴスラビア ハード・ディナール \(1966–1990\)),
				'other' => q(ユーゴスラビア ハード・ディナール \(1966–1990\)),
			},
		},
		'YUM' => {
			symbol => 'YUM',
			display_name => {
				'currency' => q(ユーゴスラビア ノビ・ディナール \(1994–2002\)),
				'other' => q(ユーゴスラビア ノビ・ディナール \(1994–2002\)),
			},
		},
		'YUN' => {
			symbol => 'YUN',
			display_name => {
				'currency' => q(ユーゴスラビア 兌換ディナール \(1990–1992\)),
				'other' => q(ユーゴスラビア 兌換ディナール \(1990–1992\)),
			},
		},
		'YUR' => {
			symbol => 'YUR',
			display_name => {
				'currency' => q(ユーゴスラビア 改革ディナール（1992–1993）),
				'other' => q(ユーゴスラビア 改革ディナール（1992–1993）),
			},
		},
		'ZAL' => {
			symbol => 'ZAL',
			display_name => {
				'currency' => q(南アフリカ ランド \(ZAL\)),
				'other' => q(南アフリカ ランド \(ZAL\)),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(南アフリカ ランド),
				'other' => q(南アフリカ ランド),
			},
		},
		'ZMK' => {
			symbol => 'ZMK',
			display_name => {
				'currency' => q(ザンビア クワチャ \(1968–2012\)),
				'other' => q(ザンビア クワチャ \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(ザンビア クワチャ),
				'other' => q(ザンビア クワチャ),
			},
		},
		'ZRN' => {
			symbol => 'ZRN',
			display_name => {
				'currency' => q(ザイール 新ザイール \(1993–1998\)),
				'other' => q(ザイール 新ザイール \(1993–1998\)),
			},
		},
		'ZRZ' => {
			symbol => 'ZRZ',
			display_name => {
				'currency' => q(ザイール ザイール \(1971–1993\)),
				'other' => q(ザイール ザイール \(1971–1993\)),
			},
		},
		'ZWD' => {
			symbol => 'ZWD',
			display_name => {
				'currency' => q(ジンバブエ ドル \(1980–2008\)),
				'other' => q(ジンバブエ ドル \(1980–2008\)),
			},
		},
		'ZWL' => {
			symbol => 'ZWL',
			display_name => {
				'currency' => q(ジンバブエ ドル \(2009\)),
				'other' => q(ジンバブエ ドル \(2009\)),
			},
		},
		'ZWR' => {
			symbol => 'ZWR',
			display_name => {
				'currency' => q(シンバブエ ドル（2008）),
				'other' => q(シンバブエ ドル（2008）),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'chinese' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'正月',
							'二月',
							'三月',
							'四月',
							'五月',
							'六月',
							'七月',
							'八月',
							'九月',
							'十月',
							'十一月',
							'十二月'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'正',
							'二',
							'三',
							'四',
							'五',
							'六',
							'七',
							'八',
							'九',
							'十',
							'十一',
							'十二'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'正月',
							'二月',
							'三月',
							'四月',
							'五月',
							'六月',
							'七月',
							'八月',
							'九月',
							'十月',
							'十一月',
							'十二月'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'正月',
							'二月',
							'三月',
							'四月',
							'五月',
							'六月',
							'七月',
							'八月',
							'九月',
							'十月',
							'十一月',
							'十二月'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'正',
							'二',
							'三',
							'四',
							'五',
							'六',
							'七',
							'八',
							'九',
							'十',
							'十一',
							'十二'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'正月',
							'二月',
							'三月',
							'四月',
							'五月',
							'六月',
							'七月',
							'八月',
							'九月',
							'十月',
							'十一月',
							'十二月'
						],
						leap => [
							
						],
					},
				},
			},
			'coptic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'トウト',
							'ババ',
							'ハトール',
							'キアック',
							'トーバ',
							'アムシール',
							'バラムハート',
							'バラモウダ',
							'バシャンス',
							'パオーナ',
							'エペープ',
							'メスラ',
							'ナシエ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'トウト',
							'ババ',
							'ハトール',
							'キアック',
							'トーバ',
							'アムシール',
							'バラムハート',
							'バラモウダ',
							'バシャンス',
							'パオーナ',
							'エペープ',
							'メスラ',
							'ナシエ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'トウト',
							'ババ',
							'ハトール',
							'キアック',
							'トーバ',
							'アムシール',
							'バラムハート',
							'バラモウダ',
							'バシャンス',
							'パオーナ',
							'エペープ',
							'メスラ',
							'ナシエ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'トウト',
							'ババ',
							'ハトール',
							'キアック',
							'トーバ',
							'アムシール',
							'バラムハート',
							'バラモウダ',
							'バシャンス',
							'パオーナ',
							'エペープ',
							'メスラ',
							'ナシエ'
						],
						leap => [
							
						],
					},
				},
			},
			'dangi' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'正月',
							'二月',
							'三月',
							'四月',
							'五月',
							'六月',
							'七月',
							'八月',
							'九月',
							'十月',
							'十一月',
							'十二月'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'正',
							'二',
							'三',
							'四',
							'五',
							'六',
							'七',
							'八',
							'九',
							'十',
							'十一',
							'十二'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'正月',
							'二月',
							'三月',
							'四月',
							'五月',
							'六月',
							'七月',
							'八月',
							'九月',
							'十月',
							'十一月',
							'十二月'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'正月',
							'二月',
							'三月',
							'四月',
							'五月',
							'六月',
							'七月',
							'八月',
							'九月',
							'十月',
							'十一月',
							'十二月'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'正',
							'二',
							'三',
							'四',
							'五',
							'六',
							'七',
							'八',
							'九',
							'十',
							'十一',
							'十二'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'正月',
							'二月',
							'三月',
							'四月',
							'五月',
							'六月',
							'七月',
							'八月',
							'九月',
							'十月',
							'十一月',
							'十二月'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'メスケレム',
							'テケムト',
							'ヘダル',
							'ターサス',
							'テル',
							'イェカティト',
							'メガビト',
							'ミアジア',
							'ゲンボト',
							'セネ',
							'ハムレ',
							'ネハッセ',
							'パグメン'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'メスケレム',
							'テケムト',
							'ヘダル',
							'ターサス',
							'テル',
							'イェカティト',
							'メガビト',
							'ミアジア',
							'ゲンボト',
							'セネ',
							'ハムレ',
							'ネハッセ',
							'パグメン'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'メスケレム',
							'テケムト',
							'ヘダル',
							'ターサス',
							'テル',
							'イェカティト',
							'メガビト',
							'ミアジア',
							'ゲンボト',
							'セネ',
							'ハムレ',
							'ネハッセ',
							'パグメン'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'メスケレム',
							'テケムト',
							'ヘダル',
							'ターサス',
							'テル',
							'イェカティト',
							'メガビト',
							'ミアジア',
							'ゲンボト',
							'セネ',
							'ハムレ',
							'ネハッセ',
							'パグメン'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'1月',
							'2月',
							'3月',
							'4月',
							'5月',
							'6月',
							'7月',
							'8月',
							'9月',
							'10月',
							'11月',
							'12月'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'1月',
							'2月',
							'3月',
							'4月',
							'5月',
							'6月',
							'7月',
							'8月',
							'9月',
							'10月',
							'11月',
							'12月'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'1月',
							'2月',
							'3月',
							'4月',
							'5月',
							'6月',
							'7月',
							'8月',
							'9月',
							'10月',
							'11月',
							'12月'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'1月',
							'2月',
							'3月',
							'4月',
							'5月',
							'6月',
							'7月',
							'8月',
							'9月',
							'10月',
							'11月',
							'12月'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ティスレ',
							'へシボン',
							'キスレブ',
							'テベット',
							'シバット',
							'アダル I',
							'アダル',
							'ニサン',
							'イヤル',
							'シバン',
							'タムズ',
							'アヴ',
							'エルル'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'アダル II'
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'7'
						],
					},
					wide => {
						nonleap => [
							'ティスレ',
							'へシボン',
							'キスレブ',
							'テベット',
							'シバット',
							'アダル I',
							'アダル',
							'ニサン',
							'イヤル',
							'シバン',
							'タムズ',
							'アヴ',
							'エルル'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'アダル II'
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ティスレ',
							'へシボン',
							'キスレブ',
							'テベット',
							'シバット',
							'アダル I',
							'アダル',
							'ニサン',
							'イヤル',
							'シバン',
							'タムズ',
							'アヴ',
							'エルル'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'アダル II'
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'7'
						],
					},
					wide => {
						nonleap => [
							'ティスレ',
							'へシボン',
							'キスレブ',
							'テベット',
							'シバット',
							'アダル I',
							'アダル',
							'ニサン',
							'イヤル',
							'シバン',
							'タムズ',
							'アヴ',
							'エルル'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'アダル II'
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'カイトラ',
							'ヴァイサカ',
							'ジャイスタ',
							'アーサダ',
							'スラバナ',
							'バードラ',
							'アスビナ',
							'カルディカ',
							'アヴラハヤナ',
							'パウサ',
							'マーガ',
							'パルグナ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'カイトラ',
							'ヴァイサカ',
							'ジャイスタ',
							'アーサダ',
							'スラバナ',
							'バードラ',
							'アスビナ',
							'カルディカ',
							'アヴラハヤナ',
							'パウサ',
							'マーガ',
							'パルグナ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'カイトラ',
							'ヴァイサカ',
							'ジャイスタ',
							'アーサダ',
							'スラバナ',
							'バードラ',
							'アスビナ',
							'カルディカ',
							'アヴラハヤナ',
							'パウサ',
							'マーガ',
							'パルグナ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'カイトラ',
							'ヴァイサカ',
							'ジャイスタ',
							'アーサダ',
							'スラバナ',
							'バードラ',
							'アスビナ',
							'カルディカ',
							'アヴラハヤナ',
							'パウサ',
							'マーガ',
							'パルグナ'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ムハッラム',
							'サフアル',
							'ラビー・ウル・アウワル',
							'ラビー・ウッ・サーニー',
							'ジュマーダル・アウワル',
							'ジュマーダッサーニー',
							'ラジャブ',
							'シャアバーン',
							'ラマダーン',
							'シャウワール',
							'ズル・カイダ',
							'ズル・ヒッジャ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ムハッラム',
							'サフアル',
							'ラビー・ウル・アウワル',
							'ラビー・ウッ・サーニー',
							'ジュマーダル・アウワル',
							'ジュマーダッサーニー',
							'ラジャブ',
							'シャアバーン',
							'ラマダーン',
							'シャウワール',
							'ズル・カイダ',
							'ズル・ヒッジャ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ムハッラム',
							'サフアル',
							'ラビー・ウル・アウワル',
							'ラビー・ウッ・サーニー',
							'ジュマーダル・アウワル',
							'ジュマーダッサーニー',
							'ラジャブ',
							'シャアバーン',
							'ラマダーン',
							'シャウワール',
							'ズル・カイダ',
							'ズル・ヒッジャ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ムハッラム',
							'サフアル',
							'ラビー・ウル・アウワル',
							'ラビー・ウッ・サーニー',
							'ジュマーダル・アウワル',
							'ジュマーダッサーニー',
							'ラジャブ',
							'シャアバーン',
							'ラマダーン',
							'シャウワール',
							'ズル・カイダ',
							'ズル・ヒッジャ'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ファルヴァルディーン',
							'オルディーベヘシュト',
							'ホルダード',
							'ティール',
							'モルダード',
							'シャハリーヴァル',
							'メフル',
							'アーバーン',
							'アーザル',
							'デイ',
							'バフマン',
							'エスファンド'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ファルヴァルディーン',
							'オルディーベヘシュト',
							'ホルダード',
							'ティール',
							'モルダード',
							'シャハリーヴァル',
							'メフル',
							'アーバーン',
							'アーザル',
							'デイ',
							'バフマン',
							'エスファンド'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ファルヴァルディーン',
							'オルディーベヘシュト',
							'ホルダード',
							'ティール',
							'モルダード',
							'シャハリーヴァル',
							'メフル',
							'アーバーン',
							'アーザル',
							'デイ',
							'バフマン',
							'エスファンド'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ファルヴァルディーン',
							'オルディーベヘシュト',
							'ホルダード',
							'ティール',
							'モルダード',
							'シャハリーヴァル',
							'メフル',
							'アーバーン',
							'アーザル',
							'デイ',
							'バフマン',
							'エスファンド'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => '月',
						tue => '火',
						wed => '水',
						thu => '木',
						fri => '金',
						sat => '土',
						sun => '日'
					},
					narrow => {
						mon => '月',
						tue => '火',
						wed => '水',
						thu => '木',
						fri => '金',
						sat => '土',
						sun => '日'
					},
					short => {
						mon => '月',
						tue => '火',
						wed => '水',
						thu => '木',
						fri => '金',
						sat => '土',
						sun => '日'
					},
					wide => {
						mon => '月曜日',
						tue => '火曜日',
						wed => '水曜日',
						thu => '木曜日',
						fri => '金曜日',
						sat => '土曜日',
						sun => '日曜日'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => '月',
						tue => '火',
						wed => '水',
						thu => '木',
						fri => '金',
						sat => '土',
						sun => '日'
					},
					narrow => {
						mon => '月',
						tue => '火',
						wed => '水',
						thu => '木',
						fri => '金',
						sat => '土',
						sun => '日'
					},
					short => {
						mon => '月',
						tue => '火',
						wed => '水',
						thu => '木',
						fri => '金',
						sat => '土',
						sun => '日'
					},
					wide => {
						mon => '月曜日',
						tue => '火曜日',
						wed => '水曜日',
						thu => '木曜日',
						fri => '金曜日',
						sat => '土曜日',
						sun => '日曜日'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '第1四半期',
						1 => '第2四半期',
						2 => '第3四半期',
						3 => '第4四半期'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '第1四半期',
						1 => '第2四半期',
						2 => '第3四半期',
						3 => '第4四半期'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'chinese') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'dangi') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'japanese') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'roc') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2300;
					return 'night2' if $time >= 2300;
					return 'night2' if $time < 400;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
	my ($orig, $self) = @_;
	return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{昼},
					'am' => q{午前},
					'evening1' => q{夕方},
					'midnight' => q{真夜中},
					'morning1' => q{朝},
					'night1' => q{夜},
					'night2' => q{夜中},
					'noon' => q{正午},
					'pm' => q{午後},
				},
				'narrow' => {
					'afternoon1' => q{昼},
					'am' => q{午前},
					'evening1' => q{夕方},
					'midnight' => q{真夜中},
					'morning1' => q{朝},
					'night1' => q{夜},
					'night2' => q{夜中},
					'noon' => q{正午},
					'pm' => q{午後},
				},
				'wide' => {
					'afternoon1' => q{昼},
					'am' => q{午前},
					'evening1' => q{夕方},
					'midnight' => q{真夜中},
					'morning1' => q{朝},
					'night1' => q{夜},
					'night2' => q{夜中},
					'noon' => q{正午},
					'pm' => q{午後},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{昼},
					'am' => q{午前},
					'evening1' => q{夕方},
					'midnight' => q{真夜中},
					'morning1' => q{朝},
					'night1' => q{夜},
					'night2' => q{夜中},
					'noon' => q{正午},
					'pm' => q{午後},
				},
				'narrow' => {
					'afternoon1' => q{昼},
					'am' => q{午前},
					'evening1' => q{夕方},
					'midnight' => q{真夜中},
					'morning1' => q{朝},
					'night1' => q{夜},
					'night2' => q{夜中},
					'noon' => q{正午},
					'pm' => q{午後},
				},
				'wide' => {
					'afternoon1' => q{昼},
					'am' => q{午前},
					'evening1' => q{夕方},
					'midnight' => q{真夜中},
					'morning1' => q{朝},
					'night1' => q{夜},
					'night2' => q{夜中},
					'noon' => q{正午},
					'pm' => q{午後},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'BE'
			},
			narrow => {
				'0' => 'BE'
			},
			wide => {
				'0' => '仏暦'
			},
		},
		'chinese' => {
		},
		'coptic' => {
			abbreviated => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
			narrow => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
			wide => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
		},
		'dangi' => {
		},
		'ethiopic' => {
			abbreviated => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
			narrow => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
			wide => {
				'0' => 'ERA0',
				'1' => 'ERA1'
			},
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => '紀元前',
				'1' => '西暦'
			},
			narrow => {
				'0' => 'BC',
				'1' => 'AD'
			},
			wide => {
				'0' => '紀元前',
				'1' => '西暦'
			},
		},
		'hebrew' => {
			abbreviated => {
				'0' => 'AM'
			},
			narrow => {
				'0' => 'AM'
			},
			wide => {
				'0' => 'AM'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'サカ'
			},
			narrow => {
				'0' => 'サカ'
			},
			wide => {
				'0' => 'サカ'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'AH'
			},
			narrow => {
				'0' => 'AH'
			},
			wide => {
				'0' => 'AH'
			},
		},
		'japanese' => {
			abbreviated => {
				'0' => '大化',
				'1' => '白雉',
				'2' => '白鳳',
				'3' => '朱鳥',
				'4' => '大宝',
				'5' => '慶雲',
				'6' => '和銅',
				'7' => '霊亀',
				'8' => '養老',
				'9' => '神亀',
				'10' => '天平',
				'11' => '天平感宝',
				'12' => '天平勝宝',
				'13' => '天平宝字',
				'14' => '天平神護',
				'15' => '神護景雲',
				'16' => '宝亀',
				'17' => '天応',
				'18' => '延暦',
				'19' => '大同',
				'20' => '弘仁',
				'21' => '天長',
				'22' => '承和',
				'23' => '嘉祥',
				'24' => '仁寿',
				'25' => '斉衡',
				'26' => '天安',
				'27' => '貞観',
				'28' => '元慶',
				'29' => '仁和',
				'30' => '寛平',
				'31' => '昌泰',
				'32' => '延喜',
				'33' => '延長',
				'34' => '承平',
				'35' => '天慶',
				'36' => '天暦',
				'37' => '天徳',
				'38' => '応和',
				'39' => '康保',
				'40' => '安和',
				'41' => '天禄',
				'42' => '天延',
				'43' => '貞元',
				'44' => '天元',
				'45' => '永観',
				'46' => '寛和',
				'47' => '永延',
				'48' => '永祚',
				'49' => '正暦',
				'50' => '長徳',
				'51' => '長保',
				'52' => '寛弘',
				'53' => '長和',
				'54' => '寛仁',
				'55' => '治安',
				'56' => '万寿',
				'57' => '長元',
				'58' => '長暦',
				'59' => '長久',
				'60' => '寛徳',
				'61' => '永承',
				'62' => '天喜',
				'63' => '康平',
				'64' => '治暦',
				'65' => '延久',
				'66' => '承保',
				'67' => '承暦',
				'68' => '永保',
				'69' => '応徳',
				'70' => '寛治',
				'71' => '嘉保',
				'72' => '永長',
				'73' => '承徳',
				'74' => '康和',
				'75' => '長治',
				'76' => '嘉承',
				'77' => '天仁',
				'78' => '天永',
				'79' => '永久',
				'80' => '元永',
				'81' => '保安',
				'82' => '天治',
				'83' => '大治',
				'84' => '天承',
				'85' => '長承',
				'86' => '保延',
				'87' => '永治',
				'88' => '康治',
				'89' => '天養',
				'90' => '久安',
				'91' => '仁平',
				'92' => '久寿',
				'93' => '保元',
				'94' => '平治',
				'95' => '永暦',
				'96' => '応保',
				'97' => '長寛',
				'98' => '永万',
				'99' => '仁安',
				'100' => '嘉応',
				'101' => '承安',
				'102' => '安元',
				'103' => '治承',
				'104' => '養和',
				'105' => '寿永',
				'106' => '元暦',
				'107' => '文治',
				'108' => '建久',
				'109' => '正治',
				'110' => '建仁',
				'111' => '元久',
				'112' => '建永',
				'113' => '承元',
				'114' => '建暦',
				'115' => '建保',
				'116' => '承久',
				'117' => '貞応',
				'118' => '元仁',
				'119' => '嘉禄',
				'120' => '安貞',
				'121' => '寛喜',
				'122' => '貞永',
				'123' => '天福',
				'124' => '文暦',
				'125' => '嘉禎',
				'126' => '暦仁',
				'127' => '延応',
				'128' => '仁治',
				'129' => '寛元',
				'130' => '宝治',
				'131' => '建長',
				'132' => '康元',
				'133' => '正嘉',
				'134' => '正元',
				'135' => '文応',
				'136' => '弘長',
				'137' => '文永',
				'138' => '建治',
				'139' => '弘安',
				'140' => '正応',
				'141' => '永仁',
				'142' => '正安',
				'143' => '乾元',
				'144' => '嘉元',
				'145' => '徳治',
				'146' => '延慶',
				'147' => '応長',
				'148' => '正和',
				'149' => '文保',
				'150' => '元応',
				'151' => '元亨',
				'152' => '正中',
				'153' => '嘉暦',
				'154' => '元徳',
				'155' => '元弘',
				'156' => '建武',
				'157' => '延元',
				'158' => '興国',
				'159' => '正平',
				'160' => '建徳',
				'161' => '文中',
				'162' => '天授',
				'163' => '康暦',
				'164' => '弘和',
				'165' => '元中',
				'166' => '至徳',
				'167' => '嘉慶',
				'168' => '康応',
				'169' => '明徳',
				'170' => '応永',
				'171' => '正長',
				'172' => '永享',
				'173' => '嘉吉',
				'174' => '文安',
				'175' => '宝徳',
				'176' => '享徳',
				'177' => '康正',
				'178' => '長禄',
				'179' => '寛正',
				'180' => '文正',
				'181' => '応仁',
				'182' => '文明',
				'183' => '長享',
				'184' => '延徳',
				'185' => '明応',
				'186' => '文亀',
				'187' => '永正',
				'188' => '大永',
				'189' => '享禄',
				'190' => '天文',
				'191' => '弘治',
				'192' => '永禄',
				'193' => '元亀',
				'194' => '天正',
				'195' => '文禄',
				'196' => '慶長',
				'197' => '元和',
				'198' => '寛永',
				'199' => '正保',
				'200' => '慶安',
				'201' => '承応',
				'202' => '明暦',
				'203' => '万治',
				'204' => '寛文',
				'205' => '延宝',
				'206' => '天和',
				'207' => '貞享',
				'208' => '元禄',
				'209' => '宝永',
				'210' => '正徳',
				'211' => '享保',
				'212' => '元文',
				'213' => '寛保',
				'214' => '延享',
				'215' => '寛延',
				'216' => '宝暦',
				'217' => '明和',
				'218' => '安永',
				'219' => '天明',
				'220' => '寛政',
				'221' => '享和',
				'222' => '文化',
				'223' => '文政',
				'224' => '天保',
				'225' => '弘化',
				'226' => '嘉永',
				'227' => '安政',
				'228' => '万延',
				'229' => '文久',
				'230' => '元治',
				'231' => '慶応',
				'232' => '明治',
				'233' => '大正',
				'234' => '昭和',
				'235' => '平成',
				'236' => 'ＱＱ'
			},
			narrow => {
				'0' => '大化',
				'1' => '白雉',
				'2' => '白鳳',
				'3' => '朱鳥',
				'4' => '大宝',
				'5' => '慶雲',
				'6' => '和銅',
				'7' => '霊亀',
				'8' => '養老',
				'9' => '神亀',
				'10' => '天平',
				'11' => '天平感宝',
				'12' => '天平勝宝',
				'13' => '天平宝字',
				'14' => '天平神護',
				'15' => '神護景雲',
				'16' => '宝亀',
				'17' => '天応',
				'18' => '延暦',
				'19' => '大同',
				'20' => '弘仁',
				'21' => '天長',
				'22' => '承和',
				'23' => '嘉祥',
				'24' => '仁寿',
				'25' => '斉衡',
				'26' => '天安',
				'27' => '貞観',
				'28' => '元慶',
				'29' => '仁和',
				'30' => '寛平',
				'31' => '昌泰',
				'32' => '延喜',
				'33' => '延長',
				'34' => '承平',
				'35' => '天慶',
				'36' => '天暦',
				'37' => '天徳',
				'38' => '応和',
				'39' => '康保',
				'40' => '安和',
				'41' => '天禄',
				'42' => '天延',
				'43' => '貞元',
				'44' => '天元',
				'45' => '永観',
				'46' => '寛和',
				'47' => '永延',
				'48' => '永祚',
				'49' => '正暦',
				'50' => '長徳',
				'51' => '長保',
				'52' => '寛弘',
				'53' => '長和',
				'54' => '寛仁',
				'55' => '治安',
				'56' => '万寿',
				'57' => '長元',
				'58' => '長暦',
				'59' => '長久',
				'60' => '寛徳',
				'61' => '永承',
				'62' => '天喜',
				'63' => '康平',
				'64' => '治暦',
				'65' => '延久',
				'66' => '承保',
				'67' => '承暦',
				'68' => '永保',
				'69' => '応徳',
				'70' => '寛治',
				'71' => '嘉保',
				'72' => '永長',
				'73' => '承徳',
				'74' => '康和',
				'75' => '長治',
				'76' => '嘉承',
				'77' => '天仁',
				'78' => '天永',
				'79' => '永久',
				'80' => '元永',
				'81' => '保安',
				'82' => '天治',
				'83' => '大治',
				'84' => '天承',
				'85' => '長承',
				'86' => '保延',
				'87' => '永治',
				'88' => '康治',
				'89' => '天養',
				'90' => '久安',
				'91' => '仁平',
				'92' => '久寿',
				'93' => '保元',
				'94' => '平治',
				'95' => '永暦',
				'96' => '応保',
				'97' => '長寛',
				'98' => '永万',
				'99' => '仁安',
				'100' => '嘉応',
				'101' => '承安',
				'102' => '安元',
				'103' => '治承',
				'104' => '養和',
				'105' => '寿永',
				'106' => '元暦',
				'107' => '文治',
				'108' => '建久',
				'109' => '正治',
				'110' => '建仁',
				'111' => '元久',
				'112' => '建永',
				'113' => '承元',
				'114' => '建暦',
				'115' => '建保',
				'116' => '承久',
				'117' => '貞応',
				'118' => '元仁',
				'119' => '嘉禄',
				'120' => '安貞',
				'121' => '寛喜',
				'122' => '貞永',
				'123' => '天福',
				'124' => '文暦',
				'125' => '嘉禎',
				'126' => '暦仁',
				'127' => '延応',
				'128' => '仁治',
				'129' => '寛元',
				'130' => '宝治',
				'131' => '建長',
				'132' => '康元',
				'133' => '正嘉',
				'134' => '正元',
				'135' => '文応',
				'136' => '弘長',
				'137' => '文永',
				'138' => '建治',
				'139' => '弘安',
				'140' => '正応',
				'141' => '永仁',
				'142' => '正安',
				'143' => '乾元',
				'144' => '嘉元',
				'145' => '徳治',
				'146' => '延慶',
				'147' => '応長',
				'148' => '正和',
				'149' => '文保',
				'150' => '元応',
				'151' => '元亨',
				'152' => '正中',
				'153' => '嘉暦',
				'154' => '元徳',
				'155' => '元弘',
				'156' => '建武',
				'157' => '延元',
				'158' => '興国',
				'159' => '正平',
				'160' => '建徳',
				'161' => '文中',
				'162' => '天授',
				'163' => '康暦',
				'164' => '弘和',
				'165' => '元中',
				'166' => '至徳',
				'167' => '嘉慶',
				'168' => '康応',
				'169' => '明徳',
				'170' => '応永',
				'171' => '正長',
				'172' => '永享',
				'173' => '嘉吉',
				'174' => '文安',
				'175' => '宝徳',
				'176' => '享徳',
				'177' => '康正',
				'178' => '長禄',
				'179' => '寛正',
				'180' => '文正',
				'181' => '応仁',
				'182' => '文明',
				'183' => '長享',
				'184' => '延徳',
				'185' => '明応',
				'186' => '文亀',
				'187' => '永正',
				'188' => '大永',
				'189' => '享禄',
				'190' => '天文',
				'191' => '弘治',
				'192' => '永禄',
				'193' => '元亀',
				'194' => '天正',
				'195' => '文禄',
				'196' => '慶長',
				'197' => '元和',
				'198' => '寛永',
				'199' => '正保',
				'200' => '慶安',
				'201' => '承応',
				'202' => '明暦',
				'203' => '万治',
				'204' => '寛文',
				'205' => '延宝',
				'206' => '天和',
				'207' => '貞享',
				'208' => '元禄',
				'209' => '宝永',
				'210' => '正徳',
				'211' => '享保',
				'212' => '元文',
				'213' => '寛保',
				'214' => '延享',
				'215' => '寛延',
				'216' => '宝暦',
				'217' => '明和',
				'218' => '安永',
				'219' => '天明',
				'220' => '寛政',
				'221' => '享和',
				'222' => '文化',
				'223' => '文政',
				'224' => '天保',
				'225' => '弘化',
				'226' => '嘉永',
				'227' => '安政',
				'228' => '万延',
				'229' => '文久',
				'230' => '元治',
				'231' => '慶応',
				'232' => 'M',
				'233' => 'T',
				'234' => 'S',
				'235' => 'H',
				'236' => 'Q'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'AP'
			},
			narrow => {
				'0' => 'AP'
			},
			wide => {
				'0' => 'AP'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => '民国前',
				'1' => '民国'
			},
			narrow => {
				'0' => '民国前',
				'1' => '民国'
			},
			wide => {
				'0' => '民国前'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			'full' => q{GGGGy年M月d日EEEE},
			'long' => q{GGGGy年M月d日},
			'medium' => q{Gy/MM/dd},
			'short' => q{Gy/MM/dd},
		},
		'chinese' => {
			'full' => q{U年MMMd日EEEE},
			'long' => q{U年MMMd日},
			'medium' => q{U年MMMd日},
			'short' => q{U-M-d},
		},
		'coptic' => {
		},
		'dangi' => {
			'full' => q{U年MMMd日EEEE},
			'long' => q{U年MMMd日},
			'medium' => q{U年MMMd日},
			'short' => q{U-M-d},
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{Gy年M月d日(EEEE)},
			'long' => q{Gy年M月d日},
			'medium' => q{Gy/MM/dd},
			'short' => q{Gy/M/d},
		},
		'gregorian' => {
			'full' => q{y年M月d日EEEE},
			'long' => q{y年M月d日},
			'medium' => q{y/MM/dd},
			'short' => q{y/MM/dd},
		},
		'hebrew' => {
			'full' => q{Gy年M月d日EEEE},
			'long' => q{Gy年M月d日},
			'medium' => q{Gy/MM/dd},
			'short' => q{Gy/MM/dd},
		},
		'indian' => {
		},
		'islamic' => {
			'full' => q{Gy年M月d日EEEE},
			'long' => q{Gy年M月d日},
			'medium' => q{Gy/MM/dd},
			'short' => q{Gy/MM/dd},
		},
		'japanese' => {
			'full' => q{Gy年M月d日EEEE},
			'long' => q{Gy年M月d日},
			'medium' => q{Gy年M月d日},
			'short' => q{GGGGGy/M/d},
		},
		'persian' => {
		},
		'roc' => {
			'full' => q{Gy年M月d日EEEE},
			'long' => q{Gy年M月d日},
			'medium' => q{Gy/MM/dd},
			'short' => q{Gy/MM/dd},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'dangi' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{H時mm分ss秒 zzzz},
			'long' => q{H:mm:ss z},
			'medium' => q{H:mm:ss},
			'short' => q{H:mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'dangi' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			EEEEd => q{d日EEEE},
			Ed => q{d日(E)},
			Gy => q{GGGGy年},
			GyMMM => q{GGGGy年M月},
			GyMMMEEEEd => q{GGGGy年M月d日EEEE},
			GyMMMEd => q{GGGGy年M月d日(E)},
			GyMMMd => q{GGGGy年M月d日},
			GyMd => q{GGGGy年M月d日},
			H => q{H時},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			M => q{M月},
			MEEEEd => q{M/dEEEE},
			MEd => q{M/d(E)},
			MMM => q{M月},
			MMMEEEEd => q{M月d日EEEE},
			MMMEd => q{M月d日(E)},
			MMMMd => q{M月d日},
			MMMd => q{M月d日},
			Md => q{M/d},
			d => q{d日},
			h => q{aK時},
			hm => q{aK:mm},
			hms => q{aK:mm:ss},
			ms => q{mm:ss},
			y => q{GGGGy年},
			yyyy => q{GGGGy年},
			yyyyM => q{GGGGy年M月},
			yyyyMEEEEd => q{GGGGy年M/dEEEE},
			yyyyMEd => q{GGGGy年M/d(E)},
			yyyyMM => q{Gy/MM},
			yyyyMMM => q{GGGGy年M月},
			yyyyMMMEEEEd => q{GGGGy年M月d日EEEE},
			yyyyMMMEd => q{GGGGy年M月d日(E)},
			yyyyMMMM => q{GGGGy年M月},
			yyyyMMMd => q{GGGGy年M月d日},
			yyyyMd => q{Gy/M/d},
		},
		'chinese' => {
			Bh => q{BK時},
			Bhm => q{BK:mm},
			Bhms => q{BK:mm:ss},
			E => q{ccc},
			EBhm => q{BK:mm (E)},
			EBhms => q{BK:mm:ss (E)},
			EEEEd => q{d日EEEE},
			Ed => q{d日(E)},
			Gy => q{U年},
			GyMMM => q{U年MMM},
			GyMMMEEEEd => q{U年MMMd日EEEE},
			GyMMMEd => q{U年MMMd日(E)},
			GyMMMd => q{U年MMMd日},
			H => q{H時},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			M => q{MMM},
			MEEEEd => q{M/dEEEE},
			MEd => q{M/d(E)},
			MMM => q{LLL},
			MMMEEEEd => q{MMMd日EEEE},
			MMMEd => q{MMMd日(E)},
			MMMMd => q{MMMMd日},
			MMMd => q{MMMd日},
			Md => q{M/d},
			UM => q{U年M月},
			UMMM => q{U年MMM},
			UMMMd => q{U年MMMd日},
			UMd => q{U年M月d日},
			d => q{d日},
			h => q{aK時},
			hm => q{aK:mm},
			hms => q{aK:mm:ss},
			ms => q{mm:ss},
			y => q{U年},
			yMd => q{U年M月d日},
			yyyy => q{U年},
			yyyyM => q{U年M月},
			yyyyMEEEEd => q{U年M月d日EEEE},
			yyyyMEd => q{U年M月d日(E)},
			yyyyMMM => q{U年MMM},
			yyyyMMMEEEEd => q{U年MMMd日EEEE},
			yyyyMMMEd => q{U年MMMd日(E)},
			yyyyMMMM => q{U年MMMM},
			yyyyMMMd => q{U年MMMd日},
			yyyyMd => q{U年M月d日},
			yyyyQQQ => q{U年QQQ},
			yyyyQQQQ => q{U年QQQQ},
		},
		'generic' => {
			Bh => q{BK時},
			Bhm => q{BK:mm},
			Bhms => q{BK:mm:ss},
			E => q{ccc},
			EBhm => q{BK:mm (E)},
			EBhms => q{BK:mm:ss (E)},
			EEEEd => q{d日(EEEE)},
			EHm => q{H:mm (E)},
			EHms => q{H:mm:ss (E)},
			Ed => q{d日(E)},
			Ehm => q{aK:mm (E)},
			Ehms => q{aK:mm:ss (E)},
			Gy => q{Gy年},
			GyMMM => q{Gy年M月},
			GyMMMEEEEd => q{Gy年M月d日(EEEE)},
			GyMMMEd => q{Gy年M月d日(E)},
			GyMMMd => q{Gy年M月d日},
			H => q{H時},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			M => q{M月},
			MEEEEd => q{M/d(EEEE)},
			MEd => q{M/d(E)},
			MMM => q{M月},
			MMMEEEEd => q{M月d日(EEEE)},
			MMMEd => q{M月d日(E)},
			MMMMd => q{M月d日},
			MMMd => q{M月d日},
			Md => q{M/d},
			d => q{d日},
			h => q{aK時},
			hm => q{aK:mm},
			hms => q{aK:mm:ss},
			ms => q{mm:ss},
			y => q{Gy年},
			yyyy => q{Gy年},
			yyyyM => q{Gy/M},
			yyyyMEEEEd => q{Gy/M/d(EEEE)},
			yyyyMEd => q{Gy/M/d(E)},
			yyyyMMM => q{Gy年M月},
			yyyyMMMEEEEd => q{Gy年M月d日(EEEE)},
			yyyyMMMEd => q{Gy年M月d日(E)},
			yyyyMMMM => q{Gy年M月},
			yyyyMMMd => q{Gy年M月d日},
			yyyyMd => q{Gy/M/d},
			yyyyQQQ => q{Gy/QQQ},
			yyyyQQQQ => q{Gy年QQQQ},
		},
		'gregorian' => {
			Bh => q{BK時},
			Bhm => q{BK:mm},
			Bhms => q{BK:mm:ss},
			E => q{ccc},
			EBhm => q{BK:mm (E)},
			EBhms => q{BK:mm:ss (E)},
			EEEEd => q{d日EEEE},
			EHm => q{H:mm (E)},
			EHms => q{H:mm:ss (E)},
			Ed => q{d日(E)},
			Ehm => q{aK:mm (E)},
			Ehms => q{aK:mm:ss (E)},
			Gy => q{Gy年},
			GyMMM => q{Gy年M月},
			GyMMMEEEEd => q{Gy年M月d日EEEE},
			GyMMMEd => q{Gy年M月d日(E)},
			GyMMMd => q{Gy年M月d日},
			H => q{H時},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			Hmsv => q{H:mm:ss v},
			Hmv => q{H:mm v},
			M => q{M月},
			MEEEEd => q{M/dEEEE},
			MEd => q{M/d(E)},
			MMM => q{M月},
			MMMEEEEd => q{M月d日EEEE},
			MMMEd => q{M月d日(E)},
			MMMMW => q{M月第W週},
			MMMMd => q{M月d日},
			MMMd => q{M月d日},
			Md => q{M/d},
			d => q{d日},
			h => q{aK時},
			hm => q{aK:mm},
			hms => q{aK:mm:ss},
			hmsv => q{aK:mm:ss v},
			hmv => q{aK:mm v},
			ms => q{mm:ss},
			y => q{y年},
			yM => q{y/M},
			yMEEEEd => q{y/M/dEEEE},
			yMEd => q{y/M/d(E)},
			yMM => q{y/MM},
			yMMM => q{y年M月},
			yMMMEEEEd => q{y年M月d日EEEE},
			yMMMEd => q{y年M月d日(E)},
			yMMMM => q{y年M月},
			yMMMd => q{y年M月d日},
			yMd => q{y/M/d},
			yQQQ => q{y/QQQ},
			yQQQQ => q{y年QQQQ},
			yw => q{Y年第w週},
		},
		'islamic' => {
			M => q{M月},
			MEd => q{M/d(E)},
			MMM => q{M月},
			MMMEd => q{M月d日(E)},
			MMMMd => q{M月d日},
			MMMd => q{M月d日},
			Md => q{M/d},
			d => q{d日},
			y => q{Gy年},
		},
		'japanese' => {
			E => q{ccc},
			EEEEd => q{d日EEEE},
			Ed => q{d日(E)},
			Gy => q{Gy年},
			GyMMM => q{Gy年M月},
			GyMMMEEEEd => q{Gy年M月d日EEEE},
			GyMMMEd => q{Gy年M月d日(E)},
			GyMMMd => q{Gy年M月d日},
			H => q{H時},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			M => q{M月},
			MEEEEd => q{M/dEEEE},
			MEd => q{M/d(E)},
			MMM => q{M月},
			MMMEEEEd => q{M月d日EEEE},
			MMMEd => q{M月d日(E)},
			MMMMd => q{M月d日},
			MMMd => q{M月d日},
			Md => q{M/d},
			d => q{d日},
			h => q{aK時},
			hm => q{aK:mm},
			hms => q{aK:mm:ss},
			ms => q{mm:ss},
			y => q{Gy年},
			yyyy => q{Gy年},
			yyyyM => q{Gy/M},
			yyyyMEEEEd => q{Gy/M/dEEEE},
			yyyyMEd => q{Gy/M/d(E)},
			yyyyMM => q{Gy/MM},
			yyyyMMM => q{Gy年M月},
			yyyyMMMEEEEd => q{Gy年M月d日EEEE},
			yyyyMMMEd => q{Gy年M月d日(E)},
			yyyyMMMM => q{Gy年M月},
			yyyyMMMd => q{Gy年M月d日},
			yyyyMd => q{Gy/M/d},
			yyyyQQQ => q{Gy/QQQ},
			yyyyQQQQ => q{Gy年QQQQ},
		},
		'roc' => {
			M => q{M月},
			MEd => q{M/d(E)},
			MMM => q{M月},
			MMMEd => q{M月d日(E)},
			MMMMd => q{M月d日},
			MMMd => q{M月d日},
			Md => q{M/d},
			d => q{d日},
			y => q{Gy年},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
			H => {
				H => q{H時～H時},
			},
			Hm => {
				H => q{H時mm分～H時mm分},
				m => q{H時mm分～H時mm分},
			},
			Hmv => {
				H => q{H時mm分～H時mm分(v)},
				m => q{H時mm分～H時mm分(v)},
			},
			Hv => {
				H => q{H時～H時(v)},
			},
			M => {
				M => q{M月～M月},
			},
			MEd => {
				M => q{MM/dd(E)～MM/dd(E)},
				d => q{MM/dd(E)～MM/dd(E)},
			},
			MMM => {
				M => q{MMM～MMM},
			},
			MMMEd => {
				M => q{MMMd日(E)～MMMd日(E)},
				d => q{MMMd日(E)～d日(E)},
			},
			MMMM => {
				M => q{MMMM～MMMM},
			},
			MMMd => {
				M => q{MMMd日～MMMd日},
				d => q{MMMd日～d日},
			},
			Md => {
				M => q{MM/dd～MM/dd},
				d => q{MM/dd～MM/dd},
			},
			d => {
				d => q{d日～d日},
			},
			fallback => '{0}～{1}',
			h => {
				a => q{aK時～aK時},
				h => q{aK時～K時},
			},
			hm => {
				a => q{aK時mm分～aK時mm分},
				h => q{aK時mm分～K時mm分},
				m => q{aK時mm分～K時mm分},
			},
			hmv => {
				a => q{aK時mm分～aK時mm分(v)},
				h => q{aK時mm分～K時mm分(v)},
				m => q{aK時mm分～K時mm分(v)},
			},
			hv => {
				a => q{aK時～aK時(v)},
				h => q{aK時～K時(v)},
			},
			y => {
				y => q{U年～U年},
			},
			yM => {
				M => q{U/MM～U/MM},
				y => q{U/MM～U/MM},
			},
			yMEd => {
				M => q{U/MM/dd(E)～U/MM/dd(E)},
				d => q{U/MM/dd(E)～U/MM/dd(E)},
				y => q{U/MM/dd(E)～U/MM/dd(E)},
			},
			yMMM => {
				M => q{U年MMM～MMM},
				y => q{U年MMM～U年MMM},
			},
			yMMMEd => {
				M => q{U年MMMd日(E)～MMMd日(E)},
				d => q{U年MMMd日(E)～d日(E)},
				y => q{U年MMMd日(E)～U年MMMd日(E)},
			},
			yMMMM => {
				M => q{U年MMM～MMM},
				y => q{U年MMM～U年MMM},
			},
			yMMMd => {
				M => q{U年MMMd日～MMMd日},
				d => q{U年MMMd日～d日},
				y => q{U年MMMd日～U年MMMd日},
			},
			yMd => {
				M => q{U/MM/dd～U/MM/dd},
				d => q{U/MM/dd～U/MM/dd},
				y => q{U/MM/dd～U/MM/dd},
			},
		},
		'generic' => {
			Gy => {
				G => q{Gy年～Gy年},
				y => q{Gy年～y年},
			},
			GyM => {
				G => q{Gy/MM～Gy/MM},
				M => q{Gy/MM～y/MM},
				y => q{Gy/MM～y/MM},
			},
			GyMEd => {
				G => q{Gy/MM/dd(E)～Gy/MM/dd(E)},
				M => q{Gy/MM/dd(E)～y/MM/dd(E)},
				d => q{Gy/MM/dd(E)～y/MM/dd(E)},
				y => q{Gy/MM/dd(E)～y/MM/dd(E)},
			},
			GyMMM => {
				G => q{Gy年M月～Gy年M月},
				M => q{Gy年M月～M月},
				y => q{Gy年M月～y年M月},
			},
			GyMMMEd => {
				G => q{Gy年M月d日(E)～Gy年M月d日(E)},
				M => q{Gy年M月d日(E)～M月d日(E)},
				d => q{Gy年M月d日(E)～d日(E)},
				y => q{Gy年M月d日(E)～y年M月d日(E)},
			},
			GyMMMd => {
				G => q{Gy年M月d日～Gy年M月d日},
				M => q{Gy年M月d日～M月d日},
				d => q{Gy年M月d日～d日},
				y => q{Gy年M月d日～y年M月d日},
			},
			GyMd => {
				G => q{Gy/MM/dd～Gy/MM/dd},
				M => q{Gy/MM/dd～y/MM/dd},
				d => q{Gy/MM/dd～y/MM/dd},
				y => q{Gy/MM/dd～y/MM/dd},
			},
			H => {
				H => q{H時～H時},
			},
			Hm => {
				H => q{H時mm分～H時mm分},
				m => q{H時mm分～H時mm分},
			},
			Hmv => {
				H => q{H時mm分～H時mm分(v)},
				m => q{H時mm分～H時mm分(v)},
			},
			Hv => {
				H => q{H時～H時(v)},
			},
			M => {
				M => q{M月～M月},
			},
			MEd => {
				M => q{MM/dd(E)～MM/dd(E)},
				d => q{MM/dd(E)～MM/dd(E)},
			},
			MMM => {
				M => q{M月～M月},
			},
			MMMEd => {
				M => q{M月d日(E)～M月d日(E)},
				d => q{M月d日(E)～d日(E)},
			},
			MMMM => {
				M => q{M月～M月},
			},
			MMMd => {
				M => q{M月d日～M月d日},
				d => q{M月d日～d日},
			},
			Md => {
				M => q{MM/dd～MM/dd},
				d => q{MM/dd～MM/dd},
			},
			d => {
				d => q{d日～d日},
			},
			fallback => '{0}～{1}',
			h => {
				a => q{aK時～aK時},
				h => q{aK時～K時},
			},
			hm => {
				a => q{aK時mm分～aK時mm分},
				h => q{aK時mm分～K時mm分},
				m => q{aK時mm分～K時mm分},
			},
			hmv => {
				a => q{aK時mm分～aK時mm分(v)},
				h => q{aK時mm分～K時mm分(v)},
				m => q{aK時mm分～K時mm分(v)},
			},
			hv => {
				a => q{aK時～aK時(v)},
				h => q{aK時～K時(v)},
			},
			y => {
				y => q{Gy年～y年},
			},
			yM => {
				M => q{Gy/MM～y/MM},
				y => q{Gy/MM～y/MM},
			},
			yMEd => {
				M => q{Gy/MM/dd(E)～y/MM/dd(E)},
				d => q{Gy/MM/dd(E)～y/MM/dd(E)},
				y => q{Gy/MM/dd(E)～y/MM/dd(E)},
			},
			yMMM => {
				M => q{Gy年M月～M月},
				y => q{Gy年M月～y年M月},
			},
			yMMMEd => {
				M => q{Gy年M月d日(E)～M月d日(E)},
				d => q{Gy年M月d日(E)～d日(E)},
				y => q{Gy年M月d日(E)～y年M月d日(E)},
			},
			yMMMM => {
				M => q{Gy年M月～M月},
				y => q{Gy年M月～y年M月},
			},
			yMMMd => {
				M => q{Gy年M月d日～M月d日},
				d => q{Gy年M月d日～d日},
				y => q{Gy年M月d日～y年M月d日},
			},
			yMd => {
				M => q{Gy/MM/dd～y/MM/dd},
				d => q{Gy/MM/dd～y/MM/dd},
				y => q{Gy/MM/dd～y/MM/dd},
			},
		},
		'gregorian' => {
			Gy => {
				G => q{Gy年～Gy年},
				y => q{Gy年～y年},
			},
			GyM => {
				G => q{Gy/MM～Gy/MM},
				M => q{Gy/MM～y/MM},
				y => q{Gy/MM～y/MM},
			},
			GyMEd => {
				G => q{Gy/MM/dd(E)～Gy/MM/dd(E)},
				M => q{Gy/MM/dd(E)～y/MM/dd(E)},
				d => q{Gy/MM/dd(E)～y/MM/dd(E)},
				y => q{Gy/MM/dd(E)～y/MM/dd(E)},
			},
			GyMMM => {
				G => q{Gy年M月～Gy年M月},
				M => q{Gy年M月～M月},
				y => q{Gy年M月～y年M月},
			},
			GyMMMEd => {
				G => q{Gy年M月d日(E)～Gy年M月d日(E)},
				M => q{Gy年M月d日(E)～M月d日(E)},
				d => q{Gy年M月d日(E)～d日(E)},
				y => q{Gy年M月d日(E)～y年M月d日(E)},
			},
			GyMMMd => {
				G => q{Gy年M月d日～Gy年M月d日},
				M => q{Gy年M月d日～M月d日},
				d => q{Gy年M月d日～d日},
				y => q{Gy年M月d日～y年M月d日},
			},
			GyMd => {
				G => q{Gy/MM/dd～Gy/MM/dd},
				M => q{Gy/MM/dd～y/MM/dd},
				d => q{Gy/MM/dd～y/MM/dd},
				y => q{Gy/MM/dd～y/MM/dd},
			},
			H => {
				H => q{H時～H時},
			},
			Hm => {
				H => q{H時mm分～H時mm分},
				m => q{H時mm分～H時mm分},
			},
			Hmv => {
				H => q{H時mm分～H時mm分(v)},
				m => q{H時mm分～H時mm分(v)},
			},
			Hv => {
				H => q{H時～H時(v)},
			},
			M => {
				M => q{M月～M月},
			},
			MEd => {
				M => q{MM/dd(E)～MM/dd(E)},
				d => q{MM/dd(E)～MM/dd(E)},
			},
			MMM => {
				M => q{M月～M月},
			},
			MMMEd => {
				M => q{M月d日(E)～M月d日(E)},
				d => q{M月d日(E)～d日(E)},
			},
			MMMM => {
				M => q{M月～M月},
			},
			MMMd => {
				M => q{M月d日～M月d日},
				d => q{M月d日～d日},
			},
			Md => {
				M => q{MM/dd～MM/dd},
				d => q{MM/dd～MM/dd},
			},
			d => {
				d => q{d日～d日},
			},
			fallback => '{0}～{1}',
			h => {
				a => q{aK時～aK時},
				h => q{aK時～K時},
			},
			hm => {
				a => q{aK時mm分～aK時mm分},
				h => q{aK時mm分～K時mm分},
				m => q{aK時mm分～K時mm分},
			},
			hmv => {
				a => q{aK時mm分～aK時mm分(v)},
				h => q{aK時mm分～K時mm分(v)},
				m => q{aK時mm分～K時mm分(v)},
			},
			hv => {
				a => q{aK時～aK時(v)},
				h => q{aK時～K時(v)},
			},
			y => {
				y => q{y年～y年},
			},
			yM => {
				M => q{y/MM～y/MM},
				y => q{y/MM～y/MM},
			},
			yMEd => {
				M => q{y/MM/dd(E)～y/MM/dd(E)},
				d => q{y/MM/dd(E)～y/MM/dd(E)},
				y => q{y/MM/dd(E)～y/MM/dd(E)},
			},
			yMMM => {
				M => q{y年M月～M月},
				y => q{y年M月～y年M月},
			},
			yMMMEd => {
				M => q{y年M月d日(E)～M月d日(E)},
				d => q{y年M月d日(E)～d日(E)},
				y => q{y年M月d日(E)～y年M月d日(E)},
			},
			yMMMM => {
				M => q{y年M月～M月},
				y => q{y年M月～y年M月},
			},
			yMMMd => {
				M => q{y年M月d日～M月d日},
				d => q{y年M月d日～d日},
				y => q{y年M月d日～y年M月d日},
			},
			yMd => {
				M => q{y/MM/dd～y/MM/dd},
				d => q{y/MM/dd～y/MM/dd},
				y => q{y/MM/dd～y/MM/dd},
			},
		},
	} },
);

has 'month_patterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
			'format' => {
				'wide' => {
					'leap' => q{閏{0}},
				},
			},
			'numeric' => {
				'all' => {
					'leap' => q{閏{0}},
				},
			},
			'stand-alone' => {
				'narrow' => {
					'leap' => q{閏{0}},
				},
			},
		},
	} },
);

has 'cyclic_name_sets' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
			'dayParts' => {
				'format' => {
					'abbreviated' => {
						0 => q(子),
						1 => q(丑),
						2 => q(寅),
						3 => q(卯),
						4 => q(辰),
						5 => q(巳),
						6 => q(午),
						7 => q(未),
						8 => q(申),
						9 => q(酉),
						10 => q(戌),
						11 => q(亥),
					},
				},
			},
			'solarTerms' => {
				'format' => {
					'abbreviated' => {
						0 => q(立春),
						1 => q(雨水),
						2 => q(啓蟄),
						3 => q(春分),
						4 => q(清明),
						5 => q(穀雨),
						6 => q(立夏),
						7 => q(小満),
						8 => q(芒種),
						9 => q(夏至),
						10 => q(小暑),
						11 => q(大暑),
						12 => q(立秋),
						13 => q(処暑),
						14 => q(白露),
						15 => q(秋分),
						16 => q(寒露),
						17 => q(霜降),
						18 => q(立冬),
						19 => q(小雪),
						20 => q(大雪),
						21 => q(冬至),
						22 => q(小寒),
						23 => q(大寒),
					},
				},
			},
			'years' => {
				'format' => {
					'abbreviated' => {
						0 => q(甲子),
						1 => q(乙丑),
						2 => q(丙寅),
						3 => q(丁卯),
						4 => q(戊辰),
						5 => q(己巳),
						6 => q(庚午),
						7 => q(辛未),
						8 => q(壬申),
						9 => q(癸酉),
						10 => q(甲戌),
						11 => q(乙亥),
						12 => q(丙子),
						13 => q(丁丑),
						14 => q(戊寅),
						15 => q(己卯),
						16 => q(庚辰),
						17 => q(辛巳),
						18 => q(壬午),
						19 => q(癸未),
						20 => q(甲申),
						21 => q(乙酉),
						22 => q(丙戌),
						23 => q(丁亥),
						24 => q(戊子),
						25 => q(己丑),
						26 => q(庚寅),
						27 => q(辛卯),
						28 => q(壬辰),
						29 => q(癸巳),
						30 => q(甲午),
						31 => q(乙未),
						32 => q(丙申),
						33 => q(丁酉),
						34 => q(戊戌),
						35 => q(己亥),
						36 => q(庚子),
						37 => q(辛丑),
						38 => q(壬寅),
						39 => q(癸卯),
						40 => q(甲辰),
						41 => q(乙巳),
						42 => q(丙午),
						43 => q(丁未),
						44 => q(戊申),
						45 => q(己酉),
						46 => q(庚戌),
						47 => q(辛亥),
						48 => q(壬子),
						49 => q(癸丑),
						50 => q(甲寅),
						51 => q(乙卯),
						52 => q(丙辰),
						53 => q(丁巳),
						54 => q(戊午),
						55 => q(己未),
						56 => q(庚申),
						57 => q(辛酉),
						58 => q(壬戌),
						59 => q(癸亥),
					},
				},
			},
			'zodiacs' => {
				'format' => {
					'abbreviated' => {
						0 => q(鼠),
						1 => q(牛),
						2 => q(虎),
						3 => q(兎),
						4 => q(竜),
						5 => q(蛇),
						6 => q(馬),
						7 => q(羊),
						8 => q(猿),
						9 => q(鶏),
						10 => q(犬),
						11 => q(猪),
					},
				},
			},
		},
		'dangi' => {
			'dayParts' => {
				'format' => {
					'abbreviated' => {
						0 => q(子),
						1 => q(丑),
						2 => q(寅),
						3 => q(卯),
						4 => q(辰),
						5 => q(巳),
						6 => q(午),
						7 => q(未),
						8 => q(申),
						9 => q(酉),
						10 => q(戌),
						11 => q(亥),
					},
				},
			},
			'years' => {
				'format' => {
					'abbreviated' => {
						0 => q(甲子),
						1 => q(乙丑),
						2 => q(丙寅),
						3 => q(丁卯),
						4 => q(戊辰),
						5 => q(己巳),
						6 => q(庚午),
						7 => q(辛未),
						8 => q(壬申),
						9 => q(癸酉),
						10 => q(甲戌),
						11 => q(乙亥),
						12 => q(丙子),
						13 => q(丁丑),
						14 => q(戊寅),
						15 => q(己卯),
						16 => q(庚辰),
						17 => q(辛巳),
						18 => q(壬午),
						19 => q(癸未),
						20 => q(甲申),
						21 => q(乙酉),
						22 => q(丙戌),
						23 => q(丁亥),
						24 => q(戊子),
						25 => q(己丑),
						26 => q(庚寅),
						27 => q(辛卯),
						28 => q(壬辰),
						29 => q(癸巳),
						30 => q(甲午),
						31 => q(乙未),
						32 => q(丙申),
						33 => q(丁酉),
						34 => q(戊戌),
						35 => q(己亥),
						36 => q(庚子),
						37 => q(辛丑),
						38 => q(壬寅),
						39 => q(癸卯),
						40 => q(甲辰),
						41 => q(乙巳),
						42 => q(丙午),
						43 => q(丁未),
						44 => q(戊申),
						45 => q(己酉),
						46 => q(庚戌),
						47 => q(辛亥),
						48 => q(壬子),
						49 => q(癸丑),
						50 => q(甲寅),
						51 => q(乙卯),
						52 => q(丙辰),
						53 => q(丁巳),
						54 => q(戊午),
						55 => q(己未),
						56 => q(庚申),
						57 => q(辛酉),
						58 => q(壬戌),
						59 => q(癸亥),
					},
				},
			},
			'zodiacs' => {
				'format' => {
					'abbreviated' => {
						0 => q(鼠),
						1 => q(牛),
						2 => q(虎),
						3 => q(兎),
						4 => q(竜),
						5 => q(蛇),
						6 => q(馬),
						7 => q(羊),
						8 => q(猿),
						9 => q(鶏),
						10 => q(犬),
						11 => q(猪),
					},
				},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0}時間),
		regionFormat => q({0}夏時間),
		regionFormat => q({0}標準時),
		fallbackFormat => q({1}（{0}）),
		'Acre' => {
			long => {
				'daylight' => q#アクレ夏時間#,
				'generic' => q#アクレ時間#,
				'standard' => q#アクレ標準時#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#アフガニスタン時間#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#アビジャン#,
		},
		'Africa/Accra' => {
			exemplarCity => q#アクラ#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#アジスアベバ#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#アルジェ#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#アスマラ#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#バマコ#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#バンギ#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#バンジュール#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ビサウ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ブランタイヤ#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ブラザビル#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ブジュンブラ#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#カイロ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#カサブランカ#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#セウタ#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#コナクリ#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ダカール#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ダルエスサラーム#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ジブチ#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ドゥアラ#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#アイウン#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#フリータウン#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ハボローネ#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ハラレ#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ヨハネスブルグ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ジュバ#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#カンパラ#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ハルツーム#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#キガリ#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#キンシャサ#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ラゴス#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#リーブルヴィル#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ロメ#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ルアンダ#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ルブンバシ#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ルサカ#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#マラボ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#マプト#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#マセル#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#ムババーネ#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#モガディシオ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#モンロビア#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#ナイロビ#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ンジャメナ#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#ニアメ#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#ヌアクショット#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ワガドゥグー#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#ポルトノボ#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#サントメ#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#トリポリ#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#チュニス#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ウィントフック#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#中央アフリカ時間#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#東アフリカ時間#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#南アフリカ標準時#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#西アフリカ夏時間#,
				'generic' => q#西アフリカ時間#,
				'standard' => q#西アフリカ標準時#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#アラスカ夏時間#,
				'generic' => q#アラスカ時間#,
				'standard' => q#アラスカ標準時#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#アルマトイ夏時間#,
				'generic' => q#アルトマイ時間#,
				'standard' => q#アルトマイ標準時#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#アマゾン夏時間#,
				'generic' => q#アマゾン時間#,
				'standard' => q#アマゾン標準時#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#アダック#,
		},
		'America/Anchorage' => {
			exemplarCity => q#アンカレッジ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#アンギラ#,
		},
		'America/Antigua' => {
			exemplarCity => q#アンティグア#,
		},
		'America/Araguaina' => {
			exemplarCity => q#アラグァイナ#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ラリオハ#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#リオガジェゴス#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#サルタ#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#サンファン#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#サンルイス#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#トゥクマン#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ウシュアイア#,
		},
		'America/Aruba' => {
			exemplarCity => q#アルバ#,
		},
		'America/Asuncion' => {
			exemplarCity => q#アスンシオン#,
		},
		'America/Bahia' => {
			exemplarCity => q#バイーア#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#バイアバンデラ#,
		},
		'America/Barbados' => {
			exemplarCity => q#バルバドス#,
		},
		'America/Belem' => {
			exemplarCity => q#ベレン#,
		},
		'America/Belize' => {
			exemplarCity => q#ベリーズ#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ブラン・サブロン#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#ボアビスタ#,
		},
		'America/Bogota' => {
			exemplarCity => q#ボゴタ#,
		},
		'America/Boise' => {
			exemplarCity => q#ボイシ#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ブエノスアイレス#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#ケンブリッジベイ#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#カンポグランデ#,
		},
		'America/Cancun' => {
			exemplarCity => q#カンクン#,
		},
		'America/Caracas' => {
			exemplarCity => q#カラカス#,
		},
		'America/Catamarca' => {
			exemplarCity => q#カタマルカ#,
		},
		'America/Cayenne' => {
			exemplarCity => q#カイエンヌ#,
		},
		'America/Cayman' => {
			exemplarCity => q#ケイマン#,
		},
		'America/Chicago' => {
			exemplarCity => q#シカゴ#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#チワワ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#アティコカン#,
		},
		'America/Cordoba' => {
			exemplarCity => q#コルドバ#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#コスタリカ#,
		},
		'America/Creston' => {
			exemplarCity => q#クレストン#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#クイアバ#,
		},
		'America/Curacao' => {
			exemplarCity => q#キュラソー#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#デンマークシャウン#,
		},
		'America/Dawson' => {
			exemplarCity => q#ドーソン#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ドーソンクリーク#,
		},
		'America/Denver' => {
			exemplarCity => q#デンバー#,
		},
		'America/Detroit' => {
			exemplarCity => q#デトロイト#,
		},
		'America/Dominica' => {
			exemplarCity => q#ドミニカ#,
		},
		'America/Edmonton' => {
			exemplarCity => q#エドモントン#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#エイルネペ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#エルサルバドル#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#フォートネルソン#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#フォルタレザ#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#グレースベイ#,
		},
		'America/Godthab' => {
			exemplarCity => q#ヌーク#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#グースベイ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#グランドターク#,
		},
		'America/Grenada' => {
			exemplarCity => q#グレナダ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#グアドループ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#グアテマラ#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#グアヤキル#,
		},
		'America/Guyana' => {
			exemplarCity => q#ガイアナ#,
		},
		'America/Halifax' => {
			exemplarCity => q#ハリファクス#,
		},
		'America/Havana' => {
			exemplarCity => q#ハバナ#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#エルモシヨ#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#インディアナ州ノックス#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#インディアナ州マレンゴ#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#インディアナ州ピーターズバーグ#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#インディアナ州テルシティ#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#インディアナ州ビベー#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#インディアナ州ビンセンス#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#インディアナ州ウィナマック#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#インディアナポリス#,
		},
		'America/Inuvik' => {
			exemplarCity => q#イヌヴィク#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#イカルイット#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ジャマイカ#,
		},
		'America/Jujuy' => {
			exemplarCity => q#フフイ#,
		},
		'America/Juneau' => {
			exemplarCity => q#ジュノー#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#ケンタッキー州モンティチェロ#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#クラレンダイク#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ラパス#,
		},
		'America/Lima' => {
			exemplarCity => q#リマ#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ロサンゼルス#,
		},
		'America/Louisville' => {
			exemplarCity => q#ルイビル#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ローワー・プリンセズ・クウォーター#,
		},
		'America/Maceio' => {
			exemplarCity => q#マセイオ#,
		},
		'America/Managua' => {
			exemplarCity => q#マナグア#,
		},
		'America/Manaus' => {
			exemplarCity => q#マナウス#,
		},
		'America/Marigot' => {
			exemplarCity => q#マリゴ#,
		},
		'America/Martinique' => {
			exemplarCity => q#マルティニーク#,
		},
		'America/Matamoros' => {
			exemplarCity => q#マタモロス#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#マサトラン#,
		},
		'America/Mendoza' => {
			exemplarCity => q#メンドーサ#,
		},
		'America/Menominee' => {
			exemplarCity => q#メノミニー#,
		},
		'America/Merida' => {
			exemplarCity => q#メリダ#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#メトラカトラ#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#メキシコシティー#,
		},
		'America/Miquelon' => {
			exemplarCity => q#ミクロン島#,
		},
		'America/Moncton' => {
			exemplarCity => q#モンクトン#,
		},
		'America/Monterrey' => {
			exemplarCity => q#モンテレイ#,
		},
		'America/Montevideo' => {
			exemplarCity => q#モンテビデオ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#モントセラト#,
		},
		'America/Nassau' => {
			exemplarCity => q#ナッソー#,
		},
		'America/New_York' => {
			exemplarCity => q#ニューヨーク#,
		},
		'America/Nipigon' => {
			exemplarCity => q#ニピゴン#,
		},
		'America/Nome' => {
			exemplarCity => q#ノーム#,
		},
		'America/Noronha' => {
			exemplarCity => q#ノローニャ#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ノースダコタ州ビューラー#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#ノースダコタ州センター#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#ノースダコタ州ニューセーラム#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#オヒナガ#,
		},
		'America/Panama' => {
			exemplarCity => q#パナマ#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#パンナータング#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#パラマリボ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#フェニックス#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#ポルトープランス#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#ポートオブスペイン#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#ポルトベーリョ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#プエルトリコ#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#プンタアレナス#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#レイニーリバー#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#ランキンインレット#,
		},
		'America/Recife' => {
			exemplarCity => q#レシフェ#,
		},
		'America/Regina' => {
			exemplarCity => q#レジャイナ#,
		},
		'America/Resolute' => {
			exemplarCity => q#レゾリュート#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#リオブランコ#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#サンタイサベル#,
		},
		'America/Santarem' => {
			exemplarCity => q#サンタレム#,
		},
		'America/Santiago' => {
			exemplarCity => q#サンチアゴ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#サントドミンゴ#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#サンパウロ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#イトコルトルミット#,
		},
		'America/Sitka' => {
			exemplarCity => q#シトカ#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#サン・バルテルミー#,
		},
		'America/St_Johns' => {
			exemplarCity => q#セントジョンズ#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#セントクリストファー#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#セントルシア#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#セントトーマス#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#セントビンセント#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#スウィフトカレント#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#テグシガルパ#,
		},
		'America/Thule' => {
			exemplarCity => q#チューレ#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#サンダーベイ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ティフアナ#,
		},
		'America/Toronto' => {
			exemplarCity => q#トロント#,
		},
		'America/Tortola' => {
			exemplarCity => q#トルトーラ#,
		},
		'America/Vancouver' => {
			exemplarCity => q#バンクーバー#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ホワイトホース#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ウィニペグ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ヤクタット#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#イエローナイフ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#アメリカ中部夏時間#,
				'generic' => q#アメリカ中部時間#,
				'standard' => q#アメリカ中部標準時#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#アメリカ東部夏時間#,
				'generic' => q#アメリカ東部時間#,
				'standard' => q#アメリカ東部標準時#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#アメリカ山地夏時間#,
				'generic' => q#アメリカ山地時間#,
				'standard' => q#アメリカ山地標準時#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#アメリカ太平洋夏時間#,
				'generic' => q#アメリカ太平洋時間#,
				'standard' => q#アメリカ太平洋標準時#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#アナディリ夏時間#,
				'generic' => q#アナディリ時間#,
				'standard' => q#アナディリ標準時#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#ケーシー基地#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#デービス基地#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#デュモン・デュルヴィル基地#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#マッコリー#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#モーソン基地#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#マクマード基地#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#パーマー基地#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#ロゼラ基地#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#昭和基地#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#トロル基地#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ボストーク基地#,
		},
		'Apia' => {
			long => {
				'daylight' => q#アピア夏時間#,
				'generic' => q#アピア時間#,
				'standard' => q#アピア標準時#,
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q#アクタウ夏時間#,
				'generic' => q#アクタウ時間#,
				'standard' => q#アクタウ標準時#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#アクトベ夏時間#,
				'generic' => q#アクトベ時間#,
				'standard' => q#アクトベ標準時#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#アラビア夏時間#,
				'generic' => q#アラビア時間#,
				'standard' => q#アラビア標準時#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ロングイェールビーン#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#アルゼンチン夏時間#,
				'generic' => q#アルゼンチン時間#,
				'standard' => q#アルゼンチン標準時#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#西部アルゼンチン夏時間#,
				'generic' => q#西部アルゼンチン時間#,
				'standard' => q#西部アルゼンチン標準時#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#アルメニア夏時間#,
				'generic' => q#アルメニア時間#,
				'standard' => q#アルメニア標準時#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#アデン#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#アルマトイ#,
		},
		'Asia/Amman' => {
			exemplarCity => q#アンマン#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#アナディリ#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#アクタウ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#アクトベ#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#アシガバード#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#アティラウ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#バグダッド#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#バーレーン#,
		},
		'Asia/Baku' => {
			exemplarCity => q#バクー#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#バンコク#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#バルナウル#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#ベイルート#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ビシュケク#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ブルネイ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#コルカタ#,
		},
		'Asia/Chita' => {
			exemplarCity => q#チタ#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#チョイバルサン#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#コロンボ#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ダマスカス#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ダッカ#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ディリ#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ドバイ#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ドゥシャンベ#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#ファマグスタ#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#ガザ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ヘブロン#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#香港#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ホブド#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#イルクーツク#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ジャカルタ#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ジャヤプラ#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#エルサレム#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#カブール#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#カムチャッカ#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#カラチ#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#カトマンズ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ハンドゥイガ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#クラスノヤルスク#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#クアラルンプール#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#クチン#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#クウェート#,
		},
		'Asia/Macau' => {
			exemplarCity => q#マカオ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#マガダン#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#マカッサル#,
		},
		'Asia/Manila' => {
			exemplarCity => q#マニラ#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#マスカット#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#ニコシア#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#ノヴォクズネツク#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#ノヴォシビルスク#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#オムスク#,
		},
		'Asia/Oral' => {
			exemplarCity => q#オラル#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#プノンペン#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#ポンティアナック#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#平壌#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#カタール#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#クズロルダ#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#ヤンゴン#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#リヤド#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ホーチミン#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#サハリン#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#サマルカンド#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#ソウル#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#上海#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#シンガポール#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#スレドネコリムスク#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#台北#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#タシケント#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#トビリシ#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#テヘラン#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#ティンプー#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#東京#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#トムスク#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ウランバートル#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ウルムチ#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#ウスチネラ#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ビエンチャン#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ウラジオストク#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ヤクーツク#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#エカテリンブルグ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#エレバン#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#大西洋夏時間#,
				'generic' => q#大西洋時間#,
				'standard' => q#大西洋標準時#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#アゾレス#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#バミューダ#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#カナリア#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#カーボベルデ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#フェロー#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#マデイラ#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#レイキャビク#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#サウスジョージア#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#セントヘレナ#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#スタンレー#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#アデレード#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ブリスベン#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ブロークンヒル#,
		},
		'Australia/Currie' => {
			exemplarCity => q#カリー#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ダーウィン#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ユークラ#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ホバート#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#リンデマン#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ロードハウ#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#メルボルン#,
		},
		'Australia/Perth' => {
			exemplarCity => q#パース#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#シドニー#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#オーストラリア中部夏時間#,
				'generic' => q#オーストラリア中部時間#,
				'standard' => q#オーストラリア中部標準時#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#オーストラリア中西部夏時間#,
				'generic' => q#オーストラリア中西部時間#,
				'standard' => q#オーストラリア中西部標準時#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#オーストラリア東部夏時間#,
				'generic' => q#オーストラリア東部時間#,
				'standard' => q#オーストラリア東部標準時#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#オーストラリア西部夏時間#,
				'generic' => q#オーストラリア西部時間#,
				'standard' => q#オーストラリア西部標準時#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#アゼルバイジャン夏時間#,
				'generic' => q#アゼルバイジャン時間#,
				'standard' => q#アゼルバイジャン標準時#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#アゾレス夏時間#,
				'generic' => q#アゾレス時間#,
				'standard' => q#アゾレス標準時#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#バングラデシュ夏時間#,
				'generic' => q#バングラデシュ時間#,
				'standard' => q#バングラデシュ標準時#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#ブータン時間#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#ボリビア時間#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ブラジリア夏時間#,
				'generic' => q#ブラジリア時間#,
				'standard' => q#ブラジリア標準時#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#ブルネイ・ダルサラーム時間#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#カーボベルデ夏時間#,
				'generic' => q#カーボベルデ時間#,
				'standard' => q#カーボベルデ標準時#,
			},
		},
		'Casey' => {
			long => {
				'standard' => q#ケイシー基地時間#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#チャモロ時間#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#チャタム夏時間#,
				'generic' => q#チャタム時間#,
				'standard' => q#チャタム標準時#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#チリ夏時間#,
				'generic' => q#チリ時間#,
				'standard' => q#チリ標準時#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#中国夏時間#,
				'generic' => q#中国時間#,
				'standard' => q#中国標準時#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#チョイバルサン夏時間#,
				'generic' => q#チョイバルサン時間#,
				'standard' => q#チョイバルサン標準時#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#クリスマス島時間#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#ココス諸島時間#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#コロンビア夏時間#,
				'generic' => q#コロンビア時間#,
				'standard' => q#コロンビア標準時#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#クック諸島夏時間#,
				'generic' => q#クック諸島時間#,
				'standard' => q#クック諸島標準時#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#キューバ夏時間#,
				'generic' => q#キューバ時間#,
				'standard' => q#キューバ標準時#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#デービス基地時間#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#デュモン・デュルヴィル基地時間#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#東ティモール時間#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#イースター島夏時間#,
				'generic' => q#イースター島時間#,
				'standard' => q#イースター島標準時#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#エクアドル時間#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#協定世界時#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#地域不明#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#アムステルダム#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#アンドラ#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#アストラハン#,
		},
		'Europe/Athens' => {
			exemplarCity => q#アテネ#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#ベオグラード#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#ベルリン#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ブラチスラバ#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ブリュッセル#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ブカレスト#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ブダペスト#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ビュージンゲン#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#キシナウ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#コペンハーゲン#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ダブリン#,
			long => {
				'daylight' => q#アイルランド標準時#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ジブラルタル#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ガーンジー#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ヘルシンキ#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#マン島#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#イスタンブール#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ジャージー#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#カリーニングラード#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#キエフ#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#キーロフ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#リスボン#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#リュブリャナ#,
		},
		'Europe/London' => {
			exemplarCity => q#ロンドン#,
			long => {
				'daylight' => q#英国夏時間#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ルクセンブルク#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#マドリード#,
		},
		'Europe/Malta' => {
			exemplarCity => q#マルタ#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#マリエハムン#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#ミンスク#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#モナコ#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#モスクワ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#オスロ#,
		},
		'Europe/Paris' => {
			exemplarCity => q#パリ#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#ポドゴリツァ#,
		},
		'Europe/Prague' => {
			exemplarCity => q#プラハ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#リガ#,
		},
		'Europe/Rome' => {
			exemplarCity => q#ローマ#,
		},
		'Europe/Samara' => {
			exemplarCity => q#サマラ#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#サンマリノ#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#サラエボ#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#サラトフ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#シンフェロポリ#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#スコピエ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#ソフィア#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#ストックホルム#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#タリン#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ティラナ#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#ウリヤノフスク#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ウージュホロド#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ファドゥーツ#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#バチカン#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ウィーン#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ヴィリニュス#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ボルゴグラード#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ワルシャワ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ザグレブ#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ザポリージャ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#チューリッヒ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#中央ヨーロッパ夏時間#,
				'generic' => q#中央ヨーロッパ時間#,
				'standard' => q#中央ヨーロッパ標準時#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#東ヨーロッパ夏時間#,
				'generic' => q#東ヨーロッパ時間#,
				'standard' => q#東ヨーロッパ標準時#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#極東ヨーロッパ時間#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#西ヨーロッパ夏時間#,
				'generic' => q#西ヨーロッパ時間#,
				'standard' => q#西ヨーロッパ標準時#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#フォークランド諸島夏時間#,
				'generic' => q#フォークランド諸島時間#,
				'standard' => q#フォークランド諸島標準時#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#フィジー夏時間#,
				'generic' => q#フィジー時間#,
				'standard' => q#フィジー標準時#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#仏領ギアナ時間#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#仏領南方南極時間#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#グリニッジ標準時#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#ガラパゴス時間#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#ガンビエ諸島時間#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#ジョージア夏時間#,
				'generic' => q#ジョージア時間#,
				'standard' => q#ジョージア標準時#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#ギルバート諸島時間#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#グリーンランド東部夏時間#,
				'generic' => q#グリーンランド東部時間#,
				'standard' => q#グリーンランド東部標準時#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#グリーンランド西部夏時間#,
				'generic' => q#グリーンランド西部時間#,
				'standard' => q#グリーンランド西部標準時#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#グアム時間#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#湾岸標準時#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#ガイアナ時間#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#ハワイ・アリューシャン夏時間#,
				'generic' => q#ハワイ・アリューシャン時間#,
				'standard' => q#ハワイ・アリューシャン標準時#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#香港夏時間#,
				'generic' => q#香港時間#,
				'standard' => q#香港標準時#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#ホブド夏時間#,
				'generic' => q#ホブド時間#,
				'standard' => q#ホブド標準時#,
			},
		},
		'India' => {
			long => {
				'standard' => q#インド標準時#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#アンタナナリボ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#チャゴス#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#クリスマス島#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#ココス諸島#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#コモロ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#ケルゲレン諸島#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#マヘ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#モルディブ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#モーリシャス#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#マヨット#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#レユニオン#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#インド洋時間#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#インドシナ時間#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#インドネシア中部時間#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#インドネシア東部時間#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#インドネシア西部時間#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#イラン夏時間#,
				'generic' => q#イラン時間#,
				'standard' => q#イラン標準時#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#イルクーツク夏時間#,
				'generic' => q#イルクーツク時間#,
				'standard' => q#イルクーツク標準時#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#イスラエル夏時間#,
				'generic' => q#イスラエル時間#,
				'standard' => q#イスラエル標準時#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#日本夏時間#,
				'generic' => q#日本時間#,
				'standard' => q#日本標準時#,
			},
			short => {
				'daylight' => q#JDT#,
				'generic' => q#∅∅∅#,
				'standard' => q#JST#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#ペトロパブロフスク・カムチャツキー夏時間#,
				'generic' => q#ペトロパブロフスク・カムチャツキー時間#,
				'standard' => q#ペトロパブロフスク・カムチャツキー標準時#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#東カザフスタン時間#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#西カザフスタン時間#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#韓国夏時間#,
				'generic' => q#韓国時間#,
				'standard' => q#韓国標準時#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#コスラエ時間#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#クラスノヤルスク夏時間#,
				'generic' => q#クラスノヤルスク時間#,
				'standard' => q#クラスノヤルスク標準時#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#キルギス時間#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#ランカ時間#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#ライン諸島時間#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#ロードハウ夏時間#,
				'generic' => q#ロードハウ時間#,
				'standard' => q#ロードハウ標準時#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#マカオ夏時間#,
				'generic' => q#マカオ時間#,
				'standard' => q#マカオ標準時#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#マッコーリー島時間#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#マガダン夏時間#,
				'generic' => q#マガダン時間#,
				'standard' => q#マガダン標準時#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#マレーシア時間#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#モルディブ時間#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#マルキーズ時間#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#マーシャル諸島時間#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#モーリシャス夏時間#,
				'generic' => q#モーリシャス時間#,
				'standard' => q#モーリシャス標準時#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#モーソン基地時間#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#メキシコ北西部夏時間#,
				'generic' => q#メキシコ北西部時間#,
				'standard' => q#メキシコ北西部標準時#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#メキシコ太平洋夏時間#,
				'generic' => q#メキシコ太平洋時間#,
				'standard' => q#メキシコ太平洋標準時#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#ウランバートル夏時間#,
				'generic' => q#ウランバートル時間#,
				'standard' => q#ウランバートル標準時#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#モスクワ夏時間#,
				'generic' => q#モスクワ時間#,
				'standard' => q#モスクワ標準時#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#ミャンマー時間#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#ナウル時間#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#ネパール時間#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#ニューカレドニア夏時間#,
				'generic' => q#ニューカレドニア時間#,
				'standard' => q#ニューカレドニア標準時#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#ニュージーランド夏時間#,
				'generic' => q#ニュージーランド時間#,
				'standard' => q#ニュージーランド標準時#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#ニューファンドランド夏時間#,
				'generic' => q#ニューファンドランド時間#,
				'standard' => q#ニューファンドランド標準時#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#ニウエ時間#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#ノーフォーク島時間#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#フェルナンド・デ・ノローニャ夏時間#,
				'generic' => q#フェルナンド・デ・ノローニャ時間#,
				'standard' => q#フェルナンド・デ・ノローニャ標準時#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#北マリアナ諸島時間#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#ノヴォシビルスク夏時間#,
				'generic' => q#ノヴォシビルスク時間#,
				'standard' => q#ノヴォシビルスク標準時#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#オムスク夏時間#,
				'generic' => q#オムスク時間#,
				'standard' => q#オムスク標準時#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#アピア#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#オークランド#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#ブーゲンビル#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#チャタム#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#イースター島#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#エフェテ島#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#エンダーベリー島#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ファカオフォ#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#フィジー#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#フナフティ#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ガラパゴス#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ガンビエ諸島#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ガダルカナル#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#グアム#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ホノルル#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ジョンストン島#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#キリスィマスィ島#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#コスラエ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#クェゼリン#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#マジュロ#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#マルキーズ#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#ミッドウェー島#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ナウル#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#ニウエ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#ノーフォーク島#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#ヌメア#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#パゴパゴ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#パラオ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#ピトケアン諸島#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#ポンペイ島#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#ポートモレスビー#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#ラロトンガ#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#サイパン#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#タヒチ#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#タラワ#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#トンガタプ#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#チューク#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ウェーク島#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ウォリス諸島#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#パキスタン夏時間#,
				'generic' => q#パキスタン時間#,
				'standard' => q#パキスタン標準時#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#パラオ時間#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#パプアニューギニア時間#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#パラグアイ夏時間#,
				'generic' => q#パラグアイ時間#,
				'standard' => q#パラグアイ標準時#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#ペルー夏時間#,
				'generic' => q#ペルー時間#,
				'standard' => q#ペルー標準時#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#フィリピン夏時間#,
				'generic' => q#フィリピン時間#,
				'standard' => q#フィリピン標準時#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#フェニックス諸島時間#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#サンピエール島・ミクロン島夏時間#,
				'generic' => q#サンピエール島・ミクロン島時間#,
				'standard' => q#サンピエール島・ミクロン島標準時#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#ピトケアン時間#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#ポナペ時間#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#平壌時間#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#クズロルダ夏時間#,
				'generic' => q#クズロルダ時間#,
				'standard' => q#クズロルダ標準時#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#レユニオン時間#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#ロゼラ基地時間#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#サハリン夏時間#,
				'generic' => q#サハリン時間#,
				'standard' => q#サハリン標準時#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#サマラ夏時間#,
				'generic' => q#サマラ時間#,
				'standard' => q#サマラ標準時#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#サモア夏時間#,
				'generic' => q#サモア時間#,
				'standard' => q#サモア標準時#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#セーシェル時間#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#シンガポール標準時#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#ソロモン諸島時間#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#サウスジョージア時間#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#スリナム時間#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#昭和基地時間#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#タヒチ時間#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#台北夏時間#,
				'generic' => q#台北時間#,
				'standard' => q#台北標準時#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#タジキスタン時間#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#トケラウ時間#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#トンガ夏時間#,
				'generic' => q#トンガ時間#,
				'standard' => q#トンガ標準時#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#チューク時間#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#トルクメニスタン夏時間#,
				'generic' => q#トルクメニスタン時間#,
				'standard' => q#トルクメニスタン標準時#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#ツバル時間#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#ウルグアイ夏時間#,
				'generic' => q#ウルグアイ時間#,
				'standard' => q#ウルグアイ標準時#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ウズベキスタン夏時間#,
				'generic' => q#ウズベキスタン時間#,
				'standard' => q#ウズベキスタン標準時#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#バヌアツ夏時間#,
				'generic' => q#バヌアツ時間#,
				'standard' => q#バヌアツ標準時#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#ベネズエラ時間#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ウラジオストク夏時間#,
				'generic' => q#ウラジオストク時間#,
				'standard' => q#ウラジオストク標準時#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#ボルゴグラード夏時間#,
				'generic' => q#ボルゴグラード時間#,
				'standard' => q#ボルゴグラード標準時#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ボストーク基地時間#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ウェーク島時間#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#ウォリス・フツナ時間#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#ヤクーツク夏時間#,
				'generic' => q#ヤクーツク時間#,
				'standard' => q#ヤクーツク標準時#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#エカテリンブルグ夏時間#,
				'generic' => q#エカテリンブルグ時間#,
				'standard' => q#エカテリンブルグ標準時#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
