package Kwiki::Installer;
use Spoon::Installer -Base;

sub set_file_content {
    # Can't use super here because of mixin squashes things down into one
    # namespace. May need to make mixins more flexible.
    my $content = Spoon::Installer::set_file_content($self, @_);
    my $path = shift;
    $content = $self->warn_config($content)
      if $self->file_is_config($path);
    return $content;
}

sub file_is_config {
    my $path = shift;
    $path =~ /config\/\w+\.yaml$/;
}

sub warn_config {
    <<END . shift;
# DO NOT EDIT THIS FILE
# Put overrides in the top level config.yaml
# See: http://www.kwiki.org/?ChangingConfigDotYaml
#
END
}

__DATA__

=head1 NAME

Kwiki::Installer - Kwiki Installer Base Class

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 AUTHOR

Brian Ingerson <INGY@cpan.org>

=head1 COPYRIGHT

Copyright (c) 2004. Brian Ingerson. All rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

See http://www.perl.com/perl/misc/Artistic.html

=cut
