#============================================================= -*-Perl-*-
#
# Jemplate::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Ingy döt Net   <ingy@cpan.org>
#
# ORIGINAL AUTHOR
#   Andy Wardley   <abw@kfs.org>
#
# COPYRIGHT
#   Copyright (C) 2006 Ingy döt Net.  All Rights Reserved.
#   Copyright (C) 1996-2000 Andy Wardley.  All Rights Reserved.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#------------------------------------------------------------------------
#
# NOTE: this module is constructed from the parser/Grammar.pm.skel
# file by running the parser/yc script.  You only need to do this if 
# you have modified the grammar in the parser/Parser.yp file and need
# to-recompile it.  See the README in the 'parser' directory for more
# information (sub-directory of the Jemplate distribution).
#
#========================================================================

package Jemplate::Grammar;

require 5.004;

use strict;
use vars qw( $VERSION );

$VERSION  = sprintf("%d.%02d", q$Revision: 2.10 $ =~ /(\d+)\.(\d+)/);

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================
# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE PLUGIN FILTER MACRO JAVASCRIPT TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META IN
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG
    );

# for historical reasons, != and == are converted to ne and eq to perform 
# stringwise comparison (mainly because it doesn't generate "non-numerical 
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al, 
# briefly for v2.04d and then took them out again in 2.04e.

%CMPOP = qw( 
    != !=
    == ==
    <  <
    >  >
    >= >=
    <= <=
);


#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
#    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
#    my @binop  = qw( + - * % );              # '/' above, in @tokens
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'template' => 51,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'switch' => 34,
			'try' => 35,
			'assign' => 19,
			'block' => 72,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 1
		ACTIONS => {
			"\$" => 42,
			'LITERAL' => 75,
			'IDENT' => 2,
			"\${" => 37
		},
		GOTOS => {
			'setlist' => 76,
			'item' => 39,
			'assign' => 19,
			'node' => 23,
			'ident' => 74
		}
	},
	{#State 2
		DEFAULT => -129
	},
	{#State 3
		DEFAULT => -25
	},
	{#State 4
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 79,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 5
		DEFAULT => -23
	},
	{#State 6
		ACTIONS => {
			";" => 80
		}
	},
	{#State 7
		DEFAULT => -38
	},
	{#State 8
		DEFAULT => -14
	},
	{#State 9
		ACTIONS => {
			"\"" => 89,
			"\$" => 86,
			'LITERAL' => 88,
			'FILENAME' => 83,
			'IDENT' => 81,
			'NUMBER' => 84
		},
		GOTOS => {
			'filepart' => 87,
			'names' => 91,
			'nameargs' => 90,
			'filename' => 85,
			'name' => 82
		}
	},
	{#State 10
		ACTIONS => {
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"]" => 94,
			"\${" => 37
		},
		GOTOS => {
			'sterm' => 96,
			'item' => 39,
			'range' => 93,
			'node' => 23,
			'ident' => 77,
			'term' => 95,
			'lterm' => 56,
			'list' => 92
		}
	},
	{#State 11
		ACTIONS => {
			";" => 97
		}
	},
	{#State 12
		DEFAULT => -5
	},
	{#State 13
		ACTIONS => {
			";" => -20
		},
		DEFAULT => -28
	},
	{#State 14
		ACTIONS => {
			'IDENT' => 98
		},
		DEFAULT => -86,
		GOTOS => {
			'blockargs' => 101,
			'metadata' => 100,
			'meta' => 99
		}
	},
	{#State 15
		ACTIONS => {
			'IDENT' => 98
		},
		GOTOS => {
			'metadata' => 102,
			'meta' => 99
		}
	},
	{#State 16
		ACTIONS => {
			'DOT' => 103,
			'ASSIGN' => 104
		},
		DEFAULT => -108
	},
	{#State 17
		ACTIONS => {
			"\"" => 89,
			"\$" => 86,
			'LITERAL' => 88,
			'FILENAME' => 83,
			'IDENT' => 81,
			'NUMBER' => 84
		},
		GOTOS => {
			'filepart' => 87,
			'names' => 91,
			'nameargs' => 105,
			'filename' => 85,
			'name' => 82
		}
	},
	{#State 18
		ACTIONS => {
			'IDENT' => 106
		}
	},
	{#State 19
		DEFAULT => -148
	},
	{#State 20
		DEFAULT => -12
	},
	{#State 21
		ACTIONS => {
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 107,
			"\"" => 60,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'sterm' => 68,
			'item' => 39,
			'loopvar' => 109,
			'node' => 23,
			'ident' => 77,
			'term' => 108,
			'lterm' => 56
		}
	},
	{#State 22
		DEFAULT => -41
	},
	{#State 23
		DEFAULT => -126
	},
	{#State 24
		DEFAULT => -6
	},
	{#State 25
		ACTIONS => {
			"\"" => 116,
			"\$" => 113,
			'LITERAL' => 115,
			'FILENAME' => 83,
			'IDENT' => 110,
			'NUMBER' => 84,
			"\${" => 37
		},
		GOTOS => {
			'names' => 91,
			'lvalue' => 111,
			'item' => 112,
			'name' => 82,
			'filepart' => 87,
			'filename' => 85,
			'nameargs' => 117,
			'lnameargs' => 114
		}
	},
	{#State 26
		DEFAULT => -112
	},
	{#State 27
		ACTIONS => {
			"\$" => 42,
			'IDENT' => 2,
			"\${" => 37
		},
		GOTOS => {
			'item' => 39,
			'node' => 23,
			'ident' => 118
		}
	},
	{#State 28
		ACTIONS => {
			'LITERAL' => 123,
			'FILENAME' => 83,
			'IDENT' => 119,
			'NUMBER' => 84
		},
		DEFAULT => -86,
		GOTOS => {
			'blockargs' => 122,
			'filepart' => 87,
			'filename' => 121,
			'blockname' => 120,
			'metadata' => 100,
			'meta' => 99
		}
	},
	{#State 29
		DEFAULT => -44
	},
	{#State 30
		ACTIONS => {
			"\$" => 42,
			'LITERAL' => 128,
			'IDENT' => 2,
			"\${" => 37
		},
		DEFAULT => -118,
		GOTOS => {
			'params' => 127,
			'hash' => 124,
			'item' => 125,
			'param' => 126
		}
	},
	{#State 31
		DEFAULT => -26
	},
	{#State 32
		ACTIONS => {
			"\"" => 116,
			"\$" => 113,
			'LITERAL' => 115,
			'FILENAME' => 83,
			'IDENT' => 110,
			'NUMBER' => 84,
			"\${" => 37
		},
		GOTOS => {
			'names' => 91,
			'lvalue' => 111,
			'item' => 112,
			'name' => 82,
			'filepart' => 87,
			'filename' => 85,
			'nameargs' => 117,
			'lnameargs' => 129
		}
	},
	{#State 33
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -2,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 130,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 34
		DEFAULT => -22
	},
	{#State 35
		DEFAULT => -24
	},
	{#State 36
		ACTIONS => {
			"\"" => 89,
			"\$" => 86,
			'LITERAL' => 88,
			'FILENAME' => 83,
			'IDENT' => 81,
			'NUMBER' => 84
		},
		GOTOS => {
			'filepart' => 87,
			'names' => 91,
			'nameargs' => 131,
			'filename' => 85,
			'name' => 82
		}
	},
	{#State 37
		ACTIONS => {
			"\"" => 60,
			"\$" => 42,
			'LITERAL' => 78,
			'IDENT' => 2,
			'REF' => 27,
			'NUMBER' => 26,
			"\${" => 37
		},
		GOTOS => {
			'sterm' => 132,
			'item' => 39,
			'node' => 23,
			'ident' => 77
		}
	},
	{#State 38
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 133,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 39
		ACTIONS => {
			"(" => 134
		},
		DEFAULT => -127
	},
	{#State 40
		DEFAULT => -39
	},
	{#State 41
		DEFAULT => -11
	},
	{#State 42
		ACTIONS => {
			'IDENT' => 135
		}
	},
	{#State 43
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 136,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 44
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 137,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 45
		DEFAULT => -43
	},
	{#State 46
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 138,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 47
		ACTIONS => {
			'IF' => 142,
			'FILTER' => 141,
			'FOR' => 140,
			'WHILE' => 144,
			'WRAPPER' => 143,
			'UNLESS' => 139
		}
	},
	{#State 48
		DEFAULT => -40
	},
	{#State 49
		DEFAULT => -10
	},
	{#State 50
		ACTIONS => {
			"\"" => 89,
			"\$" => 86,
			'LITERAL' => 88,
			'FILENAME' => 83,
			'IDENT' => 81,
			'NUMBER' => 84
		},
		GOTOS => {
			'filepart' => 87,
			'names' => 91,
			'nameargs' => 145,
			'filename' => 85,
			'name' => 82
		}
	},
	{#State 51
		ACTIONS => {
			'' => 146
		}
	},
	{#State 52
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 57,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 149,
			'sterm' => 68,
			'item' => 39,
			'assign' => 148,
			'node' => 23,
			'ident' => 147,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 53
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 150,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 54
		ACTIONS => {
			";" => 151
		}
	},
	{#State 55
		ACTIONS => {
			"\"" => 89,
			"\$" => 86,
			'LITERAL' => 88,
			'FILENAME' => 83,
			'IDENT' => 81,
			'NUMBER' => 84
		},
		GOTOS => {
			'filepart' => 87,
			'names' => 91,
			'nameargs' => 152,
			'filename' => 85,
			'name' => 82
		}
	},
	{#State 56
		DEFAULT => -102
	},
	{#State 57
		ACTIONS => {
			'ASSIGN' => 153
		},
		DEFAULT => -111
	},
	{#State 58
		DEFAULT => -145
	},
	{#State 59
		DEFAULT => -15
	},
	{#State 60
		DEFAULT => -175,
		GOTOS => {
			'quoted' => 154
		}
	},
	{#State 61
		ACTIONS => {
			"\"" => 89,
			"\$" => 86,
			'LITERAL' => 88,
			'FILENAME' => 83,
			'IDENT' => 81,
			'NUMBER' => 84
		},
		GOTOS => {
			'filepart' => 87,
			'names' => 91,
			'nameargs' => 155,
			'filename' => 85,
			'name' => 82
		}
	},
	{#State 62
		ACTIONS => {
			";" => -16,
			"+" => 156,
			'CAT' => 162,
			'CMPOP' => 163,
			"?" => 157,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165,
			'AND' => 159,
			'BINOP' => 160,
			'OR' => 161
		},
		DEFAULT => -27
	},
	{#State 63
		DEFAULT => -13
	},
	{#State 64
		DEFAULT => -37
	},
	{#State 65
		ACTIONS => {
			"\"" => 89,
			"\$" => 86,
			'LITERAL' => 88,
			'FILENAME' => 83,
			'IDENT' => 81,
			'NUMBER' => 84
		},
		GOTOS => {
			'filepart' => 87,
			'names' => 91,
			'nameargs' => 166,
			'filename' => 85,
			'name' => 82
		}
	},
	{#State 66
		DEFAULT => -9
	},
	{#State 67
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 167,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 68
		DEFAULT => -103
	},
	{#State 69
		ACTIONS => {
			"\$" => 42,
			'LITERAL' => 75,
			'IDENT' => 2,
			"\${" => 37
		},
		GOTOS => {
			'setlist' => 168,
			'item' => 39,
			'assign' => 19,
			'node' => 23,
			'ident' => 74
		}
	},
	{#State 70
		ACTIONS => {
			"\$" => 42,
			'COMMA' => 170,
			'LITERAL' => 75,
			'IDENT' => 2,
			"\${" => 37
		},
		DEFAULT => -19,
		GOTOS => {
			'item' => 39,
			'assign' => 169,
			'node' => 23,
			'ident' => 74
		}
	},
	{#State 71
		DEFAULT => -8
	},
	{#State 72
		DEFAULT => -1
	},
	{#State 73
		DEFAULT => -21
	},
	{#State 74
		ACTIONS => {
			'ASSIGN' => 171,
			'DOT' => 103
		}
	},
	{#State 75
		ACTIONS => {
			'ASSIGN' => 153
		}
	},
	{#State 76
		ACTIONS => {
			'COMMA' => 170,
			'LITERAL' => 75,
			'IDENT' => 2,
			"\$" => 42,
			"\${" => 37
		},
		DEFAULT => -31,
		GOTOS => {
			'item' => 39,
			'assign' => 169,
			'node' => 23,
			'ident' => 74
		}
	},
	{#State 77
		ACTIONS => {
			'DOT' => 103
		},
		DEFAULT => -108
	},
	{#State 78
		DEFAULT => -111
	},
	{#State 79
		ACTIONS => {
			'CMPOP' => 163,
			"?" => 157,
			";" => 172,
			"+" => 156,
			'MOD' => 164,
			'DIV' => 158,
			"/" => 165,
			'AND' => 159,
			'CAT' => 162,
			'BINOP' => 160,
			'OR' => 161
		}
	},
	{#State 80
		DEFAULT => -7
	},
	{#State 81
		DEFAULT => -172
	},
	{#State 82
		DEFAULT => -165
	},
	{#State 83
		DEFAULT => -171
	},
	{#State 84
		DEFAULT => -173
	},
	{#State 85
		ACTIONS => {
			'DOT' => 173
		},
		DEFAULT => -167
	},
	{#State 86
		ACTIONS => {
			"\$" => 42,
			'IDENT' => 2,
			"\${" => 37
		},
		GOTOS => {
			'item' => 39,
			'node' => 23,
			'ident' => 174
		}
	},
	{#State 87
		DEFAULT => -170
	},
	{#State 88
		DEFAULT => -168
	},
	{#State 89
		DEFAULT => -175,
		GOTOS => {
			'quoted' => 175
		}
	},
	{#State 90
		DEFAULT => -36
	},
	{#State 91
		ACTIONS => {
			"+" => 176,
			"(" => 177
		},
		DEFAULT => -155,
		GOTOS => {
			'args' => 178
		}
	},
	{#State 92
		ACTIONS => {
			"{" => 30,
			'COMMA' => 181,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"]" => 179,
			"\${" => 37
		},
		GOTOS => {
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 180,
			'lterm' => 56
		}
	},
	{#State 93
		ACTIONS => {
			"]" => 182
		}
	},
	{#State 94
		DEFAULT => -106
	},
	{#State 95
		DEFAULT => -115
	},
	{#State 96
		ACTIONS => {
			'TO' => 183
		},
		DEFAULT => -103
	},
	{#State 97
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 184,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 98
		ACTIONS => {
			'ASSIGN' => 185
		}
	},
	{#State 99
		DEFAULT => -98
	},
	{#State 100
		ACTIONS => {
			'COMMA' => 187,
			'IDENT' => 98
		},
		DEFAULT => -85,
		GOTOS => {
			'meta' => 186
		}
	},
	{#State 101
		ACTIONS => {
			";" => 188
		}
	},
	{#State 102
		ACTIONS => {
			'COMMA' => 187,
			'IDENT' => 98
		},
		DEFAULT => -17,
		GOTOS => {
			'meta' => 186
		}
	},
	{#State 103
		ACTIONS => {
			"\$" => 42,
			'IDENT' => 2,
			'NUMBER' => 190,
			"\${" => 37
		},
		GOTOS => {
			'item' => 39,
			'node' => 189
		}
	},
	{#State 104
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			'FOR' => 21,
			'NEXT' => 22,
			'LITERAL' => 57,
			"\"" => 60,
			'PROCESS' => 61,
			'FILTER' => 25,
			'RETURN' => 64,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 191,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			"\${" => 37
		},
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'expr' => 193,
			'wrapper' => 45,
			'atomexpr' => 47,
			'atomdir' => 13,
			'mdir' => 192,
			'filter' => 29,
			'sterm' => 68,
			'ident' => 147,
			'setlist' => 70,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'directive' => 194,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 105
		DEFAULT => -34
	},
	{#State 106
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'INCLUDE' => 17,
			"(" => 196,
			'SWITCH' => 53,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			'FOR' => 21,
			'NEXT' => 22,
			'LITERAL' => 57,
			"\"" => 60,
			'PROCESS' => 61,
			'FILTER' => 25,
			'RETURN' => 64,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 191,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			"\${" => 37
		},
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'expr' => 197,
			'wrapper' => 45,
			'atomexpr' => 47,
			'atomdir' => 13,
			'mdir' => 195,
			'filter' => 29,
			'sterm' => 68,
			'ident' => 147,
			'setlist' => 70,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'directive' => 194,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 107
		ACTIONS => {
			'IN' => 199,
			'ASSIGN' => 198
		},
		DEFAULT => -129
	},
	{#State 108
		DEFAULT => -155,
		GOTOS => {
			'args' => 200
		}
	},
	{#State 109
		ACTIONS => {
			";" => 201
		}
	},
	{#State 110
		ACTIONS => {
			'ASSIGN' => -129
		},
		DEFAULT => -172
	},
	{#State 111
		ACTIONS => {
			'ASSIGN' => 202
		}
	},
	{#State 112
		DEFAULT => -158
	},
	{#State 113
		ACTIONS => {
			"\$" => 42,
			'IDENT' => 203,
			"\${" => 37
		},
		GOTOS => {
			'item' => 39,
			'node' => 23,
			'ident' => 174
		}
	},
	{#State 114
		ACTIONS => {
			";" => 204
		}
	},
	{#State 115
		ACTIONS => {
			'ASSIGN' => -160
		},
		DEFAULT => -168
	},
	{#State 116
		DEFAULT => -175,
		GOTOS => {
			'quoted' => 205
		}
	},
	{#State 117
		DEFAULT => -157
	},
	{#State 118
		ACTIONS => {
			'DOT' => 103
		},
		DEFAULT => -109
	},
	{#State 119
		ACTIONS => {
			'ASSIGN' => 185
		},
		DEFAULT => -172
	},
	{#State 120
		DEFAULT => -82
	},
	{#State 121
		ACTIONS => {
			'DOT' => 173
		},
		DEFAULT => -83
	},
	{#State 122
		ACTIONS => {
			";" => 206
		}
	},
	{#State 123
		DEFAULT => -84
	},
	{#State 124
		ACTIONS => {
			"}" => 207
		}
	},
	{#State 125
		ACTIONS => {
			'ASSIGN' => 208
		}
	},
	{#State 126
		DEFAULT => -121
	},
	{#State 127
		ACTIONS => {
			"\$" => 42,
			'COMMA' => 210,
			'LITERAL' => 128,
			'IDENT' => 2,
			"\${" => 37
		},
		DEFAULT => -117,
		GOTOS => {
			'item' => 125,
			'param' => 209
		}
	},
	{#State 128
		ACTIONS => {
			'ASSIGN' => 211
		}
	},
	{#State 129
		DEFAULT => -74
	},
	{#State 130
		DEFAULT => -4
	},
	{#State 131
		ACTIONS => {
			";" => 212
		}
	},
	{#State 132
		ACTIONS => {
			"}" => 213
		}
	},
	{#State 133
		ACTIONS => {
			"+" => 156,
			'CAT' => 162,
			'CMPOP' => 163,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165,
			'BINOP' => 160
		},
		DEFAULT => -141
	},
	{#State 134
		DEFAULT => -155,
		GOTOS => {
			'args' => 214
		}
	},
	{#State 135
		DEFAULT => -131
	},
	{#State 136
		ACTIONS => {
			'CMPOP' => 163,
			"?" => 157,
			";" => 215,
			"+" => 156,
			'MOD' => 164,
			'DIV' => 158,
			"/" => 165,
			'AND' => 159,
			'CAT' => 162,
			'BINOP' => 160,
			'OR' => 161
		}
	},
	{#State 137
		ACTIONS => {
			"+" => 156,
			'CAT' => 162,
			'CMPOP' => 163,
			"?" => 157,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165,
			'AND' => 159,
			'BINOP' => 160,
			'OR' => 161
		},
		DEFAULT => -30
	},
	{#State 138
		ACTIONS => {
			"+" => 156,
			'CAT' => 162,
			'CMPOP' => 163,
			"?" => 157,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165,
			'AND' => 159,
			'BINOP' => 160,
			'OR' => 161
		},
		DEFAULT => -29
	},
	{#State 139
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 216,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 140
		ACTIONS => {
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 107,
			"\"" => 60,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'sterm' => 68,
			'item' => 39,
			'loopvar' => 217,
			'node' => 23,
			'ident' => 77,
			'term' => 108,
			'lterm' => 56
		}
	},
	{#State 141
		ACTIONS => {
			"\"" => 116,
			"\$" => 113,
			'LITERAL' => 115,
			'FILENAME' => 83,
			'IDENT' => 110,
			'NUMBER' => 84,
			"\${" => 37
		},
		GOTOS => {
			'names' => 91,
			'lvalue' => 111,
			'item' => 112,
			'name' => 82,
			'filepart' => 87,
			'filename' => 85,
			'nameargs' => 117,
			'lnameargs' => 218
		}
	},
	{#State 142
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 219,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 143
		ACTIONS => {
			"\"" => 89,
			"\$" => 86,
			'LITERAL' => 88,
			'FILENAME' => 83,
			'IDENT' => 81,
			'NUMBER' => 84
		},
		GOTOS => {
			'filepart' => 87,
			'names' => 91,
			'nameargs' => 220,
			'filename' => 85,
			'name' => 82
		}
	},
	{#State 144
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 221,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 145
		DEFAULT => -42
	},
	{#State 146
		DEFAULT => 0
	},
	{#State 147
		ACTIONS => {
			'DOT' => 103,
			'ASSIGN' => 171
		},
		DEFAULT => -108
	},
	{#State 148
		ACTIONS => {
			")" => 222
		}
	},
	{#State 149
		ACTIONS => {
			'CMPOP' => 163,
			"?" => 157,
			"+" => 156,
			'MOD' => 164,
			'DIV' => 158,
			"/" => 165,
			'AND' => 159,
			'CAT' => 162,
			'BINOP' => 160,
			")" => 223,
			'OR' => 161
		}
	},
	{#State 150
		ACTIONS => {
			'CMPOP' => 163,
			"?" => 157,
			";" => 224,
			"+" => 156,
			'MOD' => 164,
			'DIV' => 158,
			"/" => 165,
			'AND' => 159,
			'CAT' => 162,
			'BINOP' => 160,
			'OR' => 161
		}
	},
	{#State 151
		DEFAULT => -77,
		GOTOS => {
			'@4-2' => 225
		}
	},
	{#State 152
		ACTIONS => {
			";" => 226
		}
	},
	{#State 153
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 227,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 154
		ACTIONS => {
			"\"" => 232,
			'TEXT' => 229,
			";" => 231,
			"\$" => 42,
			'IDENT' => 2,
			"\${" => 37
		},
		GOTOS => {
			'item' => 39,
			'node' => 23,
			'ident' => 228,
			'quotable' => 230
		}
	},
	{#State 155
		DEFAULT => -35
	},
	{#State 156
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 233,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 157
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 234,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 158
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 235,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 159
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 236,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 160
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 237,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 161
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 238,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 162
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 239,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 163
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 240,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 164
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 241,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 165
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 242,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 166
		DEFAULT => -33
	},
	{#State 167
		ACTIONS => {
			'CMPOP' => 163,
			"?" => 157,
			";" => 243,
			"+" => 156,
			'MOD' => 164,
			'DIV' => 158,
			"/" => 165,
			'AND' => 159,
			'CAT' => 162,
			'BINOP' => 160,
			'OR' => 161
		}
	},
	{#State 168
		ACTIONS => {
			'COMMA' => 170,
			'LITERAL' => 75,
			'IDENT' => 2,
			"\$" => 42,
			"\${" => 37
		},
		DEFAULT => -32,
		GOTOS => {
			'item' => 39,
			'assign' => 169,
			'node' => 23,
			'ident' => 74
		}
	},
	{#State 169
		DEFAULT => -146
	},
	{#State 170
		DEFAULT => -147
	},
	{#State 171
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 244,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 172
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 245,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 173
		ACTIONS => {
			'FILENAME' => 83,
			'IDENT' => 81,
			'NUMBER' => 84
		},
		GOTOS => {
			'filepart' => 246
		}
	},
	{#State 174
		ACTIONS => {
			'DOT' => 103
		},
		DEFAULT => -155,
		GOTOS => {
			'args' => 247
		}
	},
	{#State 175
		ACTIONS => {
			"\"" => 248,
			'TEXT' => 229,
			";" => 231,
			"\$" => 42,
			'IDENT' => 2,
			"\${" => 37
		},
		GOTOS => {
			'item' => 39,
			'node' => 23,
			'ident' => 228,
			'quotable' => 230
		}
	},
	{#State 176
		ACTIONS => {
			"\"" => 89,
			'LITERAL' => 88,
			'FILENAME' => 83,
			'IDENT' => 81,
			'NUMBER' => 84
		},
		GOTOS => {
			'filepart' => 87,
			'filename' => 85,
			'name' => 249
		}
	},
	{#State 177
		DEFAULT => -155,
		GOTOS => {
			'args' => 250
		}
	},
	{#State 178
		ACTIONS => {
			'LITERAL' => 254,
			'IDENT' => 2,
			"\"" => 60,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"{" => 30,
			'COMMA' => 256,
			"\${" => 37
		},
		DEFAULT => -162,
		GOTOS => {
			'sterm' => 68,
			'item' => 252,
			'param' => 253,
			'node' => 23,
			'ident' => 251,
			'term' => 255,
			'lterm' => 56
		}
	},
	{#State 179
		DEFAULT => -104
	},
	{#State 180
		DEFAULT => -113
	},
	{#State 181
		DEFAULT => -114
	},
	{#State 182
		DEFAULT => -105
	},
	{#State 183
		ACTIONS => {
			"\"" => 60,
			"\$" => 42,
			'LITERAL' => 78,
			'IDENT' => 2,
			'REF' => 27,
			'NUMBER' => 26,
			"\${" => 37
		},
		GOTOS => {
			'sterm' => 257,
			'item' => 39,
			'node' => 23,
			'ident' => 77
		}
	},
	{#State 184
		ACTIONS => {
			'FINAL' => 258,
			'CATCH' => 260
		},
		DEFAULT => -73,
		GOTOS => {
			'final' => 259
		}
	},
	{#State 185
		ACTIONS => {
			"\"" => 263,
			'LITERAL' => 262,
			'NUMBER' => 261
		}
	},
	{#State 186
		DEFAULT => -96
	},
	{#State 187
		DEFAULT => -97
	},
	{#State 188
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'template' => 264,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 72,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 189
		DEFAULT => -124
	},
	{#State 190
		DEFAULT => -125
	},
	{#State 191
		ACTIONS => {
			";" => 265
		}
	},
	{#State 192
		DEFAULT => -88
	},
	{#State 193
		ACTIONS => {
			";" => -149,
			"+" => 156,
			'LITERAL' => -149,
			'IDENT' => -149,
			'CAT' => 162,
			"\$" => -149,
			'CMPOP' => 163,
			"?" => 157,
			'DIV' => 158,
			'MOD' => 164,
			'COMMA' => -149,
			"/" => 165,
			'AND' => 159,
			'BINOP' => 160,
			'OR' => 161,
			"\${" => -149
		},
		DEFAULT => -27
	},
	{#State 194
		DEFAULT => -91
	},
	{#State 195
		DEFAULT => -90
	},
	{#State 196
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 57,
			'IDENT' => 266,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 149,
			'sterm' => 68,
			'item' => 39,
			'assign' => 148,
			'margs' => 267,
			'node' => 23,
			'ident' => 147,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 197
		ACTIONS => {
			"+" => 156,
			'CAT' => 162,
			'CMPOP' => 163,
			"?" => 157,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165,
			'AND' => 159,
			'BINOP' => 160,
			'OR' => 161
		},
		DEFAULT => -27
	},
	{#State 198
		ACTIONS => {
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 268,
			'lterm' => 56
		}
	},
	{#State 199
		ACTIONS => {
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 269,
			'lterm' => 56
		}
	},
	{#State 200
		ACTIONS => {
			"{" => 30,
			'COMMA' => 256,
			'LITERAL' => 254,
			'IDENT' => 2,
			"\"" => 60,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		DEFAULT => -65,
		GOTOS => {
			'sterm' => 68,
			'item' => 252,
			'param' => 253,
			'node' => 23,
			'ident' => 251,
			'term' => 255,
			'lterm' => 56
		}
	},
	{#State 201
		DEFAULT => -57,
		GOTOS => {
			'@1-3' => 270
		}
	},
	{#State 202
		ACTIONS => {
			"\"" => 89,
			"\$" => 86,
			'LITERAL' => 88,
			'FILENAME' => 83,
			'IDENT' => 81,
			'NUMBER' => 84
		},
		GOTOS => {
			'filepart' => 87,
			'names' => 91,
			'nameargs' => 271,
			'filename' => 85,
			'name' => 82
		}
	},
	{#State 203
		ACTIONS => {
			'ASSIGN' => -131
		},
		DEFAULT => -129
	},
	{#State 204
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 272,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 205
		ACTIONS => {
			"\"" => 273,
			'TEXT' => 229,
			";" => 231,
			"\$" => 42,
			'IDENT' => 2,
			"\${" => 37
		},
		GOTOS => {
			'item' => 39,
			'node' => 23,
			'ident' => 228,
			'quotable' => 230
		}
	},
	{#State 206
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 274,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 207
		DEFAULT => -107
	},
	{#State 208
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 275,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 209
		DEFAULT => -119
	},
	{#State 210
		DEFAULT => -120
	},
	{#State 211
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 276,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 212
		DEFAULT => -75,
		GOTOS => {
			'@3-3' => 277
		}
	},
	{#State 213
		DEFAULT => -130
	},
	{#State 214
		ACTIONS => {
			"{" => 30,
			'COMMA' => 256,
			'LITERAL' => 254,
			'IDENT' => 2,
			"\"" => 60,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			")" => 278,
			"\${" => 37
		},
		GOTOS => {
			'sterm' => 68,
			'item' => 252,
			'param' => 253,
			'node' => 23,
			'ident' => 251,
			'term' => 255,
			'lterm' => 56
		}
	},
	{#State 215
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 279,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 216
		ACTIONS => {
			'CMPOP' => 163,
			"?" => 157,
			"+" => 156,
			'MOD' => 164,
			'DIV' => 158,
			"/" => 165,
			'AND' => 159,
			'CAT' => 162,
			'BINOP' => 160,
			'OR' => 161
		},
		DEFAULT => -48
	},
	{#State 217
		DEFAULT => -59
	},
	{#State 218
		DEFAULT => -80
	},
	{#State 219
		ACTIONS => {
			'CMPOP' => 163,
			"?" => 157,
			"+" => 156,
			'MOD' => 164,
			'DIV' => 158,
			"/" => 165,
			'AND' => 159,
			'CAT' => 162,
			'BINOP' => 160,
			'OR' => 161
		},
		DEFAULT => -46
	},
	{#State 220
		DEFAULT => -67
	},
	{#State 221
		ACTIONS => {
			'CMPOP' => 163,
			"?" => 157,
			"+" => 156,
			'MOD' => 164,
			'DIV' => 158,
			"/" => 165,
			'AND' => 159,
			'CAT' => 162,
			'BINOP' => 160,
			'OR' => 161
		},
		DEFAULT => -62
	},
	{#State 222
		DEFAULT => -143
	},
	{#State 223
		DEFAULT => -144
	},
	{#State 224
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 280,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 225
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 281,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 226
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 282,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 227
		ACTIONS => {
			"+" => 156,
			'CAT' => 162,
			'CMPOP' => 163,
			"?" => 157,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165,
			'AND' => 159,
			'BINOP' => 160,
			'OR' => 161
		},
		DEFAULT => -150
	},
	{#State 228
		ACTIONS => {
			'DOT' => 103
		},
		DEFAULT => -176
	},
	{#State 229
		DEFAULT => -177
	},
	{#State 230
		DEFAULT => -174
	},
	{#State 231
		DEFAULT => -178
	},
	{#State 232
		DEFAULT => -110
	},
	{#State 233
		ACTIONS => {
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165
		},
		DEFAULT => -134
	},
	{#State 234
		ACTIONS => {
			":" => 283,
			'CMPOP' => 163,
			"?" => 157,
			"+" => 156,
			'MOD' => 164,
			'DIV' => 158,
			"/" => 165,
			'AND' => 159,
			'CAT' => 162,
			'BINOP' => 160,
			'OR' => 161
		}
	},
	{#State 235
		ACTIONS => {
			'MOD' => 164
		},
		DEFAULT => -135
	},
	{#State 236
		ACTIONS => {
			"+" => 156,
			'CAT' => 162,
			'CMPOP' => 163,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165,
			'BINOP' => 160
		},
		DEFAULT => -139
	},
	{#State 237
		ACTIONS => {
			"+" => 156,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165
		},
		DEFAULT => -132
	},
	{#State 238
		ACTIONS => {
			"+" => 156,
			'CAT' => 162,
			'CMPOP' => 163,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165,
			'BINOP' => 160
		},
		DEFAULT => -140
	},
	{#State 239
		ACTIONS => {
			"+" => 156,
			'CMPOP' => 163,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165,
			'BINOP' => 160
		},
		DEFAULT => -138
	},
	{#State 240
		ACTIONS => {
			"+" => 156,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165,
			'BINOP' => 160
		},
		DEFAULT => -137
	},
	{#State 241
		DEFAULT => -136
	},
	{#State 242
		ACTIONS => {
			'DIV' => 158,
			'MOD' => 164
		},
		DEFAULT => -133
	},
	{#State 243
		DEFAULT => -60,
		GOTOS => {
			'@2-3' => 284
		}
	},
	{#State 244
		ACTIONS => {
			"+" => 156,
			'CAT' => 162,
			'CMPOP' => 163,
			"?" => 157,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165,
			'AND' => 159,
			'BINOP' => 160,
			'OR' => 161
		},
		DEFAULT => -149
	},
	{#State 245
		ACTIONS => {
			'ELSIF' => 287,
			'ELSE' => 285
		},
		DEFAULT => -51,
		GOTOS => {
			'else' => 286
		}
	},
	{#State 246
		DEFAULT => -169
	},
	{#State 247
		ACTIONS => {
			'LITERAL' => 254,
			'IDENT' => 2,
			"\"" => 60,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"{" => 30,
			'COMMA' => 256,
			"\${" => 37
		},
		DEFAULT => -161,
		GOTOS => {
			'sterm' => 68,
			'item' => 252,
			'param' => 253,
			'node' => 23,
			'ident' => 251,
			'term' => 255,
			'lterm' => 56
		}
	},
	{#State 248
		DEFAULT => -166
	},
	{#State 249
		DEFAULT => -164
	},
	{#State 250
		ACTIONS => {
			"{" => 30,
			'COMMA' => 256,
			'LITERAL' => 254,
			'IDENT' => 2,
			"\"" => 60,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			")" => 288,
			"\${" => 37
		},
		GOTOS => {
			'sterm' => 68,
			'item' => 252,
			'param' => 253,
			'node' => 23,
			'ident' => 251,
			'term' => 255,
			'lterm' => 56
		}
	},
	{#State 251
		ACTIONS => {
			'DOT' => 103,
			'ASSIGN' => 289
		},
		DEFAULT => -108
	},
	{#State 252
		ACTIONS => {
			"(" => 134,
			'ASSIGN' => 208
		},
		DEFAULT => -127
	},
	{#State 253
		DEFAULT => -152
	},
	{#State 254
		ACTIONS => {
			'ASSIGN' => 211
		},
		DEFAULT => -111
	},
	{#State 255
		DEFAULT => -151
	},
	{#State 256
		DEFAULT => -154
	},
	{#State 257
		DEFAULT => -116
	},
	{#State 258
		ACTIONS => {
			";" => 290
		}
	},
	{#State 259
		ACTIONS => {
			'END' => 291
		}
	},
	{#State 260
		ACTIONS => {
			";" => 293,
			'DEFAULT' => 294,
			'FILENAME' => 83,
			'IDENT' => 81,
			'NUMBER' => 84
		},
		GOTOS => {
			'filepart' => 87,
			'filename' => 292
		}
	},
	{#State 261
		DEFAULT => -101
	},
	{#State 262
		DEFAULT => -99
	},
	{#State 263
		ACTIONS => {
			'TEXT' => 295
		}
	},
	{#State 264
		ACTIONS => {
			'END' => 296
		}
	},
	{#State 265
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 297,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 266
		ACTIONS => {
			'IDENT' => -95,
			")" => -95,
			'COMMA' => -95
		},
		DEFAULT => -129
	},
	{#State 267
		ACTIONS => {
			'COMMA' => 300,
			'IDENT' => 298,
			")" => 299
		}
	},
	{#State 268
		DEFAULT => -155,
		GOTOS => {
			'args' => 301
		}
	},
	{#State 269
		DEFAULT => -155,
		GOTOS => {
			'args' => 302
		}
	},
	{#State 270
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 303,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 271
		DEFAULT => -156
	},
	{#State 272
		ACTIONS => {
			'END' => 304
		}
	},
	{#State 273
		ACTIONS => {
			'ASSIGN' => -159
		},
		DEFAULT => -166
	},
	{#State 274
		ACTIONS => {
			'END' => 305
		}
	},
	{#State 275
		ACTIONS => {
			"+" => 156,
			'CAT' => 162,
			'CMPOP' => 163,
			"?" => 157,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165,
			'AND' => 159,
			'BINOP' => 160,
			'OR' => 161
		},
		DEFAULT => -123
	},
	{#State 276
		ACTIONS => {
			"+" => 156,
			'CAT' => 162,
			'CMPOP' => 163,
			"?" => 157,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165,
			'AND' => 159,
			'BINOP' => 160,
			'OR' => 161
		},
		DEFAULT => -122
	},
	{#State 277
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 306,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 278
		DEFAULT => -128
	},
	{#State 279
		ACTIONS => {
			'ELSIF' => 287,
			'ELSE' => 285
		},
		DEFAULT => -51,
		GOTOS => {
			'else' => 307
		}
	},
	{#State 280
		ACTIONS => {
			'CASE' => 308
		},
		DEFAULT => -56,
		GOTOS => {
			'case' => 309
		}
	},
	{#State 281
		ACTIONS => {
			'END' => 310
		}
	},
	{#State 282
		ACTIONS => {
			'END' => 311
		}
	},
	{#State 283
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 312,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 284
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 313,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 285
		ACTIONS => {
			";" => 314
		}
	},
	{#State 286
		ACTIONS => {
			'END' => 315
		}
	},
	{#State 287
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 316,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 288
		DEFAULT => -163
	},
	{#State 289
		ACTIONS => {
			'NOT' => 38,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"(" => 52,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'expr' => 317,
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 58,
			'lterm' => 56
		}
	},
	{#State 290
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 318,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 291
		DEFAULT => -68
	},
	{#State 292
		ACTIONS => {
			'DOT' => 173,
			";" => 319
		}
	},
	{#State 293
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 320,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 294
		ACTIONS => {
			";" => 321
		}
	},
	{#State 295
		ACTIONS => {
			"\"" => 322
		}
	},
	{#State 296
		DEFAULT => -81
	},
	{#State 297
		ACTIONS => {
			'END' => 323
		}
	},
	{#State 298
		DEFAULT => -93
	},
	{#State 299
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			'FOR' => 21,
			'NEXT' => 22,
			'LITERAL' => 57,
			"\"" => 60,
			'PROCESS' => 61,
			'FILTER' => 25,
			'RETURN' => 64,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 191,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			"\${" => 37
		},
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'expr' => 197,
			'wrapper' => 45,
			'atomexpr' => 47,
			'atomdir' => 13,
			'mdir' => 324,
			'filter' => 29,
			'sterm' => 68,
			'ident' => 147,
			'setlist' => 70,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'directive' => 194,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 300
		DEFAULT => -94
	},
	{#State 301
		ACTIONS => {
			"{" => 30,
			'COMMA' => 256,
			'LITERAL' => 254,
			'IDENT' => 2,
			"\"" => 60,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		DEFAULT => -63,
		GOTOS => {
			'sterm' => 68,
			'item' => 252,
			'param' => 253,
			'node' => 23,
			'ident' => 251,
			'term' => 255,
			'lterm' => 56
		}
	},
	{#State 302
		ACTIONS => {
			"{" => 30,
			'COMMA' => 256,
			'LITERAL' => 254,
			'IDENT' => 2,
			"\"" => 60,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		DEFAULT => -64,
		GOTOS => {
			'sterm' => 68,
			'item' => 252,
			'param' => 253,
			'node' => 23,
			'ident' => 251,
			'term' => 255,
			'lterm' => 56
		}
	},
	{#State 303
		ACTIONS => {
			'END' => 325
		}
	},
	{#State 304
		DEFAULT => -79
	},
	{#State 305
		DEFAULT => -87
	},
	{#State 306
		ACTIONS => {
			'END' => 326
		}
	},
	{#State 307
		ACTIONS => {
			'END' => 327
		}
	},
	{#State 308
		ACTIONS => {
			";" => 328,
			'DEFAULT' => 330,
			"{" => 30,
			'LITERAL' => 78,
			'IDENT' => 2,
			"\"" => 60,
			"\$" => 42,
			"[" => 10,
			'NUMBER' => 26,
			'REF' => 27,
			"\${" => 37
		},
		GOTOS => {
			'sterm' => 68,
			'item' => 39,
			'node' => 23,
			'ident' => 77,
			'term' => 329,
			'lterm' => 56
		}
	},
	{#State 309
		ACTIONS => {
			'END' => 331
		}
	},
	{#State 310
		DEFAULT => -78
	},
	{#State 311
		DEFAULT => -66
	},
	{#State 312
		ACTIONS => {
			"+" => 156,
			'CAT' => 162,
			'CMPOP' => 163,
			"?" => 157,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165,
			'AND' => 159,
			'BINOP' => 160,
			'OR' => 161
		},
		DEFAULT => -142
	},
	{#State 313
		ACTIONS => {
			'END' => 332
		}
	},
	{#State 314
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 333,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 315
		DEFAULT => -47
	},
	{#State 316
		ACTIONS => {
			'CMPOP' => 163,
			"?" => 157,
			";" => 334,
			"+" => 156,
			'MOD' => 164,
			'DIV' => 158,
			"/" => 165,
			'AND' => 159,
			'CAT' => 162,
			'BINOP' => 160,
			'OR' => 161
		}
	},
	{#State 317
		ACTIONS => {
			"+" => 156,
			'CAT' => 162,
			'CMPOP' => 163,
			"?" => 157,
			'DIV' => 158,
			'MOD' => 164,
			"/" => 165,
			'AND' => 159,
			'BINOP' => 160,
			'OR' => 161
		},
		DEFAULT => -153
	},
	{#State 318
		DEFAULT => -72
	},
	{#State 319
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 335,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 320
		ACTIONS => {
			'FINAL' => 258,
			'CATCH' => 260
		},
		DEFAULT => -73,
		GOTOS => {
			'final' => 336
		}
	},
	{#State 321
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 337,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 322
		DEFAULT => -100
	},
	{#State 323
		DEFAULT => -92
	},
	{#State 324
		DEFAULT => -89
	},
	{#State 325
		DEFAULT => -58
	},
	{#State 326
		DEFAULT => -76
	},
	{#State 327
		DEFAULT => -45
	},
	{#State 328
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 338,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 329
		ACTIONS => {
			";" => 339
		}
	},
	{#State 330
		ACTIONS => {
			";" => 340
		}
	},
	{#State 331
		DEFAULT => -52
	},
	{#State 332
		DEFAULT => -61
	},
	{#State 333
		DEFAULT => -50
	},
	{#State 334
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 341,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 335
		ACTIONS => {
			'FINAL' => 258,
			'CATCH' => 260
		},
		DEFAULT => -73,
		GOTOS => {
			'final' => 342
		}
	},
	{#State 336
		DEFAULT => -71
	},
	{#State 337
		ACTIONS => {
			'FINAL' => 258,
			'CATCH' => 260
		},
		DEFAULT => -73,
		GOTOS => {
			'final' => 343
		}
	},
	{#State 338
		DEFAULT => -55
	},
	{#State 339
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 344,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 340
		ACTIONS => {
			'SET' => 1,
			'NOT' => 38,
			'IDENT' => 2,
			'CLEAR' => 40,
			'UNLESS' => 4,
			'IF' => 43,
			"\$" => 42,
			'STOP' => 7,
			'CALL' => 44,
			'THROW' => 9,
			'GET' => 46,
			"[" => 10,
			'TRY' => 11,
			'LAST' => 48,
			'DEBUG' => 50,
			'META' => 15,
			'INCLUDE' => 17,
			"(" => 52,
			'SWITCH' => 53,
			'MACRO' => 18,
			'JAVASCRIPT' => 54,
			'WRAPPER' => 55,
			";" => -18,
			'FOR' => 21,
			'LITERAL' => 57,
			'NEXT' => 22,
			'rawperl' => 59,
			"\"" => 60,
			'TEXT' => 24,
			'PROCESS' => 61,
			'RETURN' => 64,
			'FILTER' => 25,
			'INSERT' => 65,
			'NUMBER' => 26,
			'REF' => 27,
			'WHILE' => 67,
			'BLOCK' => 28,
			'DEFAULT' => 69,
			"{" => 30,
			'perl' => 31,
			'USE' => 32,
			'VIEW' => 36,
			"\${" => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 39,
			'javascript' => 3,
			'node' => 23,
			'term' => 58,
			'loop' => 5,
			'use' => 63,
			'expr' => 62,
			'capture' => 41,
			'statement' => 6,
			'view' => 8,
			'wrapper' => 45,
			'atomexpr' => 47,
			'chunk' => 12,
			'defblock' => 66,
			'atomdir' => 13,
			'anonblock' => 49,
			'sterm' => 68,
			'defblockname' => 14,
			'filter' => 29,
			'ident' => 16,
			'setlist' => 70,
			'chunks' => 33,
			'try' => 35,
			'switch' => 34,
			'assign' => 19,
			'block' => 345,
			'directive' => 71,
			'macro' => 20,
			'condition' => 73,
			'lterm' => 56
		}
	},
	{#State 341
		ACTIONS => {
			'ELSIF' => 287,
			'ELSE' => 285
		},
		DEFAULT => -51,
		GOTOS => {
			'else' => 346
		}
	},
	{#State 342
		DEFAULT => -69
	},
	{#State 343
		DEFAULT => -70
	},
	{#State 344
		ACTIONS => {
			'CASE' => 308
		},
		DEFAULT => -56,
		GOTOS => {
			'case' => 347
		}
	},
	{#State 345
		DEFAULT => -54
	},
	{#State 346
		DEFAULT => -49
	},
	{#State 347
		DEFAULT => -53
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 68 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 71 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 72 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 75 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
					if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 77 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 80 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2,
sub
#line 81 "Parser.yp"
{ return '' unless $_[1];
                           $_[0]->location() . $_[1];
                         }
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1,
sub
#line 94 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 17
		 'statement', 2,
sub
#line 95 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 18
		 'statement', 0, undef
	],
	[#Rule 19
		 'directive', 1,
sub
#line 99 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 20
		 'directive', 1, undef
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'directive', 1, undef
	],
	[#Rule 27
		 'atomexpr', 1,
sub
#line 114 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 28
		 'atomexpr', 1, undef
	],
	[#Rule 29
		 'atomdir', 2,
sub
#line 118 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 119 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 120 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 121 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 122 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 123 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 124 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 36
		 'atomdir', 2,
sub
#line 125 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 37
		 'atomdir', 1,
sub
#line 126 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 127 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 128 "Parser.yp"
{ $factory->clear()                   }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 129 "Parser.yp"
{ $factory->break()                   }
	],
	[#Rule 41
		 'atomdir', 1,
sub
#line 130 "Parser.yp"
{ $factory->next()                    }
	],
	[#Rule 42
		 'atomdir', 2,
sub
#line 131 "Parser.yp"
{ if ($_[2]->[0]->[0] =~ /^'(on|off)'$/) {
				          $_[0]->{ DEBUG_DIRS } = ($1 eq 'on');
					  $factory->debug($_[2]);
				      }
				      else {
					  $_[0]->{ DEBUG_DIRS } ? $factory->debug($_[2]) : '';
				      }
				    }
	],
	[#Rule 43
		 'atomdir', 1, undef
	],
	[#Rule 44
		 'atomdir', 1, undef
	],
	[#Rule 45
		 'condition', 6,
sub
#line 144 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 46
		 'condition', 3,
sub
#line 145 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 47
		 'condition', 6,
sub
#line 147 "Parser.yp"
{ $factory->if("!($_[2])", @_[4, 5])  }
	],
	[#Rule 48
		 'condition', 3,
sub
#line 148 "Parser.yp"
{ $factory->if("!($_[3])", $_[1])     }
	],
	[#Rule 49
		 'else', 5,
sub
#line 152 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
				      $_[5];                              }
	],
	[#Rule 50
		 'else', 3,
sub
#line 154 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 51
		 'else', 0,
sub
#line 155 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 52
		 'switch', 6,
sub
#line 159 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 53
		 'case', 5,
sub
#line 163 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
				      $_[5];                              }
	],
	[#Rule 54
		 'case', 4,
sub
#line 165 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 55
		 'case', 3,
sub
#line 166 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 56
		 'case', 0,
sub
#line 167 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 57
		 '@1-3', 0,
sub
#line 170 "Parser.yp"
{ $_[0]->{ INFOR }++                  }
	],
	[#Rule 58
		 'loop', 6,
sub
#line 171 "Parser.yp"
{ $_[0]->{ INFOR }--;
				      $factory->foreach(@{$_[2]}, $_[5])  }
	],
	[#Rule 59
		 'loop', 3,
sub
#line 175 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 60
		 '@2-3', 0,
sub
#line 176 "Parser.yp"
{ $_[0]->{ INWHILE }++                }
	],
	[#Rule 61
		 'loop', 6,
sub
#line 177 "Parser.yp"
{ $_[0]->{ INWHILE }--;
                                      $factory->while(@_[2, 5])           }
	],
	[#Rule 62
		 'loop', 3,
sub
#line 179 "Parser.yp"
{ $factory->while(@_[3, 1])           }
	],
	[#Rule 63
		 'loopvar', 4,
sub
#line 182 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 64
		 'loopvar', 4,
sub
#line 183 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 65
		 'loopvar', 2,
sub
#line 184 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 66
		 'wrapper', 5,
sub
#line 188 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 67
		 'wrapper', 3,
sub
#line 190 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 68
		 'try', 5,
sub
#line 194 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 69
		 'final', 5,
sub
#line 198 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
				      $_[5];                              }
	],
	[#Rule 70
		 'final', 5,
sub
#line 201 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
				      $_[5];                              }
	],
	[#Rule 71
		 'final', 4,
sub
#line 204 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
				      $_[4];                              }
	],
	[#Rule 72
		 'final', 3,
sub
#line 206 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 73
		 'final', 0,
sub
#line 207 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 74
		 'use', 2,
sub
#line 210 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 75
		 '@3-3', 0,
sub
#line 213 "Parser.yp"
{ $_[0]->push_defblock();		  }
	],
	[#Rule 76
		 'view', 6,
sub
#line 214 "Parser.yp"
{ $factory->view(@_[2,5], 
						     $_[0]->pop_defblock) }
	],
	[#Rule 77
		 '@4-2', 0,
sub
#line 218 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}++;             }
	],
	[#Rule 78
		 'javascript', 5,
sub
#line 219 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}--;
				      $_[0]->{ EVAL_JAVASCRIPT } 
				      ? $factory->javascript($_[4])             
				      : $factory->no_javascript();              }
	],
	[#Rule 79
		 'filter', 5,
sub
#line 226 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 80
		 'filter', 3,
sub
#line 228 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 81
		 'defblock', 5,
sub
#line 233 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
				      pop(@{ $_[0]->{ DEFBLOCKS } });
				      $_[0]->define_block($name, $_[4]); 
				      undef
				    }
	],
	[#Rule 82
		 'defblockname', 2,
sub
#line 240 "Parser.yp"
{ push(@{ $_[0]->{ DEFBLOCKS } }, $_[2]);
				      $_[2];
				    }
	],
	[#Rule 83
		 'blockname', 1, undef
	],
	[#Rule 84
		 'blockname', 1,
sub
#line 246 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 85
		 'blockargs', 1, undef
	],
	[#Rule 86
		 'blockargs', 0, undef
	],
	[#Rule 87
		 'anonblock', 5,
sub
#line 254 "Parser.yp"
{ local $" = ', ';
				      print STDERR "experimental block args: [@{ $_[2] }]\n"
					  if $_[2];
				      $factory->anon_block($_[4])         }
	],
	[#Rule 88
		 'capture', 3,
sub
#line 260 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 89
		 'macro', 6,
sub
#line 264 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 90
		 'macro', 3,
sub
#line 265 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 91
		 'mdir', 1, undef
	],
	[#Rule 92
		 'mdir', 4,
sub
#line 269 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 93
		 'margs', 2,
sub
#line 272 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 94
		 'margs', 2,
sub
#line 273 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 95
		 'margs', 1,
sub
#line 274 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 96
		 'metadata', 2,
sub
#line 277 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 97
		 'metadata', 2, undef
	],
	[#Rule 98
		 'metadata', 1, undef
	],
	[#Rule 99
		 'meta', 3,
sub
#line 282 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
						       s/\\'/'/g  }; 
					 [ @_[1,3] ] }
	],
	[#Rule 100
		 'meta', 5,
sub
#line 285 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 101
		 'meta', 3,
sub
#line 286 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 102
		 'term', 1, undef
	],
	[#Rule 103
		 'term', 1, undef
	],
	[#Rule 104
		 'lterm', 3,
sub
#line 298 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 105
		 'lterm', 3,
sub
#line 299 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 106
		 'lterm', 2,
sub
#line 300 "Parser.yp"
{ "[ ]"                               }
	],
	[#Rule 107
		 'lterm', 3,
sub
#line 301 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 108
		 'sterm', 1,
sub
#line 304 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 109
		 'sterm', 2,
sub
#line 305 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 110
		 'sterm', 3,
sub
#line 306 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 111
		 'sterm', 1, undef
	],
	[#Rule 112
		 'sterm', 1, undef
	],
	[#Rule 113
		 'list', 2,
sub
#line 311 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 114
		 'list', 2, undef
	],
	[#Rule 115
		 'list', 1, undef
	],
	[#Rule 116
		 'range', 3,
sub
#line 316 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 117
		 'hash', 1, undef
	],
	[#Rule 118
		 'hash', 0,
sub
#line 321 "Parser.yp"
{ "" }
	],
	[#Rule 119
		 'params', 2,
sub
#line 324 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 120
		 'params', 2, undef
	],
	[#Rule 121
		 'params', 1, undef
	],
	[#Rule 122
		 'param', 3,
sub
#line 329 "Parser.yp"
{ "$_[1]: $_[3]"                    }
	],
	[#Rule 123
		 'param', 3,
sub
#line 330 "Parser.yp"
{ "$_[1]: $_[3]"                    }
	],
	[#Rule 124
		 'ident', 3,
sub
#line 333 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 125
		 'ident', 3,
sub
#line 334 "Parser.yp"
{ push(@{$_[1]}, 
					   map {($_, 0)} split(/\./, $_[3]));
				      $_[1];			          }
	],
	[#Rule 126
		 'ident', 1, undef
	],
	[#Rule 127
		 'node', 1,
sub
#line 340 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 128
		 'node', 4,
sub
#line 341 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 129
		 'item', 1,
sub
#line 344 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 130
		 'item', 3,
sub
#line 345 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 131
		 'item', 2,
sub
#line 346 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
				       ? "'$_[2]'" 
				       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 132
		 'expr', 3,
sub
#line 351 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 133
		 'expr', 3,
sub
#line 352 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 353 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 354 "Parser.yp"
{ "int($_[1] / $_[3])"                }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 355 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 137
		 'expr', 3,
sub
#line 356 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 138
		 'expr', 3,
sub
#line 357 "Parser.yp"
{ "$_[1]  + $_[3]"                    }
	],
	[#Rule 139
		 'expr', 3,
sub
#line 358 "Parser.yp"
{ "$_[1] && $_[3]"                    }
	],
	[#Rule 140
		 'expr', 3,
sub
#line 359 "Parser.yp"
{ "$_[1] || $_[3]"                    }
	],
	[#Rule 141
		 'expr', 2,
sub
#line 360 "Parser.yp"
{ "! $_[2]"                           }
	],
	[#Rule 142
		 'expr', 5,
sub
#line 361 "Parser.yp"
{ "$_[1] ? $_[3] : $_[5]"             }
	],
	[#Rule 143
		 'expr', 3,
sub
#line 362 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 144
		 'expr', 3,
sub
#line 363 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 145
		 'expr', 1, undef
	],
	[#Rule 146
		 'setlist', 2,
sub
#line 367 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 147
		 'setlist', 2, undef
	],
	[#Rule 148
		 'setlist', 1, undef
	],
	[#Rule 149
		 'assign', 3,
sub
#line 373 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 150
		 'assign', 3,
sub
#line 374 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 151
		 'args', 2,
sub
#line 381 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 152
		 'args', 2,
sub
#line 382 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 153
		 'args', 4,
sub
#line 383 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
				      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 154
		 'args', 2,
sub
#line 385 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 155
		 'args', 0,
sub
#line 386 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 156
		 'lnameargs', 3,
sub
#line 396 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 157
		 'lnameargs', 1, undef
	],
	[#Rule 158
		 'lvalue', 1, undef
	],
	[#Rule 159
		 'lvalue', 3,
sub
#line 401 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 160
		 'lvalue', 1, undef
	],
	[#Rule 161
		 'nameargs', 3,
sub
#line 405 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 162
		 'nameargs', 2,
sub
#line 406 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 163
		 'nameargs', 4,
sub
#line 407 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 164
		 'names', 3,
sub
#line 410 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 165
		 'names', 1,
sub
#line 411 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 166
		 'name', 3,
sub
#line 414 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 167
		 'name', 1,
sub
#line 415 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 168
		 'name', 1, undef
	],
	[#Rule 169
		 'filename', 3,
sub
#line 427 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 170
		 'filename', 1, undef
	],
	[#Rule 171
		 'filepart', 1, undef
	],
	[#Rule 172
		 'filepart', 1, undef
	],
	[#Rule 173
		 'filepart', 1, undef
	],
	[#Rule 174
		 'quoted', 2,
sub
#line 441 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
				          if defined $_[2]; $_[1]         }
	],
	[#Rule 175
		 'quoted', 0,
sub
#line 443 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 176
		 'quotable', 1,
sub
#line 446 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 177
		 'quotable', 1,
sub
#line 447 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 178
		 'quotable', 1,
sub
#line 448 "Parser.yp"
{ undef                               }
	]
];

1;
