use strict;

mkdir('lc', 0777);

my @c = (
    grep {$_ ne '\\c['} (map {chr($_)} (0x20..0x7E, 0xA1..0xDF)),
);

my $script = "lc\\lc.pl";
open(SCRIPT,">$script") || die "Can't open file: $script\n";

#----------------------------------------------------------------------------
# lc
#----------------------------------------------------------------------------

for my $c (@c) {
    if ($c =~ /^['\\]$/) {
        print SCRIPT "\$_ = '\\", $c, "'; print lc, \"\\n\";\n";
    }
    else {
        print SCRIPT "\$_ = '", $c, "'; print lc, \"\\n\";\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "\$_ = '", chr($c1), chr($c2), "'; print lc, \"\\n\";\n";
    }
}

#----------------------------------------------------------------------------
# lc $_
#----------------------------------------------------------------------------

for my $c (@c) {
    if ($c =~ /^['\\]$/) {
        print SCRIPT "\$_ = '\\", $c, "'; print lc \$_, \"\\n\";\n";
    }
    else {
        print SCRIPT "\$_ = '", $c, "'; print lc \$_, \"\\n\";\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "\$_ = '", chr($c1), chr($c2), "'; print lc \$_, \"\\n\";\n";
    }
}

#----------------------------------------------------------------------------
# lc($_)
#----------------------------------------------------------------------------

for my $c (@c) {
    if ($c =~ /^['\\]$/) {
        print SCRIPT "\$_ = '\\", $c, "'; print lc(\$_), \"\\n\";\n";
    }
    else {
        print SCRIPT "\$_ = '", $c, "'; print lc(\$_), \"\\n\";\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "\$_ = '", chr($c1), chr($c2), "'; print lc(\$_), \"\\n\";\n";
    }
}

#----------------------------------------------------------------------------
# lc $_, 'A', 'B', 'C'
#----------------------------------------------------------------------------

for my $c (@c) {
    if ($c =~ /^['\\]$/) {
        print SCRIPT "\$_ = '\\", $c, "'; print lc \$_, 'A', 'B', 'C'; print \"\\n\";\n";
    }
    else {
        print SCRIPT "\$_ = '", $c, "'; print lc \$_, 'A', 'B', 'C'; print \"\\n\";\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "\$_ = '", chr($c1), chr($c2), "'; print lc \$_, 'A', 'B', 'C'; print \"\\n\";\n";
    }
}

#----------------------------------------------------------------------------
# lc '*'
#----------------------------------------------------------------------------

for my $c (@c) {
    if ($c =~ /^['\\]$/) {
        print SCRIPT "print lc '\\", $c, "', \"\\n\";\n";
    }
    else {
        print SCRIPT "print lc '", $c, "', \"\\n\";\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "print lc '", chr($c1), chr($c2), "', \"\\n\";\n";
    }
}

#----------------------------------------------------------------------------
# lc('*')
#----------------------------------------------------------------------------

for my $c (@c) {
    if ($c =~ /^['\\]$/) {
        print SCRIPT "print lc('\\", $c, "'), \"\\n\";\n";
    }
    else {
        print SCRIPT "print lc('", $c, "'), \"\\n\";\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "print lc('", chr($c1), chr($c2), "'), \"\\n\";\n";
    }
}

#----------------------------------------------------------------------------
# lc '*', 'A', 'B', 'C'
#----------------------------------------------------------------------------

for my $c (@c) {
    if ($c =~ /^['\\]$/) {
        print SCRIPT "print lc '\\", $c, "', 'A', 'B', 'C'; print \"\\n\";\n";
    }
    else {
        print SCRIPT "print lc '", $c, "', 'A', 'B', 'C'; print \"\\n\";\n";
    }
}

for my $c1 (0x81..0x9F, 0xE0..0xFC) {
    for my $c2 (0x40..0x7E, 0x80..0xFC) {
        print SCRIPT "print lc '", chr($c1), chr($c2), "', 'A', 'B', 'C'; print \"\\n\";\n";
    }
}

close(SCRIPT);

#----------------------------------------------------------------------------
