/* 	$Id: pperl.h,v 1.3 1996/03/08 23:10:47 ilya Exp $	 */
#include "EXTERN.h"
#include <perl.h>
#include <Lang.h>

#include "tkPort.h"
#include "tkVMacro.h"

#define LangDouble(sv) SvNV((SV*)sv)
#define LangInt(sv) ((int)SvIV((SV*)sv))
#define LangLong(sv) ((long)SvIV((SV*)sv))
#define LangIsList(arg) (SvROK((SV*)arg) && SvTYPE(SvRV((SV*)arg)) == SVt_PVAV)

typedef struct ListFactory {
  AV* av;
  struct ListFactory *parent;
  struct ListFactory *child;		/* To simplify macros only. */
} ListFactory;

#define ListFactoryInit(lfPtr) ((lfPtr)->av = newAV(), \
				(lfPtr)->parent = NULL,  \
				(lfPtr)->child = NULL)
#define ListFactoryFinish(lfPtr)
#define ListFactoryFree(lfPtr) (SvREFCNT_dec((SV*)(lfPtr)->av))
#define ListFactoryArg(lfPtr) ((Arg)(lfPtr)->av)
#define ListFactoryAppend(lfPtr,arg) \
	av_push((lfPtr)->av, SvREFCNT_inc((SV*)(arg))) 
#define ListFactoryAppendCopy(lfPtr,arg) \
	ListFactoryAppend((lfPtr),newSVsv((SV*)arg))
#define ListFactoryAppendCopyWithType(lfPtr,arg,type)		\
	ListFactoryAppend((lfPtr), 				\
			  (type) ?				\
			  sv_bless(newRV(newSVsv((SV*)arg)),	\
				   gv_stashpv(type, TRUE)) :	\
			  newSVsv((SV*)arg))
#define ListFactoryAppendList(lfPtr,arg) \
	do {   AV *av = (AV*)(arg); \
	       int i, l; \
	       if (SvROK(av)) av = (AV*)SvRV((SV*)av); \
	       l = av_len(av); \
	       for (i=0;i <= l;i++) { \
		 ListFactoryAppend((lfPtr), \
				   newSVsv((SV*)*av_fetch(av,i,0))); \
	       } \
	    } while (0)
#define ListFactoryNewLevel(lfPtr) ( \
        (lfPtr)->child = malloc(sizeof(ListFactory)), \
        ListFactoryInit((lfPtr)->child), \
	(lfPtr)->child->parent = (lfPtr), \
	av_push((lfPtr)->av, newRV((SV*)(lfPtr)->child->av)),\
	SvREFCNT_dec((SV*)(lfPtr)->child->av), \
	(lfPtr)->child)
#define ListFactoryNewLevelWithType(lfPtr,type) ( \
        (lfPtr)->child = malloc(sizeof(ListFactory)), \
        ListFactoryInit((lfPtr)->child), \
	(lfPtr)->child->parent = (lfPtr), \
	av_push((lfPtr)->av, sv_bless(newRV((SV*)(lfPtr)->child->av),	\
				      gv_stashpv(type, TRUE))),\
	SvREFCNT_dec((SV*)(lfPtr)->child->av), \
	(lfPtr)->child)
#define ListFactoryEndLevel(lfPtr) ((lfPtr) = (lfPtr)->parent, \
	free((lfPtr)->child), lfPtr)
#define ListFactoryEndLevelWithType ListFactoryEndLevel
#define ListFactoryResult(interpr,lfPtr) \
	Tcl_AppendArg((interpr), ListFactoryArg(lfPtr))

/* These guys were not discussed yet. */

#define LangNewArg(argPtr, freeProcPtr) ( \
	*(argPtr) = (Arg)newSV(0), *(freeProcPtr) = NULL)
#define LangSetBuffer(argPtr,buffer)
#define dArgBuffer char argBuffer_
#define LangSetDefaultBuffer(argPtr)
#define LANG_DYNAMIC TCL_DYNAMIC


int LangArgEval _ANSI_ARGS_ ((Tcl_Interp *interp, Arg av));

#if 0
int 
LangArgEval(interp, av)
     Tcl_Interp *interp;
     Arg av;
{
  dSP;
  int count = 0;
  SV *sv = sv_2mortal(newSVpv("receive",0));
  SV **cvp = (SvTYPE((AV*)av) == SVt_PVAV) ? av_fetch((AV*)av, 0, 0) 
						: (SV**)&av;
  SV *cv = cvp ? *cvp: (SV*)av;		/* To delegate error report. */
  int argc = (SvTYPE((AV*)(av)) == SVt_PVAV) ? 
    av_len((AV*)av) : 0;		/* Length - 1. */
  int i = 0;

  ENTER;
  SAVETMPS;
  PUSHMARK(sp);
  EXTEND(sp,argc);
  while (i < argc) {
    PUSHs(sv_mortalcopy(*av_fetch((AV*)av, ++i, 0)));
  }
  PUTBACK;
  count = perl_call_sv(cv, G_ARRAY | G_EVAL);
  SetTclResult(interp,count);
  FREETMPS;
  LEAVE;
  return Check_Eval(interp);
}
#endif

/* Obsolete now:
 * Arg Tcl_ResultArg _ANSI_ARGS_((Tcl_Interp *interp));
 */

/* Move this to tkGlue.c
Arg
Tcl_ResultArg(interp)
     Tcl_Interp *interp;
{
  return (Arg) ResultAV(interp,"Tcl_ResultArg",1);
}
*/
