/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.File;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.server.log.LoggingOptions;
import org.openqa.selenium.server.SslCertificateGenerator;

public class RemoteControlConfiguration {
    public static final String KEY = String.valueOf(RemoteControlConfiguration.class.getName()) + ".config";
    public static final int DEFAULT_PORT = 4444;
    private static final int USE_SAME_PORT = -1;
    public static final int MINUTES = 60;
    public static final int DEFAULT_TIMEOUT_IN_SECONDS = 1800;
    public static final int DEFAULT_RETRY_TIMEOUT_IN_SECONDS = 10;
    private int port = RemoteControlConfiguration.getDefaultPort();
    private File profilesLocation = null;
    private boolean proxyInjectionModeArg = false;
    private int portDriversShouldContact = -1;
    private boolean htmlSuite;
    private boolean selfTest;
    private File selfTestDir;
    private boolean interactive;
    private File userExtensions;
    private boolean userJSInjection;
    private boolean trustAllSSLCertificates;
    private String debugURL = "";
    private String dontInjectRegex = null;
    private File firefoxProfileTemplate = null;
    private boolean reuseBrowserSessions;
    private String forcedBrowserMode;
    private boolean honorSystemProxy;
    private int timeoutInSeconds = 1800;
    private int browserTimeoutInMs;
    private int retryTimeoutInSeconds = 10;
    private LoggingOptions loggingOptions = new LoggingOptions();
    private boolean ensureCleanSession;
    private boolean avoidProxy;
    private boolean debugMode;
    private boolean browserSideLogEnabled;
    private int jettyThreads = 512;
    private SslCertificateGenerator sslCertGenerator;
    private boolean singleWindow;

    public int getPort() {
        return this.port;
    }

    public void setPort(int newPortNumber) {
        this.port = newPortNumber;
    }

    public boolean isSingleWindow() {
        return this.singleWindow;
    }

    public void setSingleWindow(boolean useSingleWindow) {
        this.singleWindow = useSingleWindow;
    }

    public File getProfilesLocation() {
        return this.profilesLocation;
    }

    public void setProfilesLocation(File profilesLocation) {
        this.profilesLocation = profilesLocation;
    }

    public void setProxyInjectionModeArg(boolean proxyInjectionModeArg) {
        this.proxyInjectionModeArg = proxyInjectionModeArg;
    }

    public boolean getProxyInjectionModeArg() {
        return this.proxyInjectionModeArg;
    }

    public void setPortDriversShouldContact(int newPortDriversShouldContact) {
        this.portDriversShouldContact = newPortDriversShouldContact;
    }

    public int getPortDriversShouldContact() {
        if (-1 == this.portDriversShouldContact) {
            return this.port;
        }
        return this.portDriversShouldContact;
    }

    public void setHTMLSuite(boolean isHTMLSuite) {
        this.htmlSuite = isHTMLSuite;
    }

    public boolean isHTMLSuite() {
        return this.htmlSuite;
    }

    public boolean isSelfTest() {
        return this.selfTest;
    }

    public void setSelfTest(boolean isSelftest) {
        this.selfTest = isSelftest;
    }

    public void setSelfTestDir(File newSelfTestDir) {
        this.selfTestDir = newSelfTestDir;
    }

    public File getSelfTestDir() {
        return this.selfTestDir;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean isInteractive) {
        this.interactive = isInteractive;
    }

    public File getUserExtensions() {
        return this.userExtensions;
    }

    public void setUserExtensions(File newuserExtensions) {
        this.userExtensions = newuserExtensions;
    }

    public boolean userJSInjection() {
        return this.userJSInjection;
    }

    public void setUserJSInjection(boolean useUserJSInjection) {
        this.userJSInjection = useUserJSInjection;
    }

    public void setTrustAllSSLCertificates(boolean trustAllSSLCertificates) {
        this.trustAllSSLCertificates = trustAllSSLCertificates;
    }

    public boolean trustAllSSLCertificates() {
        return this.trustAllSSLCertificates;
    }

    public String getDebugURL() {
        return this.debugURL;
    }

    public void setDebugURL(String newDebugURL) {
        this.debugURL = newDebugURL;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setDontInjectRegex(String newdontInjectRegex) {
        this.dontInjectRegex = newdontInjectRegex;
    }

    public String getDontInjectRegex() {
        return this.dontInjectRegex;
    }

    public File getFirefoxProfileTemplate() {
        return this.firefoxProfileTemplate;
    }

    public void setFirefoxProfileTemplate(File newFirefoxProfileTemplate) {
        this.firefoxProfileTemplate = newFirefoxProfileTemplate;
    }

    public void setReuseBrowserSessions(boolean reuseBrowserSessions) {
        this.reuseBrowserSessions = reuseBrowserSessions;
    }

    public boolean reuseBrowserSessions() {
        return this.reuseBrowserSessions;
    }

    public void setCaptureLogsOnQuit(boolean captureLogs) {
        this.loggingOptions.setCaptureLogsOnQuit(captureLogs);
    }

    public boolean isCaptureOfLogsOnQuitEnabled() {
        return this.loggingOptions.isCaptureOfLogsOnQuitEnabled();
    }

    public void setLogOutFileName(String newLogOutFileName) {
        this.loggingOptions.setLogOutFileName(newLogOutFileName);
    }

    public String getLogOutFileName() {
        return this.loggingOptions.getLogOutFileName();
    }

    public void setLogOutFile(File newLogOutFile) {
        this.loggingOptions.setLogOutFile(newLogOutFile);
    }

    public File getLogOutFile() {
        return this.loggingOptions.getLogOutFile();
    }

    public void setForcedBrowserMode(String newForcedBrowserMode) {
        this.forcedBrowserMode = newForcedBrowserMode;
    }

    public String getForcedBrowserMode() {
        return this.forcedBrowserMode;
    }

    public static int getDefaultPort() {
        String portProperty = System.getProperty("selenium.port", "4444");
        if (portProperty == null) {
            return 4444;
        }
        return Integer.parseInt(portProperty);
    }

    public boolean honorSystemProxy() {
        return this.honorSystemProxy;
    }

    public void setHonorSystemProxy(boolean willHonorSystemProxy) {
        this.honorSystemProxy = willHonorSystemProxy;
    }

    public boolean shouldOverrideSystemProxy() {
        return !this.honorSystemProxy;
    }

    public long getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public long getTimeoutInMs() {
        return this.timeoutInSeconds * 1000;
    }

    public void setTimeoutInSeconds(int newTimeoutInSeconds) {
        this.timeoutInSeconds = newTimeoutInSeconds;
    }

    public int getBrowserTimeoutInMs() {
        return this.browserTimeoutInMs;
    }

    public void setBrowserTimeoutInMs(int browserTimeoutInMs) {
        this.browserTimeoutInMs = browserTimeoutInMs;
    }

    public int getRetryTimeoutInSeconds() {
        return this.retryTimeoutInSeconds;
    }

    public void setRetryTimeoutInSeconds(int newRetryTimeoutInSeconds) {
        this.retryTimeoutInSeconds = newRetryTimeoutInSeconds;
    }

    public boolean dontTouchLogging() {
        return this.loggingOptions.dontTouchLogging();
    }

    public void setDontTouchLogging(boolean newValue) {
        this.loggingOptions.setDontTouchLogging(newValue);
    }

    public int shortTermMemoryLoggerCapacity() {
        return this.loggingOptions.shortTermMemoryLoggerCapacity();
    }

    public boolean isEnsureCleanSession() {
        return this.ensureCleanSession;
    }

    public void setEnsureCleanSession(boolean value) {
        this.ensureCleanSession = value;
    }

    public boolean isAvoidProxy() {
        return this.avoidProxy;
    }

    public void setAvoidProxy(boolean value) {
        this.avoidProxy = value;
    }

    public boolean isBrowserSideLogEnabled() {
        return this.browserSideLogEnabled;
    }

    public void setBrowserSideLogEnabled(boolean value) {
        this.browserSideLogEnabled = value;
    }

    public int getJettyThreads() {
        return this.jettyThreads;
    }

    public void setJettyThreads(int jettyThreads) {
        if (jettyThreads < 1 || jettyThreads > 1024) {
            throw new IllegalArgumentException("Number of jetty threads specified as an argument must be greater than zero and less than 1024");
        }
        this.jettyThreads = jettyThreads;
    }

    public SslCertificateGenerator getSslCertificateGenerator() {
        return this.sslCertGenerator;
    }

    public void setSeleniumServer(SslCertificateGenerator server) {
        this.sslCertGenerator = server;
    }

    public Capabilities copySettingsIntoBrowserOptions(Capabilities source) {
        DesiredCapabilities capabilities = new DesiredCapabilities(source);
        this.setSafely(capabilities, "timeoutInSeconds", this.timeoutInSeconds);
        this.setSafely(capabilities, "honorSystemProxy", this.honorSystemProxy);
        this.setSafely(capabilities, "firefoxProfileTemplate", this.firefoxProfileTemplate);
        this.setSafely(capabilities, "dontInjectRegex", this.dontInjectRegex);
        this.setSafely(capabilities, "trustAllSSLCertificates", this.trustAllSSLCertificates);
        this.setSafely(capabilities, "userJSInjection", this.userJSInjection);
        this.setSafely(capabilities, "userExtensions", this.userExtensions);
        this.setSafely(capabilities, "proxyInjectionMode", this.proxyInjectionModeArg);
        this.setSafely(capabilities, "singleWindow", this.singleWindow);
        this.setSafely(capabilities, "ensureCleanSession", this.ensureCleanSession);
        this.setSafely(capabilities, "avoidProxy", this.avoidProxy);
        this.setSafely(capabilities, "browserSideLog", this.browserSideLogEnabled);
        return capabilities;
    }

    private void setSafely(DesiredCapabilities caps, String key, Object value) {
        if (value == null || caps.getCapability(key) != null) {
            return;
        }
        caps.setCapability(key, value);
    }

    public LoggingOptions getLoggingOptions() {
        return this.loggingOptions;
    }
}

