#!perl

use strict;
use utf8;
use Test::More tests => 9;
eval 'use Test::XPath';
plan skip_all => 'Test::XPath required for this test' if $@;

BEGIN { use_ok('Map::Tube::Glasgow') || print "Bail out!\n"; }

my $map = Map::Tube::Glasgow->new();
isa_ok($map, 'Map::Tube::Glasgow');

my $tx = Test::XPath->new( file => $map->xml() );
$tx->ok( '/tube', 'There should be a <tube> tag at top level' );
$tx->ok( '/tube/stations', 'There should be a <stations> tag directly under the top level' );
$tx->cmp_ok( 'count(/tube/stations/station)', '>', 5, 'There should be many <station> tags' );
$tx->ok( '/tube/stations/station/@id', 'The <station> tag should have an id' );
$tx->ok( '/tube/stations/station/@name', 'The <station> tag should have a name' );
$tx->ok( '/tube/stations/station/@line', 'The <station> tag should have a line' );
$tx->ok( '/tube/stations/station/@link', 'The <station> tag should have a link' );

