package App::Manoc::Form::Types;
#ABSTRACT: Manoc form types
use strict;
use warnings;

our $VERSION = '2.99.3'; ##TRIAL VERSION

use MooseX::Types -declare => [ 'MacAddress', ];

use MooseX::Types::Moose ( 'Str', 'Num', 'Int' );

use App::Manoc::Utils qw(normalize_mac_addr);



subtype MacAddress, as Str, where {
    /^[0-9a-f]{2}:[0-9a-f]{2}:[0-9a-f]{2}:[0-9a-f]{2}:[0-9a-f]{2}:[0-9a-f]{2}$/
}, message { "Not a valid mac address in aa:bb:cc:dd:ff format" };

coerce MacAddress, from Str, via {
    return normalize_mac_addr($_);
};

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Form::Types - Manoc form types

=head1 VERSION

version 2.99.3

=head1 DESCRIPTION

Inspired by HTML::FormHandler::Types

=head1 Type Constraints

These types check the value and issue an error message.

=head2 MacAddress

A valid mac address in aa-bb-cc-dd-ee format. Other format like
aaaa-bbbb-cccc are automatically converted.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
