package Audio::Ecasound::Multitrack::Wav;
our $VERSION = 1.0;
our @ISA; 
use Audio::Ecasound::Multitrack::Object qw(name active dir);
use warnings;
use Audio::Ecasound::Multitrack::Assign qw(:all);
use Memoize qw(memoize unmemoize);
no warnings qw(uninitialized);
use Carp;
memoize('candidates');

sub get_versions {
	$Audio::Ecasound::Multitrack::debug2 and print "&get_versions\n";
	my $wav = shift; # Expects a Track object here
	my $basename = $wav->name;
	my $dir = Audio::Ecasound::Multitrack::this_wav_dir();
	$debug and print "this_wav_dir: $dir\n";
	$debug and print '$wav->dir', $wav->dir; # indirectly this_wav_dir
	my ($sep, $ext) = qw( _ wav );
	$debug and print "getver: dir $dir basename $basename sep $sep ext $ext\n\n";
	my %versions = ();
	for my $candidate ( candidates($dir) ) {
		$debug and print "candidate: $candidate\n\n";
		$candidate =~ m/^ ( $basename 
		   ($sep (\d+))? 
		   \.$ext )
		   $/x or next;
		$debug and print "match: $1,  num: $3\n\n";
		$versions{ $3 ? $3 : 'bare' } =  $1 ;
	}
	$debug and print "get_version: " , Audio::Ecasound::Multitrack::yaml_out(\%versions);
	%versions;
}

sub candidates {
	my $dir = shift;
	$dir =  File::Spec::Link->resolve_all( $dir );
	$debug and print "reading directory: $dir\n\n";
	opendir(WD,$dir) or carp ("can't read directory $dir: $!");
	my @candidates = readdir WD;
	closedir WD;
	@candidates = grep{ ! (-s join_path($dir, $_) == 44 ) } @candidates;
	#$debug and print join $/, @candidates;
	@candidates;
}

sub targets {# takes a Wav object 
	
	my $wav = shift; 
 	#my $name=  ref $wav ? $wav->name: $wav;
 	my $name =  $wav->name;
	my $dir = $wav->dir;
	$Audio::Ecasound::Multitrack::debug2 and print "&targets\n";
	
	$debug and print "this_wav_dir: $dir, name: $name\n";
		my %versions =  $wav->get_versions;
		if ($versions{bare}) {  $versions{1} = $versions{bare}; 
			delete $versions{bare};
		}
	$debug and print "\%versions\n================\n", yaml_out(\%versions);
	\%versions;
}
sub versions {  # takes a Wav object or a string (filename)
	$Audio::Ecasound::Multitrack::debug2 and print "&versions\n";
	my $wav = shift;
	[ sort { $a <=> $b } keys %{ $wav->targets} ]  
}

sub last { 
	my $wav = shift;
	pop @{ $wav->versions} }

