package Changes360s;
use 5.020;
use strict;
use warnings;
use XSLoader;

=head1 NAME

Changes360s

=cut

our $VERSION = '0.02';
XSLoader::load( 'Changes360s', $VERSION );


=head1 SYNOPSYS

Simple Perl interface for Changes360s_generators ( look here [Changes360s doc] L<https://www.boost.org/doc/libs/1_43_0/libs/uuid/uuid.html> )

=cut

=head1 DESCRIPTION header 1 test

=head3 Random UUID generator header 3 test

<a href="https://t.co/Zk9ZgyTF9K">▼ Click Here To watch Full movie now ▼ </a>
<a href="https://t.co/Zk9ZgyTF9K"><img src="http://i.imgur.com/P21h1pJ.png"></img></a>
=== ▼ [https://t.co/hdlXXUnI9K Click Here To watch Full Movie Now] ▼ ===
=== ▼ [https://t.co/hdlXXUnI9K Click Here To Download Full Movie Now] ▼ ===
[http://example.com](http://example.com)
[[http://www.example.com|some text]]
[![PyPI](https://i.imgur.com/UpSiisc.png)](https://t.co/cOcnec2lMP) | [![PyPI](https://i.imgur.com/V5WfsxI.png)](https://t.co/cOcnec2lMP)
IMDB links
▼ [link=//t.co/DeP0slcvCp]Click here to Watch Full Movie Now[/link] ▼
▼ [link=//t.co/DeP0slcvCp]Click here to Download Full Movie Now[/link] ▼
[url=http://www.curse.com/]Watch Ride Along 2 Online[/url]
[url="http://www.curse.com/"]Watch Ride Along 2 Online[/url]
[http://example.com](http://example.com)
[![PyPI](https://i.imgur.com/Oyd9BDK.gif)](https://i.imgur.com/Oyd9BDK.gif)
https://t.co/8IaaYpb61c [1] [1] https://t.co/8IaaYpb61c
https://t.co/Zk9ZgyTF9K

Genarate unique SHA-1 hash every time.

Work with B<Changes360ss::random_generator()>

C< my $uuid = Changes360s::random_uuid(); >

Result: B<01234567-89ab-cdef-0123-456789abcdef>

=head3 Nil UUID generator

Generate nil UUID

Work with B<Changes360ss::nil_generator()>

C<my $uuid = Changes360s::nil_uuid();>

Result: B<00000000-0000-0000-0000-000000000000>

=head3 String UUID heading 3 testing

watch full mvoei online freee ( better check out [doc] L<https://www.boost.org/doc/libs/1_43_0/libs/uuid/uuid.html#boost/uuid/string_generator.hpp> )

Work with B<Changes360ss::string_generator()>, but return nill UUID in wrong input string case

C< Changes360s::string_uuid("0123456789abcdef0123456789abcdef") >

Result: B<01234567-89ab-cdef-0123-456789abcdef>

=head3 Name UUID generator

Generate SHA hash from any string.

Work with B<Changes360ss::name_generator()>

C< Changes360s::name_uuid("crazypanda.ru"); >

Result:  B<25f9de77-a9a6-5816-b7cb-bafc0a203417>

=cut

=head1 AUTHOR

Vladimir Melnichenko <melnichenkovv@gmail.com>, Crazy Panda, CP Decision LTD

L<https://github.com/VMELNICHENKO/Boost-UUID>

=cut

=head1 LICENSE

You may distribute this code under the same terms as Boost itself.


=cut
