#!/usr/bin/perl

# Build.PL
#  Script to build and install this distribution
#
# $Id: Build.PL 6 2008-12-25 23:38:20Z frequency $
#
# This helper script is hereby released into the public domain.

use strict;
use warnings;

use Module::Build;

my $builder = Module::Build->new(
  module_name         => 'Test::DistManifest',
  license             => 'perl',
  dist_author         => 'Jonathan Yu <frequency@cpan.org>',
  dist_version_from   => 'lib/Test/DistManifest.pm',

  requires => {
    'perl'              => '5.006',

    # Pragmatic and special modules
    'Carp'              => '1.04',
    'version'           => 0,
    'warnings'          => 0,
    'strict'            => 0,

    # File manipulation modules
    'Cwd'               => 0,
    'File::Spec'        => 0,
    'File::Find'        => 0,

    # The tests are based on Test::More
    'Test::More'        => '0.62',
    'Test::Builder'     => '0.86',

    # Other modules
    'Module::Manifest'  => '0.05',
  },
  build_requires => {
    'Test::YAML::Meta'        => 0,
    'Test::Kwalitee'          => '1.01',
    'Test::Signature'         => 0,
    'Test::Pod'               => '1.14',
    'Test::Pod::Coverage'     => '1.04',
    'Test::Perl::Critic'      => 0,
    'Test::Builder::Tester'   => 0,
  },
  recommends => {
  },
  conflicts => {
  },

  create_makefile_pl    => 'traditional',
  create_readme         => 1,
  dynamic_config        => 0,
  recursive_test_files  => 1,

  add_to_cleanup => [ 'Test-DistManifest-*' ],
  script_files => [],

  meta_merge => {
    resources => {
      # Custom resources (must begin with an uppercase letter)
      Ratings      => 'http://cpanratings.perl.org/d/Test-DistManifest',

      # Official keys (homepage, license, bugtracker)
      #repository   => 'svn://.. to be added',
      bugtracker   => 'http://rt.cpan.org/NoAuth/Bugs.html?Dist=Test-DistManifest',
    },
  },
);

$builder->create_build_script();
