# This file was automatically generated by SWIG
package GPC;

use vars qw($VERSION);
$VERSION = '1.01';

=pod

=head1 NAME

GPC - Perl wrapper for Alan Murta's gpc library

=head1 SYNOPSIS

use GPC;

=head1 Description

This module is just a wrapper around the gpc C library written by Alan Murta

gpc: General Polygon Clipping library (C) 1997-1999, Advanced Interfaces Group,
University of Manchester.

Please refer to the gpc manual for more details on gpc.

=head1 Methods

The available methods are:

=head2 Helper functions to access integer arrays

=over 4

=item *  GPC::int_array

=item *  GPC::int_destroy

=item *  GPC::int_set

=item *  GPC::int_get

=back

=head2 Helper functions to access vertex arrays

=over 4

=item * GPC::gpc_vertex_array

=item * GPC::gpc_vertex_destroy

=item * GPC::gpc_vertex_set

=item * GPC::gpc_vertex_get

=back

=head2 Helper functions to access vertex lists (arrays of vertex arrays)

=over 4

=item * GPC::gpc_vertex_list_array

=item * GPC::gpc_vertex_list_destroy

=item * GPC::gpc_vertex_list_set

=item * GPC::gpc_vertex_list_get

=back

=head2 vertex structure functions

=over 4

=item * GPC::gpc_vertex_x_set

=item * GPC::gpc_vertex_x_get

=item * GPC::gpc_vertex_y_set

=item * GPC::gpc_vertex_y_get

=item * GPC::new_gpc_vertex

=item * GPC::delete_gpc_vertex

=back

=head2 vertex list structure functions

=over 4

=item * GPC::gpc_vertex_list_num_vertices_set

=item * GPC::gpc_vertex_list_num_vertices_get

=item * GPC::gpc_vertex_list_vertex_set

=item * GPC::gpc_vertex_list_vertex_get

=item * GPC::new_gpc_vertex_list

=item * GPC::delete_gpc_vertex_list

=back

=head2 polygon structure functions

=over 4

=item * GPC::gpc_polygon_num_contours_set

=item * GPC::gpc_polygon_num_contours_get

=item * GPC::gpc_polygon_hole_set

=item * GPC::gpc_polygon_hole_get

=item * GPC::gpc_polygon_contour_set

=item * GPC::gpc_polygon_contour_get

=item * GPC::new_gpc_polygon

=item * GPC::delete_gpc_polygon

=back

=head2 tristrip structure functions

=over 4

=item * GPC::gpc_tristrip_num_strips_set

=item * GPC::gpc_tristrip_num_strips_get

=item * GPC::gpc_tristrip_strip_set

=item * GPC::gpc_tristrip_strip_get

=item * GPC::new_gpc_tristrip

=item * GPC::delete_gpc_tristrip

=back

=head2 gpc routines

=over 4

=item * GPC::gpc_read_polygon

=item * GPC::gpc_write_polygon

=item * GPC::gpc_add_contour

=item * GPC::gpc_polygon_clip

=item * GPC::gpc_tristrip_clip

=item * GPC::gpc_polygon_to_tristrip

=item * GPC::gpc_free_polygon

=item * GPC::gpc_free_tristrip

=back

=cut

require Exporter;
require DynaLoader;
@ISA = qw(Exporter DynaLoader);
package GPC;
bootstrap GPC;
package GPC;
@EXPORT = qw( );
# {"GPC::fopen", _wrap_fopen},
# {"GPC::fclose", _wrap_fclose},
1;
