use utf8;
use strict;
use warnings;

package Number::Phone::FR::Full;

our $VERSION;
BEGIN {
    $VERSION = '0.0611350';
}

use Number::Phone::FR;

use parent 'Number::Phone::FR';
use Scalar::Util 'blessed';

sub RE_0() {
    qr/(?:(?:5(?:9(?:0(?:4[0-24-8]|5[0-26-9]|[289][0-9]|0[2-5]|1[0-3]|6[0189]|3[28]|7[07])|4(?:3[0-57-9]|2[0-2457-9]|4[3-9]|6[0-3]|9[0147]|5[7-9]|[18]0)|6(?:4[024-8]|3[05-9]|[56][0-9]|9[4-8]|0[2-5]|8[09]|[12]0|7[0-9]))|0(?:0(?:6[24-9]|[57][7-9]|1[0-35]|3[0-3]|4[04]|[89]0|0[0-9])|(?:9[0-6]|6[0-9])[0-9]|1(?:6[0-26]|5[0-9]|23|44|76)|7(?:[0-6][0-9]|80)|5(?:9[0-2469]|55|80)|4(?:0[135]|41)|8(?:5[05]|41)|3(?:05|66)|244)|3(?:2(?:0[0-46-9]|3[0-2]|8[018]|1[0-9]|20)|3(?:[0-689][0-9]|7[0-8])|4[0-9][0-9]|[15][0-9][0-9])|6(?:4(?:4[0-4]|[0189][0-9]|7[6-9]|33|64)|[1-35][0-9][0-9]|7[0-9][0-9])|1(?:9(?:2[0-8]|7[0-6]|[013-6][0-9]|8[08]|99)|[67][0-9][0-9])|8(?:6(?:1[0-5]|6[5-9]|7[0-3]|0[0-9])|[127][0-9][0-9])|79(?:[0-79][0-9]|8[0-8])|4(?:[24-69][0-9][0-9]|[07][0-9][0-9])|5[35-9][0-9][0-9]|24[0-9][0-9])|4(?:0(?:0(?:1[0-6]|6[3-9]|7[05-9]|[04][0-9]|[389]0|59)|1(?:6[0-6]|5[0-9]|00|23|44|76)|4(?:0[03-5]|4[1-3]|[89]0|66)|8(?:[0-7][0-9]|8[0-2])|3(?:1[36]|44|66)|5(?:7[78]|44|66)|2(?:6[5-7]|44)|[67][0-9][0-9]|9(?:40|88|99))|8(?:4(?:4[0-578]|8[024-68]|[0-36][0-9]|50|76|98)|5(?:2[0-8]|[01][0-9]|8[08]|[46]4|38)|0(?:[0-8][0-9]|9[02-9])|9(?:[0-24-9][0-9]|3[014-9])|[1-368][0-9][0-9]|799)|2(?:2(?:1[0-8]|4[2-4]|2[23]|0[0-9]|32|55|84)|0(?:[1-4]0|9[45]|0[0-9]|55|61|88)|8(?:2[0-3]|[01][0-9])|[67][0-9][0-9])|4(?:3(?:[0-79][0-9]|8[0-24-9])|4(?:0[0-2]|44|88)|2[0-9][0-9]|80[01])|1(?:1(?:[02-9][0-9]|1[0-79])|5(?:[0-3][0-9]|5[0-2]|40)|3[0-9][0-9])|5(?:(?:(?:6[0-9]|80)|7[0-9])[0-9]|0[0-9][0-9])|3(?:[278][0-9][0-9]|[04][0-9][0-9])|6(?:[6-8][0-9][0-9]|[39][0-9][0-9])|[79][0-9][0-9][0-9])|2(?:0(?:0(?:0[0-35-9]|3[034]|7[089]|4[04]|[18]0|57|66)|1(?:6[0-36]|5[0-9]|23|44|76)|4(?:0[1-4]|1[12]|44|56)|2(?:6[236]|[89]0|44)|8(?:[01][0-9]|80)|[67][0-9][0-9]|9(?:[67]1|55)|344)|4(?:6(?:7[0-8]|[0-6][0-9]|8[02489]|90)|5(?:[0-24-9][0-9]|3[1-9])|9(?:[0-79][0-9]|8[0-8])|[01378][0-9][0-9]|4[0-9][0-9])|5(?:2(?:9[0-7]|8[4689]|[0-2][0-9]|4[248]|7[236]|3[01]|62)|7(?:[0-4][0-9]|8[489]|9[0-2]|5[01]|7[56])|[14][0-9][0-9]|[036][0-9][0-9])|6(?:2(?:7[0-57]|[2-59][0-9]|6[26-9]|1[0679]|0[126]|8[089])|1(?:6[0-7]|[0-5][0-9]|88)|9(?:6[0-4]|5[01]|80))|7(?:8(?:[0-8][0-9]|9[0-58])|[267][0-9][0-9])|1(?:4(?:[0-8][0-9]|9[0-35-9])|8[0-9][0-9])|3(?:[1-3578][0-9][0-9]|[046][0-9][0-9])|2(?:[37-9][0-9][0-9]|2[0-9][0-9])|9(?:[6-9][0-9][0-9]|0[0-9][0-9])|85[0-9][0-9])|6(?:9(?:3(?:4[0-7]|9[0-47]|0[0-4]|[13][03]|8[0-3]|[25-7]0)|0(?:[07][0-7]|8[0-8]|[1-69][0-9])|4(?:[04][0-7]|1[0-6]|3[018]|[29][0-9])|6(?:[0-47-9][0-9]|5[0-2]|6[01])|[589][0-9][0-9]|2[0-9][0-9])|3(?:9(?:0[03-79]|6[015-9]|9[04-7]|1[019]|[457]0|3[09]|2[0-9])|6(?:[5-9][0-9]|[0-4][0-9])|8(?:[1-9][0-9]|00)|[0-57][0-9][0-9])|4(?:9(?:[0-46-8][0-9]|[59][0-9])|(?:[235-8][0-9]|4[0-9])[0-9]|0(?:[1-9][0-9]|0[0-9])|1(?:[0-57-9][0-9]|6[0-9]))|0(?:0(?:[0-36-9][0-9]|4[1-5]|5[1-4])|(?:[137-9][0-9]|[245][0-9])[0-9]|6(?:[0-4][0-9]|[5-9][0-9]))|5(?:6(?:[0-57-9][0-9]|6[016-9])|(?:[0-2457-9][0-9]|3[0-9])[0-9])|(?:6(?:[0-8][0-9]|9[0-9])|[1278][0-9][0-9])[0-9])|3(?:7(?:2(?:[0-3][0-9]|4[0-3]|5[057]|8[238]|7[23]|63|92)|3(?:4[0-6]|[0-3][0-9]|8[089]|7[23]|9[89])|0(?:[0-79][0-9]|8[1-9])|1(?:[0-79][0-9]|8[0-57-9])|4(?:0[0-3]|10))|0(?:1(?:6[0-367]|5[0-9]|00|23|44|76)|0(?:4[04]|[08]0|33|54|66)|3(?:6[78]|[89]0|16|44)|8(?:[01][0-9]|8[01])|4(?:0[1-4]|4[12])|[67][0-9][0-9]|2(?:00|44)|9(?:88|99))|6(?:7(?:1[0-79]|2[0-4]|7[67]|8[48]|0[0-9]|67)|5(?:1[0-689]|8[0-7]|[02-7][0-9])|8(?:[0-79][0-9]|8[0-8])|[0-469][0-9][0-9])|5(?:2(?:0[013-9]|[1-6][0-9]|8[0-248]|70|92)|7(?:[0-689][0-9]|7[0-689])|[14589][0-9][0-9])|39(?:8[028]|[01][0-9]|2[01]|90)|(?:[28][0-9]|9[01])[0-9][0-9]|4(?:4[0-9][0-9]|5[0-9][0-9])|10[0-9][0-9])|9(?:7(?:4(?:0[1-9]|8[0-689]|4[0-6]|7[135-9]|5[0-5]|1[5-9]|[236][0-9]|91)|6(?:[06][1-9]|1[0-357]|7[0-367]|3[0-37]|5[0-2]|2[27]|4[17]|9[0-9])|1(?:5[0-35-9]|[2-4689][0-9]|1[0-5]|0[0-2]|7[013])|7(?:5[0-46-9]|8[0-79]|[0134679][0-9]|2[0-2])|0(?:2[03-9]|[013-589][0-9]|6[0-5]|7[0579])|8(?:0[0-5]|2[0-3]|4[0-2]|7[0-9]|35|97)|3(?:8[24-7]|3[0-24]|0[0-2]|[45][0-9]|73)|9(?:[0-8][0-9]|9[0-24-79])|2(?:[1-69][0-9]|0[09]|72)|5[0-9][0-9])|8(?:0(?:[12][0-9]|[3-8]0|0[018]|98)|8(?:2[0-2]|9[089]|8[0-9]|11|66|77)|2(?:[2-6][0-9]|1[01]|82|98)|7(?:[28]7|65|98)|1[0-9][0-9]|6(?:86|98)|31[1-4]|[45]98|9[0-9][0-9])|00(?:3[0-3]|[0-2][0-9]|65|94)|[56][0-9][0-9][0-9])|1(?:0(?:1(?:0[0-6]|2[1-489]|6[0-46]|9[02-4]|[348]0|7[67]|5[0-9])|4(?:0[124-8]|4[0-3]|8[1-4]|7[12]|66)|8(?:[0-3][0-9]|8[01]|66|92)|3(?:1[367]|0[03]|33|66)|2(?:[02][01]|6[06]|80)|9(?:8[18]|9[19]|66|77)|[5-7][0-9][0-9]|0[0-9][0-9])|8(?:4(?:[39][0-7]|5[0-4]|[0-24][0-9]|8[0489]|6[01])|1(?:[0-57-9][0-9]|6[02-9])|[023][0-9][0-9])|4(?:8(?:[02-57-9][0-9]|[16][0-9])|9(?:[0-689][0-9]|7[0-9])|[0-7][0-9][0-9])|(?:(?:5[035-8]|6[0149]|3[049]|9[01])[0-9]|24[12])[0-9]|7(?:1(?:[1-8][0-9]|[09][0-9])|[02-9][0-9][0-9]))|7(?:5(?:0(?:[1-489][0-9]|[056][0-9]|70)|7(?:[018]7|[56][0-9]|7[78])|5(?:6[6-9]|5[0-9])|1[0-6][0-9]|20[01]|432)|8(?:(?:8[0-5]|7[0-9]|00)[0-9]|6(?:[1-9][0-9]|0[0-9]))|6(?:0(?:[1-9][0-9]|0[0-9])|[1-4][0-9][0-9])|7(?:[78][0-9]|0[0-9])[0-9]))[0-9]|8(?:(?:9(?:1(?:3[0235-9]|5[014-79]|0[0-47]|2[02-6]|6[025-79]|1[12468]|4[3-68]|7[017-9]|8[049]|9[279])|9(?:1[0-79]|9[02-46-9]|6[0235689]|7[015-9]|3[023689]|5[04-79]|8[017-9]|4[0469]|[02][0-9])|0(?:0[0-48]|5[04-8]|6[0-24-6]|8[014-69]|2[02-5]|7[01578]|9[0-257]|3[2369]|4[246]|12)|7(?:7[0-24-9]|0[0-5]|1[023689]|2[1-49]|5[4-79]|3[27-9]|6[2569]|9[0379]|4[469]|89)|3(?:7[0137-9]|3[0-269]|0[1246]|5[5-79]|9[0359]|1[168]|2[346]|6[25]|8[47]|46)|8(?:0[0-248]|7[0-258]|6[0256]|8[0369]|2[034]|1[69]|3[29]|4[06]|5[67]|98)|2(?:[57][0-24-9]|1[0-689]|[02-469][0-9]|8[0-2489]))|2(?:5(?:6[0-35-9]|2[0-24-689]|5[0-69]|1[0-6]|4[0457-9]|7[0-2457]|9[024579]|[038][0-9])|6(?:0[0-689]|5[0-35-79]|4[0-6]|8[0-24-68]|1[0-46]|2[0246-8]|9[05-7]|[367][0-9])|1(?:4[013-9]|8[02-9]|3[01346-8]|5[0-57]|2[0-35]|6[1256]|7[0457]|[019][0-9])|0(?:6[0-69]|[79][02457]|4[0-58]|5[03-8]|[0-38][0-9]))|6(?:0(?:0[0-24-79]|1[0-25-9]|4[0-24-7]|9[0-469]|6[0-2458]|7[014589]|8[0246-8]|3[0378]|5[0179]|2[268])|8(?:3[02389]|4[0-26]|9[0-29]|7[089]|8[468]|0[17]|5[27]|6[08]|11|22))|4(?:0(?:3[013-9]|4[0-4]|[0-2][0-9]|5[045]|6[046]|7[06]|8[16]|90)|2(?:1[0-46-9]|5[457-9]|3[346]|[02][0-9]|6[68]|7[06]|9[07]|44)|1(?:0[013-5]|1[01]|4[12])|3(?:0[0-389]|99))|1(?:1(?:6[0-79]|7[0-24-9]|5[0-35-79]|[0-489][0-9])|9(?:0[25]|1[09])|0[0-9][0-9])|5(?:0[0-2469]|5[05]|8[58]|28|40|66)[0-9]|8428)[0-9]|0(?:(?:5(?:4[0-79]|9[0-35-9]|3[02-8]|5[0-7]|6[0235-79]|7[0135-7]|8[01568]|[0-2][0-9])|9(?:0[0-368]|1[023]|3[268]|[489]0|54)|(?:3[038]|0[0-9])[0-9]|1(?:6[39]|86))[0-9]|880[0135-9])|36(?:(?:0[1-35-9]|2[4-9]|4[37-9]|5[49]|6[02])[0-9]|7(?:[35][0-9]|47))))[0-9][0-9][0-9]/
}

sub RE_SUBSCRIBER() {
    qr/\A(?:(3(?:9(?:3[02-9]|9[0-689]|1[02-689]|2[0-24-69]|7[0-3579]|4[014589]|8[017-9]|5[059]|6[069]|0[0-9])|2(?:4[0-689]|5[0-24-9]|8[0-689]|6[024-9]|9[02-689]|0[0-9]|1[0-9]|2[0-9]|3[0-9]|7[0-9])|6(?:6[0-689]|5[0-24-8]|4[0-25-79]|9[024-69]|7[026-8]|8[068]|0[0-9]|1[0-9]|2[0-9]|3[0-9])|0(?:0[0-469]|2[02356]|8[0679]|1[058]|3[036]|[467]0|5[58]|9[09])|1(?:1[02-47]|0[0136]|3[0-3]|2[023]|50|88)))|(?:(?:3651)?(?:[047-9]|16(?:1[0-57-9]|2[1-357]|3[03578]|5[04679]|6[04-6]|4[04]|9[09]|03|70))|(?:00|\+)33)((?:(?:5(?:9(?:0(?:4[0-24-8]|5[0-26-9]|[289][0-9]|0[2-5]|1[0-3]|6[0189]|3[28]|7[07])|4(?:3[0-57-9]|2[0-2457-9]|4[3-9]|6[0-3]|9[0147]|5[7-9]|[18]0)|6(?:4[024-8]|3[05-9]|[56][0-9]|9[4-8]|0[2-5]|8[09]|[12]0|7[0-9]))|0(?:0(?:6[24-9]|[57][7-9]|1[0-35]|3[0-3]|4[04]|[89]0|0[0-9])|(?:9[0-6]|6[0-9])[0-9]|1(?:6[0-26]|5[0-9]|23|44|76)|7(?:[0-6][0-9]|80)|5(?:9[0-2469]|55|80)|4(?:0[135]|41)|8(?:5[05]|41)|3(?:05|66)|244)|3(?:2(?:0[0-46-9]|3[0-2]|8[018]|1[0-9]|20)|3(?:[0-689][0-9]|7[0-8])|4[0-9][0-9]|[15][0-9][0-9])|6(?:4(?:4[0-4]|[0189][0-9]|7[6-9]|33|64)|[1-35][0-9][0-9]|7[0-9][0-9])|1(?:9(?:2[0-8]|7[0-6]|[013-6][0-9]|8[08]|99)|[67][0-9][0-9])|8(?:6(?:1[0-5]|6[5-9]|7[0-3]|0[0-9])|[127][0-9][0-9])|79(?:[0-79][0-9]|8[0-8])|4(?:[24-69][0-9][0-9]|[07][0-9][0-9])|5[35-9][0-9][0-9]|24[0-9][0-9])|4(?:0(?:0(?:1[0-6]|6[3-9]|7[05-9]|[04][0-9]|[389]0|59)|1(?:6[0-6]|5[0-9]|00|23|44|76)|4(?:0[03-5]|4[1-3]|[89]0|66)|8(?:[0-7][0-9]|8[0-2])|3(?:1[36]|44|66)|5(?:7[78]|44|66)|2(?:6[5-7]|44)|[67][0-9][0-9]|9(?:40|88|99))|8(?:4(?:4[0-578]|8[024-68]|[0-36][0-9]|50|76|98)|5(?:2[0-8]|[01][0-9]|8[08]|[46]4|38)|0(?:[0-8][0-9]|9[02-9])|9(?:[0-24-9][0-9]|3[014-9])|[1-368][0-9][0-9]|799)|2(?:2(?:1[0-8]|4[2-4]|2[23]|0[0-9]|32|55|84)|0(?:[1-4]0|9[45]|0[0-9]|55|61|88)|8(?:2[0-3]|[01][0-9])|[67][0-9][0-9])|4(?:3(?:[0-79][0-9]|8[0-24-9])|4(?:0[0-2]|44|88)|2[0-9][0-9]|80[01])|1(?:1(?:[02-9][0-9]|1[0-79])|5(?:[0-3][0-9]|5[0-2]|40)|3[0-9][0-9])|5(?:(?:(?:6[0-9]|80)|7[0-9])[0-9]|0[0-9][0-9])|3(?:[278][0-9][0-9]|[04][0-9][0-9])|6(?:[6-8][0-9][0-9]|[39][0-9][0-9])|[79][0-9][0-9][0-9])|2(?:0(?:0(?:0[0-35-9]|3[034]|7[089]|4[04]|[18]0|57|66)|1(?:6[0-36]|5[0-9]|23|44|76)|4(?:0[1-4]|1[12]|44|56)|2(?:6[236]|[89]0|44)|8(?:[01][0-9]|80)|[67][0-9][0-9]|9(?:[67]1|55)|344)|4(?:6(?:7[0-8]|[0-6][0-9]|8[02489]|90)|5(?:[0-24-9][0-9]|3[1-9])|9(?:[0-79][0-9]|8[0-8])|[01378][0-9][0-9]|4[0-9][0-9])|5(?:2(?:9[0-7]|8[4689]|[0-2][0-9]|4[248]|7[236]|3[01]|62)|7(?:[0-4][0-9]|8[489]|9[0-2]|5[01]|7[56])|[14][0-9][0-9]|[036][0-9][0-9])|6(?:2(?:7[0-57]|[2-59][0-9]|6[26-9]|1[0679]|0[126]|8[089])|1(?:6[0-7]|[0-5][0-9]|88)|9(?:6[0-4]|5[01]|80))|7(?:8(?:[0-8][0-9]|9[0-58])|[267][0-9][0-9])|1(?:4(?:[0-8][0-9]|9[0-35-9])|8[0-9][0-9])|3(?:[1-3578][0-9][0-9]|[046][0-9][0-9])|2(?:[37-9][0-9][0-9]|2[0-9][0-9])|9(?:[6-9][0-9][0-9]|0[0-9][0-9])|85[0-9][0-9])|6(?:9(?:3(?:4[0-7]|9[0-47]|0[0-4]|[13][03]|8[0-3]|[25-7]0)|0(?:[07][0-7]|8[0-8]|[1-69][0-9])|4(?:[04][0-7]|1[0-6]|3[018]|[29][0-9])|6(?:[0-47-9][0-9]|5[0-2]|6[01])|[589][0-9][0-9]|2[0-9][0-9])|3(?:9(?:0[03-79]|6[015-9]|9[04-7]|1[019]|[457]0|3[09]|2[0-9])|6(?:[5-9][0-9]|[0-4][0-9])|8(?:[1-9][0-9]|00)|[0-57][0-9][0-9])|4(?:9(?:[0-46-8][0-9]|[59][0-9])|(?:[235-8][0-9]|4[0-9])[0-9]|0(?:[1-9][0-9]|0[0-9])|1(?:[0-57-9][0-9]|6[0-9]))|0(?:0(?:[0-36-9][0-9]|4[1-5]|5[1-4])|(?:[137-9][0-9]|[245][0-9])[0-9]|6(?:[0-4][0-9]|[5-9][0-9]))|5(?:6(?:[0-57-9][0-9]|6[016-9])|(?:[0-2457-9][0-9]|3[0-9])[0-9])|(?:6(?:[0-8][0-9]|9[0-9])|[1278][0-9][0-9])[0-9])|3(?:7(?:2(?:[0-3][0-9]|4[0-3]|5[057]|8[238]|7[23]|63|92)|3(?:4[0-6]|[0-3][0-9]|8[089]|7[23]|9[89])|0(?:[0-79][0-9]|8[1-9])|1(?:[0-79][0-9]|8[0-57-9])|4(?:0[0-3]|10))|0(?:1(?:6[0-367]|5[0-9]|00|23|44|76)|0(?:4[04]|[08]0|33|54|66)|3(?:6[78]|[89]0|16|44)|8(?:[01][0-9]|8[01])|4(?:0[1-4]|4[12])|[67][0-9][0-9]|2(?:00|44)|9(?:88|99))|6(?:7(?:1[0-79]|2[0-4]|7[67]|8[48]|0[0-9]|67)|5(?:1[0-689]|8[0-7]|[02-7][0-9])|8(?:[0-79][0-9]|8[0-8])|[0-469][0-9][0-9])|5(?:2(?:0[013-9]|[1-6][0-9]|8[0-248]|70|92)|7(?:[0-689][0-9]|7[0-689])|[14589][0-9][0-9])|39(?:8[028]|[01][0-9]|2[01]|90)|(?:[28][0-9]|9[01])[0-9][0-9]|4(?:4[0-9][0-9]|5[0-9][0-9])|10[0-9][0-9])|9(?:7(?:4(?:0[1-9]|8[0-689]|4[0-6]|7[135-9]|5[0-5]|1[5-9]|[236][0-9]|91)|6(?:[06][1-9]|1[0-357]|7[0-367]|3[0-37]|5[0-2]|2[27]|4[17]|9[0-9])|1(?:5[0-35-9]|[2-4689][0-9]|1[0-5]|0[0-2]|7[013])|7(?:5[0-46-9]|8[0-79]|[0134679][0-9]|2[0-2])|0(?:2[03-9]|[013-589][0-9]|6[0-5]|7[0579])|8(?:0[0-5]|2[0-3]|4[0-2]|7[0-9]|35|97)|3(?:8[24-7]|3[0-24]|0[0-2]|[45][0-9]|73)|9(?:[0-8][0-9]|9[0-24-79])|2(?:[1-69][0-9]|0[09]|72)|5[0-9][0-9])|8(?:0(?:[12][0-9]|[3-8]0|0[018]|98)|8(?:2[0-2]|9[089]|8[0-9]|11|66|77)|2(?:[2-6][0-9]|1[01]|82|98)|7(?:[28]7|65|98)|1[0-9][0-9]|6(?:86|98)|31[1-4]|[45]98|9[0-9][0-9])|00(?:3[0-3]|[0-2][0-9]|65|94)|[56][0-9][0-9][0-9])|1(?:0(?:1(?:0[0-6]|2[1-489]|6[0-46]|9[02-4]|[348]0|7[67]|5[0-9])|4(?:0[124-8]|4[0-3]|8[1-4]|7[12]|66)|8(?:[0-3][0-9]|8[01]|66|92)|3(?:1[367]|0[03]|33|66)|2(?:[02][01]|6[06]|80)|9(?:8[18]|9[19]|66|77)|[5-7][0-9][0-9]|0[0-9][0-9])|8(?:4(?:[39][0-7]|5[0-4]|[0-24][0-9]|8[0489]|6[01])|1(?:[0-57-9][0-9]|6[02-9])|[023][0-9][0-9])|4(?:8(?:[02-57-9][0-9]|[16][0-9])|9(?:[0-689][0-9]|7[0-9])|[0-7][0-9][0-9])|(?:(?:5[035-8]|6[0149]|3[049]|9[01])[0-9]|24[12])[0-9]|7(?:1(?:[1-8][0-9]|[09][0-9])|[02-9][0-9][0-9]))|7(?:5(?:0(?:[1-489][0-9]|[056][0-9]|70)|7(?:[018]7|[56][0-9]|7[78])|5(?:6[6-9]|5[0-9])|1[0-6][0-9]|20[01]|432)|8(?:(?:8[0-5]|7[0-9]|00)[0-9]|6(?:[1-9][0-9]|0[0-9]))|6(?:0(?:[1-9][0-9]|0[0-9])|[1-4][0-9][0-9])|7(?:[78][0-9]|0[0-9])[0-9]))[0-9]|8(?:(?:9(?:1(?:3[0235-9]|5[014-79]|0[0-47]|2[02-6]|6[025-79]|1[12468]|4[3-68]|7[017-9]|8[049]|9[279])|9(?:1[0-79]|9[02-46-9]|6[0235689]|7[015-9]|3[023689]|5[04-79]|8[017-9]|4[0469]|[02][0-9])|0(?:0[0-48]|5[04-8]|6[0-24-6]|8[014-69]|2[02-5]|7[01578]|9[0-257]|3[2369]|4[246]|12)|7(?:7[0-24-9]|0[0-5]|1[023689]|2[1-49]|5[4-79]|3[27-9]|6[2569]|9[0379]|4[469]|89)|3(?:7[0137-9]|3[0-269]|0[1246]|5[5-79]|9[0359]|1[168]|2[346]|6[25]|8[47]|46)|8(?:0[0-248]|7[0-258]|6[0256]|8[0369]|2[034]|1[69]|3[29]|4[06]|5[67]|98)|2(?:[57][0-24-9]|1[0-689]|[02-469][0-9]|8[0-2489]))|2(?:5(?:6[0-35-9]|2[0-24-689]|5[0-69]|1[0-6]|4[0457-9]|7[0-2457]|9[024579]|[038][0-9])|6(?:0[0-689]|5[0-35-79]|4[0-6]|8[0-24-68]|1[0-46]|2[0246-8]|9[05-7]|[367][0-9])|1(?:4[013-9]|8[02-9]|3[01346-8]|5[0-57]|2[0-35]|6[1256]|7[0457]|[019][0-9])|0(?:6[0-69]|[79][02457]|4[0-58]|5[03-8]|[0-38][0-9]))|6(?:0(?:0[0-24-79]|1[0-25-9]|4[0-24-7]|9[0-469]|6[0-2458]|7[014589]|8[0246-8]|3[0378]|5[0179]|2[268])|8(?:3[02389]|4[0-26]|9[0-29]|7[089]|8[468]|0[17]|5[27]|6[08]|11|22))|4(?:0(?:3[013-9]|4[0-4]|[0-2][0-9]|5[045]|6[046]|7[06]|8[16]|90)|2(?:1[0-46-9]|5[457-9]|3[346]|[02][0-9]|6[68]|7[06]|9[07]|44)|1(?:0[013-5]|1[01]|4[12])|3(?:0[0-389]|99))|1(?:1(?:6[0-79]|7[0-24-9]|5[0-35-79]|[0-489][0-9])|9(?:0[25]|1[09])|0[0-9][0-9])|5(?:0[0-2469]|5[05]|8[58]|28|40|66)[0-9]|8428)[0-9]|0(?:(?:5(?:4[0-79]|9[0-35-9]|3[02-8]|5[0-7]|6[0235-79]|7[0135-7]|8[01568]|[0-2][0-9])|9(?:0[0-368]|1[023]|3[268]|[489]0|54)|(?:3[038]|0[0-9])[0-9]|1(?:6[39]|86))[0-9]|880[0135-9])|36(?:(?:0[1-35-9]|2[4-9]|4[37-9]|5[49]|6[02])[0-9]|7(?:[35][0-9]|47))))[0-9][0-9][0-9]))\z/
}

sub RE_FULL() {
    qr/\A(?:(?-xism:1(?:1(?:8(?:7(?:1[0-3]|00|77)|(?:31|88)8|2(?:18|22)|00[06-8]|612)|[259]|6000)|0(?:2[02-8]|0[0-24579]|6[148]|9[079]|3[34]|4[34]|7[07]|8[08]|1[0-9]|55)|[578]))|(?-xism:3(?:9(?:3[02-9]|9[0-689]|1[02-689]|2[0-24-69]|7[0-3579]|4[014589]|8[017-9]|5[059]|6[069]|0[0-9])|2(?:4[0-689]|5[0-24-9]|8[0-689]|6[024-9]|9[02-689]|0[0-9]|1[0-9]|2[0-9]|3[0-9]|7[0-9])|6(?:6[0-689]|5[0-24-8]|4[0-25-79]|9[024-69]|7[026-8]|8[068]|0[0-9]|1[0-9]|2[0-9]|3[0-9])|0(?:0[0-469]|2[02356]|8[0679]|1[058]|3[036]|[467]0|5[58]|9[09])|1(?:1[02-47]|0[0136]|3[0-3]|2[023]|50|88)))|(?-xism:(?:(?:3651)?(?:[047-9]|16(?:1[0-57-9]|2[1-357]|3[03578]|5[04679]|6[04-6]|4[04]|9[09]|03|70))|(?:00|\+)33))(?:(?-xism:(?:(?:5(?:9(?:0(?:4[0-24-8]|5[0-26-9]|[289][0-9]|0[2-5]|1[0-3]|6[0189]|3[28]|7[07])|4(?:3[0-57-9]|2[0-2457-9]|4[3-9]|6[0-3]|9[0147]|5[7-9]|[18]0)|6(?:4[024-8]|3[05-9]|[56][0-9]|9[4-8]|0[2-5]|8[09]|[12]0|7[0-9]))|0(?:0(?:6[24-9]|[57][7-9]|1[0-35]|3[0-3]|4[04]|[89]0|0[0-9])|(?:9[0-6]|6[0-9])[0-9]|1(?:6[0-26]|5[0-9]|23|44|76)|7(?:[0-6][0-9]|80)|5(?:9[0-2469]|55|80)|4(?:0[135]|41)|8(?:5[05]|41)|3(?:05|66)|244)|3(?:2(?:0[0-46-9]|3[0-2]|8[018]|1[0-9]|20)|3(?:[0-689][0-9]|7[0-8])|4[0-9][0-9]|[15][0-9][0-9])|6(?:4(?:4[0-4]|[0189][0-9]|7[6-9]|33|64)|[1-35][0-9][0-9]|7[0-9][0-9])|1(?:9(?:2[0-8]|7[0-6]|[013-6][0-9]|8[08]|99)|[67][0-9][0-9])|8(?:6(?:1[0-5]|6[5-9]|7[0-3]|0[0-9])|[127][0-9][0-9])|79(?:[0-79][0-9]|8[0-8])|4(?:[24-69][0-9][0-9]|[07][0-9][0-9])|5[35-9][0-9][0-9]|24[0-9][0-9])|4(?:0(?:0(?:1[0-6]|6[3-9]|7[05-9]|[04][0-9]|[389]0|59)|1(?:6[0-6]|5[0-9]|00|23|44|76)|4(?:0[03-5]|4[1-3]|[89]0|66)|8(?:[0-7][0-9]|8[0-2])|3(?:1[36]|44|66)|5(?:7[78]|44|66)|2(?:6[5-7]|44)|[67][0-9][0-9]|9(?:40|88|99))|8(?:4(?:4[0-578]|8[024-68]|[0-36][0-9]|50|76|98)|5(?:2[0-8]|[01][0-9]|8[08]|[46]4|38)|0(?:[0-8][0-9]|9[02-9])|9(?:[0-24-9][0-9]|3[014-9])|[1-368][0-9][0-9]|799)|2(?:2(?:1[0-8]|4[2-4]|2[23]|0[0-9]|32|55|84)|0(?:[1-4]0|9[45]|0[0-9]|55|61|88)|8(?:2[0-3]|[01][0-9])|[67][0-9][0-9])|4(?:3(?:[0-79][0-9]|8[0-24-9])|4(?:0[0-2]|44|88)|2[0-9][0-9]|80[01])|1(?:1(?:[02-9][0-9]|1[0-79])|5(?:[0-3][0-9]|5[0-2]|40)|3[0-9][0-9])|5(?:(?:(?:6[0-9]|80)|7[0-9])[0-9]|0[0-9][0-9])|3(?:[278][0-9][0-9]|[04][0-9][0-9])|6(?:[6-8][0-9][0-9]|[39][0-9][0-9])|[79][0-9][0-9][0-9])|2(?:0(?:0(?:0[0-35-9]|3[034]|7[089]|4[04]|[18]0|57|66)|1(?:6[0-36]|5[0-9]|23|44|76)|4(?:0[1-4]|1[12]|44|56)|2(?:6[236]|[89]0|44)|8(?:[01][0-9]|80)|[67][0-9][0-9]|9(?:[67]1|55)|344)|4(?:6(?:7[0-8]|[0-6][0-9]|8[02489]|90)|5(?:[0-24-9][0-9]|3[1-9])|9(?:[0-79][0-9]|8[0-8])|[01378][0-9][0-9]|4[0-9][0-9])|5(?:2(?:9[0-7]|8[4689]|[0-2][0-9]|4[248]|7[236]|3[01]|62)|7(?:[0-4][0-9]|8[489]|9[0-2]|5[01]|7[56])|[14][0-9][0-9]|[036][0-9][0-9])|6(?:2(?:7[0-57]|[2-59][0-9]|6[26-9]|1[0679]|0[126]|8[089])|1(?:6[0-7]|[0-5][0-9]|88)|9(?:6[0-4]|5[01]|80))|7(?:8(?:[0-8][0-9]|9[0-58])|[267][0-9][0-9])|1(?:4(?:[0-8][0-9]|9[0-35-9])|8[0-9][0-9])|3(?:[1-3578][0-9][0-9]|[046][0-9][0-9])|2(?:[37-9][0-9][0-9]|2[0-9][0-9])|9(?:[6-9][0-9][0-9]|0[0-9][0-9])|85[0-9][0-9])|6(?:9(?:3(?:4[0-7]|9[0-47]|0[0-4]|[13][03]|8[0-3]|[25-7]0)|0(?:[07][0-7]|8[0-8]|[1-69][0-9])|4(?:[04][0-7]|1[0-6]|3[018]|[29][0-9])|6(?:[0-47-9][0-9]|5[0-2]|6[01])|[589][0-9][0-9]|2[0-9][0-9])|3(?:9(?:0[03-79]|6[015-9]|9[04-7]|1[019]|[457]0|3[09]|2[0-9])|6(?:[5-9][0-9]|[0-4][0-9])|8(?:[1-9][0-9]|00)|[0-57][0-9][0-9])|4(?:9(?:[0-46-8][0-9]|[59][0-9])|(?:[235-8][0-9]|4[0-9])[0-9]|0(?:[1-9][0-9]|0[0-9])|1(?:[0-57-9][0-9]|6[0-9]))|0(?:0(?:[0-36-9][0-9]|4[1-5]|5[1-4])|(?:[137-9][0-9]|[245][0-9])[0-9]|6(?:[0-4][0-9]|[5-9][0-9]))|5(?:6(?:[0-57-9][0-9]|6[016-9])|(?:[0-2457-9][0-9]|3[0-9])[0-9])|(?:6(?:[0-8][0-9]|9[0-9])|[1278][0-9][0-9])[0-9])|3(?:7(?:2(?:[0-3][0-9]|4[0-3]|5[057]|8[238]|7[23]|63|92)|3(?:4[0-6]|[0-3][0-9]|8[089]|7[23]|9[89])|0(?:[0-79][0-9]|8[1-9])|1(?:[0-79][0-9]|8[0-57-9])|4(?:0[0-3]|10))|0(?:1(?:6[0-367]|5[0-9]|00|23|44|76)|0(?:4[04]|[08]0|33|54|66)|3(?:6[78]|[89]0|16|44)|8(?:[01][0-9]|8[01])|4(?:0[1-4]|4[12])|[67][0-9][0-9]|2(?:00|44)|9(?:88|99))|6(?:7(?:1[0-79]|2[0-4]|7[67]|8[48]|0[0-9]|67)|5(?:1[0-689]|8[0-7]|[02-7][0-9])|8(?:[0-79][0-9]|8[0-8])|[0-469][0-9][0-9])|5(?:2(?:0[013-9]|[1-6][0-9]|8[0-248]|70|92)|7(?:[0-689][0-9]|7[0-689])|[14589][0-9][0-9])|39(?:8[028]|[01][0-9]|2[01]|90)|(?:[28][0-9]|9[01])[0-9][0-9]|4(?:4[0-9][0-9]|5[0-9][0-9])|10[0-9][0-9])|9(?:7(?:4(?:0[1-9]|8[0-689]|4[0-6]|7[135-9]|5[0-5]|1[5-9]|[236][0-9]|91)|6(?:[06][1-9]|1[0-357]|7[0-367]|3[0-37]|5[0-2]|2[27]|4[17]|9[0-9])|1(?:5[0-35-9]|[2-4689][0-9]|1[0-5]|0[0-2]|7[013])|7(?:5[0-46-9]|8[0-79]|[0134679][0-9]|2[0-2])|0(?:2[03-9]|[013-589][0-9]|6[0-5]|7[0579])|8(?:0[0-5]|2[0-3]|4[0-2]|7[0-9]|35|97)|3(?:8[24-7]|3[0-24]|0[0-2]|[45][0-9]|73)|9(?:[0-8][0-9]|9[0-24-79])|2(?:[1-69][0-9]|0[09]|72)|5[0-9][0-9])|8(?:0(?:[12][0-9]|[3-8]0|0[018]|98)|8(?:2[0-2]|9[089]|8[0-9]|11|66|77)|2(?:[2-6][0-9]|1[01]|82|98)|7(?:[28]7|65|98)|1[0-9][0-9]|6(?:86|98)|31[1-4]|[45]98|9[0-9][0-9])|00(?:3[0-3]|[0-2][0-9]|65|94)|[56][0-9][0-9][0-9])|1(?:0(?:1(?:0[0-6]|2[1-489]|6[0-46]|9[02-4]|[348]0|7[67]|5[0-9])|4(?:0[124-8]|4[0-3]|8[1-4]|7[12]|66)|8(?:[0-3][0-9]|8[01]|66|92)|3(?:1[367]|0[03]|33|66)|2(?:[02][01]|6[06]|80)|9(?:8[18]|9[19]|66|77)|[5-7][0-9][0-9]|0[0-9][0-9])|8(?:4(?:[39][0-7]|5[0-4]|[0-24][0-9]|8[0489]|6[01])|1(?:[0-57-9][0-9]|6[02-9])|[023][0-9][0-9])|4(?:8(?:[02-57-9][0-9]|[16][0-9])|9(?:[0-689][0-9]|7[0-9])|[0-7][0-9][0-9])|(?:(?:5[035-8]|6[0149]|3[049]|9[01])[0-9]|24[12])[0-9]|7(?:1(?:[1-8][0-9]|[09][0-9])|[02-9][0-9][0-9]))|7(?:5(?:0(?:[1-489][0-9]|[056][0-9]|70)|7(?:[018]7|[56][0-9]|7[78])|5(?:6[6-9]|5[0-9])|1[0-6][0-9]|20[01]|432)|8(?:(?:8[0-5]|7[0-9]|00)[0-9]|6(?:[1-9][0-9]|0[0-9]))|6(?:0(?:[1-9][0-9]|0[0-9])|[1-4][0-9][0-9])|7(?:[78][0-9]|0[0-9])[0-9]))[0-9]|8(?:(?:9(?:1(?:3[0235-9]|5[014-79]|0[0-47]|2[02-6]|6[025-79]|1[12468]|4[3-68]|7[017-9]|8[049]|9[279])|9(?:1[0-79]|9[02-46-9]|6[0235689]|7[015-9]|3[023689]|5[04-79]|8[017-9]|4[0469]|[02][0-9])|0(?:0[0-48]|5[04-8]|6[0-24-6]|8[014-69]|2[02-5]|7[01578]|9[0-257]|3[2369]|4[246]|12)|7(?:7[0-24-9]|0[0-5]|1[023689]|2[1-49]|5[4-79]|3[27-9]|6[2569]|9[0379]|4[469]|89)|3(?:7[0137-9]|3[0-269]|0[1246]|5[5-79]|9[0359]|1[168]|2[346]|6[25]|8[47]|46)|8(?:0[0-248]|7[0-258]|6[0256]|8[0369]|2[034]|1[69]|3[29]|4[06]|5[67]|98)|2(?:[57][0-24-9]|1[0-689]|[02-469][0-9]|8[0-2489]))|2(?:5(?:6[0-35-9]|2[0-24-689]|5[0-69]|1[0-6]|4[0457-9]|7[0-2457]|9[024579]|[038][0-9])|6(?:0[0-689]|5[0-35-79]|4[0-6]|8[0-24-68]|1[0-46]|2[0246-8]|9[05-7]|[367][0-9])|1(?:4[013-9]|8[02-9]|3[01346-8]|5[0-57]|2[0-35]|6[1256]|7[0457]|[019][0-9])|0(?:6[0-69]|[79][02457]|4[0-58]|5[03-8]|[0-38][0-9]))|6(?:0(?:0[0-24-79]|1[0-25-9]|4[0-24-7]|9[0-469]|6[0-2458]|7[014589]|8[0246-8]|3[0378]|5[0179]|2[268])|8(?:3[02389]|4[0-26]|9[0-29]|7[089]|8[468]|0[17]|5[27]|6[08]|11|22))|4(?:0(?:3[013-9]|4[0-4]|[0-2][0-9]|5[045]|6[046]|7[06]|8[16]|90)|2(?:1[0-46-9]|5[457-9]|3[346]|[02][0-9]|6[68]|7[06]|9[07]|44)|1(?:0[013-5]|1[01]|4[12])|3(?:0[0-389]|99))|1(?:1(?:6[0-79]|7[0-24-9]|5[0-35-79]|[0-489][0-9])|9(?:0[25]|1[09])|0[0-9][0-9])|5(?:0[0-2469]|5[05]|8[58]|28|40|66)[0-9]|8428)[0-9]|0(?:(?:5(?:4[0-79]|9[0-35-9]|3[02-8]|5[0-7]|6[0235-79]|7[0135-7]|8[01568]|[0-2][0-9])|9(?:0[0-368]|1[023]|3[268]|[489]0|54)|(?:3[038]|0[0-9])[0-9]|1(?:6[39]|86))[0-9]|880[0135-9])|36(?:(?:0[1-35-9]|2[4-9]|4[37-9]|5[49]|6[02])[0-9]|7(?:[35][0-9]|47))))[0-9][0-9][0-9])))\z/
}

sub RE_PFX() {
    qr/(?:(?:3651)?(?:[047-9]|16(?:1[0-57-9]|2[1-357]|3[03578]|5[04679]|6[04-6]|4[04]|9[09]|03|70))|(?:00|\+)33)/
}

sub operator
{
    my $num = Number::Phone::FR::subscriber(@_);
    return unless defined $num;
    $num .= '_' x (9 - length($num));
    if ("${num}SFR FRTEFREECOMPBOUYCOLTB3G ORNGMCI NURCLEGOPROSALTDHUBTPHONNRJ OUTROVH ORCAPAOPSRR VOXBINITBUYCATOWIPDIORNIBJTPSISTOMERORRUMIASICTLALNIJAG AFONAXLYITNFTERABUDGNEOCORIGEQFRFINERMIINWTIOPTIBRETDIABEMESPRIMSEWAWENGBTSICLLMFCTVDAUFKECOLGPHLPTLMBIUNERISENT3620CORILYCAMWSPFRMOJEMUMTPEAVMMBDMAEASYIDOMMARCVTCMWLLGCORNPRCPTLMD123MALPLCOMCMSBUV5FIVEONYNOVAICNAUTOOXIPCLEMGLOBINBOPRIXAUCHINCLLEONLNUMPIOLSIINTECHTRATADONCHMUGDEVGTPMIPOPMTPMNGCFNORMNUVOODIOACOMCNXTETOIEWAYEYESFINGHADRIPXTITELLLEILTITODBEOPENPRODSTMBTF1 TFINTHECTRANUPSAWMNEZEOPAAMTATCGATCOATTGCELYEDEVEURVGYPMIIVCIMT MOQUNORNONETOTFRPINDPITASPMTSYBATALEVIELWLLR4KALAMCAARAGASSABUFRCAWICENTCLIMINFSIPARJONALANELINKLPSTMBSDMTARMTOFPAJAPOPER188RDFRSIPESOCTTLGT" =~ m/^(8(?:9(?:2(?:6(?:[89][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{320}|1[0-9][0-9][0-9][0-9].{304}|2[0-9][0-9][0-9][0-9].{148}|3[0-9][0-9][0-9][0-9].{160}|4[0-9][0-9][0-9][0-9].{216}|6[0-9][0-9][0-9][0-9].{540}|7[0-9][0-9][0-9][0-9].{324}|5[0-9][0-9][0-9][0-9].{24})|1(?:1[0-9][0-9][0-9][0-9].{324}|2[0-9][0-9][0-9][0-9].{168}|4[0-9][0-9][0-9][0-9].{160}|5[0-9][0-9][0-9][0-9].{176}|6[0-9][0-9][0-9][0-9].{144}|8[0-9][0-9][0-9][0-9].{184}|9[0-9][0-9][0-9][0-9].{328}|3[0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{4})|9(?:[17][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{324}|3[0-9][0-9][0-9][0-9].{220}|8[0-9][0-9][0-9][0-9].{284}|9[0-9][0-9][0-9][0-9].{132}|2[0-9][0-9][0-9][0-9].{48}|4[0-9][0-9][0-9][0-9].{92}|6[0-9][0-9][0-9][0-9].{68}|5[0-9][0-9][0-9][0-9].{8})|2(?:[68][0-9][0-9][0-9][0-9].{280}|[25][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{152}|1[0-9][0-9][0-9][0-9].{288}|4[0-9][0-9][0-9][0-9].{164}|7[0-9][0-9][0-9][0-9].{316}|9[0-9][0-9][0-9][0-9].{464}|3[0-9][0-9][0-9][0-9].{24})|4(?:[01][0-9][0-9][0-9][0-9].{320}|[26][0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{324}|7[0-9][0-9][0-9][0-9].{252}|8[0-9][0-9][0-9][0-9].{112}|3[0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{72}|5[0-9][0-9][0-9][0-9].{4})|5(?:[26][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{348}|1[0-9][0-9][0-9][0-9].{104}|4[0-9][0-9][0-9][0-9].{276}|7[0-9][0-9][0-9][0-9].{128}|8[0-9][0-9][0-9][0-9].{136}|9[0-9][0-9][0-9][0-9].{232}|5[0-9][0-9][0-9][0-9].{4})|3(?:[0469][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{256}|3[0-9][0-9][0-9][0-9].{100}|7[0-9][0-9][0-9][0-9].{236}|8[0-9][0-9][0-9][0-9].{112}|2[0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9].{8})|7(?:[01][0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{196}|5[0-9][0-9][0-9][0-9].{112}|7[0-9][0-9][0-9][0-9].{100}|4[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{52})|0(?:[03][0-9][0-9][0-9][0-9].{100}|[18][0-9][0-9][0-9][0-9].{48}|[256][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{208}|7[0-9][0-9][0-9][0-9].{204}|9[0-9][0-9][0-9][0-9].{228})|8(?:0[0-9][0-9][0-9][0-9].{244}|1[0-9][0-9][0-9][0-9].{340}|2[0-9][0-9][0-9][0-9].{348}|4[0-9][0-9][0-9][0-9].{292}|9[0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{4}))|9(?:2(?:[26][0-9][0-9][0-9][0-9].{280}|0[0-9][0-9][0-9][0-9].{324}|1[0-9][0-9][0-9][0-9].{316}|4[0-9][0-9][0-9][0-9].{164}|7[0-9][0-9][0-9][0-9].{596}|8[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{504}|3[0-9][0-9][0-9][0-9].{24}|5[0-9][0-9][0-9][0-9].{60})|0(?:[05][0-9][0-9][0-9][0-9].{396}|2[0-9][0-9][0-9][0-9].{184}|3[0-9][0-9][0-9][0-9].{348}|4[0-9][0-9][0-9][0-9].{336}|6[0-9][0-9][0-9][0-9].{320}|7[0-9][0-9][0-9][0-9].{600}|8[0-9][0-9][0-9][0-9].{280}|1[0-9][0-9][0-9][0-9].{48}|9[0-9][0-9][0-9][0-9].{4})|1(?:0[0-9][0-9][0-9][0-9].{348}|1[0-9][0-9][0-9][0-9].{324}|2[0-9][0-9][0-9][0-9].{320}|3[0-9][0-9][0-9][0-9].{176}|4[0-9][0-9][0-9][0-9].{160}|5[0-9][0-9][0-9][0-9].{396}|6[0-9][0-9][0-9][0-9].{144}|7[0-9][0-9][0-9][0-9].{168}|9[0-9][0-9][0-9][0-9].{4})|9(?:2[0-9][0-9][0-9][0-9].{348}|3[0-9][0-9][0-9][0-9].{288}|8[0-9][0-9][0-9][0-9].{100}|0[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{92}|6[0-9][0-9][0-9][0-9].{24}|7[0-9][0-9][0-9][0-9].{68}|9[0-9][0-9][0-9][0-9].{48})|6(?:0[0-9][0-9][0-9][0-9].{100}|2[0-9][0-9][0-9][0-9].{148}|3[0-9][0-9][0-9][0-9].{252}|6[0-9][0-9][0-9][0-9].{236}|8[0-9][0-9][0-9][0-9].{324}|5[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{4})|5(?:0[0-9][0-9][0-9][0-9].{100}|4[0-9][0-9][0-9][0-9].{276}|5[0-9][0-9][0-9][0-9].{132}|7[0-9][0-9][0-9][0-9].{128}|9[0-9][0-9][0-9][0-9].{232}|6[0-9][0-9][0-9][0-9].{16})|7(?:[01][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{112}|6[0-9][0-9][0-9][0-9].{196}|7[0-9][0-9][0-9][0-9].{136}|9[0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{4})|3(?:0[0-9][0-9][0-9][0-9].{324}|3[0-9][0-9][0-9][0-9].{176}|6[0-9][0-9][0-9][0-9].{396}|8[0-9][0-9][0-9][0-9].{112}|2[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{4})|8(?:0[0-9][0-9][0-9][0-9].{256}|1[0-9][0-9][0-9][0-9].{340}|8[0-9][0-9][0-9][0-9].{464}|9[0-9][0-9][0-9][0-9].{48}|7[0-9][0-9][0-9][0-9].{4})|4(?:0[0-9][0-9][0-9][0-9].{100}|4[0-9][0-9][0-9][0-9].{320}|6[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{72}))|1(?:3(?:[69][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{136}|7[0-9][0-9][0-9][0-9].{236}|8[0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9].{16})|5(?:[16][0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{216}|5[0-9][0-9][0-9][0-9].{100}|7[0-9][0-9][0-9][0-9].{128}|9[0-9][0-9][0-9][0-9].{232}|0[0-9][0-9][0-9][0-9].{48})|6(?:0[0-9][0-9][0-9][0-9].{196}|2[0-9][0-9][0-9][0-9].{148}|6[0-9][0-9][0-9][0-9].{132}|5[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{72}|7[0-9][0-9][0-9][0-9].{8})|2(?:[35][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{276}|2[0-9][0-9][0-9][0-9].{100}|4[0-9][0-9][0-9][0-9].{164}|6[0-9][0-9][0-9][0-9].{176})|0(?:[02][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{168}|7[0-9][0-9][0-9][0-9].{204}|1[0-9][0-9][0-9][0-9].{48}|3[0-9][0-9][0-9][0-9].{60})|1(?:4[0-9][0-9][0-9][0-9].{160}|6[0-9][0-9][0-9][0-9].{144}|8[0-9][0-9][0-9][0-9].{288}|2[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{4})|4(?:3[0-9][0-9][0-9][0-9].{160}|4[0-9][0-9][0-9][0-9].{100}|8[0-9][0-9][0-9][0-9].{112}|6[0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{4})|7(?:[01][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{100}|9[0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{4})|9(?:7[0-9][0-9][0-9][0-9].{244}|2[0-9][0-9][0-9][0-9].{68}|9[0-9][0-9][0-9][0-9].{48})|8(?:4[0-9][0-9][0-9][0-9].{292}|0[0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{8}))|7(?:7(?:[01][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{288}|4[0-9][0-9][0-9][0-9].{196}|5[0-9][0-9][0-9][0-9].{136}|7[0-9][0-9][0-9][0-9].{132}|6[0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{68}|8[0-9][0-9][0-9][0-9].{4})|0(?:0[0-9][0-9][0-9][0-9].{100}|2[0-9][0-9][0-9][0-9].{596}|3[0-9][0-9][0-9][0-9].{348}|4[0-9][0-9][0-9][0-9].{168}|5[0-9][0-9][0-9][0-9].{600}|1[0-9][0-9][0-9][0-9].{48})|1(?:[09][0-9][0-9][0-9][0-9].{320}|3[0-9][0-9][0-9][0-9].{228}|6[0-9][0-9][0-9][0-9].{144}|2[0-9][0-9][0-9][0-9].{24}|8[0-9][0-9][0-9][0-9].{12})|2(?:1[0-9][0-9][0-9][0-9].{184}|2[0-9][0-9][0-9][0-9].{100}|4[0-9][0-9][0-9][0-9].{164}|9[0-9][0-9][0-9][0-9].{320}|3[0-9][0-9][0-9][0-9].{24})|5(?:4[0-9][0-9][0-9][0-9].{276}|5[0-9][0-9][0-9][0-9].{100}|7[0-9][0-9][0-9][0-9].{128}|9[0-9][0-9][0-9][0-9].{232}|6[0-9][0-9][0-9][0-9].{16})|3(?:7[0-9][0-9][0-9][0-9].{236}|8[0-9][0-9][0-9][0-9].{112}|2[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{4})|6(?:[56][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{148}|9[0-9][0-9][0-9][0-9].{72})|9(?:[09][0-9][0-9][0-9][0-9].{48}|3[0-9][0-9][0-9][0-9].{176}|7[0-9][0-9][0-9][0-9].{4})|4(?:4[0-9][0-9][0-9][0-9].{100}|9[0-9][0-9][0-9][0-9].{244}|6[0-9][0-9][0-9][0-9].{16})|89[0-9][0-9][0-9][0-9].{48})|0(?:5(?:0[0-9][0-9][0-9][0-9].{136}|4[0-9][0-9][0-9][0-9].{216}|5[0-9][0-9][0-9][0-9].{100}|7[0-9][0-9][0-9][0-9].{128}|8[0-9][0-9][0-9][0-9].{196}|6[0-9][0-9][0-9][0-9].{16})|6(?:0[0-9][0-9][0-9][0-9].{228}|2[0-9][0-9][0-9][0-9].{148}|6[0-9][0-9][0-9][0-9].{132}|1[0-9][0-9][0-9][0-9].{24}|4[0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{4})|8(?:4[0-9][0-9][0-9][0-9].{292}|5[0-9][0-9][0-9][0-9].{176}|1[0-9][0-9][0-9][0-9].{68}|6[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{4})|2(?:0[0-9][0-9][0-9][0-9].{484}|2[0-9][0-9][0-9][0-9].{100}|4[0-9][0-9][0-9][0-9].{164}|3[0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{4})|9(?:5[0-9][0-9][0-9][0-9].{176}|7[0-9][0-9][0-9][0-9].{244}|0[0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{4})|0(?:[03][0-9][0-9][0-9][0-9].{168}|[18][0-9][0-9][0-9][0-9].{48}|4[0-9][0-9][0-9][0-9].{336}|2[0-9][0-9][0-9][0-9].{4})|7(?:[01][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{112}|7[0-9][0-9][0-9][0-9].{288}|8[0-9][0-9][0-9][0-9].{4})|3(?:[69][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{100}|2[0-9][0-9][0-9][0-9].{36})|4(?:[26][0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{100})|12[0-9][0-9][0-9][0-9].{4})|3(?:7(?:[01][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{196}|7[0-9][0-9][0-9][0-9].{100}|9[0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{4})|3(?:[09][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{288}|1[0-9][0-9][0-9][0-9].{68}|2[0-9][0-9][0-9][0-9].{36})|5(?:5[0-9][0-9][0-9][0-9].{136}|7[0-9][0-9][0-9][0-9].{128}|9[0-9][0-9][0-9][0-9].{232}|6[0-9][0-9][0-9][0-9].{16})|9(?:0[0-9][0-9][0-9][0-9].{100}|3[0-9][0-9][0-9][0-9].{288}|9[0-9][0-9][0-9][0-9].{132}|5[0-9][0-9][0-9][0-9].{12})|0(?:[16][0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{100}|4[0-9][0-9][0-9][0-9].{336})|1(?:1[0-9][0-9][0-9][0-9].{100}|6[0-9][0-9][0-9][0-9].{144}|8[0-9][0-9][0-9][0-9].{176})|2(?:4[0-9][0-9][0-9][0-9].{164}|6[0-9][0-9][0-9][0-9].{280}|3[0-9][0-9][0-9][0-9].{24})|6(?:2[0-9][0-9][0-9][0-9].{148}|5[0-9][0-9][0-9][0-9].{24})|8(?:4[0-9][0-9][0-9][0-9].{292}|7[0-9][0-9][0-9][0-9].{48})|46[0-9][0-9][0-9][0-9].{16})|8(?:0(?:[18][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{100}|2[0-9][0-9][0-9][0-9].{196}|4[0-9][0-9][0-9][0-9].{336})|6(?:0[0-9][0-9][0-9][0-9].{100}|2[0-9][0-9][0-9][0-9].{148}|6[0-9][0-9][0-9][0-9].{132}|5[0-9][0-9][0-9][0-9].{24})|7(?:[01][0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{176}|5[0-9][0-9][0-9][0-9].{136}|8[0-9][0-9][0-9][0-9].{4})|8(?:3[0-9][0-9][0-9][0-9].{288}|6[0-9][0-9][0-9][0-9].{68}|9[0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{4})|2(?:0[0-9][0-9][0-9][0-9].{100}|4[0-9][0-9][0-9][0-9].{164}|3[0-9][0-9][0-9][0-9].{24})|1(?:6[0-9][0-9][0-9][0-9].{144}|9[0-9][0-9][0-9][0-9].{12})|4(?:0[0-9][0-9][0-9][0-9].{100}|6[0-9][0-9][0-9][0-9].{16})|5(?:7[0-9][0-9][0-9][0-9].{128}|6[0-9][0-9][0-9][0-9].{16})|3(?:2[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{4})|98[0-9][0-9][0-9][0-9].{48}))|2(?:6(?:6(?:[7-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{232}|1[0-9][0-9][0-9][0-9].{304}|2[0-9][0-9][0-9][0-9].{148}|3[0-9][0-9][0-9][0-9].{160}|4[0-9][0-9][0-9][0-9].{216}|5[0-9][0-9][0-9][0-9].{24}|6[0-9][0-9][0-9][0-9].{4})|8(?:1[0-9][0-9][0-9][0-9].{164}|4[0-9][0-9][0-9][0-9].{524}|5[0-9][0-9][0-9][0-9].{176}|2[0-9][0-9][0-9][0-9].{48}|6[0-9][0-9][0-9][0-9].{24}|8[0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{4})|0(?:[56][0-9][0-9][0-9][0-9].{100}|[18][0-9][0-9][0-9][0-9].{48}|[02][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{140}|4[0-9][0-9][0-9][0-9].{208}|9[0-9][0-9][0-9][0-9].{28})|5(?:[1-3][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{348}|6[0-9][0-9][0-9][0-9].{340}|7[0-9][0-9][0-9][0-9].{128}|9[0-9][0-9][0-9][0-9].{196}|5[0-9][0-9][0-9][0-9].{4})|1(?:1[0-9][0-9][0-9][0-9].{100}|2[0-9][0-9][0-9][0-9].{104}|3[0-9][0-9][0-9][0-9].{524}|4[0-9][0-9][0-9][0-9].{160}|6[0-9][0-9][0-9][0-9].{144}|0[0-9][0-9][0-9][0-9].{24})|3(?:[1-6][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{184}|7[0-9][0-9][0-9][0-9].{236}|8[0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{4})|2(?:[02][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{152}|6[0-9][0-9][0-9][0-9].{100}|8[0-9][0-9][0-9][0-9].{284}|7[0-9][0-9][0-9][0-9].{48})|9(?:5[0-9][0-9][0-9][0-9].{60}|6[0-9][0-9][0-9][0-9].{24}|7[0-9][0-9][0-9][0-9].{92}|0[0-9][0-9][0-9][0-9].{4})|4(?:[1-6][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{336})|7[0-9][0-9][0-9][0-9][0-9].{16})|1(?:0(?:[18][0-9][0-9][0-9][0-9].{48}|[02][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{336}|5[0-9][0-9][0-9][0-9].{100}|6[0-9][0-9][0-9][0-9].{104}|3[0-9][0-9][0-9][0-9].{60}|7[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{28})|5(?:[12][0-9][0-9][0-9][0-9].{68}|0[0-9][0-9][0-9][0-9].{232}|3[0-9][0-9][0-9][0-9].{160}|4[0-9][0-9][0-9][0-9].{216}|7[0-9][0-9][0-9][0-9].{128}|5[0-9][0-9][0-9][0-9].{4})|3(?:[36][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{340}|7[0-9][0-9][0-9][0-9].{236}|8[0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{24}|4[0-9][0-9][0-9][0-9].{48})|1(?:[36-9][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{100}|2[0-9][0-9][0-9][0-9].{104}|4[0-9][0-9][0-9][0-9].{160}|5[0-9][0-9][0-9][0-9].{176})|4(?:[5-9][0-9][0-9][0-9][0-9].{16}|[04][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{340}|3[0-9][0-9][0-9][0-9].{160})|2(?:[01][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{176}|2[0-9][0-9][0-9][0-9].{48}|3[0-9][0-9][0-9][0-9].{24})|7(?:0[0-9][0-9][0-9][0-9].{100}|5[0-9][0-9][0-9][0-9].{112}|7[0-9][0-9][0-9][0-9].{136}|4[0-9][0-9][0-9][0-9].{16})|9(?:[0-7][0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{172}|9[0-9][0-9][0-9][0-9].{8})|6(?:[15][0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9].{148}|6[0-9][0-9][0-9][0-9].{304})|8(?:[3-9][0-9][0-9][0-9][0-9].{16}|[02][0-9][0-9][0-9][0-9].{4}))|5(?:6(?:2[0-9][0-9][0-9][0-9].{148}|3[0-9][0-9][0-9][0-9].{256}|6[0-9][0-9][0-9][0-9].{132}|8[0-9][0-9][0-9][0-9].{252}|9[0-9][0-9][0-9][0-9].{152}|1[0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9].{80}|7[0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9].{4})|5(?:[12][0-9][0-9][0-9][0-9].{68}|3[0-9][0-9][0-9][0-9].{364}|4[0-9][0-9][0-9][0-9].{216}|6[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{72}|0[0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{4})|2(?:[026][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{136}|4[0-9][0-9][0-9][0-9].{276}|5[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{4})|4(?:0[0-9][0-9][0-9][0-9].{336}|4[0-9][0-9][0-9][0-9].{100}|7[0-9][0-9][0-9][0-9].{316}|8[0-9][0-9][0-9][0-9].{524}|9[0-9][0-9][0-9][0-9].{156}|5[0-9][0-9][0-9][0-9].{4})|9(?:0[0-9][0-9][0-9][0-9].{184}|4[0-9][0-9][0-9][0-9].{292}|7[0-9][0-9][0-9][0-9].{244}|9[0-9][0-9][0-9][0-9].{348}|2[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{8})|7(?:[27][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{180}|5[0-9][0-9][0-9][0-9].{188}|0[0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{16})|1(?:[36][0-9][0-9][0-9][0-9].{144}|[025][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{100}|4[0-9][0-9][0-9][0-9].{112})|[038][0-9][0-9][0-9][0-9][0-9].{8})|0(?:2(?:[0257][0-9][0-9][0-9][0-9].{8}|[68][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{184}|4[0-9][0-9][0-9][0-9].{168}|1[0-9][0-9][0-9][0-9].{48}|9[0-9][0-9][0-9][0-9].{36})|6(?:[34][0-9][0-9][0-9][0-9].{392}|[01][0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{148}|6[0-9][0-9][0-9][0-9].{156}|9[0-9][0-9][0-9][0-9].{72}|5[0-9][0-9][0-9][0-9].{4})|4(?:[28][0-9][0-9][0-9][0-9].{16}|[05][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{256}|3[0-9][0-9][0-9][0-9].{208}|4[0-9][0-9][0-9][0-9].{100})|5(?:[68][0-9][0-9][0-9][0-9].{16}|[07][0-9][0-9][0-9][0-9].{8}|3[0-9][0-9][0-9][0-9].{196}|4[0-9][0-9][0-9][0-9].{216}|5[0-9][0-9][0-9][0-9].{132})|9(?:2[0-9][0-9][0-9][0-9].{152}|4[0-9][0-9][0-9][0-9].{292}|7[0-9][0-9][0-9][0-9].{244}|5[0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9].{4})|1(?:[02-4][0-9][0-9][0-9][0-9].{4}|[19][0-9][0-9][0-9][0-9].{100}|[56][0-9][0-9][0-9][0-9].{144}|[78][0-9][0-9][0-9][0-9].{316})|7(?:[27][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{100}|4[0-9][0-9][0-9][0-9].{276}|5[0-9][0-9][0-9][0-9].{336})|[038][0-9][0-9][0-9][0-9][0-9].{8}))|0(?:5(?:1(?:[01][0-9][0-9][0-9][0-9].{36}|3[0-9][0-9][0-9][0-9].{132}|4[0-9][0-9][0-9][0-9].{160}|5[0-9][0-9][0-9][0-9].{232}|6[0-9][0-9][0-9][0-9].{144}|7[0-9][0-9][0-9][0-9].{176}|8[0-9][0-9][0-9][0-9].{140}|9[0-9][0-9][0-9][0-9].{100}|2[0-9][0-9][0-9][0-9].{4})|2(?:[05][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{256}|3[0-9][0-9][0-9][0-9].{152}|4[0-9][0-9][0-9][0-9].{384}|6[0-9][0-9][0-9][0-9].{168}|8[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{208}|2[0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{8})|9(?:[23][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{244}|8[0-9][0-9][0-9][0-9].{172}|0[0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{52}|5[0-9][0-9][0-9][0-9].{60}|6[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{16})|3(?:2[0-9][0-9][0-9][0-9].{252}|3[0-9][0-9][0-9][0-9].{100}|4[0-9][0-9][0-9][0-9].{276}|7[0-9][0-9][0-9][0-9].{136}|8[0-9][0-9][0-9][0-9].{112}|5[0-9][0-9][0-9][0-9].{24}|6[0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{4})|4(?:[24][0-9][0-9][0-9][0-9].{100}|[06][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{160}|7[0-9][0-9][0-9][0-9].{236}|9[0-9][0-9][0-9][0-9].{340}|1[0-9][0-9][0-9][0-9].{48}|5[0-9][0-9][0-9][0-9].{24})|5(?:[12][0-9][0-9][0-9][0-9].{68}|3[0-9][0-9][0-9][0-9].{196}|4[0-9][0-9][0-9][0-9].{216}|7[0-9][0-9][0-9][0-9].{128}|0[0-9][0-9][0-9][0-9].{48}|6[0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{4})|0(?:[1245][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{100}|3[0-9][0-9][0-9][0-9].{60}|7[0-9][0-9][0-9][0-9].{80}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{8})|6(?:0[0-9][0-9][0-9][0-9].{156}|2[0-9][0-9][0-9][0-9].{148}|5[0-9][0-9][0-9][0-9].{184}|7[0-9][0-9][0-9][0-9].{180}|3[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{72}|6[0-9][0-9][0-9][0-9].{4})|7(?:[017][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{316}|5[0-9][0-9][0-9][0-9].{24}|6[0-9][0-9][0-9][0-9].{52})|8(?:[01][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{304}|8[0-9][0-9][0-9][0-9].{100}|5[0-9][0-9][0-9][0-9].{16}))|9(?:0(?:[26][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{716}|1[0-9][0-9][0-9][0-9].{384}|3[0-9][0-9][0-9][0-9].{648}|8[0-9][0-9][0-9][0-9].{232})|1(?:3[0-9][0-9][0-9][0-9].{228}|0[0-9][0-9][0-9][0-9].{8}|2[0-9][0-9][0-9][0-9].{4})|3(?:2[0-9][0-9][0-9][0-9].{232}|6[0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{8})|[49]0[0-9][0-9][0-9][0-9].{4}|54[0-9][0-9][0-9][0-9].{32}|80[0-9][0-9][0-9][0-9].{48})|0(?:9(?:[0189][0-9][0-9][0-9][0-9].{8}|[257][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{288}|6[0-9][0-9][0-9][0-9].{168}|4[0-9][0-9][0-9][0-9].{24})|7(?:[02579][0-9][0-9][0-9][0-9].{8}|[13][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{288}|4[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{12})|[0-68][0-9][0-9][0-9][0-9][0-9].{8})|880(?:[03][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9].{392}|5[0-9][0-9][0-9].{128}|6[0-9][0-9][0-9].{148}|8[0-9][0-9][0-9].{48}|9[0-9][0-9][0-9].{24}|7[0-9][0-9][0-9].{4})|(?:1(?:6[39]|86)|3[038][0-9])[0-9][0-9][0-9][0-9].{8})|4(?:0(?:2(?:0[0-9][0-9][0-9][0-9].{188}|1[0-9][0-9][0-9][0-9].{244}|3[0-9][0-9][0-9][0-9].{104}|4[0-9][0-9][0-9][0-9].{352}|6[0-9][0-9][0-9][0-9].{304}|7[0-9][0-9][0-9][0-9].{192}|8[0-9][0-9][0-9][0-9].{284}|2[0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{72}|9[0-9][0-9][0-9][0-9].{60})|1(?:2[0-9][0-9][0-9][0-9].{224}|3[0-9][0-9][0-9][0-9].{172}|4[0-9][0-9][0-9][0-9].{160}|6[0-9][0-9][0-9][0-9].{148}|7[0-9][0-9][0-9][0-9].{364}|9[0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{92}|5[0-9][0-9][0-9][0-9].{80}|8[0-9][0-9][0-9][0-9].{36})|3(?:0[0-9][0-9][0-9][0-9].{152}|1[0-9][0-9][0-9][0-9].{168}|3[0-9][0-9][0-9][0-9].{100}|4[0-9][0-9][0-9][0-9].{208}|5[0-9][0-9][0-9][0-9].{252}|6[0-9][0-9][0-9][0-9].{136}|7[0-9][0-9][0-9][0-9].{196}|8[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{256})|0(?:[24579][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{328}|3[0-9][0-9][0-9][0-9].{100}|6[0-9][0-9][0-9][0-9].{184}|1[0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{8})|4(?:[12][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{400}|4[0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{4})|6(?:0[0-9][0-9][0-9][0-9].{132}|4[0-9][0-9][0-9][0-9].{216}|6[0-9][0-9][0-9][0-9].{16})|5(?:5[0-9][0-9][0-9][0-9].{156}|0[0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{16})|8(?:1[0-9][0-9][0-9][0-9].{164}|6[0-9][0-9][0-9][0-9].{20})|7(?:0[0-9][0-9][0-9][0-9].{48}|6[0-9][0-9][0-9][0-9].{52})|90[0-9][0-9][0-9][0-9].{24})|2(?:2(?:[56][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{148}|1[0-9][0-9][0-9][0-9].{196}|2[0-9][0-9][0-9][0-9].{104}|3[0-9][0-9][0-9][0-9].{256}|4[0-9][0-9][0-9][0-9].{164}|7[0-9][0-9][0-9][0-9].{400}|8[0-9][0-9][0-9][0-9].{132}|9[0-9][0-9][0-9][0-9].{60})|1(?:1[0-9][0-9][0-9][0-9].{352}|2[0-9][0-9][0-9][0-9].{304}|3[0-9][0-9][0-9][0-9].{192}|4[0-9][0-9][0-9][0-9].{168}|6[0-9][0-9][0-9][0-9].{208}|7[0-9][0-9][0-9][0-9].{364}|9[0-9][0-9][0-9][0-9].{252}|0[0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{36})|0(?:[27][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{328}|4[0-9][0-9][0-9][0-9].{112}|5[0-9][0-9][0-9][0-9].{244}|6[0-9][0-9][0-9][0-9].{464}|9[0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{48}|3[0-9][0-9][0-9][0-9].{92}|8[0-9][0-9][0-9][0-9].{8})|5(?:[7-9][0-9][0-9][0-9][0-9].{128}|4[0-9][0-9][0-9][0-9].{216}|5[0-9][0-9][0-9][0-9].{156})|3(?:[34][0-9][0-9][0-9][0-9].{100}|6[0-9][0-9][0-9][0-9].{136})|6(?:6[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{72})|7(?:0[0-9][0-9][0-9][0-9].{48}|6[0-9][0-9][0-9][0-9].{52})|9[07][0-9][0-9][0-9][0-9].{24}|44[0-9][0-9][0-9][0-9].{12})|1(?:0(?:[01][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{92}|5[0-9][0-9][0-9][0-9].{8})|4[12][0-9][0-9][0-9][0-9].{608}|1[01][0-9][0-9][0-9][0-9].{24})|3(?:0(?:[01][0-9][0-9][0-9][0-9].{48}|[23][0-9][0-9][0-9][0-9].{32}|8[0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{4})|99[0-9][0-9][0-9][0-9].{4}))|1(?:1(?:1(?:0[0-9][0-9][0-9][0-9].{100}|2[0-9][0-9][0-9][0-9].{256}|3[0-9][0-9][0-9][0-9].{144}|4[0-9][0-9][0-9][0-9].{160}|5[0-9][0-9][0-9][0-9].{384}|7[0-9][0-9][0-9][0-9].{328}|8[0-9][0-9][0-9][0-9].{316}|9[0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{8})|4(?:[45][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{100}|3[0-9][0-9][0-9][0-9].{160}|7[0-9][0-9][0-9][0-9].{140}|8[0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{168}|1[0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9].{80}|6[0-9][0-9][0-9][0-9].{16})|9(?:[23][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{188}|7[0-9][0-9][0-9][0-9].{244}|8[0-9][0-9][0-9][0-9].{172}|9[0-9][0-9][0-9][0-9].{156}|1[0-9][0-9][0-9][0-9].{48}|4[0-9][0-9][0-9][0-9].{80}|5[0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9].{4})|3(?:[27][0-9][0-9][0-9][0-9].{100}|[36][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{232}|1[0-9][0-9][0-9][0-9].{176}|4[0-9][0-9][0-9][0-9].{184}|5[0-9][0-9][0-9][0-9].{276}|8[0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{252})|8(?:[23][0-9][0-9][0-9][0-9].{392}|[01][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{292}|6[0-9][0-9][0-9][0-9].{304}|7[0-9][0-9][0-9][0-9].{196}|5[0-9][0-9][0-9][0-9].{92}|8[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{24})|6(?:[013][0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{148}|4[0-9][0-9][0-9][0-9].{216}|6[0-9][0-9][0-9][0-9].{136}|7[0-9][0-9][0-9][0-9].{236}|5[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{72})|7(?:[57][0-9][0-9][0-9][0-9].{100}|[01][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{132}|9[0-9][0-9][0-9][0-9].{372}|4[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{52}|8[0-9][0-9][0-9][0-9].{88})|0(?:[025][0-9][0-9][0-9][0-9].{4}|[18][0-9][0-9][0-9][0-9].{48}|4[0-9][0-9][0-9][0-9].{208}|3[0-9][0-9][0-9][0-9].{60}|6[0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{28})|5(?:[12][0-9][0-9][0-9][0-9].{68}|3[0-9][0-9][0-9][0-9].{160}|7[0-9][0-9][0-9][0-9].{128}|9[0-9][0-9][0-9][0-9].{340}|0[0-9][0-9][0-9][0-9].{48}|6[0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{4})|2(?:[0245][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{152}|1[0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{24}|6[0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{8}))|9(?:1(?:9[0-9][0-9][0-9][0-9].{176}|0[0-9][0-9][0-9][0-9].{8})|0[25][0-9][0-9][0-9][0-9].{60})|0[0-9][0-9][0-9][0-9][0-9][0-9].{8})|6(?:0(?:1(?:[56][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{52}|1[0-9][0-9][0-9][0-9].{100}|0[0-9][0-9][0-9][0-9].{24}|7[0-9][0-9][0-9][0-9].{68}|2[0-9][0-9][0-9][0-9].{4})|8(?:2[0-9][0-9][0-9][0-9].{152}|4[0-9][0-9][0-9][0-9].{292}|6[0-9][0-9][0-9][0-9].{100}|0[0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{8})|0(?:[19][0-9][0-9][0-9][0-9].{12}|[45][0-9][0-9][0-9][0-9].{28}|[27][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{656}|0[0-9][0-9][0-9][0-9].{8})|6(?:[45][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{644}|8[0-9][0-9][0-9][0-9].{552}|1[0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9].{12})|9(?:[239][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{292}|6[0-9][0-9][0-9][0-9].{48})|4(?:[256][0-9][0-9][0-9][0-9].{16}|[014][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{172})|3(?:[03][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{172}|8[0-9][0-9][0-9][0-9].{588})|5(?:[09][0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{128}|1[0-9][0-9][0-9][0-9].{12})|2(?:8[0-9][0-9][0-9][0-9].{552}|2[0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{8})|7(?:[0189][0-9][0-9][0-9][0-9].{4}|[45][0-9][0-9][0-9][0-9].{16}))|8(?:3(?:[89][0-9][0-9][0-9][0-9].{24}|[03][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{16})|8(?:4[0-9][0-9][0-9][0-9].{292}|6[0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{8})|9(?:[29][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{4})|4(?:[0-2][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{16})|5(?:7[0-9][0-9][0-9][0-9].{128}|2[0-9][0-9][0-9][0-9].{4})|0(?:1[0-9][0-9][0-9][0-9].{48}|7[0-9][0-9][0-9][0-9].{4})|6(?:0[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{4})|(?:11|22)[0-9][0-9][0-9][0-9].{100}|7[089][0-9][0-9][0-9][0-9].{4}))|5(?:0(?:[249][0-9][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9][0-9].{172}|0[0-9][0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9][0-9].{32})|5(?:5[0-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9][0-9].{4})|8(?:5[0-9][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9][0-9].{8})|28[0-9][0-9][0-9][0-9][0-9].{216}|66[0-9][0-9][0-9][0-9][0-9].{20}|40[0-9][0-9][0-9][0-9][0-9].{4})|36(?:(?:(?:2[4-9]|4[37-9]|5[49]|6[02])[0-9]|7(?:[35][0-9]|47))[0-9][0-9][0-9].{8}|0(?:[1-35-8][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{200}))|8428[0-9][0-9][0-9][0-9].{4})|3(?:6(?:9(?:6(?:[7-9][0-9][0-9][0-9][0-9].{36}|[2-4][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{60}|5[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{44}|_____.{384})|0(?:[1-4][0-9][0-9][0-9][0-9].{40}|[578][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{28}|_____.{8})|7(?:[3-69][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{40})|2(?:[1378][0-9][0-9][0-9][0-9].{4}|[02][0-9][0-9][0-9][0-9].{16}|[45][0-9][0-9][0-9][0-9].{24}|[69][0-9][0-9][0-9][0-9].{40}|_____.{184})|3(?:[124578][0-9][0-9][0-9][0-9].{4}|[06][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{12})|4(?:(?:[0357-9][0-9][0-9][0-9][0-9]|_____).{4}|[14][0-9][0-9][0-9][0-9].{16}|[26][0-9][0-9][0-9][0-9].{40})|5(?:(?:[346-9][0-9][0-9][0-9][0-9]|_____).{4}|[0-2][0-9][0-9][0-9][0-9].{24}|5[0-9][0-9][0-9][0-9].{16})|9(?:[0-578][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{4}|_____.{8})|8(?:[03-6][0-9][0-9][0-9][0-9].{20}|[1279][0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{16})|1(?:[02-8][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{40}))|6(?:7(?:[67][0-9][0-9][0-9][0-9].{60}|[89][0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{108}|5[0-9][0-9][0-9][0-9].{136}|0[0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{72}|3[0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{88})|8(?:(?:7[0-9][0-9][0-9][0-9]|_____).{4}|[1-5][0-9][0-9][0-9][0-9].{48}|[89][0-9][0-9][0-9][0-9].{88}|0[0-9][0-9][0-9][0-9].{180}|6[0-9][0-9][0-9][0-9].{60})|9(?:[0-5][0-9][0-9][0-9][0-9].{48}|[67][0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{180}|8[0-9][0-9][0-9][0-9].{72}|_____.{396})|2(?:[5-9][0-9][0-9][0-9][0-9].{16}|[2-4][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{172}|0[0-9][0-9][0-9][0-9].{20}|_____.{48})|6(?:[013-58][0-9][0-9][0-9][0-9].{40}|[79][0-9][0-9][0-9][0-9].{140}|[26][0-9][0-9][0-9][0-9].{60}|_____.{164})|0(?:[0-5][0-9][0-9][0-9][0-9].{16}|[7-9][0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{300}|_____.{8})|3(?:[014-9][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{252}|3[0-9][0-9][0-9][0-9].{48}|_____.{280})|4(?:(?:[01][0-9][0-9][0-9][0-9]|_____).{16}|[3-9][0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{40})|5(?:[0-7][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{60}|8[0-9][0-9][0-9][0-9].{4}|_____.{164})|1(?:[0-9][0-9][0-9][0-9][0-9].{20}|_____.{112}))|2(?:8(?:[4-6][0-9][0-9][0-9][0-9].{108}|[027][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{152}|3[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{4}|_____.{184})|5(?:[0359][0-9][0-9][0-9][0-9].{16}|[146][0-9][0-9][0-9][0-9].{36}|[27][0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{108}|_____.{184})|9(?:[4-689][0-9][0-9][0-9][0-9].{16}|[0-2][0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{360}|3[0-9][0-9][0-9][0-9].{52}|_____.{184})|2(?:[2-68][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{248}|7[0-9][0-9][0-9][0-9].{60}|_____.{8})|7(?:(?:7[0-9][0-9][0-9][0-9]|_____).{4}|[3-689][0-9][0-9][0-9][0-9].{52}|[02][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{108})|6(?:[0-26][0-9][0-9][0-9][0-9].{16}|[7-9][0-9][0-9][0-9][0-9].{108}|[3-5][0-9][0-9][0-9][0-9].{4}|_____.{8})|0(?:[13-9][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{12}|_____.{256})|4(?:[0-6][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{36}|_____.{48})|3(?:[0-4][0-9][0-9][0-9][0-9].{12}|[5-9][0-9][0-9][0-9][0-9].{36}|_____.{8})|1(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{40}|_____.{184}))|8(?:6(?:[02-6][0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{180}|1[0-9][0-9][0-9][0-9].{44}|8[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{80}|_____.{8})|7(?:[1-5][0-9][0-9][0-9][0-9].{20}|[79][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{80}|6[0-9][0-9][0-9][0-9].{52}|8[0-9][0-9][0-9][0-9].{88})|3(?:[0-2][0-9][0-9][0-9][0-9].{24}|[3-5][0-9][0-9][0-9][0-9].{16}|[679][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{112})|4(?:[02-5][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{36}|[17][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{160})|5(?:[5-8][0-9][0-9][0-9][0-9].{108}|[1-4][0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{172}|0[0-9][0-9][0-9][0-9].{16})|9(?:[04-9][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{236}|3[0-9][0-9][0-9][0-9].{248}|2[0-9][0-9][0-9][0-9].{32})|0(?:[3-7][0-9][0-9][0-9][0-9].{4}|[089][0-9][0-9][0-9][0-9].{28}|[12][0-9][0-9][0-9][0-9].{12}|_____.{512})|1(?:[0-5][0-9][0-9][0-9][0-9].{52}|[6-8][0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{176})|2(?:[2-8][0-9][0-9][0-9][0-9].{16}|[09][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{12})|8(?:[0-8][0-9][0-9][0-9][0-9].{16}|_____.{8}))|1(?:6(?:[2378][0-9][0-9][0-9][0-9].{80}|[045][0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{212}|6[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{12}|_____.{8})|9(?:[4-9][0-9][0-9][0-9][0-9].{4}|[23][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{80}|_____.{184})|7(?:[2-57-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{80}|6[0-9][0-9][0-9][0-9].{52}|_____.{8})|8(?:[3-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{80}|2[0-9][0-9][0-9][0-9].{16}|_____.{8})|3(?:[0-47][0-9][0-9][0-9][0-9].{4}|[56][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{40}|_____.{8})|5(?:[3-9][0-9][0-9][0-9][0-9].{28}|[12][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{40}|_____.{8})|0(?:(?:[0-69][0-9][0-9][0-9][0-9]|_____).{4}|7[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{92})|2(?:[1-57-9][0-9][0-9][0-9][0-9].{4}|[06][0-9][0-9][0-9][0-9].{28}|_____.{164})|1(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{28}|_____.{8})|4(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{28}|_____.{8}))|0(?:8(?:[4-6][0-9][0-9][0-9][0-9].{88}|[78][0-9][0-9][0-9][0-9].{188}|2[0-9][0-9][0-9][0-9].{152}|0[0-9][0-9][0-9][0-9].{28}|3[0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{4}|_____.{8})|7(?:[1-4][0-9][0-9][0-9][0-9].{4}|[08][0-9][0-9][0-9][0-9].{12}|[59][0-9][0-9][0-9][0-9].{24}|6[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{28}|_____.{332})|6(?:[23689][0-9][0-9][0-9][0-9].{20}|[145][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{80}|0[0-9][0-9][0-9][0-9].{4}|_____.{100})|5(?:[0-37][0-9][0-9][0-9][0-9].{4}|[589][0-9][0-9][0-9][0-9].{20}|[46][0-9][0-9][0-9][0-9].{16}|_____.{8})|3(?:[2-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{80}|_____.{8})|1(?:[0-4][0-9][0-9][0-9][0-9].{224}|[5-9][0-9][0-9][0-9][0-9].{4}|_____.{48})|0(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12}|_____.{48})|2(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16}|_____.{8})|4(?:(?:[0-35-9][0-9][0-9][0-9][0-9]|_____).{4}|4[0-9][0-9][0-9][0-9].{16})|9(?:[0-9][0-9][0-9][0-9][0-9].{12}|_____.{144}))|3(?:6(?:[0159][0-9][0-9][0-9][0-9].{20}|[23][0-9][0-9][0-9][0-9].{12}|[6-8][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{16}|_____.{232})|7(?:[4-8][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{52}|[23][0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9].{40}|_____.{8})|1(?:[0-478][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{80}|9[0-9][0-9][0-9][0-9].{24}|_____.{8})|5(?:[0-267][0-9][0-9][0-9][0-9].{4}|[3-5][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{20}|_____.{8})|8(?:[06-9][0-9][0-9][0-9][0-9].{4}|[2-5][0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{40}|_____.{280})|0(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12}|_____.{504})|3(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{24}|_____.{280})|2(?:[1-9][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{28}|_____.{4})|9(?:[0-9][0-9][0-9][0-9][0-9].{12}|_____.{676})|4(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8}))|4(?:8(?:[1-5][0-9][0-9][0-9][0-9].{188}|[89][0-9][0-9][0-9][0-9].{52}|[67][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16})|6(?:(?:[89][0-9][0-9][0-9][0-9]|_____).{4}|[0-37][0-9][0-9][0-9][0-9].{188}|[4-6][0-9][0-9][0-9][0-9].{16})|9(?:(?:2[0-9][0-9][0-9][0-9]|_____).{4}|[35-9][0-9][0-9][0-9][0-9].{36}|[014][0-9][0-9][0-9][0-9].{52})|4(?:[2-6][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{4})|2(?:[0-7][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{28}|_____.{24})|1(?:(?:[2-9][0-9][0-9][0-9][0-9]|_____).{4}|[01][0-9][0-9][0-9][0-9].{24})|7(?:(?:[1-9][0-9][0-9][0-9][0-9]|_____).{4}|0[0-9][0-9][0-9][0-9].{16})|3(?:[0-6][0-9][0-9][0-9][0-9].{28}|[7-9][0-9][0-9][0-9][0-9].{16})|0(?:[0-9][0-9][0-9][0-9][0-9].{24}|_____.{504})|5(?:[0-9][0-9][0-9][0-9][0-9]|_____).{4})|5(?:6(?:[02-4][0-9][0-9][0-9][0-9].{28}|[6-8][0-9][0-9][0-9][0-9].{140}|1[0-9][0-9][0-9][0-9].{192}|9[0-9][0-9][0-9][0-9].{104}|5[0-9][0-9][0-9][0-9].{60}|_____.{8})|4(?:[4-9][0-9][0-9][0-9][0-9].{32}|[0-2][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{4}|_____.{8})|1(?:[0-6][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{20}|_____.{8})|7(?:[0-8][0-9][0-9][0-9][0-9].{48}|9[0-9][0-9][0-9][0-9].{104}|_____.{4})|0(?:[0-8][0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{4}|_____.{48})|5(?:[0-8][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{92}|_____.{8})|3(?:[0-7][0-9][0-9][0-9][0-9].{20}|[89][0-9][0-9][0-9][0-9].{16})|8(?:[0-7][0-9][0-9][0-9][0-9].{44}|_____.{4})|2(?:[0-9][0-9][0-9][0-9][0-9].{16}|_____.{564}))|7(?:1(?:[239][0-9][0-9][0-9][0-9].{44}|4[0-9][0-9][0-9][0-9].{196}|6[0-9][0-9][0-9][0-9].{436}|0[0-9][0-9][0-9][0-9].{72}|1[0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{60}|5[0-9][0-9][0-9][0-9].{4})|0(?:[0-5][0-9][0-9][0-9][0-9].{32}|[89][0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{92}|7[0-9][0-9][0-9][0-9].{4}|_____.{8})|2(?:[23][0-9][0-9][0-9][0-9].{104}|[01][0-9][0-9][0-9][0-9].{44}|4[0-9][0-9][0-9][0-9].{416}|_____.{8})|7(?:6[0-9][0-9][0-9][0-9].{60}|7[0-9][0-9][0-9][0-9].{48}|_____.{68})|8(?:[48][0-9][0-9][0-9][0-9].{88}|_____.{448})|6(?:7[0-9][0-9][0-9][0-9].{136}|_____.{48})))|5(?:9(?:6(?:[02][0-9][0-9][0-9][0-9].{36}|[39][0-9][0-9][0-9][0-9].{16}|[45][0-9][0-9][0-9][0-9].{20}|[6-8][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{208})|3(?:[015][0-9][0-9][0-9][0-9].{16}|[2-4][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{36})|5(?:[0-4][0-9][0-9][0-9][0-9].{4}|[67][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9].{44})|9(?:[1-4][0-9][0-9][0-9][0-9].{24}|[057][0-9][0-9][0-9][0-9].{4}|[68][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{36})|4(?:[5-8][0-9][0-9][0-9][0-9].{24}|[1-4][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{148}|9[0-9][0-9][0-9][0-9].{12})|0(?:[0-58][0-9][0-9][0-9][0-9].{4}|[67][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{28})|1(?:[03-589][0-9][0-9][0-9][0-9].{12}|[267][0-9][0-9][0-9][0-9].{20}|1[0-9][0-9][0-9][0-9].{4})|2(?:[0134][0-9][0-9][0-9][0-9].{20}|[25-8][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{12})|7(?:[014-9][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{20}|3[0-9][0-9][0-9][0-9].{16})|8(?:[1-8][0-9][0-9][0-9][0-9].{24}|[09][0-9][0-9][0-9][0-9].{4}))|5(?:3(?:[4-7][0-9][0-9][0-9][0-9].{52}|[12][0-9][0-9][0-9][0-9].{28}|[89][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{132}|0[0-9][0-9][0-9][0-9].{4})|5(?:[0-2][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{16}|[45][0-9][0-9][0-9][0-9].{80}|3[0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{4})|7(?:[1-37][0-9][0-9][0-9][0-9].{16}|[4-68][0-9][0-9][0-9][0-9].{4}|[09][0-9][0-9][0-9][0-9].{12})|2(?:[5-9][0-9][0-9][0-9][0-9].{28}|[1-4][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{40})|0(?:[0135-9][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{52}|4[0-9][0-9][0-9][0-9].{40})|6(?:[1-79][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{4})|8(?:[1-79][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{16})|1(?:[2-9][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{12})|9(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16})|4[0-9][0-9][0-9][0-9][0-9].{24})|4(?:6(?:[4-7][0-9][0-9][0-9][0-9].{4}|[13][0-9][0-9][0-9][0-9].{20}|[89][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{40})|7(?:[14578][0-9][0-9][0-9][0-9].{20}|[39][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{92})|8(?:[0-35-7][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{332}|4[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{40})|5(?:[1-59][0-9][0-9][0-9][0-9].{4}|[6-8][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{16})|0(?:[15-9][0-9][0-9][0-9][0-9].{12}|[02-4][0-9][0-9][0-9][0-9].{4})|1(?:[24-9][0-9][0-9][0-9][0-9].{4}|[013][0-9][0-9][0-9][0-9].{12})|2(?:[0-37-9][0-9][0-9][0-9][0-9].{4}|[4-6][0-9][0-9][0-9][0-9].{24})|4(?:[2-9][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{28})|9(?:[0-46-9][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{4})|3[0-9][0-9][0-9][0-9][0-9].{4})|7(?:5(?:[0-39][0-9][0-9][0-9][0-9].{16}|[45][0-9][0-9][0-9][0-9].{180}|[68][0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{40})|9(?:[235-8][0-9][0-9][0-9][0-9].{32}|[01][0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{180}|4[0-9][0-9][0-9][0-9].{52})|7(?:[0168][0-9][0-9][0-9][0-9].{52}|[2-4][0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{32})|2(?:[0-7][0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{4})|1(?:[3-9][0-9][0-9][0-9][0-9].{36}|[0-2][0-9][0-9][0-9][0-9].{4})|3(?:[0-8][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{20})|4(?:[0-79][0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{88})|6(?:[0-24-9][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{52})|0(?:[0-8][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{28})|8[0-9][0-9][0-9][0-9][0-9].{20})|2(?:5(?:[4-6][0-9][0-9][0-9][0-9].{140}|[01][0-9][0-9][0-9][0-9].{28}|[23][0-9][0-9][0-9][0-9].{60}|[78][0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{104})|4(?:[0-3][0-9][0-9][0-9][0-9].{32}|[6-9][0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{92}|5[0-9][0-9][0-9][0-9].{40})|6(?:[3-9][0-9][0-9][0-9][0-9].{44}|[01][0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{104})|8(?:[048][0-9][0-9][0-9][0-9].{88}|1[0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{60})|2(?:[0-7][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{32})|1(?:[0-8][0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{16})|0[013-9][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9][0-9].{32}|70[0-9][0-9][0-9][0-9].{44}|92[0-9][0-9][0-9][0-9].{60})|1(?:8(?:[3679][0-9][0-9][0-9][0-9].{24}|[024][0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{4})|3(?:[2-46-9][0-9][0-9][0-9][0-9].{4}|[05][0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{16})|6(?:[0-49][0-9][0-9][0-9][0-9].{4}|[578][0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{24})|7(?:[13468][0-9][0-9][0-9][0-9].{20}|[2579][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{4})|1(?:[014-9][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{36}|3[0-9][0-9][0-9][0-9].{80})|0(?:[2-7][0-9][0-9][0-9][0-9].{12}|[0189][0-9][0-9][0-9][0-9].{4})|5(?:[0-689][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{80})|[24][0-9][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9][0-9].{12})|8(?:6(?:[5-8][0-9][0-9][0-9][0-9].{12}|[01][0-9][0-9][0-9][0-9].{28}|[2-4][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{16})|4(?:[1-7][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{24})|7(?:[1-6][0-9][0-9][0-9][0-9].{16}|[7-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12})|8(?:[015-79][0-9][0-9][0-9][0-9].{4}|[2-48][0-9][0-9][0-9][0-9].{16})|9(?:[1-8][0-9][0-9][0-9][0-9].{4}|[09][0-9][0-9][0-9][0-9].{16})|5(?:[0-79][0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{16})|[23][0-9][0-9][0-9][0-9][0-9].{24}|[01][0-9][0-9][0-9][0-9][0-9].{4}))|7(?:0(?:9(?:[15-8][0-9][0-9][0-9][0-9].{28}|[2-4][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{60})|7(?:[014578][0-9][0-9][0-9][0-9].{16}|[236][0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{32})|0(?:[4-9][0-9][0-9][0-9][0-9].{4}|[1-3][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{12})|2(?:[2-8][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{36})|4(?:[3-9][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{4})|8(?:[1-6][0-9][0-9][0-9][0-9].{32}|[89][0-9][0-9][0-9][0-9].{60}|7[0-9][0-9][0-9][0-9].{92})|5(?:[0-7][0-9][0-9][0-9][0-9].{20}|[89][0-9][0-9][0-9][0-9].{16})|6(?:[4-9][0-9][0-9][0-9][0-9].{32}|[0-3][0-9][0-9][0-9][0-9].{16})|3[0-9][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9][0-9].{4})|2(?:2(?:[2-4][0-9][0-9][0-9][0-9].{140}|[5689][0-9][0-9][0-9][0-9].{44}|[01][0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{284})|1(?:[16-9][0-9][0-9][0-9][0-9].{28}|[3-5][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{60})|3(?:[0-35-7][0-9][0-9][0-9][0-9].{44}|8[0-9][0-9][0-9][0-9].{104}|4[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{72})|4(?:[23][0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{4})|8(?:3[0-9][0-9][0-9][0-9].{356}|2[0-9][0-9][0-9][0-9].{60}|8[0-9][0-9][0-9][0-9].{88})|5(?:0[0-9][0-9][0-9][0-9].{80}|5[0-9][0-9][0-9][0-9].{60}|7[0-9][0-9][0-9][0-9].{92})|(?:7[23]|92)[0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9][0-9].{32}|63[0-9][0-9][0-9][0-9].{20})|3(?:2(?:[1-489][0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{92}|7[0-9][0-9][0-9][0-9].{72})|1(?:[4-9][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{92}|3[0-9][0-9][0-9][0-9].{40})|4(?:[0-4][0-9][0-9][0-9][0-9].{44}|5[0-9][0-9][0-9][0-9].{104}|6[0-9][0-9][0-9][0-9].{48})|8(?:[08][0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{92})|7(?:2[0-9][0-9][0-9][0-9].{268}|3[0-9][0-9][0-9][0-9].{60})|9(?:9[0-9][0-9][0-9][0-9].{180}|8[0-9][0-9][0-9][0-9].{80})|0[0-9][0-9][0-9][0-9][0-9].{32}|3[0-9][0-9][0-9][0-9][0-9].{44})|1(?:4(?:[6-9][0-9][0-9][0-9][0-9].{20}|[3-5][0-9][0-9][0-9][0-9].{16}|[0-2][0-9][0-9][0-9][0-9].{4})|1(?:[0-46-8][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{40})|5(?:[0-5][0-9][0-9][0-9][0-9].{20}|[6-9][0-9][0-9][0-9][0-9].{16})|6(?:[2-9][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{20})|7(?:[016-8][0-9][0-9][0-9][0-9].{52}|[2-59][0-9][0-9][0-9][0-9].{16})|9(?:[1-9][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{16})|8(?:[1-57-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{52})|[23][0-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9][0-9].{4})|4(?:0(?:[23][0-9][0-9][0-9][0-9].{104}|1[0-9][0-9][0-9][0-9].{72}|0[0-9][0-9][0-9][0-9].{4})|10[0-9][0-9][0-9][0-9].{344}))|0(?:0(?:4(?:[04][0-9][0-9][0-9][0-9].{12}|_____.{4})|0(?:0[0-9][0-9][0-9][0-9].{452}|_____.{8})|3(?:3[0-9][0-9][0-9][0-9].{4}|_____.{232})|6(?:6[0-9][0-9][0-9][0-9].{16}|_____.{8})|80[0-9][0-9][0-9][0-9].{136}|54[0-9][0-9][0-9][0-9].{16}|2_____.{24}|1_____.{8}|9_____.{4})|1(?:6(?:[0-3][0-9][0-9][0-9][0-9].{20}|[67][0-9][0-9][0-9][0-9].{16})|0(?:0[0-9][0-9][0-9][0-9].{188}|_____.{8})|5(?:[0-9][0-9][0-9][0-9][0-9].{20}|_____.{8})|23[0-9][0-9][0-9][0-9].{224}|44[0-9][0-9][0-9][0-9].{12}|76[0-9][0-9][0-9][0-9].{52}|8_____.{4})|3(?:6(?:[78][0-9][0-9][0-9][0-9].{40}|_____.{36})|(?:16[0-9][0-9][0-9][0-9]|[03]_____).{4}|80[0-9][0-9][0-9][0-9].{204}|90[0-9][0-9][0-9][0-9].{212}|44[0-9][0-9][0-9][0-9].{12})|8(?:0(?:[0-9][0-9][0-9][0-9][0-9].{8}|_____.{664})|(?:1[0-9][0-9][0-9][0-9][0-9]|[679]_____).{8}|8[01][0-9][0-9][0-9][0-9].{12})|2(?:0(?:0[0-9][0-9][0-9][0-9].{180}|_____.{100})|44[0-9][0-9][0-9][0-9].{12}|[256]_____.{8}|3_____.{4})|9(?:9(?:9[0-9][0-9][0-9][0-9].{36}|_____.{4})|88[0-9][0-9][0-9][0-9].{36}|0_____.{24})|4(?:0(?:[1-4][0-9][0-9][0-9][0-9]|_____)|4[12][0-9][0-9][0-9][0-9]).{4}|7(?:[0-9][0-9][0-9][0-9][0-9][0-9].{8}|0_____.{4})|6(?:[0-9][0-9][0-9][0-9][0-9][0-9]|0_____).{8}|5(?:8_____.{588}|5_____.{4}))|2(?:1(?:(?:[0-9][0-9][0-9][0-9][0-9][0-9]|[12]_____).{8}|[39]_____.{144}|4_____.{220}|6_____.{148}|8_____.{280}|5_____.{80}|7_____.{12}|0_____.{4})|3(?:(?:[0-9][0-9][0-9][0-9][0-9][0-9]|7_____).{8}|[89]_____.{220}|[45]_____.{48}|0_____.{704}|6_____.{164}|2_____.{24}|3_____.{16}|1_____.{4})|0(?:(?:[0-9][0-9][0-9][0-9][0-9][0-9]|3_____).{8}|[67]_____.{144}|[459]_____.{4}|0_____.{632}|2_____.{100}|8_____.{164}|1_____.{48})|7(?:(?:[0-9][0-9][0-9][0-9][0-9][0-9]|3_____).{8}|[689]_____.{220}|[14]_____.{164}|[05]_____.{4}|2_____.{216}|7_____.{112})|8(?:[0-9][0-9][0-9][0-9][0-9][0-9].{8}|[346]_____.{164}|[01]_____.{512}|5_____.{220}|8_____.{692}|9_____.{276}|2_____.{32})|2(?:(?:[0-9][0-9][0-9][0-9][0-9][0-9]|[037]_____).{8}|[249]_____.{4}|[58]_____.{48}|6_____.{184}|1_____.{12})|4(?:(?:[0-9][0-9][0-9][0-9][0-9][0-9]|[0169]_____).{8}|[35]_____.{4}|2_____.{540}|8_____.{112}|4_____.{12})|6(?:(?:[0-9][0-9][0-9][0-9][0-9][0-9]|[06]_____).{8}|[578]_____.{220}|9_____.{280}|4_____.{48}|2_____.{4})|9(?:(?:[0-9][0-9][0-9][0-9][0-9][0-9]|2_____).{8}|[3568]_____.{220}|9_____.{112}|4_____.{24}|0_____.{4})|5(?:(?:[0-9][0-9][0-9][0-9][0-9][0-9]|8_____).{8}|[479]_____.{164}|[1256]_____.{4}|0_____.{688}))|1(?:0(?:3(?:[2-6][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{12}|[7-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|7(?:[5-9][0-9][0-9][0-9][0-9].{36}|[1-4][0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{16})|9(?:[17-9][0-9][0-9][0-9][0-9].{16}|[2-6][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{188})|0(?:[0-6][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{4}|_____.{20})|6(?:[1-689][0-9][0-9][0-9][0-9].{4}|[07][0-9][0-9][0-9][0-9].{16}|_____.{20})|2(?:[2-9][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{4})|5(?:[2-9][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{16})|4(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12})|1(?:[0-9][0-9][0-9][0-9][0-9].{4}|_____.{8})|8[0-9][0-9][0-9][0-9][0-9].{36})|3(?:[13]_____.{8}|2_____.{232}|0_____.{20})|2(?:2_____.{68}|0_____.{8}|3_____.{4})|1(?:[247]_____.{4}|[03]_____.{8})|88_____.{32}|50_____.{4})|9(?:1(?:(?:[0-9][0-9][0-9][0-9][0-9][0-9]|[29]_____).{8}|4_____.{564}|5_____.{624}|6_____.{168}|8_____.{184}|3_____.{24}|0_____.{4})|0(?:(?:[0-9][0-9][0-9][0-9][0-9][0-9]|[0139]_____).{8}|[28]_____.{164}|4_____.{184}|5_____.{48}|7_____.{32}|6_____.{4})|9(?:[1249]_____.{4}|[36]_____.{8}|0_____.{40}|5_____.{48}|8_____.{16})|2(?:[249]_____.{8}|1_____.{168}|5_____.{256}|6_____.{684}|0_____.{4})|7(?:[02]_____.{32}|[59]_____.{4}|3_____.{184}|1_____.{48}|7_____.{8})|4(?:[19]_____.{48}|[45]_____.{8}|8_____.{184}|0_____.{32})|3(?:[03-68]_____.{8}|[79]_____.{4}|2_____.{48})|8(?:[09]_____.{8}|[78]_____.{4}|1_____.{184})|6(?:0_____.{100}|9_____.{16}|6_____.{8})|5(?:0_____.{56}|5_____.{8}|9_____.{4}))|4(?:5(?:6(?:[4689][0-9][0-9][0-9][0-9].{20}|[2357][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{12})|0(?:[0135-7][0-9][0-9][0-9][0-9].{12}|[248][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{36})|1(?:[02-5][0-9][0-9][0-9][0-9].{12}|[17-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{16})|5(?:[0-579][0-9][0-9][0-9][0-9].{4}|[68][0-9][0-9][0-9][0-9].{20})|7(?:[4-9][0-9][0-9][0-9][0-9].{4}|[0-3][0-9][0-9][0-9][0-9].{20})|4(?:[0-8][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{80})|8(?:[0-8][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{16})|[23][0-9][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9][0-9].{12})|4[0-9][0-9][0-9][0-9][0-9][0-9].{8})|39(?:0(?:[57-9][0-9][0-9][0-9][0-9].{44}|[01][0-9][0-9][0-9][0-9].{28}|[46][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{388}|2[0-9][0-9][0-9][0-9].{4})|1(?:[2-9][0-9][0-9][0-9][0-9].{44}|[01][0-9][0-9][0-9][0-9].{332})|2(?:1[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{44})|8[028][0-9][0-9][0-9][0-9].{88}|90[0-9][0-9][0-9][0-9].{80})|8[0-9][0-9][0-9][0-9][0-9][0-9][0-9].{8})|4(?:8(?:6(?:8(?:[38][0-9][0-9][0-9][0-9].{152}|[59][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{252}|4[0-9][0-9][0-9][0-9].{176}|6[0-9][0-9][0-9][0-9].{212}|1[0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{92})|1(?:[3-5][0-9][0-9][0-9][0-9].{16}|[7-9][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{132}|0[0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{80})|6(?:[2-59][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{80}|7[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{60})|2(?:[57-9][0-9][0-9][0-9][0-9].{24}|[26][0-9][0-9][0-9][0-9].{80}|[34][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{40})|0(?:[0-5][0-9][0-9][0-9][0-9].{4}|[78][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{28})|4(?:[1-49][0-9][0-9][0-9][0-9].{4}|[6-8][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{24})|9(?:[013479][0-9][0-9][0-9][0-9].{4}|[25][0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{12})|7(?:[1-578][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{28})|5(?:[1-57-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{4})|3(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{28}))|3(?:8(?:[34][0-9][0-9][0-9][0-9].{80}|[5-7][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{152}|0[0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{92}|8[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{40})|5(?:[045][0-9][0-9][0-9][0-9].{40}|[1-3][0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{172}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{4})|4(?:[6-9][0-9][0-9][0-9][0-9].{36}|[01][0-9][0-9][0-9][0-9].{12}|[45][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{112}|2[0-9][0-9][0-9][0-9].{4})|7(?:[0-24][0-9][0-9][0-9][0-9].{16}|[6-8][0-9][0-9][0-9][0-9].{52}|3[0-9][0-9][0-9][0-9].{60}|5[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{28})|9(?:[0-2458][0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{300}|3[0-9][0-9][0-9][0-9].{60}|7[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{4})|3(?:[124-69][0-9][0-9][0-9][0-9].{4}|[07][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{112}|8[0-9][0-9][0-9][0-9].{80})|0(?:[1-4][0-9][0-9][0-9][0-9].{12}|[57-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{16})|2(?:[2-5][0-9][0-9][0-9][0-9].{16}|[6-9][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{12})|1(?:[0-24-6][0-9][0-9][0-9][0-9].{4}|[7-9][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{28})|6(?:[0-4][0-9][0-9][0-9][0-9].{16}|[5-9][0-9][0-9][0-9][0-9].{20}))|8(?:5(?:[1-39][0-9][0-9][0-9][0-9].{20}|[67][0-9][0-9][0-9][0-9].{16}|[45][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{12})|6(?:[1459][0-9][0-9][0-9][0-9].{4}|[6-8][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{208}|2[0-9][0-9][0-9][0-9].{136}|3[0-9][0-9][0-9][0-9].{40})|1(?:[1268][0-9][0-9][0-9][0-9].{12}|[045][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{28})|2(?:[018][0-9][0-9][0-9][0-9].{12}|[4-6][0-9][0-9][0-9][0-9].{20}|[279][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{40})|0(?:[03-589][0-9][0-9][0-9][0-9].{4}|[26][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{40})|8(?:[0-3][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{36}|[4-6][0-9][0-9][0-9][0-9].{4})|3(?:[0-58][0-9][0-9][0-9][0-9].{12}|[79][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{160})|7(?:[1-378][0-9][0-9][0-9][0-9].{16}|[4-69][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{88})|4(?:[0-4][0-9][0-9][0-9][0-9].{4}|[5-79][0-9][0-9][0-9][0-9].{20}|8[0-9][0-9][0-9][0-9].{12})|9(?:[1-8][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{36}))|9(?:6(?:[3-5][0-9][0-9][0-9][0-9].{20}|[02][0-9][0-9][0-9][0-9].{28}|[6-8][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{12})|5(?:[46-8][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{24}|5[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{20}|3[0-9][0-9][0-9][0-9].{4})|2(?:[12459][0-9][0-9][0-9][0-9].{4}|[6-8][0-9][0-9][0-9][0-9].{20}|3[0-9][0-9][0-9][0-9].{136}|0[0-9][0-9][0-9][0-9].{12})|8(?:[135-8][0-9][0-9][0-9][0-9].{16}|[29][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{160}|0[0-9][0-9][0-9][0-9].{28})|0(?:[02358][0-9][0-9][0-9][0-9].{4}|[467][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{40})|1(?:[01458][0-9][0-9][0-9][0-9].{4}|[369][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{16})|7(?:[1247-9][0-9][0-9][0-9][0-9].{4}|[56][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{28}|3[0-9][0-9][0-9][0-9].{16})|9(?:[046-9][0-9][0-9][0-9][0-9].{4}|[25][0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{28})|3(?:[014-6][0-9][0-9][0-9][0-9].{4}|[7-9][0-9][0-9][0-9][0-9].{24})|4[0-9][0-9][0-9][0-9][0-9].{24})|2(?:7(?:[0-3][0-9][0-9][0-9][0-9].{56}|4[0-9][0-9][0-9][0-9].{352}|5[0-9][0-9][0-9][0-9].{192}|7[0-9][0-9][0-9][0-9].{208}|8[0-9][0-9][0-9][0-9].{148}|9[0-9][0-9][0-9][0-9].{356}|6[0-9][0-9][0-9][0-9].{52})|8(?:[579][0-9][0-9][0-9][0-9].{268}|[2-4][0-9][0-9][0-9][0-9].{60}|6[0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9].{88}|8[0-9][0-9][0-9][0-9].{16})|9(?:[3-7][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{268}|8[0-9][0-9][0-9][0-9].{136}|2[0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{4})|5(?:[5-9][0-9][0-9][0-9][0-9].{56}|[01][0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{140}|2[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{72})|3(?:[3-9][0-9][0-9][0-9][0-9].{40}|[01][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{60})|0(?:[0-6][0-9][0-9][0-9][0-9].{16}|[7-9][0-9][0-9][0-9][0-9].{32})|4(?:[2-9][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{40})|2(?:[0-7][0-9][0-9][0-9][0-9].{32}|[89][0-9][0-9][0-9][0-9].{4})|6(?:[013-9][0-9][0-9][0-9][0-9].{56}|2[0-9][0-9][0-9][0-9].{60})|1[0-9][0-9][0-9][0-9][0-9].{32})|1(?:4(?:[4-6][0-9][0-9][0-9][0-9].{108}|[0-2][0-9][0-9][0-9][0-9].{36}|[78][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{172}|3[0-9][0-9][0-9][0-9].{4})|8(?:[2-69][0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{300}|0[0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{40})|6(?:[0-5][0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{4})|9(?:[2-8][0-9][0-9][0-9][0-9].{16}|[09][0-9][0-9][0-9][0-9].{156}|1[0-9][0-9][0-9][0-9].{60})|0(?:[0-59][0-9][0-9][0-9][0-9].{4}|[78][0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{236})|7(?:[1-57-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{52})|3(?:[013469][0-9][0-9][0-9][0-9].{52}|[2578][0-9][0-9][0-9][0-9].{36})|5(?:[0-46-9][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9].{36})|1(?:[0-8][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{36})|2[0-9][0-9][0-9][0-9][0-9].{36})|4(?:3(?:[26][0-9][0-9][0-9][0-9].{104}|[7-9][0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{196}|4[0-9][0-9][0-9][0-9].{168}|0[0-9][0-9][0-9][0-9].{92}|3[0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{16})|8(?:[45][0-9][0-9][0-9][0-9].{60}|2[0-9][0-9][0-9][0-9].{268}|6[0-9][0-9][0-9][0-9].{188}|8[0-9][0-9][0-9][0-9].{284}|0[0-9][0-9][0-9][0-9].{88})|2(?:[0-4][0-9][0-9][0-9][0-9].{28}|[7-9][0-9][0-9][0-9][0-9].{92}|5[0-9][0-9][0-9][0-9].{72}|6[0-9][0-9][0-9][0-9].{4})|4(?:[1-5][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{344}|7[0-9][0-9][0-9][0-9].{104}|8[0-9][0-9][0-9][0-9].{60})|1(?:[5-9][0-9][0-9][0-9][0-9].{40}|[0-2][0-9][0-9][0-9][0-9].{32}|[34][0-9][0-9][0-9][0-9].{4})|0[0-9][0-9][0-9][0-9][0-9].{32}|50[0-9][0-9][0-9][0-9].{112}|6[0-9][0-9][0-9][0-9][0-9].{48}|76[0-9][0-9][0-9][0-9].{52}|98[0-9][0-9][0-9][0-9].{88})|0(?:3(?:[3-6][0-9][0-9][0-9][0-9].{16}|[79][0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{172}|0[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{4})|9(?:[4-68][0-9][0-9][0-9][0-9].{60}|[23][0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{156}|0[0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{4})|8(?:[3-9][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{60}|2[0-9][0-9][0-9][0-9].{360})|7(?:[016-8][0-9][0-9][0-9][0-9].{52}|[2-5][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{60})|1(?:[0-24-6][0-9][0-9][0-9][0-9].{4}|[7-9][0-9][0-9][0-9][0-9].{36}|3[0-9][0-9][0-9][0-9].{28})|4(?:[0-8][0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{16})|2[0-9][0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9][0-9].{4})|5(?:0(?:[6-9][0-9][0-9][0-9][0-9].{56}|[0-2][0-9][0-9][0-9][0-9].{40}|[3-5][0-9][0-9][0-9][0-9].{28})|1(?:[0-8][0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{104})|(?:8[08]|44)[0-9][0-9][0-9][0-9].{88}|2[0-8][0-9][0-9][0-9][0-9].{44}|38[0-9][0-9][0-9][0-9].{136}|64[0-9][0-9][0-9][0-9].{20})|799[0-9][0-9][0-9][0-9].{4})|2(?:6(?:7(?:[457][0-9][0-9][0-9][0-9].{40}|[0-2][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{208}|3[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{20})|8(?:[3-579][0-9][0-9][0-9][0-9].{24}|[026][0-9][0-9][0-9][0-9].{56}|8[0-9][0-9][0-9][0-9].{204}|1[0-9][0-9][0-9][0-9].{40})|6(?:[0-267][0-9][0-9][0-9][0-9].{4}|[3-5][0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{36})|4(?:[0-3578][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{80})|2(?:[0-248][0-9][0-9][0-9][0-9].{4}|[5-7][0-9][0-9][0-9][0-9].{36}|[39][0-9][0-9][0-9][0-9].{16})|0(?:[04-9][0-9][0-9][0-9][0-9].{4}|[12][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{36})|9(?:[1-57-9][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{40})|5(?:[1-57-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{80})|1(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16})|3(?:[0-57-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{16}))|7(?:8(?:[027][0-9][0-9][0-9][0-9].{4}|[19][0-9][0-9][0-9][0-9].{40}|[56][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{152}|4[0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{24})|1(?:[089][0-9][0-9][0-9][0-9].{28}|[1346][0-9][0-9][0-9][0-9].{4}|[27][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{16})|3(?:[0-4][0-9][0-9][0-9][0-9].{20}|[68][0-9][0-9][0-9][0-9].{16}|[79][0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{4})|7(?:[5-9][0-9][0-9][0-9][0-9].{4}|[13][0-9][0-9][0-9][0-9].{12}|[24][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{28})|0(?:[035-9][0-9][0-9][0-9][0-9].{12}|[12][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{160})|4(?:[0-589][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{12})|2(?:[0-35][0-9][0-9][0-9][0-9].{12}|[46-9][0-9][0-9][0-9][0-9].{20})|5(?:[0-689][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{12})|6(?:[0-689][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{12})|9[0-9][0-9][0-9][0-9][0-9].{12})|2(?:1(?:[12][0-9][0-9][0-9][0-9].{108}|[78][0-9][0-9][0-9][0-9].{104}|[34][0-9][0-9][0-9][0-9].{72}|[06][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{80})|0(?:[0-7][0-9][0-9][0-9][0-9].{32}|[89][0-9][0-9][0-9][0-9].{40})|2(?:2[0-9][0-9][0-9][0-9].{188}|3[0-9][0-9][0-9][0-9].{60})|4[2-4][0-9][0-9][0-9][0-9].{4}|32[0-9][0-9][0-9][0-9].{60}|55[0-9][0-9][0-9][0-9].{48}|84[0-9][0-9][0-9][0-9].{88})|0(?:0(?:[0-46][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{32})|(?:9[45]|55)[0-9][0-9][0-9][0-9].{12}|10[0-9][0-9][0-9][0-9].{24}|30[0-9][0-9][0-9][0-9].{16}|40[0-9][0-9][0-9][0-9].{60}|61[0-9][0-9][0-9][0-9].{20}|88[0-9][0-9][0-9][0-9].{88}|20[0-9][0-9][0-9][0-9].{4})|8(?:0(?:[089][0-9][0-9][0-9][0-9].{104}|[5-7][0-9][0-9][0-9][0-9].{312}|[23][0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{168}|4[0-9][0-9][0-9][0-9].{72})|1(?:[3-9][0-9][0-9][0-9][0-9].{44}|[12][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{112})|2[0-3][0-9][0-9][0-9][0-9].{44}))|1(?:3(?:6(?:[1279][0-9][0-9][0-9][0-9].{16}|[04][0-9][0-9][0-9][0-9].{52}|[36][0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{172}|8[0-9][0-9][0-9][0-9].{88})|4(?:[4-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{60}|2[0-9][0-9][0-9][0-9].{28}|3[0-9][0-9][0-9][0-9].{4})|3(?:[0-24][0-9][0-9][0-9][0-9].{16}|[6-9][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{112}|5[0-9][0-9][0-9][0-9].{248})|5(?:[0367][0-9][0-9][0-9][0-9].{52}|[458][0-9][0-9][0-9][0-9].{16}|[12][0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{4})|2(?:[124-8][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{28})|0(?:[0-49][0-9][0-9][0-9][0-9].{16}|[5-7][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{12})|9(?:[0-578][0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{300}|9[0-9][0-9][0-9][0-9].{16})|7(?:[02-57-9][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{52})|8(?:[2-9][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{92})|1(?:[0-257-9][0-9][0-9][0-9][0-9].{4}|[346][0-9][0-9][0-9][0-9].{16}))|1(?:6(?:[578][0-9][0-9][0-9][0-9].{40}|[01][0-9][0-9][0-9][0-9].{32}|[23][0-9][0-9][0-9][0-9].{92}|6[0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{4})|8(?:[024-6][0-9][0-9][0-9][0-9].{44}|7[0-9][0-9][0-9][0-9].{108}|9[0-9][0-9][0-9][0-9].{136}|1[0-9][0-9][0-9][0-9].{60}|8[0-9][0-9][0-9][0-9].{88}|3[0-9][0-9][0-9][0-9].{4})|9(?:[4-6][0-9][0-9][0-9][0-9].{104}|[028][0-9][0-9][0-9][0-9].{88}|[79][0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{60}|3[0-9][0-9][0-9][0-9].{72})|7(?:[02-4][0-9][0-9][0-9][0-9].{28}|[69][0-9][0-9][0-9][0-9].{44}|[57][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{108}|1[0-9][0-9][0-9][0-9].{60})|3(?:[35-9][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{20}|2[0-9][0-9][0-9][0-9].{172}|4[0-9][0-9][0-9][0-9].{44})|1(?:[1-7][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{40})|4(?:[0-7][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{32})|0[0-9][0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9][0-9].{32})|5(?:3(?:[3-8][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{4})|1(?:[0-5][0-9][0-9][0-9][0-9].{16}|[6-9][0-9][0-9][0-9][0-9].{32})|5(?:[12][0-9][0-9][0-9][0-9].{48}|0[0-9][0-9][0-9][0-9].{80})|0[0-9][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9][0-9].{32}|40[0-9][0-9][0-9][0-9].{104}))|3(?:0(?:9(?:[1-5][0-9][0-9][0-9][0-9].{52}|[09][0-9][0-9][0-9][0-9].{16}|[78][0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{60})|0(?:[127-9][0-9][0-9][0-9][0-9].{4}|[34][0-9][0-9][0-9][0-9].{12}|[56][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{24})|5(?:[5-9][0-9][0-9][0-9][0-9].{16}|[1-3][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{12})|6(?:[1-36][0-9][0-9][0-9][0-9].{16}|[57-9][0-9][0-9][0-9][0-9].{4}|[04][0-9][0-9][0-9][0-9].{12})|1(?:[16-9][0-9][0-9][0-9][0-9].{4}|[2-5][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{40})|4(?:[0-5][0-9][0-9][0-9][0-9].{4}|[7-9][0-9][0-9][0-9][0-9].{28}|6[0-9][0-9][0-9][0-9].{40})|8(?:[1-35-79][0-9][0-9][0-9][0-9].{4}|[08][0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{28})|3(?:[4-9][0-9][0-9][0-9][0-9].{4}|[0-3][0-9][0-9][0-9][0-9].{24})|7(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16})|2[0-9][0-9][0-9][0-9][0-9].{24})|4(?:5(?:[1-368][0-9][0-9][0-9][0-9].{4}|[05][0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{20}|9[0-9][0-9][0-9][0-9].{80})|7(?:[1-35][0-9][0-9][0-9][0-9].{16}|[46][0-9][0-9][0-9][0-9].{80}|[7-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{20})|6(?:[0-3568][0-9][0-9][0-9][0-9].{20}|[47][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{80})|1(?:[0-389][0-9][0-9][0-9][0-9].{4}|[5-7][0-9][0-9][0-9][0-9].{52}|4[0-9][0-9][0-9][0-9].{28})|8(?:[2-8][0-9][0-9][0-9][0-9].{16}|[19][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{28})|0(?:[0-24-8][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{36})|3(?:[2-9][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{12})|2(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16})|9[0-9][0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9][0-9].{4})|[278][0-9][0-9][0-9][0-9][0-9][0-9].{8})|5(?:6(?:4(?:[0-24][0-9][0-9][0-9][0-9].{28}|[359][0-9][0-9][0-9][0-9].{4}|[78][0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{12})|5(?:[013][0-9][0-9][0-9][0-9].{20}|[5-79][0-9][0-9][0-9][0-9].{4}|[28][0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{36})|8(?:[1256][0-9][0-9][0-9][0-9].{4}|[7-9][0-9][0-9][0-9][0-9].{56}|[34][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{16})|0(?:[0-5][0-9][0-9][0-9][0-9].{4}|[6-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{36})|3(?:[0-579][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{16})|9(?:[013-57-9][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{4})|6(?:[0-578][0-9][0-9][0-9][0-9].{24}|[69][0-9][0-9][0-9][0-9].{20})|1(?:[0-247-9][0-9][0-9][0-9][0-9].{4}|[356][0-9][0-9][0-9][0-9].{12})|7[0-9][0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9][0-9].{4})|7(?:0(?:[13589][0-9][0-9][0-9][0-9].{4}|[267][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{80}|4[0-9][0-9][0-9][0-9].{28})|5(?:[0-46][0-9][0-9][0-9][0-9].{28}|[59][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{80}|8[0-9][0-9][0-9][0-9].{16})|8(?:[0189][0-9][0-9][0-9][0-9].{16}|[4-7][0-9][0-9][0-9][0-9].{12}|[23][0-9][0-9][0-9][0-9].{4})|7(?:[2-46-9][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{24}|5[0-9][0-9][0-9][0-9].{80})|4(?:[5-9][0-9][0-9][0-9][0-9].{28}|[0134][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{16})|3(?:[0-7][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{40})|9(?:[0-279][0-9][0-9][0-9][0-9].{16}|[3-68][0-9][0-9][0-9][0-9].{4})|2(?:[013-9][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{12})|6[0-9][0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9][0-9].{4})|80(?:[3-9][0-9][0-9][0-9][0-9].{44}|[12][0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{72})|0[0-9][0-9][0-9][0-9][0-9][0-9].{8})|6(?:3(?:3(?:[489][0-9][0-9][0-9][0-9].{24}|[5-7][0-9][0-9][0-9][0-9].{16}|[13][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{12})|6(?:[2-46][0-9][0-9][0-9][0-9].{4}|[7-9][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{40})|0(?:[236-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{80}|4[0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{16})|5(?:[0246-8][0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9].{4})|7(?:[16-9][0-9][0-9][0-9][0-9].{4}|[235][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{24})|4(?:[25-9][0-9][0-9][0-9][0-9].{24}|[014][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{12})|2(?:[0-24-9][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{12})|[18][0-9][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9][0-9].{12})|9(?:7(?:[3479][0-9][0-9][0-9][0-9].{16}|[12][0-9][0-9][0-9][0-9].{12}|[568][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{40})|9(?:[1-57][0-9][0-9][0-9][0-9].{4}|[09][0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{112}|8[0-9][0-9][0-9][0-9].{248})|6(?:[1-6][0-9][0-9][0-9][0-9].{16}|[78][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{12})|4(?:[0-7][0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{4})|5(?:[4-9][0-9][0-9][0-9][0-9].{16}|[0-3][0-9][0-9][0-9][0-9].{12})|1(?:[4-9][0-9][0-9][0-9][0-9].{4}|[0-3][0-9][0-9][0-9][0-9].{24})|3(?:[0-7][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{40})|8(?:[1-7][0-9][0-9][0-9][0-9].{4}|[089][0-9][0-9][0-9][0-9].{16})|0[0-9][0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9][0-9].{4})|[6-8][0-9][0-9][0-9][0-9][0-9][0-9].{8})|0(?:0(?:1(?:[45][0-9][0-9][0-9][0-9].{16}|[06][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{352}|2[0-9][0-9][0-9][0-9].{628}|3[0-9][0-9][0-9][0-9].{420})|0(?:[2-47-9][0-9][0-9][0-9][0-9].{4}|[056][0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{152})|4(?:[0-35-9][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{12})|7(?:[05-7][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{16})|6[3-9][0-9][0-9][0-9][0-9].{16}|(?:30|59)[0-9][0-9][0-9][0-9].{4}|80[0-9][0-9][0-9][0-9].{136}|90[0-9][0-9][0-9][0-9].{24})|1(?:6(?:[02356][0-9][0-9][0-9][0-9].{20}|[14][0-9][0-9][0-9][0-9].{160})|5[0-9][0-9][0-9][0-9][0-9].{20}|23[0-9][0-9][0-9][0-9].{40}|44[0-9][0-9][0-9][0-9].{12}|76[0-9][0-9][0-9][0-9].{52}|00[0-9][0-9][0-9][0-9].{4})|4(?:0(?:[3-5][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{284})|4[1-3][0-9][0-9][0-9][0-9].{4}|80[0-9][0-9][0-9][0-9].{204}|90[0-9][0-9][0-9][0-9].{212}|66[0-9][0-9][0-9][0-9].{16})|3(?:1[36][0-9][0-9][0-9][0-9].{4}|44[0-9][0-9][0-9][0-9].{12}|66[0-9][0-9][0-9][0-9].{16})|8(?:[0-7][0-9][0-9][0-9][0-9][0-9].{8}|8[0-2][0-9][0-9][0-9][0-9].{12})|5(?:(?:7[78]|66)[0-9][0-9][0-9][0-9].{16}|44[0-9][0-9][0-9][0-9].{12})|9(?:(?:88|99)[0-9][0-9][0-9][0-9].{36}|40[0-9][0-9][0-9][0-9].{4})|2(?:6[5-7][0-9][0-9][0-9][0-9].{16}|44[0-9][0-9][0-9][0-9].{12})|[67][0-9][0-9][0-9][0-9][0-9][0-9].{8})|4(?:3(?:8(?:[01][0-9][0-9][0-9][0-9].{16}|[57][0-9][0-9][0-9][0-9].{28}|[89][0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{180}|2[0-9][0-9][0-9][0-9].{52}|4[0-9][0-9][0-9][0-9].{92})|7(?:[03679][0-9][0-9][0-9][0-9].{52}|[1245][0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{16})|2(?:[3-9][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{16})|5(?:[0-7][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{36})|1(?:[5-9][0-9][0-9][0-9][0-9].{28}|[0-4][0-9][0-9][0-9][0-9].{4})|4(?:[0-24-8][0-9][0-9][0-9][0-9].{4}|[39][0-9][0-9][0-9][0-9].{16})|3(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12})|6[0-9][0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9][0-9].{4})|4(?:0[0-2][0-9][0-9][0-9][0-9].{312}|44[0-9][0-9][0-9][0-9].{60}|88[0-9][0-9][0-9][0-9].{88})|80(?:0[0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{44})|2[0-9][0-9][0-9][0-9][0-9][0-9].{8})|[79][0-9][0-9][0-9][0-9][0-9][0-9][0-9].{8})|2(?:7(?:8(?:7(?:[2-4][0-9][0-9][0-9][0-9].{28}|[56][0-9][0-9][0-9][0-9].{140}|[08][0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{300}|1[0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{72})|6(?:[13-6][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{44}|2[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{92}|8[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{40})|9(?:[01][0-9][0-9][0-9][0-9].{44}|4[0-9][0-9][0-9][0-9].{104}|2[0-9][0-9][0-9][0-9].{88}|3[0-9][0-9][0-9][0-9].{72}|5[0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{60})|2(?:[0-489][0-9][0-9][0-9][0-9].{16}|[56][0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{172})|4(?:[1-7][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{44})|0(?:[3-79][0-9][0-9][0-9][0-9].{36}|[0-2][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{60})|8(?:[0235-79][0-9][0-9][0-9][0-9].{44}|[48][0-9][0-9][0-9][0-9].{88}|1[0-9][0-9][0-9][0-9].{4})|5(?:[2-9][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9].{44}|1[0-9][0-9][0-9][0-9].{16})|1(?:[0-7][0-9][0-9][0-9][0-9].{36}|[89][0-9][0-9][0-9][0-9].{16})|3(?:[0-4][0-9][0-9][0-9][0-9].{20}|[5-9][0-9][0-9][0-9][0-9].{16}))|2(?:8(?:[12679][0-9][0-9][0-9][0-9].{4}|[3-5][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{208}|0[0-9][0-9][0-9][0-9].{20})|5(?:[013478][0-9][0-9][0-9][0-9].{20}|[29][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{16})|7(?:[1347-9][0-9][0-9][0-9][0-9].{4}|[26][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{12}|5[0-9][0-9][0-9][0-9].{20})|1(?:[246-8][0-9][0-9][0-9][0-9].{4}|[019][0-9][0-9][0-9][0-9].{24}|[35][0-9][0-9][0-9][0-9].{12})|2(?:[13689][0-9][0-9][0-9][0-9].{12}|[027][0-9][0-9][0-9][0-9].{4}|[45][0-9][0-9][0-9][0-9].{24})|6(?:[02356][0-9][0-9][0-9][0-9].{4}|[179][0-9][0-9][0-9][0-9].{20}|[48][0-9][0-9][0-9][0-9].{16})|0(?:[3-79][0-9][0-9][0-9][0-9].{24}|[0-2][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{12})|4(?:[135-79][0-9][0-9][0-9][0-9].{20}|[048][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{4})|3(?:[0135-9][0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{4})|9(?:[0347-9][0-9][0-9][0-9][0-9].{12}|[1256][0-9][0-9][0-9][0-9].{4}))|7(?:7(?:[2-59][0-9][0-9][0-9][0-9].{4}|[07][0-9][0-9][0-9][0-9].{80}|1[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{16})|1(?:[2-689][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{28})|5(?:[3-9][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{12})|8(?:[07-9][0-9][0-9][0-9][0-9].{16}|[2-6][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{152})|6(?:[1269][0-9][0-9][0-9][0-9].{16}|[3-578][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12})|0(?:[0-579][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{24})|2(?:[0-68][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{28})|4(?:[4-9][0-9][0-9][0-9][0-9].{28}|[0-3][0-9][0-9][0-9][0-9].{24})|3[0-9][0-9][0-9][0-9][0-9].{24}|9[0-9][0-9][0-9][0-9][0-9].{4})|6(?:8(?:[3-5][0-9][0-9][0-9][0-9].{52}|[01][0-9][0-9][0-9][0-9].{40}|[29][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{204}|8[0-9][0-9][0-9][0-9].{148}|6[0-9][0-9][0-9][0-9].{44})|6(?:[0235][0-9][0-9][0-9][0-9].{20}|[167][0-9][0-9][0-9][0-9].{4}|[48][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{52})|5(?:[1348][0-9][0-9][0-9][0-9].{52}|[679][0-9][0-9][0-9][0-9].{20}|[025][0-9][0-9][0-9][0-9].{4})|4(?:[1-35-8][0-9][0-9][0-9][0-9].{52}|[49][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{28})|3(?:[1-35-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{36})|0(?:[3-7][0-9][0-9][0-9][0-9].{12}|[0-289][0-9][0-9][0-9][0-9].{4})|7(?:[0-4][0-9][0-9][0-9][0-9].{20}|[5-9][0-9][0-9][0-9][0-9].{4})|2(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16})|9[0-9][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9][0-9].{4}))|5(?:3(?:5(?:[049][0-9][0-9][0-9][0-9].{16}|[68][0-9][0-9][0-9][0-9].{80}|[57][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{212}|1[0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{28})|4(?:[1-35][0-9][0-9][0-9][0-9].{40}|[068][0-9][0-9][0-9][0-9].{16}|[79][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{92})|3(?:[1-46-8][0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{80})|9(?:[02-7][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{40})|8(?:[1-8][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{16})|0(?:[35-9][0-9][0-9][0-9][0-9].{4}|[0-24][0-9][0-9][0-9][0-9].{28})|2(?:[346-9][0-9][0-9][0-9][0-9].{52}|[0-25][0-9][0-9][0-9][0-9].{4})|6(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{28})|[17][0-9][0-9][0-9][0-9][0-9].{4})|0(?:5(?:[1-379][0-9][0-9][0-9][0-9].{4}|[568][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{80})|6(?:[0-4][0-9][0-9][0-9][0-9].{20}|[6-9][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{40})|7(?:[03-79][0-9][0-9][0-9][0-9].{4}|[12][0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{12})|8(?:[2-79][0-9][0-9][0-9][0-9].{24}|[01][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{44})|3(?:[1-46-9][0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{12})|0(?:[02-5][0-9][0-9][0-9][0-9].{12}|[16-9][0-9][0-9][0-9][0-9].{4})|4(?:[3-9][0-9][0-9][0-9][0-9].{4}|[0-2][0-9][0-9][0-9][0-9].{52})|1(?:[0-46-9][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{16})|9(?:[1-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{4})|2[0-9][0-9][0-9][0-9][0-9].{4})|6(?:9(?:[1-35][0-9][0-9][0-9][0-9].{28}|[467][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{24}|8[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{4})|5(?:[02-5][0-9][0-9][0-9][0-9].{4}|[67][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{40})|6(?:[4-7][0-9][0-9][0-9][0-9].{28}|[1-3][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{12})|0(?:[1457-9][0-9][0-9][0-9][0-9].{4}|[026][0-9][0-9][0-9][0-9].{80}|3[0-9][0-9][0-9][0-9].{28})|3(?:[1-46-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{80}|5[0-9][0-9][0-9][0-9].{92})|2(?:[0-8][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{40})|[78][0-9][0-9][0-9][0-9][0-9].{24}|[14][0-9][0-9][0-9][0-9][0-9].{4})|7(?:2(?:[34][0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{332}|2[0-9][0-9][0-9][0-9].{168}|7[0-9][0-9][0-9][0-9].{344}|5[0-9][0-9][0-9][0-9].{80}|6[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{4})|4(?:[1-6][0-9][0-9][0-9][0-9].{48}|[08][0-9][0-9][0-9][0-9].{88}|7[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{44})|1(?:[0-7][0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{92}|8[0-9][0-9][0-9][0-9].{4})|8(?:[48][0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{48})|7(?:5[0-9][0-9][0-9][0-9].{136}|6[0-9][0-9][0-9][0-9].{52})|(?:9[0-2]|3[0-9])[0-9][0-9][0-9][0-9].{48}|(?:5[01]|0[0-9])[0-9][0-9][0-9][0-9].{44})|2(?:1(?:[2-7][0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{428}|1[0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{4})|0(?:[0-6][0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{196}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{4})|7(?:2[0-9][0-9][0-9][0-9].{268}|3[0-9][0-9][0-9][0-9].{56}|6[0-9][0-9][0-9][0-9].{52})|2(?:[3-9][0-9][0-9][0-9][0-9].{48}|[0-2][0-9][0-9][0-9][0-9].{104})|4(?:[28][0-9][0-9][0-9][0-9].{88}|4[0-9][0-9][0-9][0-9].{136})|8(?:[468][0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{48})|(?:9[0-7]|3[01])[0-9][0-9][0-9][0-9].{48}|62[0-9][0-9][0-9][0-9].{20})|[14][0-9][0-9][0-9][0-9][0-9][0-9].{8})|4(?:6(?:0(?:[015-7][0-9][0-9][0-9][0-9].{32}|[34][0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{4})|6(?:[0-49][0-9][0-9][0-9][0-9].{44}|[67][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{72}|8[0-9][0-9][0-9][0-9].{88})|2(?:[3-7][0-9][0-9][0-9][0-9].{44}|[0-2][0-9][0-9][0-9][0-9].{28}|[89][0-9][0-9][0-9][0-9].{56})|5(?:[0-57][0-9][0-9][0-9][0-9].{56}|[89][0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{60})|7(?:[03-578][0-9][0-9][0-9][0-9].{44}|[12][0-9][0-9][0-9][0-9].{104}|6[0-9][0-9][0-9][0-9].{52})|4(?:[0-589][0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{180}|6[0-9][0-9][0-9][0-9].{60})|1(?:[1-9][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{40})|8(?:[0248][0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{48})|3[0-9][0-9][0-9][0-9][0-9].{56}|90[0-9][0-9][0-9][0-9].{48})|9(?:8(?:[13-5][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{360}|6[0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{88}|0[0-9][0-9][0-9][0-9].{4})|5(?:[4-9][0-9][0-9][0-9][0-9].{20}|[01][0-9][0-9][0-9][0-9].{36}|3[0-9][0-9][0-9][0-9].{172}|2[0-9][0-9][0-9][0-9].{4})|2(?:[4-9][0-9][0-9][0-9][0-9].{36}|[0-2][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{108})|7(?:[0-4][0-9][0-9][0-9][0-9].{52}|[5-8][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{48})|4(?:[0-35-8][0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{248}|4[0-9][0-9][0-9][0-9].{40})|1(?:[0-69][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{236}|8[0-9][0-9][0-9][0-9].{28})|6(?:[02-9][0-9][0-9][0-9][0-9].{20}|1[0-9][0-9][0-9][0-9].{16})|3[0-9][0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9][0-9].{4})|4(?:7(?:[2-589][0-9][0-9][0-9][0-9].{4}|[17][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{52})|8(?:[1-35-79][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{16})|6(?:[3-9][0-9][0-9][0-9][0-9].{16}|[12][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{4})|5(?:[2-9][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{176}|0[0-9][0-9][0-9][0-9].{28})|2(?:[0-6][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{4})|4(?:[2-9][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{4})|9(?:[1-8][0-9][0-9][0-9][0-9].{4}|[09][0-9][0-9][0-9][0-9].{16})|0(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12})|1[0-9][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9][0-9].{4})|5(?:4(?:[0-6][0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{4})|1(?:[0-6][0-9][0-9][0-9][0-9].{36}|[7-9][0-9][0-9][0-9][0-9].{16})|2(?:[0-5][0-9][0-9][0-9][0-9].{16}|[6-9][0-9][0-9][0-9][0-9].{20})|7(?:[0-7][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{32})|6(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{20})|3[1-9][0-9][0-9][0-9][0-9].{20}|[89][0-9][0-9][0-9][0-9][0-9].{32}|0[0-9][0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9][0-9].{16})|[01378][0-9][0-9][0-9][0-9][0-9][0-9].{8})|3(?:0(?:0(?:[5-9][0-9][0-9][0-9][0-9].{192}|[12][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{300}|4[0-9][0-9][0-9][0-9].{172}|0[0-9][0-9][0-9][0-9].{16})|9(?:[019][0-9][0-9][0-9][0-9].{60}|[2-4][0-9][0-9][0-9][0-9].{28}|[78][0-9][0-9][0-9][0-9].{44}|5[0-9][0-9][0-9][0-9].{180}|6[0-9][0-9][0-9][0-9].{72})|8(?:[01479][0-9][0-9][0-9][0-9].{28}|[36][0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{60}|8[0-9][0-9][0-9][0-9].{88}|2[0-9][0-9][0-9][0-9].{4})|3(?:[3-9][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{192}|2[0-9][0-9][0-9][0-9].{252})|2(?:[5-9][0-9][0-9][0-9][0-9].{192}|[0-4][0-9][0-9][0-9][0-9].{20})|5(?:[0-5][0-9][0-9][0-9][0-9].{16}|[6-9][0-9][0-9][0-9][0-9].{32})|7(?:[0-8][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{92})|1[0-9][0-9][0-9][0-9][0-9].{20}|4[0-9][0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9][0-9].{32})|6(?:1(?:[4-8][0-9][0-9][0-9][0-9].{4}|[1-3][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{52})|5(?:[1-5][0-9][0-9][0-9][0-9].{4}|[6-8][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{24})|6(?:[016-9][0-9][0-9][0-9][0-9].{4}|[245][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{52})|7(?:[1-79][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{16})|0(?:[1-689][0-9][0-9][0-9][0-9].{4}|[07][0-9][0-9][0-9][0-9].{28})|8(?:[02-9][0-9][0-9][0-9][0-9].{24}|1[0-9][0-9][0-9][0-9].{152})|9(?:[1-6][0-9][0-9][0-9][0-9].{24}|[07-9][0-9][0-9][0-9][0-9].{4})|3(?:[0-57-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{52})|4(?:[0-8][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{12})|2[0-9][0-9][0-9][0-9][0-9].{4})|4(?:2(?:[0-367][0-9][0-9][0-9][0-9].{12}|[49][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{224}|8[0-9][0-9][0-9][0-9].{16})|6(?:[3568][0-9][0-9][0-9][0-9].{20}|[1479][0-9][0-9][0-9][0-9].{4}|[02][0-9][0-9][0-9][0-9].{80})|5(?:[0-479][0-9][0-9][0-9][0-9].{4}|[56][0-9][0-9][0-9][0-9].{224}|8[0-9][0-9][0-9][0-9].{20})|8(?:[04-79][0-9][0-9][0-9][0-9].{4}|[1-3][0-9][0-9][0-9][0-9].{20}|8[0-9][0-9][0-9][0-9].{284})|0(?:[02-8][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{36})|7(?:[013478][0-9][0-9][0-9][0-9].{4}|[2569][0-9][0-9][0-9][0-9].{20})|3(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16})|[19][0-9][0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9][0-9].{4})|[1-3578][0-9][0-9][0-9][0-9][0-9][0-9].{8})|1(?:4(?:7(?:[35-9][0-9][0-9][0-9][0-9].{36}|[12][0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{60})|6(?:[5-9][0-9][0-9][0-9][0-9].{36}|[2-4][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{28})|9(?:[235-8][0-9][0-9][0-9][0-9].{20}|[01][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{180})|3(?:[1-8][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{4})|4(?:[03-9][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{16})|8(?:[05-9][0-9][0-9][0-9][0-9].{16}|[1-4][0-9][0-9][0-9][0-9].{36})|0(?:[0-7][0-9][0-9][0-9][0-9].{24}|[89][0-9][0-9][0-9][0-9].{4})|2(?:[2-9][0-9][0-9][0-9][0-9].{28}|[01][0-9][0-9][0-9][0-9].{4})|5(?:[1-46-9][0-9][0-9][0-9][0-9].{4}|[05][0-9][0-9][0-9][0-9].{16})|1[0-9][0-9][0-9][0-9][0-9].{4})|8(?:8(?:[3-57][0-9][0-9][0-9][0-9].{52}|[0-2][0-9][0-9][0-9][0-9].{4}|[69][0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{60})|3(?:[1-7][0-9][0-9][0-9][0-9].{16}|[09][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{4})|4(?:[1-5][0-9][0-9][0-9][0-9].{16}|[6-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12})|9(?:[12457-9][0-9][0-9][0-9][0-9].{36}|[036][0-9][0-9][0-9][0-9].{52})|1(?:[4-9][0-9][0-9][0-9][0-9].{28}|[0-3][0-9][0-9][0-9][0-9].{4})|2(?:[0-6][0-9][0-9][0-9][0-9].{28}|[7-9][0-9][0-9][0-9][0-9].{4})|5(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16})|7(?:[0-8][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{16})|[06][0-9][0-9][0-9][0-9][0-9].{4}))|6(?:1(?:5(?:[4-9][0-9][0-9][0-9][0-9].{48}|2[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{44}|3[0-9][0-9][0-9][0-9].{72}|1[0-9][0-9][0-9][0-9].{4})|3(?:[3-7][0-9][0-9][0-9][0-9].{28}|[89][0-9][0-9][0-9][0-9].{140}|[01][0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{40})|1(?:[3-6][0-9][0-9][0-9][0-9].{16}|[0-2][0-9][0-9][0-9][0-9].{20}|[7-9][0-9][0-9][0-9][0-9].{32})|6(?:[3-6][0-9][0-9][0-9][0-9].{44}|[0-2][0-9][0-9][0-9][0-9].{48}|7[0-9][0-9][0-9][0-9].{440})|4(?:[1-9][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{140})|0[0-9][0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9][0-9].{32}|88[0-9][0-9][0-9][0-9].{88})|2(?:6(?:[7-9][0-9][0-9][0-9][0-9].{128}|6[0-9][0-9][0-9][0-9].{112}|2[0-9][0-9][0-9][0-9].{60})|3(?:[0-57-9][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{620})|7(?:[0-5][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{244})|1(?:[09][0-9][0-9][0-9][0-9].{84}|[67][0-9][0-9][0-9][0-9].{68})|8(?:[89][0-9][0-9][0-9][0-9].{244}|0[0-9][0-9][0-9][0-9].{296})|0(?:[12][0-9][0-9][0-9][0-9].{536}|6[0-9][0-9][0-9][0-9].{48})|[2459][0-9][0-9][0-9][0-9][0-9].{8})|9(?:5(?:0[0-9][0-9][0-9][0-9].{112}|1[0-9][0-9][0-9][0-9].{84})|6[0-4][0-9][0-9][0-9][0-9].{8}|80[0-9][0-9][0-9][0-9].{296}))|0(?:0(?:0(?:[07][0-9][0-9][0-9][0-9].{112}|[69][0-9][0-9][0-9][0-9].{296}|1[0-9][0-9][0-9][0-9].{108}|2[0-9][0-9][0-9][0-9].{536}|3[0-9][0-9][0-9][0-9].{192}|5[0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{16})|3(?:[34][0-9][0-9][0-9][0-9].{68}|0[0-9][0-9][0-9][0-9].{4})|7(?:[89][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{4})|4[04][0-9][0-9][0-9][0-9].{12}|10[0-9][0-9][0-9][0-9].{440}|57[0-9][0-9][0-9][0-9].{128}|80[0-9][0-9][0-9][0-9].{136}|66[0-9][0-9][0-9][0-9].{16})|1(?:6(?:[0-3][0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{16})|23[0-9][0-9][0-9][0-9].{224}|5[0-9][0-9][0-9][0-9][0-9].{20}|44[0-9][0-9][0-9][0-9].{12}|76[0-9][0-9][0-9][0-9].{52})|2(?:6(?:2[0-9][0-9][0-9][0-9].{620}|3[0-9][0-9][0-9][0-9].{84}|6[0-9][0-9][0-9][0-9].{16})|80[0-9][0-9][0-9][0-9].{204}|90[0-9][0-9][0-9][0-9].{212}|44[0-9][0-9][0-9][0-9].{12})|4(?:(?:0[1-4]|1[12])[0-9][0-9][0-9][0-9].{4}|56[0-9][0-9][0-9][0-9].{244}|44[0-9][0-9][0-9][0-9].{12})|8(?:[01][0-9][0-9][0-9][0-9][0-9].{8}|80[0-9][0-9][0-9][0-9].{12})|9(?:[67]1|55)[0-9][0-9][0-9][0-9].{16}|[67][0-9][0-9][0-9][0-9][0-9][0-9].{8}|344[0-9][0-9][0-9][0-9].{12})|85(?:3(?:[189][0-9][0-9][0-9][0-9].{28}|[467][0-9][0-9][0-9][0-9].{40}|[23][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{92}|5[0-9][0-9][0-9][0-9].{60})|6(?:[0-46][0-9][0-9][0-9][0-9].{44}|8[0-9][0-9][0-9][0-9].{108}|5[0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{4})|5(?:[05-9][0-9][0-9][0-9][0-9].{44}|[34][0-9][0-9][0-9][0-9].{140}|1[0-9][0-9][0-9][0-9].{16}|2[0-9][0-9][0-9][0-9].{72})|7(?:[0-249][0-9][0-9][0-9][0-9].{56}|[6-8][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{356}|5[0-9][0-9][0-9][0-9].{60})|8(?:[0-3679][0-9][0-9][0-9][0-9].{56}|[48][0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{60})|9(?:[0-2467][0-9][0-9][0-9][0-9].{56}|[389][0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{60})|4(?:[0-46-8][0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{40})|0(?:[2-9][0-9][0-9][0-9][0-9].{32}|[01][0-9][0-9][0-9][0-9].{16})|2(?:[0-8][0-9][0-9][0-9][0-9].{32}|9[0-9][0-9][0-9][0-9].{4})|1[0-9][0-9][0-9][0-9][0-9].{32})|9(?:0(?:8(?:[13-6][0-9][0-9][0-9][0-9].{28}|[029][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{132}|8[0-9][0-9][0-9][0-9].{668})|2(?:[027-9][0-9][0-9][0-9][0-9].{4}|[13-5][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{16})|3(?:[016-9][0-9][0-9][0-9][0-9].{4}|[3-5][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{16})|9(?:[013489][0-9][0-9][0-9][0-9].{4}|[5-7][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{36})|0(?:[1-489][0-9][0-9][0-9][0-9].{4}|[05-7][0-9][0-9][0-9][0-9].{12})|4(?:[0-578][0-9][0-9][0-9][0-9].{4}|[69][0-9][0-9][0-9][0-9].{20})|5(?:[1-59][0-9][0-9][0-9][0-9].{20}|[06-8][0-9][0-9][0-9][0-9].{4})|6(?:[2-69][0-9][0-9][0-9][0-9].{20}|[0178][0-9][0-9][0-9][0-9].{4})|7(?:[0-47-9][0-9][0-9][0-9][0-9].{4}|[56][0-9][0-9][0-9][0-9].{28})|1(?:[1-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{4}))|[6-9][0-9][0-9][0-9][0-9][0-9][0-9].{8})|2(?:2(?:5(?:[7-9][0-9][0-9][0-9][0-9].{36}|[01][0-9][0-9][0-9][0-9].{28}|[23][0-9][0-9][0-9][0-9].{16}|[56][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{160})|1(?:[2-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{16})|7(?:[0-7][0-9][0-9][0-9][0-9].{52}|[89][0-9][0-9][0-9][0-9].{36})|8(?:[0-7][0-9][0-9][0-9][0-9].{36}|[89][0-9][0-9][0-9][0-9].{16})|0(?:[0-6][0-9][0-9][0-9][0-9].{16}|[7-9][0-9][0-9][0-9][0-9].{4})|2(?:[14-8][0-9][0-9][0-9][0-9].{4}|[0239][0-9][0-9][0-9][0-9].{16})|3(?:[0-246-9][0-9][0-9][0-9][0-9].{4}|[35][0-9][0-9][0-9][0-9].{16})|9(?:[5-9][0-9][0-9][0-9][0-9].{16}|[0-4][0-9][0-9][0-9][0-9].{4})|4(?:[0-35-9][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{112})|6(?:[0-57-9][0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{60}))|[37-9][0-9][0-9][0-9][0-9][0-9][0-9].{8}))|5(?:3(?:3(?:5(?:[6-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{156}|2[0-9][0-9][0-9][0-9].{88}|3[0-9][0-9][0-9][0-9].{20}|4[0-9][0-9][0-9][0-9].{36}|5[0-9][0-9][0-9][0-9].{52}|1[0-9][0-9][0-9][0-9].{4})|6(?:[27-9][0-9][0-9][0-9][0-9].{16}|[04][0-9][0-9][0-9][0-9].{156}|[56][0-9][0-9][0-9][0-9].{52}|1[0-9][0-9][0-9][0-9].{36}|3[0-9][0-9][0-9][0-9].{48})|4(?:[1-356][0-9][0-9][0-9][0-9].{36}|[78][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{156}|9[0-9][0-9][0-9][0-9].{172}|4[0-9][0-9][0-9][0-9].{52})|7(?:[6-8][0-9][0-9][0-9][0-9].{52}|[23][0-9][0-9][0-9][0-9].{16}|[45][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{156}|1[0-9][0-9][0-9][0-9].{36})|1(?:[6-9][0-9][0-9][0-9][0-9].{36}|[1-4][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{248}|5[0-9][0-9][0-9][0-9].{40})|2(?:[1-35-9][0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{156}|0[0-9][0-9][0-9][0-9].{52})|3(?:[124-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{156}|3[0-9][0-9][0-9][0-9].{52})|0(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{160})|[89][0-9][0-9][0-9][0-9][0-9].{20})|5(?:5(?:[0-2][0-9][0-9][0-9][0-9].{28}|[7-9][0-9][0-9][0-9][0-9].{56}|[35][0-9][0-9][0-9][0-9].{60}|6[0-9][0-9][0-9][0-9].{108}|4[0-9][0-9][0-9][0-9].{72})|3(?:[3-6][0-9][0-9][0-9][0-9].{28}|[189][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{192}|0[0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{92})|4(?:[2-47-9][0-9][0-9][0-9][0-9].{28}|[016][0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{60})|7(?:[02-49][0-9][0-9][0-9][0-9].{56}|[16-8][0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{60})|9(?:[0-47-9][0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{180}|6[0-9][0-9][0-9][0-9].{56})|0(?:[2-9][0-9][0-9][0-9][0-9].{32}|[01][0-9][0-9][0-9][0-9].{16})|8(?:[0-25689][0-9][0-9][0-9][0-9].{16}|[347][0-9][0-9][0-9][0-9].{56})|6(?:[0-46-9][0-9][0-9][0-9][0-9].{56}|5[0-9][0-9][0-9][0-9].{60})|[12][0-9][0-9][0-9][0-9][0-9].{32})|1(?:9(?:[0-5][0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{360}|9[0-9][0-9][0-9][0-9].{108}|6[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{40})|1(?:[2-5][0-9][0-9][0-9][0-9].{16}|[189][0-9][0-9][0-9][0-9].{12}|[067][0-9][0-9][0-9][0-9].{4})|5(?:[1-7][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{248})|6(?:[2-9][0-9][0-9][0-9][0-9].{36}|0[0-9][0-9][0-9][0-9].{112}|1[0-9][0-9][0-9][0-9].{60})|8(?:[0-6][0-9][0-9][0-9][0-9].{156}|[7-9][0-9][0-9][0-9][0-9].{36})|7(?:[0-46-8][0-9][0-9][0-9][0-9].{52}|[59][0-9][0-9][0-9][0-9].{36})|0(?:[0-8][0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{176})|3(?:[4-9][0-9][0-9][0-9][0-9].{4}|[0-3][0-9][0-9][0-9][0-9].{16})|2(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12})|4[0-9][0-9][0-9][0-9][0-9].{4})|2(?:0(?:[1346-8][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{284}|9[0-9][0-9][0-9][0-9].{208}|2[0-9][0-9][0-9][0-9].{4})|1(?:[2-9][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{460}|1[0-9][0-9][0-9][0-9].{104})|3(?:0[0-9][0-9][0-9][0-9].{344}|1[0-9][0-9][0-9][0-9].{268}|2[0-9][0-9][0-9][0-9].{136})|8(?:[08][0-9][0-9][0-9][0-9].{88}|1[0-9][0-9][0-9][0-9].{48})|20[0-9][0-9][0-9][0-9].{44})|4[0-9][0-9][0-9][0-9][0-9][0-9].{8})|8(?:2(?:9(?:[0134][0-9][0-9][0-9][0-9].{28}|[78][0-9][0-9][0-9][0-9].{44}|6[0-9][0-9][0-9][0-9].{236}|9[0-9][0-9][0-9][0-9].{180}|2[0-9][0-9][0-9][0-9].{60}|5[0-9][0-9][0-9][0-9].{72})|8(?:[5-79][0-9][0-9][0-9][0-9].{28}|[013][0-9][0-9][0-9][0-9].{60}|2[0-9][0-9][0-9][0-9].{300}|4[0-9][0-9][0-9][0-9].{252}|8[0-9][0-9][0-9][0-9].{88})|7(?:[6-9][0-9][0-9][0-9][0-9].{28}|[0-2][0-9][0-9][0-9][0-9].{32}|[34][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{40})|0(?:[2-6][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{108}|[7-9][0-9][0-9][0-9][0-9].{20})|3(?:[135-9][0-9][0-9][0-9][0-9].{16}|[04][0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{44})|2(?:[0-7][0-9][0-9][0-9][0-9].{20}|8[0-9][0-9][0-9][0-9].{172}|9[0-9][0-9][0-9][0-9].{16})|1(?:[1-7][0-9][0-9][0-9][0-9].{20}|[089][0-9][0-9][0-9][0-9].{16})|5(?:[3-9][0-9][0-9][0-9][0-9].{32}|[0-2][0-9][0-9][0-9][0-9].{16})|4(?:[1-9][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{44})|6[0-9][0-9][0-9][0-9][0-9].{32})|1(?:1(?:[15-79][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{80}|2[0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{92})|8(?:[4-9][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{152}|1[0-9][0-9][0-9][0-9].{212}|2[0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{4})|3(?:[05-9][0-9][0-9][0-9][0-9].{4}|[12][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{132}|4[0-9][0-9][0-9][0-9].{40})|9(?:[02-6][0-9][0-9][0-9][0-9].{24}|[78][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{28})|7(?:[013-578][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{24})|0(?:[0-7][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{16})|6(?:[014-9][0-9][0-9][0-9][0-9].{4}|[23][0-9][0-9][0-9][0-9].{16})|2(?:[0-57-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{12})|[45][0-9][0-9][0-9][0-9][0-9].{4})|7(?:2(?:[5-9][0-9][0-9][0-9][0-9].{24}|[23][0-9][0-9][0-9][0-9].{16}|[14][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{28})|6(?:[01367][0-9][0-9][0-9][0-9].{28}|[24][0-9][0-9][0-9][0-9].{20}|[89][0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{4})|0(?:[14-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{80}|3[0-9][0-9][0-9][0-9].{16})|3(?:[4-9][0-9][0-9][0-9][0-9].{4}|[0-2][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{104})|7(?:[2457-9][0-9][0-9][0-9][0-9].{4}|[136][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{40})|4(?:[0-59][0-9][0-9][0-9][0-9].{4}|[6-8][0-9][0-9][0-9][0-9].{24})|8(?:[0-26-9][0-9][0-9][0-9][0-9].{4}|[3-5][0-9][0-9][0-9][0-9].{40})|5(?:[0-79][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{20})|9[0-9][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9][0-9].{4})|6(?:0(?:[1-5][0-9][0-9][0-9][0-9].{44}|[7-9][0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{332}|6[0-9][0-9][0-9][0-9].{48})|1(?:[2-5][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{80}|1[0-9][0-9][0-9][0-9].{48})|6(?:[6-9][0-9][0-9][0-9][0-9].{48}|5[0-9][0-9][0-9][0-9].{20})|7[0-3][0-9][0-9][0-9][0-9].{48}))|1(?:6(?:5(?:[34689][0-9][0-9][0-9][0-9].{20}|[12][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{24})|6(?:[1479][0-9][0-9][0-9][0-9].{20}|[268][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{28}|3[0-9][0-9][0-9][0-9].{24}|5[0-9][0-9][0-9][0-9].{4})|4(?:[15689][0-9][0-9][0-9][0-9].{4}|[237][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{36})|0(?:[2-57-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{28})|3(?:[124-689][0-9][0-9][0-9][0-9].{4}|[03][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{80})|1(?:[016-9][0-9][0-9][0-9][0-9].{4}|[2-5][0-9][0-9][0-9][0-9].{12})|8(?:[0-79][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{44})|[27][0-9][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9][0-9].{12})|7(?:8(?:[1-4][0-9][0-9][0-9][0-9].{4}|[589][0-9][0-9][0-9][0-9].{36}|[67][0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{16})|5(?:[1-46][0-9][0-9][0-9][0-9].{16}|[7-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{12})|4(?:[1-7][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{16})|9(?:[4-9][0-9][0-9][0-9][0-9].{36}|[0-2][0-9][0-9][0-9][0-9].{52}|3[0-9][0-9][0-9][0-9].{92})|1(?:[0-6][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{4})|3(?:[0-6][0-9][0-9][0-9][0-9].{4}|[7-9][0-9][0-9][0-9][0-9].{28})|6(?:[1-57-9][0-9][0-9][0-9][0-9].{4}|[06][0-9][0-9][0-9][0-9].{16})|7(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16})|0[0-9][0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9][0-9].{4})|9(?:5(?:[0-5][0-9][0-9][0-9][0-9].{32}|[89][0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{4})|6(?:[4-9][0-9][0-9][0-9][0-9].{44}|[0-2][0-9][0-9][0-9][0-9].{28}|3[0-9][0-9][0-9][0-9].{140})|4(?:[0-4][0-9][0-9][0-9][0-9].{16}|[5-9][0-9][0-9][0-9][0-9].{32})|2(?:[2-8][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{36})|1(?:[0-8][0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9].{52})|7(?:[0-4][0-9][0-9][0-9][0-9].{44}|[56][0-9][0-9][0-9][0-9].{52})|8[08][0-9][0-9][0-9][0-9].{88}|3[0-9][0-9][0-9][0-9][0-9].{20}|99[0-9][0-9][0-9][0-9].{180}|0[0-9][0-9][0-9][0-9][0-9].{4}))|4(?:0(?:1(?:[1459][0-9][0-9][0-9][0-9].{12}|[0238][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{16})|8(?:[1-4][0-9][0-9][0-9][0-9].{12}|[0679][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{56})|2(?:[4-9][0-9][0-9][0-9][0-9].{24}|[12][0-9][0-9][0-9][0-9].{12}|[03][0-9][0-9][0-9][0-9].{4})|4(?:[2479][0-9][0-9][0-9][0-9].{12}|[356][0-9][0-9][0-9][0-9].{20}|[018][0-9][0-9][0-9][0-9].{4})|5(?:[1368][0-9][0-9][0-9][0-9].{20}|[2579][0-9][0-9][0-9][0-9].{12}|[04][0-9][0-9][0-9][0-9].{4})|6(?:[1359][0-9][0-9][0-9][0-9].{20}|[2467][0-9][0-9][0-9][0-9].{12}|[08][0-9][0-9][0-9][0-9].{4})|0(?:[035-8][0-9][0-9][0-9][0-9].{4}|[249][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{28})|3(?:[3-8][0-9][0-9][0-9][0-9].{24}|[019][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{16})|7(?:[0-24-9][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{20})|9(?:[1-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{4}))|7(?:2(?:[1378][0-9][0-9][0-9][0-9].{4}|[4-6][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9].{80}|9[0-9][0-9][0-9][0-9].{40})|5(?:[1-37-9][0-9][0-9][0-9][0-9].{24}|[56][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{180}|4[0-9][0-9][0-9][0-9].{152})|1(?:[0-469][0-9][0-9][0-9][0-9].{4}|[78][0-9][0-9][0-9][0-9].{28}|5[0-9][0-9][0-9][0-9].{80})|4(?:[1-79][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{92})|6(?:[0-357-9][0-9][0-9][0-9][0-9].{24}|4[0-9][0-9][0-9][0-9].{40}|6[0-9][0-9][0-9][0-9].{4})|7(?:[1-35-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{80}|4[0-9][0-9][0-9][0-9].{60})|3(?:[0-356][0-9][0-9][0-9][0-9].{4}|[47-9][0-9][0-9][0-9][0-9].{12})|[089][0-9][0-9][0-9][0-9][0-9].{4})|[24-69][0-9][0-9][0-9][0-9][0-9][0-9].{8})|6(?:7(?:7(?:[125][0-9][0-9][0-9][0-9].{20}|[37][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{28}|4[0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9].{4})|2(?:[26-9][0-9][0-9][0-9][0-9].{4}|[13][0-9][0-9][0-9][0-9].{12}|[45][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{16})|6(?:[13-5][0-9][0-9][0-9][0-9].{20}|[02][0-9][0-9][0-9][0-9].{12}|[6-8][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{16})|0(?:[05-9][0-9][0-9][0-9][0-9].{4}|[12][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{356}|4[0-9][0-9][0-9][0-9].{16})|3(?:[025-9][0-9][0-9][0-9][0-9].{12}|1[0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{36}|3[0-9][0-9][0-9][0-9].{4})|9(?:[016-9][0-9][0-9][0-9][0-9].{24}|[3-5][0-9][0-9][0-9][0-9].{12}|2[0-9][0-9][0-9][0-9].{4})|1(?:[02-5][0-9][0-9][0-9][0-9].{12}|[16-9][0-9][0-9][0-9][0-9].{4})|4(?:[3-9][0-9][0-9][0-9][0-9].{4}|[0-2][0-9][0-9][0-9][0-9].{12})|8(?:[0-68][0-9][0-9][0-9][0-9].{24}|[79][0-9][0-9][0-9][0-9].{4})|5(?:[0-24-9][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{20}))|4(?:1(?:[4-8][0-9][0-9][0-9][0-9].{44}|[09][0-9][0-9][0-9][0-9].{104}|3[0-9][0-9][0-9][0-9].{168}|1[0-9][0-9][0-9][0-9].{72}|2[0-9][0-9][0-9][0-9].{4})|0(?:[0-6][0-9][0-9][0-9][0-9].{56}|7[0-9][0-9][0-9][0-9].{108}|8[0-9][0-9][0-9][0-9].{148}|9[0-9][0-9][0-9][0-9].{196})|8(?:[0-79][0-9][0-9][0-9][0-9].{48}|8[0-9][0-9][0-9][0-9].{88})|4(?:[01][0-9][0-9][0-9][0-9].{156}|[2-4][0-9][0-9][0-9][0-9].{48})|7(?:[7-9][0-9][0-9][0-9][0-9].{48}|6[0-9][0-9][0-9][0-9].{52})|33[0-9][0-9][0-9][0-9].{136}|9[0-9][0-9][0-9][0-9][0-9].{48}|64[0-9][0-9][0-9][0-9].{4})|[1-35][0-9][0-9][0-9][0-9][0-9][0-9].{8})|9(?:0(?:4(?:[178][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{296}|4[0-9][0-9][0-9][0-9].{228}|5[0-9][0-9][0-9][0-9].{420}|6[0-9][0-9][0-9][0-9].{308}|2[0-9][0-9][0-9][0-9].{68})|5(?:[7-9][0-9][0-9][0-9][0-9].{128}|[0-2][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{308})|0(?:[34][0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9].{516}|5[0-9][0-9][0-9][0-9].{544})|6(?:[018][0-9][0-9][0-9][0-9].{8}|9[0-9][0-9][0-9][0-9].{112})|7(?:7[0-9][0-9][0-9][0-9].{228}|0[0-9][0-9][0-9][0-9].{60})|(?:[289][0-9]|3[28])[0-9][0-9][0-9][0-9].{8}|1[0-3][0-9][0-9][0-9][0-9].{68})|6(?:3(?:[57][0-9][0-9][0-9][0-9].{128}|[089][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{68})|4(?:[026-8][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{228}|5[0-9][0-9][0-9][0-9].{420})|9(?:[5-7][0-9][0-9][0-9][0-9].{68}|8[0-9][0-9][0-9][0-9].{308}|4[0-9][0-9][0-9][0-9].{60})|0(?:[34][0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9].{516}|5[0-9][0-9][0-9][0-9].{48})|8(?:0[0-9][0-9][0-9][0-9].{296}|9[0-9][0-9][0-9][0-9].{68})|(?:[56][0-9]|7[0-9])[0-9][0-9][0-9][0-9].{8}|10[0-9][0-9][0-9][0-9].{112}|20[0-9][0-9][0-9][0-9].{484})|4(?:4(?:[6-9][0-9][0-9][0-9][0-9].{68}|4[0-9][0-9][0-9][0-9].{228}|5[0-9][0-9][0-9][0-9].{420}|3[0-9][0-9][0-9][0-9].{60})|9(?:[014][0-9][0-9][0-9][0-9].{308}|7[0-9][0-9][0-9][0-9].{544})|(?:3[0-57-9]|2[0-2457-9])[0-9][0-9][0-9][0-9].{8}|(?:6[0-3]|5[7-9])[0-9][0-9][0-9][0-9].{128}|10[0-9][0-9][0-9][0-9].{112}|80[0-9][0-9][0-9][0-9].{296}))|0(?:0(?:0(?:[7-9][0-9][0-9][0-9][0-9].{112}|[34][0-9][0-9][0-9][0-9].{40}|[01][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{460}|6[0-9][0-9][0-9][0-9].{484}|2[0-9][0-9][0-9][0-9].{48})|6(?:[2478][0-9][0-9][0-9][0-9].{68}|[569][0-9][0-9][0-9][0-9].{16})|1(?:[235][0-9][0-9][0-9][0-9].{296}|[01][0-9][0-9][0-9][0-9].{48})|3(?:[12][0-9][0-9][0-9][0-9].{68}|[03][0-9][0-9][0-9][0-9].{4})|7(?:[89][0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{228})|4(?:4[0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{4})|5[7-9][0-9][0-9][0-9][0-9].{128}|80[0-9][0-9][0-9][0-9].{136}|90[0-9][0-9][0-9][0-9].{212})|9(?:[45][0-9][0-9][0-9][0-9][0-9].{120}|0[0-9][0-9][0-9][0-9][0-9].{408}|1[0-9][0-9][0-9][0-9][0-9].{264}|2[0-9][0-9][0-9][0-9][0-9].{272}|3[0-9][0-9][0-9][0-9][0-9].{32}|6[0-9][0-9][0-9][0-9][0-9].{64})|1(?:6(?:[0-2][0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{16})|5[0-9][0-9][0-9][0-9][0-9].{20}|23[0-9][0-9][0-9][0-9].{40}|44[0-9][0-9][0-9][0-9].{12}|76[0-9][0-9][0-9][0-9].{52})|5(?:9(?:[0469][0-9][0-9][0-9][0-9].{308}|[12][0-9][0-9][0-9][0-9].{16})|55[0-9][0-9][0-9][0-9].{156}|80[0-9][0-9][0-9][0-9].{204})|8(?:5(?:5[0-9][0-9][0-9][0-9].{604}|0[0-9][0-9][0-9][0-9].{60})|41[0-9][0-9][0-9][0-9].{604})|7(?:[0-6][0-9][0-9][0-9][0-9][0-9].{8}|80[0-9][0-9][0-9][0-9].{12})|3(?:66[0-9][0-9][0-9][0-9].{16}|05[0-9][0-9][0-9][0-9].{4})|4(?:0[135]|41)[0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9][0-9][0-9].{8}|244[0-9][0-9][0-9][0-9].{12})|79(?:9(?:[02-46][0-9][0-9][0-9][0-9].{44}|[89][0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{180}|1[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{60})|6(?:[0-5][0-9][0-9][0-9][0-9].{32}|6[0-9][0-9][0-9][0-9].{92}|7[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{4})|8(?:[1-4][0-9][0-9][0-9][0-9].{28}|[5-8][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{60})|7(?:[1-8][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{60})|0(?:[0-7][0-9][0-9][0-9][0-9].{36}|[89][0-9][0-9][0-9][0-9].{16})|3(?:[2-9][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{20})|4(?:[0-6][0-9][0-9][0-9][0-9].{16}|[7-9][0-9][0-9][0-9][0-9].{32})|1(?:[02-9][0-9][0-9][0-9][0-9].{16}|1[0-9][0-9][0-9][0-9].{36})|2[0-9][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9][0-9].{32})|24(?:5(?:[3-7][0-9][0-9][0-9][0-9].{16}|[0-2][0-9][0-9][0-9][0-9].{28}|8[0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{4})|6(?:[235-9][0-9][0-9][0-9][0-9].{4}|[01][0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{16})|8(?:[1-35-9][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{112}|0[0-9][0-9][0-9][0-9].{16})|9(?:[1-8][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{28})|0(?:[4-9][0-9][0-9][0-9][0-9].{4}|[0-3][0-9][0-9][0-9][0-9].{24})|3(?:[0-7][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{28})|4(?:[0-24-9][0-9][0-9][0-9][0-9].{28}|3[0-9][0-9][0-9][0-9].{16})|7(?:[1-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16})|[12][0-9][0-9][0-9][0-9][0-9].{4})|5[35-9][0-9][0-9][0-9][0-9][0-9][0-9].{8})|1(?:7(?:6(?:2(?:[78][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{204}|1[0-9][0-9][0-9][0-9].{208}|2[0-9][0-9][0-9][0-9].{452}|3[0-9][0-9][0-9][0-9].{168}|4[0-9][0-9][0-9][0-9].{148}|5[0-9][0-9][0-9][0-9].{352}|6[0-9][0-9][0-9][0-9].{276}|9[0-9][0-9][0-9][0-9].{4})|5(?:[5-79][0-9][0-9][0-9][0-9].{12}|[38][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{112}|1[0-9][0-9][0-9][0-9].{204}|4[0-9][0-9][0-9][0-9].{136}|2[0-9][0-9][0-9][0-9].{20})|4(?:[0-46][0-9][0-9][0-9][0-9].{88}|5[0-9][0-9][0-9][0-9].{448}|7[0-9][0-9][0-9][0-9].{356}|8[0-9][0-9][0-9][0-9].{268}|9[0-9][0-9][0-9][0-9].{196})|3(?:[14-689][0-9][0-9][0-9][0-9].{88}|[237][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{204})|7(?:[0-7][0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{28}|9[0-9][0-9][0-9][0-9].{12})|9(?:[02-46-9][0-9][0-9][0-9][0-9].{12}|[15][0-9][0-9][0-9][0-9].{28})|0(?:[1-9][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{28})|1[0-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9][0-9].{4})|4(?:9(?:[147-9][0-9][0-9][0-9][0-9].{12}|[23][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{160}|5[0-9][0-9][0-9][0-9].{408}|6[0-9][0-9][0-9][0-9].{16})|3(?:[235689][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{24}|7[0-9][0-9][0-9][0-9].{56}|4[0-9][0-9][0-9][0-9].{4})|7(?:[0-3][0-9][0-9][0-9][0-9].{28}|[6-9][0-9][0-9][0-9][0-9].{12}|[45][0-9][0-9][0-9][0-9].{20})|6(?:[1-35-7][0-9][0-9][0-9][0-9].{40}|[89][0-9][0-9][0-9][0-9].{12}|[04][0-9][0-9][0-9][0-9].{4})|8(?:[5-8][0-9][0-9][0-9][0-9].{16}|[349][0-9][0-9][0-9][0-9].{12}|[0-2][0-9][0-9][0-9][0-9].{4})|1(?:[0-37][0-9][0-9][0-9][0-9].{40}|[4-69][0-9][0-9][0-9][0-9].{12}|8[0-9][0-9][0-9][0-9].{24})|2(?:[1346-8][0-9][0-9][0-9][0-9].{12}|[259][0-9][0-9][0-9][0-9].{56}|0[0-9][0-9][0-9][0-9].{36})|0(?:[1-8][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{80}|9[0-9][0-9][0-9][0-9].{40})|5(?:[0-35][0-9][0-9][0-9][0-9].{40}|[46-9][0-9][0-9][0-9][0-9].{4})|4[0-9][0-9][0-9][0-9][0-9].{20})|9(?:7(?:[235][0-9][0-9][0-9][0-9].{112}|[6-9][0-9][0-9][0-9][0-9].{52}|[14][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{16})|3(?:[1-479][0-9][0-9][0-9][0-9].{16}|[56][0-9][0-9][0-9][0-9].{300}|0[0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{4})|8(?:[1-467][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{188}|0[0-9][0-9][0-9][0-9].{52})|9(?:[1-68][0-9][0-9][0-9][0-9].{4}|9[0-9][0-9][0-9][0-9].{372}|0[0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{92})|0(?:[2-8][0-9][0-9][0-9][0-9].{16}|[19][0-9][0-9][0-9][0-9].{52}|0[0-9][0-9][0-9][0-9].{4})|4(?:[03-59][0-9][0-9][0-9][0-9].{16}|[1278][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{40})|5(?:[0459][0-9][0-9][0-9][0-9].{16}|[1-378][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{40})|6(?:[05-79][0-9][0-9][0-9][0-9].{16}|[1-48][0-9][0-9][0-9][0-9].{4})|1(?:[0-8][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{52})|2[0-9][0-9][0-9][0-9][0-9].{16})|7(?:4(?:[2-47][0-9][0-9][0-9][0-9].{132}|[589][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{364}|1[0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{40})|3(?:[5-9][0-9][0-9][0-9][0-9].{132}|[24][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{40}|1[0-9][0-9][0-9][0-9].{36}|3[0-9][0-9][0-9][0-9].{80})|8(?:[0-359][0-9][0-9][0-9][0-9].{4}|[78][0-9][0-9][0-9][0-9].{80}|4[0-9][0-9][0-9][0-9].{16}|6[0-9][0-9][0-9][0-9].{48})|6(?:[1-35689][0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{80}|0[0-9][0-9][0-9][0-9].{4})|9(?:[1-5][0-9][0-9][0-9][0-9].{16}|[08][0-9][0-9][0-9][0-9].{80}|[679][0-9][0-9][0-9][0-9].{4})|7(?:[0-24578][0-9][0-9][0-9][0-9].{16}|[69][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{12})|5(?:[1-8][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{132}|9[0-9][0-9][0-9][0-9].{4})|0(?:[0-6][0-9][0-9][0-9][0-9].{4}|[7-9][0-9][0-9][0-9][0-9].{80})|[12][0-9][0-9][0-9][0-9][0-9].{40})|0(?:1(?:[35689][0-9][0-9][0-9][0-9].{4}|[14][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{40}|2[0-9][0-9][0-9][0-9].{36}|7[0-9][0-9][0-9][0-9].{28})|0(?:[0-2457][0-9][0-9][0-9][0-9].{40}|[89][0-9][0-9][0-9][0-9].{28}|3[0-9][0-9][0-9][0-9].{56}|6[0-9][0-9][0-9][0-9].{36})|4(?:[13579][0-9][0-9][0-9][0-9].{12}|[246][0-9][0-9][0-9][0-9].{4}|8[0-9][0-9][0-9][0-9].{172}|0[0-9][0-9][0-9][0-9].{40})|3(?:[6-9][0-9][0-9][0-9][0-9].{24}|[014][0-9][0-9][0-9][0-9].{12}|[235][0-9][0-9][0-9][0-9].{4})|5(?:[135689][0-9][0-9][0-9][0-9].{4}|[247][0-9][0-9][0-9][0-9].{12}|0[0-9][0-9][0-9][0-9].{40})|6(?:[02489][0-9][0-9][0-9][0-9].{4}|[35-7][0-9][0-9][0-9][0-9].{36}|1[0-9][0-9][0-9][0-9].{92})|8(?:[1-9][0-9][0-9][0-9][0-9].{24}|0[0-9][0-9][0-9][0-9].{36})|7[0-9][0-9][0-9][0-9][0-9].{36}|9[0-9][0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9][0-9].{4})|8(?:9(?:[27-9][0-9][0-9][0-9][0-9].{4}|[56][0-9][0-9][0-9][0-9].{176}|[34][0-9][0-9][0-9][0-9].{28}|0[0-9][0-9][0-9][0-9].{252}|1[0-9][0-9][0-9][0-9].{152})|4(?:[0-2][0-9][0-9][0-9][0-9].{24}|[3-5][0-9][0-9][0-9][0-9].{28}|[7-9][0-9][0-9][0-9][0-9].{4}|6[0-9][0-9][0-9][0-9].{16})|8(?:[02-6][0-9][0-9][0-9][0-9].{4}|[7-9][0-9][0-9][0-9][0-9].{28}|1[0-9][0-9][0-9][0-9].{152})|0(?:[0-5][0-9][0-9][0-9][0-9].{4}|[6-8][0-9][0-9][0-9][0-9].{12}|9[0-9][0-9][0-9][0-9].{28})|6(?:[3-689][0-9][0-9][0-9][0-9].{4}|[0-2][0-9][0-9][0-9][0-9].{12}|7[0-9][0-9][0-9][0-9].{16})|5(?:[0-4][0-9][0-9][0-9][0-9].{40}|[5-9][0-9][0-9][0-9][0-9].{12})|3(?:[5-9][0-9][0-9][0-9][0-9].{28}|[0-4][0-9][0-9][0-9][0-9].{4})|7(?:[0-689][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{152})|1[0-9][0-9][0-9][0-9][0-9].{28}|2[0-9][0-9][0-9][0-9][0-9].{4})|2(?:9(?:[2-48][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{12}|[67][0-9][0-9][0-9][0-9].{80}|[59][0-9][0-9][0-9][0-9].{4})|6(?:[0-367][0-9][0-9][0-9][0-9].{4}|[45][0-9][0-9][0-9][0-9].{12}|[89][0-9][0-9][0-9][0-9].{16})|2(?:[0-3568][0-9][0-9][0-9][0-9].{36}|[79][0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{4})|7(?:[013-7][0-9][0-9][0-9][0-9].{16}|[89][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{36})|8(?:[3-8][0-9][0-9][0-9][0-9].{4}|[129][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{36})|3(?:[0-468][0-9][0-9][0-9][0-9].{4}|[579][0-9][0-9][0-9][0-9].{12})|4(?:[024689][0-9][0-9][0-9][0-9].{4}|[1357][0-9][0-9][0-9][0-9].{12})|5(?:[0-689][0-9][0-9][0-9][0-9].{4}|7[0-9][0-9][0-9][0-9].{12})|[01][0-9][0-9][0-9][0-9][0-9].{36})|5(?:7(?:[0-27][0-9][0-9][0-9][0-9].{52}|[3489][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{212}|6[0-9][0-9][0-9][0-9].{16})|8(?:[1346-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{36}|2[0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{44})|5(?:[013468][0-9][0-9][0-9][0-9].{40}|[579][0-9][0-9][0-9][0-9].{4}|2[0-9][0-9][0-9][0-9].{16})|4(?:[0-25-9][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{60}|4[0-9][0-9][0-9][0-9].{28})|1(?:[3-9][0-9][0-9][0-9][0-9].{4}|[0-2][0-9][0-9][0-9][0-9].{28})|6(?:[0-57-9][0-9][0-9][0-9][0-9].{52}|6[0-9][0-9][0-9][0-9].{4})|9(?:[0-46-9][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{44})|[23][0-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9][0-9].{28})|3(?:6(?:[3-5][0-9][0-9][0-9][0-9].{40}|[7-9][0-9][0-9][0-9][0-9].{20}|[12][0-9][0-9][0-9][0-9].{36}|6[0-9][0-9][0-9][0-9].{80}|0[0-9][0-9][0-9][0-9].{4})|5(?:[1-35-9][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{12}|4[0-9][0-9][0-9][0-9].{80})|3(?:[0-27-9][0-9][0-9][0-9][0-9].{24}|[3-6][0-9][0-9][0-9][0-9].{20})|4(?:[0-6][0-9][0-9][0-9][0-9].{24}|[7-9][0-9][0-9][0-9][0-9].{40})|9(?:[013-9][0-9][0-9][0-9][0-9].{20}|2[0-9][0-9][0-9][0-9].{12})|[0-2][0-9][0-9][0-9][0-9][0-9].{24}|8[0-9][0-9][0-9][0-9][0-9].{20}|7[0-9][0-9][0-9][0-9][0-9].{4})|1(?:[1-8][0-9]|[09][0-9])[0-9][0-9][0-9][0-9].{4})|8(?:3(?:7(?:[68][0-9][0-9][0-9][0-9].{44}|[24][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{332}|1[0-9][0-9][0-9][0-9].{284}|5[0-9][0-9][0-9][0-9].{328}|7[0-9][0-9][0-9][0-9].{304}|9[0-9][0-9][0-9][0-9].{104}|3[0-9][0-9][0-9][0-9].{60})|6(?:[5-8][0-9][0-9][0-9][0-9].{140}|[24][0-9][0-9][0-9][0-9].{72}|1[0-9][0-9][0-9][0-9].{104}|0[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{4})|3(?:[0-4][0-9][0-9][0-9][0-9].{56}|[79][0-9][0-9][0-9][0-9].{40}|5[0-9][0-9][0-9][0-9].{192}|8[0-9][0-9][0-9][0-9].{60}|6[0-9][0-9][0-9][0-9].{4})|8(?:[13-68][0-9][0-9][0-9][0-9].{60}|[79][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{384}|2[0-9][0-9][0-9][0-9].{48})|9(?:[124-8][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{476}|9[0-9][0-9][0-9][0-9].{180}|3[0-9][0-9][0-9][0-9].{60})|0(?:[0-5][0-9][0-9][0-9][0-9].{32}|[7-9][0-9][0-9][0-9][0-9].{56}|6[0-9][0-9][0-9][0-9].{4})|4(?:[0-24-9][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{60})|5(?:[0-24-9][0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{60})|[12][0-9][0-9][0-9][0-9][0-9].{56})|0(?:4(?:[0-5][0-9][0-9][0-9][0-9].{248}|[89][0-9][0-9][0-9][0-9].{28}|7[0-9][0-9][0-9][0-9].{108}|6[0-9][0-9][0-9][0-9].{4})|9(?:[4-8][0-9][0-9][0-9][0-9].{16}|[0-2][0-9][0-9][0-9][0-9].{60}|9[0-9][0-9][0-9][0-9].{108}|3[0-9][0-9][0-9][0-9].{12})|7(?:[4-79][0-9][0-9][0-9][0-9].{52}|[0-2][0-9][0-9][0-9][0-9].{108}|8[0-9][0-9][0-9][0-9].{40}|3[0-9][0-9][0-9][0-9].{4})|2(?:[1-7][0-9][0-9][0-9][0-9].{108}|0[0-9][0-9][0-9][0-9].{344}|9[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{4})|1(?:[5-9][0-9][0-9][0-9][0-9].{28}|[0-3][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9].{236})|6(?:[3-9][0-9][0-9][0-9][0-9].{108}|[02][0-9][0-9][0-9][0-9].{4}|1[0-9][0-9][0-9][0-9].{52})|3(?:[1-4][0-9][0-9][0-9][0-9].{16}|[5-9][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{60})|5(?:[2-9][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{4})|8(?:[1-9][0-9][0-9][0-9][0-9].{60}|0[0-9][0-9][0-9][0-9].{92})|0[0-9][0-9][0-9][0-9][0-9].{4})|4(?:1(?:[6-9][0-9][0-9][0-9][0-9].{72}|[12][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{112}|3[0-9][0-9][0-9][0-9].{168}|4[0-9][0-9][0-9][0-9].{520}|5[0-9][0-9][0-9][0-9].{44})|2(?:[0134][0-9][0-9][0-9][0-9].{72}|[6-8][0-9][0-9][0-9][0-9].{104}|5[0-9][0-9][0-9][0-9].{592}|9[0-9][0-9][0-9][0-9].{412}|2[0-9][0-9][0-9][0-9].{16})|0(?:[0-4][0-9][0-9][0-9][0-9].{104}|[78][0-9][0-9][0-9][0-9].{168}|[56][0-9][0-9][0-9][0-9].{40}|9[0-9][0-9][0-9][0-9].{4})|8(?:0[0-9][0-9][0-9][0-9].{112}|4[0-9][0-9][0-9][0-9].{400}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{48})|3(?:[1-7][0-9][0-9][0-9][0-9].{44}|0[0-9][0-9][0-9][0-9].{36})|6(?:0[0-9][0-9][0-9][0-9].{112}|1[0-9][0-9][0-9][0-9].{20})|(?:5[0-4]|4[0-9])[0-9][0-9][0-9][0-9].{80}|9[0-7][0-9][0-9][0-9][0-9].{48})|2(?:8(?:[014-79][0-9][0-9][0-9][0-9].{32}|2[0-9][0-9][0-9][0-9].{180}|3[0-9][0-9][0-9][0-9].{60}|8[0-9][0-9][0-9][0-9].{88})|0(?:[0-26-8][0-9][0-9][0-9][0-9].{4}|[3-5][0-9][0-9][0-9][0-9].{52}|9[0-9][0-9][0-9][0-9].{40})|1(?:[0-5][0-9][0-9][0-9][0-9].{40}|[6-8][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{4})|2(?:[1-79][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{172}|8[0-9][0-9][0-9][0-9].{60})|6(?:[0-36-9][0-9][0-9][0-9][0-9].{16}|5[0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{4})|4(?:[2-9][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{20})|7(?:[3-9][0-9][0-9][0-9][0-9].{32}|[0-2][0-9][0-9][0-9][0-9].{16})|3[0-9][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9][0-9].{32})|1(?:2(?:[3-8][0-9][0-9][0-9][0-9].{108}|1[0-9][0-9][0-9][0-9].{456}|2[0-9][0-9][0-9][0-9].{360}|0[0-9][0-9][0-9][0-9].{92}|9[0-9][0-9][0-9][0-9].{40})|7(?:[02-6][0-9][0-9][0-9][0-9].{20}|[78][0-9][0-9][0-9][0-9].{92}|1[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{4})|8(?:[2-79][0-9][0-9][0-9][0-9].{20}|0[0-9][0-9][0-9][0-9].{388}|1[0-9][0-9][0-9][0-9].{92}|8[0-9][0-9][0-9][0-9].{52})|9(?:[06-9][0-9][0-9][0-9][0-9].{16}|[1245][0-9][0-9][0-9][0-9].{92}|3[0-9][0-9][0-9][0-9].{20})|3(?:[0-4][0-9][0-9][0-9][0-9].{108}|[5-9][0-9][0-9][0-9][0-9].{16})|6(?:[02-8][0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{20})|[01][0-9][0-9][0-9][0-9][0-9].{92}|[45][0-9][0-9][0-9][0-9][0-9].{16}))|0(?:0(?:3(?:1[0-9][0-9][0-9][0-9].{304}|2[0-9][0-9][0-9][0-9].{332}|3[0-9][0-9][0-9][0-9].{560}|4[0-9][0-9][0-9][0-9].{208}|5[0-9][0-9][0-9][0-9].{300}|6[0-9][0-9][0-9][0-9].{476}|7[0-9][0-9][0-9][0-9].{500}|8[0-9][0-9][0-9][0-9].{168}|9[0-9][0-9][0-9][0-9].{696}|0[0-9][0-9][0-9][0-9].{4})|8(?:[12][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{136}|3[0-9][0-9][0-9][0-9].{268}|4[0-9][0-9][0-9][0-9].{196}|5[0-9][0-9][0-9][0-9].{532}|6[0-9][0-9][0-9][0-9].{436}|7[0-9][0-9][0-9][0-9].{520}|8[0-9][0-9][0-9][0-9].{496}|9[0-9][0-9][0-9][0-9].{312})|1(?:[45][0-9][0-9][0-9][0-9].{48}|1[0-9][0-9][0-9][0-9].{108}|2[0-9][0-9][0-9][0-9].{456}|3[0-9][0-9][0-9][0-9].{360}|6[0-9][0-9][0-9][0-9].{480}|7[0-9][0-9][0-9][0-9].{364}|9[0-9][0-9][0-9][0-9].{388}|0[0-9][0-9][0-9][0-9].{80}|8[0-9][0-9][0-9][0-9].{88})|9(?:[0-2][0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{400}|4[0-9][0-9][0-9][0-9].{468}|5[0-9][0-9][0-9][0-9].{592}|6[0-9][0-9][0-9][0-9].{500}|7[0-9][0-9][0-9][0-9].{548}|8[0-9][0-9][0-9][0-9].{616}|9[0-9][0-9][0-9][0-9].{428})|0(?:[02][0-9][0-9][0-9][0-9].{172}|[67][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{152}|8[0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{236}|1[0-9][0-9][0-9][0-9].{24}|3[0-9][0-9][0-9][0-9].{40}|4[0-9][0-9][0-9][0-9].{48})|2(?:[2-4][0-9][0-9][0-9][0-9].{104}|[67][0-9][0-9][0-9][0-9].{140}|5[0-9][0-9][0-9][0-9].{328}|9[0-9][0-9][0-9][0-9].{576}|0[0-9][0-9][0-9][0-9].{32}|1[0-9][0-9][0-9][0-9].{72}|8[0-9][0-9][0-9][0-9].{4})|6(?:[2-4][0-9][0-9][0-9][0-9].{148}|[68][0-9][0-9][0-9][0-9].{16}|[01][0-9][0-9][0-9][0-9].{4}|5[0-9][0-9][0-9][0-9].{404}|7[0-9][0-9][0-9][0-9].{448}|9[0-9][0-9][0-9][0-9].{556})|7(?:[013-6][0-9][0-9][0-9][0-9].{4}|[89][0-9][0-9][0-9][0-9].{16}|7[0-9][0-9][0-9][0-9].{248}|2[0-9][0-9][0-9][0-9].{12})|5(?:[13-8][0-9][0-9][0-9][0-9].{4}|[02][0-9][0-9][0-9][0-9].{56}|9[0-9][0-9][0-9][0-9].{404})|4(?:[03-9][0-9][0-9][0-9][0-9].{4}|[12][0-9][0-9][0-9][0-9].{12}))|1(?:0(?:[125][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{528}|3[0-9][0-9][0-9][0-9].{416}|4[0-9][0-9][0-9][0-9].{412}|6[0-9][0-9][0-9][0-9].{472})|2(?:[1-3][0-9][0-9][0-9][0-9].{40}|8[0-9][0-9][0-9][0-9].{252}|4[0-9][0-9][0-9][0-9].{44}|9[0-9][0-9][0-9][0-9].{60})|6(?:[0-4][0-9][0-9][0-9][0-9].{20}|6[0-9][0-9][0-9][0-9].{16})|9(?:[2-4][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{212})|7(?:6[0-9][0-9][0-9][0-9].{52}|7[0-9][0-9][0-9][0-9].{92})|30[0-9][0-9][0-9][0-9].{344}|40[0-9][0-9][0-9][0-9].{356}|5[0-9][0-9][0-9][0-9][0-9].{20}|80[0-9][0-9][0-9][0-9].{204})|9(?:8(?:1[0-9][0-9][0-9][0-9].{16}|8[0-9][0-9][0-9][0-9].{36})|9(?:1[0-9][0-9][0-9][0-9].{16}|9[0-9][0-9][0-9][0-9].{36})|66[0-9][0-9][0-9][0-9].{16}|77[0-9][0-9][0-9][0-9].{36})|2(?:6(?:0[0-9][0-9][0-9][0-9].{132}|6[0-9][0-9][0-9][0-9].{16})|0[01][0-9][0-9][0-9][0-9].{28}|2[01][0-9][0-9][0-9][0-9].{4}|80[0-9][0-9][0-9][0-9].{216})|3(?:0(?:0[0-9][0-9][0-9][0-9].{176}|3[0-9][0-9][0-9][0-9].{4})|1[367][0-9][0-9][0-9][0-9].{4}|33[0-9][0-9][0-9][0-9].{372}|66[0-9][0-9][0-9][0-9].{16})|8(?:(?:8[01]|92)[0-9][0-9][0-9][0-9].{12}|[0-3][0-9][0-9][0-9][0-9][0-9].{8}|66[0-9][0-9][0-9][0-9].{16})|4(?:(?:0[124-8]|4[0-3])[0-9][0-9][0-9][0-9].{4}|(?:8[1-4]|7[12]|66)[0-9][0-9][0-9][0-9].{16})|[5-7][0-9][0-9][0-9][0-9][0-9][0-9].{8})|4(?:8(?:6(?:[0135-9][0-9][0-9][0-9][0-9].{8}|[24][0-9][0-9][0-9][0-9].{56})|1(?:[0-57-9][0-9][0-9][0-9][0-9].{8}|6[0-9][0-9][0-9][0-9].{56})|[02-57-9][0-9][0-9][0-9][0-9][0-9].{8})|9(?:7(?:[0-46-9][0-9][0-9][0-9][0-9].{8}|5[0-9][0-9][0-9][0-9].{56})|[0-689][0-9][0-9][0-9][0-9][0-9].{8})|[0-7][0-9][0-9][0-9][0-9][0-9][0-9].{8})|(?:(?:5[035-8]|6[0149]|3[049]|9[01])[0-9]|24[12])[0-9][0-9][0-9][0-9][0-9].{8})|9(?:7(?:0(?:5(?:0[0-9][0-9][0-9][0-9].{340}|1[0-9][0-9][0-9][0-9].{496}|2[0-9][0-9][0-9][0-9].{468}|3[0-9][0-9][0-9][0-9].{480}|4[0-9][0-9][0-9][0-9].{216}|5[0-9][0-9][0-9][0-9].{428}|6[0-9][0-9][0-9][0-9].{640}|7[0-9][0-9][0-9][0-9].{416}|8[0-9][0-9][0-9][0-9].{440}|9[0-9][0-9][0-9][0-9].{472})|3(?:0[0-9][0-9][0-9][0-9].{388}|1[0-9][0-9][0-9][0-9].{532}|3[0-9][0-9][0-9][0-9].{556}|4[0-9][0-9][0-9][0-9].{276}|5[0-9][0-9][0-9][0-9].{672}|6[0-9][0-9][0-9][0-9].{256}|7[0-9][0-9][0-9][0-9].{436}|8[0-9][0-9][0-9][0-9].{520}|9[0-9][0-9][0-9][0-9].{652}|2[0-9][0-9][0-9][0-9].{36})|1(?:[34][0-9][0-9][0-9][0-9].{4}|0[0-9][0-9][0-9][0-9].{284}|1[0-9][0-9][0-9][0-9].{100}|2[0-9][0-9][0-9][0-9].{576}|5[0-9][0-9][0-9][0-9].{168}|6[0-9][0-9][0-9][0-9].{452}|7[0-9][0-9][0-9][0-9].{148}|8[0-9][0-9][0-9][0-9].{448}|9[0-9][0-9][0-9][0-9].{500})|0(?:[2-5][0-9][0-9][0-9][0-9].{224}|1[0-9][0-9][0-9][0-9].{172}|7[0-9][0-9][0-9][0-9].{456}|9[0-9][0-9][0-9][0-9].{256}|0[0-9][0-9][0-9][0-9].{56}|6[0-9][0-9][0-9][0-9].{36}|8[0-9][0-9][0-9][0-9].{32})|2(?:[78][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{188}|3[0-9][0-9][0-9][0-9].{560}|4[0-9][0-9][0-9][0-9].{208}|5[0-9][0-9][0-9][0-9].{196}|6[0-9][0-9][0-9][0-9].{104}|9[0-9][0-9][0-9][0-9].{36})|7(?:0[0-9][0-9][0-9][0-9].{112}|5[0-9][0-9][0-9][0-9].{328}|9[0-9][0-9][0-9][0-9].{404}|7[0-9][0-9][0-9][0-9].{92})|6(?:[0-3][0-9][0-9][0-9][0-9].{36}|4[0-9][0-9][0-9][0-9].{412}|5[0-9][0-9][0-9][0-9].{312})|[89][0-9][0-9][0-9][0-9][0-9].{4}|4[0-9][0-9][0-9][0-9][0-9].{28})|6(?:7(?:0[0-9][0-9][0-9][0-9].{204}|2[0-9][0-9][0-9][0-9].{152}|6[0-9][0-9][0-9][0-9].{212}|1[0-9][0-9][0-9][0-9].{40}|7[0-9][0-9][0-9][0-9].{48}|3[0-9][0-9][0-9][0-9].{8})|1(?:[023][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{212}|5[0-9][0-9][0-9][0-9].{204}|7[0-9][0-9][0-9][0-9].{48})|3(?:[1-3][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9].{204}|7[0-9][0-9][0-9][0-9].{48})|0(?:[2-9][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{152})|2(?:2[0-9][0-9][0-9][0-9].{212}|7[0-9][0-9][0-9][0-9].{48})|4(?:1[0-9][0-9][0-9][0-9].{700}|7[0-9][0-9][0-9][0-9].{48})|(?:6[1-9]|5[0-2]|9[0-9])[0-9][0-9][0-9][0-9].{8})|4(?:6(?:[018][0-9][0-9][0-9][0-9].{4}|[23][0-9][0-9][0-9][0-9].{52}|[56][0-9][0-9][0-9][0-9].{16}|4[0-9][0-9][0-9][0-9].{212}|7[0-9][0-9][0-9][0-9].{364}|9[0-9][0-9][0-9][0-9].{8})|7(?:[67][0-9][0-9][0-9][0-9].{60}|[89][0-9][0-9][0-9][0-9].{4}|3[0-9][0-9][0-9][0-9].{212}|1[0-9][0-9][0-9][0-9].{80}|5[0-9][0-9][0-9][0-9].{48})|(?:0[1-9]|8[0-689]|4[0-6]|1[5-9]|[23][0-9])[0-9][0-9][0-9][0-9].{4}|5(?:[0-245][0-9][0-9][0-9][0-9].{16}|3[0-9][0-9][0-9][0-9].{72})|91[0-9][0-9][0-9][0-9].{356})|1(?:1(?:[12][0-9][0-9][0-9][0-9].{316}|[3-5][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{100})|0(?:0[0-9][0-9][0-9][0-9].{180}|2[0-9][0-9][0-9][0-9].{528}|1[0-9][0-9][0-9][0-9].{16})|7(?:1[0-9][0-9][0-9][0-9].{388}|0[0-9][0-9][0-9][0-9].{36}|3[0-9][0-9][0-9][0-9].{16})|(?:5[0-35-9]|[2-46][0-9])[0-9][0-9][0-9][0-9].{8}|[89][0-9][0-9][0-9][0-9][0-9].{4})|7(?:4(?:[4-9][0-9][0-9][0-9][0-9].{8}|[0-3][0-9][0-9][0-9][0-9].{24})|7(?:[0-689][0-9][0-9][0-9][0-9].{8}|7[0-9][0-9][0-9][0-9].{132})|0(?:[02-9][0-9][0-9][0-9][0-9].{8}|1[0-9][0-9][0-9][0-9].{4})|(?:5[0-46-9]|8[0-79]|[369][0-9])[0-9][0-9][0-9][0-9].{8}|(?:2[0-2]|1[0-9])[0-9][0-9][0-9][0-9].{28})|5(?:1(?:[05][0-9][0-9][0-9][0-9].{204}|[16][0-9][0-9][0-9][0-9].{584}|2[0-9][0-9][0-9][0-9].{252}|3[0-9][0-9][0-9][0-9].{344}|4[0-9][0-9][0-9][0-9].{160}|7[0-9][0-9][0-9][0-9].{92}|8[0-9][0-9][0-9][0-9].{88}|9[0-9][0-9][0-9][0-9].{80})|[2-9][0-9][0-9][0-9][0-9][0-9].{8}|0[0-9][0-9][0-9][0-9][0-9].{28})|8(?:0(?:[0-25][0-9][0-9][0-9][0-9].{8}|[34][0-9][0-9][0-9][0-9].{152})|2(?:[0-2][0-9][0-9][0-9][0-9].{12}|3[0-9][0-9][0-9][0-9].{460})|4[0-2][0-9][0-9][0-9][0-9].{488}|35[0-9][0-9][0-9][0-9].{192}|7[0-9][0-9][0-9][0-9][0-9].{4}|97[0-9][0-9][0-9][0-9].{48})|2(?:6(?:[0-6][0-9][0-9][0-9][0-9].{72}|[7-9][0-9][0-9][0-9][0-9].{16})|0(?:0[0-9][0-9][0-9][0-9].{100}|9[0-9][0-9][0-9][0-9].{80})|[1-5][0-9][0-9][0-9][0-9][0-9].{72}|72[0-9][0-9][0-9][0-9].{48}|9[0-9][0-9][0-9][0-9][0-9].{8})|3(?:3(?:[04][0-9][0-9][0-9][0-9].{212}|[12][0-9][0-9][0-9][0-9].{52})|8[24-7][0-9][0-9][0-9][0-9].{16}|0[0-2][0-9][0-9][0-9][0-9].{44}|[45][0-9][0-9][0-9][0-9][0-9].{4}|73[0-9][0-9][0-9][0-9].{572})|9(?:9(?:[5-79][0-9][0-9][0-9][0-9].{16}|[0-2][0-9][0-9][0-9][0-9].{8}|4[0-9][0-9][0-9][0-9].{72})|[0-8][0-9][0-9][0-9][0-9][0-9].{8}))|8(?:0(?:0(?:0[0-9][0-9][0-9][0-9].{372}|1[0-9][0-9][0-9][0-9].{352}|8[0-9][0-9][0-9][0-9].{60})|[12][0-9][0-9][0-9][0-9][0-9].{372}|30[0-9][0-9][0-9][0-9].{476}|50[0-9][0-9][0-9][0-9].{156}|60[0-9][0-9][0-9][0-9].{144}|70[0-9][0-9][0-9][0-9].{108}|80[0-9][0-9][0-9][0-9].{112}|40[0-9][0-9][0-9][0-9].{60}|98[0-9][0-9][0-9][0-9].{48})|8(?:9(?:0[0-9][0-9][0-9][0-9].{360}|8[0-9][0-9][0-9][0-9].{48}|9[0-9][0-9][0-9][0-9].{60})|(?:66|77)[0-9][0-9][0-9][0-9].{60}|2[0-2][0-9][0-9][0-9][0-9].{48}|11[0-9][0-9][0-9][0-9].{100}|8[0-9][0-9][0-9][0-9][0-9].{4})|2(?:[2-6][0-9][0-9][0-9][0-9][0-9].{20}|1[01][0-9][0-9][0-9][0-9].{36}|82[0-9][0-9][0-9][0-9].{516}|98[0-9][0-9][0-9][0-9].{144})|7(?:27[0-9][0-9][0-9][0-9].{660}|87[0-9][0-9][0-9][0-9].{268}|65[0-9][0-9][0-9][0-9].{20}|98[0-9][0-9][0-9][0-9].{48})|6(?:86[0-9][0-9][0-9][0-9].{304}|98[0-9][0-9][0-9][0-9].{48})|1[0-9][0-9][0-9][0-9][0-9][0-9].{20}|31[1-4][0-9][0-9][0-9][0-9].{444}|[45]98[0-9][0-9][0-9][0-9].{48}|9[0-9][0-9][0-9][0-9][0-9][0-9].{4})|00(?:2(?:0[0-9][0-9][0-9][0-9].{708}|1[0-9][0-9][0-9][0-9].{548}|2[0-9][0-9][0-9][0-9].{616}|3[0-9][0-9][0-9][0-9].{480}|5[0-9][0-9][0-9][0-9].{428}|6[0-9][0-9][0-9][0-9].{528}|7[0-9][0-9][0-9][0-9].{416}|8[0-9][0-9][0-9][0-9].{440}|9[0-9][0-9][0-9][0-9].{472}|4[0-9][0-9][0-9][0-9].{36})|0(?:1[0-9][0-9][0-9][0-9].{148}|3[0-9][0-9][0-9][0-9].{328}|4[0-9][0-9][0-9][0-9].{352}|5[0-9][0-9][0-9][0-9].{404}|6[0-9][0-9][0-9][0-9].{208}|7[0-9][0-9][0-9][0-9].{572}|8[0-9][0-9][0-9][0-9].{268}|0[0-9][0-9][0-9][0-9].{24}|2[0-9][0-9][0-9][0-9].{72}|9[0-9][0-9][0-9][0-9].{60})|1(?:[146][0-9][0-9][0-9][0-9].{16}|0[0-9][0-9][0-9][0-9].{136}|2[0-9][0-9][0-9][0-9].{532}|3[0-9][0-9][0-9][0-9].{168}|5[0-9][0-9][0-9][0-9].{436}|7[0-9][0-9][0-9][0-9].{400}|8[0-9][0-9][0-9][0-9].{496}|9[0-9][0-9][0-9][0-9].{312})|3(?:[23][0-9][0-9][0-9][0-9].{40}|0[0-9][0-9][0-9][0-9].{344}|1[0-9][0-9][0-9][0-9].{412})|65[0-9][0-9][0-9][0-9].{404}|94[0-9][0-9][0-9][0-9].{468})|5[0-9][0-9][0-9][0-9][0-9][0-9][0-9].{12}|6[0-9][0-9][0-9][0-9][0-9][0-9][0-9].{8})|6(?:9(?:0(?:0(?:[1-4][0-9][0-9][0-9][0-9].{424}|[05][0-9][0-9][0-9][0-9].{68}|[67][0-9][0-9][0-9][0-9].{96})|2(?:[013-5][0-9][0-9][0-9][0-9].{96}|[6-9][0-9][0-9][0-9][0-9].{76}|2[0-9][0-9][0-9][0-9].{228})|6(?:[0-578][0-9][0-9][0-9][0-9].{76}|6[0-9][0-9][0-9][0-9].{228}|9[0-9][0-9][0-9][0-9].{96})|8(?:[0-6][0-9][0-9][0-9][0-9].{96}|7[0-9][0-9][0-9][0-9].{508}|8[0-9][0-9][0-9][0-9].{228})|4(?:[017-9][0-9][0-9][0-9][0-9].{76}|[2-6][0-9][0-9][0-9][0-9].{96})|1(?:[1-9][0-9][0-9][0-9][0-9].{96}|0[0-9][0-9][0-9][0-9].{508})|3(?:[0-57-9][0-9][0-9][0-9][0-9].{76}|6[0-9][0-9][0-9][0-9].{96})|7(?:[0-6][0-9][0-9][0-9][0-9].{76}|7[0-9][0-9][0-9][0-9].{228})|5[0-9][0-9][0-9][0-9][0-9].{76}|9[0-9][0-9][0-9][0-9][0-9].{68})|6(?:1(?:[016-9][0-9][0-9][0-9][0-9].{96}|[2-5][0-9][0-9][0-9][0-9].{432})|8(?:[0-6][0-9][0-9][0-9][0-9].{76}|[7-9][0-9][0-9][0-9][0-9].{68})|9(?:[0-8][0-9][0-9][0-9][0-9].{96}|9[0-9][0-9][0-9][0-9].{76})|(?:5[0-2]|7[0-9])[0-9][0-9][0-9][0-9].{96}|(?:6[01]|0[0-9])[0-9][0-9][0-9][0-9].{68}|[2-4][0-9][0-9][0-9][0-9][0-9].{76})|3(?:9(?:[0-3][0-9][0-9][0-9][0-9].{124}|[47][0-9][0-9][0-9][0-9].{84})|0(?:[1-4][0-9][0-9][0-9][0-9].{84}|0[0-9][0-9][0-9][0-9].{124})|3(?:3[0-9][0-9][0-9][0-9].{124}|0[0-9][0-9][0-9][0-9].{68})|(?:4[0-7]|8[0-3]|[5-7]0)[0-9][0-9][0-9][0-9].{68}|(?:1[03]|20)[0-9][0-9][0-9][0-9].{84})|2(?:4(?:[0-4][0-9][0-9][0-9][0-9].{124}|[5-9][0-9][0-9][0-9][0-9].{84})|9(?:[015-9][0-9][0-9][0-9][0-9].{84}|[2-4][0-9][0-9][0-9][0-9].{68})|0(?:[0-57-9][0-9][0-9][0-9][0-9].{124}|6[0-9][0-9][0-9][0-9].{84})|[15-8][0-9][0-9][0-9][0-9][0-9].{84}|[23][0-9][0-9][0-9][0-9][0-9].{124})|4(?:1(?:[2-6][0-9][0-9][0-9][0-9].{96}|[01][0-9][0-9][0-9][0-9].{568})|4(?:[0-5][0-9][0-9][0-9][0-9].{76}|[67][0-9][0-9][0-9][0-9].{68})|(?:3[018]|2[0-9])[0-9][0-9][0-9][0-9].{76}|0[0-7][0-9][0-9][0-9][0-9].{68}|9[0-9][0-9][0-9][0-9][0-9].{96})|[89][0-9][0-9][0-9][0-9][0-9][0-9].{20}|5[0-9][0-9][0-9][0-9][0-9][0-9].{272})|0(?:0(?:4(?:3[0-9][0-9][0-9][0-9].{228}|5[0-9][0-9][0-9][0-9].{508}|1[0-9][0-9][0-9][0-9].{76}|2[0-9][0-9][0-9][0-9].{96}|4[0-9][0-9][0-9][0-9].{68})|5(?:1[0-9][0-9][0-9][0-9].{124}|3[0-9][0-9][0-9][0-9].{112}|2[0-9][0-9][0-9][0-9].{84}|4[0-9][0-9][0-9][0-9].{68})|[06][0-9][0-9][0-9][0-9][0-9].{272}|[18][0-9][0-9][0-9][0-9][0-9].{32}|[39][0-9][0-9][0-9][0-9][0-9].{20}|[27][0-9][0-9][0-9][0-9][0-9].{4})|2(?:[016-9][0-9][0-9][0-9][0-9][0-9].{120}|[23][0-9][0-9][0-9][0-9][0-9].{144}|[45][0-9][0-9][0-9][0-9][0-9].{612})|4(?:[014][0-9][0-9][0-9][0-9][0-9].{144}|[5-9][0-9][0-9][0-9][0-9][0-9].{4}|[23][0-9][0-9][0-9][0-9][0-9].{200})|6(?:[0-3][0-9][0-9][0-9][0-9][0-9].{200}|[5-9][0-9][0-9][0-9][0-9][0-9].{64}|4[0-9][0-9][0-9][0-9][0-9].{144})|5(?:[0-4][0-9][0-9][0-9][0-9][0-9].{380}|[5-9][0-9][0-9][0-9][0-9][0-9].{264})|[139][0-9][0-9][0-9][0-9][0-9][0-9].{4}|[78][0-9][0-9][0-9][0-9][0-9][0-9].{32})|4(?:9(?:9(?:[467][0-9][0-9][0-9][0-9].{200}|[01][0-9][0-9][0-9][0-9].{132}|[23][0-9][0-9][0-9][0-9].{120}|[58][0-9][0-9][0-9][0-9].{376}|9[0-9][0-9][0-9][0-9].{492})|5(?:[1-9][0-9][0-9][0-9][0-9].{120}|0[0-9][0-9][0-9][0-9].{52})|[0-46-8][0-9][0-9][0-9][0-9][0-9].{120})|1(?:6(?:[6-9][0-9][0-9][0-9][0-9].{116}|[01][0-9][0-9][0-9][0-9].{64}|2[0-9][0-9][0-9][0-9].{580}|3[0-9][0-9][0-9][0-9].{712}|5[0-9][0-9][0-9][0-9].{200}|4[0-9][0-9][0-9][0-9].{44})|[0-589][0-9][0-9][0-9][0-9][0-9].{240}|7[0-9][0-9][0-9][0-9][0-9].{64})|0(?:0(?:[0-4][0-9][0-9][0-9][0-9].{368}|[5-9][0-9][0-9][0-9][0-9].{260})|[1-9][0-9][0-9][0-9][0-9][0-9].{32})|4(?:[07-9][0-9][0-9][0-9][0-9][0-9].{240}|[4-6][0-9][0-9][0-9][0-9][0-9].{408}|[1-3][0-9][0-9][0-9][0-9][0-9].{32})|[23578][0-9][0-9][0-9][0-9][0-9][0-9].{32}|6[0-9][0-9][0-9][0-9][0-9][0-9].{4})|3(?:9(?:0(?:[3-7][0-9][0-9][0-9][0-9].{68}|0[0-9][0-9][0-9][0-9].{124}|9[0-9][0-9][0-9][0-9].{84})|2(?:[0-57-9][0-9][0-9][0-9][0-9].{84}|6[0-9][0-9][0-9][0-9].{68})|6(?:[5-9][0-9][0-9][0-9][0-9].{84}|[01][0-9][0-9][0-9][0-9].{124})|9(?:[4-7][0-9][0-9][0-9][0-9].{68}|0[0-9][0-9][0-9][0-9].{112})|1(?:[01][0-9][0-9][0-9][0-9].{84}|9[0-9][0-9][0-9][0-9].{68})|3(?:0[0-9][0-9][0-9][0-9].{112}|9[0-9][0-9][0-9][0-9].{68})|[57]0[0-9][0-9][0-9][0-9].{112}|40[0-9][0-9][0-9][0-9].{84})|8(?:[1-9][0-9][0-9][0-9][0-9][0-9].{32}|00[0-9][0-9][0-9][0-9].{368})|6(?:[5-9][0-9]|[0-4][0-9])[0-9][0-9][0-9][0-9].{64}|[0-37][0-9][0-9][0-9][0-9][0-9][0-9].{32}|[45][0-9][0-9][0-9][0-9][0-9][0-9].{4})|5(?:6(?:6(?:[6-9][0-9][0-9][0-9][0-9].{376}|0[0-9][0-9][0-9][0-9].{580}|1[0-9][0-9][0-9][0-9].{636})|[0-59][0-9][0-9][0-9][0-9][0-9].{200}|[78][0-9][0-9][0-9][0-9][0-9].{240})|3(?:[5-9][0-9][0-9][0-9][0-9][0-9].{272}|[0-4][0-9][0-9][0-9][0-9][0-9].{20})|[089][0-9][0-9][0-9][0-9][0-9][0-9].{20}|[12][0-9][0-9][0-9][0-9][0-9][0-9].{272}|7[0-9][0-9][0-9][0-9][0-9][0-9].{200}|4[0-9][0-9][0-9][0-9][0-9][0-9].{32}|5[0-9][0-9][0-9][0-9][0-9][0-9].{4})|6(?:9(?:[0-79][0-9][0-9][0-9][0-9][0-9].{20}|8[0-9][0-9][0-9][0-9][0-9].{4})|[0-8][0-9][0-9][0-9][0-9][0-9][0-9].{20})|[78][0-9][0-9][0-9][0-9][0-9][0-9][0-9].{32}|[12][0-9][0-9][0-9][0-9][0-9][0-9][0-9].{4})|7(?:5(?:0(?:6(?:[1-9][0-9][0-9][0-9][0-9].{120}|0[0-9][0-9][0-9][0-9].{116})|(?:[05][0-9]|70)[0-9][0-9][0-9][0-9].{116}|[2-489][0-9][0-9][0-9][0-9][0-9].{120}|1[0-9][0-9][0-9][0-9][0-9].{680})|7(?:5(?:[0-6][0-9][0-9][0-9][0-9].{260}|[78][0-9][0-9][0-9][0-9].{116}|9[0-9][0-9][0-9][0-9].{92})|(?:7[78]|6[0-9]|87)[0-9][0-9][0-9][0-9].{116}|[01]7[0-9][0-9][0-9][0-9].{60})|5(?:5(?:[0-4][0-9][0-9][0-9][0-9].{44}|[589][0-9][0-9][0-9][0-9].{116}|[67][0-9][0-9][0-9][0-9].{132})|6[6-9][0-9][0-9][0-9][0-9].{116})|1(?:[0-5][0-9][0-9][0-9][0-9][0-9].{264}|6[0-9][0-9][0-9][0-9][0-9].{120})|20[01][0-9][0-9][0-9][0-9].{492}|432[0-9][0-9][0-9][0-9].{116})|7(?:0(?:[0-4][0-9][0-9][0-9][0-9][0-9].{120}|[5-9][0-9][0-9][0-9][0-9][0-9].{64})|[78][0-9][0-9][0-9][0-9][0-9][0-9].{4})|8(?:(?:6(?:[1-9][0-9]|0[0-9])|(?:8[0-5]|7[0-9])[0-9])[0-9][0-9][0-9][0-9].{32}|00[0-9][0-9][0-9][0-9][0-9].{144})|6(?:0(?:[1-9][0-9]|0[0-9])|[1-4][0-9][0-9])[0-9][0-9][0-9][0-9].{20}))/) {
        my $op = substr($1, -4);
        $op =~ s/ *$//;
        return $op;
    }
    return undef;
}

1; # vim:set ft=perl et sw=4 sts=4:
