#!/usr/bin/perl -w -I ../../../lib

use 5.018;

use strict;

use Carp;

{ package Narwhal::Effect::Fade;

    use Moose;
    use Moose::Util::TypeConstraints;

    extends 'Narwhal::Effect';
    
    enum 'Form', [qw(quarter half triangular logarithmic parabola)];
    
    has 'in' => (
        is => 'rw',
        isa => 'Num',
    );
    
    has 'out' => (
        is => 'rw',
        isa => 'Num',
    );
    
    has 'form' => (
        is => 'rw',
        isa => 'Form',
    );
    
    sub soxi {
        my $self = shift;        
        my %form_soxi_table = ('quarter' => 'q','half' => 'h','triangular' => 't','logarithmic' => 'l','parabola' => 'p');
        my $ret = sprintf("%s %s %s 0 %s",$self->fx,$form_soxi_table{$self->form},$self->in,$self->out);
        return($ret);
    }
}

1;