package Settlers::Event::YearOfPlenty;
$Settlers::Event::YearOfPlenty::VERSION = '0.07';
use strict;
use warnings;
use List::Util 'sum';

sub new { bless {}, shift }

sub validate
{
  my ($self, $trade) = @_;
  die 'calculate requires a trade argument'
    unless $trade && $trade->isa('Settlers::Game::Trade');;

  die 'YearOfPlenty only permits up to 2 resources to be taken for 1 player'
    unless 2 == @{$trade->players} && -2 == sum map {$_->amount} @{$trade->resources('bank')};
  return 1;
}
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Settlers::Event::YearOfPlenty

=head1 VERSION

version 0.07

=head1 AUTHOR

David Farrell <dfarrell@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by David Farrell.

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut
