package Settlers::Event::RoadBuilding;
$Settlers::Event::RoadBuilding::VERSION = '0.07';
use strict;
use warnings;

sub new
{
  my ($class, $player) = @_;
  die 'RoadBuilding requires a player object argument'
    unless $player && $player->isa('Settlers::Game::Player');

  bless {
    starting_roads => scalar @{$player->roads},
    player => $player,
  }, $class;
}

# has a player built 2 roads since activating road building
sub can_build_road
{
  my $self = shift;
  return $self->{starting_roads} - scalar @{$self->{player}->roads} < 2 ? 1 : 0;
}
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Settlers::Event::RoadBuilding

=head1 VERSION

version 0.07

=head1 AUTHOR

David Farrell <dfarrell@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by David Farrell.

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut
