# SDK-SoundCloud

## Why?
This module came about as a side project while working on a SoundCloud UI improvement lib.

## Install

1 Clone the repo

2 Install Dist::Zilla

3 Run Auth and list deps

4 Build TARBALL using dzil

5 cpanm tarball

## Basic Usage

Create new instance of SDK client.
```
my $SoundCloud = SDK::SoundCloud->new(client_id => $client_id);
```
Get Auth url, redirect user to SoundCloud to get auth code for OAuthToken.
```
my $redirect_url = $SoundCloud->connect_url(redirect_uri => $redirect_uri);
redirect $redirect_uri;
```

After auth and redirect from SoundCloud's auth service. Capture code param and get OAuthToken.
```
$SoundCloud->get_token(
    client_secret => $client_secret,
    code => param->{code},
    redirect_uri => $redirect_uri
);
```

Until all methods are implemented the req method can be used to query the
SoundCloud API.
```
$SoundCloud->req($params_hashref)
```

__req__ method signature allows for @{$params_hashref}{qw/method url path query data header/}

* __method__ defaults to get
* __url__ defaults to api.soundlcoud.com
* __path__ is required
* __query__ accepts hashref that will be building into a url query string and attached to the path.
* __data__ will be json encoded and attached to the body.
* __header__ takes key => value and adds it to the header.
