package SDK::SoundCloud;
# ABSTRACT: SoundCloud SDK.

use strict;
use warnings;
use utf8;
use Moo;
use namespace::clean;

has 'client_id' => (
    is => 'ro',
    required => 1
);

has 'token' => (
    is => 'rw'
);

with 'SDK::SoundCloud::HTTP';
with 'SDK::SoundCloud::Connect';
with 'SDK::SoundCloud::OAuth2Token';

#ಠ_ಠ

1;
__END__
=pod
 
=encoding UTF-8
 
=head1 NAME
 
SDK::SoundCloud - SDK for the SoundCloud API
 
=head1 VERSION
 
version 1.005
 
=head1 SYNOPSIS
 
    use SDK::SoundCloud;
 
    my $SoundCloud = SoundCloud->new(client_id => $client_id);
    
    Get Auth url, redirect user to SoundCloud to get auth code for OAuthToken.

    my $redirect_url = $SoundCloud->connect_url(redirect_uri => $redirect_uri);

    redirect $redirect_uri;

    After auth and redirect from SoundCloud's auth service. Capture code param and get OAuthToken.

    $SoundCloud->get_token(
        client_secret => $client_secret,
        code => param->{code},
        redirect_uri => $redirect_uri
    );

    Until all methods are implemented the req method can be used to query the
    SoundCloud API.

    $SoundCloud->req($params_hashref)

    __req__ method signature allows for @{$params_hashref}{qw/method url path query data header/}

    * __method__ defaults to get
    * __url__ defaults to api.soundlcoud.com
    * __path__ is required
    * __query__ accepts hashref that will be building into a url query string and attached to the path.
    * __data__ will be json encoded and attached to the body.
    * __header__ takes key => value and adds it to the header.

=head1 DESCRIPTION
 
This SDK client provides a interface for communicating with the SoundCloud.com API.
 
=head1 SEE ALSO
 
=head1 AUTHOR
 
John Rummel <desertfox@cpan.org>
 
=head1 COPYRIGHT AND LICENSE
 
This software is copyright (c) 2015 by John Rummel
 
This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.
 
=cut
