use ExtUtils::MakeMaker;
use Config;

WriteMakefile(
    NAME         => 'CPAN::FindDependencies',
    VERSION_FROM => 'lib/CPAN/FindDependencies.pm',
    EXE_FILES    => [qw(
        examples/cpandeps
    )],
    PREREQ_PM    => {
        'Parse::CPAN::Packages' => 2.31,
        'Module::CoreList'      => 2.12,
        # 'YAML'                  => 0.61,
        'YAML::Tiny'            => 1.36,
        'LWP::Simple'           => 1.41,
        'Scalar::Util'          => 1.14,
        'URI::file'             => 4.13,
        'File::Temp'            => 0.19,
        'Capture::Tiny'         => 0.05,
        'Devel::CheckOS'        => 1.52,
    },
    dist => {
        DIST_CP => 'cp',
        PREOP => "$Config{perlpath} -Mstrict -Mlib::CPAN::FindDependencies -w shared/doincludes \$(EXE_FILES) \$(TO_INST_PM)"
    }
);

# commented out cos doesn't work on Doze
# package MY;
# sub test {
#     my $text = shift->SUPER::test(@_);
#     $text =~ s/\t(.*test_harness)/\tHARNESS_OPTIONS=j8 $1/;
#     $text;
# }
