package KinoSearch::Store::FileHandle;
use KinoSearch;

1;

__END__

__BINDING__

my $xs_code = <<'END_XS_CODE';
MODULE = KinoSearch     PACKAGE = KinoSearch::Store::FileHandle

=for comment

For testing purposes only.  Track number of FileHandle objects in existence.

=cut

chy_u32_t
FH_READ_ONLY()
CODE:
    RETVAL = KINO_FH_READ_ONLY;
OUTPUT: RETVAL

chy_u32_t
FH_WRITE_ONLY()
CODE:
    RETVAL = KINO_FH_WRITE_ONLY;
OUTPUT: RETVAL

chy_u32_t
FH_CREATE()
CODE:
    RETVAL = KINO_FH_CREATE;
OUTPUT: RETVAL

chy_u32_t
FH_EXCLUSIVE()
CODE:
    RETVAL = KINO_FH_EXCLUSIVE;
OUTPUT: RETVAL


chy_i32_t
object_count()
CODE:
    RETVAL = kino_FH_object_count;
OUTPUT: RETVAL

=for comment

For testing purposes only.  Used to help produce buffer alignment tests.

=cut

IV
_BUF_SIZE()
CODE:
   RETVAL = KINO_IO_STREAM_BUF_SIZE;
OUTPUT: RETVAL
END_XS_CODE

Clownfish::Binding::Perl::Class->register(
    parcel            => "KinoSearch",
    class_name        => "KinoSearch::Store::FileHandle",
    xs_code           => $xs_code,
    bind_methods      => [qw( Length Close )],
    bind_constructors => ['_open|do_open'],
);

__COPYRIGHT__

Copyright 2005-2010 Marvin Humphrey

This program is free software; you can redistribute it and/or modify
under the same terms as Perl itself.

