# Copyright (C) 2001-2003, The Perl Foundation.
# $Id: hints.pm 21956 2007-10-07 21:59:35Z jkeenan $

=head1 NAME

config/init/hints.pm - Platform Hints

=head1 DESCRIPTION

Loads the platform and local hints files, modifying the defaults set up in
F<config/init/default.pm>.

=cut

package init::hints;

use strict;
use warnings;
use vars qw($description @args);

use base qw(Parrot::Configure::Step::Base);

use Parrot::Configure::Step;

$description = 'Loading platform and local hints files';

@args = qw( cc verbose define );

sub runstep {
    my ( $self, $conf ) = @_;

    my $verbose = $conf->options->get('verbose');

    my $hints_used = 0;

    my $hints = "init::hints::" . lc($^O);

    print "[ $hints " if $verbose;

    eval "use $hints";
    die $@ if $@;

    # Call the runstep method if it exists.
    # Otherwise the step must have done its work when it was loaded.
    $hints->runstep( $conf, @_ ) if $hints->can('runstep');
    $hints_used++;

    $hints = "init::hints::local";
    print "$hints " if $verbose;
    eval "use $hints";

    unless ($@) {
        $hints->runstep( $conf, @_ ) if $hints->can('runstep');
        $hints_used++;
    }

    if ( $hints_used == 0 and $verbose ) {
        print "(no hints) ";
    }

    print "]" if $verbose;

    return 1;
}

1;

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
