# This Makefile.PL for Alien-libuv was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.47.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

if ($^O eq 'MSWin32') {
    my $ver;
    my $err;
    { # catch block
        local $@;
        # try
        $err = $@ || 'Error' unless eval {
            require Win32;
            $ver = (Win32::GetOSVersion())[1];
            1;
        };
    }
    if ($err || $ver < 6) {
        die("OS unsupported\nWindows needs to be Win7 or higher.\n");
    }
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "Interface to the libuv library L<http://libuv.org>",
  "AUTHOR" => "Chase Whitener <capoeirab\@cpan.org>",
  "BUILD_REQUIRES" => {
    "Alien::Build" => "1.00",
    "Alien::Build::MM" => "0.32",
    "Alien::Build::Plugin::Build::Make" => 0,
    "Config" => 0,
    "ExtUtils::MakeMaker" => "6.52",
    "IPC::Cmd" => 0
  },
  "CONFIGURE_REQUIRES" => {
    "Alien::Build" => "0.32",
    "Alien::Build::MM" => "0.32",
    "Alien::Build::Plugin::Build::Make" => "0.01",
    "ExtUtils::MakeMaker" => "6.52"
  },
  "DISTNAME" => "Alien-libuv",
  "LICENSE" => "perl",
  "NAME" => "Alien::libuv",
  "PREREQ_PM" => {
    "Alien::Base" => "1.00",
    "base" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.52",
    "File::Spec" => 0,
    "Test2::Suite" => 0,
    "Test2::V0" => 0,
    "Test::Alien" => 0,
    "Test::More" => "0.88"
  },
  "VERSION" => "1.008",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Alien::Base" => "1.00",
  "Alien::Build" => "1.00",
  "Alien::Build::MM" => "0.32",
  "Alien::Build::Plugin::Build::Make" => 0,
  "Config" => 0,
  "ExtUtils::MakeMaker" => "6.52",
  "File::Spec" => 0,
  "IPC::Cmd" => 0,
  "Test2::Suite" => 0,
  "Test2::V0" => 0,
  "Test::Alien" => 0,
  "Test::More" => "0.88",
  "base" => 0,
  "strict" => 0,
  "warnings" => 0
);

# BEGIN code inserted by Dist::Zilla::Plugin::AlienBuild
use Alien::Build::MM;
my $abmm = Alien::Build::MM->new;
%WriteMakefileArgs = $abmm->mm_args(%WriteMakefileArgs);
# END code inserted by Dist::Zilla::Plugin::AlienBuild

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

if ( $^O !~ /win/i ) {
	$WriteMakefileArgs{PREREQ_PM}{'Alien::Autotools'} = $FallbackPrereqs{'Alien::Autotools'} = '1.00';
	$WriteMakefileArgs{PREREQ_PM}{'Alien::Build::Plugin::Build::Autoconf'} = $FallbackPrereqs{'Alien::Build::Plugin::Build::Autoconf'} = '0.04';
}

if ( $^O eq 'MSWin32' ) {
	$WriteMakefileArgs{PREREQ_PM}{'Alien::Build::Plugin::Build::CMake'} = $FallbackPrereqs{'Alien::Build::Plugin::Build::CMake'} = '0';
	$WriteMakefileArgs{PREREQ_PM}{'Alien::cmake3'} = $FallbackPrereqs{'Alien::cmake3'} = '0.04';
}

WriteMakefile(%WriteMakefileArgs);

# BEGIN code inserted by Dist::Zilla::Plugin::AlienBuild
sub MY::postamble {
  $abmm->mm_postamble;
}
# END code inserted by Dist::Zilla::Plugin::AlienBuild
