#!/usr/local/bin/perl -w 
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl access.t'  
##################### We start with some black magic to print on failure.    
use strict;
use warnings;

use Test::More tests => 12;

BEGIN {use_ok 'UMLS::Interface'}
BEGIN{ use_ok ('File::Spec') }
BEGIN{ use_ok ('File::Path') }                                    

#  initialize option hash
my %option_hash = ();

#  set the option hash
$option_hash{"realtime"} = 1;
#$option_hash{"debug"} = 1;

#  connect to the UMLS-Interface
my $umls = UMLS::Interface->new(\%option_hash);
ok($umls);

my ($errCode, $errString) = $umls->getError();
ok(!($errCode));

#  get the version of umls that is being used
my $version = $umls->version();

#  check that no errors occured while obtaining the version
($errCode, $errString) = $umls->getError();
ok(!($errCode));

#  set the key directory (create it if it doesn't exist)
my $keydir = File::Spec->catfile('t','key', $version);
if(! (-e $keydir) ) {
    mkpath($keydir);
}

#  get the tests
my $testdir = File::Spec->catdir('t','tests');
opendir(DIR, $testdir) || die "Could not open directory $testdir\n";
my @testfiles = grep { $_ ne '.' and $_ ne '..' and $_ ne "CVS"} readdir DIR;

my $perl     = $^X;
my $util_prg = File::Spec->catfile('utils', 'umls-similarity.pl');

my $measure = "lch";

foreach my $file (@testfiles) {
    
    my $configfile = "config.$file";		      
    my $keyfile = "$measure.$file";
    
    my $infile  = File::Spec->catfile('t','tests', $file);
    my $config  = File::Spec->catfile('t','config', $configfile);
    my $key     = File::Spec->catfile('t', 'key', $version, $keyfile);
    
    my $output = `$perl $util_prg --config $config --realtime --measure $measure --infile $infile 2>&1`;
    
    if(-e $key) {
	ok (open KEY, $key) or diag "Could not open $key: $!";
	my $key = "";
	while(<KEY>) { $key .= $_; } close KEY;
	cmp_ok($output, 'eq', $key);
    }
    else {
	ok(open KEY, ">$key") || diag "Could not open $key: $!";
	print KEY $output;
	close KEY; 
      SKIP: {
	  skip ("Generating key, no need to run test", 1);
	}
    }
}

