#!perl

use strict;
use warnings;

use Test::More tests => 39;
use CPAN::WWW::Testers;

my $obj = CPAN::WWW::Testers->new();
isa_ok($obj,'CPAN::WWW::Testers');

# constants
is( CPAN::WWW::Testers::RSS_LIMIT_RECENT, 200, 'RSS_LIMIT_RECENT' );
is( CPAN::WWW::Testers::RSS_LIMIT_AUTHOR, 100, 'RSS_LIMIT_AUTHOR' );

# test the attributes generated by Class::Accessor::Chained::Fast
foreach my $k ( qw/
	directory
	database
	config
	updates
	tt
	ttjs
	authors
	osnames
	perls
/ ){
  my $label = "[$k]";
  SKIP: {
    ok( $obj->can($k), "$label can" )
	or skip "'$k' attribute missing", 3;
    is( $obj->$k(), undef, "$label default" );
    is( $obj->$k(123), $obj, "$label set" ); # chained, so returns object, not value.
    is( $obj->$k, 123, "$label get" );
  };
}

# TODO -- test these:
#	$EXCEPTIONS
#	%OSNAMES
#	$MAX_ID;
#	$UPDATE_ID = 0;

