use Evo::Base -strict;
use Evo::Util;
use Test::More tests => 9;
use Test::Fatal;

# wantarray
my $fired = 0;
my @res = Evo::Util::_guard_on_die { $fired++ }
sub { is wantarray, 1, 'list'; (1, 2) };
is_deeply \@res, [1, 2], 'right result';

my $res = Evo::Util::_guard_on_die { $fired++ }
sub { ok defined wantarray, 'scalar'; 'val' };
is $res, 'val', 'right result';

Evo::Util::_guard_on_die { $fired++ } sub { ok !defined wantarray, 'void' };

# die
my $die = sub { die "Foo" };

like exception {
  Evo::Util::_guard_on_die { $fired++; } $die;
}, qr/Foo/, 'right exception raised';
is $fired, 1, 'was fired';

$fired = 0;
like exception {
  Evo::Util::_guard_on_die { $fired++; die "New" } $die;
}, qr/New/, 'new exception';
is $fired, 1, 'was fired';
