package Evo::Train;
use Evo::Base 'Railway::Train';
use Evo::Manager;

#sub dispatch($self) {
#  $self->power(1);
#  do { $self->depart; $self->run } unless $self->is_current;    #nb
#}

# always current train
sub is_current($self) {
  return unless $self->manager->check_current('train');
  $self->manager->current('train') == $self;
}

sub asap($self, @stations) {
  $self->way->add($_) for @stations;
  $self->start unless $self->is_current;
}

1;

# ABSTRACT: A train, running engine

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Train - A train, running engine

=head1 VERSION

version 0.011

=head1 SYNOPSIS

  use Evo::Manager;
  my $mngr  = Evo::Manager->new;
  my $train = $mngr->build_train;

  our $foo = 'Non blocking';

  # will print Non blocking
  $train->asap(
    sub {
      local $foo = 'Blocking';
      $train->asap(sub { say $foo });
    }
  );

=head1 DESCRIPTION

This is a subclass of L<Railway::Train>

=head1 METHODS

=head2 is_current

  my $bool = $self->is_current;

Returns true if we are in this train, false otherwise

=head2 asap

  our $N = 0;

  # will print '0' three times
  $train->asap(
    sub {
      say $N;

      local $N = 1;
      $train->asap(
        sub {
          say $N;

          local $N = 2;
          $train->asap(sub { say $N});
        }
      );

    }
  );

Execute a code in the next tick, if we are in the running train, or run train
immidiately and execute this code blocking

This means that a station will be added to the L<Evo::Way> instance and
executed immidiately if we are in the 0 cicle loop, or just after others,
if we are in the 1 cicle.

So it's impossible to be caged in the recursion with more than 2 invocations
depth

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
