#!perl -T
# -*-cperl-*-
#
# 01-process.t - Test a Bitcoin Payment
# Copyright (c) 2016 Ashish Gulhati <biz-btc at ashish dot neomailbox.com>

use Test::More tests => 7;
use Business::Bitcoin;

$ENV{PATH} = '';

ok (my $bizbtc = new Business::Bitcoin (XPUB => 'xpub661MyMwAqRbcFj1ham6uPgPHQxywTCKsdBy8KfQPV7HRzK3NTXujzskBNA8SxNATivZ3iu64WwdsSwMJmQY7tMBxuieRtz86cqwW84NmSUY',
					DB => '/tmp/bizbtc.db', Create => 1, Clobber => 1), 'Business::Bitcoin object created');

# Check that ku from pycoin is available

ok (-e $bizbtc->kucmd, 'ku command available');

# Using an address with a known amount for testing.

my $req = $bizbtc->request(Amount => 4200, Confirmations => 0, Reference => 0);
ok($req->address eq '1HU8TWVbKbPZEQtiU3Z3jTc3tT7nitJmG4', 'Request created');

# Verify payment at 0 confirmations

ok($req->verify(), 'Payment verified at 0 confirmations');

# Try again with 5 confirmations required

$req->confirmations(5);
ok($req->verify(), 'Payment verified at 5 confirmations');

# Find and load a request by Address

my $req2 = $bizbtc->findreq(Address => $req->address);
ok($req2->created == $req->created, 'Find a request by Address');

# Find and load a request by Reference ID

my $req3 = $bizbtc->findreq(Reference => $req->reference);
ok($req3->address eq $req->address, 'Find a request by Reference ID');
