#============================================================= -*-Perl-*-
#
# Template::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Andy Wardley   <abw@kfs.org>
#
# COPYRIGHT
#   Copyright (C) 1996-2000 Andy Wardley.  All Rights Reserved.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#------------------------------------------------------------------------
#
# NOTE: this module is constructed from the parser/Grammar.pm.skel
# file by running the parser/yc script.  You only need to do this if 
# you have modified the grammar in the parser/Parser.yp file and need
# to-recompile it.  See the README in the 'parser' directory for more
# information (sub-directory of the Template distribution).
#
#------------------------------------------------------------------------
#
# $Id: Grammar.pm,v 2.2 2000/09/12 15:25:19 abw Exp $
#
#========================================================================

package Template::Grammar;

require 5.004;

use strict;
use vars qw( $VERSION );

$VERSION  = sprintf("%d.%02d", q$Revision: 2.2 $ =~ /(\d+)\.(\d+)/);

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================
# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE PLUGIN FILTER MACRO PERL RAWPERL TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META
	TRY THROW CATCH FINAL BREAK RETURN STOP CLEAR
    );

%CMPOP = qw( != ne  == eq  < <  > >  >= >=  <= <= );


#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @cmpop  = keys %CMPOP;
    my @binop  = qw( + - * % );              # '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			"\"" => 44,
			'BLOCK' => 43,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			"[" => 52,
			'DEFAULT' => 51,
			"{" => 17,
			'THROW' => 56,
			'CALL' => 55,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 29,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'loop' => 54,
			'defblock' => 53,
			'capture' => 18,
			'template' => 41,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 1
		DEFAULT => -93
	},
	{#State 2
		DEFAULT => -101
	},
	{#State 3
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 71,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 4
		DEFAULT => -23
	},
	{#State 5
		ACTIONS => {
			";" => -19
		},
		DEFAULT => -26
	},
	{#State 6
		DEFAULT => -72,
		GOTOS => {
			'@3-1' => 73
		}
	},
	{#State 7
		ACTIONS => {
			'IDENT' => 74
		}
	},
	{#State 8
		ACTIONS => {
			'NUMBER' => 75,
			"\"" => 80,
			'FILENAME' => 77,
			'LITERAL' => 81,
			'IDENT' => 79,
			"\$" => 76
		},
		GOTOS => {
			'nameargs' => 83,
			'filename' => 78,
			'filepart' => 82
		}
	},
	{#State 9
		ACTIONS => {
			'DOT' => 84,
			'ASSIGN' => 85
		},
		DEFAULT => -97
	},
	{#State 10
		DEFAULT => -14
	},
	{#State 11
		DEFAULT => -6
	},
	{#State 12
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 50,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 87,
			'assign' => 88,
			'item' => 24,
			'ident' => 86,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 13
		DEFAULT => -20
	},
	{#State 14
		DEFAULT => -12
	},
	{#State 15
		ACTIONS => {
			";" => 89
		}
	},
	{#State 16
		ACTIONS => {
			'IDENT' => 91
		},
		GOTOS => {
			'meta' => 92,
			'metadata' => 90
		}
	},
	{#State 17
		ACTIONS => {
			'LITERAL' => 95,
			'IDENT' => 94
		},
		DEFAULT => -107,
		GOTOS => {
			'param' => 97,
			'params' => 93,
			'hash' => 96
		}
	},
	{#State 18
		DEFAULT => -11
	},
	{#State 19
		ACTIONS => {
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			";" => -15,
			'AND' => 101,
			'DIV' => 104,
			'CMPOP' => 102,
			"/" => 105,
			"?" => 99
		},
		DEFAULT => -25
	},
	{#State 20
		DEFAULT => -92
	},
	{#State 21
		ACTIONS => {
			'NUMBER' => 75,
			"\"" => 80,
			'FILENAME' => 77,
			'LITERAL' => 81,
			'IDENT' => 79,
			"\$" => 76
		},
		GOTOS => {
			'nameargs' => 106,
			'filename' => 78,
			'filepart' => 82
		}
	},
	{#State 22
		ACTIONS => {
			"\${" => 48,
			'LITERAL' => 109,
			'IDENT' => 27,
			"\$" => 7
		},
		GOTOS => {
			'assign' => 67,
			'setlist' => 108,
			'item' => 24,
			'ident' => 107,
			'node' => 57
		}
	},
	{#State 23
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 110,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 24
		ACTIONS => {
			"(" => 111
		},
		DEFAULT => -116
	},
	{#State 25
		ACTIONS => {
			'COMMA' => 112,
			"\${" => 48,
			'LITERAL' => 109,
			'IDENT' => 27,
			"\$" => 7
		},
		DEFAULT => -18,
		GOTOS => {
			'assign' => 113,
			'item' => 24,
			'ident' => 107,
			'node' => 57
		}
	},
	{#State 26
		DEFAULT => -5
	},
	{#State 27
		DEFAULT => -118
	},
	{#State 28
		ACTIONS => {
			";" => 114
		}
	},
	{#State 29
		DEFAULT => -1
	},
	{#State 30
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 115,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 31
		ACTIONS => {
			"\${" => 48,
			'IDENT' => 27,
			"\$" => 7
		},
		GOTOS => {
			'item' => 24,
			'ident' => 116,
			'node' => 57
		}
	},
	{#State 32
		ACTIONS => {
			'IDENT' => 117
		}
	},
	{#State 33
		ACTIONS => {
			'NUMBER' => 75,
			"\"" => 80,
			'FILENAME' => 77,
			'LITERAL' => 81,
			'IDENT' => 79,
			"\$" => 76
		},
		GOTOS => {
			'nameargs' => 118,
			'filename' => 78,
			'filepart' => 82
		}
	},
	{#State 34
		ACTIONS => {
			'NUMBER' => 75,
			"\"" => 80,
			'FILENAME' => 77,
			'LITERAL' => 81,
			'IDENT' => 79,
			"\$" => 76
		},
		GOTOS => {
			'nameargs' => 119,
			'filename' => 78,
			'filepart' => 82
		}
	},
	{#State 35
		DEFAULT => -8
	},
	{#State 36
		ACTIONS => {
			'NUMBER' => 75,
			"\"" => 124,
			"\${" => 48,
			'FILENAME' => 77,
			'LITERAL' => 125,
			'IDENT' => 122,
			"\$" => 120
		},
		GOTOS => {
			'lvalue' => 126,
			'lnameargs' => 123,
			'nameargs' => 127,
			'item' => 121,
			'filename' => 78,
			'filepart' => 82
		}
	},
	{#State 37
		DEFAULT => -35
	},
	{#State 38
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 128,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 39
		DEFAULT => -40
	},
	{#State 40
		DEFAULT => -38
	},
	{#State 41
		ACTIONS => {
			'' => 129
		}
	},
	{#State 42
		ACTIONS => {
			";" => 130
		}
	},
	{#State 43
		ACTIONS => {
			'NUMBER' => 75,
			'FILENAME' => 77,
			";" => 131,
			'IDENT' => 79
		},
		GOTOS => {
			'filename' => 132,
			'filepart' => 82
		}
	},
	{#State 44
		DEFAULT => -158,
		GOTOS => {
			'quoted' => 133
		}
	},
	{#State 45
		DEFAULT => -21
	},
	{#State 46
		ACTIONS => {
			'NUMBER' => 75,
			"\"" => 124,
			"\${" => 48,
			'FILENAME' => 77,
			'LITERAL' => 125,
			'IDENT' => 122,
			"\$" => 120
		},
		GOTOS => {
			'lvalue' => 126,
			'lnameargs' => 134,
			'nameargs' => 127,
			'item' => 121,
			'filename' => 78,
			'filepart' => 82
		}
	},
	{#State 47
		DEFAULT => -10
	},
	{#State 48
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			"\${" => 48,
			'REF' => 31,
			'LITERAL' => 72,
			'IDENT' => 27,
			"\$" => 7
		},
		GOTOS => {
			'sterm' => 135,
			'item' => 24,
			'ident' => 70,
			'node' => 57
		}
	},
	{#State 49
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -2,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 136,
			'atomdir' => 5,
			'switch' => 45,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 50
		ACTIONS => {
			'ASSIGN' => 137
		},
		DEFAULT => -100
	},
	{#State 51
		ACTIONS => {
			"\${" => 48,
			'LITERAL' => 109,
			'IDENT' => 27,
			"\$" => 7
		},
		GOTOS => {
			'assign' => 67,
			'setlist' => 138,
			'item' => 24,
			'ident' => 107,
			'node' => 57
		}
	},
	{#State 52
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48
		},
		GOTOS => {
			'sterm' => 139,
			'list' => 140,
			'range' => 141,
			'item' => 24,
			'ident' => 70,
			'term' => 142,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 53
		DEFAULT => -9
	},
	{#State 54
		DEFAULT => -22
	},
	{#State 55
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 143,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 56
		ACTIONS => {
			'NUMBER' => 75,
			"\"" => 80,
			'FILENAME' => 77,
			'LITERAL' => 81,
			'IDENT' => 79,
			"\$" => 76
		},
		GOTOS => {
			'nameargs' => 144,
			'filename' => 78,
			'filepart' => 82
		}
	},
	{#State 57
		DEFAULT => -115
	},
	{#State 58
		DEFAULT => -36
	},
	{#State 59
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 145,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 24,
			'ident' => 70,
			'term' => 147,
			'lterm' => 20,
			'loopvar' => 146,
			'node' => 57
		}
	},
	{#State 60
		DEFAULT => -24
	},
	{#State 61
		DEFAULT => -37
	},
	{#State 62
		DEFAULT => -41
	},
	{#State 63
		DEFAULT => -13
	},
	{#State 64
		DEFAULT => -39
	},
	{#State 65
		ACTIONS => {
			'FOR' => 152,
			'UNLESS' => 148,
			'IF' => 153,
			'WHILE' => 150,
			'FILTER' => 151,
			'WRAPPER' => 149
		}
	},
	{#State 66
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 154,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 67
		DEFAULT => -135
	},
	{#State 68
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 155,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 69
		DEFAULT => -132
	},
	{#State 70
		ACTIONS => {
			'DOT' => 84
		},
		DEFAULT => -97
	},
	{#State 71
		ACTIONS => {
			'CMPOP' => 102,
			'MOD' => 98,
			'BINOP' => 100,
			'DIV' => 104,
			"/" => 105
		},
		DEFAULT => -128
	},
	{#State 72
		DEFAULT => -100
	},
	{#State 73
		ACTIONS => {
			";" => 156
		}
	},
	{#State 74
		DEFAULT => -120
	},
	{#State 75
		DEFAULT => -156
	},
	{#State 76
		ACTIONS => {
			"\${" => 48,
			'IDENT' => 27,
			"\$" => 7
		},
		GOTOS => {
			'item' => 24,
			'ident' => 157,
			'node' => 57
		}
	},
	{#State 77
		DEFAULT => -154
	},
	{#State 78
		ACTIONS => {
			'DOT' => 160,
			"(" => 159
		},
		DEFAULT => -141,
		GOTOS => {
			'args' => 158
		}
	},
	{#State 79
		DEFAULT => -155
	},
	{#State 80
		DEFAULT => -158,
		GOTOS => {
			'quoted' => 161
		}
	},
	{#State 81
		DEFAULT => -141,
		GOTOS => {
			'args' => 162
		}
	},
	{#State 82
		DEFAULT => -153
	},
	{#State 83
		DEFAULT => -33
	},
	{#State 84
		ACTIONS => {
			'NUMBER' => 163,
			"\${" => 48,
			'IDENT' => 27,
			"\$" => 7
		},
		GOTOS => {
			'item' => 24,
			'node' => 164
		}
	},
	{#State 85
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 168,
			"\"" => 44,
			'NOT' => 3,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			"(" => 12,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		GOTOS => {
			'directive' => 167,
			'sterm' => 1,
			'mdir' => 165,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'atomdir' => 5,
			'wrapper' => 39,
			'switch' => 45,
			'atomexpr' => 65,
			'loop' => 54,
			'expr' => 166,
			'assign' => 67,
			'perl' => 60,
			'ident' => 86,
			'term' => 69,
			'filter' => 62,
			'lterm' => 20,
			'node' => 57,
			'condition' => 13
		}
	},
	{#State 86
		ACTIONS => {
			'DOT' => 84,
			'ASSIGN' => 169
		},
		DEFAULT => -97
	},
	{#State 87
		ACTIONS => {
			'MOD' => 98,
			")" => 170,
			'BINOP' => 100,
			'OR' => 103,
			'AND' => 101,
			'DIV' => 104,
			'CMPOP' => 102,
			"/" => 105,
			"?" => 99
		}
	},
	{#State 88
		ACTIONS => {
			")" => 171
		}
	},
	{#State 89
		DEFAULT => -7
	},
	{#State 90
		ACTIONS => {
			'COMMA' => 172,
			'IDENT' => 91
		},
		DEFAULT => -16,
		GOTOS => {
			'meta' => 173
		}
	},
	{#State 91
		ACTIONS => {
			'ASSIGN' => 174
		}
	},
	{#State 92
		DEFAULT => -88
	},
	{#State 93
		ACTIONS => {
			'COMMA' => 175,
			'LITERAL' => 95,
			'IDENT' => 94
		},
		DEFAULT => -106,
		GOTOS => {
			'param' => 176
		}
	},
	{#State 94
		ACTIONS => {
			'ASSIGN' => 177
		}
	},
	{#State 95
		ACTIONS => {
			'ASSIGN' => 178
		}
	},
	{#State 96
		ACTIONS => {
			"}" => 179
		}
	},
	{#State 97
		DEFAULT => -110
	},
	{#State 98
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 180,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 99
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 181,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 100
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 182,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 101
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 183,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 102
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 184,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 103
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 185,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 104
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 186,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 105
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 187,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 106
		DEFAULT => -31
	},
	{#State 107
		ACTIONS => {
			'DOT' => 84,
			'ASSIGN' => 169
		}
	},
	{#State 108
		ACTIONS => {
			'LITERAL' => 109,
			'IDENT' => 27,
			"\$" => 7,
			'COMMA' => 112,
			"\${" => 48
		},
		DEFAULT => -29,
		GOTOS => {
			'assign' => 113,
			'item' => 24,
			'ident' => 107,
			'node' => 57
		}
	},
	{#State 109
		ACTIONS => {
			'ASSIGN' => 137
		}
	},
	{#State 110
		ACTIONS => {
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			";" => 188,
			'AND' => 101,
			'DIV' => 104,
			'CMPOP' => 102,
			"/" => 105,
			"?" => 99
		}
	},
	{#State 111
		DEFAULT => -141,
		GOTOS => {
			'args' => 189
		}
	},
	{#State 112
		DEFAULT => -134
	},
	{#State 113
		DEFAULT => -133
	},
	{#State 114
		DEFAULT => -70,
		GOTOS => {
			'@2-2' => 190
		}
	},
	{#State 115
		ACTIONS => {
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			";" => 191,
			'AND' => 101,
			'DIV' => 104,
			'CMPOP' => 102,
			"/" => 105,
			"?" => 99
		}
	},
	{#State 116
		ACTIONS => {
			'DOT' => 84
		},
		DEFAULT => -98
	},
	{#State 117
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 168,
			"\"" => 44,
			'NOT' => 3,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			"(" => 192,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		GOTOS => {
			'directive' => 167,
			'sterm' => 1,
			'mdir' => 193,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'atomdir' => 5,
			'wrapper' => 39,
			'switch' => 45,
			'atomexpr' => 65,
			'loop' => 54,
			'expr' => 194,
			'assign' => 67,
			'perl' => 60,
			'ident' => 86,
			'term' => 69,
			'filter' => 62,
			'lterm' => 20,
			'node' => 57,
			'condition' => 13
		}
	},
	{#State 118
		DEFAULT => -32
	},
	{#State 119
		ACTIONS => {
			";" => 195
		}
	},
	{#State 120
		ACTIONS => {
			"\${" => 48,
			'IDENT' => 196,
			"\$" => 7
		},
		GOTOS => {
			'item' => 24,
			'ident' => 157,
			'node' => 57
		}
	},
	{#State 121
		DEFAULT => -144
	},
	{#State 122
		ACTIONS => {
			'ASSIGN' => -118
		},
		DEFAULT => -155
	},
	{#State 123
		DEFAULT => -69
	},
	{#State 124
		DEFAULT => -158,
		GOTOS => {
			'quoted' => 197
		}
	},
	{#State 125
		ACTIONS => {
			'ASSIGN' => -146
		},
		DEFAULT => -141,
		GOTOS => {
			'args' => 162
		}
	},
	{#State 126
		ACTIONS => {
			'ASSIGN' => 198
		}
	},
	{#State 127
		DEFAULT => -143
	},
	{#State 128
		ACTIONS => {
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			";" => 199,
			'AND' => 101,
			'DIV' => 104,
			'CMPOP' => 102,
			"/" => 105,
			"?" => 99
		}
	},
	{#State 129
		DEFAULT => -0
	},
	{#State 130
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 200,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 131
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 201,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 132
		ACTIONS => {
			'DOT' => 160,
			";" => 202
		}
	},
	{#State 133
		ACTIONS => {
			"\"" => 206,
			"\${" => 48,
			'TEXT' => 204,
			";" => 205,
			'IDENT' => 27,
			"\$" => 7
		},
		GOTOS => {
			'quotable' => 207,
			'item' => 24,
			'ident' => 203,
			'node' => 57
		}
	},
	{#State 134
		ACTIONS => {
			";" => 208
		}
	},
	{#State 135
		ACTIONS => {
			"}" => 209
		}
	},
	{#State 136
		DEFAULT => -4
	},
	{#State 137
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 210,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 138
		ACTIONS => {
			'LITERAL' => 109,
			'IDENT' => 27,
			"\$" => 7,
			'COMMA' => 112,
			"\${" => 48
		},
		DEFAULT => -30,
		GOTOS => {
			'assign' => 113,
			'item' => 24,
			'ident' => 107,
			'node' => 57
		}
	},
	{#State 139
		ACTIONS => {
			'TO' => 211
		},
		DEFAULT => -93
	},
	{#State 140
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			'COMMA' => 213,
			"{" => 17,
			"]" => 212,
			'REF' => 31,
			"\${" => 48
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 24,
			'ident' => 70,
			'term' => 214,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 141
		ACTIONS => {
			"]" => 215
		}
	},
	{#State 142
		DEFAULT => -104
	},
	{#State 143
		ACTIONS => {
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			'AND' => 101,
			'DIV' => 104,
			'CMPOP' => 102,
			"/" => 105,
			"?" => 99
		},
		DEFAULT => -28
	},
	{#State 144
		DEFAULT => -34
	},
	{#State 145
		ACTIONS => {
			'ASSIGN' => 216
		},
		DEFAULT => -118
	},
	{#State 146
		ACTIONS => {
			";" => 217
		}
	},
	{#State 147
		DEFAULT => -141,
		GOTOS => {
			'args' => 218
		}
	},
	{#State 148
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 219,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 149
		ACTIONS => {
			'NUMBER' => 75,
			"\"" => 80,
			'FILENAME' => 77,
			'LITERAL' => 81,
			'IDENT' => 79,
			"\$" => 76
		},
		GOTOS => {
			'nameargs' => 220,
			'filename' => 78,
			'filepart' => 82
		}
	},
	{#State 150
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 221,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 151
		ACTIONS => {
			'NUMBER' => 75,
			"\"" => 124,
			"\${" => 48,
			'FILENAME' => 77,
			'LITERAL' => 125,
			'IDENT' => 122,
			"\$" => 120
		},
		GOTOS => {
			'lvalue' => 126,
			'lnameargs' => 222,
			'nameargs' => 127,
			'item' => 121,
			'filename' => 78,
			'filepart' => 82
		}
	},
	{#State 152
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 145,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 24,
			'ident' => 70,
			'term' => 147,
			'lterm' => 20,
			'loopvar' => 223,
			'node' => 57
		}
	},
	{#State 153
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 224,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 154
		ACTIONS => {
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			'AND' => 101,
			'DIV' => 104,
			'CMPOP' => 102,
			"/" => 105,
			"?" => 99
		},
		DEFAULT => -27
	},
	{#State 155
		ACTIONS => {
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			";" => 225,
			'AND' => 101,
			'DIV' => 104,
			'CMPOP' => 102,
			"/" => 105,
			"?" => 99
		}
	},
	{#State 156
		ACTIONS => {
			'TEXT' => 226
		}
	},
	{#State 157
		ACTIONS => {
			'DOT' => 84
		},
		DEFAULT => -141,
		GOTOS => {
			'args' => 227
		}
	},
	{#State 158
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'IDENT' => 228,
			"\$" => 7,
			'REF' => 31,
			"\${" => 48,
			'LITERAL' => 229,
			"[" => 52,
			"{" => 17,
			'COMMA' => 230
		},
		DEFAULT => -151,
		GOTOS => {
			'sterm' => 1,
			'param' => 231,
			'item' => 24,
			'ident' => 70,
			'term' => 232,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 159
		DEFAULT => -141,
		GOTOS => {
			'args' => 233
		}
	},
	{#State 160
		ACTIONS => {
			'NUMBER' => 75,
			'FILENAME' => 77,
			'IDENT' => 79
		},
		GOTOS => {
			'filepart' => 234
		}
	},
	{#State 161
		ACTIONS => {
			"\"" => 235,
			"\${" => 48,
			'TEXT' => 204,
			";" => 205,
			'IDENT' => 27,
			"\$" => 7
		},
		GOTOS => {
			'quotable' => 207,
			'item' => 24,
			'ident' => 203,
			'node' => 57
		}
	},
	{#State 162
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'IDENT' => 228,
			"\$" => 7,
			'REF' => 31,
			"\${" => 48,
			'LITERAL' => 229,
			"[" => 52,
			"{" => 17,
			'COMMA' => 230
		},
		DEFAULT => -149,
		GOTOS => {
			'sterm' => 1,
			'param' => 231,
			'item' => 24,
			'ident' => 70,
			'term' => 232,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 163
		DEFAULT => -114
	},
	{#State 164
		DEFAULT => -113
	},
	{#State 165
		DEFAULT => -78
	},
	{#State 166
		ACTIONS => {
			'IDENT' => -136,
			"\$" => -136,
			'AND' => 101,
			"\${" => -136,
			'CMPOP' => 102,
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			";" => -136,
			'LITERAL' => -136,
			'COMMA' => -136,
			'DIV' => 104,
			"/" => 105,
			"?" => 99
		},
		DEFAULT => -25
	},
	{#State 167
		DEFAULT => -81
	},
	{#State 168
		ACTIONS => {
			";" => 236
		}
	},
	{#State 169
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 237,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 170
		DEFAULT => -131
	},
	{#State 171
		DEFAULT => -130
	},
	{#State 172
		DEFAULT => -87
	},
	{#State 173
		DEFAULT => -86
	},
	{#State 174
		ACTIONS => {
			'NUMBER' => 238,
			"\"" => 239,
			'LITERAL' => 240
		}
	},
	{#State 175
		DEFAULT => -109
	},
	{#State 176
		DEFAULT => -108
	},
	{#State 177
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 24,
			'ident' => 70,
			'term' => 241,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 178
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 24,
			'ident' => 70,
			'term' => 242,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 179
		DEFAULT => -96
	},
	{#State 180
		DEFAULT => -124
	},
	{#State 181
		ACTIONS => {
			'MOD' => 98,
			'AND' => 101,
			'BINOP' => 100,
			'DIV' => 104,
			":" => 243,
			'CMPOP' => 102,
			"/" => 105,
			'OR' => 103,
			"?" => 99
		}
	},
	{#State 182
		ACTIONS => {
			'MOD' => 98,
			'DIV' => 104,
			"/" => 105
		},
		DEFAULT => -121
	},
	{#State 183
		ACTIONS => {
			'CMPOP' => 102,
			'MOD' => 98,
			'BINOP' => 100,
			'DIV' => 104,
			"/" => 105
		},
		DEFAULT => -126
	},
	{#State 184
		ACTIONS => {
			'MOD' => 98,
			'BINOP' => 100,
			'DIV' => 104,
			"/" => 105
		},
		DEFAULT => -125
	},
	{#State 185
		ACTIONS => {
			'CMPOP' => 102,
			'MOD' => 98,
			'BINOP' => 100,
			'DIV' => 104,
			"/" => 105
		},
		DEFAULT => -127
	},
	{#State 186
		ACTIONS => {
			'MOD' => 98
		},
		DEFAULT => -123
	},
	{#State 187
		ACTIONS => {
			'MOD' => 98,
			'DIV' => 104
		},
		DEFAULT => -122
	},
	{#State 188
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 244,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 189
		ACTIONS => {
			")" => 245,
			'NUMBER' => 2,
			"\"" => 44,
			'LITERAL' => 229,
			"[" => 52,
			'IDENT' => 228,
			"\$" => 7,
			'COMMA' => 230,
			"{" => 17,
			'REF' => 31,
			"\${" => 48
		},
		GOTOS => {
			'sterm' => 1,
			'param' => 231,
			'item' => 24,
			'ident' => 70,
			'term' => 232,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 190
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 246,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 191
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 247,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 192
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 50,
			"[" => 52,
			'IDENT' => 248,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 87,
			'assign' => 88,
			'margs' => 249,
			'item' => 24,
			'ident' => 86,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 193
		DEFAULT => -80
	},
	{#State 194
		ACTIONS => {
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			'AND' => 101,
			'DIV' => 104,
			'CMPOP' => 102,
			"/" => 105,
			"?" => 99
		},
		DEFAULT => -25
	},
	{#State 195
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 250,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 196
		ACTIONS => {
			'ASSIGN' => -120
		},
		DEFAULT => -118
	},
	{#State 197
		ACTIONS => {
			"\"" => 251,
			"\${" => 48,
			'TEXT' => 204,
			";" => 205,
			'IDENT' => 27,
			"\$" => 7
		},
		GOTOS => {
			'quotable' => 207,
			'item' => 24,
			'ident' => 203,
			'node' => 57
		}
	},
	{#State 198
		ACTIONS => {
			'NUMBER' => 75,
			"\"" => 80,
			'FILENAME' => 77,
			'LITERAL' => 81,
			'IDENT' => 79,
			"\$" => 76
		},
		GOTOS => {
			'nameargs' => 252,
			'filename' => 78,
			'filepart' => 82
		}
	},
	{#State 199
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 253,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 200
		ACTIONS => {
			'CATCH' => 254,
			'FINAL' => 256
		},
		DEFAULT => -68,
		GOTOS => {
			'final' => 255
		}
	},
	{#State 201
		ACTIONS => {
			'END' => 257
		}
	},
	{#State 202
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 29,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'template' => 258,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 203
		ACTIONS => {
			'DOT' => 84
		},
		DEFAULT => -159
	},
	{#State 204
		DEFAULT => -160
	},
	{#State 205
		DEFAULT => -161
	},
	{#State 206
		DEFAULT => -99
	},
	{#State 207
		DEFAULT => -157
	},
	{#State 208
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 259,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 209
		DEFAULT => -119
	},
	{#State 210
		ACTIONS => {
			'AND' => 101,
			'CMPOP' => 102,
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			'DIV' => 104,
			"/" => 105,
			"?" => 99
		},
		DEFAULT => -137
	},
	{#State 211
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			"\${" => 48,
			'REF' => 31,
			'LITERAL' => 72,
			'IDENT' => 27,
			"\$" => 7
		},
		GOTOS => {
			'sterm' => 260,
			'item' => 24,
			'ident' => 70,
			'node' => 57
		}
	},
	{#State 212
		DEFAULT => -94
	},
	{#State 213
		DEFAULT => -103
	},
	{#State 214
		DEFAULT => -102
	},
	{#State 215
		DEFAULT => -95
	},
	{#State 216
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 24,
			'ident' => 70,
			'term' => 261,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 217
		DEFAULT => -54,
		GOTOS => {
			'@1-3' => 262
		}
	},
	{#State 218
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'LITERAL' => 229,
			"[" => 52,
			'IDENT' => 228,
			"\$" => 7,
			'COMMA' => 230,
			"{" => 17,
			'REF' => 31,
			"\${" => 48
		},
		DEFAULT => -60,
		GOTOS => {
			'sterm' => 1,
			'param' => 231,
			'item' => 24,
			'ident' => 70,
			'term' => 232,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 219
		ACTIONS => {
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			'AND' => 101,
			'DIV' => 104,
			'CMPOP' => 102,
			"/" => 105,
			"?" => 99
		},
		DEFAULT => -45
	},
	{#State 220
		DEFAULT => -62
	},
	{#State 221
		ACTIONS => {
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			'AND' => 101,
			'DIV' => 104,
			'CMPOP' => 102,
			"/" => 105,
			"?" => 99
		},
		DEFAULT => -58
	},
	{#State 222
		DEFAULT => -75
	},
	{#State 223
		DEFAULT => -56
	},
	{#State 224
		ACTIONS => {
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			'AND' => 101,
			'DIV' => 104,
			'CMPOP' => 102,
			"/" => 105,
			"?" => 99
		},
		DEFAULT => -43
	},
	{#State 225
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 263,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 226
		ACTIONS => {
			'END' => 264
		}
	},
	{#State 227
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'IDENT' => 228,
			"\$" => 7,
			'REF' => 31,
			"\${" => 48,
			'LITERAL' => 229,
			"[" => 52,
			"{" => 17,
			'COMMA' => 230
		},
		DEFAULT => -147,
		GOTOS => {
			'sterm' => 1,
			'param' => 231,
			'item' => 24,
			'ident' => 70,
			'term' => 232,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 228
		ACTIONS => {
			'ASSIGN' => 177
		},
		DEFAULT => -118
	},
	{#State 229
		ACTIONS => {
			'ASSIGN' => 178
		},
		DEFAULT => -100
	},
	{#State 230
		DEFAULT => -140
	},
	{#State 231
		DEFAULT => -139
	},
	{#State 232
		DEFAULT => -138
	},
	{#State 233
		ACTIONS => {
			")" => 265,
			'NUMBER' => 2,
			"\"" => 44,
			'LITERAL' => 229,
			"[" => 52,
			'IDENT' => 228,
			"\$" => 7,
			'COMMA' => 230,
			"{" => 17,
			'REF' => 31,
			"\${" => 48
		},
		GOTOS => {
			'sterm' => 1,
			'param' => 231,
			'item' => 24,
			'ident' => 70,
			'term' => 232,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 234
		DEFAULT => -152
	},
	{#State 235
		DEFAULT => -141,
		GOTOS => {
			'args' => 266
		}
	},
	{#State 236
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 267,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 237
		ACTIONS => {
			'AND' => 101,
			'CMPOP' => 102,
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			'DIV' => 104,
			"/" => 105,
			"?" => 99
		},
		DEFAULT => -136
	},
	{#State 238
		DEFAULT => -91
	},
	{#State 239
		ACTIONS => {
			'TEXT' => 268
		}
	},
	{#State 240
		DEFAULT => -89
	},
	{#State 241
		DEFAULT => -112
	},
	{#State 242
		DEFAULT => -111
	},
	{#State 243
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 269,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 244
		ACTIONS => {
			'CASE' => 271
		},
		DEFAULT => -53,
		GOTOS => {
			'case' => 270
		}
	},
	{#State 245
		DEFAULT => -117
	},
	{#State 246
		ACTIONS => {
			'END' => 272
		}
	},
	{#State 247
		ACTIONS => {
			'ELSE' => 273,
			'ELSIF' => 275
		},
		DEFAULT => -48,
		GOTOS => {
			'else' => 274
		}
	},
	{#State 248
		ACTIONS => {
			")" => -85,
			'IDENT' => -85,
			'COMMA' => -85
		},
		DEFAULT => -118
	},
	{#State 249
		ACTIONS => {
			'COMMA' => 278,
			")" => 277,
			'IDENT' => 276
		}
	},
	{#State 250
		ACTIONS => {
			'END' => 279
		}
	},
	{#State 251
		ACTIONS => {
			'ASSIGN' => -145
		},
		DEFAULT => -141,
		GOTOS => {
			'args' => 266
		}
	},
	{#State 252
		DEFAULT => -142
	},
	{#State 253
		ACTIONS => {
			'END' => 280
		}
	},
	{#State 254
		ACTIONS => {
			'NUMBER' => 75,
			'FILENAME' => 77,
			";" => 281,
			'DEFAULT' => 283,
			'IDENT' => 79
		},
		GOTOS => {
			'filename' => 282,
			'filepart' => 82
		}
	},
	{#State 255
		ACTIONS => {
			'END' => 284
		}
	},
	{#State 256
		ACTIONS => {
			";" => 285
		}
	},
	{#State 257
		DEFAULT => -77
	},
	{#State 258
		ACTIONS => {
			'END' => 286
		}
	},
	{#State 259
		ACTIONS => {
			'END' => 287
		}
	},
	{#State 260
		DEFAULT => -105
	},
	{#State 261
		DEFAULT => -141,
		GOTOS => {
			'args' => 288
		}
	},
	{#State 262
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 289,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 263
		ACTIONS => {
			'ELSE' => 273,
			'ELSIF' => 275
		},
		DEFAULT => -48,
		GOTOS => {
			'else' => 290
		}
	},
	{#State 264
		DEFAULT => -73
	},
	{#State 265
		DEFAULT => -150
	},
	{#State 266
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'IDENT' => 228,
			"\$" => 7,
			'REF' => 31,
			"\${" => 48,
			'LITERAL' => 229,
			"[" => 52,
			"{" => 17,
			'COMMA' => 230
		},
		DEFAULT => -148,
		GOTOS => {
			'sterm' => 1,
			'param' => 231,
			'item' => 24,
			'ident' => 70,
			'term' => 232,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 267
		ACTIONS => {
			'END' => 291
		}
	},
	{#State 268
		ACTIONS => {
			"\"" => 292
		}
	},
	{#State 269
		ACTIONS => {
			'AND' => 101,
			'CMPOP' => 102,
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			'DIV' => 104,
			"/" => 105,
			"?" => 99
		},
		DEFAULT => -129
	},
	{#State 270
		ACTIONS => {
			'END' => 293
		}
	},
	{#State 271
		ACTIONS => {
			"{" => 17,
			'NUMBER' => 2,
			"\"" => 44,
			"\${" => 48,
			'REF' => 31,
			'LITERAL' => 72,
			";" => 294,
			'DEFAULT' => 295,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7
		},
		GOTOS => {
			'sterm' => 1,
			'item' => 24,
			'ident' => 70,
			'term' => 296,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 272
		DEFAULT => -71
	},
	{#State 273
		ACTIONS => {
			";" => 297
		}
	},
	{#State 274
		ACTIONS => {
			'END' => 298
		}
	},
	{#State 275
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'NOT' => 3,
			'LITERAL' => 72,
			"[" => 52,
			'IDENT' => 27,
			"\$" => 7,
			"{" => 17,
			'REF' => 31,
			"\${" => 48,
			"(" => 12
		},
		GOTOS => {
			'sterm' => 1,
			'expr' => 299,
			'item' => 24,
			'ident' => 70,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 276
		DEFAULT => -83
	},
	{#State 277
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 168,
			"\"" => 44,
			'NOT' => 3,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			"(" => 12,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		GOTOS => {
			'directive' => 167,
			'sterm' => 1,
			'mdir' => 300,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'atomdir' => 5,
			'wrapper' => 39,
			'switch' => 45,
			'atomexpr' => 65,
			'loop' => 54,
			'expr' => 194,
			'assign' => 67,
			'perl' => 60,
			'ident' => 86,
			'term' => 69,
			'filter' => 62,
			'lterm' => 20,
			'node' => 57,
			'condition' => 13
		}
	},
	{#State 278
		DEFAULT => -84
	},
	{#State 279
		DEFAULT => -61
	},
	{#State 280
		DEFAULT => -57
	},
	{#State 281
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 301,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 282
		ACTIONS => {
			'DOT' => 160,
			";" => 302
		}
	},
	{#State 283
		ACTIONS => {
			";" => 303
		}
	},
	{#State 284
		DEFAULT => -63
	},
	{#State 285
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 304,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 286
		DEFAULT => -76
	},
	{#State 287
		DEFAULT => -74
	},
	{#State 288
		ACTIONS => {
			'NUMBER' => 2,
			"\"" => 44,
			'LITERAL' => 229,
			"[" => 52,
			'IDENT' => 228,
			"\$" => 7,
			'COMMA' => 230,
			"{" => 17,
			'REF' => 31,
			"\${" => 48
		},
		DEFAULT => -59,
		GOTOS => {
			'sterm' => 1,
			'param' => 231,
			'item' => 24,
			'ident' => 70,
			'term' => 232,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 289
		ACTIONS => {
			'END' => 305
		}
	},
	{#State 290
		ACTIONS => {
			'END' => 306
		}
	},
	{#State 291
		DEFAULT => -82
	},
	{#State 292
		DEFAULT => -90
	},
	{#State 293
		DEFAULT => -49
	},
	{#State 294
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 307,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 295
		ACTIONS => {
			";" => 308
		}
	},
	{#State 296
		ACTIONS => {
			";" => 309
		}
	},
	{#State 297
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 310,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 298
		DEFAULT => -44
	},
	{#State 299
		ACTIONS => {
			'MOD' => 98,
			'BINOP' => 100,
			'OR' => 103,
			";" => 311,
			'AND' => 101,
			'DIV' => 104,
			'CMPOP' => 102,
			"/" => 105,
			"?" => 99
		}
	},
	{#State 300
		DEFAULT => -79
	},
	{#State 301
		ACTIONS => {
			'CATCH' => 254,
			'FINAL' => 256
		},
		DEFAULT => -68,
		GOTOS => {
			'final' => 312
		}
	},
	{#State 302
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 313,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 303
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 314,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 304
		DEFAULT => -67
	},
	{#State 305
		DEFAULT => -55
	},
	{#State 306
		DEFAULT => -42
	},
	{#State 307
		DEFAULT => -52
	},
	{#State 308
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 315,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 309
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 316,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 310
		DEFAULT => -47
	},
	{#State 311
		ACTIONS => {
			'TRY' => 42,
			'NUMBER' => 2,
			'BLOCK' => 43,
			"\"" => 44,
			'NOT' => 3,
			'RAWPERL' => 6,
			'FILTER' => 46,
			"\$" => 7,
			'PROCESS' => 8,
			"\${" => 48,
			'TEXT' => 11,
			"(" => 12,
			'META' => 16,
			";" => -17,
			'LITERAL' => 50,
			'DEFAULT' => 51,
			"[" => 52,
			"{" => 17,
			'CALL' => 55,
			'THROW' => 56,
			'INSERT' => 21,
			'SET' => 22,
			'STOP' => 58,
			'SWITCH' => 23,
			'IDENT' => 27,
			'PERL' => 28,
			'FOR' => 59,
			'UNLESS' => 30,
			'REF' => 31,
			'MACRO' => 32,
			'CLEAR' => 61,
			'INCLUDE' => 33,
			'WRAPPER' => 34,
			'USE' => 36,
			'NEXT' => 64,
			'RETURN' => 37,
			'WHILE' => 38,
			'BREAK' => 40,
			'GET' => 66,
			'IF' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 1,
			'try' => 4,
			'setlist' => 25,
			'item' => 24,
			'chunk' => 26,
			'atomdir' => 5,
			'switch' => 45,
			'block' => 317,
			'anonblock' => 47,
			'perl' => 60,
			'ident' => 9,
			'filter' => 62,
			'rawperl' => 10,
			'condition' => 13,
			'directive' => 35,
			'macro' => 14,
			'use' => 63,
			'statement' => 15,
			'chunks' => 49,
			'wrapper' => 39,
			'atomexpr' => 65,
			'defblock' => 53,
			'loop' => 54,
			'capture' => 18,
			'expr' => 19,
			'assign' => 67,
			'term' => 69,
			'lterm' => 20,
			'node' => 57
		}
	},
	{#State 312
		DEFAULT => -66
	},
	{#State 313
		ACTIONS => {
			'CATCH' => 254,
			'FINAL' => 256
		},
		DEFAULT => -68,
		GOTOS => {
			'final' => 318
		}
	},
	{#State 314
		ACTIONS => {
			'CATCH' => 254,
			'FINAL' => 256
		},
		DEFAULT => -68,
		GOTOS => {
			'final' => 319
		}
	},
	{#State 315
		DEFAULT => -51
	},
	{#State 316
		ACTIONS => {
			'CASE' => 271
		},
		DEFAULT => -53,
		GOTOS => {
			'case' => 320
		}
	},
	{#State 317
		ACTIONS => {
			'ELSE' => 273,
			'ELSIF' => 275
		},
		DEFAULT => -48,
		GOTOS => {
			'else' => 321
		}
	},
	{#State 318
		DEFAULT => -64
	},
	{#State 319
		DEFAULT => -65
	},
	{#State 320
		DEFAULT => -50
	},
	{#State 321
		DEFAULT => -46
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 58 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 61 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 62 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 65 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
					if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 67 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 70 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2, undef
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1,
sub
#line 82 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 16
		 'statement', 2,
sub
#line 83 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 17
		 'statement', 0, undef
	],
	[#Rule 18
		 'directive', 1,
sub
#line 87 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 19
		 'directive', 1, undef
	],
	[#Rule 20
		 'directive', 1, undef
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'atomexpr', 1,
sub
#line 101 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 26
		 'atomexpr', 1, undef
	],
	[#Rule 27
		 'atomdir', 2,
sub
#line 105 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 28
		 'atomdir', 2,
sub
#line 106 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 29
		 'atomdir', 2,
sub
#line 107 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 108 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 109 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 110 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 111 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 112 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 35
		 'atomdir', 1,
sub
#line 113 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 36
		 'atomdir', 1,
sub
#line 114 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 37
		 'atomdir', 1,
sub
#line 115 "Parser.yp"
{ "\$output = '';";                   }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 116 "Parser.yp"
{ 'last;'                             }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 117 "Parser.yp"
{ $_[0]->{ INFOR }
					? $factory->next()
				        : 'next;'                         }
	],
	[#Rule 40
		 'atomdir', 1, undef
	],
	[#Rule 41
		 'atomdir', 1, undef
	],
	[#Rule 42
		 'condition', 6,
sub
#line 125 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 43
		 'condition', 3,
sub
#line 126 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 44
		 'condition', 6,
sub
#line 128 "Parser.yp"
{ $factory->if("!($_[2])", @_[4, 5])  }
	],
	[#Rule 45
		 'condition', 3,
sub
#line 129 "Parser.yp"
{ $factory->if("!($_[3])", $_[1])     }
	],
	[#Rule 46
		 'else', 5,
sub
#line 133 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
				      $_[5];                              }
	],
	[#Rule 47
		 'else', 3,
sub
#line 135 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 48
		 'else', 0,
sub
#line 136 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 49
		 'switch', 6,
sub
#line 140 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 50
		 'case', 5,
sub
#line 144 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
				      $_[5];                              }
	],
	[#Rule 51
		 'case', 4,
sub
#line 146 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 52
		 'case', 3,
sub
#line 147 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 53
		 'case', 0,
sub
#line 148 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 54
		 '@1-3', 0,
sub
#line 151 "Parser.yp"
{ $_[0]->{ INFOR }++                  }
	],
	[#Rule 55
		 'loop', 6,
sub
#line 152 "Parser.yp"
{ $_[0]->{ INFOR }--;
				      $factory->foreach(@{$_[2]}, $_[5])  }
	],
	[#Rule 56
		 'loop', 3,
sub
#line 156 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 57
		 'loop', 5,
sub
#line 158 "Parser.yp"
{ $factory->while(@_[2, 4])           }
	],
	[#Rule 58
		 'loop', 3,
sub
#line 159 "Parser.yp"
{ $factory->while(@_[3, 1])           }
	],
	[#Rule 59
		 'loopvar', 4,
sub
#line 162 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 60
		 'loopvar', 2,
sub
#line 163 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 61
		 'wrapper', 5,
sub
#line 167 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 62
		 'wrapper', 3,
sub
#line 169 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 63
		 'try', 5,
sub
#line 173 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 64
		 'final', 5,
sub
#line 177 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
				      $_[5];                              }
	],
	[#Rule 65
		 'final', 5,
sub
#line 180 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
				      $_[4];                              }
	],
	[#Rule 66
		 'final', 4,
sub
#line 183 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
				      $_[4];                              }
	],
	[#Rule 67
		 'final', 3,
sub
#line 185 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 68
		 'final', 0,
sub
#line 186 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 69
		 'use', 2,
sub
#line 189 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 70
		 '@2-2', 0,
sub
#line 192 "Parser.yp"
{ ${$_[0]->{ INPERL }}++;             }
	],
	[#Rule 71
		 'perl', 5,
sub
#line 193 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
				      $_[0]->{ EVAL_PERL } 
				      ? $factory->perl($_[4])             
				      : $factory->no_perl();              }
	],
	[#Rule 72
		 '@3-1', 0,
sub
#line 199 "Parser.yp"
{ ${$_[0]->{ INPERL }}++; 
				      $rawstart = ${$_[0]->{'LINE'}};     }
	],
	[#Rule 73
		 'rawperl', 5,
sub
#line 201 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
				      $_[0]->{ EVAL_PERL } 
				      ? $factory->rawperl($_[4], $rawstart)
				      : $factory->no_perl();              }
	],
	[#Rule 74
		 'filter', 5,
sub
#line 208 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 75
		 'filter', 3,
sub
#line 210 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 76
		 'defblock', 5,
sub
#line 214 "Parser.yp"
{ $_[0]->define_block(@_[2, 4]); 
				      undef                               }
	],
	[#Rule 77
		 'anonblock', 4,
sub
#line 218 "Parser.yp"
{ $factory->anon_block($_[3])         }
	],
	[#Rule 78
		 'capture', 3,
sub
#line 221 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 79
		 'macro', 6,
sub
#line 225 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 80
		 'macro', 3,
sub
#line 226 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 81
		 'mdir', 1, undef
	],
	[#Rule 82
		 'mdir', 4,
sub
#line 230 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 83
		 'margs', 2,
sub
#line 233 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 84
		 'margs', 2,
sub
#line 234 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 85
		 'margs', 1,
sub
#line 235 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 86
		 'metadata', 2,
sub
#line 238 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 87
		 'metadata', 2, undef
	],
	[#Rule 88
		 'metadata', 1, undef
	],
	[#Rule 89
		 'meta', 3,
sub
#line 243 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$// }; 
					 [ @_[1,3] ] }
	],
	[#Rule 90
		 'meta', 5,
sub
#line 245 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 91
		 'meta', 3,
sub
#line 246 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 92
		 'term', 1, undef
	],
	[#Rule 93
		 'term', 1, undef
	],
	[#Rule 94
		 'lterm', 3,
sub
#line 258 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 95
		 'lterm', 3,
sub
#line 259 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 96
		 'lterm', 3,
sub
#line 260 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 97
		 'sterm', 1,
sub
#line 263 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 98
		 'sterm', 2,
sub
#line 264 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 99
		 'sterm', 3,
sub
#line 265 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 100
		 'sterm', 1, undef
	],
	[#Rule 101
		 'sterm', 1, undef
	],
	[#Rule 102
		 'list', 2,
sub
#line 270 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 103
		 'list', 2, undef
	],
	[#Rule 104
		 'list', 1, undef
	],
	[#Rule 105
		 'range', 3,
sub
#line 275 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 106
		 'hash', 1, undef
	],
	[#Rule 107
		 'hash', 0, undef
	],
	[#Rule 108
		 'params', 2,
sub
#line 283 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 109
		 'params', 2, undef
	],
	[#Rule 110
		 'params', 1, undef
	],
	[#Rule 111
		 'param', 3,
sub
#line 288 "Parser.yp"
{ "$_[1] => $_[3]"                    }
	],
	[#Rule 112
		 'param', 3,
sub
#line 289 "Parser.yp"
{ "'$_[1]' => $_[3]"                  }
	],
	[#Rule 113
		 'ident', 3,
sub
#line 292 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 114
		 'ident', 3,
sub
#line 293 "Parser.yp"
{ push(@{$_[1]}, $_[3], 0); $_[1]     }
	],
	[#Rule 115
		 'ident', 1, undef
	],
	[#Rule 116
		 'node', 1,
sub
#line 297 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 117
		 'node', 4,
sub
#line 298 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 118
		 'item', 1,
sub
#line 301 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 119
		 'item', 3,
sub
#line 302 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 120
		 'item', 2,
sub
#line 303 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
				       ? "'$_[2]'" 
				       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 121
		 'expr', 3,
sub
#line 308 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 122
		 'expr', 3,
sub
#line 309 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 123
		 'expr', 3,
sub
#line 310 "Parser.yp"
{ "int($_[1] / $_[3])"                }
	],
	[#Rule 124
		 'expr', 3,
sub
#line 311 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 125
		 'expr', 3,
sub
#line 312 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 126
		 'expr', 3,
sub
#line 313 "Parser.yp"
{ "($_[1]) && ($_[3])"                }
	],
	[#Rule 127
		 'expr', 3,
sub
#line 314 "Parser.yp"
{ "($_[1]) || ($_[3])"                }
	],
	[#Rule 128
		 'expr', 2,
sub
#line 315 "Parser.yp"
{ "!($_[2])"                          }
	],
	[#Rule 129
		 'expr', 5,
sub
#line 316 "Parser.yp"
{ "(($_[1]) ? ($_[3]) : ($_[5]))"     }
	],
	[#Rule 130
		 'expr', 3,
sub
#line 317 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 131
		 'expr', 3,
sub
#line 318 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 132
		 'expr', 1, undef
	],
	[#Rule 133
		 'setlist', 2,
sub
#line 322 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 134
		 'setlist', 2, undef
	],
	[#Rule 135
		 'setlist', 1, undef
	],
	[#Rule 136
		 'assign', 3,
sub
#line 328 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 137
		 'assign', 3,
sub
#line 329 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 138
		 'args', 2,
sub
#line 336 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 139
		 'args', 2,
sub
#line 337 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 140
		 'args', 2,
sub
#line 338 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 141
		 'args', 0,
sub
#line 339 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 142
		 'lnameargs', 3,
sub
#line 349 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 143
		 'lnameargs', 1, undef
	],
	[#Rule 144
		 'lvalue', 1, undef
	],
	[#Rule 145
		 'lvalue', 3,
sub
#line 354 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 146
		 'lvalue', 1, undef
	],
	[#Rule 147
		 'nameargs', 3,
sub
#line 358 "Parser.yp"
{ [ $factory->ident($_[2]), $_[3] ]   }
	],
	[#Rule 148
		 'nameargs', 4,
sub
#line 359 "Parser.yp"
{ [ $factory->quoted($_[2]), $_[4] ]  }
	],
	[#Rule 149
		 'nameargs', 2,
sub
#line 360 "Parser.yp"
{ [   $_[1],   $_[2] ]                }
	],
	[#Rule 150
		 'nameargs', 4,
sub
#line 361 "Parser.yp"
{ [ "'$_[1]'", $_[3] ]                }
	],
	[#Rule 151
		 'nameargs', 2,
sub
#line 362 "Parser.yp"
{ [ "'$_[1]'", $_[2] ]                }
	],
	[#Rule 152
		 'filename', 3,
sub
#line 365 "Parser.yp"
{ "$_[1].$_[3]"                       }
	],
	[#Rule 153
		 'filename', 1, undef
	],
	[#Rule 154
		 'filepart', 1, undef
	],
	[#Rule 155
		 'filepart', 1, undef
	],
	[#Rule 156
		 'filepart', 1, undef
	],
	[#Rule 157
		 'quoted', 2,
sub
#line 379 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
				          if defined $_[2]; $_[1]         }
	],
	[#Rule 158
		 'quoted', 0,
sub
#line 381 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 159
		 'quotable', 1,
sub
#line 384 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 160
		 'quotable', 1,
sub
#line 385 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 161
		 'quotable', 1,
sub
#line 386 "Parser.yp"
{ undef                               }
	]
];



1;












