package Locales::DB::Territory::ksf;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::ksf::VERSION = '0.09';

$Locales::DB::Territory::ksf::cldr_version = '2.0';

%Locales::DB::Territory::ksf::code_to_name = (
    '001' => 'World',
    '002' => 'Africa',
    '003' => "North\ America",
    '005' => "South\ America",
    '009' => 'Oceania',
    '011' => "Western\ Africa",
    '013' => "Central\ America",
    '014' => "Eastern\ Africa",
    '015' => "Northern\ Africa",
    '017' => "Middle\ Africa",
    '018' => "Southern\ Africa",
    '019' => 'Americas',
    '021' => "Northern\ America",
    '029' => 'Caribbean',
    '030' => "Eastern\ Asia",
    '034' => "Southern\ Asia",
    '035' => "South\-Eastern\ Asia",
    '039' => "Southern\ Europe",
    '053' => "Australia\ and\ New\ Zealand",
    '054' => 'Melanesia',
    '057' => "Micronesian\ Region",
    '061' => 'Polynesia',
    '062' => "South\-Central\ Asia",
    142   => 'Asia',
    143   => "Central\ Asia",
    145   => "Western\ Asia",
    150   => 'Europe',
    151   => "Eastern\ Europe",
    154   => "Northern\ Europe",
    155   => "Western\ Europe",
    172   => "Commonwealth\ of\ Independent\ States",
    200   => 'Czechoslovakia',
    419   => "Latin\ America",
    830   => "Channel\ Islands",
    'ac'  => "Ascension\ Island",
    'ad'  => 'andɔrǝ',
    'ae'  => "bǝlɔŋ\ bǝ\ kaksa\ bɛ\ táatáaŋzǝn",
    'af'  => 'afganistáŋ',
    'ag'  => "antiga\ ri\ barbúda",
    'ai'  => 'angiya',
    'al'  => 'albaní',
    'am'  => 'armɛní',
    'an'  => "antíyǝ\ nɛlandé",
    'ao'  => 'angóla',
    'aq'  => 'Antarctica',
    'ar'  => 'arjǝntín',
    'as'  => "samɔa\ a\ amɛrika",
    'at'  => 'otric',
    'au'  => 'ɔstralí',
    'aw'  => 'aruba',
    'ax'  => "\Ã\land\ Islands",
    'az'  => 'azabecán',
    'ba'  => "bɔsnyɛ\ ri\ hɛrsǝgɔvín",
    'bb'  => 'baabaadǝ',
    'bd'  => 'baŋladɛ́c',
    'be'  => 'bɛljík',
    'bf'  => "bukína\ fǝ́\ asɔ",
    'bg'  => 'bulgarí',
    'bh'  => 'barǝ́n',
    'bi'  => 'burundí',
    'bj'  => 'bɛnǝ́n',
    'bl'  => "Saint\ Barth\Ã\©lemy",
    'bm'  => 'bɛɛmúdǝ',
    'bn'  => 'brunǝ́',
    'bo'  => 'bɔɔlíví',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'brɛsíl',
    'bs'  => 'baamás',
    'bt'  => 'bután',
    'bv'  => "Bouvet\ Island",
    'bw'  => 'botswana',
    'by'  => 'bɛlaris',
    'bz'  => 'bɛliz',
    'ca'  => 'kanada',
    'cc'  => "Cocos\ \[Keeling\]\ Islands",
    'cd'  => "kɔngó\ anyɔ́n",
    'cf'  => 'santrafrík',
    'cg'  => 'kɔngó',
    'ch'  => 'swís',
    'ci'  => 'kɔtiwuár',
    'ck'  => "zɛ\ i\ kúk",
    'cl'  => 'cíli',
    'cm'  => 'kamɛrún',
    'cn'  => 'cín',
    'co'  => 'kolɔmbí',
    'cp'  => "Clipperton\ Island",
    'cr'  => 'kɔstaríka',
    'cs'  => "sɛrbí\ ri\ mɔntǝnɛgro",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'kuba',
    'cv'  => 'kapvɛr',
    'cx'  => "Christmas\ Island",
    'cy'  => 'cíprɛ',
    'cz'  => 'cɛ́k',
    'dd'  => "East\ Germany",
    'de'  => 'djɛrman',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'dyibutí',
    'dk'  => 'danmak',
    'dm'  => 'dɔminik',
    'do'  => "dɔminik\ rɛpublík",
    'dz'  => 'aljɛrí',
    'ea'  => "Ceuta\ and\ Melilla",
    'ec'  => 'ɛkwatɛǝ́',
    'ee'  => 'ɛstoní',
    'eg'  => 'ɛjípt',
    'eh'  => "Western\ Sahara",
    'er'  => 'ɛritrɛ́',
    'es'  => 'kpanyá',
    'et'  => 'ɛtyɔpí',
    'eu'  => "European\ Union",
    'fi'  => 'fínlan',
    'fj'  => 'fíji',
    'fk'  => "zǝ\ maalwín",
    'fm'  => 'mikronɛ́si',
    'fo'  => "Faroe\ Islands",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'pɛrɛsǝ́',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'gabɔŋ',
    'gb'  => "kǝlɔŋ\ kǝ\ kǝtáatáaŋzǝn",
    'gd'  => 'grɛnadǝ',
    'ge'  => 'jɔrjí',
    'gf'  => "guyán\ i\ pɛrɛsǝ́",
    'gg'  => 'Guernsey',
    'gh'  => 'gána',
    'gi'  => 'jibraltá',
    'gl'  => 'grínlan',
    'gm'  => 'gambí',
    'gn'  => 'ginɛ́',
    'gp'  => 'gwadɛlúp',
    'gq'  => "ginɛ́\ ɛkwatɔrial",
    'gr'  => 'grɛ́k',
    'gs'  => "South\ Georgia\ and\ the\ South\ Sandwich\ Islands",
    'gt'  => 'gwátǝmala',
    'gu'  => 'gwám',
    'gw'  => "ginɛ́\ bisɔ́",
    'gy'  => 'guyán',
    'hk'  => "Hong\ Kong",
    'hm'  => "Heard\ Island\ and\ McDonald\ Islands",
    'hn'  => 'ɔnduras',
    'hr'  => 'krwasí',
    'ht'  => 'ayiti',
    'hu'  => 'ɔngrí',
    'ic'  => "Canary\ Islands",
    'id'  => 'indonɛsí',
    'ie'  => 'ilán',
    'il'  => 'israɛ́l',
    'im'  => "Isle\ of\ Man",
    'in'  => 'indí',
    'io'  => "zǝ\ ingɛrís\ ncɔ́m\ wa\ indi",
    'iq'  => 'irák',
    'ir'  => 'iráŋ',
    'is'  => "zǝ\ i\ glás",
    'it'  => 'italí',
    'je'  => 'Jersey',
    'jm'  => 'jamaík',
    'jo'  => 'jɔrdán',
    'jp'  => 'japɔ́ŋ',
    'jt'  => "Johnston\ Island",
    'ke'  => 'kɛnya',
    'kg'  => 'kigistáŋ',
    'kh'  => 'kambodj',
    'ki'  => 'kiribáti',
    'km'  => 'komɔr',
    'kn'  => "sɛnkrǝstɔ́f\ ri\ nyɛ́vǝ",
    'kp'  => 'korɛanɔ́r',
    'kr'  => 'korɛasud',
    'kw'  => 'kuwɛit',
    'ky'  => "zǝ\ i\ gan",
    'kz'  => 'kazakstáŋ',
    'la'  => 'laɔs',
    'lb'  => 'libáŋ',
    'lc'  => 'sɛntlísí',
    'li'  => 'lictɛnstɛ́n',
    'lk'  => 'srílaŋka',
    'lr'  => 'libɛrya',
    'ls'  => 'lǝsóto',
    'lt'  => 'litwaní',
    'lu'  => 'luksɛmbúr',
    'lv'  => 'lɛtoní',
    'ly'  => 'libí',
    'ma'  => 'marɔk',
    'mc'  => 'monako',
    'md'  => 'mɔldaví',
    'me'  => 'Montenegro',
    'mf'  => "Saint\ Martin",
    'mg'  => 'madagaska',
    'mh'  => "zǝ\ i\ marcál",
    'mi'  => "Midway\ Islands",
    'mk'  => 'másǝdwán',
    'ml'  => 'mali',
    'mm'  => 'myanmár',
    'mn'  => 'mɔŋolí',
    'mo'  => 'Macau',
    'mp'  => "zǝ\ maryánnɔ́r",
    'mq'  => 'matiník',
    'mr'  => 'mwaritaní',
    'ms'  => 'mɔnsɛrat',
    'mt'  => 'maltǝ',
    'mu'  => 'mwarís',
    'mv'  => 'maldivǝ',
    'mw'  => 'malawi',
    'mx'  => 'mɛksík',
    'my'  => 'malɛsí',
    'mz'  => 'mosambík',
    'na'  => 'namibí',
    'nc'  => "kalɛdoní\ anyɔ́n",
    'ne'  => 'nijɛ́r',
    'nf'  => "zɛ\ nɔ́fɔlk",
    'ng'  => 'nijɛ́rya',
    'ni'  => 'níkarágwa',
    'nl'  => "kǝlɔŋ\ kǝ\ ázǝ",
    'no'  => 'nɔrvɛjǝ',
    'np'  => 'nɛpal',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'nwarú',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'niwɛ́',
    'nz'  => "zɛlan\ anyɔ́n",
    'om'  => 'oman',
    'pa'  => 'panama',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'pɛrú',
    'pf'  => "pɔlinɛsí\ a\ pɛrɛsǝ́",
    'pg'  => "papwazí\ ginɛ́\ anyɔ́n",
    'ph'  => 'filipǝ́n',
    'pk'  => 'pakistáŋ',
    'pl'  => 'polɔ́n',
    'pm'  => "sɛnpyɛr\ ri\ mikɛlɔŋ",
    'pn'  => 'pitkɛ́n',
    'pr'  => 'pɔtoríko',
    'ps'  => "zǝ\ palɛstínǝ",
    'pt'  => 'portugál',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'palwa',
    'py'  => 'paragwɛ́',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'katá',
    'qo'  => "Outlying\ Oceania",
    're'  => 'rɛunyɔŋ',
    'ro'  => 'rɔmaní',
    'rs'  => 'Serbia',
    'ru'  => 'risí',
    'rw'  => 'rwanda',
    'sa'  => "arabí\ saodí",
    'sb'  => "zǝ\ salomɔ́n",
    'sc'  => 'sɛcɛl',
    'sd'  => 'sudan',
    'se'  => 'swɛdǝ',
    'sg'  => 'siŋapó',
    'sh'  => 'sɛntɛ́len',
    'si'  => 'slovɛní',
    'sj'  => "Svalbard\ and\ Jan\ Mayen",
    'sk'  => 'slovakí',
    'sl'  => 'syɛraleon',
    'sm'  => 'sɛnmarǝn',
    'sn'  => 'sɛnɛgal',
    'so'  => 'somalí',
    'sr'  => 'surinam',
    'st'  => "saotomɛ́\ ri\ priŋsib",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => 'salvadɔr',
    'sy'  => 'sirí',
    'sz'  => 'swazilan',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "zǝ\ tirk\ ri\ kakɔs",
    'td'  => 'caád',
    'tf'  => "French\ Southern\ Territories",
    'tg'  => 'togo',
    'th'  => 'tɛlan',
    'tj'  => 'tadjikistaŋ',
    'tk'  => 'tokǝlao',
    'tl'  => "timor\ anǝ\ á\ ɛst",
    'tm'  => 'tirkmɛnistaŋ',
    'tn'  => 'tunɛsí',
    'to'  => 'tɔŋa',
    'tr'  => 'tirkí',
    'tt'  => "tɛrinitɛ\ ri\ tobago",
    'tv'  => 'tuwalu',
    'tw'  => 'tɛwán',
    'tz'  => 'tanzaní',
    'ua'  => 'ukrain',
    'ug'  => 'uganda',
    'um'  => "U\.S\.\ Minor\ Outlying\ Islands",
    'us'  => 'amɛrika',
    'uy'  => 'urugwɛ́',
    'uz'  => 'usbɛkistaŋ',
    'va'  => 'watikáŋ',
    'vc'  => "sɛnvǝnsǝŋ\ ri\ grɛnadín",
    'vd'  => "North\ Vietnam",
    've'  => 'wɛnǝzwɛla',
    'vg'  => "zǝ\ bɛ\ gɔn\ inɛ\ a\ ingɛrís",
    'vi'  => "zǝ\ bɛ\ gɔn\ inɛ\ á\ amɛrika",
    'vn'  => 'wyɛtnám',
    'vu'  => 'wanwatu',
    'wf'  => "walis\ ri\ futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'samɔa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'yɛmɛn',
    'yt'  => 'mayɔ́t',
    'za'  => "afrik\ anǝ\ a\ sud",
    'zm'  => 'zambí',
    'zw'  => 'zimbabwɛ́',
    'zz'  => "Unknown\ Region",
);

%Locales::DB::Territory::ksf::name_to_code = (
    'afganistáŋ'                              => 'af',
    'africa'                                    => '002',
    'afrikanǝasud'                             => 'za',
    'albaní'                                   => 'al',
    'aljɛrí'                                  => 'dz',
    'americas'                                  => '019',
    'amɛrika'                                  => 'us',
    'andɔrǝ'                                  => 'ad',
    'angiya'                                    => 'ai',
    'angóla'                                   => 'ao',
    'antarctica'                                => 'aq',
    'antigaribarbúda'                          => 'ag',
    'antíyǝnɛlandé'                         => 'an',
    'arabísaodí'                              => 'sa',
    'arjǝntín'                                => 'ar',
    'armɛní'                                  => 'am',
    'aruba'                                     => 'aw',
    'ascensionisland'                           => 'ac',
    'asia'                                      => 142,
    'australiaandnewzealand'                    => '053',
    'ayiti'                                     => 'ht',
    'azabecán'                                 => 'az',
    'baabaadǝ'                                 => 'bb',
    'baamás'                                   => 'bs',
    'barǝ́n'                                  => 'bh',
    'baŋladɛ́c'                              => 'bd',
    'botswana'                                  => 'bw',
    'bouvetisland'                              => 'bv',
    'britishantarcticterritory'                 => 'bq',
    'brunǝ́'                                  => 'bn',
    'brɛsíl'                                  => 'br',
    'bukínafǝ́asɔ'                          => 'bf',
    'bulgarí'                                  => 'bg',
    'burundí'                                  => 'bi',
    'bután'                                    => 'bt',
    'bǝlɔŋbǝkaksabɛtáatáaŋzǝn'         => 'ae',
    'bɔsnyɛrihɛrsǝgɔvín'                  => 'ba',
    'bɔɔlíví'                               => 'bo',
    'bɛlaris'                                  => 'by',
    'bɛliz'                                    => 'bz',
    'bɛljík'                                  => 'be',
    'bɛnǝ́n'                                 => 'bj',
    'bɛɛmúdǝ'                               => 'bm',
    'canaryislands'                             => 'ic',
    'cantonandenderburyislands'                 => 'ct',
    'caribbean'                                 => '029',
    'caád'                                     => 'td',
    'centralamerica'                            => '013',
    'centralasia'                               => 143,
    'ceutaandmelilla'                           => 'ea',
    'channelislands'                            => 830,
    'christmasisland'                           => 'cx',
    'clippertonisland'                          => 'cp',
    'cocoskeelingislands'                       => 'cc',
    'commonwealthofindependentstates'           => 172,
    'czechoslovakia'                            => 200,
    'cíli'                                     => 'cl',
    'cín'                                      => 'cn',
    'cíprɛ'                                   => 'cy',
    'cɛ́k'                                    => 'cz',
    'danmak'                                    => 'dk',
    'diegogarcia'                               => 'dg',
    'djɛrman'                                  => 'de',
    'dronningmaudland'                          => 'nq',
    'dyibutí'                                  => 'dj',
    'dɔminik'                                  => 'dm',
    'dɔminikrɛpublík'                        => 'do',
    'easternafrica'                             => '014',
    'easternasia'                               => '030',
    'easterneurope'                             => 151,
    'eastgermany'                               => 'dd',
    'europe'                                    => 150,
    'europeanunion'                             => 'eu',
    'faroeislands'                              => 'fo',
    'filipǝ́n'                                => 'ph',
    'frenchsouthernandantarcticterritories'     => 'fq',
    'frenchsouthernterritories'                 => 'tf',
    'fíji'                                     => 'fj',
    'fínlan'                                   => 'fi',
    'gabɔŋ'                                   => 'ga',
    'gambí'                                    => 'gm',
    'ginɛ́'                                   => 'gn',
    'ginɛ́bisɔ́'                            => 'gw',
    'ginɛ́ɛkwatɔrial'                       => 'gq',
    'grínlan'                                  => 'gl',
    'grɛnadǝ'                                 => 'gd',
    'grɛ́k'                                   => 'gr',
    'guernsey'                                  => 'gg',
    'guyán'                                    => 'gy',
    'guyánipɛrɛsǝ́'                        => 'gf',
    'gwadɛlúp'                                => 'gp',
    'gwám'                                     => 'gu',
    'gwátǝmala'                               => 'gt',
    'gána'                                     => 'gh',
    'heardislandandmcdonaldislands'             => 'hm',
    'hongkong'                                  => 'hk',
    'ilán'                                     => 'ie',
    'indonɛsí'                                => 'id',
    'indí'                                     => 'in',
    'irák'                                     => 'iq',
    'iráŋ'                                    => 'ir',
    'isleofman'                                 => 'im',
    'israɛ́l'                                 => 'il',
    'italí'                                    => 'it',
    'jamaík'                                   => 'jm',
    'japɔ́ŋ'                                 => 'jp',
    'jersey'                                    => 'je',
    'jibraltá'                                 => 'gi',
    'johnstonisland'                            => 'jt',
    'jɔrdán'                                  => 'jo',
    'jɔrjí'                                   => 'ge',
    'kalɛdoníanyɔ́n'                        => 'nc',
    'kambodj'                                   => 'kh',
    'kamɛrún'                                 => 'cm',
    'kanada'                                    => 'ca',
    'kapvɛr'                                   => 'cv',
    'katá'                                     => 'qa',
    'kazakstáŋ'                               => 'kz',
    'kigistáŋ'                                => 'kg',
    'kiribáti'                                 => 'ki',
    'kolɔmbí'                                 => 'co',
    'komɔr'                                    => 'km',
    'korɛanɔ́r'                              => 'kp',
    'korɛasud'                                 => 'kr',
    'kpanyá'                                   => 'es',
    'krwasí'                                   => 'hr',
    'kuba'                                      => 'cu',
    'kuwɛit'                                   => 'kw',
    'kǝlɔŋkǝkǝtáatáaŋzǝn'              => 'gb',
    'kǝlɔŋkǝázǝ'                          => 'nl',
    'kɔngó'                                   => 'cg',
    'kɔngóanyɔ́n'                           => 'cd',
    'kɔstaríka'                               => 'cr',
    'kɔtiwuár'                                => 'ci',
    'kɛnya'                                    => 'ke',
    'latinamerica'                              => 419,
    'laɔs'                                     => 'la',
    'libáŋ'                                   => 'lb',
    'libí'                                     => 'ly',
    'libɛrya'                                  => 'lr',
    'lictɛnstɛ́n'                            => 'li',
    'litwaní'                                  => 'lt',
    'luksɛmbúr'                               => 'lu',
    'lǝsóto'                                  => 'ls',
    'lɛtoní'                                  => 'lv',
    'macau'                                     => 'mo',
    'madagaska'                                 => 'mg',
    'malawi'                                    => 'mw',
    'maldivǝ'                                  => 'mv',
    'mali'                                      => 'ml',
    'maltǝ'                                    => 'mt',
    'malɛsí'                                  => 'my',
    'marɔk'                                    => 'ma',
    'matiník'                                  => 'mq',
    'mayɔ́t'                                  => 'yt',
    'melanesia'                                 => '054',
    'metropolitanfrance'                        => 'fx',
    'micronesianregion'                         => '057',
    'middleafrica'                              => '017',
    'midwayislands'                             => 'mi',
    'mikronɛ́si'                              => 'fm',
    'monako'                                    => 'mc',
    'montenegro'                                => 'me',
    'mosambík'                                 => 'mz',
    'mwaritaní'                                => 'mr',
    'mwarís'                                   => 'mu',
    'myanmár'                                  => 'mm',
    'másǝdwán'                               => 'mk',
    'mɔldaví'                                 => 'md',
    'mɔnsɛrat'                                => 'ms',
    'mɔŋolí'                                 => 'mn',
    'mɛksík'                                  => 'mx',
    'namibí'                                   => 'na',
    'neutralzone'                               => 'nt',
    'nijɛ́r'                                  => 'ne',
    'nijɛ́rya'                                => 'ng',
    'niwɛ́'                                   => 'nu',
    'northamerica'                              => '003',
    'northernafrica'                            => '015',
    'northernamerica'                           => '021',
    'northerneurope'                            => 154,
    'northvietnam'                              => 'vd',
    'nwarú'                                    => 'nr',
    'níkarágwa'                               => 'ni',
    'nɔrvɛjǝ'                                => 'no',
    'nɛpal'                                    => 'np',
    'oceania'                                   => '009',
    'oman'                                      => 'om',
    'otric'                                     => 'at',
    'outlyingoceania'                           => 'qo',
    'pacificislandstrustterritory'              => 'pc',
    'pakistáŋ'                                => 'pk',
    'palwa'                                     => 'pw',
    'panama'                                    => 'pa',
    'panamacanalzone'                           => 'pz',
    'papwazíginɛ́anyɔ́n'                   => 'pg',
    'paragwɛ́'                                => 'py',
    "people\â\\sdemocraticrepublicofyemen" => 'yd',
    'pitkɛ́n'                                 => 'pn',
    'polynesia'                                 => '061',
    'polɔ́n'                                  => 'pl',
    'portugál'                                 => 'pt',
    'pɔlinɛsíapɛrɛsǝ́'                   => 'pf',
    'pɔtoríko'                                => 'pr',
    'pɛrú'                                    => 'pe',
    'pɛrɛsǝ́'                               => 'fr',
    'risí'                                     => 'ru',
    'rwanda'                                    => 'rw',
    'rɔmaní'                                  => 'ro',
    'rɛunyɔŋ'                                => 're',
    "saintbarth\Ã\©lemy"                      => 'bl',
    'saintmartin'                               => 'mf',
    'salvadɔr'                                 => 'sv',
    'samɔa'                                    => 'ws',
    'samɔaaamɛrika'                           => 'as',
    'santrafrík'                               => 'cf',
    'saotomɛ́ripriŋsib'                      => 'st',
    'serbia'                                    => 'rs',
    'sirí'                                     => 'sy',
    'siŋapó'                                  => 'sg',
    'slovakí'                                  => 'sk',
    'slovɛní'                                 => 'si',
    'somalí'                                   => 'so',
    'southamerica'                              => '005',
    'southcentralasia'                          => '062',
    'southeasternasia'                          => '035',
    'southernafrica'                            => '018',
    'southernasia'                              => '034',
    'southerneurope'                            => '039',
    'southgeorgiaandthesouthsandwichislands'    => 'gs',
    'srílaŋka'                                => 'lk',
    'sudan'                                     => 'sd',
    'surinam'                                   => 'sr',
    'svalbardandjanmayen'                       => 'sj',
    'swazilan'                                  => 'sz',
    'swís'                                     => 'ch',
    'swɛdǝ'                                   => 'se',
    'syɛraleon'                                => 'sl',
    'sɛcɛl'                                   => 'sc',
    'sɛnkrǝstɔ́frinyɛ́vǝ'                => 'kn',
    'sɛnmarǝn'                                => 'sm',
    'sɛnpyɛrrimikɛlɔŋ'                     => 'pm',
    'sɛntlísí'                               => 'lc',
    'sɛntɛ́len'                              => 'sh',
    'sɛnvǝnsǝŋrigrɛnadín'                 => 'vc',
    'sɛnɛgal'                                 => 'sn',
    'sɛrbírimɔntǝnɛgro'                    => 'cs',
    'tadjikistaŋ'                              => 'tj',
    'tanzaní'                                  => 'tz',
    'timoranǝáɛst'                           => 'tl',
    'tirkmɛnistaŋ'                            => 'tm',
    'tirkí'                                    => 'tr',
    'togo'                                      => 'tg',
    'tokǝlao'                                  => 'tk',
    'tristandacunha'                            => 'ta',
    'tunɛsí'                                  => 'tn',
    'tuwalu'                                    => 'tv',
    'tɔŋa'                                    => 'to',
    'tɛlan'                                    => 'th',
    'tɛrinitɛritobago'                        => 'tt',
    'tɛwán'                                   => 'tw',
    "u\.s\.minoroutlyingislands"                => 'um',
    "u\.s\.miscellaneouspacificislands"         => 'pu',
    'uganda'                                    => 'ug',
    'ukrain'                                    => 'ua',
    'unionofsovietsocialistrepublics'           => 'su',
    'unknownregion'                             => 'zz',
    'urugwɛ́'                                 => 'uy',
    'usbɛkistaŋ'                              => 'uz',
    'wakeisland'                                => 'wk',
    'walisrifutuna'                             => 'wf',
    'wanwatu'                                   => 'vu',
    'watikáŋ'                                 => 'va',
    'westernafrica'                             => '011',
    'westernasia'                               => 145,
    'westerneurope'                             => 155,
    'westernsahara'                             => 'eh',
    'world'                                     => '001',
    'wyɛtnám'                                 => 'vn',
    'wɛnǝzwɛla'                              => 've',
    'yɛmɛn'                                   => 'ye',
    'zambí'                                    => 'zm',
    'zimbabwɛ́'                               => 'zw',
    'zǝbɛgɔninɛaingɛrís'                  => 'vg',
    'zǝbɛgɔninɛáamɛrika'                  => 'vi',
    'zǝigan'                                   => 'ky',
    'zǝiglás'                                 => 'is',
    'zǝimarcál'                               => 'mh',
    'zǝingɛrísncɔ́mwaindi'                 => 'io',
    'zǝmaalwín'                               => 'fk',
    'zǝmaryánnɔ́r'                          => 'mp',
    'zǝpalɛstínǝ'                           => 'ps',
    'zǝsalomɔ́n'                             => 'sb',
    'zǝtirkrikakɔs'                           => 'tc',
    'zɛikúk'                                  => 'ck',
    'zɛlananyɔ́n'                            => 'nz',
    'zɛnɔ́fɔlk'                             => 'nf',
    "\Ã\landislands"                         => 'ax',
    'ɔnduras'                                  => 'hn',
    'ɔngrí'                                   => 'hu',
    'ɔstralí'                                 => 'au',
    'ɛjípt'                                   => 'eg',
    'ɛkwatɛǝ́'                              => 'ec',
    'ɛritrɛ́'                                => 'er',
    'ɛstoní'                                  => 'ee',
    'ɛtyɔpí'                                 => 'et',
);

1;

