/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;

public class FingerprintedQName
extends StructuredQName
implements NodeName {
    private int nameCode = -1;

    public FingerprintedQName(String prefix, String uri, String localName) {
        super(prefix, uri, localName);
    }

    public FingerprintedQName(String prefix, String uri, String localName, int nameCode) {
        super(prefix, uri, localName);
        this.nameCode = nameCode;
    }

    public static FingerprintedQName fromClarkName(String expandedName) {
        String localName;
        String namespace;
        if (expandedName.charAt(0) == '{') {
            int closeBrace = expandedName.indexOf(125);
            if (closeBrace < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            namespace = expandedName.substring(1, closeBrace);
            if (closeBrace == expandedName.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            localName = expandedName.substring(closeBrace + 1);
        } else {
            namespace = "";
            localName = expandedName;
        }
        return new FingerprintedQName("", namespace, localName);
    }

    public boolean hasFingerprint() {
        return this.nameCode != -1;
    }

    public int getFingerprint() {
        return this.nameCode == -1 ? -1 : this.nameCode & 0xFFFFF;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
    }

    public int allocateNameCode(NamePool pool) {
        if (this.nameCode == -1) {
            this.nameCode = pool.allocate(this.getPrefix(), this.getURI(), this.getLocalPart());
        }
        return this.nameCode;
    }

    public boolean equals(Object other) {
        if (other instanceof NodeName) {
            if (this.nameCode != -1 && ((NodeName)other).hasFingerprint()) {
                return this.getFingerprint() == ((NodeName)other).getFingerprint();
            }
            return this.getLocalPart().equals(((NodeName)other).getLocalPart()) && this.isInSameNamespace((NodeName)other);
        }
        return false;
    }
}

