use strict;
use warnings;
use Test::More 0.88;
# This is a relatively nice way to avoid Test::NoWarnings breaking our
# expectations by adding extra tests, without using no_plan.  It also helps
# avoid any other test module that feels introducing random tests, or even
# test plans, is a nice idea.
our $success = 0;
END { $success && done_testing; }

# List our own version used to generate this
my $v = "\nGenerated by Dist::Zilla::Plugin::ReportVersions::Tiny v1.10\n";

eval {                     # no excuses!
    # report our Perl details
    my $want = '5.006';
    $v .= "perl: $] (wanted $want) on $^O from $^X\n\n";
};
defined($@) and diag("$@");

# Now, our module version dependencies:
sub pmver {
    my ($module, $wanted) = @_;
    $wanted = " (want $wanted)";
    my $pmver;
    eval "require $module;";
    if ($@) {
        if ($@ =~ m/Can't locate .* in \@INC/) {
            $pmver = 'module not found.';
        } else {
            diag("${module}: $@");
            $pmver = 'died during require.';
        }
    } else {
        my $version;
        eval { $version = $module->VERSION; };
        if ($@) {
            diag("${module}: $@");
            $pmver = 'died during VERSION check.';
        } elsif (defined $version) {
            $pmver = "$version";
        } else {
            $pmver = '<undef>';
        }
    }

    # So, we should be good, right?
    return sprintf('%-45s => %-10s%-15s%s', $module, $pmver, $wanted, "\n");
}

eval { $v .= pmver('Dist::Zilla::Plugin::ApocalypseTests','0.01') };
eval { $v .= pmver('Dist::Zilla::Plugin::ArchiveRelease','3.01') };
eval { $v .= pmver('Dist::Zilla::Plugin::Authority','1.001') };
eval { $v .= pmver('Dist::Zilla::Plugin::Bugtracker','1.102670') };
eval { $v .= pmver('Dist::Zilla::Plugin::ChangelogFromGit','0.002') };
eval { $v .= pmver('Dist::Zilla::Plugin::CheckChangesHasContent','0.003') };
eval { $v .= pmver('Dist::Zilla::Plugin::CheckIssues','0.002') };
eval { $v .= pmver('Dist::Zilla::Plugin::CheckPrereqsIndexed','0.007') };
eval { $v .= pmver('Dist::Zilla::Plugin::CheckSelfDependency','0.007') };
eval { $v .= pmver('Dist::Zilla::Plugin::Clean','0.002') };
eval { $v .= pmver('Dist::Zilla::Plugin::Covenant','v0.1.0') };
eval { $v .= pmver('Dist::Zilla::Plugin::DOAP','0.002') };
eval { $v .= pmver('Dist::Zilla::Plugin::Git','1.110500') };
eval { $v .= pmver('Dist::Zilla::Plugin::Git::CheckFor::CorrectBranch','0.011') };
eval { $v .= pmver('Dist::Zilla::Plugin::Git::Contributors','0.008') };
eval { $v .= pmver('Dist::Zilla::Plugin::Git::Describe','0.003') };
eval { $v .= pmver('Dist::Zilla::Plugin::Git::Remote::Check','v0.1.2') };
eval { $v .= pmver('Dist::Zilla::Plugin::Homepage','1.101420') };
eval { $v .= pmver('Dist::Zilla::Plugin::InstallGuide','1.101461') };
eval { $v .= pmver('Dist::Zilla::Plugin::LocaleMsgfmt','1.203') };
eval { $v .= pmver('Dist::Zilla::Plugin::MakeMaker::Fallback','0.013') };
eval { $v .= pmver('Dist::Zilla::Plugin::MetaData::BuiltWith','0.01018204') };
eval { $v .= pmver('Dist::Zilla::Plugin::MetaProvides::Package','1.12044908') };
eval { $v .= pmver('Dist::Zilla::Plugin::MinimumPerl','1.001') };
eval { $v .= pmver('Dist::Zilla::Plugin::ModuleBuildTiny','0.007') };
eval { $v .= pmver('Dist::Zilla::Plugin::PodWeaver','3.101641') };
eval { $v .= pmver('Dist::Zilla::Plugin::Prepender','1.101590') };
eval { $v .= pmver('Dist::Zilla::Plugin::PromptIfStale','0.028') };
eval { $v .= pmver('Dist::Zilla::Plugin::ReadmeAnyFromPod','0.142470') };
eval { $v .= pmver('Dist::Zilla::Plugin::ReportPhase','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::ReportVersions::Tiny','1.02') };
eval { $v .= pmver('Dist::Zilla::Plugin::Repository','0.16') };
eval { $v .= pmver('Dist::Zilla::Plugin::SchwartzRatio','v0.2.0') };
eval { $v .= pmver('Dist::Zilla::Plugin::Signature','1.100930') };
eval { $v .= pmver('Dist::Zilla::Plugin::Test::Compile','1.112820') };
eval { $v .= pmver('Dist::Zilla::Role::PluginBundle::Config::Slicer','any version') };
eval { $v .= pmver('Dist::Zilla::Role::PluginBundle::Easy','5.011') };
eval { $v .= pmver('Dist::Zilla::Role::PluginBundle::PluginRemover','any version') };
eval { $v .= pmver('ExtUtils::MakeMaker','any version') };
eval { $v .= pmver('File::Spec','any version') };
eval { $v .= pmver('File::Temp','any version') };
eval { $v .= pmver('IO::Handle','any version') };
eval { $v .= pmver('IPC::Open3','any version') };
eval { $v .= pmver('Module::Build::Tiny','0.039') };
eval { $v .= pmver('Moose','1.21') };
eval { $v .= pmver('Pod::Weaver::PluginBundle::Apocalyptic','0.002') };
eval { $v .= pmver('Test::More','0.88') };
eval { $v .= pmver('strict','any version') };
eval { $v .= pmver('warnings','any version') };


# All done.
$v .= <<'EOT';

Thanks for using my code.  I hope it works for you.
If not, please try and include this output in the bug report.
That will help me reproduce the issue and solve your problem.

EOT

diag($v);
ok(1, "we really didn't test anything, just reporting data");
$success = 1;

# Work around another nasty module on CPAN. :/
no warnings 'once';
$Template::Test::NO_FLUSH = 1;
exit 0;
